/* Copyright (C) 2000-2004 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2 of the License.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

/* close a isam-database */
/*
  TODO:
   We need to have a separate mutex on the closed file to allow other threads
   to open other files during the time we flush the cache and close this file
*/

#include "myisamdef.h"

int mi_close(register MI_INFO *info)
{
  int error=0,flag;
  MYISAM_SHARE *share=info->s;
  DBUG_ENTER("mi_close");
  DBUG_PRINT("enter",("base: %p  reopen: %u  locks: %u",
		      info, (uint) share->reopen,
                      (uint) share->tot_locks));
  DBUG_PRINT("myisam", ("close '%s'", share->unresolv_file_name));

  pthread_mutex_lock(&THR_LOCK_myisam);
  if (info->lock_type == F_EXTRA_LCK)
    info->lock_type=F_UNLCK;			/* HA_EXTRA_NO_USER_CHANGE */

  if (share->reopen == 1 && share->kfile >= 0)
    _mi_decrement_open_count(info);

  if (info->lock_type != F_UNLCK)
  {
    if (mi_lock_database(info,F_UNLCK))
      error=my_errno;
  }
  pthread_mutex_lock(&share->intern_lock);

  if (share->options & HA_OPTION_READ_ONLY_DATA)
  {
    share->r_locks--;
    share->tot_locks--;
  }
  if (info->opt_flag & (READ_CACHE_USED | WRITE_CACHE_USED))
  {
    /* Logically there should not be a WRITE_CACHE at this stage */
    DBUG_ASSERT(!(info->opt_flag & WRITE_CACHE_USED));
    if (end_io_cache(&info->rec_cache))
      error=my_errno;
    info->opt_flag&= ~(READ_CACHE_USED | WRITE_CACHE_USED);
  }
  flag= !--share->reopen;
  myisam_open_list=list_delete(myisam_open_list,&info->open_list);
  pthread_mutex_unlock(&share->intern_lock);

  my_free(mi_get_rec_buff_ptr(info, info->rec_buff), MYF(MY_ALLOW_ZERO_PTR));
  if (flag)
  {
    DBUG_PRINT("myisam", ("close share '%s'", share->unresolv_file_name));
    if (share->kfile >= 0 &&
	flush_key_blocks(share->key_cache, share->kfile,
			 share->temporary ? FLUSH_IGNORE_CHANGED :
			 FLUSH_RELEASE))
    {
      error=my_errno;
      mi_print_error(share, HA_ERR_CRASHED);
      mi_mark_crashed(info);		/* Mark that table must be checked */
    }
    if (share->kfile >= 0)
    {
      /*
        If we are crashed, we can safely flush the current state as it will
        not change the crashed state.
        We can NOT write the state in other cases as other threads
        may be using the file at this point
        IF using --external-locking.
      */
      if (share->mode != O_RDONLY && mi_is_crashed(info))
        mi_state_info_write(share, share->kfile, &share->state, 1);
      if (share->MI_LOG_OPEN_stored_in_physical_log)
        _myisam_log_command(&myisam_physical_log, MI_LOG_CLOSE, share,
                            NULL, 0, error);
      if (my_close(share->kfile,MYF(0)))
        error = my_errno;
    }
#ifdef HAVE_MMAP
    if (share->file_map)
      _mi_unmap_file(info);
#endif
    if (share->decode_trees)
    {
      my_free((uchar*) share->decode_trees,MYF(0));
      my_free((uchar*) share->decode_tables,MYF(0));
    }
#ifdef THREAD
    thr_lock_delete(&share->lock);
    pthread_mutex_destroy(&share->intern_lock);
    my_atomic_rwlock_destroy(&share->physical_logging_rwlock);
    {
      int i,keys;
      keys = share->state.header.keys;
      (void) rwlock_destroy(&share->mmap_lock);
      for(i=0; i<keys; i++) {
	(void) rwlock_destroy(&share->key_root_lock[i]);
      }
    }
#endif
    /*
      Do not free the share here. myisam_log_command_logical() needs
      to test for share->temporary.
    */
  }
  pthread_mutex_unlock(&THR_LOCK_myisam);
  if (info->ftparser_param)
  {
    my_free((uchar*)info->ftparser_param, MYF(0));
    info->ftparser_param= 0;
  }
  if (info->dfile >= 0 && my_close(info->dfile,MYF(0)))
    error = my_errno;

  myisam_log_command_logical(MI_LOG_CLOSE, info, NULL, 0, error);

  if (flag)
    my_free((uchar*) info->s,MYF(0));
  my_free((uchar*) info,MYF(0));

  if (error)
  {
    DBUG_RETURN(my_errno=error);
  }
  DBUG_RETURN(0);
} /* mi_close */
