/* Copyright (c) 2004, 2021, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */
/*
  Do not edit this file, it is automatically generated from:
  </export/home/pb2/build/sb_0-4618784-1632838993.9/rpm/BUILD/mysql-8.0.27/release/scripts/sys_schema/ALL_SYS_SCHEMA.sql>
*/
const char* mysql_sys_schema[]={
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "SET NAMES utf8mb4;\n",
"SET @sql_log_bin = @@sql_log_bin;\n",
"SET sql_log_bin = 0;\n",
"CREATE DATABASE IF NOT EXISTS sys DEFAULT CHARACTER SET utf8mb4;\n",
"ALTER DATABASE sys CHARACTER SET utf8mb4;\n",
"USE sys;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "INSERT IGNORE INTO mysql.user VALUES\n"
  "('localhost','mysql.sys','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N',"
  "'N','N','N','N','N','N','','','','',0,0,0,0,'caching_sha2_password','\\$A\\$005\\$THISISACOMBINATIONOFINVALIDSALTANDPASS"
  "WORDTHATMUSTNEVERBRBEUSED','N',CURRENT_TIMESTAMP,NULL,'Y','N','N',NULL,NULL,NULL,NULL);\n",
"INSERT IGNORE INTO mysql.db VALUES\n"
  "('localhost','sys','mysql.sys','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','N','Y');\n",
"INSERT IGNORE INTO mysql.tables_priv VALUES\n"
  "('localhost','sys','mysql.sys','sys_config','root@localhost',\n"
  "CURRENT_TIMESTAMP, 'Select', '');\n",
"-- GRANT SYSTEM_USER ON *.* TO 'mysql.sys'@localhost\n"
  "INSERT IGNORE INTO mysql.global_grants (USER,HOST,PRIV,WITH_GRANT_OPTION)\n"
  "VALUES ('mysql.sys','localhost','SYSTEM_USER','N');\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: version\n"
  "--\n"
  "-- Shows the sys schema and mysql versions\n"
  "--\n"
  "-- NOTE: This view is deprecated and will be removed in a future release.\n"
  "--\n"
  "-- mysql> select * from sys.version;\n"
  "-- +-------------+---------------+\n"
  "-- | sys_version | mysql_version |\n"
  "-- +-------------+---------------+\n"
  "-- | 2.1.1       | 8.0.18        |\n"
  "-- +-------------+---------------+\n"
  "-- \n"
  "CREATE OR REPLACE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW version (\n"
  "  sys_version,\n"
  "  mysql_version\n"
  ") AS \n"
  "SELECT '2.1.1' AS sys_version,\n"
  "        version() AS mysql_version;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- Table: sys_config\n"
  "--\n"
  "-- Stores configuration options for sys objects\n"
  "--\n"
  "CREATE TABLE IF NOT EXISTS sys_config (\n"
  "    variable VARCHAR(128) PRIMARY KEY,\n"
  "    value VARCHAR(128),\n"
  "    set_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,\n"
  "    set_by VARCHAR(128)\n"
  ") ENGINE = InnoDB;\n",
"-- Copyright (c) 2018, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- Alters the sys_config table for upgrades\n"
  "--\n"
  "ALTER TABLE sys_config CHARACTER SET utf8mb4;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "-- NOTE: This needs to be replicated within the sys_config_clean.inc file\n"
  "INSERT IGNORE INTO sys.sys_config (variable, value) VALUES\n"
  "    ('statement_truncate_len', 64),\n"
  "    ('statement_performance_analyzer.limit', 100),\n"
  "    ('statement_performance_analyzer.view', NULL),\n"
  "    ('diagnostics.allow_i_s_tables', 'OFF'),\n"
  "    ('diagnostics.include_raw', 'OFF'),\n"
  "    ('ps_thread_trx_info.max_length', 65535);\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- Trigger: sys_config_insert_set_user\n"
  "--\n"
  "-- Sets the user that inserts configuration\n"
  "--\n"
  "--\n"
  "DROP TRIGGER IF EXISTS sys_config_insert_set_user;\n",
"CREATE DEFINER='mysql.sys'@'localhost' TRIGGER sys_config_insert_set_user BEFORE INSERT on sys_config\n"
  "    FOR EACH ROW\n"
  "BEGIN\n"
  "    IF @sys.ignore_sys_config_triggers != true AND NEW.set_by IS NULL THEN\n"
  "        SET NEW.set_by = USER();\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- Trigger: sys_config_update_set_user\n"
  "--\n"
  "-- Sets the user that updates configuration\n"
  "--\n"
  "--\n"
  "DROP TRIGGER IF EXISTS sys_config_update_set_user;\n",
"CREATE DEFINER='mysql.sys'@'localhost' TRIGGER sys_config_update_set_user BEFORE UPDATE on sys_config\n"
  "    FOR EACH ROW\n"
  "BEGIN\n"
  "    IF @sys.ignore_sys_config_triggers != true AND NEW.set_by IS NULL THEN\n"
  "        SET NEW.set_by = USER();\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS extract_schema_from_file_name;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION extract_schema_from_file_name (\n"
  "        path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(64) \n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a raw file path, and attempts to extract the schema name from it.\n"
  "\n"
  "Useful for when interacting with Performance Schema data \n"
  "concerning IO statistics, for example.\n"
  "\n"
  "Currently relies on the fact that a table data file will be within a \n"
  "specified database directory (will not work with partitions or tables\n"
  "that specify an individual DATA_DIRECTORY).\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "path (VARCHAR(512)):\n"
  "  The full file path to a data file to extract the schema name from.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "VARCHAR(64)\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.extract_schema_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\');\n"
  "+----------------------------------------------------------------------------+\n"
  "| sys.extract_schema_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\') |\n"
  "+----------------------------------------------------------------------------+\n"
  "| employees                                                                  |\n"
  "+----------------------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN LEFT(SUBSTRING_INDEX(SUBSTRING_INDEX(REPLACE(path, '\\\\', '/'), '/', -2), '/', 1), 64);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS extract_table_from_file_name;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION extract_table_from_file_name (\n"
  "        path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(64) \n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a raw file path, and extracts the table name from it.\n"
  "\n"
  "Useful for when interacting with Performance Schema data \n"
  "concerning IO statistics, for example.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "path (VARCHAR(512)):\n"
  "  The full file path to a data file to extract the table name from.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "VARCHAR(64)\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.extract_table_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\');\n"
  "+---------------------------------------------------------------------------+\n"
  "| sys.extract_table_from_file_name(\\'/var/lib/mysql/employees/employee.ibd\\') |\n"
  "+---------------------------------------------------------------------------+\n"
  "| employee                                                                  |\n"
  "+---------------------------------------------------------------------------+\n"
  "1 row in set (0.02 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN LEFT(SUBSTRING_INDEX(REPLACE(SUBSTRING_INDEX(REPLACE(path, '\\\\', '/'), '/', -1), '@0024', '$'), '.', 1), 6"
  "4);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS sys.format_bytes;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION sys.format_bytes (\n"
  "        -- We feed in and return TEXT here, as aggregates of\n"
  "        -- bytes can return numbers larger than BIGINT UNSIGNED\n"
  "        bytes TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a raw bytes value, and converts it to a human readable format.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "bytes (TEXT):\n"
  "  A raw bytes value.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TEXT\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.format_bytes(2348723492723746) AS size;\n"
  "+----------+\n"
  "| size     |\n"
  "+----------+\n"
  "| 2.09 PiB |\n"
  "+----------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> SELECT sys.format_bytes(2348723492723) AS size;\n"
  "+----------+\n"
  "| size     |\n"
  "+----------+\n"
  "| 2.14 TiB |\n"
  "+----------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> SELECT sys.format_bytes(23487234) AS size;\n"
  "+-----------+\n"
  "| size      |\n"
  "+-----------+\n"
  "| 22.40 MiB |\n"
  "+-----------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  IF (bytes IS NULL) THEN\n"
  "    RETURN NULL;\n"
  "  ELSE\n"
  "    RETURN format_bytes(bytes);\n"
  "  END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS format_path;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION format_path (\n"
  "        in_path VARCHAR(512)\n"
  "    )\n"
  "    RETURNS VARCHAR(512) CHARSET UTF8MB4\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a raw path value, and strips out the datadir or tmpdir\n"
  "replacing with @@datadir and @@tmpdir respectively.\n"
  "\n"
  "Also normalizes the paths across operating systems, so backslashes\n"
  "on Windows are converted to forward slashes\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "path (VARCHAR(512)):\n"
  "  The raw file path value to format.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "VARCHAR(512) CHARSET UTF8MB4\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> select @@datadir;\n"
  "+-----------------------------------------------+\n"
  "| @@datadir                                     |\n"
  "+-----------------------------------------------+\n"
  "| /Users/mark/sandboxes/SmallTree/AMaster/data/ |\n"
  "+-----------------------------------------------+\n"
  "1 row in set (0.06 sec)\n"
  "\n"
  "mysql> select format_path(\\'/Users/mark/sandboxes/SmallTree/AMaster/data/mysql/proc.MYD\\') AS path;\n"
  "+--------------------------+\n"
  "| path                     |\n"
  "+--------------------------+\n"
  "| @@datadir/mysql/proc.MYD |\n"
  "+--------------------------+\n"
  "1 row in set (0.03 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  DECLARE v_path VARCHAR(512);\n"
  "  DECLARE v_undo_dir VARCHAR(1024);\n"
  "  DECLARE path_separator CHAR(1) DEFAULT '/';\n"
  "  IF @@global.version_compile_os LIKE 'win%' THEN\n"
  "    SET path_separator = '\\\\';\n"
  "  END IF;\n"
  "  -- OSX hides /private/ in variables, but Performance Schema does not\n"
  "  IF in_path LIKE '/private/%' THEN\n"
  "    SET v_path = REPLACE(in_path, '/private', '');\n"
  "  ELSE\n"
  "    SET v_path = in_path;\n"
  "  END IF;\n"
  "  -- @@global.innodb_undo_directory is only set when separate undo logs are used\n"
  "  SET v_undo_dir = IFNULL((SELECT VARIABLE_VALUE FROM performance_schema.global_variables WHERE VARIABLE_NAME = 'inno"
  "db_undo_directory'), '');\n"
  "  IF v_path IS NULL THEN\n"
  "    RETURN NULL;\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.datadir, IF(SUBSTRING(@@global.datadir, -1) = path_separator, '%', CONCAT(path_s"
  "eparator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.datadir, CONCAT('@@datadir', IF(SUBSTRING(@@global.datadir, -1) = path_sepa"
  "rator, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.tmpdir, IF(SUBSTRING(@@global.tmpdir, -1) = path_separator, '%', CONCAT(path_sep"
  "arator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.tmpdir, CONCAT('@@tmpdir', IF(SUBSTRING(@@global.tmpdir, -1) = path_separat"
  "or, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.replica_load_tmpdir, IF(SUBSTRING(@@global.replica_load_tmpdir, -1) = path_separ"
  "ator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.replica_load_tmpdir, CONCAT('@@replica_load_tmpdir', IF(SUBSTRING(@@global."
  "replica_load_tmpdir, -1) = path_separator, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.innodb_data_home_dir, IF(SUBSTRING(@@global.innodb_data_home_dir, -1) = path_sep"
  "arator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.innodb_data_home_dir, CONCAT('@@innodb_data_home_dir', IF(SUBSTRING(@@globa"
  "l.innodb_data_home_dir, -1) = path_separator, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.innodb_log_group_home_dir, IF(SUBSTRING(@@global.innodb_log_group_home_dir, -1) "
  "= path_separator, '%', CONCAT(path_separator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.innodb_log_group_home_dir, CONCAT('@@innodb_log_group_home_dir', IF(SUBSTRI"
  "NG(@@global.innodb_log_group_home_dir, -1) = path_separator, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(v_undo_dir, IF(SUBSTRING(v_undo_dir, -1) = path_separator, '%', CONCAT(path_separator, '%"
  "'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, v_undo_dir, CONCAT('@@innodb_undo_directory', IF(SUBSTRING(v_undo_dir, -1) = path_se"
  "parator, path_separator, '')));\n"
  "  ELSEIF v_path LIKE CONCAT(@@global.basedir, IF(SUBSTRING(@@global.basedir, -1) = path_separator, '%', CONCAT(path_s"
  "eparator, '%'))) ESCAPE '|' THEN\n"
  "    SET v_path = REPLACE(v_path, @@global.basedir, CONCAT('@@basedir', IF(SUBSTRING(@@global.basedir, -1) = path_sepa"
  "rator, path_separator, '')));\n"
  "  END IF;\n"
  "  RETURN v_path;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS format_statement;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION format_statement (\n"
  "        statement LONGTEXT\n"
  "    )\n"
  "    RETURNS LONGTEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Formats a normalized statement, truncating it if it is > 64 characters long by default.\n"
  "\n"
  "To configure the length to truncate the statement to by default, update the `statement_truncate_len`\n"
  "variable with `sys_config` table to a different value. Alternatively, to change it just for just \n"
  "your particular session, use `SET @sys.statement_truncate_len := <some new value>`.\n"
  "\n"
  "Useful for printing statement related data from Performance Schema from \n"
  "the command line.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "statement (LONGTEXT): \n"
  "  The statement to format.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "LONGTEXT\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.format_statement(digest_text)\n"
  "    ->   FROM performance_schema.events_statements_summary_by_digest\n"
  "    ->  ORDER by sum_timer_wait DESC limit 5;\n"
  "+-------------------------------------------------------------------+\n"
  "| sys.format_statement(digest_text)                                 |\n"
  "+-------------------------------------------------------------------+\n"
  "| CREATE SQL SECURITY INVOKER VI ... KE ? AND `variable_value` > ?  |\n"
  "| CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `esc` . ... |\n"
  "| CREATE SQL SECURITY INVOKER VI ... ait` IS NOT NULL , `sys` . ... |\n"
  "| CREATE SQL SECURITY INVOKER VI ...  , `compressed_size` ) ) DESC  |\n"
  "| CREATE SQL SECURITY INVOKER VI ... LIKE ? ORDER BY `timer_start`  |\n"
  "+-------------------------------------------------------------------+\n"
  "5 rows in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  -- Check if we have the configured length, if not, init it\n"
  "  IF @sys.statement_truncate_len IS NULL THEN\n"
  "      SET @sys.statement_truncate_len = sys_get_config('statement_truncate_len', 64);\n"
  "  END IF;\n"
  "  IF CHAR_LENGTH(statement) > @sys.statement_truncate_len THEN\n"
  "      RETURN REPLACE(CONCAT(LEFT(statement, (@sys.statement_truncate_len/2)-2), ' ... ', RIGHT(statement, (@sys.state"
  "ment_truncate_len/2)-2)), '\\n', ' ');\n"
  "  ELSE \n"
  "      RETURN REPLACE(statement, '\\n', ' ');\n"
  "  END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS sys.format_time;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION sys.format_time (\n"
  "-- We feed in and return TEXT here, as aggregates of\n"
  "-- picoseconds can return numbers larger than BIGINT UNSIGNED\n"
  "        picoseconds TEXT\n"
  "    )\n"
  "    RETURNS TEXT CHARSET UTF8MB4\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a raw picoseconds value, and converts it to a human readable form.\n"
  "\n"
  "Picoseconds are the precision that all latency values are printed in\n"
  "within Performance Schema, however are not user friendly when wanting\n"
  "to scan output from the command line.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "picoseconds (TEXT):\n"
  "  The raw picoseconds value to convert.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TEXT CHARSET UTF8MB4\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> select format_time(342342342342345);\n"
  "+------------------------------+\n"
  "| format_time(342342342342345) |\n"
  "+------------------------------+\n"
  "| 00:05:42                     |\n"
  "+------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> select format_time(342342342);\n"
  "+------------------------+\n"
  "| format_time(342342342) |\n"
  "+------------------------+\n"
  "| 342.34 us              |\n"
  "+------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> select format_time(34234);\n"
  "+--------------------+\n"
  "| format_time(34234) |\n"
  "+--------------------+\n"
  "| 34.23 ns           |\n"
  "+--------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "  IF picoseconds IS NULL THEN RETURN NULL;\n"
  "  ELSEIF picoseconds >= 604800000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 604800000000000000, 2), ' w');\n"
  "  ELSEIF picoseconds >= 86400000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 86400000000000000, 2), ' d');\n"
  "  ELSEIF picoseconds >= 3600000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 3600000000000000, 2), ' h');\n"
  "  ELSEIF picoseconds >= 60000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 60000000000000, 2), ' m');\n"
  "  ELSEIF picoseconds >= 1000000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000000, 2), ' s');\n"
  "  ELSEIF picoseconds >= 1000000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000000, 2), ' ms');\n"
  "  ELSEIF picoseconds >= 1000000 THEN RETURN CONCAT(ROUND(picoseconds / 1000000, 2), ' us');\n"
  "  ELSEIF picoseconds >= 1000 THEN RETURN CONCAT(ROUND(picoseconds / 1000, 2), ' ns');\n"
  "  ELSE RETURN CONCAT(picoseconds, ' ps');\n"
  "  END IF;\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS list_add;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION list_add (\n"
  "        in_list TEXT,\n"
  "        in_add_value TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a list, and a value to add to the list, and returns the resulting list.\n"
  "\n"
  "Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_list (TEXT):\n"
  "  The comma separated list to add a value to\n"
  "\n"
  "in_add_value (TEXT):\n"
  "  The value to add to the input list\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TEXT\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "mysql> select @@sql_mode;\n"
  "+-----------------------------------------------------------------------------------+\n"
  "| @@sql_mode                                                                        |\n"
  "+-----------------------------------------------------------------------------------+\n"
  "| ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "+-----------------------------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> set sql_mode = sys.list_add(@@sql_mode, ''ANSI_QUOTES'');\n"
  "Query OK, 0 rows affected (0.06 sec)\n"
  "\n"
  "mysql> select @@sql_mode;\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "| @@sql_mode                                                                                    |\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "| ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    IF (in_add_value IS NULL) THEN\n"
  "        SIGNAL SQLSTATE '02200'\n"
  "           SET MESSAGE_TEXT = 'Function sys.list_add: in_add_value input variable should not be NULL',\n"
  "               MYSQL_ERRNO = 1138;\n"
  "    END IF;\n"
  "    IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN\n"
  "        -- return the new value as a single value list\n"
  "        RETURN in_add_value;\n"
  "    END IF;\n"
  "    RETURN (SELECT CONCAT(TRIM(BOTH ',' FROM TRIM(in_list)), ',', in_add_value));\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS list_drop;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION list_drop (\n"
  "        in_list TEXT,\n"
  "        in_drop_value TEXT\n"
  "    )\n"
  "    RETURNS TEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a list, and a value to attempt to remove from the list, and returns the resulting list.\n"
  "\n"
  "Useful for altering certain session variables, like sql_mode or optimizer_switch for instance.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_list (TEXT):\n"
  "  The comma separated list to drop a value from\n"
  "\n"
  "in_drop_value (TEXT):\n"
  "  The value to drop from the input list\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TEXT\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "mysql> select @@sql_mode;\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "| @@sql_mode                                                                                    |\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "| ANSI_QUOTES,ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "+-----------------------------------------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> set sql_mode = sys.list_drop(@@sql_mode, ''ONLY_FULL_GROUP_BY'');\n"
  "Query OK, 0 rows affected (0.03 sec)\n"
  "\n"
  "mysql> select @@sql_mode;\n"
  "+----------------------------------------------------------------------------+\n"
  "| @@sql_mode                                                                 |\n"
  "+----------------------------------------------------------------------------+\n"
  "| ANSI_QUOTES,STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n"
  "+----------------------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    IF (in_drop_value IS NULL) THEN\n"
  "        SIGNAL SQLSTATE '02200'\n"
  "           SET MESSAGE_TEXT = 'Function sys.list_drop: in_drop_value input variable should not be NULL',\n"
  "               MYSQL_ERRNO = 1138;\n"
  "    END IF;\n"
  "    IF (in_list IS NULL OR LENGTH(in_list) = 0) THEN\n"
  "        -- return the list as it was passed in\n"
  "        RETURN in_list;\n"
  "    END IF;\n"
  "    -- ensure that leading / trailing commas are remove, support values with either spaces or not between commas\n"
  "    RETURN (SELECT TRIM(BOTH ',' FROM REPLACE(REPLACE(CONCAT(',', in_list), CONCAT(',', in_drop_value), ''), CONCAT('"
  ", ', in_drop_value), '')));\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_is_account_enabled;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_is_account_enabled (\n"
  "        in_host VARCHAR(255), \n"
  "        in_user VARCHAR(32)\n"
  "    ) \n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Determines whether instrumentation of an account is enabled \n"
  "within Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_host VARCHAR(255): \n"
  "  The hostname of the account to check.\n"
  "in_user VARCHAR(32):\n"
  "  The username of the account to check.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "ENUM(\\'YES\\', \\'NO\\', \\'PARTIAL\\')\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_is_account_enabled(\\'localhost\\', \\'root\\');\n"
  "+------------------------------------------------+\n"
  "| sys.ps_is_account_enabled(\\'localhost\\', \\'root\\') |\n"
  "+------------------------------------------------+\n"
  "| YES                                            |\n"
  "+------------------------------------------------+\n"
  "1 row in set (0.01 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC \n"
  "    READS SQL DATA \n"
  "BEGIN\n"
  "    RETURN IF(EXISTS(SELECT 1\n"
  "                       FROM performance_schema.setup_actors\n"
  "                      WHERE (`HOST` = '%' OR in_host LIKE `HOST`)\n"
  "                        AND (`USER` = '%' OR `USER` = in_user)\n"
  "                        AND (`ENABLED` = 'YES')\n"
  "                    ),\n"
  "              'YES', 'NO'\n"
  "           );\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_is_consumer_enabled;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_is_consumer_enabled (\n"
  "        in_consumer varchar(64)\n"
  "   )\n"
  "   RETURNS enum('YES', 'NO')\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Determines whether a consumer is enabled (taking the consumer hierarchy into consideration)\n"
  "within the Performance Schema.\n"
  "\n"
  "An exception with errno 3047 is thrown if an unknown consumer name is passed to the function.\n"
  "A consumer name of NULL returns NULL.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_consumer VARCHAR(64): \n"
  "  The name of the consumer to check.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "ENUM(\\'YES\\', \\'NO\\')\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_is_consumer_enabled(\\'events_stages_history\\');\n"
  "+-----------------------------------------------------+\n"
  "| sys.ps_is_consumer_enabled(\\'events_stages_history\\') |\n"
  "+-----------------------------------------------------+\n"
  "| NO                                                  |\n"
  "+-----------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC \n"
  "    READS SQL DATA \n"
  "BEGIN\n"
  "    DECLARE v_is_enabled ENUM('YES', 'NO') DEFAULT NULL;\n"
  "    DECLARE v_error_msg VARCHAR(128);\n"
  "    -- Return NULL for a NULL argument.\n"
  "    IF (in_consumer IS NULL) THEN\n"
  "        RETURN NULL;\n"
  "    END IF;\n"
  "    SET v_is_enabled = (\n"
  "        SELECT (CASE\n"
  "                   WHEN c.NAME = 'global_instrumentation' THEN c.ENABLED\n"
  "                   WHEN c.NAME = 'thread_instrumentation' THEN IF(cg.ENABLED = 'YES' AND c.ENABLED = 'YES', 'YES', 'N"
  "O')\n"
  "                   WHEN c.NAME LIKE '%\\_digest'           THEN IF(cg.ENABLED = 'YES' AND c.ENABLED = 'YES', 'YES', 'N"
  "O')\n"
  "                   WHEN c.NAME LIKE '%\\_current'          THEN IF(cg.ENABLED = 'YES' AND ct.ENABLED = 'YES' AND c.ENA"
  "BLED = 'YES', 'YES', 'NO')\n"
  "                   ELSE IF(cg.ENABLED = 'YES' AND ct.ENABLED = 'YES' AND c.ENABLED = 'YES'\n"
  "                           AND ( SELECT cc.ENABLED FROM performance_schema.setup_consumers cc WHERE NAME = CONCAT(SUB"
  "STRING_INDEX(c.NAME, '_', 2), '_current')\n"
  "                               ) = 'YES', 'YES', 'NO')\n"
  "                END) AS IsEnabled\n"
  "          FROM performance_schema.setup_consumers c\n"
  "               INNER JOIN performance_schema.setup_consumers cg\n"
  "               INNER JOIN performance_schema.setup_consumers ct\n"
  "         WHERE cg.NAME       = 'global_instrumentation'\n"
  "               AND ct.NAME   = 'thread_instrumentation'\n"
  "               AND c.NAME    = in_consumer\n"
  "        );\n"
  "    IF (v_is_enabled IS NOT NULL) THEN\n"
  "        RETURN v_is_enabled;\n"
  "    ELSE\n"
  "        -- A value of NULL here means it is an unknown consumer name that was passed as an argument.\n"
  "        -- Only an input value of NULL is allowed to return a NULL result value, to throw a signal instead.\n"
  "        SET v_error_msg = CONCAT('Invalid argument error: ', in_consumer, ' in function sys.ps_is_consumer_enabled.')"
  ";\n"
  "        SIGNAL SQLSTATE 'HY000'\n"
  "           SET MESSAGE_TEXT = v_error_msg,\n"
  "               MYSQL_ERRNO  = 3047;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_is_instrument_default_enabled;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_is_instrument_default_enabled (\n"
  "        in_instrument VARCHAR(128)\n"
  "    ) \n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns whether an instrument is enabled by default in this version of MySQL.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_instrument VARCHAR(128): \n"
  "  The instrument to check.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "ENUM(\\'YES\\', \\'NO\\')\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_is_instrument_default_enabled(\\'statement/sql/select\\');\n"
  "+--------------------------------------------------------------+\n"
  "| sys.ps_is_instrument_default_enabled(\\'statement/sql/select\\') |\n"
  "+--------------------------------------------------------------+\n"
  "| YES                                                          |\n"
  "+--------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC \n"
  "    READS SQL DATA \n"
  "BEGIN\n"
  "    DECLARE v_enabled ENUM('YES', 'NO');\n"
  "    IF (in_instrument LIKE 'stage/%') THEN\n"
  "    BEGIN\n"
  "      /* Stages are enabled by default if the progress property is set. */\n"
  "      SET v_enabled = (SELECT\n"
  "                        IF(find_in_set(\"progress\", PROPERTIES) != 0, 'YES', 'NO')\n"
  "                        FROM performance_schema.setup_instruments\n"
  "                        WHERE NAME = in_instrument);\n"
  "      SET v_enabled = IFNULL(v_enabled, 'NO');\n"
  "    END;\n"
  "    ELSE\n"
  "      SET v_enabled = IF(in_instrument LIKE 'wait/synch/%'\n"
  "                         OR in_instrument LIKE 'wait/io/socket/%'\n"
  "                        ,\n"
  "                         'NO',\n"
  "                         'YES'\n"
  "                      );\n"
  "    END IF;\n"
  "    RETURN v_enabled;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_is_instrument_default_timed;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_is_instrument_default_timed (\n"
  "        in_instrument VARCHAR(128)\n"
  "    ) \n"
  "    RETURNS ENUM('YES', 'NO')\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns whether an instrument is timed by default in this version of MySQL.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_instrument VARCHAR(128): \n"
  "  The instrument to check.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "ENUM(\\'YES\\', \\'NO\\')\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_is_instrument_default_timed(\\'statement/sql/select\\');\n"
  "+------------------------------------------------------------+\n"
  "| sys.ps_is_instrument_default_timed(\\'statement/sql/select\\') |\n"
  "+------------------------------------------------------------+\n"
  "| YES                                                        |\n"
  "+------------------------------------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC \n"
  "    READS SQL DATA \n"
  "BEGIN\n"
  "    DECLARE v_timed ENUM('YES', 'NO');\n"
  "    IF (in_instrument LIKE 'stage/%') THEN\n"
  "    BEGIN\n"
  "      -- Stages are timed by default if the progress property is set.\n"
  "      SET v_timed = (SELECT\n"
  "                      IF(find_in_set(\"progress\", PROPERTIES) != 0, 'YES', 'NO')\n"
  "                      FROM performance_schema.setup_instruments\n"
  "                      WHERE NAME = in_instrument);\n"
  "      SET v_timed = IFNULL(v_timed, 'NO');\n"
  "    END;\n"
  "    ELSE\n"
  "      -- Mutex, rwlock, prlock, sxlock, cond are not timed by default\n"
  "      -- Memory instruments are never timed.\n"
  "      SET v_timed = IF(in_instrument LIKE 'wait/synch/%'\n"
  "                       OR in_instrument LIKE 'memory/%'\n"
  "                      ,\n"
  "                       'NO',\n"
  "                       'YES'\n"
  "                    );\n"
  "    END IF;\n"
  "    RETURN v_timed;\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_is_thread_instrumented;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_is_thread_instrumented (\n"
  "        in_connection_id BIGINT UNSIGNED\n"
  "    ) RETURNS ENUM('YES', 'NO', 'UNKNOWN')\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Checks whether the provided connection id is instrumented within Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_connection_id (BIGINT UNSIGNED):\n"
  "  The id of the connection to check.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "ENUM(\\'YES\\', \\'NO\\', \\'UNKNOWN\\')\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_is_thread_instrumented(CONNECTION_ID());\n"
  "+------------------------------------------------+\n"
  "| sys.ps_is_thread_instrumented(CONNECTION_ID()) |\n"
  "+------------------------------------------------+\n"
  "| YES                                            |\n"
  "+------------------------------------------------+\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_enabled ENUM('YES', 'NO', 'UNKNOWN');\n"
  "    IF (in_connection_id IS NULL) THEN\n"
  "        RETURN NULL;\n"
  "    END IF;\n"
  "    SELECT INSTRUMENTED INTO v_enabled\n"
  "      FROM performance_schema.threads \n"
  "     WHERE PROCESSLIST_ID = in_connection_id;\n"
  "    IF (v_enabled IS NULL) THEN\n"
  "        RETURN 'UNKNOWN';\n"
  "    ELSE\n"
  "        RETURN v_enabled;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS sys.ps_thread_id;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION sys.ps_thread_id (\n"
  "        in_connection_id BIGINT UNSIGNED\n"
  "    ) RETURNS BIGINT UNSIGNED\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Return the Performance Schema THREAD_ID for the specified connection ID.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_connection_id (BIGINT UNSIGNED):\n"
  "  The id of the connection to return the thread id for. If NULL, the current\n"
  "  connection thread id is returned.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.ps_thread_id(79);\n"
  "+----------------------+\n"
  "| sys.ps_thread_id(79) |\n"
  "+----------------------+\n"
  "|                   98 |\n"
  "+----------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> SELECT sys.ps_thread_id(CONNECTION_ID());\n"
  "+-----------------------------------+\n"
  "| sys.ps_thread_id(CONNECTION_ID()) |\n"
  "+-----------------------------------+\n"
  "|                                98 |\n"
  "+-----------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "  IF (in_connection_id IS NULL) THEN\n"
  "    RETURN ps_current_thread_id();\n"
  "  ELSE\n"
  "    RETURN ps_thread_id(in_connection_id);\n"
  "  END IF;\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_thread_account;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_thread_account (\n"
  "        in_thread_id BIGINT UNSIGNED\n"
  "    ) RETURNS TEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Return the user@host account for the given Performance Schema thread id.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_thread_id (BIGINT UNSIGNED):\n"
  "  The id of the thread to return the account for.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> select thread_id, processlist_user, processlist_host from performance_schema.threads where type = ''foreground"
  "'';\n"
  "+-----------+------------------+------------------+\n"
  "| thread_id | processlist_user | processlist_host |\n"
  "+-----------+------------------+------------------+\n"
  "|        23 | NULL             | NULL             |\n"
  "|        30 | root             | localhost        |\n"
  "|        31 | msandbox         | localhost        |\n"
  "|        32 | msandbox         | localhost        |\n"
  "+-----------+------------------+------------------+\n"
  "4 rows in set (0.00 sec)\n"
  "\n"
  "mysql> select sys.ps_thread_account(31);\n"
  "+---------------------------+\n"
  "| sys.ps_thread_account(31) |\n"
  "+---------------------------+\n"
  "| msandbox@localhost        |\n"
  "+---------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    RETURN (SELECT IF(\n"
  "                      type = 'FOREGROUND',\n"
  "                      CONCAT(processlist_user, '@', processlist_host),\n"
  "                      type\n"
  "                     ) AS account\n"
  "              FROM `performance_schema`.`threads`\n"
  "             WHERE thread_id = in_thread_id);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_thread_stack;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_thread_stack (\n"
  "        thd_id BIGINT UNSIGNED,\n"
  "        debug BOOLEAN\n"
  "    )\n"
  "RETURNS LONGTEXT CHARSET latin1\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Outputs a JSON formatted stack of all statements, stages and events\n"
  "within Performance Schema for the specified thread.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "thd_id (BIGINT UNSIGNED):\n"
  "  The id of the thread to trace. This should match the thread_id\n"
  "  column from the performance_schema.threads table.\n"
  "in_verbose (BOOLEAN):\n"
  "  Include file:lineno information in the events.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "(line separation added for output)\n"
  "\n"
  "mysql> SELECT sys.ps_thread_stack(37, FALSE) AS thread_stack\\\\G\n"
  "*************************** 1. row ***************************\n"
  "thread_stack: {\"rankdir\": \"LR\",\"nodesep\": \"0.10\",\"stack_created\": \"2014-02-19 13:39:03\",\n"
  "\"mysql_version\": \"5.7.3-m13\",\"mysql_user\": \"root@localhost\",\"events\": \n"
  "[{\"nesting_event_id\": \"0\", \"event_id\": \"10\", \"timer_wait\": 256.35, \"event_info\": \n"
  "\"sql/select\", \"wait_info\": \"select @@version_comment limit 1\\\\nerrors: 0\\\\nwarnings: 0\\\\nlock time:\n"
  "...\n"
  "'\n"
  "SQL SECURITY INVOKER\n"
  "NOT DETERMINISTIC\n"
  "READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE json_objects LONGTEXT;\n"
  "    -- Do not track the current thread, it will kill the stack\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE processlist_id = CONNECTION_ID();\n"
  "    SET SESSION group_concat_max_len=@@global.max_allowed_packet;\n"
  "    -- Select the entire stack of events\n"
  "    SELECT GROUP_CONCAT(CONCAT( '{'\n"
  "              , CONCAT_WS( ', '\n"
  "              , CONCAT('\"nesting_event_id\": \"', IF(nesting_event_id IS NULL, '0', nesting_event_id), '\"')\n"
  "              , CONCAT('\"event_id\": \"', event_id, '\"')\n"
  "              -- Convert from picoseconds to microseconds\n"
  "              , CONCAT( '\"timer_wait\": ', ROUND(timer_wait/1000000, 2))  \n"
  "              , CONCAT( '\"event_info\": \"'\n"
  "                  , CASE\n"
  "                        WHEN event_name NOT LIKE 'wait/io%' THEN REPLACE(SUBSTRING_INDEX(event_name, '/', -2), '\\\\', "
  "'\\\\\\\\')\n"
  "                        WHEN event_name NOT LIKE 'wait/io/file%' OR event_name NOT LIKE 'wait/io/socket%' THEN REPLAC"
  "E(SUBSTRING_INDEX(event_name, '/', -4), '\\\\', '\\\\\\\\')\n"
  "                        ELSE event_name\n"
  "                    END\n"
  "                  , '\"'\n"
  "              )\n"
  "              -- Always dump the extra wait information gathered for statements\n"
  "              , CONCAT( '\"wait_info\": \"', IFNULL(wait_info, ''), '\"')\n"
  "              -- If debug is enabled, add the file:lineno information for waits\n"
  "              , CONCAT( '\"source\": \"', IF(true AND event_name LIKE 'wait%', IFNULL(wait_info, ''), ''), '\"')\n"
  "              -- Depending on the type of event, name it appropriately\n"
  "              , CASE \n"
  "                     WHEN event_name LIKE 'wait/io/file%'      THEN '\"event_type\": \"io/file\"'\n"
  "                     WHEN event_name LIKE 'wait/io/table%'     THEN '\"event_type\": \"io/table\"'\n"
  "                     WHEN event_name LIKE 'wait/io/socket%'    THEN '\"event_type\": \"io/socket\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/mutex%'  THEN '\"event_type\": \"synch/mutex\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/cond%'   THEN '\"event_type\": \"synch/cond\"'\n"
  "                     WHEN event_name LIKE 'wait/synch/rwlock%' THEN '\"event_type\": \"synch/rwlock\"'\n"
  "                     WHEN event_name LIKE 'wait/lock%'         THEN '\"event_type\": \"lock\"'\n"
  "                     WHEN event_name LIKE 'statement/%'        THEN '\"event_type\": \"stmt\"'\n"
  "                     WHEN event_name LIKE 'stage/%'            THEN '\"event_type\": \"stage\"'\n"
  "                     WHEN event_name LIKE '%idle%'             THEN '\"event_type\": \"idle\"'\n"
  "                     ELSE '' \n"
  "                END                   \n"
  "            )\n"
  "            , '}'\n"
  "          )\n"
  "          ORDER BY event_id ASC SEPARATOR ',') event\n"
  "    INTO json_objects\n"
  "    FROM (\n"
  "          -- Select all statements, with the extra tracing information available\n"
  "          (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, \n"
  "                  CONCAT(sql_text, '\\\\n',\n"
  "                         'errors: ', errors, '\\\\n',\n"
  "                         'warnings: ', warnings, '\\\\n',\n"
  "                         'lock time: ', ROUND(lock_time/1000000, 2),'us\\\\n',\n"
  "                         'rows affected: ', rows_affected, '\\\\n',\n"
  "                         'rows sent: ', rows_sent, '\\\\n',\n"
  "                         'rows examined: ', rows_examined, '\\\\n',\n"
  "                         'tmp tables: ', created_tmp_tables, '\\\\n',\n"
  "                         'tmp disk tables: ', created_tmp_disk_tables, '\\\\n',\n"
  "                         'select scan: ', select_scan, '\\\\n',\n"
  "                         'select full join: ', select_full_join, '\\\\n',\n"
  "                         'select full range join: ', select_full_range_join, '\\\\n',\n"
  "                         'select range: ', select_range, '\\\\n',\n"
  "                         'select range check: ', select_range_check, '\\\\n', \n"
  "                         'sort merge passes: ', sort_merge_passes, '\\\\n',\n"
  "                         'sort rows: ', sort_rows, '\\\\n',\n"
  "                         'sort range: ', sort_range, '\\\\n',\n"
  "                         'sort scan: ', sort_scan, '\\\\n',\n"
  "                         'no index used: ', IF(no_index_used, 'TRUE', 'FALSE'), '\\\\n',\n"
  "                         'no good index used: ', IF(no_good_index_used, 'TRUE', 'FALSE'), '\\\\n'\n"
  "                         ) AS wait_info\n"
  "             FROM performance_schema.events_statements_history_long WHERE thread_id = thd_id)\n"
  "          UNION \n"
  "          -- Select all stages\n"
  "          (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info\n"
  "             FROM performance_schema.events_stages_history_long WHERE thread_id = thd_id) \n"
  "          UNION\n"
  "          -- Select all events, adding information appropriate to the event\n"
  "          (SELECT thread_id, event_id, \n"
  "                  CONCAT(event_name , \n"
  "                         IF(event_name NOT LIKE 'wait/synch/mutex%', IFNULL(CONCAT(' - ', operation), ''), ''), \n"
  "                         IF(number_of_bytes IS NOT NULL, CONCAT(' ', number_of_bytes, ' bytes'), ''),\n"
  "                         IF(event_name LIKE 'wait/io/file%', '\\\\n', ''),\n"
  "                         IF(object_schema IS NOT NULL, CONCAT('\\\\nObject: ', object_schema, '.'), ''), \n"
  "                         IF(object_name IS NOT NULL, \n"
  "                            IF (event_name LIKE 'wait/io/socket%',\n"
  "                                -- Print the socket if used, else the IP:port as reported\n"
  "                                CONCAT(IF (object_name LIKE ':0%', @@socket, object_name)),\n"
  "                                object_name),\n"
  "                            ''),\n"
  "                         IF(index_name IS NOT NULL, CONCAT(' Index: ', index_name), ''),'\\\\n'\n"
  "                         ) AS event_name,\n"
  "                  timer_wait, timer_start, nesting_event_id, source AS wait_info\n"
  "             FROM performance_schema.events_waits_history_long WHERE thread_id = thd_id)) events \n"
  "    ORDER BY event_id;\n"
  "    RETURN CONCAT('{', \n"
  "                  CONCAT_WS(',', \n"
  "                            '\"rankdir\": \"LR\"',\n"
  "                            '\"nodesep\": \"0.10\"',\n"
  "                            CONCAT('\"stack_created\": \"', NOW(), '\"'),\n"
  "                            CONCAT('\"mysql_version\": \"', VERSION(), '\"'),\n"
  "                            CONCAT('\"mysql_user\": \"', CURRENT_USER(), '\"'),\n"
  "                            CONCAT('\"events\": [', IFNULL(json_objects,''), ']')\n"
  "                           ),\n"
  "                  '}');\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS ps_thread_trx_info;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION ps_thread_trx_info (\n"
  "        in_thread_id BIGINT UNSIGNED\n"
  "    ) RETURNS LONGTEXT\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns a JSON object with info on the given threads current transaction, \n"
  "and the statements it has already executed, derived from the\n"
  "performance_schema.events_transactions_current and\n"
  "performance_schema.events_statements_history tables (so the consumers \n"
  "for these also have to be enabled within Performance Schema to get full\n"
  "data in the object).\n"
  "\n"
  "When the output exceeds the default truncation length (65535), a JSON error\n"
  "object is returned, such as:\n"
  "\n"
  "{ \"error\": \"Trx info truncated: Row 6 was cut by GROUP_CONCAT()\" }\n"
  "\n"
  "Similar error objects are returned for other warnings/and exceptions raised\n"
  "when calling the function.\n"
  "\n"
  "The max length of the output of this function can be controlled with the\n"
  "ps_thread_trx_info.max_length variable set via sys_config, or the\n"
  "@sys.ps_thread_trx_info.max_length user variable, as appropriate.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_thread_id (BIGINT UNSIGNED):\n"
  "  The id of the thread to return the transaction info for.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "SELECT sys.ps_thread_trx_info(48)\\\\G\n"
  "*************************** 1. row ***************************\n"
  "sys.ps_thread_trx_info(48): [\n"
  "  {\n"
  "    \"time\": \"790.70 us\",\n"
  "    \"state\": \"COMMITTED\",\n"
  "    \"mode\": \"READ WRITE\",\n"
  "    \"autocommitted\": \"NO\",\n"
  "    \"gtid\": \"AUTOMATIC\",\n"
  "    \"isolation\": \"REPEATABLE READ\",\n"
  "    \"statements_executed\": [\n"
  "      {\n"
  "        \"sql_text\": \"INSERT INTO info VALUES (1, \\'foo\\')\",\n"
  "        \"time\": \"471.02 us\",\n"
  "        \"schema\": \"trx\",\n"
  "        \"rows_examined\": 0,\n"
  "        \"rows_affected\": 1,\n"
  "        \"rows_sent\": 0,\n"
  "        \"tmp_tables\": 0,\n"
  "        \"tmp_disk_tables\": 0,\n"
  "        \"sort_rows\": 0,\n"
  "        \"sort_merge_passes\": 0\n"
  "      },\n"
  "      {\n"
  "        \"sql_text\": \"COMMIT\",\n"
  "        \"time\": \"254.42 us\",\n"
  "        \"schema\": \"trx\",\n"
  "        \"rows_examined\": 0,\n"
  "        \"rows_affected\": 0,\n"
  "        \"rows_sent\": 0,\n"
  "        \"tmp_tables\": 0,\n"
  "        \"tmp_disk_tables\": 0,\n"
  "        \"sort_rows\": 0,\n"
  "        \"sort_merge_passes\": 0\n"
  "      }\n"
  "    ]\n"
  "  },\n"
  "  {\n"
  "    \"time\": \"426.20 us\",\n"
  "    \"state\": \"COMMITTED\",\n"
  "    \"mode\": \"READ WRITE\",\n"
  "    \"autocommitted\": \"NO\",\n"
  "    \"gtid\": \"AUTOMATIC\",\n"
  "    \"isolation\": \"REPEATABLE READ\",\n"
  "    \"statements_executed\": [\n"
  "      {\n"
  "        \"sql_text\": \"INSERT INTO info VALUES (2, \\'bar\\')\",\n"
  "        \"time\": \"107.33 us\",\n"
  "        \"schema\": \"trx\",\n"
  "        \"rows_examined\": 0,\n"
  "        \"rows_affected\": 1,\n"
  "        \"rows_sent\": 0,\n"
  "        \"tmp_tables\": 0,\n"
  "        \"tmp_disk_tables\": 0,\n"
  "        \"sort_rows\": 0,\n"
  "        \"sort_merge_passes\": 0\n"
  "      },\n"
  "      {\n"
  "        \"sql_text\": \"COMMIT\",\n"
  "        \"time\": \"213.23 us\",\n"
  "        \"schema\": \"trx\",\n"
  "        \"rows_examined\": 0,\n"
  "        \"rows_affected\": 0,\n"
  "        \"rows_sent\": 0,\n"
  "        \"tmp_tables\": 0,\n"
  "        \"tmp_disk_tables\": 0,\n"
  "        \"sort_rows\": 0,\n"
  "        \"sort_merge_passes\": 0\n"
  "      }\n"
  "    ]\n"
  "  }\n"
  "]\n"
  "1 row in set (0.03 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_output LONGTEXT DEFAULT '{}';\n"
  "    DECLARE v_msg_text TEXT DEFAULT '';\n"
  "    DECLARE v_signal_msg TEXT DEFAULT '';\n"
  "    DECLARE v_mysql_errno INT;\n"
  "    DECLARE v_max_output_len BIGINT;\n"
  "    -- Capture warnings/errors such as group_concat truncation\n"
  "    -- and report as JSON error objects\n"
  "    DECLARE EXIT HANDLER FOR SQLWARNING, SQLEXCEPTION\n"
  "    BEGIN\n"
  "        GET DIAGNOSTICS CONDITION 1\n"
  "            v_msg_text = MESSAGE_TEXT,\n"
  "            v_mysql_errno = MYSQL_ERRNO;\n"
  "        IF v_mysql_errno = 1260 THEN\n"
  "            SET v_signal_msg = CONCAT('{ \"error\": \"Trx info truncated: ', v_msg_text, '\" }');\n"
  "        ELSE\n"
  "            SET v_signal_msg = CONCAT('{ \"error\": \"', v_msg_text, '\" }');\n"
  "        END IF;\n"
  "        RETURN v_signal_msg;\n"
  "    END;\n"
  "    -- Set configuration options\n"
  "    IF (@sys.ps_thread_trx_info.max_length IS NULL) THEN\n"
  "        SET @sys.ps_thread_trx_info.max_length = sys.sys_get_config('ps_thread_trx_info.max_length', 65535);\n"
  "    END IF;\n"
  "    IF (@sys.ps_thread_trx_info.max_length != @@session.group_concat_max_len) THEN\n"
  "        SET @old_group_concat_max_len = @@session.group_concat_max_len;\n"
  "        -- Convert to int value for the SET, and give some surrounding space\n"
  "        SET v_max_output_len = (@sys.ps_thread_trx_info.max_length - 5);\n"
  "        SET SESSION group_concat_max_len = v_max_output_len;\n"
  "    END IF;\n"
  "    SET v_output = (\n"
  "        SELECT CONCAT('[', IFNULL(GROUP_CONCAT(trx_info ORDER BY event_id), ''), '\\n]') AS trx_info\n"
  "          FROM (SELECT trxi.thread_id, \n"
  "                       trxi.event_id,\n"
  "                       GROUP_CONCAT(\n"
  "                         IFNULL(\n"
  "                           CONCAT('\\n  {\\n',\n"
  "                                  '    \"time\": \"', IFNULL(format_pico_time(trxi.timer_wait), ''), '\",\\n',\n"
  "                                  '    \"state\": \"', IFNULL(trxi.state, ''), '\",\\n',\n"
  "                                  '    \"mode\": \"', IFNULL(trxi.access_mode, ''), '\",\\n',\n"
  "                                  '    \"autocommitted\": \"', IFNULL(trxi.autocommit, ''), '\",\\n',\n"
  "                                  '    \"gtid\": \"', IFNULL(trxi.gtid, ''), '\",\\n',\n"
  "                                  '    \"isolation\": \"', IFNULL(trxi.isolation_level, ''), '\",\\n',\n"
  "                                  '    \"statements_executed\": [', IFNULL(s.stmts, ''), IF(s.stmts IS NULL, ' ]\\n', "
  "'\\n    ]\\n'),\n"
  "                                  '  }'\n"
  "                           ), \n"
  "                           '') \n"
  "                         ORDER BY event_id) AS trx_info\n"
  "                  FROM (\n"
  "                        (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level"
  "\n"
  "                           FROM performance_schema.events_transactions_current\n"
  "                          WHERE thread_id = in_thread_id\n"
  "                            AND end_event_id IS NULL)\n"
  "                        UNION\n"
  "                        (SELECT thread_id, event_id, timer_wait, state,access_mode, autocommit, gtid, isolation_level"
  "\n"
  "                           FROM performance_schema.events_transactions_history\n"
  "                          WHERE thread_id = in_thread_id)\n"
  "                       ) AS trxi\n"
  "                  LEFT JOIN (SELECT thread_id,\n"
  "                                    nesting_event_id,\n"
  "                                    GROUP_CONCAT(\n"
  "                                      IFNULL(\n"
  "                                        CONCAT('\\n      {\\n',\n"
  "                                               '        \"sql_text\": \"', IFNULL(sys.format_statement(REPLACE(sql_te"
  "xt, '\\\\', '\\\\\\\\')), ''), '\",\\n',\n"
  "                                               '        \"time\": \"', IFNULL(format_pico_time(timer_wait), ''), '\","
  "\\n',\n"
  "                                               '        \"schema\": \"', IFNULL(current_schema, ''), '\",\\n',\n"
  "                                               '        \"rows_examined\": ', IFNULL(rows_examined, ''), ',\\n',\n"
  "                                               '        \"rows_affected\": ', IFNULL(rows_affected, ''), ',\\n',\n"
  "                                               '        \"rows_sent\": ', IFNULL(rows_sent, ''), ',\\n',\n"
  "                                               '        \"tmp_tables\": ', IFNULL(created_tmp_tables, ''), ',\\n',\n"
  "                                               '        \"tmp_disk_tables\": ', IFNULL(created_tmp_disk_tables, ''), "
  "',\\n',\n"
  "                                               '        \"sort_rows\": ', IFNULL(sort_rows, ''), ',\\n',\n"
  "                                               '        \"sort_merge_passes\": ', IFNULL(sort_merge_passes, ''), '\\n'"
  ",\n"
  "                                               '      }'), '') ORDER BY event_id) AS stmts\n"
  "                               FROM performance_schema.events_statements_history\n"
  "                              WHERE sql_text IS NOT NULL\n"
  "                                AND thread_id = in_thread_id\n"
  "                              GROUP BY thread_id, nesting_event_id\n"
  "                            ) AS s \n"
  "                    ON trxi.thread_id = s.thread_id \n"
  "                   AND trxi.event_id = s.nesting_event_id\n"
  "                 WHERE trxi.thread_id = in_thread_id\n"
  "                 GROUP BY trxi.thread_id, trxi.event_id\n"
  "                ) trxs\n"
  "          GROUP BY thread_id\n"
  "    );\n"
  "    IF (@old_group_concat_max_len IS NOT NULL) THEN\n"
  "        SET SESSION group_concat_max_len = @old_group_concat_max_len;\n"
  "    END IF;\n"
  "    RETURN v_output;\n"
  "END\n",
"-- Copyright (c) 2016, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS quote_identifier;\n",
"-- https://dev.mysql.com/doc/refman/5.7/en/identifiers.html\n"
  "-- Maximum supported length for any of the current identifiers in 5.7.5+ is 256 characters.\n"
  "-- Before that, user variables could have any length.\n"
  "--\n"
  "-- Based on Paul Dubois' suggestion in Bug #78823/Bug #22011361.\n"
  "CREATE DEFINER='mysql.sys'@'localhost' FUNCTION quote_identifier(in_identifier TEXT)\n"
  "    RETURNS TEXT CHARSET UTF8MB4\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes an unquoted identifier (schema name, table name, etc.) and\n"
  "returns the identifier quoted with backticks.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_identifier (TEXT):\n"
  "  The identifier to quote.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TEXT CHARSET UTF8MB4\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT sys.quote_identifier(''my_identifier'') AS Identifier;\n"
  "+-----------------+\n"
  "| Identifier      |\n"
  "+-----------------+\n"
  "| `my_identifier` |\n"
  "+-----------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> SELECT sys.quote_identifier(''my`idenfier'') AS Identifier;\n"
  "+----------------+\n"
  "| Identifier     |\n"
  "+----------------+\n"
  "| `my``idenfier` |\n"
  "+----------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN CONCAT('`', REPLACE(in_identifier, '`', '``'), '`');\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS sys_get_config;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION sys_get_config (\n"
  "        in_variable_name VARCHAR(128),\n"
  "        in_default_value VARCHAR(128)\n"
  "    )\n"
  "    RETURNS VARCHAR(128)\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns the value for the requested variable using the following logic:\n"
  "\n"
  "   1. If the option exists in sys.sys_config return the value from there.\n"
  "   2. Else fall back on the provided default value.\n"
  "\n"
  "Notes for using sys_get_config():\n"
  "\n"
  "   * If the default value argument to sys_get_config() is NULL and case 2. is reached, NULL is returned.\n"
  "     It is then expected that the caller is able to handle NULL for the given configuration option.\n"
  "   * The convention is to name the user variables @sys.<name of variable>. It is <name of variable> that\n"
  "     is stored in the sys_config table and is what is expected as the argument to sys_get_config().\n"
  "   * If you want to check whether the configuration option has already been set and if not assign with\n"
  "     the return value of sys_get_config() you can use IFNULL(...) (see example below). However this should\n"
  "     not be done inside a loop (e.g. for each row in a result set) as for repeated calls where assignment\n"
  "     is only needed in the first iteration using IFNULL(...) is expected to be significantly slower than\n"
  "     using an IF (...) THEN ... END IF; block (see example below).\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_variable_name (VARCHAR(128)):\n"
  "  The name of the config option to return the value for.\n"
  "\n"
  "in_default_value (VARCHAR(128)):\n"
  "  The default value to return if the variable does not exist in sys.sys_config.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "VARCHAR(128)\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "-- Get the configuration value from sys.sys_config falling back on 128 if the option is not present in the table.\n"
  "mysql> SELECT sys.sys_get_config(''statement_truncate_len'', 128) AS Value;\n"
  "+-------+\n"
  "| Value |\n"
  "+-------+\n"
  "| 64    |\n"
  "+-------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "-- Check whether the option is already set, if not assign - IFNULL(...) one liner example.\n"
  "mysql> SET @sys.statement_truncate_len = IFNULL(@sys.statement_truncate_len, sys.sys_get_config(''statement_truncate_"
  "len'', 64));\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "-- Check whether the option is already set, if not assign - IF ... THEN ... END IF example.\n"
  "IF (@sys.statement_truncate_len IS NULL) THEN\n"
  "    SET @sys.statement_truncate_len = sys.sys_get_config(''statement_truncate_len'', 64);\n"
  "END IF;\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_value VARCHAR(128) DEFAULT NULL;\n"
  "    -- Check if we have the variable in the sys.sys_config table\n"
  "    SET v_value = (SELECT value FROM sys.sys_config WHERE variable = in_variable_name);\n"
  "    -- Protection against the variable not existing in sys_config\n"
  "    IF (v_value IS NULL) THEN\n"
  "        SET v_value = in_default_value;\n"
  "    END IF;\n"
  "    RETURN v_value;\n"
  "END \n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS version_major;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION version_major ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns the major version of MySQL Server.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TINYINT UNSIGNED\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT VERSION(), sys.version_major();\n"
  "+--------------------------------------+---------------------+\n"
  "| VERSION()                            | sys.version_major() |\n"
  "+--------------------------------------+---------------------+\n"
  "| 5.7.9-enterprise-commercial-advanced | 5                   |\n"
  "+--------------------------------------+---------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', 1);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS version_minor;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION version_minor ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns the minor (release series) version of MySQL Server.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TINYINT UNSIGNED\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT VERSION(), sys.server_minor();\n"
  "+--------------------------------------+---------------------+\n"
  "| VERSION()                            | sys.version_minor() |\n"
  "+--------------------------------------+---------------------+\n"
  "| 5.7.9-enterprise-commercial-advanced | 7                   |\n"
  "+--------------------------------------+---------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', 2), '.', -1);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP FUNCTION IF EXISTS version_patch;\n",
"CREATE DEFINER='mysql.sys'@'localhost' FUNCTION version_patch ()\n"
  "    RETURNS TINYINT UNSIGNED\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Returns the patch release version of MySQL Server.\n"
  "\n"
  "Returns\n"
  "-----------\n"
  "\n"
  "TINYINT UNSIGNED\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SELECT VERSION(), sys.version_patch();\n"
  "+--------------------------------------+---------------------+\n"
  "| VERSION()                            | sys.version_patch() |\n"
  "+--------------------------------------+---------------------+\n"
  "| 5.7.9-enterprise-commercial-advanced | 9                   |\n"
  "+--------------------------------------+---------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    NO SQL\n"
  "BEGIN\n"
  "    RETURN SUBSTRING_INDEX(SUBSTRING_INDEX(VERSION(), '-', 1), '.', -1);\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: innodb_buffer_stats_by_schema\n"
  "-- \n"
  "-- Summarizes the output of the INFORMATION_SCHEMA.INNODB_BUFFER_PAGE \n"
  "-- table, aggregating by schema\n"
  "--\n"
  "-- \n"
  "-- mysql> select * from innodb_buffer_stats_by_schema;\n"
  "-- +--------------------------+------------+------------+-------+--------------+-----------+-------------+\n"
  "-- | object_schema            | allocated  | data       | pages | pages_hashed | pages_old | rows_cached |\n"
  "-- +--------------------------+------------+------------+-------+--------------+-----------+-------------+\n"
  "-- | mem30_trunk__instruments | 1.69 MiB   | 510.03 KiB |   108 |          108 |       108 |        3885 |\n"
  "-- | InnoDB System            | 688.00 KiB | 351.62 KiB |    43 |           43 |        43 |         862 |\n"
  "-- | mem30_trunk__events      | 80.00 KiB  | 21.61 KiB  |     5 |            5 |         5 |         229 |\n"
  "-- +--------------------------+------------+------------+-------+--------------+-----------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW innodb_buffer_stats_by_schema (\n"
  "  object_schema,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')"
  ") AS object_schema,\n"
  "       format_bytes(SUM(IF(ibp.compressed_size = 0, 16384, compressed_size))) AS allocated,\n"
  "       format_bytes(SUM(ibp.data_size)) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed = 'YES', 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old = 'YES', 1, NULL)) AS pages_old,\n"
  "       ROUND(SUM(ibp.number_records)/COUNT(DISTINCT ibp.index_name)) AS rows_cached \n"
  "  FROM information_schema.innodb_buffer_page ibp \n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$innodb_buffer_stats_by_schema\n"
  "-- \n"
  "-- Summarizes the output of the INFORMATION_SCHEMA.INNODB_BUFFER_PAGE \n"
  "-- table, aggregating by schema\n"
  "--\n"
  "-- mysql> select * from x$innodb_buffer_stats_by_schema;\n"
  "-- +--------------------------+-----------+--------+-------+--------------+-----------+-------------+\n"
  "-- | object_schema            | allocated | data   | pages | pages_hashed | pages_old | rows_cached |\n"
  "-- +--------------------------+-----------+--------+-------+--------------+-----------+-------------+\n"
  "-- | mem30_trunk__instruments |   1769472 | 522272 |   108 |          108 |       108 |        3885 |\n"
  "-- | InnoDB System            |    704512 | 360054 |    43 |           43 |        43 |         862 |\n"
  "-- | mem30_trunk__events      |     81920 |  22125 |     5 |            5 |         5 |         229 |\n"
  "-- +--------------------------+-----------+--------+-------+--------------+-----------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$innodb_buffer_stats_by_schema (\n"
  "  object_schema,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')"
  ") AS object_schema,\n"
  "       SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) AS allocated,\n"
  "       SUM(ibp.data_size) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed = 'YES', 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old = 'YES', 1, NULL)) AS pages_old,\n"
  "       ROUND(IFNULL(SUM(ibp.number_records)/NULLIF(COUNT(DISTINCT ibp.index_name), 0), 0)) AS rows_cached \n"
  "  FROM information_schema.innodb_buffer_page ibp \n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: innodb_buffer_stats_by_table\n"
  "-- \n"
  "-- Summarizes the output of the INFORMATION_SCHEMA.INNODB_BUFFER_PAGE \n"
  "-- table, aggregating by schema and table name\n"
  "--\n"
  "-- mysql> select * from innodb_buffer_stats_by_table;\n"
  "-- +--------------------------+------------------------------------+------------+-----------+-------+--------------+-"
  "----------+-------------+\n"
  "-- | object_schema            | object_name                        | allocated  | data      | pages | pages_hashed | "
  "pages_old | rows_cached |\n"
  "-- +--------------------------+------------------------------------+------------+-----------+-------+--------------+-"
  "----------+-------------+\n"
  "-- | InnoDB System            | SYS_COLUMNS                        | 128.00 KiB | 98.97 KiB |     8 |            8 | "
  "        8 |        1532 |\n"
  "-- | InnoDB System            | SYS_FOREIGN                        | 128.00 KiB | 55.48 KiB |     8 |            8 | "
  "        8 |         172 |\n"
  "-- | InnoDB System            | SYS_TABLES                         | 128.00 KiB | 56.18 KiB |     8 |            8 | "
  "        8 |         365 |\n"
  "-- | InnoDB System            | SYS_INDEXES                        | 112.00 KiB | 76.16 KiB |     7 |            7 | "
  "        7 |        1046 |\n"
  "-- | mem30_trunk__instruments | agentlatencytime                   | 96.00 KiB  | 28.83 KiB |     6 |            6 | "
  "        6 |         252 |\n"
  "-- | mem30_trunk__instruments | binlogspaceusagedata               | 96.00 KiB  | 22.54 KiB |     6 |            6 | "
  "        6 |         196 |\n"
  "-- | mem30_trunk__instruments | connectionsdata                    | 96.00 KiB  | 36.68 KiB |     6 |            6 | "
  "        6 |         276 |\n"
  "-- ...\n"
  "-- +--------------------------+------------------------------------+------------+-----------+-------+--------------+-"
  "----------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW innodb_buffer_stats_by_table (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')"
  ") AS object_schema,\n"
  "       REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', -1), '`', '') AS object_name,\n"
  "       format_bytes(SUM(IF(ibp.compressed_size = 0, 16384, compressed_size))) AS allocated,\n"
  "       format_bytes(SUM(ibp.data_size)) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed = 'YES', 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old = 'YES', 1, NULL)) AS pages_old,\n"
  "       ROUND(SUM(ibp.number_records)/COUNT(DISTINCT ibp.index_name)) AS rows_cached \n"
  "  FROM information_schema.innodb_buffer_page ibp \n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema, object_name\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$innodb_buffer_stats_by_table\n"
  "-- \n"
  "-- Summarizes the output of the INFORMATION_SCHEMA.INNODB_BUFFER_PAGE \n"
  "-- table, aggregating by schema and table name\n"
  "--\n"
  "-- mysql> select * from x$innodb_buffer_stats_by_table;\n"
  "-- +--------------------------+------------------------------------+-----------+--------+-------+--------------+-----"
  "------+-------------+\n"
  "-- | object_schema            | object_name                        | allocated | data   | pages | pages_hashed | page"
  "s_old | rows_cached |\n"
  "-- +--------------------------+------------------------------------+-----------+--------+-------+--------------+-----"
  "------+-------------+\n"
  "-- | InnoDB System            | SYS_COLUMNS                        |    131072 | 101350 |     8 |            8 |     "
  "    8 |        1532 |\n"
  "-- | InnoDB System            | SYS_FOREIGN                        |    131072 |  56808 |     8 |            8 |     "
  "    8 |         172 |\n"
  "-- | InnoDB System            | SYS_TABLES                         |    131072 |  57529 |     8 |            8 |     "
  "    8 |         365 |\n"
  "-- | InnoDB System            | SYS_INDEXES                        |    114688 |  77984 |     7 |            7 |     "
  "    7 |        1046 |\n"
  "-- | mem30_trunk__instruments | agentlatencytime                   |     98304 |  29517 |     6 |            6 |     "
  "    6 |         252 |\n"
  "-- | mem30_trunk__instruments | binlogspaceusagedata               |     98304 |  23076 |     6 |            6 |     "
  "    6 |         196 |\n"
  "-- | mem30_trunk__instruments | connectionsdata                    |     98304 |  37563 |     6 |            6 |     "
  "    6 |         276 |\n"
  "-- ...\n"
  "-- +--------------------------+------------------------------------+-----------+--------+-------+--------------+-----"
  "------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$innodb_buffer_stats_by_table (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  allocated,\n"
  "  data,\n"
  "  pages,\n"
  "  pages_hashed,\n"
  "  pages_old,\n"
  "  rows_cached\n"
  ") AS\n"
  "SELECT IF(LOCATE('.', ibp.table_name) = 0, 'InnoDB System', REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', 1), '`', '')"
  ") AS object_schema,\n"
  "       REPLACE(SUBSTRING_INDEX(ibp.table_name, '.', -1), '`', '') AS object_name,\n"
  "       SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) AS allocated,\n"
  "       SUM(ibp.data_size) AS data,\n"
  "       COUNT(ibp.page_number) AS pages,\n"
  "       COUNT(IF(ibp.is_hashed = 'YES', 1, NULL)) AS pages_hashed,\n"
  "       COUNT(IF(ibp.is_old = 'YES', 1, NULL)) AS pages_old,\n"
  "       ROUND(IFNULL(SUM(ibp.number_records)/NULLIF(COUNT(DISTINCT ibp.index_name), 0), 0)) AS rows_cached \n"
  "  FROM information_schema.innodb_buffer_page ibp \n"
  " WHERE table_name IS NOT NULL\n"
  " GROUP BY object_schema, object_name\n"
  " ORDER BY SUM(IF(ibp.compressed_size = 0, 16384, compressed_size)) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: schema_object_overview\n"
  "-- \n"
  "-- Shows an overview of the types of objects within each schema\n"
  "--\n"
  "-- Note: On instances with a large number of objects, this could take\n"
  "--       some time to execute, and is not recommended.\n"
  "--\n"
  "-- mysql> select * from schema_object_overview;\n"
  "-- +---------------------------------+---------------+-------+\n"
  "-- | db                              | object_type   | count |\n"
  "-- +---------------------------------+---------------+-------+\n"
  "-- | information_schema              | SYSTEM VIEW   |    59 |\n"
  "-- | mem30_test__instruments         | BASE TABLE    |     1 |\n"
  "-- | mem30_test__instruments         | INDEX (BTREE) |     2 |\n"
  "-- | mem30_test__test                | BASE TABLE    |     9 |\n"
  "-- | mem30_test__test                | INDEX (BTREE) |    19 |\n"
  "-- ...\n"
  "-- | sys                             | FUNCTION      |     8 |\n"
  "-- | sys                             | PROCEDURE     |    16 |\n"
  "-- | sys                             | VIEW          |    59 |\n"
  "-- +---------------------------------+---------------+-------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_object_overview (\n"
  "  db,\n"
  "  object_type,\n"
  "  count\n"
  ") AS\n"
  "SELECT ROUTINE_SCHEMA AS db, ROUTINE_TYPE AS object_type, COUNT(*) AS count FROM information_schema.routines GROUP BY"
  " ROUTINE_SCHEMA, ROUTINE_TYPE\n"
  " UNION \n"
  "SELECT TABLE_SCHEMA, TABLE_TYPE, COUNT(*) FROM information_schema.tables GROUP BY TABLE_SCHEMA, TABLE_TYPE\n"
  " UNION\n"
  "SELECT TABLE_SCHEMA, CONCAT('INDEX (', INDEX_TYPE, ')'), COUNT(*) FROM information_schema.statistics GROUP BY TABLE_S"
  "CHEMA, INDEX_TYPE\n"
  " UNION\n"
  "SELECT TRIGGER_SCHEMA, 'TRIGGER', COUNT(*) FROM information_schema.triggers GROUP BY TRIGGER_SCHEMA\n"
  " UNION\n"
  "SELECT EVENT_SCHEMA, 'EVENT', COUNT(*) FROM information_schema.events GROUP BY EVENT_SCHEMA\n"
  "ORDER BY DB, OBJECT_TYPE;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: schema_auto_increment_columns\n"
  "--\n"
  "-- Present current auto_increment usage/capacity in all tables.\n"
  "--\n"
  "-- mysql> select * from schema_auto_increment_columns limit 5;\n"
  "-- +-------------------+-------------------+-------------+-----------+-------------+-----------+-------------+-------"
  "--------------+----------------+----------------------+\n"
  "-- | table_schema      | table_name        | column_name | data_type | column_type | is_signed | is_unsigned | max_va"
  "lue           | auto_increment | auto_increment_ratio |\n"
  "-- +-------------------+-------------------+-------------+-----------+-------------+-----------+-------------+-------"
  "--------------+----------------+----------------------+\n"
  "-- | test              | t1                | i           | tinyint   | tinyint     |         1 |           0 |       "
  "          127 |             34 |               0.2677 |\n"
  "-- | mem__advisor_text | template_meta     | hib_id      | int       | int         |         1 |           0 |       "
  "   2147483647 |            516 |               0.0000 |\n"
  "-- | mem__advisors     | advisor_schedules | schedule_id | int       | int         |         1 |           0 |       "
  "   2147483647 |            249 |               0.0000 |\n"
  "-- | mem__advisors     | app_identity_path | hib_id      | int       | int         |         1 |           0 |       "
  "   2147483647 |            251 |               0.0000 |\n"
  "-- | mem__bean_config  | plists            | id          | bigint    | bigint      |         1 |           0 | 922337"
  "2036854775807 |              1 |               0.0000 |\n"
  "-- +-------------------+-------------------+-------------+-----------+-------------+-----------+-------------+-------"
  "--------------+----------------+----------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_auto_increment_columns (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  column_name,\n"
  "  data_type,\n"
  "  column_type,\n"
  "  is_signed,\n"
  "  is_unsigned,\n"
  "  max_value,\n"
  "  auto_increment,\n"
  "  auto_increment_ratio\n"
  ") AS\n"
  "SELECT TABLE_SCHEMA,\n"
  "       TABLE_NAME,\n"
  "       COLUMN_NAME,\n"
  "       DATA_TYPE,\n"
  "       COLUMN_TYPE,\n"
  "       (LOCATE('unsigned', COLUMN_TYPE) = 0) AS is_signed,\n"
  "       (LOCATE('unsigned', COLUMN_TYPE) > 0) AS is_unsigned,\n"
  "       (\n"
  "          CASE DATA_TYPE\n"
  "            WHEN 'tinyint' THEN 255\n"
  "            WHEN 'smallint' THEN 65535\n"
  "            WHEN 'mediumint' THEN 16777215\n"
  "            WHEN 'int' THEN 4294967295\n"
  "            WHEN 'bigint' THEN 18446744073709551615\n"
  "          END >> IF(LOCATE('unsigned', COLUMN_TYPE) > 0, 0, 1)\n"
  "       ) AS max_value,\n"
  "       AUTO_INCREMENT,\n"
  "       AUTO_INCREMENT / (\n"
  "         CASE DATA_TYPE\n"
  "           WHEN 'tinyint' THEN 255\n"
  "           WHEN 'smallint' THEN 65535\n"
  "           WHEN 'mediumint' THEN 16777215\n"
  "           WHEN 'int' THEN 4294967295\n"
  "           WHEN 'bigint' THEN 18446744073709551615\n"
  "         END >> IF(LOCATE('unsigned', COLUMN_TYPE) > 0, 0, 1)\n"
  "       ) AS auto_increment_ratio\n"
  "  FROM INFORMATION_SCHEMA.COLUMNS\n"
  " INNER JOIN INFORMATION_SCHEMA.TABLES USING (TABLE_SCHEMA, TABLE_NAME)\n"
  " WHERE TABLE_SCHEMA NOT IN ('mysql', 'sys', 'INFORMATION_SCHEMA', 'performance_schema')\n"
  "   AND TABLE_TYPE='BASE TABLE'\n"
  "   AND EXTRA='auto_increment'\n"
  " ORDER BY auto_increment_ratio DESC, max_value;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$schema_flattened_keys\n"
  "--\n"
  "-- Helper view for the schema_redundant_keys view.\n"
  "--\n"
  "-- mysql> select * from sys.x$schema_flattened_keys;\n"
  "-- +---------------+---------------------+------------------------------+------------+----------------+--------------"
  "---+\n"
  "-- | table_schema  | table_name          | index_name                   | non_unique | subpart_exists | index_columns"
  "   |\n"
  "-- +---------------+---------------------+------------------------------+------------+----------------+--------------"
  "---+\n"
  "-- | mem__advisors | advisor_initialized | PRIMARY                      |          0 |              0 | advisorClassI"
  "d  |\n"
  "-- | mem__advisors | advisor_schedules   | advisorClassIdIdx            |          1 |              0 | advisorClassI"
  "d  |\n"
  "-- | mem__advisors | advisor_schedules   | PRIMARY                      |          0 |              0 | schedule_id  "
  "   |\n"
  "-- | mem__advisors | app_identity_path   | FK_7xbq2i81hgo0xlvnb6rr77s21 |          1 |              0 | for_schedule_"
  "id |\n"
  "-- | mem__advisors | app_identity_path   | PRIMARY                      |          0 |              0 | hib_id       "
  "   |\n"
  "-- ...\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$schema_flattened_keys (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  non_unique,\n"
  "  subpart_exists,\n"
  "  index_columns\n"
  ") AS\n"
  "  SELECT\n"
  "    TABLE_SCHEMA,\n"
  "    TABLE_NAME,\n"
  "    INDEX_NAME,\n"
  "    MAX(NON_UNIQUE) AS non_unique,\n"
  "    MAX(IF(SUB_PART IS NULL, 0, 1)) AS subpart_exists,\n"
  "    GROUP_CONCAT(COLUMN_NAME ORDER BY SEQ_IN_INDEX) AS index_columns\n"
  "  FROM INFORMATION_SCHEMA.STATISTICS\n"
  "  WHERE\n"
  "    INDEX_TYPE='BTREE'\n"
  "    AND TABLE_SCHEMA NOT IN ('mysql', 'sys', 'INFORMATION_SCHEMA', 'PERFORMANCE_SCHEMA')\n"
  "  GROUP BY\n"
  "    TABLE_SCHEMA, TABLE_NAME, INDEX_NAME;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: schema_redundant_keys\n"
  "--\n"
  "-- Shows indexes which are made redundant (or duplicate) by other (dominant) keys.\n"
  "--\n"
  "-- mysql> select * from sys.schema_redundant_indexes\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--               table_schema: test\n"
  "--                 table_name: rkey\n"
  "--       redundant_index_name: j\n"
  "--    redundant_index_columns: j\n"
  "-- redundant_index_non_unique: 1\n"
  "--        dominant_index_name: j_2\n"
  "--     dominant_index_columns: j,k\n"
  "--  dominant_index_non_unique: 1\n"
  "--             subpart_exists: 0\n"
  "--             sql_drop_index: ALTER TABLE `test`.`rkey` DROP INDEX `j`\n"
  "-- 1 row in set (0.20 sec)\n"
  "-- \n"
  "-- mysql> SHOW CREATE TABLE test.rkey\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--        Table: rkey\n"
  "-- Create Table: CREATE TABLE `rkey` (\n"
  "--   `i` int NOT NULL,\n"
  "--   `j` int DEFAULT NULL,\n"
  "--   `k` int DEFAULT NULL,\n"
  "--   PRIMARY KEY (`i`),\n"
  "--   KEY `j` (`j`),\n"
  "--   KEY `j_2` (`j`,`k`)\n"
  "-- ) ENGINE=InnoDB DEFAULT CHARSET=latin1\n"
  "-- 1 row in set (0.06 sec)\n"
  "-- \n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW schema_redundant_indexes (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  redundant_index_name,\n"
  "  redundant_index_columns,\n"
  "  redundant_index_non_unique,\n"
  "  dominant_index_name,\n"
  "  dominant_index_columns,\n"
  "  dominant_index_non_unique,\n"
  "  subpart_exists,\n"
  "  sql_drop_index\n"
  ") AS\n"
  "  SELECT\n"
  "    redundant_keys.table_schema,\n"
  "    redundant_keys.table_name,\n"
  "    redundant_keys.index_name AS redundant_index_name,\n"
  "    redundant_keys.index_columns AS redundant_index_columns,\n"
  "    redundant_keys.non_unique AS redundant_index_non_unique,\n"
  "    dominant_keys.index_name AS dominant_index_name,\n"
  "    dominant_keys.index_columns AS dominant_index_columns,\n"
  "    dominant_keys.non_unique AS dominant_index_non_unique,\n"
  "    IF(redundant_keys.subpart_exists OR dominant_keys.subpart_exists, 1 ,0) AS subpart_exists,\n"
  "    CONCAT(\n"
  "      'ALTER TABLE `', redundant_keys.table_schema, '`.`', redundant_keys.table_name, '` DROP INDEX `', redundant_key"
  "s.index_name, '`'\n"
  "      ) AS sql_drop_index\n"
  "  FROM\n"
  "    x$schema_flattened_keys AS redundant_keys\n"
  "    INNER JOIN x$schema_flattened_keys AS dominant_keys\n"
  "    USING (TABLE_SCHEMA, TABLE_NAME)\n"
  "  WHERE\n"
  "    redundant_keys.index_name != dominant_keys.index_name\n"
  "    AND (\n"
  "      ( \n"
  "        /* Identical columns */\n"
  "        (redundant_keys.index_columns = dominant_keys.index_columns)\n"
  "        AND (\n"
  "          (redundant_keys.non_unique > dominant_keys.non_unique)\n"
  "          OR (redundant_keys.non_unique = dominant_keys.non_unique \n"
  "          	AND IF(redundant_keys.index_name='PRIMARY', '', redundant_keys.index_name) > IF(dominant_keys.index_name='"
  "PRIMARY', '', dominant_keys.index_name)\n"
  "          )\n"
  "        )\n"
  "      )\n"
  "      OR\n"
  "      ( \n"
  "        /* Non-unique prefix columns */\n"
  "        LOCATE(CONCAT(redundant_keys.index_columns, ','), dominant_keys.index_columns) = 1\n"
  "        AND redundant_keys.non_unique = 1\n"
  "      )\n"
  "      OR\n"
  "      ( \n"
  "        /* Unique prefix columns */\n"
  "        LOCATE(CONCAT(dominant_keys.index_columns, ','), redundant_keys.index_columns) = 1\n"
  "        AND dominant_keys.non_unique = 0\n"
  "      )\n"
  "    );\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: ps_check_lost_instrumentation\n"
  "-- \n"
  "-- Used to check whether Performance Schema is not able to monitor\n"
  "-- all runtime data - only returns variables that have lost instruments\n"
  "--\n"
  "-- mysql> select * from ps_check_lost_instrumentation;\n"
  "-- +----------------------------------------+----------------+\n"
  "-- | variable_name                          | variable_value |\n"
  "-- +----------------------------------------+----------------+\n"
  "-- | Performance_schema_file_handles_lost   | 101223         |\n"
  "-- | Performance_schema_file_instances_lost | 1231           |\n"
  "-- +----------------------------------------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW ps_check_lost_instrumentation (\n"
  "  variable_name,\n"
  "  variable_value\n"
  ")\n"
  "AS\n"
  "SELECT variable_name, variable_value\n"
  "  FROM performance_schema.global_status\n"
  " WHERE variable_name LIKE 'perf%lost'\n"
  "   AND variable_value > 0;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: latest_file_io\n"
  "--\n"
  "-- Shows the latest file IO, by file / thread.\n"
  "--\n"
  "-- mysql> select * from latest_file_io limit 5;\n"
  "-- +----------------------+----------------------------------------+------------+-----------+-----------+\n"
  "-- | thread               | file                                   | latency    | operation | requested |\n"
  "-- +----------------------+----------------------------------------+------------+-----------+-----------+\n"
  "-- | msandbox@localhost:1 | @@tmpdir/#sqlcf28_1_4e.MYI             | 9.26 us    | write     | 124 bytes |\n"
  "-- | msandbox@localhost:1 | @@tmpdir/#sqlcf28_1_4e.MYI             | 4.00 us    | write     | 2 bytes   |\n"
  "-- | msandbox@localhost:1 | @@tmpdir/#sqlcf28_1_4e.MYI             | 56.34 us   | close     | NULL      |\n"
  "-- | msandbox@localhost:1 | @@tmpdir/#sqlcf28_1_4e.MYD             | 53.93 us   | close     | NULL      |\n"
  "-- | msandbox@localhost:1 | @@tmpdir/#sqlcf28_1_4e.MYI             | 104.05 ms  | delete    | NULL      |\n"
  "-- +----------------------+----------------------------------------+------------+-----------+-----------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW latest_file_io (\n"
  "  thread,\n"
  "  file,\n"
  "  latency,\n"
  "  operation,\n"
  "  requested\n"
  ") AS\n"
  "SELECT IF(id IS NULL, \n"
  "             CONCAT(SUBSTRING_INDEX(name, '/', -1), ':', thread_id), \n"
  "             CONCAT(user, '@', host, ':', id)\n"
  "          ) thread, \n"
  "       sys.format_path(object_name) file, \n"
  "       format_pico_time(timer_wait) AS latency, \n"
  "       operation, \n"
  "       format_bytes(number_of_bytes) AS requested\n"
  "  FROM performance_schema.events_waits_history_long \n"
  "  JOIN performance_schema.threads USING (thread_id)\n"
  "  LEFT JOIN information_schema.processlist ON processlist_id = id\n"
  " WHERE object_name IS NOT NULL\n"
  "   AND event_name LIKE 'wait/io/file/%'\n"
  " ORDER BY timer_start;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$latest_file_io\n"
  "--\n"
  "-- Shows the latest file IO, by file / thread.\n"
  "--\n"
  "-- mysql> SELECT * FROM x$latest_file_io LIMIT 5;\n"
  "-- +------------------+------------------------------------------------------------------------------------+---------"
  "----+-----------+-----------+\n"
  "-- | thread           | file                                                                               | latency "
  "    | operation | requested |\n"
  "-- +------------------+------------------------------------------------------------------------------------+---------"
  "----+-----------+-----------+\n"
  "-- | root@localhost:6 | /Users/mark/sandboxes/msb_5_7_2/data/ps_helper/user_summary_by_statement_type.frm~ |    26152"
  "490 | write     |      4210 |\n"
  "-- | root@localhost:6 | /Users/mark/sandboxes/msb_5_7_2/data/ps_helper/user_summary_by_statement_type.frm~ | 30062722"
  "690 | sync      |      NULL |\n"
  "-- | root@localhost:6 | /Users/mark/sandboxes/msb_5_7_2/data/ps_helper/user_summary_by_statement_type.frm~ |    34144"
  "890 | close     |      NULL |\n"
  "-- | root@localhost:6 | /Users/mark/sandboxes/msb_5_7_2/data/ps_helper/check_lost_instrumentation.frm      |   113001"
  "980 | open      |      NULL |\n"
  "-- | root@localhost:6 | /Users/mark/sandboxes/msb_5_7_2/data/ps_helper/check_lost_instrumentation.frm      |     9553"
  "180 | read      |        10 |\n"
  "-- +------------------+------------------------------------------------------------------------------------+---------"
  "----+-----------+-----------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$latest_file_io (\n"
  "  thread,\n"
  "  file,\n"
  "  latency,\n"
  "  operation,\n"
  "  requested\n"
  ") AS\n"
  "SELECT IF(id IS NULL, \n"
  "             CONCAT(SUBSTRING_INDEX(name, '/', -1), ':', thread_id), \n"
  "             CONCAT(user, '@', host, ':', id)\n"
  "          ) thread, \n"
  "       object_name file, \n"
  "       timer_wait AS latency, \n"
  "       operation, \n"
  "       number_of_bytes AS requested\n"
  "  FROM performance_schema.events_waits_history_long \n"
  "  JOIN performance_schema.threads USING (thread_id)\n"
  "  LEFT JOIN information_schema.processlist ON processlist_id = id\n"
  " WHERE object_name IS NOT NULL\n"
  "   AND event_name LIKE 'wait/io/file/%'\n"
  " ORDER BY timer_start;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: io_by_thread_by_latency\n"
  "--\n"
  "-- Show the top IO consumers by thread, ordered by total latency\n"
  "--\n"
  "-- mysql> select * from io_by_thread_by_latency;\n"
  "-- +---------------------+-------+---------------+-------------+-------------+-------------+-----------+-------------"
  "---+\n"
  "-- | user                | total | total_latency | min_latency | avg_latency | max_latency | thread_id | processlist_"
  "id |\n"
  "-- +---------------------+-------+---------------+-------------+-------------+-------------+-----------+-------------"
  "---+\n"
  "-- | root@localhost      | 11580 | 18.01 s       | 429.78 ns   | 1.12 ms     | 181.07 ms   |        25 |             "
  " 6 |\n"
  "-- | main                |  1358 | 1.31 s        | 475.02 ns   | 2.27 ms     | 350.70 ms   |         1 |           NU"
  "LL |\n"
  "-- | page_cleaner_thread |   654 | 147.44 ms     | 588.12 ns   | 225.44 us   | 46.41 ms    |        18 |           NU"
  "LL |\n"
  "-- | io_write_thread     |   131 | 107.75 ms     | 8.60 us     | 822.55 us   | 27.69 ms    |         8 |           NU"
  "LL |\n"
  "-- | io_write_thread     |    46 | 47.07 ms      | 10.64 us    | 1.02 ms     | 16.90 ms    |         9 |           NU"
  "LL |\n"
  "-- | io_write_thread     |    71 | 46.99 ms      | 9.11 us     | 661.81 us   | 17.04 ms    |        11 |           NU"
  "LL |\n"
  "-- | io_log_thread       |    20 | 21.01 ms      | 14.25 us    | 1.05 ms     | 7.08 ms     |         3 |           NU"
  "LL |\n"
  "-- | srv_master_thread   |    13 | 17.60 ms      | 8.49 us     | 1.35 ms     | 9.99 ms     |        16 |           NU"
  "LL |\n"
  "-- | srv_purge_thread    |     4 | 1.81 ms       | 34.31 us    | 452.45 us   | 1.02 ms     |        17 |           NU"
  "LL |\n"
  "-- | io_write_thread     |    19 | 951.39 us     | 9.75 us     | 50.07 us    | 297.47 us   |        10 |           NU"
  "LL |\n"
  "-- | signal_handler      |     3 | 218.03 us     | 21.64 us    | 72.68 us    | 154.84 us   |        19 |           NU"
  "LL |\n"
  "-- +---------------------+-------+---------------+-------------+-------------+-------------+-----------+-------------"
  "---+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW io_by_thread_by_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  thread_id,\n"
  "  processlist_id\n"
  ")\n"
  "AS\n"
  "SELECT IF(processlist_id IS NULL, \n"
  "             SUBSTRING_INDEX(name, '/', -1), \n"
  "             CONCAT(processlist_user, '@', processlist_host)\n"
  "          ) user, \n"
  "       SUM(count_star) total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) min_latency,\n"
  "       format_pico_time(AVG(avg_timer_wait)) avg_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) max_latency,\n"
  "       thread_id,\n"
  "       processlist_id\n"
  "  FROM performance_schema.events_waits_summary_by_thread_by_event_name \n"
  "  LEFT JOIN performance_schema.threads USING (thread_id)\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND sum_timer_wait > 0\n"
  " GROUP BY thread_id, processlist_id, user\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$io_by_thread_by_latency\n"
  "--\n"
  "-- Show the top IO consumers by thread, ordered by total latency\n"
  "--\n"
  "-- mysql> select * from x$io_by_thread_by_latency;\n"
  "-- +---------------------+-------+----------------+-------------+-----------------+--------------+-----------+-------"
  "---------+\n"
  "-- | user                | total | total_latency  | min_latency | avg_latency     | max_latency  | thread_id | proces"
  "slist_id |\n"
  "-- +---------------------+-------+----------------+-------------+-----------------+--------------+-----------+-------"
  "---------+\n"
  "-- | root@localhost      | 11587 | 18007539905680 |      429780 | 1120831681.6667 | 181065665560 |        25 |       "
  "       6 |\n"
  "-- | main                |  1358 |  1309001741320 |      475020 | 2269581997.8000 | 350700491310 |         1 |       "
  "    NULL |\n"
  "-- | page_cleaner_thread |   654 |   147435455960 |      588120 |  225436198.0000 |  46412043990 |        18 |       "
  "    NULL |\n"
  "-- | io_write_thread     |   131 |   107754483070 |     8603140 |  822553303.0000 |  27691592500 |         8 |       "
  "    NULL |\n"
  "-- | io_write_thread     |    46 |    47074926860 |    10642710 | 1023367631.0000 |  16899745070 |         9 |       "
  "    NULL |\n"
  "-- | io_write_thread     |    71 |    46988801210 |     9108320 |  661814075.0000 |  17042760020 |        11 |       "
  "    NULL |\n"
  "-- | io_log_thread       |    20 |    21007710490 |    14250600 | 1050385336.0000 |   7081255090 |         3 |       "
  "    NULL |\n"
  "-- | srv_master_thread   |    13 |    17601511720 |     8486270 | 1353962324.0000 |   9990100380 |        16 |       "
  "    NULL |\n"
  "-- | srv_purge_thread    |     4 |     1809792270 |    34307000 |  452447879.0000 |   1018887740 |        17 |       "
  "    NULL |\n"
  "-- | io_write_thread     |    19 |      951385890 |     9745450 |   50072763.0000 |    297468080 |        10 |       "
  "    NULL |\n"
  "-- | signal_handler      |     3 |      218026640 |    21639800 |   72675421.0000 |    154841440 |        19 |       "
  "    NULL |\n"
  "-- +---------------------+-------+----------------+-------------+-----------------+--------------+-----------+-------"
  "---------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$io_by_thread_by_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  thread_id,\n"
  "  processlist_id\n"
  ")\n"
  "AS\n"
  "SELECT IF(processlist_id IS NULL, \n"
  "             SUBSTRING_INDEX(name, '/', -1), \n"
  "             CONCAT(processlist_user, '@', processlist_host)\n"
  "          ) user, \n"
  "       SUM(count_star) total,\n"
  "       SUM(sum_timer_wait) total_latency,\n"
  "       MIN(min_timer_wait) min_latency,\n"
  "       AVG(avg_timer_wait) avg_latency,\n"
  "       MAX(max_timer_wait) max_latency,\n"
  "       thread_id,\n"
  "       processlist_id\n"
  "  FROM performance_schema.events_waits_summary_by_thread_by_event_name \n"
  "  LEFT JOIN performance_schema.threads USING (thread_id)\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND sum_timer_wait > 0\n"
  " GROUP BY thread_id, processlist_id, user\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: io_global_by_file_by_bytes\n"
  "--\n"
  "-- Shows the top global IO consumers by bytes usage by file.\n"
  "--\n"
  "-- mysql> SELECT * FROM io_global_by_file_by_bytes LIMIT 5;\n"
  "-- +--------------------------------------------+------------+------------+-----------+-------------+---------------+"
  "-----------+------------+-----------+\n"
  "-- | file                                       | count_read | total_read | avg_read  | count_write | total_written |"
  " avg_write | total      | write_pct |\n"
  "-- +--------------------------------------------+------------+------------+-----------+-------------+---------------+"
  "-----------+------------+-----------+\n"
  "-- | @@datadir/ibdata1                          |        147 | 4.27 MiB   | 29.71 KiB |           3 | 48.00 KiB     |"
  " 16.00 KiB | 4.31 MiB   |      1.09 |\n"
  "-- | @@datadir/mysql/proc.MYD                   |        347 | 85.35 KiB  | 252 bytes |         111 | 19.08 KiB     |"
  " 176 bytes | 104.43 KiB |     18.27 |\n"
  "-- | @@datadir/ib_logfile0                      |          6 | 68.00 KiB  | 11.33 KiB |           8 | 4.00 KiB      |"
  " 512 bytes | 72.00 KiB  |      5.56 |\n"
  "-- | /opt/mysql/5.5.33/share/english/errmsg.sys |          3 | 43.68 KiB  | 14.56 KiB |           0 | 0 bytes       |"
  " 0 bytes   | 43.68 KiB  |      0.00 |\n"
  "-- | /opt/mysql/5.5.33/share/charsets/Index.xml |          1 | 17.89 KiB  | 17.89 KiB |           0 | 0 bytes       |"
  " 0 bytes   | 17.89 KiB  |      0.00 |\n"
  "-- +--------------------------------------------+------------+------------+-----------+-------------+---------------+"
  "-----------+------------+-----------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW io_global_by_file_by_bytes (\n"
  "  file,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_write,\n"
  "  total,\n"
  "  write_pct\n"
  ") AS\n"
  "SELECT sys.format_path(file_name) AS file, \n"
  "       count_read, \n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write, \n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0.00)) AS avg_write,\n"
  "       format_bytes(sum_number_of_bytes_read + sum_number_of_bytes_write) AS total, \n"
  "       IFNULL(ROUND(100-((sum_number_of_bytes_read/ NULLIF((sum_number_of_bytes_read+sum_number_of_bytes_write), 0))*"
  "100), 2), 0.00) AS write_pct \n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_number_of_bytes_read + sum_number_of_bytes_write DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$io_global_by_file_by_bytes\n"
  "--\n"
  "-- Shows the top global IO consumers by bytes usage by file.\n"
  "--\n"
  "-- mysql> SELECT * FROM x$io_global_by_file_by_bytes LIMIT 5;\n"
  "-- +------------------------------------------------------+------------+------------+------------+-------------+-----"
  "----------+------------+---------+-----------+\n"
  "-- | file                                                 | count_read | total_read | avg_read   | count_write | tota"
  "l_written | avg_write  | total   | write_pct |\n"
  "-- +------------------------------------------------------+------------+------------+------------+-------------+-----"
  "----------+------------+---------+-----------+\n"
  "-- | /Users/mark/sandboxes/msb_5_5_33/data/ibdata1        |        147 |    4472832 | 30427.4286 |           3 |     "
  "    49152 | 16384.0000 | 4521984 |      1.09 |\n"
  "-- | /Users/mark/sandboxes/msb_5_5_33/data/mysql/proc.MYD |        347 |      87397 |   251.8646 |         111 |     "
  "    19536 |   176.0000 |  106933 |     18.27 |\n"
  "-- | /Users/mark/sandboxes/msb_5_5_33/data/ib_logfile0    |          6 |      69632 | 11605.3333 |           8 |     "
  "     4096 |   512.0000 |   73728 |      5.56 |\n"
  "-- | /opt/mysql/5.5.33/share/english/errmsg.sys           |          3 |      44724 | 14908.0000 |           0 |     "
  "        0 |     0.0000 |   44724 |      0.00 |\n"
  "-- | /opt/mysql/5.5.33/share/charsets/Index.xml           |          1 |      18317 | 18317.0000 |           0 |     "
  "        0 |     0.0000 |   18317 |      0.00 |\n"
  "-- +------------------------------------------------------+------------+------------+------------+-------------+-----"
  "----------+------------+---------+-----------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$io_global_by_file_by_bytes (\n"
  "  file,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_write,\n"
  "  total,\n"
  "  write_pct\n"
  ") AS\n"
  "SELECT file_name AS file, \n"
  "       count_read, \n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write, \n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0.00) AS avg_write,\n"
  "       sum_number_of_bytes_read + sum_number_of_bytes_write AS total, \n"
  "       IFNULL(ROUND(100-((sum_number_of_bytes_read/ NULLIF((sum_number_of_bytes_read+sum_number_of_bytes_write), 0))*"
  "100), 2), 0.00) AS write_pct \n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_number_of_bytes_read + sum_number_of_bytes_write DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: io_global_by_file_by_latency\n"
  "--\n"
  "-- Shows the top global IO consumers by latency by file.\n"
  "--\n"
  "-- mysql> select * from io_global_by_file_by_latency limit 5;\n"
  "-- +-----------------------------------------------------------+-------+---------------+------------+--------------+-"
  "------------+---------------+------------+--------------+\n"
  "-- | file                                                      | total | total_latency | count_read | read_latency | "
  "count_write | write_latency | count_misc | misc_latency |\n"
  "-- +-----------------------------------------------------------+-------+---------------+------------+--------------+-"
  "------------+---------------+------------+--------------+\n"
  "-- | @@datadir/sys/wait_classes_global_by_avg_latency_raw.frm~ |    24 | 451.99 ms     |          0 | 0 ps         | "
  "          4 | 108.07 us     |         20 | 451.88 ms    |\n"
  "-- | @@datadir/sys/innodb_buffer_stats_by_schema_raw.frm~      |    24 | 379.84 ms     |          0 | 0 ps         | "
  "          4 | 108.88 us     |         20 | 379.73 ms    |\n"
  "-- | @@datadir/sys/io_by_thread_by_latency_raw.frm~            |    24 | 379.46 ms     |          0 | 0 ps         | "
  "          4 | 101.37 us     |         20 | 379.36 ms    |\n"
  "-- | @@datadir/ibtmp1                                          |    53 | 373.45 ms     |          0 | 0 ps         | "
  "         48 | 246.08 ms     |          5 | 127.37 ms    |\n"
  "-- | @@datadir/sys/statement_analysis_raw.frm~                 |    24 | 353.14 ms     |          0 | 0 ps         | "
  "          4 | 94.96 us      |         20 | 353.04 ms    |\n"
  "-- +-----------------------------------------------------------+-------+---------------+------------+--------------+-"
  "------------+---------------+------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW io_global_by_file_by_latency (\n"
  "  file,\n"
  "  total,\n"
  "  total_latency,\n"
  "  count_read,\n"
  "  read_latency,\n"
  "  count_write,\n"
  "  write_latency,\n"
  "  count_misc,\n"
  "  misc_latency\n"
  ") AS\n"
  "SELECT sys.format_path(file_name) AS file, \n"
  "       count_star AS total, \n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       count_read,\n"
  "       format_pico_time(sum_timer_read) AS read_latency,\n"
  "       count_write,\n"
  "       format_pico_time(sum_timer_write) AS write_latency,\n"
  "       count_misc,\n"
  "       format_pico_time(sum_timer_misc) AS misc_latency\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$io_global_by_file_by_latency\n"
  "--\n"
  "-- Shows the top global IO consumers by latency by file.\n"
  "--\n"
  "-- mysql> select * from x$io_global_by_file_by_latency limit 5;\n"
  "-- +--------------------------------------------------------------------------------------+-------+---------------+--"
  "----------+--------------+-------------+---------------+------------+--------------+\n"
  "-- | file                                                                                 | total | total_latency | c"
  "ount_read | read_latency | count_write | write_latency | count_misc | misc_latency |\n"
  "-- +--------------------------------------------------------------------------------------+-------+---------------+--"
  "----------+--------------+-------------+---------------+------------+--------------+\n"
  "-- | /Users/mark/sandboxes/msb_5_7_2/data/sys/wait_classes_global_by_avg_latency_raw.frm~ |    30 |  513959738110 |  "
  "        0 |            0 |           5 |     132130960 |         25 | 513827607150 |\n"
  "-- | /Users/mark/sandboxes/msb_5_7_2/data/sys/innodb_buffer_stats_by_schema_raw.frm~      |    30 |  490149888410 |  "
  "        0 |            0 |           5 |     483887040 |         25 | 489666001370 |\n"
  "-- | /Users/mark/sandboxes/msb_5_7_2/data/sys/io_by_thread_by_latency_raw.frm~            |    30 |  427724241620 |  "
  "        0 |            0 |           5 |     131399580 |         25 | 427592842040 |\n"
  "-- | /Users/mark/sandboxes/msb_5_7_2/data/sys/innodb_buffer_stats_by_schema.frm~          |    30 |  406392559950 |  "
  "        0 |            0 |           5 |     104082160 |         25 | 406288477790 |\n"
  "-- | /Users/mark/sandboxes/msb_5_7_2/data/sys/statement_analysis_raw.frm~                 |    30 |  395527510430 |  "
  "        0 |            0 |           5 |     118724840 |         25 | 395408785590 |\n"
  "-- +--------------------------------------------------------------------------------------+-------+---------------+--"
  "----------+--------------+-------------+---------------+------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$io_global_by_file_by_latency (\n"
  "  file,\n"
  "  total,\n"
  "  total_latency,\n"
  "  count_read,\n"
  "  read_latency,\n"
  "  count_write,\n"
  "  write_latency,\n"
  "  count_misc,\n"
  "  misc_latency\n"
  ") AS\n"
  "SELECT file_name AS file, \n"
  "       count_star AS total, \n"
  "       sum_timer_wait AS total_latency,\n"
  "       count_read,\n"
  "       sum_timer_read AS read_latency,\n"
  "       count_write,\n"
  "       sum_timer_write AS write_latency,\n"
  "       count_misc,\n"
  "       sum_timer_misc AS misc_latency\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: io_global_by_wait_by_bytes\n"
  "--\n"
  "-- Shows the top global IO consumer classes by bytes usage.\n"
  "--\n"
  "-- mysql> select * from io_global_by_wait_by_bytes;\n"
  "-- +--------------------+--------+---------------+-------------+-------------+-------------+------------+------------"
  "+-----------+-------------+---------------+-------------+-----------------+\n"
  "-- | event_name         | total  | total_latency | min_latency | avg_latency | max_latency | count_read | total_read "
  "| avg_read  | count_write | total_written | avg_written | total_requested |\n"
  "-- +--------------------+--------+---------------+-------------+-------------+-------------+------------+------------"
  "+-----------+-------------+---------------+-------------+-----------------+\n"
  "-- | myisam/dfile       | 163681 | 983.13 ms     | 379.08 ns   | 6.01 us     | 22.06 ms    |      68737 | 127.31 MiB "
  "| 1.90 KiB  |     1012221 | 121.52 MiB    | 126 bytes   | 248.83 MiB      |\n"
  "-- | myisam/kfile       |   1775 | 375.13 ms     | 1.02 us     | 211.34 us   | 35.15 ms    |      54066 | 9.97 MiB   "
  "| 193 bytes |      428257 | 12.40 MiB     | 30 bytes    | 22.37 MiB       |\n"
  "-- | sql/FRM            |  57889 | 8.40 s        | 19.44 ns    | 145.05 us   | 336.71 ms   |       8009 | 2.60 MiB   "
  "| 341 bytes |       14675 | 2.91 MiB      | 208 bytes   | 5.51 MiB        |\n"
  "-- | sql/global_ddl_log |    164 | 75.96 ms      | 5.72 us     | 463.19 us   | 7.43 ms     |         20 | 80.00 KiB  "
  "| 4.00 KiB  |          76 | 304.00 KiB    | 4.00 KiB    | 384.00 KiB      |\n"
  "-- | sql/file_parser    |    419 | 601.37 ms     | 1.96 us     | 1.44 ms     | 37.14 ms    |         66 | 42.01 KiB  "
  "| 652 bytes |          64 | 226.98 KiB    | 3.55 KiB    | 268.99 KiB      |\n"
  "-- | sql/binlog         |    190 | 6.79 s        | 1.56 us     | 35.76 ms    | 4.21 s      |         52 | 60.54 KiB  "
  "| 1.16 KiB  |           0 | 0 bytes       | 0 bytes     | 60.54 KiB       |\n"
  "-- | sql/ERRMSG         |      5 | 2.03 s        | 8.61 us     | 405.40 ms   | 2.03 s      |          3 | 51.82 KiB  "
  "| 17.27 KiB |           0 | 0 bytes       | 0 bytes     | 51.82 KiB       |\n"
  "-- | mysys/charset      |      3 | 196.52 us     | 17.61 us    | 65.51 us    | 137.33 us   |          1 | 17.83 KiB  "
  "| 17.83 KiB |           0 | 0 bytes       | 0 bytes     | 17.83 KiB       |\n"
  "-- | sql/partition      |     81 | 18.87 ms      | 888.08 ns   | 232.92 us   | 4.67 ms     |         66 | 2.75 KiB   "
  "| 43 bytes  |           8 | 288 bytes     | 36 bytes    | 3.04 KiB        |\n"
  "-- | sql/dbopt          | 329166 | 26.95 s       | 2.06 us     | 81.89 us    | 178.71 ms   |          0 | 0 bytes    "
  "| 0 bytes   |           9 | 585 bytes     | 65 bytes    | 585 bytes       |\n"
  "-- | sql/relaylog       |      7 | 1.18 ms       | 838.84 ns   | 168.30 us   | 892.70 us   |          0 | 0 bytes    "
  "| 0 bytes   |           1 | 120 bytes     | 120 bytes   | 120 bytes       |\n"
  "-- | mysys/cnf          |      5 | 171.61 us     | 303.26 ns   | 34.32 us    | 115.21 us   |          3 | 56 bytes   "
  "| 19 bytes  |           0 | 0 bytes       | 0 bytes     | 56 bytes        |\n"
  "-- | sql/pid            |      3 | 220.55 us     | 29.29 us    | 73.52 us    | 143.11 us   |          0 | 0 bytes    "
  "| 0 bytes   |           1 | 5 bytes       | 5 bytes     | 5 bytes         |\n"
  "-- | sql/casetest       |      1 | 121.19 us     | 121.19 us   | 121.19 us   | 121.19 us   |          0 | 0 bytes    "
  "| 0 bytes   |           0 | 0 bytes       | 0 bytes     | 0 bytes         |\n"
  "-- | sql/binlog_index   |      5 | 593.47 us     | 1.07 us     | 118.69 us   | 535.90 us   |          0 | 0 bytes    "
  "| 0 bytes   |           0 | 0 bytes       | 0 bytes     | 0 bytes         |\n"
  "-- | sql/misc           |     23 | 2.73 ms       | 65.14 us    | 118.50 us   | 255.31 us   |          0 | 0 bytes    "
  "| 0 bytes   |           0 | 0 bytes       | 0 bytes     | 0 bytes         |\n"
  "-- +--------------------+--------+---------------+-------------+-------------+-------------+------------+------------"
  "+-----------+-------------+---------------+-------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW io_global_by_wait_by_bytes (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written,\n"
  "  total_requested\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(min_timer_wait) AS min_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       count_read,\n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write,\n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0)) AS avg_written,\n"
  "       format_bytes(sum_number_of_bytes_write + sum_number_of_bytes_read) AS total_requested\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%' \n"
  "   AND count_star > 0\n"
  " ORDER BY sum_number_of_bytes_write + sum_number_of_bytes_read DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$io_global_by_wait_by_bytes\n"
  "--\n"
  "-- Shows the top global IO consumer classes by bytes usage.\n"
  "--\n"
  "-- mysql> select * from x$io_global_by_wait_by_bytes;\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+------------+-------"
  "-----+------------+-------------+---------------+-------------+-----------------+\n"
  "-- | event_name              | total | total_latency | min_latency | avg_latency | max_latency  | count_read | total_"
  "read | avg_read   | count_write | total_written | avg_written | total_requested |\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+------------+-------"
  "-----+------------+-------------+---------------+-------------+-----------------+\n"
  "-- | innodb/innodb_data_file |   151 |  334405721910 |     8399560 |  2214607429 | 107444600380 |        147 |    447"
  "2832 | 30427.4286 |           0 |             0 |      0.0000 |         4472832 |\n"
  "-- | sql/FRM                 |   555 |  147752034170 |      674830 |   266219881 |  57705900850 |        270 |     11"
  "2174 |   415.4593 |           0 |             0 |      0.0000 |          112174 |\n"
  "-- | innodb/innodb_log_file  |    22 |   56776429970 |     2476890 |  2580746816 |  18883021430 |          6 |      6"
  "9632 | 11605.3333 |           5 |          2560 |    512.0000 |           72192 |\n"
  "-- | sql/ERRMSG              |     5 |   11862056180 |    14883960 |  2372411236 |  11109473700 |          3 |      4"
  "4724 | 14908.0000 |           0 |             0 |      0.0000 |           44724 |\n"
  "-- | mysys/charset           |     3 |    7256869230 |    19796270 |  2418956410 |   7198498320 |          1 |      1"
  "8317 | 18317.0000 |           0 |             0 |      0.0000 |           18317 |\n"
  "-- | myisam/kfile            |   135 |   10194698280 |      784160 |    75516283 |   2593514950 |         40 |       "
  "9216 |   230.4000 |          33 |          1017 |     30.8182 |           10233 |\n"
  "-- | myisam/dfile            |    68 |   10527909730 |      772850 |   154822201 |   7600014630 |          9 |       "
  "6667 |   740.7778 |           0 |             0 |      0.0000 |            6667 |\n"
  "-- | sql/pid                 |     3 |     216507330 |    41296580 |    72169110 |    100617530 |          0 |       "
  "   0 |     0.0000 |           1 |             6 |      6.0000 |               6 |\n"
  "-- | sql/casetest            |     5 |     185261570 |     4105530 |    37052314 |    113488310 |          0 |       "
  "   0 |     0.0000 |           0 |             0 |      0.0000 |               0 |\n"
  "-- | sql/global_ddl_log      |     2 |      21538010 |     3121560 |    10769005 |     18416450 |          0 |       "
  "   0 |     0.0000 |           0 |             0 |      0.0000 |               0 |\n"
  "-- | sql/dbopt               |    10 |    1004267680 |     1164930 |   100426768 |    939894930 |          0 |       "
  "   0 |     0.0000 |           0 |             0 |      0.0000 |               0 |\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+------------+-------"
  "-----+------------+-------------+---------------+-------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$io_global_by_wait_by_bytes (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written,\n"
  "  total_requested\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       min_timer_wait AS min_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       count_read,\n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write,\n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0) AS avg_written,\n"
  "       sum_number_of_bytes_write + sum_number_of_bytes_read AS total_requested\n"
  "  FROM performance_schema.file_summary_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%' \n"
  "   AND count_star > 0\n"
  " ORDER BY sum_number_of_bytes_write + sum_number_of_bytes_read DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: io_global_by_wait_by_latency\n"
  "--\n"
  "-- Shows the top global IO consumers by latency.\n"
  "--\n"
  "-- mysql> SELECT * FROM io_global_by_wait_by_latency;\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+---------------+----"
  "----------+------------+------------+-----------+-------------+---------------+-------------+\n"
  "-- | event_name              | total | total_latency | avg_latency | max_latency | read_latency | write_latency | mis"
  "c_latency | count_read | total_read | avg_read  | count_write | total_written | avg_written |\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+---------------+----"
  "----------+------------+------------+-----------+-------------+---------------+-------------+\n"
  "-- | sql/file_parser         |  5433 | 30.20 s       | 5.56 ms     | 203.65 ms   | 22.08 ms     | 24.89 ms      | 30."
  "16 s      |         24 | 6.18 KiB   | 264 bytes |         737 | 2.15 MiB      | 2.99 KiB    |\n"
  "-- | innodb/innodb_data_file |  1344 | 1.52 s        | 1.13 ms     | 350.70 ms   | 203.82 ms    | 450.96 ms     | 868"
  ".21 ms    |        147 | 2.30 MiB   | 16.00 KiB |        1001 | 53.61 MiB     | 54.84 KiB   |\n"
  "-- | innodb/innodb_log_file  |   828 | 893.48 ms     | 1.08 ms     | 30.11 ms    | 16.32 ms     | 705.89 ms     | 171"
  ".27 ms    |          6 | 68.00 KiB  | 11.33 KiB |         413 | 2.19 MiB      | 5.42 KiB    |\n"
  "-- | myisam/kfile            |  7642 | 242.34 ms     | 31.71 us    | 19.27 ms    | 73.60 ms     | 23.48 ms      | 145"
  ".26 ms    |        758 | 135.63 KiB | 183 bytes |        4386 | 232.52 KiB    | 54 bytes    |\n"
  "-- | myisam/dfile            | 12540 | 223.47 ms     | 17.82 us    | 32.50 ms    | 87.76 ms     | 16.97 ms      | 118"
  ".74 ms    |       5390 | 4.49 MiB   | 873 bytes |        1448 | 2.65 MiB      | 1.88 KiB    |\n"
  "-- | csv/metadata            |     8 | 28.98 ms      | 3.62 ms     | 20.15 ms    | 399.27 us    | 0 ps          | 28."
  "58 ms     |          2 | 70 bytes   | 35 bytes  |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | mysys/charset           |     3 | 24.24 ms      | 8.08 ms     | 24.15 ms    | 24.15 ms     | 0 ps          | 93."
  "18 us     |          1 | 17.31 KiB  | 17.31 KiB |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | sql/ERRMSG              |     5 | 20.43 ms      | 4.09 ms     | 19.31 ms    | 20.32 ms     | 0 ps          | 103"
  ".20 us    |          3 | 58.97 KiB  | 19.66 KiB |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | mysys/cnf               |     5 | 11.37 ms      | 2.27 ms     | 11.28 ms    | 11.29 ms     | 0 ps          | 78."
  "22 us     |          3 | 56 bytes   | 19 bytes  |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | sql/dbopt               |    57 | 4.04 ms       | 70.92 us    | 843.70 us   | 0 ps         | 186.43 us     | 3.8"
  "6 ms      |          0 | 0 bytes    | 0 bytes   |           7 | 431 bytes     | 62 bytes    |\n"
  "-- | csv/data                |     4 | 411.55 us     | 102.89 us   | 234.89 us   | 0 ps         | 0 ps          | 411"
  ".55 us    |          0 | 0 bytes    | 0 bytes   |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | sql/misc                |    22 | 340.38 us     | 15.47 us    | 33.77 us    | 0 ps         | 0 ps          | 340"
  ".38 us    |          0 | 0 bytes    | 0 bytes   |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | archive/data            |    39 | 277.86 us     | 7.12 us     | 16.18 us    | 0 ps         | 0 ps          | 277"
  ".86 us    |          0 | 0 bytes    | 0 bytes   |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | sql/pid                 |     3 | 218.03 us     | 72.68 us    | 154.84 us   | 0 ps         | 21.64 us      | 196"
  ".39 us    |          0 | 0 bytes    | 0 bytes   |           1 | 6 bytes       | 6 bytes     |\n"
  "-- | sql/casetest            |     5 | 197.15 us     | 39.43 us    | 126.31 us   | 0 ps         | 0 ps          | 197"
  ".15 us    |          0 | 0 bytes    | 0 bytes   |           0 | 0 bytes       | 0 bytes     |\n"
  "-- | sql/global_ddl_log      |     2 | 14.60 us      | 7.30 us     | 12.12 us    | 0 ps         | 0 ps          | 14."
  "60 us     |          0 | 0 bytes    | 0 bytes   |           0 | 0 bytes       | 0 bytes     |\n"
  "-- +-------------------------+-------+---------------+-------------+-------------+--------------+---------------+----"
  "----------+------------+------------+-----------+-------------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW io_global_by_wait_by_latency (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  read_latency,\n"
  "  write_latency,\n"
  "  misc_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_timer_read) AS read_latency,\n"
  "       format_pico_time(sum_timer_write) AS write_latency,\n"
  "       format_pico_time(sum_timer_misc) AS misc_latency,\n"
  "       count_read,\n"
  "       format_bytes(sum_number_of_bytes_read) AS total_read,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0)) AS avg_read,\n"
  "       count_write,\n"
  "       format_bytes(sum_number_of_bytes_write) AS total_written,\n"
  "       format_bytes(IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0)) AS avg_written\n"
  "  FROM performance_schema.file_summary_by_event_name \n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$io_global_by_wait_by_latency\n"
  "--\n"
  "-- Shows the top global IO consumers by latency.\n"
  "--\n"
  "-- mysql> select * from x$io_global_by_wait_by_latency;\n"
  "-- +-------------------------+-------+----------------+-------------+--------------+--------------+---------------+--"
  "--------------+------------+------------+------------+-------------+---------------+-------------+\n"
  "-- | event_name              | total | total_latency  | avg_latency | max_latency  | read_latency | write_latency | m"
  "isc_latency   | count_read | total_read | avg_read   | count_write | total_written | avg_written |\n"
  "-- +-------------------------+-------+----------------+-------------+--------------+--------------+---------------+--"
  "--------------+------------+------------+------------+-------------+---------------+-------------+\n"
  "-- | sql/file_parser         |  5945 | 33615441247050 |  5654405471 | 203652881640 |  22093704230 |   27389668280 | 3"
  "3565957874540 |         26 |       7008 |   269.5385 |         808 |       2479209 |   3068.3280 |\n"
  "-- | sql/FRM                 |  6332 |  1755386796800 |   277224688 | 145624702340 | 519139578620 |    1677016640 |  "
  "1234570201540 |       2040 |     865905 |   424.4632 |         439 |        103445 |    235.6378 |\n"
  "-- | innodb/innodb_data_file |  1344 |  1522989889460 |  1133176798 | 350700491310 | 203817502460 |  450959403830 |  "
  " 868212983170 |        147 |    2408448 | 16384.0000 |        1001 |      56213504 |  56157.3467 |\n"
  "-- | innodb/innodb_log_file  |   828 |   893475794640 |  1079076921 |  30108124800 |  16315236730 |  705886928240 |  "
  " 171273629670 |          6 |      69632 | 11605.3333 |         413 |       2294272 |   5555.1380 |\n"
  "-- | myisam/kfile            |  7826 |   246001992860 |    31433883 |  19265276810 |  74419162870 |   23923730090 |  "
  " 147659099900 |        770 |     141058 |   183.1922 |        4516 |        249602 |     55.2706 |\n"
  "-- | myisam/dfile            | 13431 |   228191713620 |    16989882 |  32500163410 |  89162969350 |   17341973610 |  "
  " 121686770660 |       5819 |    4873176 |   837.4594 |        1577 |       2853444 |   1809.4128 |\n"
  "-- | csv/metadata            |     8 |    28975194560 |  3621899320 |  20148109020 |    399265620 |             0 |  "
  "  28575928940 |          2 |         70 |    35.0000 |           0 |             0 |      0.0000 |\n"
  "-- | mysys/charset           |     3 |    24244722970 |  8081574072 |  24151547420 |  24151547420 |             0 |  "
  "     93175550 |          1 |      17722 | 17722.0000 |           0 |             0 |      0.0000 |\n"
  "-- | sql/ERRMSG              |     5 |    20427386850 |  4085477370 |  19312386730 |  20324183100 |             0 |  "
  "    103203750 |          3 |      60390 | 20130.0000 |           0 |             0 |      0.0000 |\n"
  "-- | mysys/cnf               |     5 |    11366169230 |  2273233846 |  11283602460 |  11287953040 |             0 |  "
  "     78216190 |          3 |         56 |    18.6667 |           0 |             0 |      0.0000 |\n"
  "-- | sql/dbopt               |    57 |     4042348570 |    70918224 |    843703380 |            0 |     186430270 |  "
  "   3855918300 |          0 |          0 |     0.0000 |           7 |           431 |     61.5714 |\n"
  "-- | csv/data                |     4 |      411548280 |   102887070 |    234886080 |            0 |             0 |  "
  "    411548280 |          0 |          0 |     0.0000 |           0 |             0 |      0.0000 |\n"
  "-- | sql/misc                |    24 |      369128240 |    15380092 |     33771660 |            0 |             0 |  "
  "    369128240 |          0 |          0 |     0.0000 |           0 |             0 |      0.0000 |\n"
  "-- | archive/data            |    39 |      277856540 |     7124169 |     16180840 |            0 |             0 |  "
  "    277856540 |          0 |          0 |     0.0000 |           0 |             0 |      0.0000 |\n"
  "-- | sql/pid                 |     3 |      218026640 |    72675421 |    154841440 |            0 |      21639800 |  "
  "    196386840 |          0 |          0 |     0.0000 |           1 |             6 |      6.0000 |\n"
  "-- | sql/casetest            |     5 |      197152150 |    39430430 |    126310080 |            0 |             0 |  "
  "    197152150 |          0 |          0 |     0.0000 |           0 |             0 |      0.0000 |\n"
  "-- | sql/global_ddl_log      |     2 |       14604980 |     7302490 |     12120550 |            0 |             0 |  "
  "     14604980 |          0 |          0 |     0.0000 |           0 |             0 |      0.0000 |\n"
  "-- +-------------------------+-------+----------------+-------------+--------------+--------------+---------------+--"
  "--------------+------------+------------+------------+-------------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$io_global_by_wait_by_latency (\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency,\n"
  "  read_latency,\n"
  "  write_latency,\n"
  "  misc_latency,\n"
  "  count_read,\n"
  "  total_read,\n"
  "  avg_read,\n"
  "  count_write,\n"
  "  total_written,\n"
  "  avg_written\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name, '/', -2) AS event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_timer_read AS read_latency,\n"
  "       sum_timer_write AS write_latency,\n"
  "       sum_timer_misc AS misc_latency,\n"
  "       count_read,\n"
  "       sum_number_of_bytes_read AS total_read,\n"
  "       IFNULL(sum_number_of_bytes_read / NULLIF(count_read, 0), 0) AS avg_read,\n"
  "       count_write,\n"
  "       sum_number_of_bytes_write AS total_written,\n"
  "       IFNULL(sum_number_of_bytes_write / NULLIF(count_write, 0), 0) AS avg_written\n"
  "  FROM performance_schema.file_summary_by_event_name \n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  "   AND count_star > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2017, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: innodb_lock_waits\n"
  "--\n"
  "-- Give a snapshot of which InnoDB locks transactions are waiting for.\n"
  "-- The lock waits are ordered by the age of the lock descending.\n"
  "--\n"
  "-- Versions: 8.0+\n"
  "--\n"
  "-- mysql> select * from sys.innodb_lock_waits\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                 wait_started: 2017-01-24 14:25:39\n"
  "--                     wait_age: 00:00:02\n"
  "--                wait_age_secs: 2\n"
  "--                 locked_table: `test`.`t1`\n"
  "--          locked_table_schema: test\n"
  "--            locked_table_name: t1\n"
  "--       locked_table_partition: NULL\n"
  "--    locked_table_subpartition: NULL\n"
  "--                 locked_index: GEN_CLUST_INDEX\n"
  "--                  locked_type: RECORD\n"
  "--               waiting_trx_id: 2063\n"
  "--          waiting_trx_started: 2017-01-24 14:25:39\n"
  "--              waiting_trx_age: 00:00:02\n"
  "--      waiting_trx_rows_locked: 1\n"
  "--    waiting_trx_rows_modified: 0\n"
  "--                  waiting_pid: 6\n"
  "--                waiting_query: update test.t1 set j = j + sleep(100) where i = 1\n"
  "--              waiting_lock_id: 2063:61:5:2\n"
  "--            waiting_lock_mode: X\n"
  "--              blocking_trx_id: 2060\n"
  "--                 blocking_pid: 5\n"
  "--               blocking_query: update test.t1 set j = j + sleep(100) where i = 1\n"
  "--             blocking_lock_id: 2060:61:5:2\n"
  "--           blocking_lock_mode: X\n"
  "--         blocking_trx_started: 2017-01-24 14:24:19\n"
  "--             blocking_trx_age: 00:01:22\n"
  "--     blocking_trx_rows_locked: 1\n"
  "--   blocking_trx_rows_modified: 0\n"
  "--      sql_kill_blocking_query: KILL QUERY 5\n"
  "-- sql_kill_blocking_connection: KILL 5\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW innodb_lock_waits (\n"
  "  wait_started,\n"
  "  wait_age,\n"
  "  wait_age_secs,\n"
  "  locked_table,\n"
  "  locked_table_schema,\n"
  "  locked_table_name,\n"
  "  locked_table_partition,\n"
  "  locked_table_subpartition,\n"
  "  locked_index,\n"
  "  locked_type,\n"
  "  waiting_trx_id,\n"
  "  waiting_trx_started,\n"
  "  waiting_trx_age,\n"
  "  waiting_trx_rows_locked,\n"
  "  waiting_trx_rows_modified,\n"
  "  waiting_pid,\n"
  "  waiting_query,\n"
  "  waiting_lock_id,\n"
  "  waiting_lock_mode,\n"
  "  blocking_trx_id,\n"
  "  blocking_pid,\n"
  "  blocking_query,\n"
  "  blocking_lock_id,\n"
  "  blocking_lock_mode,\n"
  "  blocking_trx_started,\n"
  "  blocking_trx_age,\n"
  "  blocking_trx_rows_locked,\n"
  "  blocking_trx_rows_modified,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT r.trx_wait_started AS wait_started,\n"
  "       TIMEDIFF(NOW(), r.trx_wait_started) AS wait_age,\n"
  "       TIMESTAMPDIFF(SECOND, r.trx_wait_started, NOW()) AS wait_age_secs,\n"
  "       CONCAT(sys.quote_identifier(rl.object_schema), '.', sys.quote_identifier(rl.object_name)) AS locked_table,\n"
  "       rl.object_schema AS locked_table_schema,\n"
  "       rl.object_name AS locked_table_name,\n"
  "       rl.partition_name AS locked_table_partition,\n"
  "       rl.subpartition_name AS locked_table_subpartition,\n"
  "       rl.index_name AS locked_index,\n"
  "       rl.lock_type AS locked_type,\n"
  "       r.trx_id AS waiting_trx_id,\n"
  "       r.trx_started as waiting_trx_started,\n"
  "       TIMEDIFF(NOW(), r.trx_started) AS waiting_trx_age,\n"
  "       r.trx_rows_locked AS waiting_trx_rows_locked,\n"
  "       r.trx_rows_modified AS waiting_trx_rows_modified,\n"
  "       r.trx_mysql_thread_id AS waiting_pid,\n"
  "       sys.format_statement(r.trx_query) AS waiting_query,\n"
  "       rl.engine_lock_id AS waiting_lock_id,\n"
  "       rl.lock_mode AS waiting_lock_mode,\n"
  "       b.trx_id AS blocking_trx_id,\n"
  "       b.trx_mysql_thread_id AS blocking_pid,\n"
  "       sys.format_statement(b.trx_query) AS blocking_query,\n"
  "       bl.engine_lock_id AS blocking_lock_id,\n"
  "       bl.lock_mode AS blocking_lock_mode,\n"
  "       b.trx_started AS blocking_trx_started,\n"
  "       TIMEDIFF(NOW(), b.trx_started) AS blocking_trx_age,\n"
  "       b.trx_rows_locked AS blocking_trx_rows_locked,\n"
  "       b.trx_rows_modified AS blocking_trx_rows_modified,\n"
  "       CONCAT('KILL QUERY ', b.trx_mysql_thread_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', b.trx_mysql_thread_id) AS sql_kill_blocking_connection\n"
  "    FROM performance_schema.data_lock_waits w\n"
  " INNER JOIN information_schema.innodb_trx b  ON b.trx_id = CAST(w.blocking_engine_transaction_id AS CHAR)\n"
  " INNER JOIN information_schema.innodb_trx r  ON r.trx_id = CAST(w.requesting_engine_transaction_id AS CHAR)\n"
  " INNER JOIN performance_schema.data_locks bl ON bl.engine_lock_id = w.blocking_engine_lock_id\n"
  " INNER JOIN performance_schema.data_locks rl ON rl.engine_lock_id = w.requesting_engine_lock_id\n"
  " ORDER BY r.trx_wait_started;\n",
"-- Copyright (c) 2017, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$innodb_lock_waits\n"
  "--\n"
  "-- Give a snapshot of which InnoDB locks transactions are waiting for.\n"
  "-- The lock waits are ordered by the age of the lock descending.\n"
  "--\n"
  "-- Versions: 8.0+\n"
  "--\n"
  "-- mysql> select * from sys.x$innodb_lock_waits\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                 wait_started: 2017-01-24 14:25:39\n"
  "--                     wait_age: 00:00:08\n"
  "--                wait_age_secs: 8\n"
  "--                 locked_table: `test`.`t1`\n"
  "--          locked_table_schema: test\n"
  "--            locked_table_name: t1\n"
  "--       locked_table_partition: NULL\n"
  "--    locked_table_subpartition: NULL\n"
  "--                 locked_index: GEN_CLUST_INDEX\n"
  "--                  locked_type: RECORD\n"
  "--               waiting_trx_id: 2063\n"
  "--          waiting_trx_started: 2017-01-24 14:25:39\n"
  "--              waiting_trx_age: 00:00:08\n"
  "--      waiting_trx_rows_locked: 1\n"
  "--    waiting_trx_rows_modified: 0\n"
  "--                  waiting_pid: 6\n"
  "--                waiting_query: update test.t1 set j = j + sleep(100) where i = 1\n"
  "--              waiting_lock_id: 2063:61:5:2\n"
  "--            waiting_lock_mode: X\n"
  "--              blocking_trx_id: 2060\n"
  "--                 blocking_pid: 5\n"
  "--               blocking_query: update test.t1 set j = j + sleep(100) where i = 1\n"
  "--             blocking_lock_id: 2060:61:5:2\n"
  "--           blocking_lock_mode: X\n"
  "--         blocking_trx_started: 2017-01-24 14:24:19\n"
  "--             blocking_trx_age: 00:01:28\n"
  "--     blocking_trx_rows_locked: 1\n"
  "--   blocking_trx_rows_modified: 0\n"
  "--      sql_kill_blocking_query: KILL QUERY 5\n"
  "-- sql_kill_blocking_connection: KILL 5\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$innodb_lock_waits (\n"
  "  wait_started,\n"
  "  wait_age,\n"
  "  wait_age_secs,\n"
  "  locked_table,\n"
  "  locked_table_schema,\n"
  "  locked_table_name,\n"
  "  locked_table_partition,\n"
  "  locked_table_subpartition,\n"
  "  locked_index,\n"
  "  locked_type,\n"
  "  waiting_trx_id,\n"
  "  waiting_trx_started,\n"
  "  waiting_trx_age,\n"
  "  waiting_trx_rows_locked,\n"
  "  waiting_trx_rows_modified,\n"
  "  waiting_pid,\n"
  "  waiting_query,\n"
  "  waiting_lock_id,\n"
  "  waiting_lock_mode,\n"
  "  blocking_trx_id,\n"
  "  blocking_pid,\n"
  "  blocking_query,\n"
  "  blocking_lock_id,\n"
  "  blocking_lock_mode,\n"
  "  blocking_trx_started,\n"
  "  blocking_trx_age,\n"
  "  blocking_trx_rows_locked,\n"
  "  blocking_trx_rows_modified,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT r.trx_wait_started AS wait_started,\n"
  "       TIMEDIFF(NOW(), r.trx_wait_started) AS wait_age,\n"
  "       TIMESTAMPDIFF(SECOND, r.trx_wait_started, NOW()) AS wait_age_secs,\n"
  "       CONCAT(sys.quote_identifier(rl.object_schema), '.', sys.quote_identifier(rl.object_name)) AS locked_table,\n"
  "       rl.object_schema AS locked_table_schema,\n"
  "       rl.object_name AS locked_table_name,\n"
  "       rl.partition_name AS locked_table_partition,\n"
  "       rl.subpartition_name AS locked_table_subpartition,\n"
  "       rl.index_name AS locked_index,\n"
  "       rl.lock_type AS locked_type,\n"
  "       r.trx_id AS waiting_trx_id,\n"
  "       r.trx_started as waiting_trx_started,\n"
  "       TIMEDIFF(NOW(), r.trx_started) AS waiting_trx_age,\n"
  "       r.trx_rows_locked AS waiting_trx_rows_locked,\n"
  "       r.trx_rows_modified AS waiting_trx_rows_modified,\n"
  "       r.trx_mysql_thread_id AS waiting_pid,\n"
  "       r.trx_query AS waiting_query,\n"
  "       rl.engine_lock_id AS waiting_lock_id,\n"
  "       rl.lock_mode AS waiting_lock_mode,\n"
  "       b.trx_id AS blocking_trx_id,\n"
  "       b.trx_mysql_thread_id AS blocking_pid,\n"
  "       b.trx_query AS blocking_query,\n"
  "       bl.engine_lock_id AS blocking_lock_id,\n"
  "       bl.lock_mode AS blocking_lock_mode,\n"
  "       b.trx_started AS blocking_trx_started,\n"
  "       TIMEDIFF(NOW(), b.trx_started) AS blocking_trx_age,\n"
  "       b.trx_rows_locked AS blocking_trx_rows_locked,\n"
  "       b.trx_rows_modified AS blocking_trx_rows_modified,\n"
  "       CONCAT('KILL QUERY ', b.trx_mysql_thread_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', b.trx_mysql_thread_id) AS sql_kill_blocking_connection\n"
  "  FROM performance_schema.data_lock_waits w\n"
  " INNER JOIN information_schema.innodb_trx b  ON b.trx_id = CAST(w.blocking_engine_transaction_id AS CHAR)\n"
  " INNER JOIN information_schema.innodb_trx r  ON r.trx_id = CAST(w.requesting_engine_transaction_id AS CHAR)\n"
  " INNER JOIN performance_schema.data_locks bl ON bl.engine_lock_id = w.blocking_engine_lock_id\n"
  " INNER JOIN performance_schema.data_locks rl ON rl.engine_lock_id = w.requesting_engine_lock_id\n"
  " ORDER BY r.trx_wait_started;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: memory_by_user_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by user using the 5.7 Performance Schema instrumentation.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from memory_by_user_by_current_bytes;\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | user | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | total_allocated |\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | root |               1401 | 1.09 MiB          | 815 bytes         | 334.97 KiB        | 42.73 MiB       |\n"
  "-- | mark |                201 | 496.08 KiB        | 2.47 KiB          | 334.97 KiB        | 5.50 MiB        |\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW memory_by_user_by_current_bytes (\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_avg"
  "_alloc,\n"
  "       format_bytes(MAX(current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$memory_by_user_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by user\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from x$memory_by_user_by_current_bytes;\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | user | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | total_allocated |\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | root |               1399 |           1124553 |          803.8263 |            343008 |        45426133 |\n"
  "-- | mark |                201 |            507990 |         2527.3134 |            343008 |         5769804 |\n"
  "-- +------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$memory_by_user_by_current_bytes (\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       SUM(current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: memory_by_host_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by host using the 5.7 Performance Schema instrumentation.\n"
  "-- \n"
  "-- When the host found is NULL, it is assumed to be a local \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from memory_by_host_by_current_bytes;\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | host       | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | total_allocated |\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | background |               2773 | 10.84 MiB         | 4.00 KiB          | 8.00 MiB          | 30.69 MiB       |\n"
  "-- | localhost  |               1509 | 809.30 KiB        | 549 bytes         | 176.38 KiB        | 83.59 MiB       |\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW memory_by_host_by_current_bytes (\n"
  "  host,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_avg"
  "_alloc,\n"
  "       format_bytes(MAX(current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$memory_by_host_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by host\n"
  "-- \n"
  "-- When the host found is NULL, it is assumed to be a local \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from x$memory_by_host_by_current_bytes;\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | host       | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | total_allocated |\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "-- | background |               2773 |          11362444 |         4097.5276 |           8390792 |        32184183 |\n"
  "-- | localhost  |               1508 |            813040 |          539.1512 |            180616 |        88168182 |\n"
  "-- +------------+--------------------+-------------------+-------------------+-------------------+-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$memory_by_host_by_current_bytes (\n"
  "  host,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(current_count_used) AS current_count_used,\n"
  "       SUM(current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: memory_by_thread_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by user using the 5.7 Performance Schema instrumentation.\n"
  "-- \n"
  "-- User shows either the background or foreground user name appropriately.\n"
  "--\n"
  "-- mysql> select * from sys.memory_by_thread_by_current_bytes limit 5;\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "-- | thread_id | user           | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | to"
  "tal_allocated |\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "-- |         1 | sql/main       |              29333 | 166.02 MiB        | 5.80 KiB          | 131.13 MiB        | 19"
  "6.00 MiB      |\n"
  "-- |        55 | root@localhost |                175 | 1.04 MiB          | 6.09 KiB          | 350.86 KiB        | 67"
  ".37 MiB       |\n"
  "-- |        58 | root@localhost |                236 | 368.13 KiB        | 1.56 KiB          | 312.05 KiB        | 13"
  "0.34 MiB      |\n"
  "-- |       904 | root@localhost |                 32 | 18.00 KiB         | 576 bytes         | 16.00 KiB         | 6."
  "68 MiB        |\n"
  "-- |       970 | root@localhost |                 12 | 16.80 KiB         | 1.40 KiB          | 16.00 KiB         | 1."
  "20 MiB        |\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW memory_by_thread_by_current_bytes (\n"
  "  thread_id,\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT thread_id,\n"
  "       IF(t.name = 'thread/sql/one_connection', \n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host), \n"
  "          REPLACE(t.name, 'thread/', '')) user,\n"
  "       SUM(mt.current_count_used) AS current_count_used,\n"
  "       format_bytes(SUM(mt.current_number_of_bytes_used)) AS current_allocated,\n"
  "       format_bytes(IFNULL(SUM(mt.current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0)) AS current_"
  "avg_alloc,\n"
  "       format_bytes(MAX(mt.current_number_of_bytes_used)) AS current_max_alloc,\n"
  "       format_bytes(SUM(mt.sum_number_of_bytes_alloc)) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_thread_by_event_name AS mt\n"
  "  JOIN performance_schema.threads AS t USING (thread_id)\n"
  " GROUP BY thread_id, IF(t.name = 'thread/sql/one_connection', \n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host), \n"
  "          REPLACE(t.name, 'thread/', ''))\n"
  " ORDER BY SUM(current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$memory_by_thread_by_current_bytes\n"
  "--\n"
  "-- Summarizes memory use by user\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from sys.x$memory_by_thread_by_current_bytes limit 5;\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "-- | thread_id | user           | current_count_used | current_allocated | current_avg_alloc | current_max_alloc | to"
  "tal_allocated |\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "-- |         1 | sql/main       |              29333 |         174089450 |         5934.9351 |         137494528 |   "
  "    205523135 |\n"
  "-- |        55 | root@localhost |                173 |           1074664 |         6211.9306 |            359280 |   "
  "     72248413 |\n"
  "-- |        58 | root@localhost |                240 |            377099 |         1571.2458 |            319536 |   "
  "    169483870 |\n"
  "-- |      1152 | root@localhost |                 30 |             56949 |         1898.3000 |             16391 |   "
  "      1010024 |\n"
  "-- |      1154 | root@localhost |                 34 |             56369 |         1657.9118 |             16391 |   "
  "      1958771 |\n"
  "-- +-----------+----------------+--------------------+-------------------+-------------------+-------------------+---"
  "--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$memory_by_thread_by_current_bytes (\n"
  "  thread_id,\n"
  "  user,\n"
  "  current_count_used,\n"
  "  current_allocated,\n"
  "  current_avg_alloc,\n"
  "  current_max_alloc,\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT t.thread_id,\n"
  "       IF(t.name = 'thread/sql/one_connection', \n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host), \n"
  "          REPLACE(t.name, 'thread/', '')) user,\n"
  "       SUM(mt.current_count_used) AS current_count_used,\n"
  "       SUM(mt.current_number_of_bytes_used) AS current_allocated,\n"
  "       IFNULL(SUM(mt.current_number_of_bytes_used) / NULLIF(SUM(current_count_used), 0), 0) AS current_avg_alloc,\n"
  "       MAX(mt.current_number_of_bytes_used) AS current_max_alloc,\n"
  "       SUM(mt.sum_number_of_bytes_alloc) AS total_allocated\n"
  "  FROM performance_schema.memory_summary_by_thread_by_event_name AS mt\n"
  "  JOIN performance_schema.threads AS t USING (thread_id)\n"
  " GROUP BY thread_id, IF(t.name = 'thread/sql/one_connection', \n"
  "          CONCAT(t.processlist_user, '@', t.processlist_host), \n"
  "          REPLACE(t.name, 'thread/', ''))\n"
  " ORDER BY SUM(mt.current_number_of_bytes_used) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: memory_global_by_current_bytes\n"
  "-- \n"
  "-- Shows the current memory usage within the server globally broken down by allocation type.\n"
  "--\n"
  "-- mysql> select * from memory_global_by_current_bytes;\n"
  "-- +-------------------------------------------------+---------------+---------------+-------------------+-----------"
  "-+-------------+----------------+\n"
  "-- | event_name                                      | current_count | current_alloc | current_avg_alloc | high_count"
  " | high_alloc  | high_avg_alloc |\n"
  "-- +-------------------------------------------------+---------------+---------------+-------------------+-----------"
  "-+-------------+----------------+\n"
  "-- | memory/performance_schema/internal_buffers      |            62 | 293.80 MiB    | 4.74 MiB          |         62"
  " | 293.80 MiB  | 4.74 MiB       |\n"
  "-- | memory/innodb/buf_buf_pool                      |             1 | 131.06 MiB    | 131.06 MiB        |          1"
  " | 131.06 MiB  | 131.06 MiB     |\n"
  "-- | memory/innodb/log0log                           |             9 | 8.01 MiB      | 911.15 KiB        |          9"
  " | 8.01 MiB    | 911.15 KiB     |\n"
  "-- | memory/mysys/KEY_CACHE                          |             3 | 8.00 MiB      | 2.67 MiB          |          3"
  " | 8.00 MiB    | 2.67 MiB       |\n"
  "-- | memory/innodb/hash0hash                         |            27 | 4.73 MiB      | 179.51 KiB        |         27"
  " | 6.84 MiB    | 259.47 KiB     |\n"
  "-- | memory/innodb/os0event                          |         24998 | 4.01 MiB      | 168 bytes         |      24998"
  " | 4.01 MiB    | 168 bytes      |\n"
  "-- ...\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW memory_global_by_current_bytes (\n"
  "  event_name,\n"
  "  current_count,\n"
  "  current_alloc,\n"
  "  current_avg_alloc,\n"
  "  high_count,\n"
  "  high_alloc,\n"
  "  high_avg_alloc\n"
  ") AS\n"
  "SELECT event_name,\n"
  "       current_count_used AS current_count,\n"
  "       format_bytes(current_number_of_bytes_used) AS current_alloc,\n"
  "       format_bytes(IFNULL(current_number_of_bytes_used / NULLIF(current_count_used, 0), 0)) AS current_avg_alloc,\n"
  "       high_count_used AS high_count,\n"
  "       format_bytes(high_number_of_bytes_used) AS high_alloc,\n"
  "       format_bytes(IFNULL(high_number_of_bytes_used / NULLIF(high_count_used, 0), 0)) AS high_avg_alloc\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  " WHERE current_number_of_bytes_used > 0\n"
  " ORDER BY current_number_of_bytes_used DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$memory_global_by_current_bytes\n"
  "-- \n"
  "-- Shows the current memory usage within the server globally broken down by allocation type.\n"
  "--\n"
  "-- mysql> select * from x$memory_global_by_current_bytes;\n"
  "-- +-------------------------------------------------+---------------+---------------+-------------------+-----------"
  "-+------------+----------------+\n"
  "-- | event_name                                      | current_count | current_alloc | current_avg_alloc | high_count"
  " | high_alloc | high_avg_alloc |\n"
  "-- +-------------------------------------------------+---------------+---------------+-------------------+-----------"
  "-+------------+----------------+\n"
  "-- | memory/performance_schema/internal_buffers      |            62 |     308073712 |      4968930.8387 |         62"
  " |  308073712 |   4968930.8387 |\n"
  "-- | memory/innodb/buf_buf_pool                      |             1 |     137428992 |    137428992.0000 |          1"
  " |  137428992 | 137428992.0000 |\n"
  "-- | memory/innodb/log0log                           |             9 |       8397152 |       933016.8889 |          9"
  " |    8397152 |    933016.8889 |\n"
  "-- | memory/mysys/KEY_CACHE                          |             3 |       8390792 |      2796930.6667 |          3"
  " |    8390792 |   2796930.6667 |\n"
  "-- | memory/innodb/hash0hash                         |            27 |       4962992 |       183814.5185 |         27"
  " |    7173904 |    265700.1481 |\n"
  "-- | memory/innodb/os0event                          |         24998 |       4199664 |          168.0000 |      24998"
  " |    4199664 |       168.0000 |\n"
  "-- ...\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$memory_global_by_current_bytes (\n"
  "  event_name,\n"
  "  current_count,\n"
  "  current_alloc,\n"
  "  current_avg_alloc,\n"
  "  high_count,\n"
  "  high_alloc,\n"
  "  high_avg_alloc\n"
  ") AS\n"
  "SELECT event_name,\n"
  "       current_count_used AS current_count,\n"
  "       current_number_of_bytes_used AS current_alloc,\n"
  "       IFNULL(current_number_of_bytes_used / NULLIF(current_count_used, 0), 0) AS current_avg_alloc,\n"
  "       high_count_used AS high_count,\n"
  "       high_number_of_bytes_used AS high_alloc,\n"
  "       IFNULL(high_number_of_bytes_used / NULLIF(high_count_used, 0), 0) AS high_avg_alloc\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  " WHERE current_number_of_bytes_used > 0\n"
  " ORDER BY current_number_of_bytes_used DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: memory_global_total\n"
  "-- \n"
  "-- Shows the total memory usage within the server globally.\n"
  "--\n"
  "-- mysql> select * from memory_global_total;\n"
  "-- +-----------------+\n"
  "-- | total_allocated |\n"
  "-- +-----------------+\n"
  "-- | 123.35 MiB      |\n"
  "-- +-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW memory_global_total (\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT format_bytes(SUM(CURRENT_NUMBER_OF_BYTES_USED)) total_allocated\n"
  "  FROM performance_schema.memory_summary_global_by_event_name;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$memory_global_total\n"
  "-- \n"
  "-- Shows the total memory usage within the server globally\n"
  "--\n"
  "-- mysql> select * from x$memory_global_total;\n"
  "-- +-----------------+\n"
  "-- | total_allocated |\n"
  "-- +-----------------+\n"
  "-- |         1420023 |\n"
  "-- +-----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$memory_global_total (\n"
  "  total_allocated\n"
  ") AS\n"
  "SELECT SUM(CURRENT_NUMBER_OF_BYTES_USED) total_allocated\n"
  "  FROM performance_schema.memory_summary_global_by_event_name;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: schema_index_statistics\n"
  "--\n"
  "-- Statistics around indexes.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top indexes are most contended.\n"
  "--\n"
  "-- mysql> select * from schema_index_statistics limit 5;\n"
  "-- +------------------+-------------+------------+---------------+----------------+---------------+----------------+-"
  "-------------+----------------+--------------+----------------+\n"
  "-- | table_schema     | table_name  | index_name | rows_selected | select_latency | rows_inserted | insert_latency | "
  "rows_updated | update_latency | rows_deleted | delete_latency |\n"
  "-- +------------------+-------------+------------+---------------+----------------+---------------+----------------+-"
  "-------------+----------------+--------------+----------------+\n"
  "-- | mem              | mysqlserver | PRIMARY    |          6208 | 108.27 ms      |             0 | 0 ps           | "
  "        5470 | 1.47 s         |            0 | 0 ps           |\n"
  "-- | mem              | innodb      | PRIMARY    |          4666 | 76.27 ms       |             0 | 0 ps           | "
  "        4454 | 571.47 ms      |            0 | 0 ps           |\n"
  "-- | mem              | connection  | PRIMARY    |          1064 | 20.98 ms       |             0 | 0 ps           | "
  "        1064 | 457.30 ms      |            0 | 0 ps           |\n"
  "-- | mem              | environment | PRIMARY    |          5566 | 151.17 ms      |             0 | 0 ps           | "
  "         694 | 252.57 ms      |            0 | 0 ps           |\n"
  "-- | mem              | querycache  | PRIMARY    |          1698 | 27.99 ms       |             0 | 0 ps           | "
  "        1698 | 371.72 ms      |            0 | 0 ps           |\n"
  "-- +------------------+-------------+------------+---------------+----------------+---------------+----------------+-"
  "-------------+----------------+--------------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_index_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  rows_selected,\n"
  "  select_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency\n"
  ") AS\n"
  "SELECT OBJECT_SCHEMA AS table_schema,\n"
  "       OBJECT_NAME AS table_name,\n"
  "       INDEX_NAME as index_name,\n"
  "       COUNT_FETCH AS rows_selected,\n"
  "       format_pico_time(SUM_TIMER_FETCH) AS select_latency,\n"
  "       COUNT_INSERT AS rows_inserted,\n"
  "       format_pico_time(SUM_TIMER_INSERT) AS insert_latency,\n"
  "       COUNT_UPDATE AS rows_updated,\n"
  "       format_pico_time(SUM_TIMER_UPDATE) AS update_latency,\n"
  "       COUNT_DELETE AS rows_deleted,\n"
  "       format_pico_time(SUM_TIMER_DELETE) AS delete_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NOT NULL\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$schema_index_statistics\n"
  "--\n"
  "-- Statistics around indexes.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top indexes are most contended.\n"
  "--\n"
  "-- mysql> SELECT * FROM x$schema_index_statistics LIMIT 5;\n"
  "-- +---------------+----------------------+-------------------+---------------+----------------+---------------+-----"
  "-----------+--------------+----------------+--------------+----------------+\n"
  "-- | table_schema  | table_name           | index_name        | rows_selected | select_latency | rows_inserted | inse"
  "rt_latency | rows_updated | update_latency | rows_deleted | delete_latency |\n"
  "-- +---------------+----------------------+-------------------+---------------+----------------+---------------+-----"
  "-----------+--------------+----------------+--------------+----------------+\n"
  "-- | common_schema | _global_sql_tokens   | PRIMARY           |          1886 |     1129676730 |             0 |     "
  "         0 |            0 |              0 |         1878 |              0 |\n"
  "-- | common_schema | _script_statements   | PRIMARY           |          4606 |     4212160680 |             0 |     "
  "         0 |            0 |              0 |            0 |              0 |\n"
  "-- | common_schema | _global_qs_variables | declaration_depth |           256 |     1650193090 |             0 |     "
  "         0 |           32 |     1372148050 |            0 |              0 |\n"
  "-- | common_schema | _global_qs_variables | PRIMARY           |             0 |              0 |             0 |     "
  "         0 |            0 |              0 |           16 |              0 |\n"
  "-- | common_schema | metadata             | PRIMARY           |             5 |       76730810 |             0 |     "
  "         0 |            4 |      114310170 |            0 |              0 |\n"
  "-- +---------------+----------------------+-------------------+---------------+----------------+---------------+-----"
  "-----------+--------------+----------------+--------------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$schema_index_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  index_name,\n"
  "  rows_selected,\n"
  "  select_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency\n"
  ") AS\n"
  "SELECT OBJECT_SCHEMA AS table_schema,\n"
  "       OBJECT_NAME AS table_name,\n"
  "       INDEX_NAME as index_name,\n"
  "       COUNT_FETCH AS rows_selected,\n"
  "       SUM_TIMER_FETCH AS select_latency,\n"
  "       COUNT_INSERT AS rows_inserted,\n"
  "       SUM_TIMER_INSERT AS insert_latency,\n"
  "       COUNT_UPDATE AS rows_updated,\n"
  "       SUM_TIMER_UPDATE AS update_latency,\n"
  "       COUNT_DELETE AS rows_deleted,\n"
  "       SUM_TIMER_DELETE AS delete_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  " WHERE index_name IS NOT NULL\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$ps_schema_table_statistics_io\n"
  "--\n"
  "-- Helper view for schema_table_statistics\n"
  "-- Having this view with ALGORITHM = TEMPTABLE means MySQL can use the optimizations for\n"
  "-- materialized views to improve the overall performance.\n"
  "--\n"
  "-- mysql> SELECT * FROM x$ps_schema_table_statistics_io LIMIT 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--              table_schema: charsets\n"
  "--                table_name: Index\n"
  "--                count_read: 1\n"
  "--  sum_number_of_bytes_read: 18710\n"
  "--            sum_timer_read: 20229409070\n"
  "--               count_write: 0\n"
  "-- sum_number_of_bytes_write: 0\n"
  "--           sum_timer_write: 0\n"
  "--                count_misc: 2\n"
  "--            sum_timer_misc: 80768480\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$ps_schema_table_statistics_io (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  count_read,\n"
  "  sum_number_of_bytes_read,\n"
  "  sum_timer_read,\n"
  "  count_write,\n"
  "  sum_number_of_bytes_write,\n"
  "  sum_timer_write,\n"
  "  count_misc,\n"
  "  sum_timer_misc\n"
  ") AS\n"
  "SELECT extract_schema_from_file_name(file_name) AS table_schema,\n"
  "       extract_table_from_file_name(file_name) AS table_name,\n"
  "       SUM(count_read) AS count_read,\n"
  "       SUM(sum_number_of_bytes_read) AS sum_number_of_bytes_read,\n"
  "       SUM(sum_timer_read) AS sum_timer_read,\n"
  "       SUM(count_write) AS count_write,\n"
  "       SUM(sum_number_of_bytes_write) AS sum_number_of_bytes_write,\n"
  "       SUM(sum_timer_write) AS sum_timer_write,\n"
  "       SUM(count_misc) AS count_misc,\n"
  "       SUM(sum_timer_misc) AS sum_timer_misc\n"
  "  FROM performance_schema.file_summary_by_instance\n"
  " GROUP BY table_schema, table_name;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: schema_table_statistics\n"
  "--\n"
  "-- Statistics around tables.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top tables are most contended.\n"
  "-- \n"
  "-- mysql> SELECT * FROM schema_table_statistics\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--      table_schema: sys\n"
  "--        table_name: sys_config\n"
  "--     total_latency: 0 ps\n"
  "--      rows_fetched: 0\n"
  "--     fetch_latency: 0 ps\n"
  "--     rows_inserted: 0\n"
  "--    insert_latency: 0 ps\n"
  "--      rows_updated: 0\n"
  "--    update_latency: 0 ps\n"
  "--      rows_deleted: 0\n"
  "--    delete_latency: 0 ps\n"
  "--  io_read_requests: 8\n"
  "--           io_read: 2.28 KiB\n"
  "--   io_read_latency: 727.32 us\n"
  "-- io_write_requests: 0\n"
  "--          io_write: 0 bytes\n"
  "--  io_write_latency: 0 ps\n"
  "--  io_misc_requests: 10\n"
  "--   io_misc_latency: 126.88 us\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_table_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  total_latency,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       format_pico_time(pst.sum_timer_wait) AS total_latency,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       format_pico_time(pst.sum_timer_fetch) AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       format_pico_time(pst.sum_timer_insert) AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       format_pico_time(pst.sum_timer_update) AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       format_pico_time(pst.sum_timer_delete) AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_read) AS io_read,\n"
  "       format_pico_time(fsbi.sum_timer_read) AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_write) AS io_write,\n"
  "       format_pico_time(fsbi.sum_timer_write) AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       format_pico_time(fsbi.sum_timer_misc) AS io_misc_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$schema_table_statistics\n"
  "--\n"
  "-- Statistics around tables.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top tables are most contended.\n"
  "-- \n"
  "-- mysql> select * from x$schema_table_statistics\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--      table_schema: sys\n"
  "--        table_name: sys_config\n"
  "--     total_latency: 0\n"
  "--      rows_fetched: 0\n"
  "--     fetch_latency: 0\n"
  "--     rows_inserted: 0\n"
  "--    insert_latency: 0\n"
  "--      rows_updated: 0\n"
  "--    update_latency: 0\n"
  "--      rows_deleted: 0\n"
  "--    delete_latency: 0\n"
  "--  io_read_requests: 8\n"
  "--           io_read: 2336\n"
  "--   io_read_latency: 727319710\n"
  "-- io_write_requests: 0\n"
  "--          io_write: 0\n"
  "--  io_write_latency: 0\n"
  "--  io_misc_requests: 10\n"
  "--   io_misc_latency: 126879350\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$schema_table_statistics (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  total_latency,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.sum_timer_wait AS total_latency,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       pst.sum_timer_fetch AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       pst.sum_timer_insert AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       pst.sum_timer_update AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       pst.sum_timer_delete AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       fsbi.sum_number_of_bytes_read AS io_read,\n"
  "       fsbi.sum_timer_read AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       fsbi.sum_number_of_bytes_write AS io_write,\n"
  "       fsbi.sum_timer_write AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       fsbi.sum_timer_misc AS io_misc_latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: schema_table_statistics_with_buffer\n"
  "--\n"
  "-- Statistics around tables.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top tables are most contended.\n"
  "--\n"
  "-- More statistics such as caching stats for the InnoDB buffer pool with InnoDB tables\n"
  "--\n"
  "-- mysql> select * from schema_table_statistics_with_buffer limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                  table_schema: mem\n"
  "--                    table_name: mysqlserver\n"
  "--                  rows_fetched: 27087\n"
  "--                 fetch_latency: 442.72 ms\n"
  "--                 rows_inserted: 2\n"
  "--                insert_latency: 185.04 us \n"
  "--                  rows_updated: 5096\n"
  "--                update_latency: 1.39 s\n"
  "--                  rows_deleted: 0\n"
  "--                delete_latency: 0 ps\n"
  "--              io_read_requests: 2565\n"
  "--                 io_read_bytes: 1121627\n"
  "--               io_read_latency: 10.07 ms\n"
  "--             io_write_requests: 1691\n"
  "--                io_write_bytes: 128383\n"
  "--              io_write_latency: 14.17 ms\n"
  "--              io_misc_requests: 2698\n"
  "--               io_misc_latency: 433.66 ms\n"
  "--           innodb_buffer_pages: 19\n"
  "--    innodb_buffer_pages_hashed: 19\n"
  "--       innodb_buffer_pages_old: 19\n"
  "-- innodb_buffer_bytes_allocated: 311296\n"
  "--      innodb_buffer_bytes_data: 1924\n"
  "--     innodb_buffer_rows_cached: 2\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_table_statistics_with_buffer (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency,\n"
  "  innodb_buffer_allocated,\n"
  "  innodb_buffer_data,\n"
  "  innodb_buffer_free,\n"
  "  innodb_buffer_pages,\n"
  "  innodb_buffer_pages_hashed,\n"
  "  innodb_buffer_pages_old,\n"
  "  innodb_buffer_rows_cached\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       format_pico_time(pst.sum_timer_fetch) AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       format_pico_time(pst.sum_timer_insert) AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       format_pico_time(pst.sum_timer_update) AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       format_pico_time(pst.sum_timer_delete) AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_read) AS io_read,\n"
  "       format_pico_time(fsbi.sum_timer_read) AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       format_bytes(fsbi.sum_number_of_bytes_write) AS io_write,\n"
  "       format_pico_time(fsbi.sum_timer_write) AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       format_pico_time(fsbi.sum_timer_misc) AS io_misc_latency,\n"
  "       format_bytes(ibp.allocated) AS innodb_buffer_allocated,\n"
  "       format_bytes(ibp.data) AS innodb_buffer_data,\n"
  "       format_bytes(ibp.allocated - ibp.data) AS innodb_buffer_free,\n"
  "       ibp.pages AS innodb_buffer_pages,\n"
  "       ibp.pages_hashed AS innodb_buffer_pages_hashed,\n"
  "       ibp.pages_old AS innodb_buffer_pages_old,\n"
  "       ibp.rows_cached AS innodb_buffer_rows_cached\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  "  LEFT JOIN sys.x$innodb_buffer_stats_by_table AS ibp\n"
  "    ON pst.object_schema = ibp.object_schema\n"
  "   AND pst.object_name = ibp.object_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$schema_table_statistics_with_buffer\n"
  "--\n"
  "-- Statistics around tables.\n"
  "--\n"
  "-- Ordered by the total wait time descending - top tables are most contended.\n"
  "--\n"
  "-- More statistics such as caching stats for the InnoDB buffer pool with InnoDB tables\n"
  "--\n"
  "-- mysql> SELECT * FROM x$schema_table_statistics_with_buffer LIMIT 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--               table_schema: common_schema\n"
  "--                 table_name: help_content\n"
  "--               rows_fetched: 0\n"
  "--              fetch_latency: 0\n"
  "--              rows_inserted: 169\n"
  "--             insert_latency: 409815527680\n"
  "--               rows_updated: 0\n"
  "--             update_latency: 0\n"
  "--               rows_deleted: 0\n"
  "--             delete_latency: 0\n"
  "--           io_read_requests: 14\n"
  "--                    io_read: 1180\n"
  "--            io_read_latency: 52406770\n"
  "--          io_write_requests: 131\n"
  "--                   io_write: 11719246\n"
  "--           io_write_latency: 133726902790\n"
  "--           io_misc_requests: 61\n"
  "--            io_misc_latency: 209081089750\n"
  "--    innodb_buffer_allocated: 688128\n"
  "--         innodb_buffer_data: 423667\n"
  "--        innodb_buffer_pages: 42\n"
  "-- innodb_buffer_pages_hashed: 42\n"
  "--    innodb_buffer_pages_old: 42\n"
  "--  innodb_buffer_rows_cached: 210\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$schema_table_statistics_with_buffer (\n"
  "  table_schema,\n"
  "  table_name,\n"
  "  rows_fetched,\n"
  "  fetch_latency,\n"
  "  rows_inserted,\n"
  "  insert_latency,\n"
  "  rows_updated,\n"
  "  update_latency,\n"
  "  rows_deleted,\n"
  "  delete_latency,\n"
  "  io_read_requests,\n"
  "  io_read,\n"
  "  io_read_latency,\n"
  "  io_write_requests,\n"
  "  io_write,\n"
  "  io_write_latency,\n"
  "  io_misc_requests,\n"
  "  io_misc_latency,\n"
  "  innodb_buffer_allocated,\n"
  "  innodb_buffer_data,\n"
  "  innodb_buffer_free,\n"
  "  innodb_buffer_pages,\n"
  "  innodb_buffer_pages_hashed,\n"
  "  innodb_buffer_pages_old,\n"
  "  innodb_buffer_rows_cached\n"
  ") AS\n"
  "SELECT pst.object_schema AS table_schema,\n"
  "       pst.object_name AS table_name,\n"
  "       pst.count_fetch AS rows_fetched,\n"
  "       pst.sum_timer_fetch AS fetch_latency,\n"
  "       pst.count_insert AS rows_inserted,\n"
  "       pst.sum_timer_insert AS insert_latency,\n"
  "       pst.count_update AS rows_updated,\n"
  "       pst.sum_timer_update AS update_latency,\n"
  "       pst.count_delete AS rows_deleted,\n"
  "       pst.sum_timer_delete AS delete_latency,\n"
  "       fsbi.count_read AS io_read_requests,\n"
  "       fsbi.sum_number_of_bytes_read AS io_read,\n"
  "       fsbi.sum_timer_read AS io_read_latency,\n"
  "       fsbi.count_write AS io_write_requests,\n"
  "       fsbi.sum_number_of_bytes_write AS io_write,\n"
  "       fsbi.sum_timer_write AS io_write_latency,\n"
  "       fsbi.count_misc AS io_misc_requests,\n"
  "       fsbi.sum_timer_misc AS io_misc_latency,\n"
  "       ibp.allocated AS innodb_buffer_allocated,\n"
  "       ibp.data AS innodb_buffer_data,\n"
  "       (ibp.allocated - ibp.data) AS innodb_buffer_free,\n"
  "       ibp.pages AS innodb_buffer_pages,\n"
  "       ibp.pages_hashed AS innodb_buffer_pages_hashed,\n"
  "       ibp.pages_old AS innodb_buffer_pages_old,\n"
  "       ibp.rows_cached AS innodb_buffer_rows_cached\n"
  "  FROM performance_schema.table_io_waits_summary_by_table AS pst\n"
  "  LEFT JOIN x$ps_schema_table_statistics_io AS fsbi\n"
  "    ON pst.object_schema = fsbi.table_schema\n"
  "   AND pst.object_name = fsbi.table_name\n"
  "  LEFT JOIN sys.x$innodb_buffer_stats_by_table AS ibp\n"
  "    ON pst.object_schema = ibp.object_schema\n"
  "   AND pst.object_name = ibp.object_name\n"
  " ORDER BY pst.sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: schema_tables_with_full_table_scans\n"
  "--\n"
  "-- Find tables that are being accessed by full table scans\n"
  "-- ordering by the number of rows scanned descending.\n"
  "--\n"
  "-- mysql> select * from schema_tables_with_full_table_scans limit 5;\n"
  "-- +--------------------+--------------------------------+-------------------+-----------+\n"
  "-- | object_schema      | object_name                    | rows_full_scanned | latency   |\n"
  "-- +--------------------+--------------------------------+-------------------+-----------+\n"
  "-- | mem30__instruments | fsstatistics                   |          10207042 | 13.10 s   |\n"
  "-- | mem30__instruments | preparedstatementapidata       |            436428 | 973.27 ms |\n"
  "-- | mem30__instruments | mysqlprocessactivity           |            411702 | 282.07 ms |\n"
  "-- | mem30__instruments | querycachequeriesincachedata   |            374011 | 767.15 ms |\n"
  "-- | mem30__instruments | rowaccessesdata                |            322321 | 1.55 s    |\n"
  "-- +--------------------+--------------------------------+-------------------+-----------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_tables_with_full_table_scans (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  rows_full_scanned,\n"
  "  latency\n"
  ") AS\n"
  "SELECT object_schema, \n"
  "       object_name,\n"
  "       count_read AS rows_full_scanned,\n"
  "       format_pico_time(sum_timer_wait) AS latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage \n"
  " WHERE index_name IS NULL\n"
  "   AND count_read > 0\n"
  " ORDER BY count_read DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$schema_tables_with_full_table_scans\n"
  "--\n"
  "-- Find tables that are being accessed by full table scans\n"
  "-- ordering by the number of rows scanned descending.\n"
  "--\n"
  "-- mysql> select * from x$schema_tables_with_full_table_scans limit 5;\n"
  "-- +--------------------+------------------------------+-------------------+----------------+\n"
  "-- | object_schema      | object_name                  | rows_full_scanned | latency        |\n"
  "-- +--------------------+------------------------------+-------------------+----------------+\n"
  "-- | mem30__instruments | fsstatistics                 |          10207042 | 13098927688488 |\n"
  "-- | mem30__instruments | preparedstatementapidata     |            436428 |   973274338980 |\n"
  "-- | mem30__instruments | mysqlprocessactivity         |            411702 |   282072434940 |\n"
  "-- | mem30__instruments | querycachequeriesincachedata |            374011 |   767152380564 |\n"
  "-- | mem30__instruments | rowaccessesdata              |            322321 |  1547594778456 |\n"
  "-- +--------------------+------------------------------+-------------------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$schema_tables_with_full_table_scans (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  rows_full_scanned,\n"
  "  latency\n"
  ") AS\n"
  "SELECT object_schema, \n"
  "       object_name,\n"
  "       count_read AS rows_full_scanned,\n"
  "       sum_timer_wait AS latency\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage \n"
  " WHERE index_name IS NULL\n"
  "   AND count_read > 0\n"
  " ORDER BY count_read DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: schema_unused_indexes\n"
  "-- \n"
  "-- Finds indexes that have had no events against them (and hence, no usage).\n"
  "--\n"
  "-- To trust whether the data from this view is representative of your workload,\n"
  "-- you should ensure that the server has been up for a representative amount of\n"
  "-- time before using it.\n"
  "--\n"
  "-- PRIMARY (key) indexes are ignored.\n"
  "--\n"
  "-- mysql> select * from schema_unused_indexes limit 5;\n"
  "-- +--------------------+---------------------+--------------------+\n"
  "-- | object_schema      | object_name         | index_name         |\n"
  "-- +--------------------+---------------------+--------------------+\n"
  "-- | mem30__bean_config | plists              | path               |\n"
  "-- | mem30__config      | group_selections    | name               |\n"
  "-- | mem30__config      | notification_groups | name               |\n"
  "-- | mem30__config      | user_form_defaults  | FKC1AEF1F9E7EE2CFB |\n"
  "-- | mem30__enterprise  | whats_new_entries   | entryId            |\n"
  "-- +--------------------+---------------------+--------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_unused_indexes (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  index_name\n"
  ") AS\n"
  "SELECT t.object_schema,\n"
  "       t.object_name,\n"
  "       t.index_name\n"
  "  FROM performance_schema.table_io_waits_summary_by_index_usage t\n"
  " INNER JOIN information_schema.statistics s\n"
  "    ON t.object_schema = s.table_schema\n"
  "   AND t.object_name = s.table_name\n"
  "   AND t.index_name = s.index_name\n"
  " WHERE t.index_name IS NOT NULL\n"
  "   AND t.count_star = 0\n"
  "   AND t.object_schema != 'mysql'\n"
  "   AND t.index_name != 'PRIMARY'\n"
  "   AND s.NON_UNIQUE = 1\n"
  "   AND s.SEQ_IN_INDEX = 1\n"
  " ORDER BY object_schema, object_name;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: schema_table_lock_waits\n"
  "--\n"
  "-- Shows sessions that are blocked waiting on table metadata locks, and \n"
  "-- who is blocking them.\n"
  "--\n"
  "-- mysql> select * from sys.schema_table_lock_waits\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                object_schema: test\n"
  "--                  object_name: t\n"
  "--            waiting_thread_id: 43\n"
  "--                  waiting_pid: 21\n"
  "--              waiting_account: msandbox@localhost\n"
  "--            waiting_lock_type: SHARED_UPGRADABLE\n"
  "--        waiting_lock_duration: TRANSACTION\n"
  "--                waiting_query: alter table test.t add foo int\n"
  "--           waiting_query_secs: 988\n"
  "--  waiting_query_rows_affected: 0\n"
  "--  waiting_query_rows_examined: 0\n"
  "--           blocking_thread_id: 42\n"
  "--                 blocking_pid: 20\n"
  "--             blocking_account: msandbox@localhost\n"
  "--           blocking_lock_type: SHARED_NO_READ_WRITE\n"
  "--       blocking_lock_duration: TRANSACTION\n"
  "--      sql_kill_blocking_query: KILL QUERY 20\n"
  "-- sql_kill_blocking_connection: KILL 20\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW schema_table_lock_waits (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  waiting_thread_id,\n"
  "  waiting_pid,\n"
  "  waiting_account,\n"
  "  waiting_lock_type,\n"
  "  waiting_lock_duration,\n"
  "  waiting_query,\n"
  "  waiting_query_secs,\n"
  "  waiting_query_rows_affected,\n"
  "  waiting_query_rows_examined,\n"
  "  blocking_thread_id,\n"
  "  blocking_pid,\n"
  "  blocking_account,\n"
  "  blocking_lock_type,\n"
  "  blocking_lock_duration,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT g.object_schema AS object_schema,\n"
  "       g.object_name AS object_name,\n"
  "       pt.thread_id AS waiting_thread_id,\n"
  "       pt.processlist_id AS waiting_pid,\n"
  "       sys.ps_thread_account(p.owner_thread_id) AS waiting_account,\n"
  "       p.lock_type AS waiting_lock_type,\n"
  "       p.lock_duration AS waiting_lock_duration,\n"
  "       sys.format_statement(pt.processlist_info) AS waiting_query,\n"
  "       pt.processlist_time AS waiting_query_secs,\n"
  "       ps.rows_affected AS waiting_query_rows_affected,\n"
  "       ps.rows_examined AS waiting_query_rows_examined,\n"
  "       gt.thread_id AS blocking_thread_id,\n"
  "       gt.processlist_id AS blocking_pid,\n"
  "       sys.ps_thread_account(g.owner_thread_id) AS blocking_account,\n"
  "       g.lock_type AS blocking_lock_type,\n"
  "       g.lock_duration AS blocking_lock_duration,\n"
  "       CONCAT('KILL QUERY ', gt.processlist_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', gt.processlist_id) AS sql_kill_blocking_connection\n"
  "  FROM performance_schema.metadata_locks g\n"
  " INNER JOIN performance_schema.metadata_locks p \n"
  "    ON g.object_type = p.object_type\n"
  "   AND g.object_schema = p.object_schema\n"
  "   AND g.object_name = p.object_name\n"
  "   AND g.lock_status = 'GRANTED'\n"
  "   AND p.lock_status = 'PENDING'\n"
  " INNER JOIN performance_schema.threads gt ON g.owner_thread_id = gt.thread_id\n"
  " INNER JOIN performance_schema.threads pt ON p.owner_thread_id = pt.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current gs ON g.owner_thread_id = gs.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current ps ON p.owner_thread_id = ps.thread_id\n"
  " WHERE g.object_type = 'TABLE';\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: schema_table_lock_waits\n"
  "--\n"
  "-- Shows sessions that are blocked waiting on table metadata locks, and \n"
  "-- who is blocking them.\n"
  "--\n"
  "-- mysql> select * from sys.x$schema_table_lock_waits\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                object_schema: test\n"
  "--                  object_name: t\n"
  "--            waiting_thread_id: 43\n"
  "--                  waiting_pid: 21\n"
  "--              waiting_account: msandbox@localhost\n"
  "--            waiting_lock_type: SHARED_UPGRADABLE\n"
  "--        waiting_lock_duration: TRANSACTION\n"
  "--                waiting_query: alter table test.t add foo int\n"
  "--           waiting_query_secs: 990\n"
  "--  waiting_query_rows_affected: 0\n"
  "--  waiting_query_rows_examined: 0\n"
  "--           blocking_thread_id: 42\n"
  "--                 blocking_pid: 20\n"
  "--             blocking_account: msandbox@localhost\n"
  "--           blocking_lock_type: SHARED_NO_READ_WRITE\n"
  "--       blocking_lock_duration: TRANSACTION\n"
  "--      sql_kill_blocking_query: KILL QUERY 20\n"
  "-- sql_kill_blocking_connection: KILL 20\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$schema_table_lock_waits (\n"
  "  object_schema,\n"
  "  object_name,\n"
  "  waiting_thread_id,\n"
  "  waiting_pid,\n"
  "  waiting_account,\n"
  "  waiting_lock_type,\n"
  "  waiting_lock_duration,\n"
  "  waiting_query,\n"
  "  waiting_query_secs,\n"
  "  waiting_query_rows_affected,\n"
  "  waiting_query_rows_examined,\n"
  "  blocking_thread_id,\n"
  "  blocking_pid,\n"
  "  blocking_account,\n"
  "  blocking_lock_type,\n"
  "  blocking_lock_duration,\n"
  "  sql_kill_blocking_query,\n"
  "  sql_kill_blocking_connection\n"
  ") AS\n"
  "SELECT g.object_schema AS object_schema,\n"
  "       g.object_name AS object_name,\n"
  "       pt.thread_id AS waiting_thread_id,\n"
  "       pt.processlist_id AS waiting_pid,\n"
  "       sys.ps_thread_account(p.owner_thread_id) AS waiting_account,\n"
  "       p.lock_type AS waiting_lock_type,\n"
  "       p.lock_duration AS waiting_lock_duration,\n"
  "       pt.processlist_info AS waiting_query,\n"
  "       pt.processlist_time AS waiting_query_secs,\n"
  "       ps.rows_affected AS waiting_query_rows_affected,\n"
  "       ps.rows_examined AS waiting_query_rows_examined,\n"
  "       gt.thread_id AS blocking_thread_id,\n"
  "       gt.processlist_id AS blocking_pid,\n"
  "       sys.ps_thread_account(g.owner_thread_id) AS blocking_account,\n"
  "       g.lock_type AS blocking_lock_type,\n"
  "       g.lock_duration AS blocking_lock_duration,\n"
  "       CONCAT('KILL QUERY ', gt.processlist_id) AS sql_kill_blocking_query,\n"
  "       CONCAT('KILL ', gt.processlist_id) AS sql_kill_blocking_connection\n"
  "  FROM performance_schema.metadata_locks g\n"
  " INNER JOIN performance_schema.metadata_locks p \n"
  "    ON g.object_type = p.object_type\n"
  "   AND g.object_schema = p.object_schema\n"
  "   AND g.object_name = p.object_name\n"
  "   AND g.lock_status = 'GRANTED'\n"
  "   AND p.lock_status = 'PENDING'\n"
  " INNER JOIN performance_schema.threads gt ON g.owner_thread_id = gt.thread_id\n"
  " INNER JOIN performance_schema.threads pt ON p.owner_thread_id = pt.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current gs ON g.owner_thread_id = gs.thread_id\n"
  "  LEFT JOIN performance_schema.events_statements_current ps ON p.owner_thread_id = ps.thread_id\n"
  " WHERE g.object_type = 'TABLE';\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: statement_analysis\n"
  "--\n"
  "-- Lists a normalized statement view with aggregated statistics,\n"
  "-- mimics the MySQL Enterprise Monitor Query Analysis view,\n"
  "-- ordered by the total execution time per normalized statement\n"
  "-- \n"
  "-- mysql> select- * from statement_analysis limit 1\\G\n"
  "-- *************************** 1. row--**************************\n"
  "--             query: SELECT * FROM `schema_object_o ... MA` , `information_schema` ...\n"
  "--                db: sys\n"
  "--         full_scan: *\n"
  "--        exec_count: 2\n"
  "--         err_count: 0\n"
  "--        warn_count: 0\n"
  "--     total_latency: 16.75 s\n"
  "--       max_latency: 16.57 s\n"
  "--       avg_latency: 8.38 s\n"
  "--      lock_latency: 16.69 s\n"
  "--         rows_sent: 84\n"
  "--     rows_sent_avg: 42\n"
  "--     rows_examined: 20012\n"
  "--     rows_affected: 0\n"
  "-- rows_affected_avg: 0\n"
  "-- rows_examined_avg: 10006\n"
  "--        tmp_tables: 378\n"
  "--   tmp_disk_tables: 66\n"
  "--       rows_sorted: 168\n"
  "-- sort_merge_passes: 0\n"
  "--            digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--        first_seen: 2014-03-07 13:13:41\n"
  "--         last_seen: 2014-03-07 13:13:48\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statement_analysis (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  rows_affected,\n"
  "  rows_affected_avg,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  rows_sorted,\n"
  "  sort_merge_passes,\n"
  "  digest,\n"
  "  first_seen,\n"
  "  last_seen\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       format_pico_time(MAX_TIMER_WAIT) AS max_latency,\n"
  "       format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "       format_pico_time(SUM_LOCK_TIME) AS lock_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0))  AS rows_examined_avg,\n"
  "       SUM_ROWS_AFFECTED AS rows_affected,\n"
  "       ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0))  AS rows_affected_avg,\n"
  "       SUM_CREATED_TMP_TABLES AS tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS tmp_disk_tables,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       DIGEST AS digest,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN as last_seen\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  "ORDER BY SUM_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: x$statement_analysis\n"
  "--\n"
  "-- Lists a normalized statement view with aggregated statistics,\n"
  "-- mimics the MySQL Enterprise Monitor Query Analysis view,\n"
  "-- ordered by the total execution time per normalized statement\n"
  "-- \n"
  "-- mysql> select * from x$statement_analysis limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--             query: SELECT * FROM `schema_object_overview` SELECT `information_schema` . `routines`  -- truncated\n"
  "--                db: sys\n"
  "--         full_scan: *\n"
  "--        exec_count: 2\n"
  "--         err_count: 0\n"
  "--        warn_count: 0\n"
  "--     total_latency: 16751388791000\n"
  "--       max_latency: 16566171163000\n"
  "--       avg_latency: 8375694395000\n"
  "--      lock_latency: 16686483000000\n"
  "--         rows_sent: 84\n"
  "--     rows_sent_avg: 42\n"
  "--     rows_examined: 20012\n"
  "-- rows_examined_avg: 10006\n"
  "--     rows_affected: 0\n"
  "-- rows_affected_avg: 0\n"
  "--        tmp_tables: 378\n"
  "--   tmp_disk_tables: 66\n"
  "--       rows_sorted: 168\n"
  "-- sort_merge_passes: 0\n"
  "--            digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--        first_seen: 2014-03-07 13:13:41\n"
  "--         last_seen: 2014-03-07 13:13:48\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statement_analysis (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  rows_affected,\n"
  "  rows_affected_avg,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  rows_sorted,\n"
  "  sort_merge_passes,\n"
  "  digest,\n"
  "  first_seen,\n"
  "  last_seen\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       MAX_TIMER_WAIT AS max_latency,\n"
  "       AVG_TIMER_WAIT AS avg_latency,\n"
  "       SUM_LOCK_TIME AS lock_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0))  AS rows_examined_avg,\n"
  "       SUM_ROWS_AFFECTED AS rows_affected,\n"
  "       ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0))  AS rows_affected_avg,\n"
  "       SUM_CREATED_TMP_TABLES AS tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS tmp_disk_tables,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       DIGEST AS digest,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN as last_seen\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  "ORDER BY SUM_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "--\n"
  "-- View: statements_with_errors_or_warnings\n"
  "--\n"
  "-- Lists all normalized statements that have raised errors or warnings.\n"
  "--\n"
  "-- mysql> select * from statements_with_errors_or_warnings LIMIT 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--       query: CREATE OR REPLACE ALGORITHM =  ... _delete` AS `rows_deleted` ...\n"
  "--          db: sys\n"
  "--  exec_count: 2\n"
  "--      errors: 1\n"
  "--   error_pct: 50.0000\n"
  "--    warnings: 0\n"
  "-- warning_pct: 0.0000\n"
  "--  first_seen: 2014-03-07 12:56:54\n"
  "--   last_seen: 2014-03-07 13:01:01\n"
  "--      digest: 943a788859e623d5f7798ba0ae0fd8a9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statements_with_errors_or_warnings (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  errors,\n"
  "  error_pct,\n"
  "  warnings,\n"
  "  warning_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS errors,\n"
  "       IFNULL(SUM_ERRORS / NULLIF(COUNT_STAR, 0), 0) * 100 as error_pct,\n"
  "       SUM_WARNINGS AS warnings,\n"
  "       IFNULL(SUM_WARNINGS / NULLIF(COUNT_STAR, 0), 0) * 100 as warning_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_ERRORS > 0\n"
  "    OR SUM_WARNINGS > 0\n"
  "ORDER BY SUM_ERRORS DESC, SUM_WARNINGS DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$statements_with_errors_or_warnings\n"
  "--\n"
  "-- Lists all normalized statements that have raised errors or warnings.\n"
  "--\n"
  "-- mysql> select * from x$statements_with_errors_or_warnings LIMIT 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--       query: CREATE OR REPLACE ALGORITHM = TEMPTABLE DEFINER = ? @ ? SQL SECURITY INVOKER VIEW ... truncated\n"
  "--          db: sys\n"
  "--  exec_count: 2\n"
  "--      errors: 1\n"
  "--   error_pct: 50.0000\n"
  "--    warnings: 0\n"
  "-- warning_pct: 0.0000\n"
  "--  first_seen: 2014-03-07 12:56:54\n"
  "--   last_seen: 2014-03-07 13:01:01\n"
  "--      digest: 943a788859e623d5f7798ba0ae0fd8a9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statements_with_errors_or_warnings (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  errors,\n"
  "  error_pct,\n"
  "  warnings,\n"
  "  warning_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS errors,\n"
  "       IFNULL(SUM_ERRORS / NULLIF(COUNT_STAR, 0), 0) * 100 as error_pct,\n"
  "       SUM_WARNINGS AS warnings,\n"
  "       IFNULL(SUM_WARNINGS / NULLIF(COUNT_STAR, 0), 0) * 100 as warning_pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_ERRORS > 0\n"
  "    OR SUM_WARNINGS > 0\n"
  "ORDER BY SUM_ERRORS DESC, SUM_WARNINGS DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: statements_with_full_table_scans\n"
  "--\n"
  "-- Lists all normalized statements that use have done a full table scan\n"
  "-- ordered by number the percentage of times a full scan was done,\n"
  "-- then by the statement latency.\n"
  "--\n"
  "-- This view ignores SHOW statements, as these always cause a full table scan,\n"
  "-- and there is nothing that can be done about this.\n"
  "--\n"
  "-- mysql> select * from statements_with_full_table_scans limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                    query: SELECT * FROM `schema_tables_w ... ex_usage` . `COUNT_READ` DESC\n"
  "--                       db: sys\n"
  "--               exec_count: 1\n"
  "--            total_latency: 88.20 ms\n"
  "--      no_index_used_count: 1\n"
  "-- no_good_index_used_count: 0\n"
  "--        no_index_used_pct: 100\n"
  "--                rows_sent: 0\n"
  "--            rows_examined: 1501\n"
  "--            rows_sent_avg: 0\n"
  "--        rows_examined_avg: 1501\n"
  "--               first_seen: 2014-03-07 13:58:20\n"
  "--                last_seen: 2014-03-07 13:58:20\n"
  "--                   digest: 64baecd5c1e1e1651a6b92e55442a288\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statements_with_full_table_scans (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  no_index_used_count,\n"
  "  no_good_index_used_count,\n"
  "  no_index_used_pct,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_sent_avg,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       SUM_NO_INDEX_USED AS no_index_used_count,\n"
  "       SUM_NO_GOOD_INDEX_USED AS no_good_index_used_count,\n"
  "       ROUND(IFNULL(SUM_NO_INDEX_USED / NULLIF(COUNT_STAR, 0), 0) * 100) AS no_index_used_pct,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(SUM_ROWS_SENT/COUNT_STAR) AS rows_sent_avg,\n"
  "       ROUND(SUM_ROWS_EXAMINED/COUNT_STAR) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE (SUM_NO_INDEX_USED > 0\n"
  "    OR SUM_NO_GOOD_INDEX_USED > 0)\n"
  "   AND DIGEST_TEXT NOT LIKE 'SHOW%'\n"
  " ORDER BY no_index_used_pct DESC, total_latency DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$statements_with_full_table_scans\n"
  "--\n"
  "-- Lists all normalized statements that use have done a full table scan\n"
  "-- ordered by number the percentage of times a full scan was done,\n"
  "-- then by the statement latency.\n"
  "--\n"
  "-- This view ignores SHOW statements, as these always cause a full table scan,\n"
  "-- and there is nothing that can be done about this.\n"
  "--\n"
  "-- mysql> select * from x$statements_with_full_table_scans limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                    query: SELECT * FROM `schema_object_overview` SELECT `information_schema` . `routines` . `ROUTI"
  "NE_SCHEMA` // truncated\n"
  "--                       db: sys\n"
  "--               exec_count: 2\n"
  "--            total_latency: 16751388791000\n"
  "--      no_index_used_count: 2\n"
  "-- no_good_index_used_count: 0\n"
  "--        no_index_used_pct: 100\n"
  "--                rows_sent: 84\n"
  "--            rows_examined: 20012\n"
  "--            rows_sent_avg: 42\n"
  "--        rows_examined_avg: 10006\n"
  "--               first_seen: 2014-03-07 13:13:41\n"
  "--                last_seen: 2014-03-07 13:13:48\n"
  "--                   digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statements_with_full_table_scans (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  no_index_used_count,\n"
  "  no_good_index_used_count,\n"
  "  no_index_used_pct,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_sent_avg,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       SUM_NO_INDEX_USED AS no_index_used_count,\n"
  "       SUM_NO_GOOD_INDEX_USED AS no_good_index_used_count,\n"
  "       ROUND(IFNULL(SUM_NO_INDEX_USED / NULLIF(COUNT_STAR, 0), 0) * 100) AS no_index_used_pct,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(SUM_ROWS_SENT/COUNT_STAR) AS rows_sent_avg,\n"
  "       ROUND(SUM_ROWS_EXAMINED/COUNT_STAR) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE (SUM_NO_INDEX_USED > 0\n"
  "    OR SUM_NO_GOOD_INDEX_USED > 0)\n"
  "   AND DIGEST_TEXT NOT LIKE 'SHOW%'\n"
  " ORDER BY no_index_used_pct DESC, total_latency DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$ps_digest_avg_latency_distribution\n"
  "--\n"
  "-- Helper view for x$ps_digest_95th_percentile_by_avg_us\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$ps_digest_avg_latency_distribution (\n"
  "  cnt,\n"
  "  avg_us\n"
  ") AS\n"
  "SELECT COUNT(*) cnt, \n"
  "       ROUND(avg_timer_wait/1000000) AS avg_us\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " GROUP BY avg_us;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$ps_digest_95th_percentile_by_avg_us\n"
  "--\n"
  "-- Helper view for statements_with_runtimes_in_95th_percentile.\n"
  "-- Lists the 95th percentile runtime, for all statements\n"
  "--\n"
  "-- mysql> select * from x$ps_digest_95th_percentile_by_avg_us;\n"
  "-- +--------+------------+\n"
  "-- | avg_us | percentile |\n"
  "-- +--------+------------+\n"
  "-- |    964 |     0.9525 |\n"
  "-- +--------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$ps_digest_95th_percentile_by_avg_us (\n"
  "  avg_us,\n"
  "  percentile\n"
  ") AS\n"
  "SELECT s2.avg_us avg_us,\n"
  "       IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM performance_schema.events_statements_summary_by_digest), 0), 0"
  ") percentile\n"
  "  FROM sys.x$ps_digest_avg_latency_distribution AS s1\n"
  "  JOIN sys.x$ps_digest_avg_latency_distribution AS s2\n"
  "    ON s1.avg_us <= s2.avg_us\n"
  " GROUP BY s2.avg_us\n"
  "HAVING IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM performance_schema.events_statements_summary_by_digest), 0), 0"
  ") > 0.95\n"
  " ORDER BY percentile\n"
  " LIMIT 1;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: statements_with_runtimes_in_95th_percentile\n"
  "--\n"
  "-- List all statements whose average runtime, in microseconds, is in the top 95th percentile.\n"
  "-- \n"
  "-- mysql> select * from statements_with_runtimes_in_95th_percentile limit 5;\n"
  "-- +-------------------------------------------------------------------+------+-----------+------------+-----------+-"
  "-----------+---------------+-------------+-------------+-----------+---------------+---------------+-----------------"
  "--+---------------------+---------------------+----------------------------------+\n"
  "-- | query                                                             | db   | full_scan | exec_count | err_count | "
  "warn_count | total_latency | max_latency | avg_latency | rows_sent | rows_sent_avg | rows_examined | rows_examined_av"
  "g | FIRST_SEEN          | LAST_SEEN           | digest                           |\n"
  "-- +-------------------------------------------------------------------+------+-----------+------------+-----------+-"
  "-----------+---------------+-------------+-------------+-----------+---------------+---------------+-----------------"
  "--+---------------------+---------------------+----------------------------------+\n"
  "-- | SELECT `e` . `round_robin_bin` ...  `timestamp` = `maxes` . `ts`  | mem  | *         |         14 |         0 | "
  "         0 | 43.96 s       | 6.69 s      | 3.14 s      |        11 |             1 |        253170 |             1808"
  "4 | 2013-12-04 20:05:01 | 2013-12-04 20:06:34 | 29ba002bf039bb6439357a10134407de |\n"
  "-- | SELECT `e` . `round_robin_bin` ...  `timestamp` = `maxes` . `ts`  | mem  | *         |          8 |         0 | "
  "         0 | 17.89 s       | 4.12 s      | 2.24 s      |         7 |             1 |        169534 |             2119"
  "2 | 2013-12-04 20:04:54 | 2013-12-04 20:05:05 | 0b1c1f91e7e9e0ff91aa49d15f540793 |\n"
  "-- | SELECT `e` . `round_robin_bin` ...  `timestamp` = `maxes` . `ts`  | mem  | *         |          1 |         0 | "
  "         0 | 2.22 s        | 2.22 s      | 2.22 s      |         1 |             1 |         40322 |             4032"
  "2 | 2013-12-04 20:05:39 | 2013-12-04 20:05:39 | 07b27145c8f8a3779737df5032374833 |\n"
  "-- | SELECT `e` . `round_robin_bin` ...  `timestamp` = `maxes` . `ts`  | mem  | *         |          1 |         0 | "
  "         0 | 1.97 s        | 1.97 s      | 1.97 s      |         1 |             1 |         40322 |             4032"
  "2 | 2013-12-04 20:05:39 | 2013-12-04 20:05:39 | a07488137ea5c1bccf3e291c50bfd21f |\n"
  "-- | SELECT `e` . `round_robin_bin` ...  `timestamp` = `maxes` . `ts`  | mem  | *         |          2 |         0 | "
  "         0 | 3.91 s        | 3.91 s      | 1.96 s      |         1 |             1 |         13126 |              656"
  "3 | 2013-12-04 20:05:04 | 2013-12-04 20:06:34 | b8bddc6566366dafc7e474f67096a93b |\n"
  "-- +-------------------------------------------------------------------+------+-----------+------------+-----------+-"
  "-----------+---------------+-------------+-------------+-----------+---------------+---------------+-----------------"
  "--+---------------------+---------------------+----------------------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statements_with_runtimes_in_95th_percentile (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       format_pico_time(MAX_TIMER_WAIT) AS max_latency,\n"
  "       format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "       FIRST_SEEN AS first_seen,\n"
  "       LAST_SEEN AS last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest stmts\n"
  "  JOIN sys.x$ps_digest_95th_percentile_by_avg_us AS top_percentile\n"
  "    ON ROUND(stmts.avg_timer_wait/1000000) >= top_percentile.avg_us\n"
  " ORDER BY AVG_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$statements_with_runtimes_in_95th_percentile\n"
  "--\n"
  "-- List all statements whose average runtime, in microseconds, is in the top 95th percentile.\n"
  "-- \n"
  "-- mysql> SELECT * FROM x$statements_with_runtimes_in_95th_percentile LIMIT 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--             query: SELECT `e` . `round_robin_bin` AS `round1_1706_0_` , `e` . `id` AS `id1706_0_` , `e` . `timesta"
  "mp` AS `timestamp1706_0_` , ... truncated\n"
  "--                db: mem\n"
  "--         full_scan: *\n"
  "--        exec_count: 14\n"
  "--         err_count: 0\n"
  "--        warn_count: 0\n"
  "--     total_latency: 43961670267000\n"
  "--       max_latency: 6686877140000\n"
  "--       avg_latency: 3140119304000\n"
  "--         rows_sent: 11\n"
  "--     rows_sent_avg: 1\n"
  "--     rows_examined: 253170\n"
  "-- rows_examined_avg: 18084\n"
  "--        first_seen: 2013-12-04 20:05:01\n"
  "--         last_seen: 2013-12-04 20:06:34\n"
  "--            digest: 29ba002bf039bb6439357a10134407de\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statements_with_runtimes_in_95th_percentile (\n"
  "  query,\n"
  "  db,\n"
  "  full_scan,\n"
  "  exec_count,\n"
  "  err_count,\n"
  "  warn_count,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  avg_latency,\n"
  "  rows_sent,\n"
  "  rows_sent_avg,\n"
  "  rows_examined,\n"
  "  rows_examined_avg,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME AS db,\n"
  "       IF(SUM_NO_GOOD_INDEX_USED > 0 OR SUM_NO_INDEX_USED > 0, '*', '') AS full_scan,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_ERRORS AS err_count,\n"
  "       SUM_WARNINGS AS warn_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       MAX_TIMER_WAIT AS max_latency,\n"
  "       AVG_TIMER_WAIT AS avg_latency,\n"
  "       SUM_ROWS_SENT AS rows_sent,\n"
  "       ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "       SUM_ROWS_EXAMINED AS rows_examined,\n"
  "       ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest stmts\n"
  "  JOIN sys.x$ps_digest_95th_percentile_by_avg_us AS top_percentile\n"
  "    ON ROUND(stmts.avg_timer_wait/1000000) >= top_percentile.avg_us\n"
  " ORDER BY AVG_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: statements_with_sorting\n"
  "--\n"
  "-- Lists all normalized statements that have done sorts,\n"
  "-- ordered by total_latency descending.\n"
  "--\n"
  "-- mysql> select * from statements_with_sorting limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--             query: SELECT * FROM `schema_object_o ... MA` , `information_schema` ...\n"
  "--                db: sys\n"
  "--        exec_count: 2\n"
  "--     total_latency: 16.75 s\n"
  "-- sort_merge_passes: 0\n"
  "--   avg_sort_merges: 0\n"
  "-- sorts_using_scans: 12\n"
  "--  sort_using_range: 0\n"
  "--       rows_sorted: 168\n"
  "--   avg_rows_sorted: 84\n"
  "--        first_seen: 2014-03-07 13:13:41\n"
  "--         last_seen: 2014-03-07 13:13:48\n"
  "--            digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statements_with_sorting (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  sort_merge_passes,\n"
  "  avg_sort_merges,\n"
  "  sorts_using_scans,\n"
  "  sort_using_range,\n"
  "  rows_sorted,\n"
  "  avg_rows_sorted,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       ROUND(IFNULL(SUM_SORT_MERGE_PASSES / NULLIF(COUNT_STAR, 0), 0)) AS avg_sort_merges,\n"
  "       SUM_SORT_SCAN AS sorts_using_scans,\n"
  "       SUM_SORT_RANGE AS sort_using_range,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       ROUND(IFNULL(SUM_SORT_ROWS / NULLIF(COUNT_STAR, 0), 0)) AS avg_rows_sorted,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_SORT_ROWS > 0\n"
  " ORDER BY SUM_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$statements_with_sorting\n"
  "--\n"
  "-- Lists all normalized statements that have done sorts,\n"
  "-- ordered by total_latency descending.\n"
  "--\n"
  "-- mysql> select * from x$statements_with_sorting\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--             query: SELECT * FROM `schema_object_overview` SELECT `information_schema` . `routines` . `ROUTINE_SCHE"
  "MA` AS ... truncated\n"
  "--                db: sys\n"
  "--        exec_count: 2\n"
  "--     total_latency: 16751388791000\n"
  "-- sort_merge_passes: 0\n"
  "--   avg_sort_merges: 0\n"
  "-- sorts_using_scans: 12\n"
  "--  sort_using_range: 0\n"
  "--       rows_sorted: 168\n"
  "--   avg_rows_sorted: 84\n"
  "--        first_seen: 2014-03-07 13:13:41\n"
  "--         last_seen: 2014-03-07 13:13:48\n"
  "--            digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statements_with_sorting (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  sort_merge_passes,\n"
  "  avg_sort_merges,\n"
  "  sorts_using_scans,\n"
  "  sort_using_range,\n"
  "  rows_sorted,\n"
  "  avg_rows_sorted,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT AS total_latency,\n"
  "       SUM_SORT_MERGE_PASSES AS sort_merge_passes,\n"
  "       ROUND(IFNULL(SUM_SORT_MERGE_PASSES / NULLIF(COUNT_STAR, 0), 0)) AS avg_sort_merges,\n"
  "       SUM_SORT_SCAN AS sorts_using_scans,\n"
  "       SUM_SORT_RANGE AS sort_using_range,\n"
  "       SUM_SORT_ROWS AS rows_sorted,\n"
  "       ROUND(IFNULL(SUM_SORT_ROWS / NULLIF(COUNT_STAR, 0), 0)) AS avg_rows_sorted,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_SORT_ROWS > 0\n"
  " ORDER BY SUM_TIMER_WAIT DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: statements_with_temp_tables\n"
  "--\n"
  "-- Lists all normalized statements that use temporary tables\n"
  "-- ordered by number of on disk temporary tables descending first, \n"
  "-- then by the number of memory tables.\n"
  "--\n"
  "-- mysql> select * from statements_with_temp_tables limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                    query: SELECT * FROM `schema_object_o ... MA` , `information_schema` ...\n"
  "--                       db: sys\n"
  "--               exec_count: 2\n"
  "--            total_latency: 16.75 s\n"
  "--        memory_tmp_tables: 378\n"
  "--          disk_tmp_tables: 66\n"
  "-- avg_tmp_tables_per_query: 189\n"
  "--   tmp_tables_to_disk_pct: 17\n"
  "--               first_seen: 2014-03-07 13:13:41\n"
  "--                last_seen: 2014-03-07 13:13:48\n"
  "--                   digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW statements_with_temp_tables (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  memory_tmp_tables,\n"
  "  disk_tmp_tables,\n"
  "  avg_tmp_tables_per_query,\n"
  "  tmp_tables_to_disk_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       format_pico_time(SUM_TIMER_WAIT) as total_latency,\n"
  "       SUM_CREATED_TMP_TABLES AS memory_tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS disk_tmp_tables,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_TABLES / NULLIF(COUNT_STAR, 0), 0)) AS avg_tmp_tables_per_query,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_DISK_TABLES / NULLIF(SUM_CREATED_TMP_TABLES, 0), 0) * 100) AS tmp_tables_to_disk_"
  "pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_CREATED_TMP_TABLES > 0\n"
  "ORDER BY SUM_CREATED_TMP_DISK_TABLES DESC, SUM_CREATED_TMP_TABLES DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$statements_with_temp_tables\n"
  "--\n"
  "-- Lists all normalized statements that use temporary tables\n"
  "-- ordered by number of on disk temporary tables descending first, \n"
  "-- then by the number of memory tables.\n"
  "--\n"
  "-- mysql> select * from x$statements_with_temp_tables limit 1\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                    query: SELECT * FROM `schema_object_overview` SELECT `information_schema` . `routines` . `ROUTI"
  "NE_SCHEMA` AS `db` , ... truncated\n"
  "--                       db: sys\n"
  "--               exec_count: 2\n"
  "--            total_latency: 16751388791000\n"
  "--        memory_tmp_tables: 378\n"
  "--          disk_tmp_tables: 66\n"
  "-- avg_tmp_tables_per_query: 189\n"
  "--   tmp_tables_to_disk_pct: 17\n"
  "--               first_seen: 2014-03-07 13:13:41\n"
  "--                last_seen: 2014-03-07 13:13:48\n"
  "--                   digest: 54f9bd520f0bbf15db0c2ed93386bec9\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$statements_with_temp_tables (\n"
  "  query,\n"
  "  db,\n"
  "  exec_count,\n"
  "  total_latency,\n"
  "  memory_tmp_tables,\n"
  "  disk_tmp_tables,\n"
  "  avg_tmp_tables_per_query,\n"
  "  tmp_tables_to_disk_pct,\n"
  "  first_seen,\n"
  "  last_seen,\n"
  "  digest\n"
  ") AS\n"
  "SELECT DIGEST_TEXT AS query,\n"
  "       SCHEMA_NAME as db,\n"
  "       COUNT_STAR AS exec_count,\n"
  "       SUM_TIMER_WAIT as total_latency,\n"
  "       SUM_CREATED_TMP_TABLES AS memory_tmp_tables,\n"
  "       SUM_CREATED_TMP_DISK_TABLES AS disk_tmp_tables,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_TABLES / NULLIF(COUNT_STAR, 0), 0)) AS avg_tmp_tables_per_query,\n"
  "       ROUND(IFNULL(SUM_CREATED_TMP_DISK_TABLES / NULLIF(SUM_CREATED_TMP_TABLES, 0), 0) * 100) AS tmp_tables_to_disk_"
  "pct,\n"
  "       FIRST_SEEN as first_seen,\n"
  "       LAST_SEEN as last_seen,\n"
  "       DIGEST AS digest\n"
  "  FROM performance_schema.events_statements_summary_by_digest\n"
  " WHERE SUM_CREATED_TMP_TABLES > 0\n"
  "ORDER BY SUM_CREATED_TMP_DISK_TABLES DESC, SUM_CREATED_TMP_TABLES DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary_by_file_io_type\n"
  "--\n"
  "-- Summarizes file IO by event type per user.\n"
  "--\n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from user_summary_by_file_io_type;\n"
  "-- +------------+--------------------------------------+-------+-----------+-------------+\n"
  "-- | user       | event_name                           | total | latency   | max_latency |\n"
  "-- +------------+--------------------------------------+-------+-----------+-------------+\n"
  "-- | background | wait/io/file/sql/FRM                 |   871 | 168.15 ms | 18.48 ms    |\n"
  "-- | background | wait/io/file/innodb/innodb_data_file |   173 | 129.56 ms | 34.09 ms    |\n"
  "-- | background | wait/io/file/innodb/innodb_log_file  |    20 | 77.53 ms  | 60.66 ms    |\n"
  "-- | background | wait/io/file/myisam/dfile            |    40 | 6.54 ms   | 4.58 ms     |\n"
  "-- | background | wait/io/file/mysys/charset           |     3 | 4.79 ms   | 4.71 ms     |\n"
  "-- | background | wait/io/file/myisam/kfile            |    67 | 4.38 ms   | 300.04 us   |\n"
  "-- | background | wait/io/file/sql/ERRMSG              |     5 | 2.72 ms   | 1.69 ms     |\n"
  "-- | background | wait/io/file/sql/pid                 |     3 | 266.30 us | 185.47 us   |\n"
  "-- | background | wait/io/file/sql/casetest            |     5 | 246.81 us | 150.19 us   |\n"
  "-- | background | wait/io/file/sql/global_ddl_log      |     2 | 21.24 us  | 18.59 us    |\n"
  "-- | root       | wait/io/file/sql/file_parser         |  1422 | 4.80 s    | 135.14 ms   |\n"
  "-- | root       | wait/io/file/sql/FRM                 |   865 | 85.82 ms  | 9.81 ms     |\n"
  "-- | root       | wait/io/file/myisam/kfile            |  1073 | 37.14 ms  | 15.79 ms    |\n"
  "-- | root       | wait/io/file/myisam/dfile            |  2991 | 25.53 ms  | 5.25 ms     |\n"
  "-- | root       | wait/io/file/sql/dbopt               |    20 | 1.07 ms   | 153.07 us   |\n"
  "-- | root       | wait/io/file/sql/misc                |     4 | 59.71 us  | 33.75 us    |\n"
  "-- | root       | wait/io/file/archive/data            |     1 | 13.91 us  | 13.91 us    |\n"
  "-- +------------+--------------------------------------+-------+-----------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary_by_file_io_type (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary_by_file_io_type\n"
  "--\n"
  "-- Summarizes file IO by event type per user.\n"
  "--\n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$user_summary_by_file_io_type;\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "-- | user       | event_name                           | total | latency       | max_latency  |\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "-- | background | wait/io/file/sql/FRM                 |   871 |  168148450470 |  18482624810 |\n"
  "-- | background | wait/io/file/innodb/innodb_data_file |   173 |  129564287450 |  34087423890 |\n"
  "-- | background | wait/io/file/innodb/innodb_log_file  |    20 |   77525706960 |  60657475320 |\n"
  "-- | background | wait/io/file/myisam/dfile            |    40 |    6544493800 |   4580546230 |\n"
  "-- | background | wait/io/file/mysys/charset           |     3 |    4793558770 |   4713476430 |\n"
  "-- | background | wait/io/file/myisam/kfile            |    67 |    4384332810 |    300035450 |\n"
  "-- | background | wait/io/file/sql/ERRMSG              |     5 |    2717434850 |   1687316280 |\n"
  "-- | background | wait/io/file/sql/pid                 |     3 |     266301490 |    185468920 |\n"
  "-- | background | wait/io/file/sql/casetest            |     5 |     246814360 |    150193030 |\n"
  "-- | background | wait/io/file/sql/global_ddl_log      |     2 |      21236410 |     18593640 |\n"
  "-- | root       | wait/io/file/sql/file_parser         |  1422 | 4801104756760 | 135138518970 |\n"
  "-- | root       | wait/io/file/sql/FRM                 |   865 |   85818594810 |   9812303410 |\n"
  "-- | root       | wait/io/file/myisam/kfile            |  1073 |   37143664870 |  15793838190 |\n"
  "-- | root       | wait/io/file/myisam/dfile            |  2991 |   25528215700 |   5252232050 |\n"
  "-- | root       | wait/io/file/sql/dbopt               |    20 |    1067339780 |    153073310 |\n"
  "-- | root       | wait/io/file/sql/misc                |     4 |      59713030 |     33752810 |\n"
  "-- | root       | wait/io/file/archive/data            |     1 |      13907530 |     13907530 |\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary_by_file_io_type (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary_by_file_io\n"
  "--\n"
  "-- Summarizes file IO totals per user.\n"
  "--\n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from user_summary_by_file_io;\n"
  "-- +------------+-------+------------+\n"
  "-- | user       | ios   | io_latency |\n"
  "-- +------------+-------+------------+\n"
  "-- | root       | 26457 | 21.58 s    |\n"
  "-- | background |  1189 | 394.21 ms  |\n"
  "-- +------------+-------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary_by_file_io (\n"
  "  user,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS ios,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS io_latency \n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary_by_file_io\n"
  "--\n"
  "-- Summarizes file IO totals per user.\n"
  "--\n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$user_summary_by_file_io;\n"
  "-- +------------+-------+----------------+\n"
  "-- | user       | ios   | io_latency     |\n"
  "-- +------------+-------+----------------+\n"
  "-- | root       | 26457 | 21579585586390 |\n"
  "-- | background |  1189 |   394212617370 |\n"
  "-- +------------+-------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary_by_file_io (\n"
  "  user,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS ios,\n"
  "       SUM(sum_timer_wait) AS io_latency \n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary_by_statement_type\n"
  "--\n"
  "-- Summarizes the types of statements executed by each user.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from user_summary_by_statement_type;\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "-- | user | statement            | total  | total_latency | max_latency | lock_latency | rows_sent | rows_examined | "
  "rows_affected | full_scans |\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "-- | root | create_view          |   2063 | 00:05:04.20   | 463.58 ms   | 1.42 s       |         0 |             0 | "
  "            0 |          0 |\n"
  "-- | root | select               |    174 | 40.87 s       | 28.83 s     | 858.13 ms    |      5212 |        157022 | "
  "            0 |         82 |\n"
  "-- | root | stmt                 |   6645 | 15.31 s       | 491.78 ms   | 0 ps         |         0 |             0 | "
  "         7951 |          0 |\n"
  "-- | root | call_procedure       |     17 | 4.78 s        | 1.02 s      | 37.94 ms     |         0 |             0 | "
  "           19 |          0 |\n"
  "-- | root | create_table         |     19 | 3.04 s        | 431.71 ms   | 0 ps         |         0 |             0 | "
  "            0 |          0 |\n"
  "-- ...\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary_by_statement_type (\n"
  "  user,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_lock_time) AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary_by_statement_type\n"
  "--\n"
  "-- Summarizes the types of statements executed by each user.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$user_summary_by_statement_type;\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "-- | user | statement            | total  | total_latency   | max_latency    | lock_latency   | rows_sent | rows_exam"
  "ined | rows_affected | full_scans |\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "-- | root | create_view          |   2110 | 312717366332000 |   463578029000 |  1432355000000 |         0 |          "
  "   0 |             0 |          0 |\n"
  "-- | root | select               |    177 |  41115690428000 | 28827579292000 |   858709000000 |      5254 |        15"
  "7437 |             0 |         83 |\n"
  "-- | root | stmt                 |   6645 |  15305389969000 |   491780297000 |              0 |         0 |          "
  "   0 |          7951 |          0 |\n"
  "-- | root | call_procedure       |     17 |   4783806053000 |  1016083397000 |    37936000000 |         0 |          "
  "   0 |            19 |          0 |\n"
  "-- | root | create_table         |     19 |   3035120946000 |   431706815000 |              0 |         0 |          "
  "   0 |             0 |          0 |\n"
  "-- ...\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary_by_statement_type (\n"
  "  user,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_lock_time AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary_by_statement_latency\n"
  "--\n"
  "-- Summarizes overall statement statistics by user.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from user_summary_by_statement_latency;\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "-- | user | total | total_latency | max_latency | lock_latency | rows_sent | rows_examined | rows_affected | full_sca"
  "ns |\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "-- | root |  3381 | 00:02:09.13   | 1.48 s      | 1.07 s       |      1151 |         93947 |           150 |         "
  "91 |\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary_by_statement_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(SUM(max_timer_wait)) AS max_latency,\n"
  "       format_pico_time(SUM(sum_lock_time)) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary_by_statement_latency\n"
  "--\n"
  "-- Summarizes overall statement statistics by user.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$user_summary_by_statement_latency;\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "-- | user | total | total_latency   | max_latency   | lock_latency  | rows_sent | rows_examined | rows_affected | ful"
  "l_scans |\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "-- | root |  3382 | 129134039432000 | 1483246743000 | 1069831000000 |      1152 |         94286 |           150 |    "
  "     92 |\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary_by_statement_latency (\n"
  "  user,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       SUM(count_star) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       SUM(max_timer_wait) AS max_latency,\n"
  "       SUM(sum_lock_time) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_user_by_event_name\n"
  " GROUP BY IF(user IS NULL, 'background', user)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary_by_stages\n"
  "--\n"
  "-- Summarizes stages by user, ordered by user and total latency per stage.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "-- \n"
  "-- mysql> select * from user_summary_by_stages;\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | user | event_name                     | total | total_latency | avg_latency |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | root | stage/sql/Opening tables       |   889 | 1.97 ms       | 2.22 us     |\n"
  "-- | root | stage/sql/Creating sort index  |     4 | 1.79 ms       | 446.30 us   |\n"
  "-- | root | stage/sql/init                 |    10 | 312.27 us     | 31.23 us    |\n"
  "-- | root | stage/sql/checking permissions |    10 | 300.62 us     | 30.06 us    |\n"
  "-- | root | stage/sql/freeing items        |     5 | 85.89 us      | 17.18 us    |\n"
  "-- | root | stage/sql/statistics           |     5 | 79.15 us      | 15.83 us    |\n"
  "-- | root | stage/sql/preparing            |     5 | 69.12 us      | 13.82 us    |\n"
  "-- | root | stage/sql/optimizing           |     5 | 53.11 us      | 10.62 us    |\n"
  "-- | root | stage/sql/Sending data         |     5 | 44.66 us      | 8.93 us     |\n"
  "-- | root | stage/sql/closing tables       |     5 | 37.54 us      | 7.51 us     |\n"
  "-- | root | stage/sql/System lock          |     5 | 34.28 us      | 6.86 us     |\n"
  "-- | root | stage/sql/query end            |     5 | 24.37 us      | 4.87 us     |\n"
  "-- | root | stage/sql/end                  |     5 | 8.60 us       | 1.72 us     |\n"
  "-- | root | stage/sql/Sorting result       |     5 | 8.33 us       | 1.67 us     |\n"
  "-- | root | stage/sql/executing            |     5 | 5.37 us       | 1.07 us     |\n"
  "-- | root | stage/sql/cleaning up          |     5 | 4.60 us       | 919.00 ns   |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary_by_stages (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency, \n"
  "       format_pico_time(avg_timer_wait) AS avg_latency \n"
  "  FROM performance_schema.events_stages_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0 \n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary_by_stages\n"
  "--\n"
  "-- Summarizes stages by user, ordered by user and total latency per stage.\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "-- \n"
  "-- mysql> select * from x$user_summary_by_stages;\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | user | event_name                     | total | total_latency | avg_latency |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | root | stage/sql/Opening tables       |  1114 |   71919037000 |    64559000 |\n"
  "-- | root | stage/sql/Creating sort index  |     5 |    2245762000 |   449152000 |\n"
  "-- | root | stage/sql/init                 |    13 |     428798000 |    32984000 |\n"
  "-- | root | stage/sql/checking permissions |    13 |     363231000 |    27940000 |\n"
  "-- | root | stage/sql/freeing items        |     7 |     137728000 |    19675000 |\n"
  "-- | root | stage/sql/statistics           |     6 |      93955000 |    15659000 |\n"
  "-- | root | stage/sql/preparing            |     6 |      82571000 |    13761000 |\n"
  "-- | root | stage/sql/optimizing           |     6 |      63338000 |    10556000 |\n"
  "-- | root | stage/sql/Sending data         |     6 |      53400000 |     8900000 |\n"
  "-- | root | stage/sql/closing tables       |     7 |      46922000 |     6703000 |\n"
  "-- | root | stage/sql/System lock          |     6 |      40175000 |     6695000 |\n"
  "-- | root | stage/sql/query end            |     7 |      31723000 |     4531000 |\n"
  "-- | root | stage/sql/Sorting result       |     6 |       9855000 |     1642000 |\n"
  "-- | root | stage/sql/end                  |     6 |       9556000 |     1592000 |\n"
  "-- | root | stage/sql/cleaning up          |     7 |       7312000 |     1044000 |\n"
  "-- | root | stage/sql/executing            |     6 |       6487000 |     1081000 |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary_by_stages (\n"
  "  user,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency, \n"
  "       avg_timer_wait AS avg_latency \n"
  "  FROM performance_schema.events_stages_summary_by_user_by_event_name\n"
  " WHERE sum_timer_wait != 0 \n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: user_summary\n"
  "--\n"
  "-- Summarizes statement activity and connections by user\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from user_summary;\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "-- | user | statements | total_latency | avg_latency | current_connections | total_connections | unique_hosts | curre"
  "nt_memory | total_memory_allocated |\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "-- | root |       5663 | 00:01:47.14   | 18.92 ms    |                   1 |                 1 |            1 | 1.41 "
  "MiB       | 543.55 MiB             |\n"
  "-- | mark |        225 | 14.49 s       | 64.40 ms    |                   1 |                 1 |            1 | 707.6"
  "0 KiB     | 81.02 MiB              |\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW user_summary (\n"
  "  user,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_hosts,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.user IS NULL, 'background', accounts.user) AS user,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       format_pico_time(SUM(stmt.total_latency)) AS statement_latency,\n"
  "       format_pico_time(IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0)) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       format_pico_time(SUM(io.io_latency)) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT host) AS unique_hosts,\n"
  "       format_bytes(SUM(mem.current_allocated)) AS current_memory,\n"
  "       format_bytes(SUM(mem.total_allocated)) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  LEFT JOIN sys.x$user_summary_by_statement_latency AS stmt ON IF(accounts.user IS NULL, 'background', accounts.user)"
  " = stmt.user\n"
  "  LEFT JOIN sys.x$user_summary_by_file_io AS io ON IF(accounts.user IS NULL, 'background', accounts.user) = io.user\n"
  "  LEFT JOIN sys.x$memory_by_user_by_current_bytes mem ON IF(accounts.user IS NULL, 'background', accounts.user) = mem"
  ".user\n"
  " GROUP BY IF(accounts.user IS NULL, 'background', accounts.user)\n"
  " ORDER BY SUM(stmt.total_latency) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$user_summary\n"
  "--\n"
  "-- Summarizes statement activity and connections by user\n"
  "-- \n"
  "-- When the user found is NULL, it is assumed to be a \"background\" thread.  \n"
  "--\n"
  "-- mysql> select * from x$user_summary;\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "-- | user | statements | total_latency   | avg_latency      | current_connections | total_connections | unique_hosts "
  "| current_memory | total_memory_allocated |\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "-- | root |       5685 | 107175100271000 | 18852260381.8821 |                   1 |                 1 |            1 "
  "|        1459022 |              572855680 |\n"
  "-- | mark |        225 |  14489223428000 | 64396548568.8889 |                   1 |                 1 |            1 "
  "|         724578 |               84958286 |\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$user_summary (\n"
  "  user,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_hosts,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.user IS NULL, 'background', accounts.user) AS user,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       SUM(stmt.total_latency) AS statement_latency,\n"
  "       IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       SUM(io.io_latency) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT host) AS unique_hosts,\n"
  "       SUM(mem.current_allocated) AS current_memory,\n"
  "       SUM(mem.total_allocated) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  LEFT JOIN sys.x$user_summary_by_statement_latency AS stmt ON IF(accounts.user IS NULL, 'background', accounts.user)"
  " = stmt.user\n"
  "  LEFT JOIN sys.x$user_summary_by_file_io AS io ON IF(accounts.user IS NULL, 'background', accounts.user) = io.user\n"
  "  LEFT JOIN sys.x$memory_by_user_by_current_bytes mem ON IF(accounts.user IS NULL, 'background', accounts.user) = mem"
  ".user\n"
  " GROUP BY IF(accounts.user IS NULL, 'background', accounts.user)\n"
  " ORDER BY SUM(stmt.total_latency) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary_by_file_io_type\n"
  "--\n"
  "-- Summarizes file IO by event type per host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from host_summary_by_file_io_type;\n"
  "-- +------------+--------------------------------------+-------+---------------+-------------+\n"
  "-- | host       | event_name                           | total | total_latency | max_latency |\n"
  "-- +------------+--------------------------------------+-------+---------------+-------------+\n"
  "-- | hal1       | wait/io/file/sql/FRM                 |   871 | 168.15 ms     | 18.48 ms    |\n"
  "-- | hal1       | wait/io/file/innodb/innodb_data_file |   173 | 129.56 ms     | 34.09 ms    |\n"
  "-- | hal1       | wait/io/file/innodb/innodb_log_file  |    20 | 77.53 ms      | 60.66 ms    |\n"
  "-- | hal1       | wait/io/file/myisam/dfile            |    40 | 6.54 ms       | 4.58 ms     |\n"
  "-- | hal1       | wait/io/file/mysys/charset           |     3 | 4.79 ms       | 4.71 ms     |\n"
  "-- | hal1       | wait/io/file/myisam/kfile            |    67 | 4.38 ms       | 300.04 us   |\n"
  "-- | hal1       | wait/io/file/sql/ERRMSG              |     5 | 2.72 ms       | 1.69 ms     |\n"
  "-- | hal1       | wait/io/file/sql/pid                 |     3 | 266.30 us     | 185.47 us   |\n"
  "-- | hal1       | wait/io/file/sql/casetest            |     5 | 246.81 us     | 150.19 us   |\n"
  "-- | hal1       | wait/io/file/sql/global_ddl_log      |     2 | 21.24 us      | 18.59 us    |\n"
  "-- | hal2       | wait/io/file/sql/file_parser         |  1422 | 4.80 s        | 135.14 ms   |\n"
  "-- | hal2       | wait/io/file/sql/FRM                 |   865 | 85.82 ms      | 9.81 ms     |\n"
  "-- | hal2       | wait/io/file/myisam/kfile            |  1073 | 37.14 ms      | 15.79 ms    |\n"
  "-- | hal2       | wait/io/file/myisam/dfile            |  2991 | 25.53 ms      | 5.25 ms     |\n"
  "-- | hal2       | wait/io/file/sql/dbopt               |    20 | 1.07 ms       | 153.07 us   |\n"
  "-- | hal2       | wait/io/file/sql/misc                |     4 | 59.71 us      | 33.75 us    |\n"
  "-- | hal2       | wait/io/file/archive/data            |     1 | 13.91 us      | 13.91 us    |\n"
  "-- +------------+--------------------------------------+-------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary_by_file_io_type (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary_by_file_io_type\n"
  "--\n"
  "-- Summarizes file IO by event type per host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary_by_file_io_type;\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "-- | host       | event_name                           | total | total_latency | max_latency  |\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "-- | hal1       | wait/io/file/sql/FRM                 |   871 |  168148450470 |  18482624810 |\n"
  "-- | hal1       | wait/io/file/innodb/innodb_data_file |   173 |  129564287450 |  34087423890 |\n"
  "-- | hal1       | wait/io/file/innodb/innodb_log_file  |    20 |   77525706960 |  60657475320 |\n"
  "-- | hal1       | wait/io/file/myisam/dfile            |    40 |    6544493800 |   4580546230 |\n"
  "-- | hal1       | wait/io/file/mysys/charset           |     3 |    4793558770 |   4713476430 |\n"
  "-- | hal1       | wait/io/file/myisam/kfile            |    67 |    4384332810 |    300035450 |\n"
  "-- | hal1       | wait/io/file/sql/ERRMSG              |     5 |    2717434850 |   1687316280 |\n"
  "-- | hal1       | wait/io/file/sql/pid                 |     3 |     266301490 |    185468920 |\n"
  "-- | hal1       | wait/io/file/sql/casetest            |     5 |     246814360 |    150193030 |\n"
  "-- | hal1       | wait/io/file/sql/global_ddl_log      |     2 |      21236410 |     18593640 |\n"
  "-- | hal2       | wait/io/file/sql/file_parser         |  1422 | 4801104756760 | 135138518970 |\n"
  "-- | hal2       | wait/io/file/sql/FRM                 |   865 |   85818594810 |   9812303410 |\n"
  "-- | hal2       | wait/io/file/myisam/kfile            |  1073 |   37143664870 |  15793838190 |\n"
  "-- | hal2       | wait/io/file/myisam/dfile            |  2991 |   25528215700 |   5252232050 |\n"
  "-- | hal2       | wait/io/file/sql/dbopt               |    20 |    1067339780 |    153073310 |\n"
  "-- | hal2       | wait/io/file/sql/misc                |     4 |      59713030 |     33752810 |\n"
  "-- | hal2       | wait/io/file/archive/data            |     1 |      13907530 |     13907530 |\n"
  "-- +------------+--------------------------------------+-------+---------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary_by_file_io_type (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file%'\n"
  "   AND count_star > 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary_by_file_io\n"
  "--\n"
  "-- Summarizes file IO totals per host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from host_summary_by_file_io;\n"
  "-- +------------+-------+------------+\n"
  "-- | host       | ios   | io_latency |\n"
  "-- +------------+-------+------------+\n"
  "-- | hal1       | 26457 | 21.58 s    |\n"
  "-- | hal2       |  1189 | 394.21 ms  |\n"
  "-- +------------+-------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary_by_file_io (\n"
  "  host,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS ios,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS io_latency \n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary_by_file_io\n"
  "--\n"
  "-- Summarizes file IO totals per host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary_by_file_io;\n"
  "-- +------------+-------+----------------+\n"
  "-- | host       | ios   | io_latency     |\n"
  "-- +------------+-------+----------------+\n"
  "-- | hal1       | 26457 | 21579585586390 |\n"
  "-- | hal2       |  1189 |   394212617370 |\n"
  "-- +------------+-------+----------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary_by_file_io (\n"
  "  host,\n"
  "  ios,\n"
  "  io_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS ios,\n"
  "       SUM(sum_timer_wait) AS io_latency \n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name LIKE 'wait/io/file/%'\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary_by_statement_type\n"
  "--\n"
  "-- Summarizes the types of statements executed by each host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from host_summary_by_statement_type;\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "-- | host | statement            | total  | total_latency | max_latency | lock_latency | rows_sent | rows_examined | "
  "rows_affected | full_scans |\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "-- | hal  | create_view          |   2063 | 00:05:04.20   | 463.58 ms   | 1.42 s       |         0 |             0 | "
  "            0 |          0 |\n"
  "-- | hal  | select               |    174 | 40.87 s       | 28.83 s     | 858.13 ms    |      5212 |        157022 | "
  "            0 |         82 |\n"
  "-- | hal  | stmt                 |   6645 | 15.31 s       | 491.78 ms   | 0 ps         |         0 |             0 | "
  "         7951 |          0 |\n"
  "-- | hal  | call_procedure       |     17 | 4.78 s        | 1.02 s      | 37.94 ms     |         0 |             0 | "
  "           19 |          0 |\n"
  "-- | hal  | create_table         |     19 | 3.04 s        | 431.71 ms   | 0 ps         |         0 |             0 | "
  "            0 |          0 |\n"
  "-- ...\n"
  "-- +------+----------------------+--------+---------------+-------------+--------------+-----------+---------------+-"
  "--------------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary_by_statement_type (\n"
  "  host,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency,\n"
  "       format_pico_time(sum_lock_time) AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary_by_statement_type\n"
  "--\n"
  "-- Summarizes the types of statements executed by each host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary_by_statement_type;\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "-- | host | statement            | total  | total_latency   | max_latency    | lock_latency   | rows_sent | rows_exam"
  "ined | rows_affected | full_scans |\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "-- | hal  | create_view          |   2110 | 312717366332000 |   463578029000 |  1432355000000 |         0 |          "
  "   0 |             0 |          0 |\n"
  "-- | hal  | select               |    177 |  41115690428000 | 28827579292000 |   858709000000 |      5254 |        15"
  "7437 |             0 |         83 |\n"
  "-- | hal  | stmt                 |   6645 |  15305389969000 |   491780297000 |              0 |         0 |          "
  "   0 |          7951 |          0 |\n"
  "-- | hal  | call_procedure       |     17 |   4783806053000 |  1016083397000 |    37936000000 |         0 |          "
  "   0 |            19 |          0 |\n"
  "-- | hal  | create_table         |     19 |   3035120946000 |   431706815000 |              0 |         0 |          "
  "   0 |             0 |          0 |\n"
  "-- ...\n"
  "-- +------+----------------------+--------+-----------------+----------------+----------------+-----------+----------"
  "-----+---------------+------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary_by_statement_type (\n"
  "  host,\n"
  "  statement,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUBSTRING_INDEX(event_name, '/', -1) AS statement,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       max_timer_wait AS max_latency,\n"
  "       sum_lock_time AS lock_latency,\n"
  "       sum_rows_sent AS rows_sent,\n"
  "       sum_rows_examined AS rows_examined,\n"
  "       sum_rows_affected AS rows_affected,\n"
  "       sum_no_index_used + sum_no_good_index_used AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary_by_statement_latency\n"
  "--\n"
  "-- Summarizes overall statement statistics by host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select-- from host_summary_by_statement_latency;\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "-- | host | total | total_latency | max_latency | lock_latency | rows_sent | rows_examined | rows_affected | full_sca"
  "ns |\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "-- | hal  |  3381 | 00:02:09.13   | 1.48 s      | 1.07 s       |      1151 |         93947 |           150 |         "
  "91 |\n"
  "-- +------+-------+---------------+-------------+--------------+-----------+---------------+---------------+---------"
  "---+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary_by_statement_latency (\n"
  "  host,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) AS max_latency,\n"
  "       format_pico_time(SUM(sum_lock_time)) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary_by_statement_latency\n"
  "--\n"
  "-- Summarizes overall statement statistics by host.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary_by_statement_latency;\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "-- | host | total | total_latency   | max_latency   | lock_latency  | rows_sent | rows_examined | rows_affected | ful"
  "l_scans |\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "-- | hal  |  3382 | 129134039432000 | 1483246743000 | 1069831000000 |      1152 |         94286 |           150 |    "
  "     92 |\n"
  "-- +------+-------+-----------------+---------------+---------------+-----------+---------------+---------------+----"
  "--------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary_by_statement_latency (\n"
  "  host,\n"
  "  total,\n"
  "  total_latency,\n"
  "  max_latency,\n"
  "  lock_latency,\n"
  "  rows_sent,\n"
  "  rows_examined,\n"
  "  rows_affected,\n"
  "  full_scans\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       SUM(count_star) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MAX(max_timer_wait) AS max_latency,\n"
  "       SUM(sum_lock_time) AS lock_latency,\n"
  "       SUM(sum_rows_sent) AS rows_sent,\n"
  "       SUM(sum_rows_examined) AS rows_examined,\n"
  "       SUM(sum_rows_affected) AS rows_affected,\n"
  "       SUM(sum_no_index_used) + SUM(sum_no_good_index_used) AS full_scans\n"
  "  FROM performance_schema.events_statements_summary_by_host_by_event_name\n"
  " GROUP BY IF(host IS NULL, 'background', host)\n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary_by_stages\n"
  "--\n"
  "-- Summarizes stages by host, ordered by host and total latency per stage.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from host_summary_by_stages;\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | host | event_name                     | total | total_latency | avg_latency |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | hal  | stage/sql/Opening tables       |   889 | 1.97 ms       | 2.22 us     |\n"
  "-- | hal  | stage/sql/Creating sort index  |     4 | 1.79 ms       | 446.30 us   |\n"
  "-- | hal  | stage/sql/init                 |    10 | 312.27 us     | 31.23 us    |\n"
  "-- | hal  | stage/sql/checking permissions |    10 | 300.62 us     | 30.06 us    |\n"
  "-- | hal  | stage/sql/freeing items        |     5 | 85.89 us      | 17.18 us    |\n"
  "-- | hal  | stage/sql/statistics           |     5 | 79.15 us      | 15.83 us    |\n"
  "-- | hal  | stage/sql/preparing            |     5 | 69.12 us      | 13.82 us    |\n"
  "-- | hal  | stage/sql/optimizing           |     5 | 53.11 us      | 10.62 us    |\n"
  "-- | hal  | stage/sql/Sending data         |     5 | 44.66 us      | 8.93 us     |\n"
  "-- | hal  | stage/sql/closing tables       |     5 | 37.54 us      | 7.51 us     |\n"
  "-- | hal  | stage/sql/System lock          |     5 | 34.28 us      | 6.86 us     |\n"
  "-- | hal  | stage/sql/query end            |     5 | 24.37 us      | 4.87 us     |\n"
  "-- | hal  | stage/sql/end                  |     5 | 8.60 us       | 1.72 us     |\n"
  "-- | hal  | stage/sql/Sorting result       |     5 | 8.33 us       | 1.67 us     |\n"
  "-- | hal  | stage/sql/executing            |     5 | 5.37 us       | 1.07 us     |\n"
  "-- | hal  | stage/sql/cleaning up          |     5 | 4.60 us       | 919.00 ns   |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary_by_stages (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency, \n"
  "       format_pico_time(avg_timer_wait) AS avg_latency \n"
  "  FROM performance_schema.events_stages_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary_by_stages\n"
  "--\n"
  "-- Summarizes stages by host, ordered by host and total latency per stage.\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary_by_stages;\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | host | event_name                     | total | total_latency | avg_latency |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "-- | hal  | stage/sql/Opening tables       |  1114 |   71919037000 |    64559000 |\n"
  "-- | hal  | stage/sql/Creating sort index  |     5 |    2245762000 |   449152000 |\n"
  "-- | hal  | stage/sql/init                 |    13 |     428798000 |    32984000 |\n"
  "-- | hal  | stage/sql/checking permissions |    13 |     363231000 |    27940000 |\n"
  "-- | hal  | stage/sql/freeing items        |     7 |     137728000 |    19675000 |\n"
  "-- | hal  | stage/sql/statistics           |     6 |      93955000 |    15659000 |\n"
  "-- | hal  | stage/sql/preparing            |     6 |      82571000 |    13761000 |\n"
  "-- | hal  | stage/sql/optimizing           |     6 |      63338000 |    10556000 |\n"
  "-- | hal  | stage/sql/Sending data         |     6 |      53400000 |     8900000 |\n"
  "-- | hal  | stage/sql/closing tables       |     7 |      46922000 |     6703000 |\n"
  "-- | hal  | stage/sql/System lock          |     6 |      40175000 |     6695000 |\n"
  "-- | hal  | stage/sql/query end            |     7 |      31723000 |     4531000 |\n"
  "-- | hal  | stage/sql/Sorting result       |     6 |       9855000 |     1642000 |\n"
  "-- | hal  | stage/sql/end                  |     6 |       9556000 |     1592000 |\n"
  "-- | hal  | stage/sql/cleaning up          |     7 |       7312000 |     1044000 |\n"
  "-- | hal  | stage/sql/executing            |     6 |       6487000 |     1081000 |\n"
  "-- +------+--------------------------------+-------+---------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary_by_stages (\n"
  "  host,\n"
  "  event_name,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency, \n"
  "       avg_timer_wait AS avg_latency \n"
  "  FROM performance_schema.events_stages_summary_by_host_by_event_name\n"
  " WHERE sum_timer_wait != 0\n"
  " ORDER BY IF(host IS NULL, 'background', host), sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: host_summary\n"
  "--\n"
  "-- Summarizes statement activity and connections by host\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from host_summary;\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "-- | host | statements | total_latency | avg_latency | current_connections | total_connections | unique_users | curre"
  "nt_memory | total_memory_allocated |\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "-- | hal1 |       5663 | 00:01:47.14   | 18.92 ms    |                   1 |                 1 |            1 | 1.41 "
  "MiB       | 543.55 MiB             |\n"
  "-- | hal2 |        225 | 14.49 s       | 64.40 ms    |                   1 |                 1 |            1 | 707.6"
  "0 KiB     | 81.02 MiB              |\n"
  "-- +------+------------+---------------+-------------+---------------------+-------------------+--------------+------"
  "----------+------------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW host_summary (\n"
  "  host,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_users,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.host IS NULL, 'background', accounts.host) AS host,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       format_pico_time(SUM(stmt.total_latency)) AS statement_latency,\n"
  "       format_pico_time(IFNULL(SUM(stmt.total_latency) / NULLIF(SUM(stmt.total), 0), 0)) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       format_pico_time(SUM(io.io_latency)) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT user) AS unique_users,\n"
  "       format_bytes(SUM(mem.current_allocated)) AS current_memory,\n"
  "       format_bytes(SUM(mem.total_allocated)) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  JOIN sys.x$host_summary_by_statement_latency AS stmt ON accounts.host = stmt.host\n"
  "  JOIN sys.x$host_summary_by_file_io AS io ON accounts.host = io.host\n"
  "  JOIN sys.x$memory_by_host_by_current_bytes mem ON accounts.host = mem.host\n"
  " GROUP BY IF(accounts.host IS NULL, 'background', accounts.host);\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$host_summary\n"
  "--\n"
  "-- Summarizes statement activity and connections by host\n"
  "--\n"
  "-- When the host found is NULL, it is assumed to be a \"background\" thread.\n"
  "--\n"
  "-- mysql> select * from x$host_summary;\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "-- | host | statements | total_latency   | avg_latency      | current_connections | total_connections | unique_users "
  "| current_memory | total_memory_allocated |\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "-- | hal1 |       5685 | 107175100271000 | 18852260381.8821 |                   1 |                 1 |            1 "
  "|        1459022 |              572855680 |\n"
  "-- | hal2 |        225 |  14489223428000 | 64396548568.8889 |                   1 |                 1 |            1 "
  "|         724578 |               84958286 |\n"
  "-- +------+------------+-----------------+------------------+---------------------+-------------------+--------------"
  "+----------------+------------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$host_summary (\n"
  "  host,\n"
  "  statements,\n"
  "  statement_latency,\n"
  "  statement_avg_latency,\n"
  "  table_scans,\n"
  "  file_ios,\n"
  "  file_io_latency,\n"
  "  current_connections,\n"
  "  total_connections,\n"
  "  unique_users,\n"
  "  current_memory,\n"
  "  total_memory_allocated\n"
  ") AS\n"
  "SELECT IF(accounts.host IS NULL, 'background', accounts.host) AS host,\n"
  "       SUM(stmt.total) AS statements,\n"
  "       SUM(stmt.total_latency) AS statement_latency,\n"
  "       SUM(stmt.total_latency) / SUM(stmt.total) AS statement_avg_latency,\n"
  "       SUM(stmt.full_scans) AS table_scans,\n"
  "       SUM(io.ios) AS file_ios,\n"
  "       SUM(io.io_latency) AS file_io_latency,\n"
  "       SUM(accounts.current_connections) AS current_connections,\n"
  "       SUM(accounts.total_connections) AS total_connections,\n"
  "       COUNT(DISTINCT accounts.user) AS unique_users,\n"
  "       SUM(mem.current_allocated) AS current_memory,\n"
  "       SUM(mem.total_allocated) AS total_memory_allocated\n"
  "  FROM performance_schema.accounts\n"
  "  JOIN sys.x$host_summary_by_statement_latency AS stmt ON accounts.host = stmt.host\n"
  "  JOIN sys.x$host_summary_by_file_io AS io ON accounts.host = io.host\n"
  "  JOIN sys.x$memory_by_host_by_current_bytes mem ON accounts.host = mem.host\n"
  " GROUP BY IF(accounts.host IS NULL, 'background', accounts.host);\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: wait_classes_global_by_avg_latency\n"
  "-- \n"
  "-- Lists the top wait classes by average latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from wait_classes_global_by_avg_latency where event_class != 'idle';\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "-- | event_class       | total  | total_latency | min_latency | avg_latency | max_latency |\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "-- | wait/io/file      | 543123 | 44.60 s       | 19.44 ns    | 82.11 us    | 4.21 s      |\n"
  "-- | wait/io/table     |  22002 | 766.60 ms     | 148.72 ns   | 34.84 us    | 44.97 ms    |\n"
  "-- | wait/io/socket    |  79613 | 967.17 ms     | 0 ps        | 12.15 us    | 27.10 ms    |\n"
  "-- | wait/lock/table   |  35409 | 18.68 ms      | 65.45 ns    | 527.51 ns   | 969.88 us   |\n"
  "-- | wait/synch/rwlock |  37935 | 4.61 ms       | 21.38 ns    | 121.61 ns   | 34.65 us    |\n"
  "-- | wait/synch/mutex  | 390622 | 18.60 ms      | 19.44 ns    | 47.61 ns    | 10.32 us    |\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW wait_classes_global_by_avg_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       format_pico_time(CAST(SUM(sum_timer_wait) AS UNSIGNED)) AS total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) AS min_latency,\n"
  "       format_pico_time(IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0)) AS avg_latency,\n"
  "       format_pico_time(CAST(MAX(max_timer_wait) AS UNSIGNED)) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY event_class\n"
  " ORDER BY IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$wait_classes_global_by_avg_latency\n"
  "-- \n"
  "-- Lists the top wait classes by average latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from x$wait_classes_global_by_avg_latency;\n"
  "-- +-------------------+---------+-------------------+-------------+--------------------+------------------+\n"
  "-- | event_class       | total   | total_latency     | min_latency | avg_latency        | max_latency      |\n"
  "-- +-------------------+---------+-------------------+-------------+--------------------+------------------+\n"
  "-- | idle              |    4331 | 16044682716000000 |     2000000 | 3704613880397.1369 | 1593550454000000 |\n"
  "-- | wait/io/file      |   23037 |    20856702551880 |           0 |     905356711.0249 |     350700491310 |\n"
  "-- | wait/io/table     |  224924 |      719670285750 |      116870 |       3199615.3623 |     208579012460 |\n"
  "-- | wait/lock/table   |    6972 |        3674766030 |      109330 |        527074.8752 |          8855730 |\n"
  "-- | wait/synch/rwlock |   11916 |        1273279800 |       37700 |        106854.6324 |          6838780 |\n"
  "-- | wait/synch/mutex  | 1031881 |       80464286240 |       56550 |         77978.2613 |       2590408470 |\n"
  "-- +-------------------+---------+-------------------+-------------+--------------------+------------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$wait_classes_global_by_avg_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class,\n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MIN(min_timer_wait) AS min_latency,\n"
  "       IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) AS avg_latency,\n"
  "       MAX(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY event_class\n"
  " ORDER BY IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: wait_classes_global_by_latency\n"
  "-- \n"
  "-- Lists the top wait classes by total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from wait_classes_global_by_latency;\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "-- | event_class       | total  | total_latency | min_latency | avg_latency | max_latency |\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "-- | wait/io/file      | 550470 | 46.01 s       | 19.44 ns    | 83.58 us    | 4.21 s      |\n"
  "-- | wait/io/socket    | 228833 | 2.71 s        | 0 ps        | 11.86 us    | 29.93 ms    |\n"
  "-- | wait/io/table     |  64063 | 1.89 s        | 99.79 ns    | 29.43 us    | 68.07 ms    |\n"
  "-- | wait/lock/table   |  76029 | 47.19 ms      | 65.45 ns    | 620.74 ns   | 969.88 us   |\n"
  "-- | wait/synch/mutex  | 635925 | 34.93 ms      | 19.44 ns    | 54.93 ns    | 107.70 us   |\n"
  "-- | wait/synch/rwlock |  61287 | 7.62 ms       | 21.38 ns    | 124.37 ns   | 34.65 us    |\n"
  "-- +-------------------+--------+---------------+-------------+-------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW wait_classes_global_by_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class, \n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       format_pico_time(SUM(sum_timer_wait)) AS total_latency,\n"
  "       format_pico_time(MIN(min_timer_wait)) min_latency,\n"
  "       format_pico_time(IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0)) AS avg_latency,\n"
  "       format_pico_time(MAX(max_timer_wait)) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY SUBSTRING_INDEX(event_name,'/', 3) \n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$wait_classes_global_by_latency\n"
  "-- \n"
  "-- Lists the top wait classes by total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> SELECT * FROM x$wait_classes_global_by_latency;\n"
  "-- +-------------------+---------+----------------+-------------+----------------+--------------+\n"
  "-- | event_class       | total   | total_latency  | min_latency | avg_latency    | max_latency  |\n"
  "-- +-------------------+---------+----------------+-------------+----------------+--------------+\n"
  "-- | wait/io/file      |   29468 | 27100905420290 |           0 | 919672370.7170 | 350700491310 |\n"
  "-- | wait/io/table     |  224924 |   719670285750 |      116870 |   3199615.3623 | 208579012460 |\n"
  "-- | wait/synch/mutex  | 1532036 |   118515948070 |       56550 |     77358.4616 |   2590408470 |\n"
  "-- | wait/io/socket    |    1193 |    10677541030 |           0 |   8950160.1257 |    287760330 |\n"
  "-- | wait/lock/table   |    6972 |     3674766030 |      109330 |    527074.8752 |      8855730 |\n"
  "-- | wait/synch/rwlock |   13646 |     1579833580 |       37700 |    115772.6499 |     28293850 |\n"
  "-- +-------------------+---------+----------------+-------------+----------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$wait_classes_global_by_latency (\n"
  "  event_class,\n"
  "  total,\n"
  "  total_latency,\n"
  "  min_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT SUBSTRING_INDEX(event_name,'/', 3) AS event_class, \n"
  "       SUM(COUNT_STAR) AS total,\n"
  "       SUM(sum_timer_wait) AS total_latency,\n"
  "       MIN(min_timer_wait) AS min_latency,\n"
  "       IFNULL(SUM(sum_timer_wait) / NULLIF(SUM(COUNT_STAR), 0), 0) AS avg_latency,\n"
  "       MAX(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE sum_timer_wait > 0\n"
  "   AND event_name != 'idle'\n"
  " GROUP BY SUBSTRING_INDEX(event_name,'/', 3) \n"
  " ORDER BY SUM(sum_timer_wait) DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: waits_by_user_by_latency\n"
  "--\n"
  "-- Lists the top wait events per user by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from waits_by_user_by_latency;\n"
  "-- +------+-----------------------------------------------------+--------+---------------+-------------+-------------"
  "+\n"
  "-- | user | event                                               | total  | total_latency | avg_latency | max_latency "
  "|\n"
  "-- +------+-----------------------------------------------------+--------+---------------+-------------+-------------"
  "+\n"
  "-- | root | wait/io/file/sql/file_parser                        |  13743 | 00:01:00.46   | 4.40 ms     | 231.88 ms   "
  "|\n"
  "-- | root | wait/io/file/innodb/innodb_data_file                |   4699 | 3.02 s        | 643.38 us   | 46.93 ms    "
  "|\n"
  "-- | root | wait/io/file/sql/FRM                                |  11462 | 2.60 s        | 226.83 us   | 61.72 ms    "
  "|\n"
  "-- | root | wait/io/file/myisam/dfile                           |  26776 | 746.70 ms     | 27.89 us    | 308.79 ms   "
  "|\n"
  "-- | root | wait/io/file/myisam/kfile                           |   7126 | 462.66 ms     | 64.93 us    | 88.76 ms    "
  "|\n"
  "-- | root | wait/io/file/sql/dbopt                              |    179 | 137.58 ms     | 768.59 us   | 15.46 ms    "
  "|\n"
  "-- | root | wait/io/file/csv/metadata                           |      8 | 86.60 ms      | 10.82 ms    | 50.32 ms    "
  "|\n"
  "-- | root | wait/synch/mutex/mysys/IO_CACHE::append_buffer_lock | 798080 | 66.46 ms      | 82.94 ns    | 161.03 us   "
  "|\n"
  "-- | root | wait/io/file/sql/binlog                             |     19 | 49.11 ms      | 2.58 ms     | 9.40 ms     "
  "|\n"
  "-- | root | wait/io/file/sql/misc                               |     26 | 22.38 ms      | 860.80 us   | 15.30 ms    "
  "|\n"
  "-- | root | wait/io/file/csv/data                               |      4 | 297.46 us     | 74.37 us    | 111.93 us   "
  "|\n"
  "-- | root | wait/synch/rwlock/sql/MDL_lock::rwlock              |    944 | 287.86 us     | 304.62 ns   | 874.64 ns   "
  "|\n"
  "-- | root | wait/io/file/archive/data                           |      4 | 82.71 us      | 20.68 us    | 40.74 us    "
  "|\n"
  "-- | root | wait/synch/mutex/myisam/MYISAM_SHARE::intern_lock   |     60 | 12.21 us      | 203.20 ns   | 512.72 ns   "
  "|\n"
  "-- | root | wait/synch/mutex/innodb/trx_mutex                   |     81 | 5.93 us       | 73.14 ns    | 252.59 ns   "
  "|\n"
  "-- +------+-----------------------------------------------------+--------+---------------+-------------+-------------"
  "+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW waits_by_user_by_latency (\n"
  "  user,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND user IS NOT NULL\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$waits_by_user_by_latency\n"
  "--\n"
  "-- Lists the top wait events per user by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from x$waits_by_user_by_latency;\n"
  "-- +------+-----------------------------------------------------+--------+----------------+-------------+------------"
  "--+\n"
  "-- | user | event                                               | total  | total_latency  | avg_latency | max_latency"
  "  |\n"
  "-- +------+-----------------------------------------------------+--------+----------------+-------------+------------"
  "--+\n"
  "-- | root | wait/io/file/sql/file_parser                        |  13745 | 60462025415480 |  4398837508 | 23188109217"
  "0 |\n"
  "-- | root | wait/io/file/innodb/innodb_data_file                |   4699 |  3023248450820 |   643381037 |  4692833418"
  "0 |\n"
  "-- | root | wait/io/file/sql/FRM                                |  11467 |  2600067790580 |   226743257 |  6171827792"
  "0 |\n"
  "-- | root | wait/io/file/myisam/dfile                           |  26776 |   746701506200 |    27886690 | 30878504696"
  "0 |\n"
  "-- | root | wait/io/file/myisam/kfile                           |   7126 |   462661061590 |    64925432 |  8875640878"
  "0 |\n"
  "-- | root | wait/io/file/sql/dbopt                              |    179 |   137577467690 |   768589146 |  1545719981"
  "0 |\n"
  "-- | root | wait/io/file/csv/metadata                           |      8 |    86599791590 | 10824973666 |  5032252927"
  "0 |\n"
  "-- | root | wait/synch/mutex/mysys/IO_CACHE::append_buffer_lock | 798080 |    66461175430 |       82940 |    16102801"
  "0 |\n"
  "-- | root | wait/io/file/sql/binlog                             |     19 |    49110632610 |  2584770058 |   940044976"
  "0 |\n"
  "-- | root | wait/io/file/sql/misc                               |     26 |    22380676630 |   860795052 |  1529847527"
  "0 |\n"
  "-- | root | wait/io/file/csv/data                               |      4 |      297460540 |    74365135 |    11193130"
  "0 |\n"
  "-- | root | wait/synch/rwlock/sql/MDL_lock::rwlock              |    944 |      287862120 |      304616 |       87464"
  "0 |\n"
  "-- | root | wait/io/file/archive/data                           |      4 |       82713800 |    20678450 |     4073862"
  "0 |\n"
  "-- | root | wait/synch/mutex/myisam/MYISAM_SHARE::intern_lock   |     60 |       12211030 |      203203 |       51272"
  "0 |\n"
  "-- | root | wait/synch/mutex/innodb/trx_mutex                   |     81 |        5926440 |       73138 |       25259"
  "0 |\n"
  "-- +------+-----------------------------------------------------+--------+----------------+-------------+------------"
  "--+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$waits_by_user_by_latency (\n"
  "  user,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(user IS NULL, 'background', user) AS user,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_user_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND user IS NOT NULL\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY user, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: waits_by_host_by_latency\n"
  "--\n"
  "-- Lists the top wait events per host by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from sys.waits_by_host_by_latency where host != 'background' limit 5;\n"
  "-- +-----------+------------------------------+-------+---------------+-------------+-------------+\n"
  "-- | host      | event                        | total | total_latency | avg_latency | max_latency |\n"
  "-- +-----------+------------------------------+-------+---------------+-------------+-------------+\n"
  "-- | localhost | wait/io/file/sql/file_parser |  1386 | 14.50 s       | 10.46 ms    | 357.36 ms   |\n"
  "-- | localhost | wait/io/file/sql/FRM         |   162 | 356.08 ms     | 2.20 ms     | 75.33 ms    |\n"
  "-- | localhost | wait/io/file/myisam/kfile    |   410 | 322.29 ms     | 786.08 us   | 65.98 ms    |\n"
  "-- | localhost | wait/io/file/myisam/dfile    |  1327 | 307.44 ms     | 231.68 us   | 37.16 ms    |\n"
  "-- | localhost | wait/io/file/sql/dbopt       |    89 | 180.34 ms     | 2.03 ms     | 63.41 ms    |\n"
  "-- +-----------+------------------------------+-------+---------------+-------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW waits_by_host_by_latency (\n"
  "  host,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY host, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: waits_by_host_by_latency\n"
  "--\n"
  "-- Lists the top wait events per host by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from sys.x$waits_by_host_by_latency where host != 'background' limit 5;\n"
  "-- +-----------+------------------------------+-------+----------------+-------------+--------------+\n"
  "-- | host      | event                        | total | total_latency  | avg_latency | max_latency  |\n"
  "-- +-----------+------------------------------+-------+----------------+-------------+--------------+\n"
  "-- | localhost | wait/io/file/sql/file_parser |  1388 | 14502657551590 | 10448600240 | 357364034170 |\n"
  "-- | localhost | wait/io/file/sql/FRM         |   167 |   361060236420 |  2162037319 |  75331088170 |\n"
  "-- | localhost | wait/io/file/myisam/kfile    |   410 |   322294755250 |   786084585 |  65978227120 |\n"
  "-- | localhost | wait/io/file/myisam/dfile    |  1327 |   307435262550 |   231676679 |  37162925800 |\n"
  "-- | localhost | wait/io/file/sql/dbopt       |    89 |   180341976360 |  2026314303 |  63405386850 |\n"
  "-- +-----------+------------------------------+-------+----------------+-------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$waits_by_host_by_latency (\n"
  "  host,\n"
  "  event,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT IF(host IS NULL, 'background', host) AS host,\n"
  "       event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_by_host_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY host, sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: waits_global_by_latency\n"
  "--\n"
  "-- Lists the top wait events by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from waits_global_by_latency limit 5;\n"
  "-- +--------------------------------------+------------+---------------+-------------+-------------+\n"
  "-- | event                                | total      | total_latency | avg_latency | max_latency |\n"
  "-- +--------------------------------------+------------+---------------+-------------+-------------+\n"
  "-- | wait/io/file/myisam/dfile            | 3623719744 | 00:47:49.09   | 791.70 ns   | 312.96 ms   |\n"
  "-- | wait/io/table/sql/handler            |   69114944 | 00:44:30.74   | 38.64 us    | 879.49 ms   |\n"
  "-- | wait/io/file/innodb/innodb_log_file  |   28100261 | 00:37:42.12   | 80.50 us    | 476.00 ms   |\n"
  "-- | wait/io/socket/sql/client_connection |  200704863 | 00:18:37.81   | 5.57 us     | 1.27 s      |\n"
  "-- | wait/io/file/innodb/innodb_data_file |    2829403 | 00:08:12.89   | 174.20 us   | 455.22 ms   |\n"
  "-- +--------------------------------------+------------+---------------+-------------+-------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW waits_global_by_latency (\n"
  "  events,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT event_name AS event,\n"
  "       count_star AS total,\n"
  "       format_pico_time(sum_timer_wait) AS total_latency,\n"
  "       format_pico_time(avg_timer_wait) AS avg_latency,\n"
  "       format_pico_time(max_timer_wait) AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$waits_global_by_latency\n"
  "--\n"
  "-- Lists the top wait events by their total latency, ignoring idle (this may be very large).\n"
  "--\n"
  "-- mysql> select * from x$waits_global_by_latency limit 5;\n"
  "-- +--------------------------------------+-------+---------------+-------------+--------------+\n"
  "-- | event                                | total | total_latency | avg_latency | max_latency  |\n"
  "-- +--------------------------------------+-------+---------------+-------------+--------------+\n"
  "-- | wait/io/file/sql/file_parser         |   679 | 3536136351540 |  5207858773 | 129860439800 |\n"
  "-- | wait/io/file/innodb/innodb_data_file |   195 |  848170566100 |  4349592637 | 350700491310 |\n"
  "-- | wait/io/file/sql/FRM                 |  1355 |  400428476500 |   295518990 |  44823120940 |\n"
  "-- | wait/io/file/innodb/innodb_log_file  |    20 |   54298899070 |  2714944765 |  30108124800 |\n"
  "-- | wait/io/file/mysys/charset           |     3 |   24244722970 |  8081574072 |  24151547420 |\n"
  "-- +--------------------------------------+-------+---------------+-------------+--------------+\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$waits_global_by_latency (\n"
  "  events,\n"
  "  total,\n"
  "  total_latency,\n"
  "  avg_latency,\n"
  "  max_latency\n"
  ") AS\n"
  "SELECT event_name AS event,\n"
  "       count_star AS total,\n"
  "       sum_timer_wait AS total_latency,\n"
  "       avg_timer_wait AS avg_latency,\n"
  "       max_timer_wait AS max_latency\n"
  "  FROM performance_schema.events_waits_summary_global_by_event_name\n"
  " WHERE event_name != 'idle'\n"
  "   AND sum_timer_wait > 0\n"
  " ORDER BY sum_timer_wait DESC;\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "--   This program is free software; you can redistribute it and/or modify\n"
  "--   it under the terms of the GNU General Public License as published by\n"
  "--   the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "--   This program is distributed in the hope that it will be useful,\n"
  "--   but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "--   GNU General Public License for more details.\n"
  "--\n"
  "--   You should have received a copy of the GNU General Public License\n"
  "--   along with this program; if not, write to the Free Software\n"
  "--   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA \n"
  "-- IMPORTANT\n"
  "-- If you update this view, also update the \"5.7+ and the Performance Schema disabled\"\n"
  "-- query in procedures/diagnostics.sql\n"
  "-- View: metrics\n"
  "-- \n"
  "-- Creates a union of the following information:\n"
  "--\n"
  "--    *  performance_schema.global_status\n"
  "--    *  information_schema.INNODB_METRICS\n"
  "--    *  Performance Schema global memory usage information\n"
  "--    *  Current time\n"
  "--\n"
  "-- For view has the following columns:\n"
  "-- \n"
  "--    * Variable_name: The name of the variable\n"
  "--    * Variable_value: The value of the variable\n"
  "--    * Type: The type of the variable. This will depend on the source, e.g. Global Status, InnoDB Metrics - ..., etc"
  ".\n"
  "--    * Enabled: Whether the variable is enabled or not. Possible values are 'YES', 'NO', 'PARTIAL'.\n"
  "--      PARTIAL is currently only supported for the memory usage variables and means some but not all of the memory/%"
  " instruments\n"
  "--      are enabled.\n"
  "--\n"
  "-- mysql> SELECT * FROM metrics;\n"
  "-- +-----------------------------------------------+-------------------------...+------------------------------------"
  "--+---------+\n"
  "-- | Variable_name                                 | Variable_value          ...| Type                               "
  "  | Enabled |\n"
  "-- +-----------------------------------------------+-------------------------...+------------------------------------"
  "--+---------+\n"
  "-- | aborted_clients                               | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | aborted_connects                              | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | binlog_cache_disk_use                         | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | binlog_cache_use                              | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | binlog_stmt_cache_disk_use                    | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | binlog_stmt_cache_use                         | 0                       ...| Global Status                      "
  "  | YES     |\n"
  "-- | bytes_received                                | 217081                  ...| Global Status                      "
  "  | YES     |\n"
  "-- | bytes_sent                                    | 27257                   ...| Global Status                      "
  "  | YES     |\n"
  "-- ...\n"
  "-- | innodb_rwlock_x_os_waits                      | 0                       ...| InnoDB Metrics - server            "
  "  | YES     |\n"
  "-- | innodb_rwlock_x_spin_rounds                   | 2723                    ...| InnoDB Metrics - server            "
  "  | YES     |\n"
  "-- | innodb_rwlock_x_spin_waits                    | 1                       ...| InnoDB Metrics - server            "
  "  | YES     |\n"
  "-- | trx_active_transactions                       | 0                       ...| InnoDB Metrics - transaction       "
  "  | NO      |\n"
  "-- ...\n"
  "-- | trx_rseg_current_size                         | 0                       ...| InnoDB Metrics - transaction       "
  "  | NO      |\n"
  "-- | trx_rseg_history_len                          | 4                       ...| InnoDB Metrics - transaction       "
  "  | YES     |\n"
  "-- | trx_rw_commits                                | 0                       ...| InnoDB Metrics - transaction       "
  "  | NO      |\n"
  "-- | trx_undo_slots_cached                         | 0                       ...| InnoDB Metrics - transaction       "
  "  | NO      |\n"
  "-- | trx_undo_slots_used                           | 0                       ...| InnoDB Metrics - transaction       "
  "  | NO      |\n"
  "-- | memory_current_allocated                      | 138244216               ...| Performance Schema                 "
  "  | PARTIAL |\n"
  "-- | memory_total_allocated                        | 138244216               ...| Performance Schema                 "
  "  | PARTIAL |\n"
  "-- | NOW()                                         | 2015-05-31 13:27:50.382 ...| System Time                        "
  "  | YES     |\n"
  "-- | UNIX_TIMESTAMP()                              | 1433042870.382          ...| System Time                        "
  "  | YES     |\n"
  "-- +-----------------------------------------------+-------------------------...+------------------------------------"
  "--+---------+\n"
  "-- 412 rows in set (0.02 sec)\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW metrics (\n"
  "  Variable_name,\n"
  "  Variable_value,\n"
  "  Type,\n"
  "  Enabled\n"
  ") AS\n"
  "(\n"
  "SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value, 'Global Status' AS Type, 'YES' AS Ena"
  "bled\n"
  "  FROM performance_schema.global_status\n"
  ") UNION ALL (\n"
  "SELECT NAME AS Variable_name, COUNT AS Variable_value,\n"
  "       CONCAT('InnoDB Metrics - ', SUBSYSTEM) AS Type,\n"
  "       IF(STATUS = 'enabled', 'YES', 'NO') AS Enabled\n"
  "  FROM information_schema.INNODB_METRICS\n"
  "  -- De duplication - some variables exists both in GLOBAL_STATUS and INNODB_METRICS\n"
  "  -- Keep the one from GLOBAL_STATUS as it is always enabled and it's more likely to be used for existing tools.\n"
  " WHERE NAME NOT IN (\n"
  "     'lock_row_lock_time', 'lock_row_lock_time_avg', 'lock_row_lock_time_max', 'lock_row_lock_waits',\n"
  "     'buffer_pool_reads', 'buffer_pool_read_requests', 'buffer_pool_write_requests', 'buffer_pool_wait_free',\n"
  "     'buffer_pool_read_ahead', 'buffer_pool_read_ahead_evicted', 'buffer_pool_pages_total', 'buffer_pool_pages_misc',"
  "\n"
  "     'buffer_pool_pages_data', 'buffer_pool_bytes_data', 'buffer_pool_pages_dirty', 'buffer_pool_bytes_dirty',\n"
  "     'buffer_pool_pages_free', 'buffer_pages_created', 'buffer_pages_written', 'buffer_pages_read',\n"
  "     'buffer_data_reads', 'buffer_data_written', 'file_num_open_files',\n"
  "     'os_log_bytes_written', 'os_log_fsyncs', 'os_log_pending_fsyncs', 'os_log_pending_writes',\n"
  "     'log_waits', 'log_write_requests', 'log_writes', 'innodb_dblwr_writes', 'innodb_dblwr_pages_written', 'innodb_pa"
  "ge_size')\n"
  ") UNION ALL (\n"
  "SELECT 'memory_current_allocated' AS Variable_name, SUM(CURRENT_NUMBER_OF_BYTES_USED) AS Variable_value, 'Performance"
  " Schema' AS Type,\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES')"
  " = 0, 'NO',\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'NO') "
  "= 0, 'YES',\n"
  "            'PARTIAL')) AS Enabled\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  ") UNION ALL (\n"
  "SELECT 'memory_total_allocated' AS Variable_name, SUM(SUM_NUMBER_OF_BYTES_ALLOC) AS Variable_value, 'Performance Sche"
  "ma' AS Type,\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'YES')"
  " = 0, 'NO',\n"
  "        IF((SELECT COUNT(*) FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'NO') "
  "= 0, 'YES',\n"
  "            'PARTIAL')) AS Enabled\n"
  "  FROM performance_schema.memory_summary_global_by_event_name\n"
  ") UNION ALL (\n"
  "SELECT 'NOW()' AS Variable_name, NOW(3) AS Variable_value, 'System Time' AS Type, 'YES' AS Enabled\n"
  ") UNION ALL (\n"
  "SELECT 'UNIX_TIMESTAMP()' AS Variable_name, ROUND(UNIX_TIMESTAMP(NOW(3)), 3) AS Variable_value, 'System Time' AS Type"
  ", 'YES' AS Enabled\n"
  ")\n"
  " ORDER BY Type, Variable_name;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: processlist\n"
  "--\n"
  "-- A detailed non-blocking processlist view to replace \n"
  "-- [INFORMATION_SCHEMA. | SHOW FULL] PROCESSLIST\n"
  "-- \n"
  "-- Performs less locking than the legacy sources, whilst giving extra information.\n"
  "--\n"
  "-- mysql> select * from sys.processlist where conn_id is not null and command != 'daemon' and conn_id != connection_i"
  "d()\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                 thd_id: 44524\n"
  "--                conn_id: 44502\n"
  "--                   user: msandbox@localhost\n"
  "--                     db: test\n"
  "--                command: Query\n"
  "--                  state: alter table (flush)\n"
  "--                   time: 18\n"
  "--      current_statement: alter table t1 add column g int\n"
  "--      statement_latency: 18.45 s\n"
  "--               progress: 98.84\n"
  "--           lock_latency: 265.43 ms\n"
  "--          rows_examined: 0\n"
  "--              rows_sent: 0\n"
  "--          rows_affected: 0\n"
  "--             tmp_tables: 0\n"
  "--        tmp_disk_tables: 0\n"
  "--              full_scan: NO\n"
  "--         last_statement: NULL\n"
  "-- last_statement_latency: NULL\n"
  "--         current_memory: 664.06 KiB\n"
  "--              last_wait: wait/io/file/innodb/innodb_data_file\n"
  "--      last_wait_latency: 1.07 us\n"
  "--                 source: fil0fil.cc:5146\n"
  "--            trx_latency: NULL\n"
  "--              trx_state: NULL\n"
  "--         trx_autocommit: NULL\n"
  "--                    pid: 4212\n"
  "--           program_name: mysql\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW processlist (\n"
  "  thd_id,\n"
  "  conn_id,\n"
  "  user,\n"
  "  db,\n"
  "  command,\n"
  "  state,\n"
  "  time,\n"
  "  current_statement,\n"
  "  statement_latency,\n"
  "  progress,\n"
  "  lock_latency,\n"
  "  rows_examined,\n"
  "  rows_sent,\n"
  "  rows_affected,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  full_scan,\n"
  "  last_statement,\n"
  "  last_statement_latency,\n"
  "  current_memory,\n"
  "  last_wait,\n"
  "  last_wait_latency,\n"
  "  source,\n"
  "  trx_latency,\n"
  "  trx_state,\n"
  "  trx_autocommit,\n"
  "  pid,\n"
  "  program_name\n"
  ") AS\n"
  "SELECT pps.thread_id AS thd_id,\n"
  "       pps.processlist_id AS conn_id,\n"
  "       IF(pps.name IN ('thread/sql/one_connection', 'thread/thread_pool/tp_one_connection'),\n"
  "          CONCAT(pps.processlist_user, '@', pps.processlist_host),\n"
  "          REPLACE(pps.name, 'thread/', '')) user,\n"
  "       pps.processlist_db AS db,\n"
  "       pps.processlist_command AS command,\n"
  "       pps.processlist_state AS state,\n"
  "       pps.processlist_time AS time,\n"
  "       sys.format_statement(pps.processlist_info) AS current_statement,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          format_pico_time(esc.timer_wait),\n"
  "          NULL) AS statement_latency,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          ROUND(100 * (estc.work_completed / estc.work_estimated), 2),\n"
  "          NULL) AS progress,\n"
  "       format_pico_time(esc.lock_time) AS lock_latency,\n"
  "       esc.rows_examined AS rows_examined,\n"
  "       esc.rows_sent AS rows_sent,\n"
  "       esc.rows_affected AS rows_affected,\n"
  "       esc.created_tmp_tables AS tmp_tables,\n"
  "       esc.created_tmp_disk_tables AS tmp_disk_tables,\n"
  "       IF(esc.no_good_index_used > 0 OR esc.no_index_used > 0, 'YES', 'NO') AS full_scan,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          sys.format_statement(esc.sql_text),\n"
  "          NULL) AS last_statement,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          format_pico_time(esc.timer_wait),\n"
  "          NULL) AS last_statement_latency,\n"
  "       format_bytes(mem.current_allocated) AS current_memory,\n"
  "       ewc.event_name AS last_wait,\n"
  "       IF(ewc.end_event_id IS NULL AND ewc.event_name IS NOT NULL,\n"
  "          'Still Waiting',\n"
  "          format_pico_time(ewc.timer_wait)) last_wait_latency,\n"
  "       ewc.source,\n"
  "       format_pico_time(etc.timer_wait) AS trx_latency,\n"
  "       etc.state AS trx_state,\n"
  "       etc.autocommit AS trx_autocommit,\n"
  "       conattr_pid.attr_value as pid,\n"
  "       conattr_progname.attr_value as program_name\n"
  "  FROM performance_schema.threads AS pps\n"
  "  LEFT JOIN performance_schema.events_waits_current AS ewc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_stages_current AS estc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_statements_current AS esc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_transactions_current AS etc USING (thread_id)\n"
  "  LEFT JOIN sys.x$memory_by_thread_by_current_bytes AS mem USING (thread_id)\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_pid\n"
  "    ON conattr_pid.processlist_id=pps.processlist_id and conattr_pid.attr_name='_pid'\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_progname\n"
  "    ON conattr_progname.processlist_id=pps.processlist_id and conattr_progname.attr_name='program_name'\n"
  " ORDER BY pps.processlist_time DESC, last_wait_latency DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$processlist\n"
  "--\n"
  "-- A detailed non-blocking processlist view to replace \n"
  "-- [INFORMATION_SCHEMA. | SHOW FULL] PROCESSLIST\n"
  "-- \n"
  "-- Performs less locking than the legacy sources, whilst giving extra information.\n"
  "--\n"
  "-- mysql> select * from sys.x$processlist where conn_id is not null and command != 'daemon' and conn_id != connection"
  "_id()\\G\n"
  "-- ...\n"
  "-- *************************** 2. row ***************************\n"
  "--                 thd_id: 720\n"
  "--                conn_id: 698\n"
  "--                   user: msandbox@localhost\n"
  "--                     db: test\n"
  "--                command: Query\n"
  "--                  state: alter table (read PK and internal sort)\n"
  "--                   time: 2\n"
  "--      current_statement: alter table t1 add column l int\n"
  "--      statement_latency: 2349834276374\n"
  "--               progress: 60.00\n"
  "--           lock_latency: 339707000000\n"
  "--          rows_examined: 0\n"
  "--              rows_sent: 0\n"
  "--          rows_affected: 0\n"
  "--             tmp_tables: 0\n"
  "--        tmp_disk_tables: 0\n"
  "--              full_scan: NO\n"
  "--         last_statement: NULL\n"
  "-- last_statement_latency: NULL\n"
  "--         current_memory: 10186821\n"
  "--              last_wait: wait/io/file/innodb/innodb_data_file\n"
  "--      last_wait_latency: Still Waiting\n"
  "--                 source: fil0fil.cc:5351\n"
  "--            trx_latency: NULL\n"
  "--              trx_state: NULL\n"
  "--         trx_autocommit: NULL\n"
  "--                    pid: 5559\n"
  "--           program_name: mysql\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = TEMPTABLE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW x$processlist (\n"
  "  thd_id,\n"
  "  conn_id,\n"
  "  user,\n"
  "  db,\n"
  "  command,\n"
  "  state,\n"
  "  time,\n"
  "  current_statement,\n"
  "  statement_latency,\n"
  "  progress,\n"
  "  lock_latency,\n"
  "  rows_examined,\n"
  "  rows_sent,\n"
  "  rows_affected,\n"
  "  tmp_tables,\n"
  "  tmp_disk_tables,\n"
  "  full_scan,\n"
  "  last_statement,\n"
  "  last_statement_latency,\n"
  "  current_memory,\n"
  "  last_wait,\n"
  "  last_wait_latency,\n"
  "  source,\n"
  "  trx_latency,\n"
  "  trx_state,\n"
  "  trx_autocommit,\n"
  "  pid,\n"
  "  program_name\n"
  ") AS\n"
  "SELECT pps.thread_id AS thd_id,\n"
  "       pps.processlist_id AS conn_id,\n"
  "       IF(pps.name IN ('thread/sql/one_connection', 'thread/thread_pool/tp_one_connection'),\n"
  "          CONCAT(pps.processlist_user, '@', pps.processlist_host),\n"
  "          REPLACE(pps.name, 'thread/', '')) user,\n"
  "       pps.processlist_db AS db,\n"
  "       pps.processlist_command AS command,\n"
  "       pps.processlist_state AS state,\n"
  "       pps.processlist_time AS time,\n"
  "       pps.processlist_info AS current_statement,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          esc.timer_wait,\n"
  "          NULL) AS statement_latency,\n"
  "       IF(esc.end_event_id IS NULL,\n"
  "          ROUND(100 * (estc.work_completed / estc.work_estimated), 2),\n"
  "          NULL) AS progress,\n"
  "       esc.lock_time AS lock_latency,\n"
  "       esc.rows_examined AS rows_examined,\n"
  "       esc.rows_sent AS rows_sent,\n"
  "       esc.rows_affected AS rows_affected,\n"
  "       esc.created_tmp_tables AS tmp_tables,\n"
  "       esc.created_tmp_disk_tables AS tmp_disk_tables,\n"
  "       IF(esc.no_good_index_used > 0 OR esc.no_index_used > 0, 'YES', 'NO') AS full_scan,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          esc.sql_text,\n"
  "          NULL) AS last_statement,\n"
  "       IF(esc.end_event_id IS NOT NULL,\n"
  "          esc.timer_wait,\n"
  "          NULL) AS last_statement_latency,\n"
  "       mem.current_allocated AS current_memory,\n"
  "       ewc.event_name AS last_wait,\n"
  "       IF(ewc.end_event_id IS NULL AND ewc.event_name IS NOT NULL,\n"
  "          'Still Waiting', \n"
  "          ewc.timer_wait) last_wait_latency,\n"
  "       ewc.source,\n"
  "       etc.timer_wait AS trx_latency,\n"
  "       etc.state AS trx_state,\n"
  "       etc.autocommit AS trx_autocommit,\n"
  "       conattr_pid.attr_value as pid,\n"
  "       conattr_progname.attr_value as program_name\n"
  "  FROM performance_schema.threads AS pps\n"
  "  LEFT JOIN performance_schema.events_waits_current AS ewc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_stages_current AS estc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_statements_current AS esc USING (thread_id)\n"
  "  LEFT JOIN performance_schema.events_transactions_current AS etc USING (thread_id)\n"
  "  LEFT JOIN sys.x$memory_by_thread_by_current_bytes AS mem USING (thread_id)\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_pid\n"
  "    ON conattr_pid.processlist_id=pps.processlist_id and conattr_pid.attr_name='_pid'\n"
  "  LEFT JOIN performance_schema.session_connect_attrs AS conattr_progname\n"
  "    ON conattr_progname.processlist_id=pps.processlist_id and conattr_progname.attr_name='program_name'\n"
  " ORDER BY pps.processlist_time DESC, last_wait_latency DESC;\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: session\n"
  "--\n"
  "-- Filter sys.processlist to only show user sessions and not background threads.\n"
  "-- This is a non-blocking closer replacement to\n"
  "-- [INFORMATION_SCHEMA. | SHOW FULL] PROCESSLIST\n"
  "-- \n"
  "-- Performs less locking than the legacy sources, whilst giving extra information.\n"
  "--\n"
  "-- mysql> select * from sys.session\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                 thd_id: 24\n"
  "--                conn_id: 2\n"
  "--                   user: root@localhost\n"
  "--                     db: sys\n"
  "--                command: Query\n"
  "--                  state: Sending data\n"
  "--                   time: 0\n"
  "--      current_statement: select * from sys.session\n"
  "--      statement_latency: 137.22 ms\n"
  "--               progress: NULL\n"
  "--           lock_latency: 33.75 ms\n"
  "--          rows_examined: 0\n"
  "--              rows_sent: 0\n"
  "--          rows_affected: 0\n"
  "--             tmp_tables: 4\n"
  "--        tmp_disk_tables: 1\n"
  "--              full_scan: YES\n"
  "--         last_statement: NULL\n"
  "-- last_statement_latency: NULL\n"
  "--         current_memory: 3.26 MiB\n"
  "--              last_wait: wait/synch/mutex/innodb/file_format_max_mutex\n"
  "--      last_wait_latency: 64.09 ns\n"
  "--                 source: trx0sys.cc:778\n"
  "--            trx_latency: 7.88 s\n"
  "--              trx_state: ACTIVE\n"
  "--         trx_autocommit: NO\n"
  "--                    pid: 4212\n"
  "--           program_name: mysql\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW session\n"
  " AS\n"
  "SELECT * FROM sys.processlist\n"
  "WHERE conn_id IS NOT NULL AND command != 'Daemon';\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: x$session\n"
  "--\n"
  "-- Filter sys.processlist to only show user sessions and not background threads.\n"
  "-- This is a non-blocking closer replacement to\n"
  "-- [INFORMATION_SCHEMA. | SHOW FULL] PROCESSLIST\n"
  "-- \n"
  "-- Performs less locking than the legacy sources, whilst giving extra information.\n"
  "--\n"
  "-- mysql> select * from sys.x$session\\G\n"
  "-- *************************** 1. row ***************************\n"
  "--                 thd_id: 24\n"
  "--                conn_id: 2\n"
  "--                   user: root@localhost\n"
  "--                     db: sys\n"
  "--                command: Query\n"
  "--                  state: Sending data\n"
  "--                   time: 0\n"
  "--      current_statement: select * from sys.x$session\n"
  "--      statement_latency: 16285980000\n"
  "--               progress: NULL\n"
  "--           lock_latency: 15450000000\n"
  "--          rows_examined: 0\n"
  "--              rows_sent: 0\n"
  "--          rows_affected: 0\n"
  "--             tmp_tables: 4\n"
  "--        tmp_disk_tables: 1\n"
  "--              full_scan: YES\n"
  "--         last_statement: NULL\n"
  "-- last_statement_latency: NULL\n"
  "--         current_memory: 3383772\n"
  "--              last_wait: wait/synch/mutex/innodb/trx_mutex\n"
  "--      last_wait_latency: 56550\n"
  "--                 source: trx0trx.h:1520\n"
  "--            trx_latency: 17893350207000\n"
  "--              trx_state: ACTIVE\n"
  "--         trx_autocommit: NO\n"
  "--                    pid: 5559\n"
  "--           program_name: mysql\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER \n"
  "VIEW x$session\n"
  " AS\n"
  "SELECT * FROM sys.x$processlist\n"
  "WHERE conn_id IS NOT NULL AND command != 'Daemon';\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "--\n"
  "-- View: session_ssl_status\n"
  "--\n"
  "-- Shows SSL version, cipher and the count of re-used SSL sessions per connection\n"
  "--\n"
  "-- mysql> select * from session_ssl_status;\n"
  "-- +-----------+-------------+--------------------+---------------------+\n"
  "-- | thread_id | ssl_version | ssl_cipher         | ssl_sessions_reused |\n"
  "-- +-----------+-------------+--------------------+---------------------+\n"
  "-- |        26 | TLSv1       | DHE-RSA-AES256-SHA | 0                   |\n"
  "-- |        27 | TLSv1       | DHE-RSA-AES256-SHA | 0                   |\n"
  "-- |        28 | TLSv1       | DHE-RSA-AES256-SHA | 0                   |\n"
  "-- +-----------+-------------+--------------------+---------------------+\n"
  "-- 3 rows in set (0.00 sec)\n"
  "--\n"
  "CREATE OR REPLACE\n"
  "  ALGORITHM = MERGE\n"
  "  DEFINER = 'mysql.sys'@'localhost'\n"
  "  SQL SECURITY INVOKER\n"
  "VIEW session_ssl_status (\n"
  "  thread_id,\n"
  "  ssl_version,\n"
  "  ssl_cipher,\n"
  "  ssl_sessions_reused\n"
  ") AS\n"
  "SELECT sslver.thread_id, \n"
  "       sslver.variable_value ssl_version, \n"
  "       sslcip.variable_value ssl_cipher,\n"
  "       sslreuse.variable_value ssl_sessions_reused\n"
  "  FROM performance_schema.status_by_thread sslver \n"
  "  LEFT JOIN performance_schema.status_by_thread sslcip \n"
  "    ON (sslcip.thread_id=sslver.thread_id and sslcip.variable_name='Ssl_cipher')\n"
  "  LEFT JOIN performance_schema.status_by_thread sslreuse \n"
  "    ON (sslreuse.thread_id=sslver.thread_id and sslreuse.variable_name='Ssl_sessions_reused') \n"
  " WHERE sslver.variable_name='Ssl_version';\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS create_synonym_db;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE create_synonym_db (\n"
  "        IN in_db_name VARCHAR(64), \n"
  "        IN in_synonym VARCHAR(64)\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes a source database name and synonym name, and then creates the \n"
  "synonym database with views that point to all of the tables within\n"
  "the source database.\n"
  "\n"
  "Useful for creating a \"ps\" synonym for \"performance_schema\",\n"
  "or \"is\" instead of \"information_schema\", for example.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_db_name (VARCHAR(64)):\n"
  "  The database name that you would like to create a synonym for.\n"
  "in_synonym (VARCHAR(64)):\n"
  "  The database synonym name.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> SHOW DATABASES;\n"
  "+--------------------+\n"
  "| Database           |\n"
  "+--------------------+\n"
  "| information_schema |\n"
  "| mysql              |\n"
  "| performance_schema |\n"
  "| sys                |\n"
  "| test               |\n"
  "+--------------------+\n"
  "5 rows in set (0.00 sec)\n"
  "\n"
  "mysql> CALL sys.create_synonym_db(\\'performance_schema\\', \\'ps\\');\n"
  "+---------------------------------------+\n"
  "| summary                               |\n"
  "+---------------------------------------+\n"
  "| Created 74 views in the `ps` database |\n"
  "+---------------------------------------+\n"
  "1 row in set (8.57 sec)\n"
  "\n"
  "Query OK, 0 rows affected (8.57 sec)\n"
  "\n"
  "mysql> SHOW DATABASES;\n"
  "+--------------------+\n"
  "| Database           |\n"
  "+--------------------+\n"
  "| information_schema |\n"
  "| mysql              |\n"
  "| performance_schema |\n"
  "| ps                 |\n"
  "| sys                |\n"
  "| test               |\n"
  "+--------------------+\n"
  "6 rows in set (0.00 sec)\n"
  "\n"
  "mysql> SHOW FULL TABLES FROM ps;\n"
  "+------------------------------------------------------+------------+\n"
  "| Tables_in_ps                                         | Table_type |\n"
  "+------------------------------------------------------+------------+\n"
  "| accounts                                             | VIEW       |\n"
  "| cond_instances                                       | VIEW       |\n"
  "| events_stages_current                                | VIEW       |\n"
  "| events_stages_history                                | VIEW       |\n"
  "...\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_db_name_check VARCHAR(64);\n"
  "    DECLARE v_db_err_msg TEXT;\n"
  "    DECLARE v_table VARCHAR(64);\n"
  "    DECLARE v_views_created INT DEFAULT 0;\n"
  "    DECLARE db_doesnt_exist CONDITION FOR SQLSTATE '42000';\n"
  "    DECLARE db_name_exists CONDITION FOR SQLSTATE 'HY000';\n"
  "    DECLARE c_table_names CURSOR FOR \n"
  "        SELECT TABLE_NAME \n"
  "          FROM INFORMATION_SCHEMA.TABLES \n"
  "         WHERE TABLE_SCHEMA = in_db_name;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    -- Check if the source database exists\n"
  "    SELECT SCHEMA_NAME INTO v_db_name_check\n"
  "      FROM INFORMATION_SCHEMA.SCHEMATA\n"
  "     WHERE SCHEMA_NAME = in_db_name;\n"
  "    IF v_db_name_check IS NULL THEN\n"
  "        SET v_db_err_msg = CONCAT('Unknown database ', in_db_name);\n"
  "        SIGNAL SQLSTATE 'HY000'\n"
  "            SET MESSAGE_TEXT = v_db_err_msg;\n"
  "    END IF;\n"
  "    -- Check if a database of the synonym name already exists\n"
  "    SELECT SCHEMA_NAME INTO v_db_name_check\n"
  "      FROM INFORMATION_SCHEMA.SCHEMATA\n"
  "     WHERE SCHEMA_NAME = in_synonym;\n"
  "    IF v_db_name_check = in_synonym THEN\n"
  "        SET v_db_err_msg = CONCAT('Can\\'t create database ', in_synonym, '; database exists');\n"
  "        SIGNAL SQLSTATE 'HY000'\n"
  "            SET MESSAGE_TEXT = v_db_err_msg;\n"
  "    END IF;\n"
  "    -- All good, create the database and views\n"
  "    SET @create_db_stmt := CONCAT('CREATE DATABASE ', sys.quote_identifier(in_synonym));\n"
  "    PREPARE create_db_stmt FROM @create_db_stmt;\n"
  "    EXECUTE create_db_stmt;\n"
  "    DEALLOCATE PREPARE create_db_stmt;\n"
  "    SET v_done = FALSE;\n"
  "    OPEN c_table_names;\n"
  "    c_table_names: LOOP\n"
  "        FETCH c_table_names INTO v_table;\n"
  "        IF v_done THEN\n"
  "            LEAVE c_table_names;\n"
  "        END IF;\n"
  "        SET @create_view_stmt = CONCAT(\n"
  "            'CREATE SQL SECURITY INVOKER VIEW ',\n"
  "            sys.quote_identifier(in_synonym),\n"
  "            '.',\n"
  "            sys.quote_identifier(v_table),\n"
  "            ' AS SELECT * FROM ',\n"
  "            sys.quote_identifier(in_db_name),\n"
  "            '.',\n"
  "            sys.quote_identifier(v_table)\n"
  "        );\n"
  "        PREPARE create_view_stmt FROM @create_view_stmt;\n"
  "        EXECUTE create_view_stmt;\n"
  "        DEALLOCATE PREPARE create_view_stmt;\n"
  "        SET v_views_created = v_views_created + 1;\n"
  "    END LOOP;\n"
  "    CLOSE c_table_names;\n"
  "    SELECT CONCAT(\n"
  "        'Created ', v_views_created, ' view',\n"
  "        IF(v_views_created != 1, 's', ''), ' in the ',\n"
  "        sys.quote_identifier(in_synonym), ' database'\n"
  "    ) AS summary;\n"
  "END\n",
"--  Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "--  This program is free software; you can redistribute it and/or modify\n"
  "--  it under the terms of the GNU General Public License as published by\n"
  "--  the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "--  This program is distributed in the hope that it will be useful,\n"
  "--  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "--  GNU General Public License for more details.\n"
  "--\n"
  "--  You should have received a copy of the GNU General Public License\n"
  "--  along with this program; if not, write to the Free Software\n"
  "--  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS execute_prepared_stmt;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE execute_prepared_stmt (\n"
  "        IN in_query longtext CHARACTER SET UTF8MB4\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Takes the query in the argument and executes it using a prepared statement. The prepared statement is deallocated,\n"
  "so the procedure is mainly useful for executing one off dynamically created queries.\n"
  "\n"
  "The sys_execute_prepared_stmt prepared statement name is used for the query and is required not to exist.\n"
  "\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_query (longtext CHARACTER SET UTF8MB4):\n"
  "  The query to execute.\n"
  "\n"
  "\n"
  "Configuration Options\n"
  "----------------------\n"
  "\n"
  "sys.debug\n"
  "  Whether to provide debugging output.\n"
  "  Default is ''OFF''. Set to ''ON'' to include.\n"
  "\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "mysql> CALL sys.execute_prepared_stmt(''SELECT * FROM sys.sys_config'');\n"
  "+------------------------+-------+---------------------+--------+\n"
  "| variable               | value | set_time            | set_by |\n"
  "+------------------------+-------+---------------------+--------+\n"
  "| statement_truncate_len | 64    | 2015-06-30 13:06:00 | NULL   |\n"
  "+------------------------+-------+---------------------+--------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    -- Set configuration options\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug = sys.sys_get_config('debug', 'OFF');\n"
  "    END IF;\n"
  "    -- Verify the query exists\n"
  "    -- The shortest possible query is \"DO 1\"\n"
  "    IF (in_query IS NULL OR LENGTH(in_query) < 4) THEN\n"
  "       SIGNAL SQLSTATE '45000'\n"
  "          SET MESSAGE_TEXT = \"The @sys.execute_prepared_stmt.sql must contain a query\";\n"
  "    END IF;\n"
  "    SET @sys.execute_prepared_stmt.sql = in_query;\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "        SELECT @sys.execute_prepared_stmt.sql AS 'Debug';\n"
  "    END IF;\n"
  "    PREPARE sys_execute_prepared_stmt FROM @sys.execute_prepared_stmt.sql;\n"
  "    EXECUTE sys_execute_prepared_stmt;\n"
  "    DEALLOCATE PREPARE sys_execute_prepared_stmt;\n"
  "    SET @sys.execute_prepared_stmt.sql = NULL;\n"
  "END\n",
"--  Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "-- \n"
  "--  This program is free software; you can redistribute it and/or modify\n"
  "--  it under the terms of the GNU General Public License as published by\n"
  "--  the Free Software Foundation; version 2 of the License.\n"
  "-- \n"
  "--  This program is distributed in the hope that it will be useful,\n"
  "--  but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "--  GNU General Public License for more details.\n"
  "-- \n"
  "--  You should have received a copy of the GNU General Public License\n"
  "--  along with this program; if not, write to the Free Software\n"
  "--  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA \n"
  "DROP PROCEDURE IF EXISTS diagnostics;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE diagnostics (\n"
  "        IN in_max_runtime int unsigned, IN in_interval int unsigned,\n"
  "        IN in_auto_config enum ('current', 'medium', 'full')\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Create a report of the current status of the server for diagnostics purposes. Data collected includes (some items dep"
  "ends on versions and settings):\n"
  "\n"
  "   * The GLOBAL VARIABLES\n"
  "   * Several sys schema views including metrics or equivalent (depending on version and settings)\n"
  "   * Queries in the 95th percentile\n"
  "   * Several ndbinfo views for MySQL Cluster\n"
  "   * Replication (both master and slave) information.\n"
  "\n"
  "Some of the sys schema views are calculated as initial (optional), overall, delta:\n"
  "\n"
  "   * The initial view is the content of the view at the start of this procedure.\n"
  "     This output will be the same as the the start values used for the delta view.\n"
  "     The initial view is included if @sys.diagnostics.include_raw = ''ON''.\n"
  "   * The overall view is the content of the view at the end of this procedure.\n"
  "     This output is the same as the end values used for the delta view.\n"
  "     The overall view is always included.\n"
  "   * The delta view is the difference from the beginning to the end. Note that for min and max values\n"
  "     they are simply the min or max value from the end view respectively, so does not necessarily reflect\n"
  "     the minimum/maximum value in the monitored period.\n"
  "     Note: except for the metrics views the delta is only calculation between the first and last outputs.\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_max_runtime (INT UNSIGNED):\n"
  "  The maximum time to keep collecting data.\n"
  "  Use NULL to get the default which is 60 seconds, otherwise enter a value greater than 0.\n"
  "in_interval (INT UNSIGNED):\n"
  "  How long to sleep between data collections.\n"
  "  Use NULL to get the default which is 30 seconds, otherwise enter a value greater than 0.\n"
  "in_auto_config (ENUM(''current'', ''medium'', ''full''))\n"
  "  Automatically enable Performance Schema instruments and consumers.\n"
  "  NOTE: The more that are enabled, the more impact on the performance.\n"
  "  Supported values are:\n"
  "     * current - use the current settings.\n"
  "     * medium - enable some settings. This requires the SUPER privilege.\n"
  "     * full - enables all settings. This will have a big impact on the\n"
  "              performance - be careful using this option. This requires\n"
  "              the SUPER privilege.\n"
  "  If another setting the ''current'' is chosen, the current settings\n"
  "  are restored at the end of the procedure.\n"
  "\n"
  "\n"
  "Configuration Options\n"
  "----------------------\n"
  "\n"
  "sys.diagnostics.allow_i_s_tables\n"
  "  Specifies whether it is allowed to do table scan queries on information_schema.TABLES. This can be expensive if the"
  "re\n"
  "  are many tables. Set to ''ON'' to allow, ''OFF'' to not allow.\n"
  "  Default is ''OFF''.\n"
  "\n"
  "sys.diagnostics.include_raw\n"
  "  Set to ''ON'' to include the raw data (e.g. the original output of \"SELECT * FROM sys.metrics\").\n"
  "  Use this to get the initial values of the various views.\n"
  "  Default is ''OFF''.\n"
  "\n"
  "sys.statement_truncate_len\n"
  "  How much of queries in the process list output to include.\n"
  "  Default is 64.\n"
  "\n"
  "sys.debug\n"
  "  Whether to provide debugging output.\n"
  "  Default is ''OFF''. Set to ''ON'' to include.\n"
  "\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "To create a report and append it to the file diag.out:\n"
  "\n"
  "mysql> TEE diag.out;\n"
  "mysql> CALL sys.diagnostics(120, 30, ''current'');\n"
  "...\n"
  "mysql> NOTEE;\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_start, v_runtime, v_iter_start, v_sleep DECIMAL(20,2) DEFAULT 0.0;\n"
  "    DECLARE v_has_innodb, v_has_ndb, v_has_ps, v_has_replication, v_has_ps_replication VARCHAR(8) CHARSET utf8mb4 DEF"
  "AULT 'NO';\n"
  "    DECLARE v_this_thread_enabled  ENUM('YES', 'NO');\n"
  "    DECLARE v_table_name, v_banner VARCHAR(64) CHARSET utf8mb4;\n"
  "    DECLARE v_sql_status_summary_select, v_sql_status_summary_delta, v_sql_status_summary_from, v_no_delta_names TEXT"
  ";\n"
  "    DECLARE v_output_time, v_output_time_prev DECIMAL(20,3) UNSIGNED;\n"
  "    DECLARE v_output_count, v_count, v_old_group_concat_max_len INT UNSIGNED DEFAULT 0;\n"
  "    -- The width of each of the status outputs in the summery\n"
  "    DECLARE v_status_summary_width TINYINT UNSIGNED DEFAULT 50;\n"
  "    DECLARE v_done BOOLEAN DEFAULT FALSE;\n"
  "    -- Do not include the following ndbinfo views:\n"
  "    --    'blocks'                    Static\n"
  "    --    'config_params'             Static\n"
  "    --    'dict_obj_types'            Static\n"
  "    --    'disk_write_speed_base'     Can generate lots of output - only include aggregate views here\n"
  "    --    'memory_per_fragment'       Can generate lots of output\n"
  "    --    'memoryusage'               Handled separately\n"
  "    --    'operations_per_fragment'   Can generate lots of output\n"
  "    --    'threadblocks'              Only needed once\n"
  "    DECLARE c_ndbinfo CURSOR FOR\n"
  "        SELECT TABLE_NAME\n"
  "          FROM information_schema.TABLES\n"
  "         WHERE TABLE_SCHEMA = 'ndbinfo'\n"
  "               AND TABLE_NAME NOT IN (\n"
  "                  'blocks',\n"
  "                  'config_params',\n"
  "                  'dict_obj_types',\n"
  "                  'disk_write_speed_base',\n"
  "                  'memory_per_fragment',\n"
  "                  'memoryusage',\n"
  "                  'operations_per_fragment',\n"
  "                  'threadblocks'\n"
  "               );\n"
  "    DECLARE c_sysviews_w_delta CURSOR FOR\n"
  "        SELECT table_name\n"
  "          FROM tmp_sys_views_delta\n"
  "         ORDER BY table_name;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    -- Do not track the current thread - no reason to clutter the output\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_"
  "ID();\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    -- Check options are sane\n"
  "    IF (in_max_runtime < in_interval) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_max_runtime must be greater than or equal to in_interval';\n"
  "    END IF;\n"
  "    IF (in_max_runtime = 0) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_max_runtime must be greater than 0';\n"
  "    END IF;\n"
  "    IF (in_interval = 0) THEN\n"
  "        SIGNAL SQLSTATE '45000'\n"
  "           SET MESSAGE_TEXT = 'in_interval must be greater than 0';\n"
  "    END IF;\n"
  "    -- Set configuration options\n"
  "    IF (@sys.diagnostics.allow_i_s_tables IS NULL) THEN\n"
  "        SET @sys.diagnostics.allow_i_s_tables = sys.sys_get_config('diagnostics.allow_i_s_tables', 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.diagnostics.include_raw IS NULL) THEN\n"
  "        SET @sys.diagnostics.include_raw      = sys.sys_get_config('diagnostics.include_raw'     , 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug                        = sys.sys_get_config('debug'                       , 'OFF');\n"
  "    END IF;\n"
  "    IF (@sys.statement_truncate_len IS NULL) THEN\n"
  "        SET @sys.statement_truncate_len       = sys.sys_get_config('statement_truncate_len'      , '64' );\n"
  "    END IF;\n"
  "    -- Temporary table are used - disable sql_log_bin if necessary to prevent them replicating\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = 0;\n"
  "    END IF;\n"
  "    -- Some metrics variables doesn't make sense in delta and rate calculations even if they are numeric\n"
  "    -- as they really are more like settings or \"current\" status.\n"
  "    SET v_no_delta_names = CONCAT('s%{COUNT}.Variable_name NOT IN (',\n"
  "        '''innodb_buffer_pool_pages_total'', ',\n"
  "        '''innodb_page_size'', ',\n"
  "        '''last_query_cost'', ',\n"
  "        '''last_query_partial_plans'', ',\n"
  "        '''qcache_total_blocks'', ',\n"
  "        '''slave_last_heartbeat'', ',\n"
  "        '''ssl_ctx_verify_depth'', ',\n"
  "        '''ssl_ctx_verify_mode'', ',\n"
  "        '''ssl_session_cache_size'', ',\n"
  "        '''ssl_verify_depth'', ',\n"
  "        '''ssl_verify_mode'', ',\n"
  "        '''ssl_version'', ',\n"
  "        '''buffer_flush_lsn_avg_rate'', ',\n"
  "        '''buffer_flush_pct_for_dirty'', ',\n"
  "        '''buffer_flush_pct_for_lsn'', ',\n"
  "        '''buffer_pool_pages_total'', ',\n"
  "        '''lock_row_lock_time_avg'', ',\n"
  "        '''lock_row_lock_time_max'', ',\n"
  "        '''innodb_page_size''',\n"
  "    ')');\n"
  "    IF (in_auto_config <> 'current') THEN\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('Updating Performance Schema configuration to ', in_auto_config) AS 'Debug';\n"
  "        END IF;\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        IF (in_auto_config = 'medium') THEN\n"
  "            -- Enable all consumers except %history and %history_long\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "                SET ENABLED = 'YES'\n"
  "            WHERE NAME NOT LIKE '%\\_history%';\n"
  "            -- Enable all instruments except wait/synch/%\n"
  "            UPDATE performance_schema.setup_instruments\n"
  "                SET ENABLED = 'YES',\n"
  "                    TIMED   = 'YES'\n"
  "            WHERE NAME NOT LIKE 'wait/synch/%';\n"
  "        ELSEIF (in_auto_config = 'full') THEN\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "                SET ENABLED = 'YES';\n"
  "            UPDATE performance_schema.setup_instruments\n"
  "                SET ENABLED = 'YES',\n"
  "                    TIMED   = 'YES';\n"
  "        END IF;\n"
  "        -- Enable all threads except this one\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = 'YES'\n"
  "         WHERE PROCESSLIST_ID <> CONNECTION_ID();\n"
  "    END IF;\n"
  "    SET v_start        = UNIX_TIMESTAMP(NOW(2)),\n"
  "        in_interval    = IFNULL(in_interval, 30),\n"
  "        in_max_runtime = IFNULL(in_max_runtime, 60);\n"
  "    -- Get a quick ref with hostname, server UUID, and the time for the report.\n"
  "    SET v_banner = REPEAT(\n"
  "                      '-',\n"
  "                      LEAST(\n"
  "                         GREATEST(\n"
  "                            36,\n"
  "                            CHAR_LENGTH(VERSION()),\n"
  "                            CHAR_LENGTH(@@global.version_comment),\n"
  "                            CHAR_LENGTH(@@global.version_compile_os),\n"
  "                            CHAR_LENGTH(@@global.version_compile_machine),\n"
  "                            CHAR_LENGTH(@@global.socket),\n"
  "                            CHAR_LENGTH(@@global.datadir)\n"
  "                         ),\n"
  "                         64\n"
  "                      )\n"
  "                   );\n"
  "    SELECT 'Hostname' AS 'Name', @@global.hostname AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Port' AS 'Name', @@global.port AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Socket' AS 'Name', @@global.socket AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Datadir' AS 'Name', @@global.datadir AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Server UUID' AS 'Name', @@global.server_uuid AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT REPEAT('-', 23) AS 'Name', v_banner AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'MySQL Version' AS 'Name', VERSION() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Sys Schema Version' AS 'Name', (SELECT sys_version FROM sys.version) AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Comment' AS 'Name', @@global.version_comment AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Compile OS' AS 'Name', @@global.version_compile_os AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Version Compile Machine' AS 'Name', @@global.version_compile_machine AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT REPEAT('-', 23) AS 'Name', v_banner AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'UTC Time' AS 'Name', UTC_TIMESTAMP() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Local Time' AS 'Name', NOW() AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Time Zone' AS 'Name', @@global.time_zone AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'System Time Zone' AS 'Name', @@global.system_time_zone AS 'Value'\n"
  "    UNION ALL\n"
  "    SELECT 'Time Zone Offset' AS 'Name', TIMEDIFF(NOW(), UTC_TIMESTAMP()) AS 'Value';\n"
  "    -- Are the InnoDB, NDBCluster, and Performance Schema storage engines present?\n"
  "    SET v_has_innodb         = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'InnoDB'), 'NO')"
  ",\n"
  "        v_has_ndb            = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'NDBCluster'), '"
  "NO'),\n"
  "        v_has_ps             = IFNULL((SELECT SUPPORT FROM information_schema.ENGINES WHERE ENGINE = 'PERFORMANCE_SCH"
  "EMA'), 'NO'),\n"
  "        v_has_ps_replication = v_has_ps,\n"
  "        v_has_replication    = IF(v_has_ps_replication = 'YES', IF((SELECT COUNT(*) FROM performance_schema.replicati"
  "on_connection_status) > 0, 'YES', 'NO'),\n"
  "                                  IF(@@master_info_repository = 'TABLE', IF((SELECT COUNT(*) FROM mysql.slave_master_"
  "info) > 0, 'YES', 'NO'),\n"
  "                                     IF(@@relay_log_info_repository = 'TABLE', IF((SELECT COUNT(*) FROM mysql.slave_r"
  "elay_log_info) > 0, 'YES', 'NO'),\n"
  "                                        'MAYBE')));\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "       SELECT v_has_innodb AS 'Has_InnoDB', v_has_ndb AS 'Has_NDBCluster',\n"
  "              v_has_ps AS 'Has_Performance_Schema',\n"
  "              v_has_ps_replication 'AS Has_P_S_Replication', v_has_replication AS 'Has_Replication';\n"
  "    END IF;\n"
  "    IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "        -- Need to use prepared statement as just having the query as a plain command\n"
  "        -- will generate an error if the InnoDB storage engine is not present\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE InnoDB STATUS';\n"
  "        PREPARE stmt_innodb_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        -- Need to use prepared statement as just having the query as a plain command\n"
  "        -- will generate an error if the InnoDB storage engine is not present\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE PERFORMANCE_SCHEMA STATUS';\n"
  "        PREPARE stmt_ps_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "        -- Need to use prepared statement as just having the query as a plain command\n"
  "        -- will generate an error if the NDBCluster storage engine is not present\n"
  "        SET @sys.diagnostics.sql = 'SHOW ENGINE NDBCLUSTER STATUS';\n"
  "        PREPARE stmt_ndbcluster_status FROM @sys.diagnostics.sql;\n"
  "    END IF;\n"
  "    SET @sys.diagnostics.sql_gen_query_template = 'SELECT CONCAT(\n"
  "           ''SELECT '',\n"
  "           GROUP_CONCAT(\n"
  "               CASE WHEN (SUBSTRING(TABLE_NAME, 3), COLUMN_NAME) IN (\n"
  "                                (''io_global_by_file_by_bytes'', ''total''),\n"
  "                                (''io_global_by_wait_by_bytes'', ''total_requested'')\n"
  "                         )\n"
  "                         THEN CONCAT(''format_bytes('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME LIKE ''%latency''\n"
  "                         THEN CONCAT(''format_pico_time('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -7) = ''_memory'' OR SUBSTRING(COLUMN_NAME, -17) = ''_memory_allocate"
  "d''\n"
  "                         OR ((SUBSTRING(COLUMN_NAME, -5) = ''_read'' OR SUBSTRING(COLUMN_NAME, -8) = ''_written'' OR "
  "SUBSTRING(COLUMN_NAME, -6) = ''_write'') AND SUBSTRING(COLUMN_NAME, 1, 6) <> ''COUNT_'')\n"
  "                         THEN CONCAT(''format_bytes('', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    ELSE COLUMN_NAME\n"
  "               END\n"
  "               ORDER BY ORDINAL_POSITION\n"
  "               SEPARATOR '',\\n       ''\n"
  "           ),\n"
  "           ''\\n  FROM tmp_'', SUBSTRING(TABLE_NAME FROM 3), ''_%{OUTPUT}''\n"
  "       ) AS Query INTO @sys.diagnostics.sql_select\n"
  "  FROM information_schema.COLUMNS\n"
  " WHERE TABLE_SCHEMA = ''sys'' AND TABLE_NAME = ?\n"
  " GROUP BY TABLE_NAME';\n"
  "    SET @sys.diagnostics.sql_gen_query_delta = 'SELECT CONCAT(\n"
  "           ''SELECT '',\n"
  "           GROUP_CONCAT(\n"
  "               CASE WHEN FIND_IN_SET(COLUMN_NAME COLLATE utf8_general_ci, diag.pk)\n"
  "                         THEN COLUMN_NAME\n"
  "                    WHEN diag.TABLE_NAME = ''io_global_by_file_by_bytes'' AND COLUMN_NAME COLLATE utf8_general_ci = '"
  "'write_pct''\n"
  "                         THEN CONCAT(''IFNULL(ROUND(100-(((e.total_read-IFNULL(s.total_read, 0))'',\n"
  "                                     ''/NULLIF(((e.total_read-IFNULL(s.total_read, 0))+(e.total_written-IFNULL(s.tota"
  "l_written, 0))), 0))*100), 2), 0.00) AS '',\n"
  "                                     COLUMN_NAME)\n"
  "                    WHEN (diag.TABLE_NAME, COLUMN_NAME) IN (\n"
  "                                (''io_global_by_file_by_bytes'', ''total''),\n"
  "                                (''io_global_by_wait_by_bytes'', ''total_requested'')\n"
  "                         )\n"
  "                         THEN CONCAT(''format_bytes(e.'', COLUMN_NAME, ''-IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', CO"
  "LUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, 1, 4) IN (''max_'', ''min_'') AND SUBSTRING(COLUMN_NAME, -8) = ''_lat"
  "ency''\n"
  "                         THEN CONCAT(''format_pico_time(e.'', COLUMN_NAME, '') AS '', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME COLLATE utf8_general_ci = ''avg_latency''\n"
  "                         THEN CONCAT(''format_pico_time((e.total_latency - IFNULL(s.total_latency, 0))'',\n"
  "                                     ''/NULLIF(e.total - IFNULL(s.total, 0), 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -12) = ''_avg_latency''\n"
  "                         THEN CONCAT(''format_pico_time((e.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NA"
  "ME)-12), ''_latency - IFNULL(s.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''_latency, 0))'',\n"
  "                                     ''/NULLIF(e.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), '"
  "'s - IFNULL(s.'', SUBSTRING(COLUMN_NAME FROM 1 FOR CHAR_LENGTH(COLUMN_NAME)-12), ''s, 0), 0)) AS '', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME LIKE ''%latency''\n"
  "                         THEN CONCAT(''format_pico_time(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS "
  "'', COLUMN_NAME)\n"
  "                    WHEN COLUMN_NAME IN (''avg_read'', ''avg_write'', ''avg_written'')\n"
  "                         THEN CONCAT(''format_bytes(IFNULL((e.total_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''wr"
  "itten''), ''-IFNULL(s.total_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''written''), '', 0))'',\n"
  "                                     ''/NULLIF(e.count_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''write''), ''-IF"
  "NULL(s.count_'', IF(COLUMN_NAME = ''avg_read'', ''read'', ''write''), '', 0), 0), 0)) AS '',\n"
  "                                     COLUMN_NAME)\n"
  "                    WHEN SUBSTRING(COLUMN_NAME, -7) = ''_memory'' OR SUBSTRING(COLUMN_NAME, -17) = ''_memory_allocate"
  "d''\n"
  "                         OR ((SUBSTRING(COLUMN_NAME, -5) = ''_read'' OR SUBSTRING(COLUMN_NAME, -8) = ''_written'' OR "
  "SUBSTRING(COLUMN_NAME, -6) = ''_write'') AND SUBSTRING(COLUMN_NAME, 1, 6) <> ''COUNT_'')\n"
  "                         THEN CONCAT(''format_bytes(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', "
  "COLUMN_NAME)\n"
  "                    ELSE CONCAT(''(e.'', COLUMN_NAME, '' - IFNULL(s.'', COLUMN_NAME, '', 0)) AS '', COLUMN_NAME)\n"
  "               END\n"
  "               ORDER BY ORDINAL_POSITION\n"
  "               SEPARATOR '',\\n       ''\n"
  "           ),\n"
  "           ''\\n  FROM tmp_'', diag.TABLE_NAME, ''_end e\n"
  "       LEFT OUTER JOIN tmp_'', diag.TABLE_NAME, ''_start s USING ('', diag.pk, '')''\n"
  "       ) AS Query INTO @sys.diagnostics.sql_select\n"
  "  FROM tmp_sys_views_delta diag\n"
  "       INNER JOIN information_schema.COLUMNS c ON c.TABLE_NAME COLLATE utf8_general_ci = CONCAT(''x$'', diag.TABLE_NA"
  "ME)\n"
  " WHERE c.TABLE_SCHEMA = ''sys'' AND diag.TABLE_NAME = ?\n"
  " GROUP BY diag.TABLE_NAME';\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        -- Create temporary table with the ORDER BY clauses. Will be required both for the initial (if included) and "
  "end queries\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_sys_views_delta;\n"
  "        CREATE TEMPORARY TABLE tmp_sys_views_delta (\n"
  "            TABLE_NAME varchar(64) NOT NULL,\n"
  "            order_by text COMMENT 'ORDER BY clause for the initial and overall views',\n"
  "            order_by_delta text COMMENT 'ORDER BY clause for the delta views',\n"
  "            where_delta text COMMENT 'WHERE clause to use for delta views to only include rows with a \"count\" > 0',"
  "\n"
  "            limit_rows int unsigned COMMENT 'The maximum number of rows to include for the view',\n"
  "            pk varchar(128) COMMENT 'Used with the FIND_IN_SET() function so use comma separated list without whitesp"
  "ace',\n"
  "            PRIMARY KEY (TABLE_NAME)\n"
  "        );\n"
  "        -- %{OUTPUT} will be replace by the suffix used for the output.\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'Populating tmp_sys_views_delta' AS 'Debug';\n"
  "        END IF;\n"
  "        INSERT INTO tmp_sys_views_delta\n"
  "        VALUES ('host_summary'                       , '%{TABLE}.statement_latency DESC',\n"
  "                                                       '(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC',\n"
  "                                                       '(e.statements - IFNULL(s.statements, 0)) > 0', NULL, 'host'),"
  "\n"
  "               ('host_summary_by_file_io'            , '%{TABLE}.io_latency DESC',\n"
  "                                                       '(e.io_latency-IFNULL(s.io_latency, 0)) DESC',\n"
  "                                                       '(e.ios - IFNULL(s.ios, 0)) > 0', NULL, 'host'),\n"
  "               ('host_summary_by_file_io_type'       , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event_name')"
  ",\n"
  "               ('host_summary_by_stages'             , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event_name')"
  ",\n"
  "               ('host_summary_by_statement_latency'  , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host'),\n"
  "               ('host_summary_by_statement_type'     , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,statement'),"
  "\n"
  "               ('io_by_thread_by_latency'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,thread_id,pr"
  "ocesslist_id'),\n"
  "               ('io_global_by_file_by_bytes'         , '%{TABLE}.total DESC',\n"
  "                                                       '(e.total-IFNULL(s.total, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', 100, 'file'),\n"
  "               ('io_global_by_file_by_latency'       , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', 100, 'file'),\n"
  "               ('io_global_by_wait_by_bytes'         , '%{TABLE}.total_requested DESC',\n"
  "                                                       '(e.total_requested-IFNULL(s.total_requested, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_name'),\n"
  "               ('io_global_by_wait_by_latency'       , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_name'),\n"
  "               ('schema_index_statistics'            , '(%{TABLE}.select_latency+%{TABLE}.insert_latency+%{TABLE}.upd"
  "ate_latency+%{TABLE}.delete_latency) DESC',\n"
  "                                                       '((e.select_latency+e.insert_latency+e.update_latency+e.delete"
  "_latency)-IFNULL(s.select_latency+s.insert_latency+s.update_latency+s.delete_latency, 0)) DESC',\n"
  "                                                       '((e.rows_selected+e.insert_latency+e.rows_updated+e.rows_dele"
  "ted)-IFNULL(s.rows_selected+s.rows_inserted+s.rows_updated+s.rows_deleted, 0)) > 0',\n"
  "                                                       100, 'table_schema,table_name,index_name'),\n"
  "               ('schema_table_statistics'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) > 0', 100, 'tabl"
  "e_schema,table_name'),\n"
  "               ('schema_tables_with_full_table_scans', '%{TABLE}.rows_full_scanned DESC',\n"
  "                                                       '(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) DESC',\n"
  "                                                       '(e.rows_full_scanned-IFNULL(s.rows_full_scanned, 0)) > 0', 10"
  "0, 'object_schema,object_name'),\n"
  "               ('user_summary'                       , '%{TABLE}.statement_latency DESC',\n"
  "                                                       '(e.statement_latency-IFNULL(s.statement_latency, 0)) DESC',\n"
  "                                                       '(e.statements - IFNULL(s.statements, 0)) > 0', NULL, 'user'),"
  "\n"
  "               ('user_summary_by_file_io'            , '%{TABLE}.io_latency DESC',\n"
  "                                                       '(e.io_latency-IFNULL(s.io_latency, 0)) DESC',\n"
  "                                                       '(e.ios - IFNULL(s.ios, 0)) > 0', NULL, 'user'),\n"
  "               ('user_summary_by_file_io_type'       , '%{TABLE}.user, %{TABLE}.latency DESC',\n"
  "                                                       'e.user, (e.latency-IFNULL(s.latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event_name')"
  ",\n"
  "               ('user_summary_by_stages'             , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event_name')"
  ",\n"
  "               ('user_summary_by_statement_latency'  , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user'),\n"
  "               ('user_summary_by_statement_type'     , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,statement'),"
  "\n"
  "               ('wait_classes_global_by_avg_latency' , 'IFNULL(%{TABLE}.total_latency / NULLIF(%{TABLE}.total, 0), 0)"
  " DESC',\n"
  "                                                       'IFNULL((e.total_latency-IFNULL(s.total_latency, 0)) / NULLIF("
  "(e.total - IFNULL(s.total, 0)), 0), 0) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_class'),\n"
  "               ('wait_classes_global_by_latency'     , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'event_class'),\n"
  "               ('waits_by_host_by_latency'           , '%{TABLE}.host, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.host, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'host,event'),\n"
  "               ('waits_by_user_by_latency'           , '%{TABLE}.user, %{TABLE}.total_latency DESC',\n"
  "                                                       'e.user, (e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'user,event'),\n"
  "               ('waits_global_by_latency'            , '%{TABLE}.total_latency DESC',\n"
  "                                                       '(e.total_latency-IFNULL(s.total_latency, 0)) DESC',\n"
  "                                                       '(e.total - IFNULL(s.total, 0)) > 0', NULL, 'events')\n"
  "        ;\n"
  "    END IF;\n"
  "    SELECT '\n"
  "\n"
  "=======================\n"
  "\n"
  "     Configuration\n"
  "\n"
  "=======================\n"
  "\n"
  "' AS '';\n"
  "    -- Get the configuration.\n"
  "    SELECT 'GLOBAL VARIABLES' AS 'The following output is:';\n"
  "    SELECT LOWER(VARIABLE_NAME) AS Variable_name, VARIABLE_VALUE AS Variable_value FROM performance_schema.global_var"
  "iables ORDER BY VARIABLE_NAME;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        -- Overview of the Performance Schema dynamic settings used for this report.\n"
  "        SELECT 'Performance Schema Setup - Actors' AS 'The following output is:';\n"
  "        SELECT * FROM performance_schema.setup_actors;\n"
  "        SELECT 'Performance Schema Setup - Consumers' AS 'The following output is:';\n"
  "        SELECT NAME AS Consumer, ENABLED, sys.ps_is_consumer_enabled(NAME) AS COLLECTS\n"
  "          FROM performance_schema.setup_consumers;\n"
  "        SELECT 'Performance Schema Setup - Instruments' AS 'The following output is:';\n"
  "        SELECT SUBSTRING_INDEX(NAME, '/', 2) AS 'InstrumentClass',\n"
  "               ROUND(100*SUM(IF(ENABLED = 'YES', 1, 0))/COUNT(*), 2) AS 'EnabledPct',\n"
  "               ROUND(100*SUM(IF(TIMED = 'YES', 1, 0))/COUNT(*), 2) AS 'TimedPct'\n"
  "          FROM performance_schema.setup_instruments\n"
  "         GROUP BY SUBSTRING_INDEX(NAME, '/', 2)\n"
  "         ORDER BY SUBSTRING_INDEX(NAME, '/', 2);\n"
  "        SELECT 'Performance Schema Setup - Objects' AS 'The following output is:';\n"
  "        SELECT * FROM performance_schema.setup_objects;\n"
  "        SELECT 'Performance Schema Setup - Threads' AS 'The following output is:';\n"
  "        SELECT `TYPE` AS ThreadType, COUNT(*) AS 'Total', ROUND(100*SUM(IF(INSTRUMENTED = 'YES', 1, 0))/COUNT(*), 2) "
  "AS 'InstrumentedPct'\n"
  "          FROM performance_schema.threads\n"
  "        GROUP BY TYPE;\n"
  "    END IF;\n"
  "    IF (v_has_replication = 'NO') THEN\n"
  "        SELECT 'No Replication Configured' AS 'Replication Status';\n"
  "    ELSE\n"
  "        -- No guarantee that replication is actually configured, but we can't really know\n"
  "        SELECT CONCAT('Replication Configured: ', v_has_replication, ' - Performance Schema Replication Tables: ', v_"
  "has_ps_replication) AS 'Replication Status';\n"
  "        IF (v_has_ps_replication = 'YES') THEN\n"
  "            SELECT 'Replication - Connection Configuration' AS 'The following output is:';\n"
  "            SELECT * FROM performance_schema.replication_connection_configuration ORDER BY CHANNEL_NAME;\n"
  "        END IF;\n"
  "        IF (v_has_ps_replication = 'YES') THEN\n"
  "            SELECT 'Replication - Applier Configuration' AS 'The following output is:';\n"
  "            SELECT * FROM performance_schema.replication_applier_configuration ORDER BY CHANNEL_NAME;\n"
  "        END IF;\n"
  "        IF (@@master_info_repository = 'TABLE') THEN\n"
  "            SELECT 'Replication - Master Info Repository Configuration' AS 'The following output is:';\n"
  "            -- Can't just do SELECT *  as the password may be present in plain text\n"
  "            -- Don't include binary log file and position as that will be determined in each iteration as well\n"
  "            SELECT Channel_name, Host, User_name, Port, Connect_retry,\n"
  "                   Enabled_ssl, Ssl_ca, Ssl_capath, Ssl_cert, Ssl_cipher, Ssl_key, Ssl_verify_server_cert,\n"
  "                   Heartbeat, Bind, Ignored_server_ids, Uuid, Retry_count, Ssl_crl, Ssl_crlpath,\n"
  "                   Tls_version, Enabled_auto_position\n"
  "              FROM mysql.slave_master_info ORDER BY Channel_name;\n"
  "        END IF;\n"
  "        IF (@@relay_log_info_repository = 'TABLE') THEN\n"
  "            SELECT 'Replication - Relay Log Repository Configuration' AS 'The following output is:';\n"
  "            SELECT Channel_name, Sql_delay, Number_of_workers, Id\n"
  "              FROM mysql.slave_relay_log_info ORDER BY Channel_name;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "       SELECT 'Cluster Thread Blocks' AS 'The following output is:';\n"
  "       SELECT * FROM ndbinfo.threadblocks;\n"
  "    END IF;\n"
  "    -- For a number of sys views as well as events_statements_summary_by_digest,\n"
  "    -- just get the start data and then at the end output the overall and delta values\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            SELECT '\n"
  "\n"
  "========================\n"
  "\n"
  "     Initial Status\n"
  "\n"
  "========================\n"
  "\n"
  "' AS '';\n"
  "        END IF;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_digests_start;\n"
  "        CALL sys.statement_performance_analyzer('create_tmp', 'tmp_digests_start', NULL);\n"
  "        CALL sys.statement_performance_analyzer('snapshot', NULL, NULL);\n"
  "        CALL sys.statement_performance_analyzer('save', 'tmp_digests_start', NULL);\n"
  "        -- Loop over the sys views where deltas should be calculated.\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, '%{OUTPUT}', 'start');\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT 'The following query will be used to generate the query for each sys view' AS 'Debug';\n"
  "                SELECT @sys.diagnostics.sql AS 'Debug';\n"
  "            END IF;\n"
  "            PREPARE stmt_gen_query FROM @sys.diagnostics.sql;\n"
  "        END IF;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT CONCAT('The following queries are for storing the initial content of ', v_table_name) AS 'Debu"
  "g';\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS `tmp_', v_table_name, '_start`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE `tmp_', v_table_name, '_start` SELECT * FRO"
  "M `sys`.`x$', v_table_name, '`'));\n"
  "            IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "                SET @sys.diagnostics.table_name = CONCAT('x$', v_table_name);\n"
  "                EXECUTE stmt_gen_query USING @sys.diagnostics.table_name;\n"
  "                -- If necessary add ORDER BY and LIMIT\n"
  "                SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                              IF(order_by IS NOT NULL, CONCAT('\\n ORDER BY ', REPLACE(order_by, '%{TABLE}', CONCAT('t"
  "mp_', v_table_name, '_start'))), ''),\n"
  "                              IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                       )\n"
  "                  INTO @sys.diagnostics.sql_select\n"
  "                  FROM tmp_sys_views_delta\n"
  "                 WHERE TABLE_NAME COLLATE utf8mb4_0900_as_ci = v_table_name;\n"
  "                SELECT CONCAT('Initial ', v_table_name) AS 'The following output is:';\n"
  "                CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "            END IF;\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            DEALLOCATE PREPARE stmt_gen_query;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    -- If in_include_status_summary is TRUE then a temporary table is required to store the data\n"
  "    SET v_sql_status_summary_select = 'SELECT Variable_name',\n"
  "        v_sql_status_summary_delta  = '',\n"
  "        v_sql_status_summary_from   = '';\n"
  "    -- Start the loop\n"
  "    REPEAT\n"
  "        SET v_output_count = v_output_count + 1;\n"
  "        IF (v_output_count > 1) THEN\n"
  "            -- Don't sleep on the first execution\n"
  "            SET v_sleep = in_interval-(UNIX_TIMESTAMP(NOW(2))-v_iter_start);\n"
  "            SELECT NOW() AS 'Time', CONCAT('Going to sleep for ', v_sleep, ' seconds. Please do not interrupt') AS 'T"
  "he following output is:';\n"
  "            DO SLEEP(in_interval);\n"
  "        END IF;\n"
  "        SET v_iter_start = UNIX_TIMESTAMP(NOW(2));\n"
  "        SELECT NOW(), CONCAT('Iteration Number ', IFNULL(v_output_count, 'NULL')) AS 'The following output is:';\n"
  "        -- Even in 5.7 there is no way to get all the info from SHOW MASTER|SLAVE STATUS using the Performance Schema"
  " or\n"
  "        -- other tables, so include them even though they are no longer optimal solutions and if present get the addi"
  "tional\n"
  "        -- information from the other tables available.\n"
  "        IF (@@log_bin = 1) THEN\n"
  "            SELECT 'SHOW MASTER STATUS' AS 'The following output is:';\n"
  "            SHOW MASTER STATUS;\n"
  "        END IF;\n"
  "        IF (v_has_replication <> 'NO') THEN\n"
  "            SELECT 'SHOW SLAVE STATUS' AS 'The following output is:';\n"
  "            SHOW SLAVE STATUS;\n"
  "            IF (v_has_ps_replication = 'YES') THEN\n"
  "                SELECT 'Replication Connection Status' AS 'The following output is:';\n"
  "                SELECT * FROM performance_schema.replication_connection_status;\n"
  "                SELECT 'Replication Applier Status' AS 'The following output is:';\n"
  "                SELECT * FROM performance_schema.replication_applier_status ORDER BY CHANNEL_NAME;\n"
  "                SELECT 'Replication Applier Status - Coordinator' AS 'The following output is:';\n"
  "                SELECT * FROM performance_schema.replication_applier_status_by_coordinator ORDER BY CHANNEL_NAME;\n"
  "                SELECT 'Replication Applier Status - Worker' AS 'The following output is:';\n"
  "                SELECT * FROM performance_schema.replication_applier_status_by_worker ORDER BY CHANNEL_NAME, WORKER_I"
  "D;\n"
  "            END IF;\n"
  "            IF (@@master_info_repository = 'TABLE') THEN\n"
  "                SELECT 'Replication - Master Log Status' AS 'The following output is:';\n"
  "                SELECT Master_log_name, Master_log_pos FROM mysql.slave_master_info;\n"
  "            END IF;\n"
  "            IF (@@relay_log_info_repository = 'TABLE') THEN\n"
  "                SELECT 'Replication - Relay Log Status' AS 'The following output is:';\n"
  "                SELECT sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_log_"
  "pos FROM mysql.slave_relay_log_info;\n"
  "                SELECT 'Replication - Worker Status' AS 'The following output is:';\n"
  "                SELECT Id, sys.format_path(Relay_log_name) AS Relay_log_name, Relay_log_pos, Master_log_name, Master_"
  "log_pos,\n"
  "                       sys.format_path(Checkpoint_relay_log_name) AS Checkpoint_relay_log_name, Checkpoint_relay_log_"
  "pos,\n"
  "                       Checkpoint_master_log_name, Checkpoint_master_log_pos, Checkpoint_seqno, Checkpoint_group_size"
  ",\n"
  "                       HEX(Checkpoint_group_bitmap) AS Checkpoint_group_bitmap, Channel_name\n"
  "                  FROM mysql.slave_worker_info\n"
  "              ORDER BY Channel_name, Id;\n"
  "            END IF;\n"
  "        END IF;\n"
  "        -- We need one table per output as a temporary table cannot be opened twice in the same query, and we need to"
  "\n"
  "        -- join the outputs in the summary at the end.\n"
  "        SET v_table_name = CONCAT('tmp_metrics_', v_output_count);\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS ', v_table_name));\n"
  "        -- Currently information_schema.GLOBAL_STATUS has VARIABLE_VALUE as varchar(1024)\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE ', v_table_name, ' (\n"
  "  Variable_name VARCHAR(193) NOT NULL,\n"
  "  Variable_value VARCHAR(1024),\n"
  "  Type VARCHAR(225) NOT NULL,\n"
  "  Enabled ENUM(''YES'', ''NO'', ''PARTIAL'') NOT NULL,\n"
  "  PRIMARY KEY (Type, Variable_name)\n"
  ") ENGINE = InnoDB DEFAULT CHARSET=utf8mb4'));\n"
  "        SET @sys.diagnostics.sql = CONCAT(\n"
  "            'INSERT INTO ', v_table_name,\n"
  "            ' SELECT Variable_name, REPLACE(Variable_value, ''\\n'', ''\\\\\\\\n'') AS Variable_value, Type, Enabled FROM "
  "sys.metrics'\n"
  "        );\n"
  "        CALL sys.execute_prepared_stmt(@sys.diagnostics.sql);\n"
  "        -- Prepare the query to retrieve the summary\n"
  "        CALL sys.execute_prepared_stmt(\n"
  "            CONCAT('(SELECT Variable_value INTO @sys.diagnostics.output_time FROM ', v_table_name, ' WHERE Type = ''S"
  "ystem Time'' AND Variable_name = ''UNIX_TIMESTAMP()'')')\n"
  "        );\n"
  "        SET v_output_time = @sys.diagnostics.output_time;\n"
  "        -- Limit each value to v_status_summary_width chars (when v_has_ndb = TRUE the values can be very wide - refe"
  "r to the output here for the full values)\n"
  "        -- v_sql_status_summary_select, v_sql_status_summary_delta, v_sql_status_summary_from\n"
  "        SET v_sql_status_summary_select = CONCAT(v_sql_status_summary_select, ',\n"
  "       CONCAT(\n"
  "           LEFT(s', v_output_count, '.Variable_value, ', v_status_summary_width, '),\n"
  "           IF(', REPLACE(v_no_delta_names, '%{COUNT}', v_output_count), ' AND s', v_output_count, '.Variable_value RE"
  "GEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'', CONCAT('' ('', ROUND(s', v_output_count, '.Variable_value/', v_output_time, ', 2), '"
  "'/sec)''), '''')\n"
  "       ) AS ''Output ', v_output_count, ''''),\n"
  "            v_sql_status_summary_from   = CONCAT(v_sql_status_summary_from, '\n"
  "',\n"
  "                                                    IF(v_output_count = 1, '  FROM ', '       INNER JOIN '),\n"
  "                                                    v_table_name, ' s', v_output_count,\n"
  "                                                    IF (v_output_count = 1, '', ' USING (Type, Variable_name)'));\n"
  "        IF (v_output_count > 1) THEN\n"
  "            SET v_sql_status_summary_delta  = CONCAT(v_sql_status_summary_delta, ',\n"
  "       IF(', REPLACE(v_no_delta_names, '%{COUNT}', v_output_count), ' AND s', (v_output_count-1), '.Variable_value RE"
  "GEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'' AND s', v_output_count, '.Variable_value REGEXP ''^[0-9]+(\\\\\\\\.[0-9]+)?$'',\n"
  "          CONCAT(IF(s', (v_output_count-1), '.Variable_value REGEXP ''^[0-9]+\\\\\\\\.[0-9]+$'' OR s', v_output_count, '."
  "Variable_value REGEXP ''^[0-9]+\\\\\\\\.[0-9]+$'',\n"
  "                    ROUND((s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value), 2),\n"
  "                    (s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value)\n"
  "                   ),\n"
  "                 '' ('', ROUND((s', v_output_count, '.Variable_value-s', (v_output_count-1), '.Variable_value)/(', v_"
  "output_time, '-', v_output_time_prev, '), 2), ''/sec)''\n"
  "          ),\n"
  "          ''''\n"
  "       ) AS ''Delta (', (v_output_count-1), ' -> ', v_output_count, ')''');\n"
  "        END IF;\n"
  "        SET v_output_time_prev = v_output_time;\n"
  "        IF (@sys.diagnostics.include_raw = 'ON') THEN\n"
  "            SELECT 'SELECT * FROM sys.metrics' AS 'The following output is:';\n"
  "            -- Ensures that the output here is the same as the one used in the status summary at the end\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('SELECT Type, Variable_name, Enabled, Variable_value FROM ', v_tabl"
  "e_name, ' ORDER BY Type, Variable_name'));\n"
  "        END IF;\n"
  "        -- InnoDB\n"
  "        IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "            SELECT 'SHOW ENGINE INNODB STATUS' AS 'The following output is:';\n"
  "            EXECUTE stmt_innodb_status;\n"
  "            SELECT 'InnoDB - Transactions' AS 'The following output is:';\n"
  "            SELECT * FROM information_schema.INNODB_TRX;\n"
  "        END IF;\n"
  "        -- NDBCluster\n"
  "        IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "            SELECT 'SHOW ENGINE NDBCLUSTER STATUS' AS 'The following output is:';\n"
  "            EXECUTE stmt_ndbcluster_status;\n"
  "            SELECT 'ndbinfo.memoryusage' AS 'The following output is:';\n"
  "            SELECT node_id, memory_type, format_bytes(used) AS used, used_pages, format_bytes(total) AS total, total_"
  "pages,\n"
  "                   ROUND(100*(used/total), 2) AS 'Used %'\n"
  "            FROM ndbinfo.memoryusage;\n"
  "            -- Loop over the ndbinfo tables (except memoryusage which was handled separately above).\n"
  "            -- The exact tables available are version dependent, so get the list from the Information Schema.\n"
  "            SET v_done = FALSE;\n"
  "            OPEN c_ndbinfo;\n"
  "            c_ndbinfo_loop: LOOP\n"
  "                FETCH c_ndbinfo INTO v_table_name;\n"
  "                IF v_done THEN\n"
  "                LEAVE c_ndbinfo_loop;\n"
  "                END IF;\n"
  "                SELECT CONCAT('SELECT * FROM ndbinfo.', v_table_name) AS 'The following output is:';\n"
  "                CALL sys.execute_prepared_stmt(CONCAT('SELECT * FROM `ndbinfo`.`', v_table_name, '`'));\n"
  "            END LOOP;\n"
  "            CLOSE c_ndbinfo;\n"
  "            SELECT * FROM information_schema.FILES;\n"
  "        END IF;\n"
  "        SELECT 'SELECT * FROM sys.processlist' AS 'The following output is:';\n"
  "        SELECT processlist.* FROM sys.processlist;\n"
  "        IF (v_has_ps = 'YES') THEN\n"
  "            -- latest_file_io\n"
  "            IF (sys.ps_is_consumer_enabled('events_waits_history_long') = 'YES') THEN\n"
  "                SELECT 'SELECT * FROM sys.latest_file_io' AS 'The following output is:';\n"
  "                SELECT * FROM sys.latest_file_io;\n"
  "            END IF;\n"
  "            -- current memory usage\n"
  "            IF (EXISTS(SELECT 1 FROM performance_schema.setup_instruments WHERE NAME LIKE 'memory/%' AND ENABLED = 'Y"
  "ES')) THEN\n"
  "                SELECT 'SELECT * FROM sys.memory_by_host_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_host_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_by_thread_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_thread_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_by_user_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_by_user_by_current_bytes;\n"
  "                SELECT 'SELECT * FROM sys.memory_global_by_current_bytes' AS 'The following output is:';\n"
  "                SELECT * FROM sys.memory_global_by_current_bytes;\n"
  "            END IF;\n"
  "        END IF;\n"
  "        SET v_runtime = (UNIX_TIMESTAMP(NOW(2)) - v_start);\n"
  "    UNTIL (v_runtime + in_interval >= in_max_runtime) END REPEAT;\n"
  "    -- Get Performance Schema status\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT 'SHOW ENGINE PERFORMANCE_SCHEMA STATUS' AS 'The following output is:';\n"
  "        EXECUTE stmt_ps_status;\n"
  "    END IF;\n"
  "    -- Deallocate prepared statements\n"
  "    IF (v_has_innodb IN ('DEFAULT', 'YES')) THEN\n"
  "        DEALLOCATE PREPARE stmt_innodb_status;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        DEALLOCATE PREPARE stmt_ps_status;\n"
  "    END IF;\n"
  "    IF (v_has_ndb IN ('DEFAULT', 'YES')) THEN\n"
  "        DEALLOCATE PREPARE stmt_ndbcluster_status;\n"
  "    END IF;\n"
  "    SELECT '\n"
  "\n"
  "============================\n"
  "\n"
  "     Schema Information\n"
  "\n"
  "============================\n"
  "\n"
  "' AS '';\n"
  "    SELECT COUNT(*) AS 'Total Number of Tables' FROM information_schema.TABLES;\n"
  "    -- The cost of information_schema.TABLES.DATA_LENGTH depends mostly on the number of tables\n"
  "    IF (@sys.diagnostics.allow_i_s_tables = 'ON') THEN\n"
  "        SELECT 'Storage Engine Usage' AS 'The following output is:';\n"
  "        SELECT ENGINE, COUNT(*) AS NUM_TABLES,\n"
  "                format_bytes(SUM(DATA_LENGTH)) AS DATA_LENGTH,\n"
  "                format_bytes(SUM(INDEX_LENGTH)) AS INDEX_LENGTH,\n"
  "                format_bytes(SUM(DATA_LENGTH+INDEX_LENGTH)) AS TOTAL\n"
  "            FROM information_schema.TABLES\n"
  "            GROUP BY ENGINE;\n"
  "        SELECT 'Schema Object Overview' AS 'The following output is:';\n"
  "        SELECT * FROM sys.schema_object_overview;\n"
  "        SELECT 'Tables without a PRIMARY KEY' AS 'The following output is:';\n"
  "        SELECT TABLES.TABLE_SCHEMA, ENGINE, COUNT(*) AS NumTables\n"
  "          FROM information_schema.TABLES\n"
  "               LEFT OUTER JOIN information_schema.STATISTICS ON STATISTICS.TABLE_SCHEMA = TABLES.TABLE_SCHEMA\n"
  "                                                                AND STATISTICS.TABLE_NAME = TABLES.TABLE_NAME\n"
  "                                                                AND STATISTICS.INDEX_NAME = 'PRIMARY'\n"
  "         WHERE STATISTICS.TABLE_NAME IS NULL\n"
  "               AND TABLES.TABLE_SCHEMA NOT IN ('mysql', 'information_schema', 'performance_schema', 'sys')\n"
  "               AND TABLES.TABLE_TYPE = 'BASE TABLE'\n"
  "         GROUP BY TABLES.TABLE_SCHEMA, ENGINE;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT 'Unused Indexes' AS 'The following output is:';\n"
  "        SELECT object_schema, COUNT(*) AS NumUnusedIndexes\n"
  "          FROM performance_schema.table_io_waits_summary_by_index_usage\n"
  "         WHERE index_name IS NOT NULL\n"
  "               AND count_star = 0\n"
  "               AND object_schema NOT IN ('mysql', 'sys')\n"
  "               AND index_name != 'PRIMARY'\n"
  "         GROUP BY object_schema;\n"
  "    END IF;\n"
  "    IF (v_has_ps = 'YES') THEN\n"
  "        SELECT '\n"
  "\n"
  "=========================\n"
  "\n"
  "     Overall Status\n"
  "\n"
  "=========================\n"
  "\n"
  "' AS '';\n"
  "        SELECT 'CALL sys.ps_statement_avg_latency_histogram()' AS 'The following output is:';\n"
  "        CALL sys.ps_statement_avg_latency_histogram();\n"
  "        CALL sys.statement_performance_analyzer('snapshot', NULL, NULL);\n"
  "        CALL sys.statement_performance_analyzer('overall', NULL, 'with_runtimes_in_95th_percentile');\n"
  "        SET @sys.diagnostics.sql = REPLACE(@sys.diagnostics.sql_gen_query_template, '%{OUTPUT}', 'end');\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'The following query will be used to generate the query for each sys view' AS 'Debug';\n"
  "            SELECT @sys.diagnostics.sql AS 'Debug';\n"
  "        END IF;\n"
  "        PREPARE stmt_gen_query FROM @sys.diagnostics.sql;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT CONCAT('The following queries are for storing the final content of ', v_table_name) AS 'Debug'"
  ";\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS `tmp_', v_table_name, '_end`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('CREATE TEMPORARY TABLE `tmp_', v_table_name, '_end` SELECT * FROM "
  "`sys`.`x$', v_table_name, '`'));\n"
  "            SET @sys.diagnostics.table_name = CONCAT('x$', v_table_name);\n"
  "            EXECUTE stmt_gen_query USING @sys.diagnostics.table_name;\n"
  "            -- If necessary add ORDER BY and LIMIT\n"
  "            SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                            IF(order_by IS NOT NULL, CONCAT('\\n ORDER BY ', REPLACE(order_by, '%{TABLE}', CONCAT('tmp"
  "_', v_table_name, '_end'))), ''),\n"
  "                            IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                    )\n"
  "                INTO @sys.diagnostics.sql_select\n"
  "                FROM tmp_sys_views_delta\n"
  "                WHERE TABLE_NAME COLLATE utf8mb4_0900_as_ci = v_table_name;\n"
  "            SELECT CONCAT('Overall ', v_table_name) AS 'The following output is:';\n"
  "            CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        DEALLOCATE PREPARE stmt_gen_query;\n"
  "        SELECT '\n"
  "\n"
  "======================\n"
  "\n"
  "     Delta Status\n"
  "\n"
  "======================\n"
  "\n"
  "' AS '';\n"
  "        CALL sys.statement_performance_analyzer('delta', 'tmp_digests_start', 'with_runtimes_in_95th_percentile');\n"
  "        CALL sys.statement_performance_analyzer('cleanup', NULL, NULL);\n"
  "        DROP TEMPORARY TABLE tmp_digests_start;\n"
  "        -- @sys.diagnostics.sql_gen_query_delta is defined near the to together with @sys.diagnostics.sql_gen_query_t"
  "emplate\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT 'The following query will be used to generate the query for each sys view delta' AS 'Debug';\n"
  "            SELECT @sys.diagnostics.sql_gen_query_delta AS 'Debug';\n"
  "        END IF;\n"
  "        PREPARE stmt_gen_query_delta FROM @sys.diagnostics.sql_gen_query_delta;\n"
  "        SET v_old_group_concat_max_len = @@session.group_concat_max_len;\n"
  "        SET @@session.group_concat_max_len = 2048;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_sysviews_w_delta;\n"
  "        c_sysviews_w_delta_loop: LOOP\n"
  "            FETCH c_sysviews_w_delta INTO v_table_name;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_sysviews_w_delta_loop;\n"
  "            END IF;\n"
  "            SET @sys.diagnostics.table_name = v_table_name;\n"
  "            EXECUTE stmt_gen_query_delta USING @sys.diagnostics.table_name;\n"
  "            -- If necessary add WHERE, ORDER BY, and LIMIT\n"
  "            SELECT CONCAT(@sys.diagnostics.sql_select,\n"
  "                            IF(where_delta IS NOT NULL, CONCAT('\\n WHERE ', where_delta), ''),\n"
  "                            IF(order_by_delta IS NOT NULL, CONCAT('\\n ORDER BY ', order_by_delta), ''),\n"
  "                            IF(limit_rows IS NOT NULL, CONCAT('\\n LIMIT ', limit_rows), '')\n"
  "                    )\n"
  "                INTO @sys.diagnostics.sql_select\n"
  "                FROM tmp_sys_views_delta\n"
  "                WHERE TABLE_NAME COLLATE utf8mb4_0900_as_ci = v_table_name;\n"
  "            SELECT CONCAT('Delta ', v_table_name) AS 'The following output is:';\n"
  "            CALL sys.execute_prepared_stmt(@sys.diagnostics.sql_select);\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE `tmp_', v_table_name, '_end`'));\n"
  "            CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE `tmp_', v_table_name, '_start`'));\n"
  "        END LOOP;\n"
  "        CLOSE c_sysviews_w_delta;\n"
  "        SET @@session.group_concat_max_len = v_old_group_concat_max_len;\n"
  "        DEALLOCATE PREPARE stmt_gen_query_delta;\n"
  "        DROP TEMPORARY TABLE tmp_sys_views_delta;\n"
  "    END IF;\n"
  "    SELECT 'SELECT * FROM sys.metrics' AS 'The following output is:';\n"
  "    CALL sys.execute_prepared_stmt(\n"
  "        CONCAT(v_sql_status_summary_select, v_sql_status_summary_delta, ', Type, s1.Enabled', v_sql_status_summary_fr"
  "om,\n"
  "               '\n"
  " ORDER BY Type, Variable_name'\n"
  "        )\n"
  "    );\n"
  "    -- Remove all the metrics temporary tables again\n"
  "    SET v_count = 0;\n"
  "    WHILE (v_count < v_output_count) DO\n"
  "        SET v_count = v_count + 1;\n"
  "        SET v_table_name = CONCAT('tmp_metrics_', v_count);\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DROP TEMPORARY TABLE IF EXISTS ', v_table_name));\n"
  "    END WHILE;\n"
  "    IF (in_auto_config <> 'current') THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "    -- Reset the @sys.diagnostics.% user variables internal to this procedure\n"
  "    SET @sys.diagnostics.output_time            = NULL,\n"
  "        @sys.diagnostics.sql                    = NULL,\n"
  "        @sys.diagnostics.sql_gen_query_delta    = NULL,\n"
  "        @sys.diagnostics.sql_gen_query_template = NULL,\n"
  "        @sys.diagnostics.sql_select             = NULL,\n"
  "        @sys.diagnostics.table_name             = NULL;\n"
  "    -- Restore INSTRUMENTED for this thread\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_statement_avg_latency_histogram;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_statement_avg_latency_histogram ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Outputs a textual histogram graph of the average latency values\n"
  "across all normalized queries tracked within the Performance Schema\n"
  "events_statements_summary_by_digest table.\n"
  "\n"
  "Can be used to show a very high level picture of what kind of \n"
  "latency distribution statements running within this instance have.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_statement_avg_latency_histogram()\\\\G\n"
  "*************************** 1. row ***************************\n"
  "Performance Schema Statement Digest Average Latency Histogram:\n"
  "\n"
  "  . = 1 unit\n"
  "  * = 2 units\n"
  "  # = 3 units\n"
  "\n"
  "(0 - 38ms)     240 | ################################################################################\n"
  "(38 - 77ms)    38  | ......................................\n"
  "(77 - 115ms)   3   | ...\n"
  "(115 - 154ms)  62  | *******************************\n"
  "(154 - 192ms)  3   | ...\n"
  "(192 - 231ms)  0   |\n"
  "(231 - 269ms)  0   |\n"
  "(269 - 307ms)  0   |\n"
  "(307 - 346ms)  0   |\n"
  "(346 - 384ms)  1   | .\n"
  "(384 - 423ms)  1   | .\n"
  "(423 - 461ms)  0   |\n"
  "(461 - 499ms)  0   |\n"
  "(499 - 538ms)  0   |\n"
  "(538 - 576ms)  0   |\n"
  "(576 - 615ms)  1   | .\n"
  "\n"
  "  Total Statements: 350; Buckets: 16; Bucket Size: 38 ms;\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "SELECT CONCAT('\\n',\n"
  "       '\\n  . = 1 unit',\n"
  "       '\\n  * = 2 units',\n"
  "       '\\n  # = 3 units\\n',\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(0 - ',\n"
  "                                               ROUND((@bucket_size := (SELECT ROUND((MAX(avg_us) - MIN(avg_us)) / (@b"
  "uckets := 16)) AS size\n"
  "                                                                         FROM sys.x$ps_digest_avg_latency_distributio"
  "n)) / (@unit_div := 1000)),\n"
  "                                                (@unit := 'ms'), ')'),\n"
  "                        REPEAT(' ', (@max_label_size := ((1 + LENGTH(ROUND((@bucket_size * 15) / @unit_div)) + 3 + LE"
  "NGTH(ROUND(@bucket_size * 16) / @unit_div)) + 1)) - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us <= @bucket_size), 0)),\n"
  "       REPEAT(' ', (@max_label_len := (@max_label_size + LENGTH((@total_queries := (SELECT SUM(cnt) FROM sys.x$ps_dig"
  "est_avg_latency_distribution)))) + 1) - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < (@one_unit := 40), '.', IF(@count_in_bucket < (@two_unit := 80), '*', '#')"
  "), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND(@bucket_size / @unit_div), ' - ', ROUND((@bucket_size * 2"
  ") / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size AND b1.avg_us <= @bucket_size * 2"
  "), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 2) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 3) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 2 AND b1.avg_us <= @bucket_size"
  " * 3), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 3) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 4) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 3 AND b1.avg_us <= @bucket_size"
  " * 4), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 4) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 5) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 4 AND b1.avg_us <= @bucket_size"
  " * 5), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 5) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 6) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 5 AND b1.avg_us <= @bucket_size"
  " * 6), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 6) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 7) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 6 AND b1.avg_us <= @bucket_size"
  " * 7), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 7) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 8) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 7 AND b1.avg_us <= @bucket_size"
  " * 8), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 8) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 9) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 8 AND b1.avg_us <= @bucket_size"
  " * 9), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 9) / @unit_div), ' - ', ROUND((@bucket_si"
  "ze * 10) / @unit_div), @unit, ')'),\n"
  "                         REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                         @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                       FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                      WHERE b1.avg_us > @bucket_size * 9 AND b1.avg_us <= @bucket_siz"
  "e * 10), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 10) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 11) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 10 AND b1.avg_us <= @bucket_siz"
  "e * 11), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 11) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 12) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 11 AND b1.avg_us <= @bucket_siz"
  "e * 12), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 12) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 13) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 12 AND b1.avg_us <= @bucket_siz"
  "e * 13), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 13) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 14) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 13 AND b1.avg_us <= @bucket_siz"
  "e * 14), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 14) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 15) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 14 AND b1.avg_us <= @bucket_siz"
  "e * 15), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       @label := CONCAT(@label_inner := CONCAT('\\n(', ROUND((@bucket_size * 15) / @unit_div), ' - ', ROUND((@bucket_s"
  "ize * 16) / @unit_div), @unit, ')'),\n"
  "                        REPEAT(' ', @max_label_size - LENGTH(@label_inner)),\n"
  "                        @count_in_bucket := IFNULL((SELECT SUM(cnt)\n"
  "                                                      FROM sys.x$ps_digest_avg_latency_distribution AS b1 \n"
  "                                                     WHERE b1.avg_us > @bucket_size * 15 AND b1.avg_us <= @bucket_siz"
  "e * 16), 0)),\n"
  "       REPEAT(' ', @max_label_len - LENGTH(@label)), '| ',\n"
  "       IFNULL(REPEAT(IF(@count_in_bucket < @one_unit, '.', IF(@count_in_bucket < @two_unit, '*', '#')), \n"
  "       	             IF(@count_in_bucket < @one_unit, @count_in_bucket,\n"
  "       	             	IF(@count_in_bucket < @two_unit, @count_in_bucket / 2, @count_in_bucket / 3))), ''),\n"
  "       '\\n\\n  Total Statements: ', @total_queries, '; Buckets: ', @buckets , '; Bucket Size: ', ROUND(@bucket_size / "
  "@unit_div) , ' ', @unit, ';\\n'\n"
  "      ) AS `Performance Schema Statement Digest Average Latency Histogram`;\n"
  "END \n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_trace_statement_digest;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_trace_statement_digest (\n"
  "        IN in_digest VARCHAR(64),\n"
  "        IN in_runtime INT,\n"
  "        IN in_interval DECIMAL(2,2),\n"
  "        IN in_start_fresh BOOLEAN,\n"
  "        IN in_auto_enable BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Traces all instrumentation within Performance Schema for a specific\n"
  "Statement Digest.\n"
  "\n"
  "When finding a statement of interest within the\n"
  "performance_schema.events_statements_summary_by_digest table, feed\n"
  "the DIGEST value in to this procedure, set how long to poll for,\n"
  "and at what interval to poll, and it will generate a report of all\n"
  "statistics tracked within Performance Schema for that digest for the\n"
  "interval.\n"
  "\n"
  "It will also attempt to generate an EXPLAIN for the longest running\n"
  "example of the digest during the interval. Note this may fail, as:\n"
  "\n"
  "   * Performance Schema truncates long SQL_TEXT values (and hence the\n"
  "     EXPLAIN will fail due to parse errors)\n"
  "   * the default schema is sys (so tables that are not fully qualified\n"
  "     in the query may not be found)\n"
  "   * some queries such as SHOW are not supported in EXPLAIN.\n"
  "\n"
  "When the EXPLAIN fails, the error will be ignored and no EXPLAIN\n"
  "output generated.\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_digest (VARCHAR(64)):\n"
  "  The statement digest identifier you would like to analyze\n"
  "in_runtime (INT):\n"
  "  The number of seconds to run analysis for\n"
  "in_interval (DECIMAL(2,2)):\n"
  "  The interval (in seconds, may be fractional) at which to try\n"
  "  and take snapshots\n"
  "in_start_fresh (BOOLEAN):\n"
  "  Whether to TRUNCATE the events_statements_history_long and\n"
  "  events_stages_history_long tables before starting\n"
  "in_auto_enable (BOOLEAN):\n"
  "  Whether to automatically turn on required consumers\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> call ps_trace_statement_digest(\\'891ec6860f98ba46d89dd20b0c03652c\\', 10, 0.1, true, true);\n"
  "+--------------------+\n"
  "| SUMMARY STATISTICS |\n"
  "+--------------------+\n"
  "| SUMMARY STATISTICS |\n"
  "+--------------------+\n"
  "1 row in set (9.11 sec)\n"
  "\n"
  "+------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "| executions | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scans |\n"
  "+------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "|         21 | 4.11 ms   | 2.00 ms   |         0 |            21 |          0 |          0 |\n"
  "+------------+-----------+-----------+-----------+---------------+------------+------------+\n"
  "1 row in set (9.11 sec)\n"
  "\n"
  "+------------------------------------------+-------+-----------+\n"
  "| event_name                               | count | latency   |\n"
  "+------------------------------------------+-------+-----------+\n"
  "| stage/sql/checking query cache for query |    16 | 724.37 us |\n"
  "| stage/sql/statistics                     |    16 | 546.92 us |\n"
  "| stage/sql/freeing items                  |    18 | 520.11 us |\n"
  "| stage/sql/init                           |    51 | 466.80 us |\n"
  "...\n"
  "| stage/sql/cleaning up                    |    18 | 11.92 us  |\n"
  "| stage/sql/executing                      |    16 | 6.95 us   |\n"
  "+------------------------------------------+-------+-----------+\n"
  "17 rows in set (9.12 sec)\n"
  "\n"
  "+---------------------------+\n"
  "| LONGEST RUNNING STATEMENT |\n"
  "+---------------------------+\n"
  "| LONGEST RUNNING STATEMENT |\n"
  "+---------------------------+\n"
  "1 row in set (9.16 sec)\n"
  "\n"
  "+-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "| thread_id | exec_time | lock_time | rows_sent | rows_examined | tmp_tables | full_scan |\n"
  "+-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "|    166646 | 618.43 us | 1.00 ms   |         0 |             1 |          0 |         0 |\n"
  "+-----------+-----------+-----------+-----------+---------------+------------+-----------+\n"
  "1 row in set (9.16 sec)\n"
  "\n"
  "// Truncated for clarity...\n"
  "+-----------------------------------------------------------------+\n"
  "| sql_text                                                        |\n"
  "+-----------------------------------------------------------------+\n"
  "| select hibeventhe0_.id as id1382_, hibeventhe0_.createdTime ... |\n"
  "+-----------------------------------------------------------------+\n"
  "1 row in set (9.17 sec)\n"
  "\n"
  "+------------------------------------------+-----------+\n"
  "| event_name                               | latency   |\n"
  "+------------------------------------------+-----------+\n"
  "| stage/sql/init                           | 8.61 us   |\n"
  "| stage/sql/Waiting for query cache lock   | 453.23 us |\n"
  "| stage/sql/init                           | 331.07 ns |\n"
  "| stage/sql/checking query cache for query | 43.04 us  |\n"
  "...\n"
  "| stage/sql/freeing items                  | 30.46 us  |\n"
  "| stage/sql/cleaning up                    | 662.13 ns |\n"
  "+------------------------------------------+-----------+\n"
  "18 rows in set (9.23 sec)\n"
  "\n"
  "+----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "| id | select_type | table        | type  | possible_keys | key       | key_len | ref         | rows | Extra |\n"
  "+----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "|  1 | SIMPLE      | hibeventhe0_ | const | fixedTime     | fixedTime | 775     | const,const |    1 | NULL  |\n"
  "+----+-------------+--------------+-------+---------------+-----------+---------+-------------+------+-------+\n"
  "1 row in set (9.27 sec)\n"
  "\n"
  "Query OK, 0 rows affected (9.28 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_start_fresh BOOLEAN DEFAULT false;\n"
  "    DECLARE v_auto_enable BOOLEAN DEFAULT false;\n"
  "    DECLARE v_explain     BOOLEAN DEFAULT true;\n"
  "    DECLARE v_this_thread_enabed ENUM('YES', 'NO');\n"
  "    DECLARE v_runtime INT DEFAULT 0;\n"
  "    DECLARE v_start INT DEFAULT 0;\n"
  "    DECLARE v_found_stmts INT;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    -- Do not track the current thread, it will kill the stack\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_I"
  "D();\n"
  "    CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    DROP TEMPORARY TABLE IF EXISTS stmt_trace;\n"
  "    CREATE TEMPORARY TABLE stmt_trace (\n"
  "        thread_id BIGINT UNSIGNED,\n"
  "        timer_start BIGINT UNSIGNED,\n"
  "        event_id BIGINT UNSIGNED,\n"
  "        sql_text longtext,\n"
  "        timer_wait BIGINT UNSIGNED,\n"
  "        lock_time BIGINT UNSIGNED,\n"
  "        errors BIGINT UNSIGNED,\n"
  "        mysql_errno INT,\n"
  "        rows_sent BIGINT UNSIGNED,\n"
  "        rows_affected BIGINT UNSIGNED,\n"
  "        rows_examined BIGINT UNSIGNED,\n"
  "        created_tmp_tables BIGINT UNSIGNED,\n"
  "        created_tmp_disk_tables BIGINT UNSIGNED,\n"
  "        no_index_used BIGINT UNSIGNED,\n"
  "        PRIMARY KEY (thread_id, timer_start)\n"
  "    );\n"
  "    DROP TEMPORARY TABLE IF EXISTS stmt_stages;\n"
  "    CREATE TEMPORARY TABLE stmt_stages (\n"
  "       event_id BIGINT UNSIGNED,\n"
  "       stmt_id BIGINT UNSIGNED,\n"
  "       event_name VARCHAR(128),\n"
  "       timer_wait BIGINT UNSIGNED,\n"
  "       PRIMARY KEY (event_id)\n"
  "    );\n"
  "    SET v_start_fresh = in_start_fresh;\n"
  "    IF v_start_fresh THEN\n"
  "        TRUNCATE TABLE performance_schema.events_statements_history_long;\n"
  "        TRUNCATE TABLE performance_schema.events_stages_history_long;\n"
  "    END IF;\n"
  "    SET v_auto_enable = in_auto_enable;\n"
  "    IF v_auto_enable THEN\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = IF(PROCESSLIST_ID IS NOT NULL, 'YES', 'NO');\n"
  "        -- Only the events_statements_history_long and events_stages_history_long tables and their ancestors are need"
  "ed\n"
  "        UPDATE performance_schema.setup_consumers\n"
  "           SET ENABLED = 'YES'\n"
  "         WHERE NAME NOT LIKE '%\\_history'\n"
  "               AND NAME NOT LIKE 'events_wait%'\n"
  "               AND NAME NOT LIKE 'events_transactions%'\n"
  "               AND NAME <> 'statements_digest';\n"
  "        UPDATE performance_schema.setup_instruments\n"
  "           SET ENABLED = 'YES',\n"
  "               TIMED   = 'YES'\n"
  "         WHERE NAME LIKE 'statement/%' OR NAME LIKE 'stage/%';\n"
  "    END IF;\n"
  "    WHILE v_runtime < in_runtime DO\n"
  "        SELECT UNIX_TIMESTAMP() INTO v_start;\n"
  "        INSERT IGNORE INTO stmt_trace\n"
  "        SELECT thread_id, timer_start, event_id, sql_text, timer_wait, lock_time, errors, mysql_errno, \n"
  "               rows_sent, rows_affected, rows_examined, created_tmp_tables, created_tmp_disk_tables, no_index_used\n"
  "          FROM performance_schema.events_statements_history_long\n"
  "        WHERE digest = in_digest;\n"
  "        INSERT IGNORE INTO stmt_stages\n"
  "        SELECT stages.event_id, stmt_trace.event_id,\n"
  "               stages.event_name, stages.timer_wait\n"
  "          FROM performance_schema.events_stages_history_long AS stages\n"
  "          JOIN stmt_trace ON stages.nesting_event_id = stmt_trace.event_id;\n"
  "        SELECT SLEEP(in_interval) INTO @sleep;\n"
  "        SET v_runtime = v_runtime + (UNIX_TIMESTAMP() - v_start);\n"
  "    END WHILE;\n"
  "    SELECT \"SUMMARY STATISTICS\";\n"
  "    SELECT COUNT(*) executions,\n"
  "           format_pico_time(SUM(timer_wait)) AS exec_time,\n"
  "           format_pico_time(SUM(lock_time)) AS lock_time,\n"
  "           SUM(rows_sent) AS rows_sent,\n"
  "           SUM(rows_affected) AS rows_affected,\n"
  "           SUM(rows_examined) AS rows_examined,\n"
  "           SUM(created_tmp_tables) AS tmp_tables,\n"
  "           SUM(no_index_used) AS full_scans\n"
  "      FROM stmt_trace;\n"
  "    SELECT event_name,\n"
  "           COUNT(*) as count,\n"
  "           format_pico_time(SUM(timer_wait)) as latency\n"
  "      FROM stmt_stages\n"
  "     GROUP BY event_name\n"
  "     ORDER BY SUM(timer_wait) DESC;\n"
  "    SELECT \"LONGEST RUNNING STATEMENT\";\n"
  "    SELECT thread_id,\n"
  "           format_pico_time(timer_wait) AS exec_time,\n"
  "           format_pico_time(lock_time) AS lock_time,\n"
  "           rows_sent,\n"
  "           rows_affected,\n"
  "           rows_examined,\n"
  "           created_tmp_tables AS tmp_tables,\n"
  "           no_index_used AS full_scan\n"
  "      FROM stmt_trace\n"
  "     ORDER BY timer_wait DESC LIMIT 1;\n"
  "    SELECT sql_text\n"
  "      FROM stmt_trace\n"
  "     ORDER BY timer_wait DESC LIMIT 1;\n"
  "    SELECT sql_text, event_id INTO @sql, @sql_id\n"
  "      FROM stmt_trace\n"
  "    ORDER BY timer_wait DESC LIMIT 1;\n"
  "    IF (@sql_id IS NOT NULL) THEN\n"
  "        SELECT event_name,\n"
  "               format_pico_time(timer_wait) as latency\n"
  "          FROM stmt_stages\n"
  "         WHERE stmt_id = @sql_id\n"
  "         ORDER BY event_id;\n"
  "    END IF;\n"
  "    DROP TEMPORARY TABLE stmt_trace;\n"
  "    DROP TEMPORARY TABLE stmt_stages;\n"
  "    IF (@sql IS NOT NULL) THEN\n"
  "        SET @stmt := CONCAT(\"EXPLAIN FORMAT=JSON \", @sql);\n"
  "        BEGIN\n"
  "            -- Not all queries support EXPLAIN, so catch the cases that are\n"
  "            -- not supported. Currently that includes cases where the table\n"
  "            -- is not fully qualified and is not in the default schema for this\n"
  "            -- procedure as it's not possible to change the default schema inside\n"
  "            -- a procedure.\n"
  "            --\n"
  "            -- Errno = 1064: You have an error in your SQL syntax\n"
  "            -- Errno = 1146: Table '...' doesn't exist\n"
  "            DECLARE CONTINUE HANDLER FOR 1064, 1146 SET v_explain = false;\n"
  "            PREPARE explain_stmt FROM @stmt;\n"
  "        END;\n"
  "        IF (v_explain) THEN\n"
  "            EXECUTE explain_stmt;\n"
  "            DEALLOCATE PREPARE explain_stmt;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF v_auto_enable THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "    END IF;\n"
  "    -- Restore INSTRUMENTED for this thread\n"
  "    IF (v_this_thread_enabed = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_trace_thread;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_trace_thread (\n"
  "        IN in_thread_id BIGINT UNSIGNED,\n"
  "        IN in_outfile VARCHAR(255),\n"
  "        IN in_max_runtime DECIMAL(20,2),\n"
  "        IN in_interval DECIMAL(20,2),\n"
  "        IN in_start_fresh BOOLEAN,\n"
  "        IN in_auto_setup BOOLEAN,\n"
  "        IN in_debug BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Dumps all data within Performance Schema for an instrumented thread,\n"
  "to create a DOT formatted graph file. \n"
  "\n"
  "Each resultset returned from the procedure should be used for a complete graph\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_thread_id (BIGINT UNSIGNED):\n"
  "  The thread that you would like a stack trace for\n"
  "in_outfile  (VARCHAR(255)):\n"
  "  The filename the dot file will be written to\n"
  "in_max_runtime (DECIMAL(20,2)):\n"
  "  The maximum time to keep collecting data.\n"
  "  Use NULL to get the default which is 60 seconds.\n"
  "in_interval (DECIMAL(20,2)): \n"
  "  How long to sleep between data collections. \n"
  "  Use NULL to get the default which is 1 second.\n"
  "in_start_fresh (BOOLEAN):\n"
  "  Whether to reset all Performance Schema data before tracing.\n"
  "in_auto_setup (BOOLEAN):\n"
  "  Whether to disable all other threads and enable all consumers/instruments. \n"
  "  This will also reset the settings at the end of the run.\n"
  "in_debug (BOOLEAN):\n"
  "  Whether you would like to include file:lineno in the graph\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_trace_thread(25, CONCAT(\\'/tmp/stack-\\', REPLACE(NOW(), \\' \\', \\'-\\'), \\'.dot\\'), NULL, NULL, TRUE"
  ", TRUE, TRUE);\n"
  "+-------------------+\n"
  "| summary           |\n"
  "+-------------------+\n"
  "| Disabled 1 thread |\n"
  "+-------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "+---------------------------------------------+\n"
  "| Info                                        |\n"
  "+---------------------------------------------+\n"
  "| Data collection starting for THREAD_ID = 25 |\n"
  "+---------------------------------------------+\n"
  "1 row in set (0.03 sec)\n"
  "\n"
  "+-----------------------------------------------------------+\n"
  "| Info                                                      |\n"
  "+-----------------------------------------------------------+\n"
  "| Stack trace written to /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "+-----------------------------------------------------------+\n"
  "1 row in set (60.07 sec)\n"
  "\n"
  "+-------------------------------------------------------------------+\n"
  "| Convert to PDF                                                    |\n"
  "+-------------------------------------------------------------------+\n"
  "| dot -Tpdf -o /tmp/stack_25.pdf /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "+-------------------------------------------------------------------+\n"
  "1 row in set (60.07 sec)\n"
  "\n"
  "+-------------------------------------------------------------------+\n"
  "| Convert to PNG                                                    |\n"
  "+-------------------------------------------------------------------+\n"
  "| dot -Tpng -o /tmp/stack_25.png /tmp/stack-2014-02-16-21:18:41.dot |\n"
  "+-------------------------------------------------------------------+\n"
  "1 row in set (60.07 sec)\n"
  "\n"
  "+------------------+\n"
  "| summary          |\n"
  "+------------------+\n"
  "| Enabled 1 thread |\n"
  "+------------------+\n"
  "1 row in set (60.32 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_start, v_runtime DECIMAL(20,2) DEFAULT 0.0;\n"
  "    DECLARE v_min_event_id bigint unsigned DEFAULT 0;\n"
  "    DECLARE v_this_thread_enabed ENUM('YES', 'NO');\n"
  "    DECLARE v_event longtext;\n"
  "    DECLARE c_stack CURSOR FOR\n"
  "        SELECT CONCAT(IF(nesting_event_id IS NOT NULL, CONCAT(nesting_event_id, ' -> '), ''), \n"
  "                    event_id, '; ', event_id, ' [label=\"',\n"
  "                    -- Convert from picoseconds to microseconds\n"
  "                    '(', format_pico_time(timer_wait), ') ',\n"
  "                    IF (event_name NOT LIKE 'wait/io%', \n"
  "                        SUBSTRING_INDEX(event_name, '/', -2), \n"
  "                        IF (event_name NOT LIKE 'wait/io/file%' OR event_name NOT LIKE 'wait/io/socket%',\n"
  "                            SUBSTRING_INDEX(event_name, '/', -4),\n"
  "                            event_name)\n"
  "                        ),\n"
  "                    -- Always dump the extra wait information gathered for transactions and statements\n"
  "                    IF (event_name LIKE 'transaction', IFNULL(CONCAT('\\\\n', wait_info), ''), ''),\n"
  "                    IF (event_name LIKE 'statement/%', IFNULL(CONCAT('\\\\n', wait_info), ''), ''),\n"
  "                    -- If debug is enabled, add the file:lineno information for waits\n"
  "                    IF (in_debug AND event_name LIKE 'wait%', wait_info, ''),\n"
  "                    '\", ', \n"
  "                    -- Depending on the type of event, style appropriately\n"
  "                    CASE WHEN event_name LIKE 'wait/io/file%' THEN \n"
  "                           'shape=box, style=filled, color=red'\n"
  "                         WHEN event_name LIKE 'wait/io/table%' THEN \n"
  "                           'shape=box, style=filled, color=green'\n"
  "                         WHEN event_name LIKE 'wait/io/socket%' THEN\n"
  "                           'shape=box, style=filled, color=yellow'\n"
  "                         WHEN event_name LIKE 'wait/synch/mutex%' THEN\n"
  "                           'style=filled, color=lightskyblue'\n"
  "                         WHEN event_name LIKE 'wait/synch/cond%' THEN\n"
  "                           'style=filled, color=darkseagreen3'\n"
  "                         WHEN event_name LIKE 'wait/synch/rwlock%' THEN\n"
  "                           'style=filled, color=orchid'\n"
  "                         WHEN event_name LIKE 'wait/synch/sxlock%' THEN\n"
  "                           'style=filled, color=palevioletred' \n"
  "                         WHEN event_name LIKE 'wait/lock%' THEN\n"
  "                           'shape=box, style=filled, color=tan'\n"
  "                         WHEN event_name LIKE 'statement/%' THEN\n"
  "                           CONCAT('shape=box, style=bold',\n"
  "                                  -- Style statements depending on COM vs SQL\n"
  "                                  CASE WHEN event_name LIKE 'statement/com/%' THEN\n"
  "                                         ' style=filled, color=darkseagreen'\n"
  "                                       ELSE\n"
  "                                         -- Use long query time from the server to\n"
  "                                         -- flag long running statements in red\n"
  "                                         IF((timer_wait/1000000000000) > @@long_query_time, \n"
  "                                            ' style=filled, color=red', \n"
  "                                            ' style=filled, color=lightblue')\n"
  "                                  END\n"
  "                           )\n"
  "                         WHEN event_name LIKE 'transaction' THEN\n"
  "                           'shape=box, style=filled, color=lightblue3'\n"
  "                         WHEN event_name LIKE 'stage/%' THEN\n"
  "                           'style=filled, color=slategray3'\n"
  "                         -- IDLE events are on their own, call attention to them\n"
  "                         WHEN event_name LIKE '%idle%' THEN\n"
  "                           'shape=box, style=filled, color=firebrick3'\n"
  "                         ELSE '' END,\n"
  "                     '];\\n'\n"
  "                   ) event, event_id\n"
  "        FROM (\n"
  "             -- Select all transactions\n"
  "             (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id,\n"
  "                     CONCAT('trx_id: ',  IFNULL(trx_id, ''), '\\\\n',\n"
  "                            'gtid: ', IFNULL(gtid, ''), '\\\\n',\n"
  "                            'state: ', state, '\\\\n',\n"
  "                            'mode: ', access_mode, '\\\\n',\n"
  "                            'isolation: ', isolation_level, '\\\\n',\n"
  "                            'autocommit: ', autocommit, '\\\\n',\n"
  "                            'savepoints: ', number_of_savepoints, '\\\\n'\n"
  "                     ) AS wait_info\n"
  "                FROM performance_schema.events_transactions_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "             UNION\n"
  "             -- Select all statements, with the extra tracing information available\n"
  "             (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, \n"
  "                     CONCAT('statement: ', sql_text, '\\\\n',\n"
  "                            'errors: ', errors, '\\\\n',\n"
  "                            'warnings: ', warnings, '\\\\n',\n"
  "                            'lock time: ', format_pico_time(lock_time),'\\\\n',\n"
  "                            'rows affected: ', rows_affected, '\\\\n',\n"
  "                            'rows sent: ', rows_sent, '\\\\n',\n"
  "                            'rows examined: ', rows_examined, '\\\\n',\n"
  "                            'tmp tables: ', created_tmp_tables, '\\\\n',\n"
  "                            'tmp disk tables: ', created_tmp_disk_tables, '\\\\n'\n"
  "                            'select scan: ', select_scan, '\\\\n',\n"
  "                            'select full join: ', select_full_join, '\\\\n',\n"
  "                            'select full range join: ', select_full_range_join, '\\\\n',\n"
  "                            'select range: ', select_range, '\\\\n',\n"
  "                            'select range check: ', select_range_check, '\\\\n', \n"
  "                            'sort merge passes: ', sort_merge_passes, '\\\\n',\n"
  "                            'sort rows: ', sort_rows, '\\\\n',\n"
  "                            'sort range: ', sort_range, '\\\\n',\n"
  "                            'sort scan: ', sort_scan, '\\\\n',\n"
  "                            'no index used: ', IF(no_index_used, 'TRUE', 'FALSE'), '\\\\n',\n"
  "                            'no good index used: ', IF(no_good_index_used, 'TRUE', 'FALSE'), '\\\\n'\n"
  "                     ) AS wait_info\n"
  "                FROM performance_schema.events_statements_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "             UNION\n"
  "             -- Select all stages\n"
  "             (SELECT thread_id, event_id, event_name, timer_wait, timer_start, nesting_event_id, null AS wait_info\n"
  "                FROM performance_schema.events_stages_history_long \n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "             UNION \n"
  "             -- Select all events, adding information appropriate to the event\n"
  "             (SELECT thread_id, event_id, \n"
  "                     CONCAT(event_name, \n"
  "                            IF(event_name NOT LIKE 'wait/synch/mutex%', IFNULL(CONCAT(' - ', operation), ''), ''), \n"
  "                            IF(number_of_bytes IS NOT NULL, CONCAT(' ', number_of_bytes, ' bytes'), ''),\n"
  "                            IF(event_name LIKE 'wait/io/file%', '\\\\n', ''),\n"
  "                            IF(object_schema IS NOT NULL, CONCAT('\\\\nObject: ', object_schema, '.'), ''), \n"
  "                            IF(object_name IS NOT NULL, \n"
  "                               IF (event_name LIKE 'wait/io/socket%',\n"
  "                                   -- Print the socket if used, else the IP:port as reported\n"
  "                                   CONCAT('\\\\n', IF (object_name LIKE ':0%', @@socket, object_name)),\n"
  "                                   object_name),\n"
  "                               ''\n"
  "                            ),\n"
  "                            IF(index_name IS NOT NULL, CONCAT(' Index: ', index_name), ''), '\\\\n'\n"
  "                     ) AS event_name,\n"
  "                     timer_wait, timer_start, nesting_event_id, source AS wait_info\n"
  "                FROM performance_schema.events_waits_history_long\n"
  "               WHERE thread_id = in_thread_id AND event_id > v_min_event_id)\n"
  "           ) events \n"
  "       ORDER BY event_id;\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    -- Do not track the current thread, it will kill the stack\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabed FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_I"
  "D();\n"
  "    CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    IF (in_auto_setup) THEN\n"
  "        CALL sys.ps_setup_save(0);\n"
  "        -- Ensure only the thread to create the stack trace for is instrumented and that we instrument everything.\n"
  "        DELETE FROM performance_schema.setup_actors;\n"
  "        UPDATE performance_schema.threads\n"
  "           SET INSTRUMENTED = IF(THREAD_ID = in_thread_id, 'YES', 'NO');\n"
  "        -- only the %_history_long tables and it ancestors are needed\n"
  "        UPDATE performance_schema.setup_consumers\n"
  "           SET ENABLED = 'YES'\n"
  "         WHERE NAME NOT LIKE '%\\_history';\n"
  "        UPDATE performance_schema.setup_instruments\n"
  "           SET ENABLED = 'YES',\n"
  "               TIMED   = 'YES';\n"
  "    END IF;\n"
  "    IF (in_start_fresh) THEN\n"
  "        TRUNCATE performance_schema.events_transactions_history_long;\n"
  "        TRUNCATE performance_schema.events_statements_history_long;\n"
  "        TRUNCATE performance_schema.events_stages_history_long;\n"
  "        TRUNCATE performance_schema.events_waits_history_long;\n"
  "    END IF;\n"
  "    DROP TEMPORARY TABLE IF EXISTS tmp_events;\n"
  "    CREATE TEMPORARY TABLE tmp_events (\n"
  "      event_id bigint unsigned NOT NULL,\n"
  "      event longblob,\n"
  "      PRIMARY KEY (event_id)\n"
  "    );\n"
  "    -- Print headers for a .dot file\n"
  "    INSERT INTO tmp_events VALUES (0, CONCAT('digraph events { rankdir=LR; nodesep=0.10;\\n',\n"
  "                                             '// Stack created .....: ', NOW(), '\\n',\n"
  "                                             '// MySQL version .....: ', VERSION(), '\\n',\n"
  "                                             '// MySQL hostname ....: ', @@hostname, '\\n',\n"
  "                                             '// MySQL port ........: ', @@port, '\\n',\n"
  "                                             '// MySQL socket ......: ', @@socket, '\\n',\n"
  "                                             '// MySQL user ........: ', CURRENT_USER(), '\\n'));\n"
  "    SELECT CONCAT('Data collection starting for THREAD_ID = ', in_thread_id) AS 'Info';\n"
  "    SET v_min_event_id = 0,\n"
  "        v_start        = UNIX_TIMESTAMP(),\n"
  "        in_interval    = IFNULL(in_interval, 1.00),\n"
  "        in_max_runtime = IFNULL(in_max_runtime, 60.00);\n"
  "    WHILE (v_runtime < in_max_runtime\n"
  "           AND (SELECT INSTRUMENTED FROM performance_schema.threads WHERE THREAD_ID = in_thread_id) = 'YES') DO\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_stack;\n"
  "        c_stack_loop: LOOP\n"
  "            FETCH c_stack INTO v_event, v_min_event_id;\n"
  "            IF v_done THEN\n"
  "                LEAVE c_stack_loop;\n"
  "            END IF;\n"
  "            IF (LENGTH(v_event) > 0) THEN\n"
  "                INSERT INTO tmp_events VALUES (v_min_event_id, v_event);\n"
  "            END IF;\n"
  "        END LOOP;\n"
  "        CLOSE c_stack;\n"
  "        SELECT SLEEP(in_interval) INTO @sleep;\n"
  "        SET v_runtime = (UNIX_TIMESTAMP() - v_start);\n"
  "    END WHILE;\n"
  "    INSERT INTO tmp_events VALUES (v_min_event_id+1, '}');\n"
  "    SET @query = CONCAT('SELECT event FROM tmp_events ORDER BY event_id INTO OUTFILE ''', in_outfile, ''' FIELDS ESCA"
  "PED BY '''' LINES TERMINATED BY ''''');\n"
  "    PREPARE stmt_output FROM @query;\n"
  "    EXECUTE stmt_output;\n"
  "    DEALLOCATE PREPARE stmt_output;\n"
  "    SELECT CONCAT('Stack trace written to ', in_outfile) AS 'Info';\n"
  "    SELECT CONCAT('dot -Tpdf -o /tmp/stack_', in_thread_id, '.pdf ', in_outfile) AS 'Convert to PDF';\n"
  "    SELECT CONCAT('dot -Tpng -o /tmp/stack_', in_thread_id, '.png ', in_outfile) AS 'Convert to PNG';\n"
  "    DROP TEMPORARY TABLE tmp_events;\n"
  "    -- Reset the settings for the performance schema\n"
  "    IF (in_auto_setup) THEN\n"
  "        CALL sys.ps_setup_reload_saved();\n"
  "    END IF;\n"
  "    -- Restore INSTRUMENTED for this thread\n"
  "    IF (v_this_thread_enabed = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_disable_background_threads;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_disable_background_threads ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Disable all background thread instrumentation within Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_background_threads();\n"
  "+--------------------------------+\n"
  "| summary                        |\n"
  "+--------------------------------+\n"
  "| Disabled 18 background threads |\n"
  "+--------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE type = 'BACKGROUND';\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' background thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_disable_consumer;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_disable_consumer (\n"
  "        IN consumer VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Disables consumers within Performance Schema \n"
  "matching the input pattern.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "consumer (VARCHAR(128)):\n"
  "  A LIKE pattern match (using \"%consumer%\") of consumers to disable\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "To disable all consumers:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_consumer(\\'\\');\n"
  "+--------------------------+\n"
  "| summary                  |\n"
  "+--------------------------+\n"
  "| Disabled 15 consumers    |\n"
  "+--------------------------+\n"
  "1 row in set (0.02 sec)\n"
  "\n"
  "To disable just the event_stage consumers:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_comsumers(\\'stage\\');\n"
  "+------------------------+\n"
  "| summary                |\n"
  "+------------------------+\n"
  "| Disabled 3 consumers   |\n"
  "+------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_consumers\n"
  "       SET enabled = 'NO'\n"
  "     WHERE name LIKE CONCAT('%', consumer, '%');\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' consumer', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_disable_instrument;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_disable_instrument (\n"
  "        IN in_pattern VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Disables instruments within Performance Schema \n"
  "matching the input pattern.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_pattern (VARCHAR(128)):\n"
  "  A LIKE pattern match (using \"%in_pattern%\") of events to disable\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "To disable all mutex instruments:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_instrument(\\'wait/synch/mutex\\');\n"
  "+--------------------------+\n"
  "| summary                  |\n"
  "+--------------------------+\n"
  "| Disabled 155 instruments |\n"
  "+--------------------------+\n"
  "1 row in set (0.02 sec)\n"
  "\n"
  "To disable just a specific TCP/IP based network IO instrument:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_instrument(\\'wait/io/socket/sql/server_tcpip_socket\\');\n"
  "+------------------------+\n"
  "| summary                |\n"
  "+------------------------+\n"
  "| Disabled 1 instruments |\n"
  "+------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "To disable all instruments:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_instrument(\\'\\');\n"
  "+--------------------------+\n"
  "| summary                  |\n"
  "+--------------------------+\n"
  "| Disabled 547 instruments |\n"
  "+--------------------------+\n"
  "1 row in set (0.01 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "       SET enabled = 'NO', timed = 'NO'\n"
  "     WHERE name LIKE CONCAT('%', in_pattern, '%');\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' instrument', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_disable_thread;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_disable_thread (\n"
  "        IN in_connection_id BIGINT\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Disable the given connection/thread in Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_connection_id (BIGINT):\n"
  "  The connection ID (PROCESSLIST_ID from performance_schema.threads\n"
  "  or the ID shown within SHOW PROCESSLIST)\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_thread(3);\n"
  "+-------------------+\n"
  "| summary           |\n"
  "+-------------------+\n"
  "| Disabled 1 thread |\n"
  "+-------------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "To disable the current connection:\n"
  "\n"
  "mysql> CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "+-------------------+\n"
  "| summary           |\n"
  "+-------------------+\n"
  "| Disabled 1 thread |\n"
  "+-------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'NO'\n"
  "     WHERE processlist_id = in_connection_id;\n"
  "    SELECT CONCAT('Disabled ', @rows := ROW_COUNT(), ' thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_enable_background_threads;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_enable_background_threads ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Enable all background thread instrumentation within Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_background_threads();\n"
  "+-------------------------------+\n"
  "| summary                       |\n"
  "+-------------------------------+\n"
  "| Enabled 18 background threads |\n"
  "+-------------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'YES'\n"
  "     WHERE type = 'BACKGROUND';\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' background thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_enable_consumer;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_enable_consumer (\n"
  "        IN consumer VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Enables consumers within Performance Schema \n"
  "matching the input pattern.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "consumer (VARCHAR(128)):\n"
  "  A LIKE pattern match (using \"%consumer%\") of consumers to enable\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "To enable all consumers:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_consumer(\\'\\');\n"
  "+-------------------------+\n"
  "| summary                 |\n"
  "+-------------------------+\n"
  "| Enabled 10 consumers    |\n"
  "+-------------------------+\n"
  "1 row in set (0.02 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.02 sec)\n"
  "\n"
  "To enable just \"waits\" consumers:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_consumer(\\'waits\\');\n"
  "+-----------------------+\n"
  "| summary               |\n"
  "+-----------------------+\n"
  "| Enabled 3 consumers   |\n"
  "+-----------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_consumers\n"
  "       SET enabled = 'YES'\n"
  "     WHERE name LIKE CONCAT('%', consumer, '%');\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' consumer', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_enable_instrument;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_enable_instrument (\n"
  "        IN in_pattern VARCHAR(128)\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Enables instruments within Performance Schema \n"
  "matching the input pattern.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_pattern (VARCHAR(128)):\n"
  "  A LIKE pattern match (using \"%in_pattern%\") of events to enable\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "To enable all mutex instruments:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_instrument(\\'wait/synch/mutex\\');\n"
  "+-------------------------+\n"
  "| summary                 |\n"
  "+-------------------------+\n"
  "| Enabled 155 instruments |\n"
  "+-------------------------+\n"
  "1 row in set (0.02 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.02 sec)\n"
  "\n"
  "To enable just a specific TCP/IP based network IO instrument:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_instrument(\\'wait/io/socket/sql/server_tcpip_socket\\');\n"
  "+-----------------------+\n"
  "| summary               |\n"
  "+-----------------------+\n"
  "| Enabled 1 instruments |\n"
  "+-----------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "To enable all instruments:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_instrument(\\'\\');\n"
  "+-------------------------+\n"
  "| summary                 |\n"
  "+-------------------------+\n"
  "| Enabled 547 instruments |\n"
  "+-------------------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.01 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "       SET enabled = 'YES', timed = 'YES'\n"
  "     WHERE name LIKE CONCAT('%', in_pattern, '%');\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' instrument', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_enable_thread;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_enable_thread (\n"
  "        IN in_connection_id BIGINT\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Enable the given connection/thread in Performance Schema.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_connection_id (BIGINT):\n"
  "  The connection ID (PROCESSLIST_ID from performance_schema.threads\n"
  "  or the ID shown within SHOW PROCESSLIST)\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_thread(3);\n"
  "+------------------+\n"
  "| summary          |\n"
  "+------------------+\n"
  "| Enabled 1 thread |\n"
  "+------------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "To enable the current connection:\n"
  "\n"
  "mysql> CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "+------------------+\n"
  "| summary          |\n"
  "+------------------+\n"
  "| Enabled 1 thread |\n"
  "+------------------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    UPDATE performance_schema.threads\n"
  "       SET instrumented = 'YES'\n"
  "     WHERE processlist_id = in_connection_id;\n"
  "    SELECT CONCAT('Enabled ', @rows := ROW_COUNT(), ' thread', IF(@rows != 1, 's', '')) AS summary;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_reload_saved;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_reload_saved ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Reloads a saved Performance Schema configuration,\n"
  "so that you can alter the setup for debugging purposes, \n"
  "but restore it to a previous state.\n"
  "\n"
  "Use the companion procedure - ps_setup_save(), to \n"
  "save a configuration.\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_save();\n"
  "Query OK, 0 rows affected (0.08 sec)\n"
  "\n"
  "mysql> UPDATE performance_schema.setup_instruments SET enabled = \\'YES\\', timed = \\'YES\\';\n"
  "Query OK, 547 rows affected (0.40 sec)\n"
  "Rows matched: 784  Changed: 547  Warnings: 0\n"
  "\n"
  "/* Run some tests that need more detailed instrumentation here */\n"
  "\n"
  "mysql> CALL sys.ps_setup_reload_saved();\n"
  "Query OK, 0 rows affected (0.32 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done bool DEFAULT FALSE;\n"
  "    DECLARE v_lock_result INT;\n"
  "    DECLARE v_lock_used_by BIGINT;\n"
  "    DECLARE v_signal_message TEXT;\n"
  "    DECLARE EXIT HANDLER FOR SQLEXCEPTION\n"
  "    BEGIN\n"
  "        SIGNAL SQLSTATE VALUE '90001'\n"
  "           SET MESSAGE_TEXT = 'An error occurred, was sys.ps_setup_save() run before this procedure?';\n"
  "    END;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    SELECT IS_USED_LOCK('sys.ps_setup_save') INTO v_lock_used_by;\n"
  "    IF (v_lock_used_by != CONNECTION_ID()) THEN\n"
  "        SET v_signal_message = CONCAT('The sys.ps_setup_save lock is currently owned by ', v_lock_used_by);\n"
  "        SIGNAL SQLSTATE VALUE '90002'\n"
  "           SET MESSAGE_TEXT = v_signal_message;\n"
  "    END IF;\n"
  "    DELETE FROM performance_schema.setup_actors;\n"
  "    INSERT INTO performance_schema.setup_actors SELECT * FROM tmp_setup_actors;\n"
  "    BEGIN\n"
  "        -- Workaround for http://bugs.mysql.com/bug.php?id=70025\n"
  "        DECLARE v_name varchar(64);\n"
  "        DECLARE v_enabled enum('YES', 'NO');\n"
  "        DECLARE c_consumers CURSOR FOR SELECT NAME, ENABLED FROM tmp_setup_consumers;\n"
  "        DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_consumers;\n"
  "        c_consumers_loop: LOOP\n"
  "            FETCH c_consumers INTO v_name, v_enabled;\n"
  "            IF v_done THEN\n"
  "               LEAVE c_consumers_loop;\n"
  "            END IF;\n"
  "            UPDATE performance_schema.setup_consumers\n"
  "               SET ENABLED = v_enabled\n"
  "             WHERE NAME = v_name;\n"
  "         END LOOP;\n"
  "         CLOSE c_consumers;\n"
  "    END;\n"
  "    UPDATE performance_schema.setup_instruments\n"
  "     INNER JOIN tmp_setup_instruments USING (NAME)\n"
  "       SET performance_schema.setup_instruments.ENABLED = tmp_setup_instruments.ENABLED,\n"
  "           performance_schema.setup_instruments.TIMED   = tmp_setup_instruments.TIMED;\n"
  "    BEGIN\n"
  "        -- Workaround for http://bugs.mysql.com/bug.php?id=70025\n"
  "        DECLARE v_thread_id bigint unsigned;\n"
  "        DECLARE v_instrumented enum('YES', 'NO');\n"
  "        DECLARE c_threads CURSOR FOR SELECT THREAD_ID, INSTRUMENTED FROM tmp_threads;\n"
  "        DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "        SET v_done = FALSE;\n"
  "        OPEN c_threads;\n"
  "        c_threads_loop: LOOP\n"
  "            FETCH c_threads INTO v_thread_id, v_instrumented;\n"
  "            IF v_done THEN\n"
  "               LEAVE c_threads_loop;\n"
  "            END IF;\n"
  "            UPDATE performance_schema.threads\n"
  "               SET INSTRUMENTED = v_instrumented\n"
  "             WHERE THREAD_ID = v_thread_id;\n"
  "        END LOOP;\n"
  "        CLOSE c_threads;\n"
  "    END;\n"
  "    UPDATE performance_schema.threads\n"
  "       SET INSTRUMENTED = IF(PROCESSLIST_USER IS NOT NULL,\n"
  "                             sys.ps_is_account_enabled(PROCESSLIST_HOST, PROCESSLIST_USER),\n"
  "                             'YES')\n"
  "     WHERE THREAD_ID NOT IN (SELECT THREAD_ID FROM tmp_threads);\n"
  "    DROP TEMPORARY TABLE tmp_setup_actors;\n"
  "    DROP TEMPORARY TABLE tmp_setup_consumers;\n"
  "    DROP TEMPORARY TABLE tmp_setup_instruments;\n"
  "    DROP TEMPORARY TABLE tmp_threads;\n"
  "    SELECT RELEASE_LOCK('sys.ps_setup_save') INTO v_lock_result;\n"
  "    SET sql_log_bin = @log_bin; \n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_reset_to_default;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_reset_to_default (\n"
  "       IN in_verbose BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Resets the Performance Schema setup to the default settings.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_verbose (BOOLEAN):\n"
  "  Whether to print each setup stage (including the SQL) whilst running.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_reset_to_default(true)\\\\G\n"
  "*************************** 1. row ***************************\n"
  "status: Resetting: setup_actors\n"
  "DELETE\n"
  "FROM performance_schema.setup_actors\n"
  " WHERE NOT (HOST = \\'%\\' AND USER = \\'%\\' AND `ROLE` = \\'%\\')\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "*************************** 1. row ***************************\n"
  "status: Resetting: setup_actors\n"
  "INSERT IGNORE INTO performance_schema.setup_actors\n"
  "VALUES (\\'%\\', \\'%\\', \\'%\\')\n"
  "1 row in set (0.00 sec)\n"
  "...\n"
  "\n"
  "mysql> CALL sys.ps_setup_reset_to_default(false)\\\\G\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    SET @query = 'DELETE\n"
  "                    FROM performance_schema.setup_actors\n"
  "                   WHERE NOT (HOST = ''%'' AND USER = ''%'' AND `ROLE` = ''%'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_actors\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'INSERT IGNORE INTO performance_schema.setup_actors\n"
  "                  VALUES (''%'', ''%'', ''%'', ''YES'', ''YES'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_actors\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.setup_instruments\n"
  "                     SET ENABLED = sys.ps_is_instrument_default_enabled(NAME),\n"
  "                         TIMED   = sys.ps_is_instrument_default_timed(NAME)';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_instruments\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.setup_consumers\n"
  "                     SET ENABLED = IF(NAME IN (''events_statements_current'', ''events_transactions_current'', ''glob"
  "al_instrumentation'', ''thread_instrumentation'', ''statements_digest''), ''YES'', ''NO'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_consumers\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'DELETE\n"
  "                    FROM performance_schema.setup_objects\n"
  "                   WHERE NOT (OBJECT_TYPE IN (''EVENT'', ''FUNCTION'', ''PROCEDURE'', ''TABLE'', ''TRIGGER'') AND OBJ"
  "ECT_NAME = ''%'' \n"
  "                     AND (OBJECT_SCHEMA = ''mysql''              AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''performance_schema'' AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''information_schema'' AND ENABLED = ''NO''  AND TIMED = ''NO'' )\n"
  "                      OR (OBJECT_SCHEMA = ''%''                  AND ENABLED = ''YES'' AND TIMED = ''YES''))';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_objects\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'INSERT IGNORE INTO performance_schema.setup_objects\n"
  "                  VALUES (''EVENT''    , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''EVENT''    , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''FUNCTION'' , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''FUNCTION'' , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''PROCEDURE'', ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''PROCEDURE'', ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''TABLE''    , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TABLE''    , ''%''                 , ''%'', ''YES'', ''YES''),\n"
  "                         (''TRIGGER''  , ''mysql''             , ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''performance_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''information_schema'', ''%'', ''NO'' , ''NO'' ),\n"
  "                         (''TRIGGER''  , ''%''                 , ''%'', ''YES'', ''YES'')';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: setup_objects\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "    SET @query = 'UPDATE performance_schema.threads\n"
  "                     SET INSTRUMENTED = ''YES''';\n"
  "    IF (in_verbose) THEN\n"
  "        SELECT CONCAT('Resetting: threads\\n', REPLACE(@query, '  ', '')) AS status;\n"
  "    END IF;\n"
  "    PREPARE reset_stmt FROM @query;\n"
  "    EXECUTE reset_stmt;\n"
  "    DEALLOCATE PREPARE reset_stmt;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_save;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_save (\n"
  "        IN in_timeout INT\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Saves the current configuration of Performance Schema, \n"
  "so that you can alter the setup for debugging purposes, \n"
  "but restore it to a previous state.\n"
  "\n"
  "Use the companion procedure - ps_setup_reload_saved(), to \n"
  "restore the saved config.\n"
  "\n"
  "The named lock \"sys.ps_setup_save\" is taken before the\n"
  "current configuration is saved. If the attempt to get the named\n"
  "lock times out, an error occurs.\n"
  "\n"
  "The lock is released after the settings have been restored by\n"
  "calling ps_setup_reload_saved().\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_timeout INT\n"
  "  The timeout in seconds used when trying to obtain the lock.\n"
  "  A negative timeout means infinite timeout.\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_save(-1);\n"
  "Query OK, 0 rows affected (0.08 sec)\n"
  "\n"
  "mysql> UPDATE performance_schema.setup_instruments \n"
  "    ->    SET enabled = \\'YES\\', timed = \\'YES\\';\n"
  "Query OK, 547 rows affected (0.40 sec)\n"
  "Rows matched: 784  Changed: 547  Warnings: 0\n"
  "\n"
  "/* Run some tests that need more detailed instrumentation here */\n"
  "\n"
  "mysql> CALL sys.ps_setup_reload_saved();\n"
  "Query OK, 0 rows affected (0.32 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_lock_result INT;\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    SET sql_log_bin = 0;\n"
  "    SELECT GET_LOCK('sys.ps_setup_save', in_timeout) INTO v_lock_result;\n"
  "    IF v_lock_result THEN\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_actors;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_consumers;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_setup_instruments;\n"
  "        DROP TEMPORARY TABLE IF EXISTS tmp_threads;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_actors SELECT * FROM performance_schema.setup_actors LIMIT 0;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_consumers LIKE performance_schema.setup_consumers;\n"
  "        CREATE TEMPORARY TABLE tmp_setup_instruments LIKE performance_schema.setup_instruments;\n"
  "        CREATE TEMPORARY TABLE tmp_threads (THREAD_ID bigint unsigned NOT NULL PRIMARY KEY, INSTRUMENTED enum('YES','"
  "NO') NOT NULL);\n"
  "        INSERT INTO tmp_setup_actors SELECT * FROM performance_schema.setup_actors;\n"
  "        INSERT INTO tmp_setup_consumers SELECT * FROM performance_schema.setup_consumers;\n"
  "        INSERT INTO tmp_setup_instruments SELECT * FROM performance_schema.setup_instruments;\n"
  "        INSERT INTO tmp_threads SELECT THREAD_ID, INSTRUMENTED FROM performance_schema.threads;\n"
  "    ELSE\n"
  "        SIGNAL SQLSTATE VALUE '90000'\n"
  "           SET MESSAGE_TEXT = 'Could not lock the sys.ps_setup_save user lock, another thread has a saved configurati"
  "on';\n"
  "    END IF;\n"
  "    SET sql_log_bin = @log_bin;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_disabled;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_disabled (\n"
  "        IN in_show_instruments BOOLEAN,\n"
  "        IN in_show_threads BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently disable Performance Schema configuration.\n"
  "\n"
  "Disabled users is only available for MySQL 5.7.6 and later.\n"
  "In earlier versions it was only possible to enable users.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_show_instruments (BOOLEAN):\n"
  "  Whether to print disabled instruments (can print many items)\n"
  "\n"
  "in_show_threads (BOOLEAN):\n"
  "  Whether to print disabled threads\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_disabled(TRUE, TRUE);\n"
  "+----------------------------+\n"
  "| performance_schema_enabled |\n"
  "+----------------------------+\n"
  "|                          1 |\n"
  "+----------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "+--------------------+\n"
  "| disabled_users     |\n"
  "+--------------------+\n"
  "| \\'mark\\'@\\'localhost\\' |\n"
  "+--------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "+-------------+----------------------+---------+-------+\n"
  "| object_type | objects              | enabled | timed |\n"
  "+-------------+----------------------+---------+-------+\n"
  "| EVENT       | mysql.%              | NO      | NO    |\n"
  "| EVENT       | performance_schema.% | NO      | NO    |\n"
  "| EVENT       | information_schema.% | NO      | NO    |\n"
  "| FUNCTION    | mysql.%              | NO      | NO    |\n"
  "| FUNCTION    | performance_schema.% | NO      | NO    |\n"
  "| FUNCTION    | information_schema.% | NO      | NO    |\n"
  "| PROCEDURE   | mysql.%              | NO      | NO    |\n"
  "| PROCEDURE   | performance_schema.% | NO      | NO    |\n"
  "| PROCEDURE   | information_schema.% | NO      | NO    |\n"
  "| TABLE       | mysql.%              | NO      | NO    |\n"
  "| TABLE       | performance_schema.% | NO      | NO    |\n"
  "| TABLE       | information_schema.% | NO      | NO    |\n"
  "| TRIGGER     | mysql.%              | NO      | NO    |\n"
  "| TRIGGER     | performance_schema.% | NO      | NO    |\n"
  "| TRIGGER     | information_schema.% | NO      | NO    |\n"
  "+-------------+----------------------+---------+-------+\n"
  "15 rows in set (0.00 sec)\n"
  "\n"
  "+----------------------------------+\n"
  "| disabled_consumers               |\n"
  "+----------------------------------+\n"
  "| events_stages_current            |\n"
  "| events_stages_history            |\n"
  "| events_stages_history_long       |\n"
  "| events_statements_history        |\n"
  "| events_statements_history_long   |\n"
  "| events_transactions_history      |\n"
  "| events_transactions_history_long |\n"
  "| events_waits_current             |\n"
  "| events_waits_history             |\n"
  "| events_waits_history_long        |\n"
  "+----------------------------------+\n"
  "10 rows in set (0.00 sec)\n"
  "\n"
  "Empty set (0.00 sec)\n"
  "\n"
  "+---------------------------------------------------------------------------------------+-------+\n"
  "| disabled_instruments                                                                  | timed |\n"
  "+---------------------------------------------------------------------------------------+-------+\n"
  "| wait/synch/mutex/sql/TC_LOG_MMAP::LOCK_tc                                             | NO    |\n"
  "| wait/synch/mutex/sql/LOCK_des_key_file                                                | NO    |\n"
  "| wait/synch/mutex/sql/MYSQL_BIN_LOG::LOCK_commit                                       | NO    |\n"
  "...\n"
  "| memory/sql/servers_cache                                                              | NO    |\n"
  "| memory/sql/udf_mem                                                                    | NO    |\n"
  "| wait/lock/metadata/sql/mdl                                                            | NO    |\n"
  "+---------------------------------------------------------------------------------------+-------+\n"
  "547 rows in set (0.00 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.01 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT @@performance_schema AS performance_schema_enabled;\n"
  "    SELECT CONCAT('\\'', user, '\\'@\\'', host, '\\'') AS disabled_users\n"
  "      FROM performance_schema.setup_actors\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_users;\n"
  "    SELECT object_type,\n"
  "           CONCAT(object_schema, '.', object_name) AS objects,\n"
  "           enabled,\n"
  "           timed\n"
  "      FROM performance_schema.setup_objects\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY object_type, objects;\n"
  "    SELECT name AS disabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_consumers;\n"
  "    IF (in_show_threads) THEN\n"
  "        SELECT IF(name = 'thread/sql/one_connection', \n"
  "                  CONCAT(processlist_user, '@', processlist_host), \n"
  "                  REPLACE(name, 'thread/', '')) AS disabled_threads,\n"
  "        TYPE AS thread_type\n"
  "          FROM performance_schema.threads\n"
  "         WHERE INSTRUMENTED = 'NO'\n"
  "         ORDER BY disabled_threads;\n"
  "    END IF;\n"
  "    IF (in_show_instruments) THEN\n"
  "        SELECT name AS disabled_instruments,\n"
  "               timed\n"
  "          FROM performance_schema.setup_instruments\n"
  "         WHERE enabled = 'NO'\n"
  "         ORDER BY disabled_instruments;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_disabled_consumers;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_disabled_consumers ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently disabled consumers.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_disabled_consumers();\n"
  "\n"
  "+---------------------------+\n"
  "| disabled_consumers        |\n"
  "+---------------------------+\n"
  "| events_statements_current |\n"
  "| global_instrumentation    |\n"
  "| thread_instrumentation    |\n"
  "| statements_digest         |\n"
  "+---------------------------+\n"
  "4 rows in set (0.05 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS disabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_consumers;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_disabled_instruments;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_disabled_instruments ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently disabled instruments.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_disabled_instruments();\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS disabled_instruments, timed\n"
  "      FROM performance_schema.setup_instruments\n"
  "     WHERE enabled = 'NO'\n"
  "     ORDER BY disabled_instruments;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_enabled;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_enabled (\n"
  "        IN in_show_instruments BOOLEAN,\n"
  "        IN in_show_threads BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently enabled Performance Schema configuration.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_show_instruments (BOOLEAN):\n"
  "  Whether to print enabled instruments (can print many items)\n"
  "\n"
  "in_show_threads (BOOLEAN):\n"
  "  Whether to print enabled threads\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_enabled(TRUE, TRUE);\n"
  "+----------------------------+\n"
  "| performance_schema_enabled |\n"
  "+----------------------------+\n"
  "|                          1 |\n"
  "+----------------------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "+---------------+\n"
  "| enabled_users |\n"
  "+---------------+\n"
  "| \\'%\\'@\\'%\\'       |\n"
  "+---------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "+-------------+---------+---------+-------+\n"
  "| object_type | objects | enabled | timed |\n"
  "+-------------+---------+---------+-------+\n"
  "| EVENT       | %.%     | YES     | YES   |\n"
  "| FUNCTION    | %.%     | YES     | YES   |\n"
  "| PROCEDURE   | %.%     | YES     | YES   |\n"
  "| TABLE       | %.%     | YES     | YES   |\n"
  "| TRIGGER     | %.%     | YES     | YES   |\n"
  "+-------------+---------+---------+-------+\n"
  "5 rows in set (0.01 sec)\n"
  "\n"
  "+---------------------------+\n"
  "| enabled_consumers         |\n"
  "+---------------------------+\n"
  "| events_statements_current |\n"
  "| global_instrumentation    |\n"
  "| thread_instrumentation    |\n"
  "| statements_digest         |\n"
  "+---------------------------+\n"
  "4 rows in set (0.05 sec)\n"
  "\n"
  "+---------------------------------+-------------+\n"
  "| enabled_threads                 | thread_type |\n"
  "+---------------------------------+-------------+\n"
  "| sql/main                        | BACKGROUND  |\n"
  "| sql/thread_timer_notifier       | BACKGROUND  |\n"
  "| innodb/io_ibuf_thread           | BACKGROUND  |\n"
  "| innodb/io_log_thread            | BACKGROUND  |\n"
  "| innodb/io_read_thread           | BACKGROUND  |\n"
  "| innodb/io_read_thread           | BACKGROUND  |\n"
  "| innodb/io_write_thread          | BACKGROUND  |\n"
  "| innodb/io_write_thread          | BACKGROUND  |\n"
  "| innodb/page_cleaner_thread      | BACKGROUND  |\n"
  "| innodb/srv_lock_timeout_thread  | BACKGROUND  |\n"
  "| innodb/srv_error_monitor_thread | BACKGROUND  |\n"
  "| innodb/srv_monitor_thread       | BACKGROUND  |\n"
  "| innodb/srv_master_thread        | BACKGROUND  |\n"
  "| innodb/srv_purge_thread         | BACKGROUND  |\n"
  "| innodb/srv_worker_thread        | BACKGROUND  |\n"
  "| innodb/srv_worker_thread        | BACKGROUND  |\n"
  "| innodb/srv_worker_thread        | BACKGROUND  |\n"
  "| innodb/buf_dump_thread          | BACKGROUND  |\n"
  "| innodb/dict_stats_thread        | BACKGROUND  |\n"
  "| sql/signal_handler              | BACKGROUND  |\n"
  "| sql/compress_gtid_table         | FOREGROUND  |\n"
  "| root@localhost                  | FOREGROUND  |\n"
  "+---------------------------------+-------------+\n"
  "22 rows in set (0.01 sec)\n"
  "\n"
  "+-------------------------------------+-------+\n"
  "| enabled_instruments                 | timed |\n"
  "+-------------------------------------+-------+\n"
  "| wait/io/file/sql/map                | YES   |\n"
  "| wait/io/file/sql/binlog             | YES   |\n"
  "...\n"
  "| statement/com/Error                 | YES   |\n"
  "| statement/com/                      | YES   |\n"
  "| idle                                | YES   |\n"
  "+-------------------------------------+-------+\n"
  "210 rows in set (0.08 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.89 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT @@performance_schema AS performance_schema_enabled;\n"
  "    SELECT CONCAT('\\'', user, '\\'@\\'', host, '\\'') AS enabled_users\n"
  "      FROM performance_schema.setup_actors\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_users;\n"
  "    SELECT object_type,\n"
  "           CONCAT(object_schema, '.', object_name) AS objects,\n"
  "           enabled,\n"
  "           timed\n"
  "      FROM performance_schema.setup_objects\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY object_type, objects;\n"
  "    SELECT name AS enabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_consumers;\n"
  "    IF (in_show_threads) THEN\n"
  "        SELECT IF(name = 'thread/sql/one_connection', \n"
  "                  CONCAT(processlist_user, '@', processlist_host), \n"
  "                  REPLACE(name, 'thread/', '')) AS enabled_threads,\n"
  "        TYPE AS thread_type\n"
  "          FROM performance_schema.threads\n"
  "         WHERE INSTRUMENTED = 'YES'\n"
  "         ORDER BY enabled_threads;\n"
  "    END IF;\n"
  "    IF (in_show_instruments) THEN\n"
  "        SELECT name AS enabled_instruments,\n"
  "               timed\n"
  "          FROM performance_schema.setup_instruments\n"
  "         WHERE enabled = 'YES'\n"
  "         ORDER BY enabled_instruments;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_enabled_consumers;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_enabled_consumers ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently enabled consumers.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_enabled_consumers();\n"
  "\n"
  "+---------------------------+\n"
  "| enabled_consumers         |\n"
  "+---------------------------+\n"
  "| events_statements_current |\n"
  "| global_instrumentation    |\n"
  "| thread_instrumentation    |\n"
  "| statements_digest         |\n"
  "+---------------------------+\n"
  "4 rows in set (0.05 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS enabled_consumers\n"
  "      FROM performance_schema.setup_consumers\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_consumers;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_setup_show_enabled_instruments;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_setup_show_enabled_instruments ()\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Shows all currently enabled instruments.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "None\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_setup_show_enabled_instruments();\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    READS SQL DATA\n"
  "BEGIN\n"
  "    SELECT name AS enabled_instruments, timed\n"
  "      FROM performance_schema.setup_instruments\n"
  "     WHERE enabled = 'YES'\n"
  "     ORDER BY enabled_instruments;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS ps_truncate_all_tables;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE ps_truncate_all_tables (\n"
  "        IN in_verbose BOOLEAN\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Truncates all summary tables within Performance Schema, \n"
  "resetting all aggregated instrumentation as a snapshot.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_verbose (BOOLEAN):\n"
  "  Whether to print each TRUNCATE statement before running\n"
  "\n"
  "Example\n"
  "-----------\n"
  "\n"
  "mysql> CALL sys.ps_truncate_all_tables(false);\n"
  "+---------------------+\n"
  "| summary             |\n"
  "+---------------------+\n"
  "| Truncated 44 tables |\n"
  "+---------------------+\n"
  "1 row in set (0.10 sec)\n"
  "\n"
  "Query OK, 0 rows affected (0.10 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    DETERMINISTIC\n"
  "    MODIFIES SQL DATA\n"
  "BEGIN\n"
  "    DECLARE v_done INT DEFAULT FALSE;\n"
  "    DECLARE v_total_tables INT DEFAULT 0;\n"
  "    DECLARE v_ps_table VARCHAR(64);\n"
  "    DECLARE ps_tables CURSOR FOR\n"
  "        SELECT table_name \n"
  "          FROM INFORMATION_SCHEMA.TABLES \n"
  "         WHERE table_schema = 'performance_schema' \n"
  "           AND (table_name LIKE '%summary%' \n"
  "            OR table_name LIKE '%history%');\n"
  "    DECLARE CONTINUE HANDLER FOR NOT FOUND SET v_done = TRUE;\n"
  "    OPEN ps_tables;\n"
  "    ps_tables_loop: LOOP\n"
  "        FETCH ps_tables INTO v_ps_table;\n"
  "        IF v_done THEN\n"
  "          LEAVE ps_tables_loop;\n"
  "        END IF;\n"
  "        SET @truncate_stmt := CONCAT('TRUNCATE TABLE performance_schema.', v_ps_table);\n"
  "        IF in_verbose THEN\n"
  "            SELECT CONCAT('Running: ', @truncate_stmt) AS status;\n"
  "        END IF;\n"
  "        PREPARE truncate_stmt FROM @truncate_stmt;\n"
  "        EXECUTE truncate_stmt;\n"
  "        DEALLOCATE PREPARE truncate_stmt;\n"
  "        SET v_total_tables = v_total_tables + 1;\n"
  "    END LOOP;\n"
  "    CLOSE ps_tables;\n"
  "    SELECT CONCAT('Truncated ', v_total_tables, ' tables') AS summary;\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "-- \n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "-- \n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "-- \n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS statement_performance_analyzer;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE statement_performance_analyzer (\n"
  "        IN in_action ENUM('snapshot', 'overall', 'delta', 'create_table', 'create_tmp', 'save', 'cleanup'),\n"
  "        IN in_table VARCHAR(129),\n"
  "        IN in_views SET ('with_runtimes_in_95th_percentile', 'analysis', 'with_errors_or_warnings', 'with_full_table_"
  "scans', 'with_sorting', 'with_temp_tables', 'custom')\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Create a report of the statements running on the server.\n"
  "\n"
  "The views are calculated based on the overall and/or delta activity.\n"
  "\n"
  "Requires the SUPER privilege for \"SET sql_log_bin = 0;\".\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_action (ENUM(''snapshot'', ''overall'', ''delta'', ''create_tmp'', ''create_table'', ''save'', ''cleanup'')):\n"
  "  The action to take. Supported actions are:\n"
  "    * snapshot      Store a snapshot. The default is to make a snapshot of the current content of\n"
  "                    performance_schema.events_statements_summary_by_digest, but by setting in_table\n"
  "                    this can be overwritten to copy the content of the specified table.\n"
  "                    The snapshot is stored in the sys.tmp_digests temporary table.\n"
  "    * overall       Generate analyzis based on the content specified by in_table. For the overall analyzis,\n"
  "                    in_table can be NOW() to use a fresh snapshot. This will overwrite an existing snapshot.\n"
  "                    Use NULL for in_table to use the existing snapshot. If in_table IS NULL and no snapshot\n"
  "                    exists, a new will be created.\n"
  "                    See also in_views and @sys.statement_performance_analyzer.limit.\n"
  "    * delta         Generate a delta analysis. The delta will be calculated between the reference table in\n"
  "                    in_table and the snapshot. An existing snapshot must exist.\n"
  "                    The action uses the sys.tmp_digests_delta temporary table.\n"
  "                    See also in_views and @sys.statement_performance_analyzer.limit.\n"
  "    * create_table  Create a regular table suitable for storing the snapshot for later use, e.g. for\n"
  "                    calculating deltas.\n"
  "    * create_tmp    Create a temporary table suitable for storing the snapshot for later use, e.g. for\n"
  "                    calculating deltas.\n"
  "    * save          Save the snapshot in the table specified by in_table. The table must exists and have\n"
  "                    the correct structure.\n"
  "                    If no snapshot exists, a new is created.\n"
  "    * cleanup       Remove the temporary tables used for the snapshot and delta.\n"
  "\n"
  "in_table (VARCHAR(129)):\n"
  "  The table argument used for some actions. Use the format ''db1.t1'' or ''t1'' without using any backticks (`)\n"
  "  for quoting. Periods (.) are not supported in the database and table names.\n"
  "\n"
  "  The meaning of the table for each action supporting the argument is:\n"
  "\n"
  "    * snapshot      The snapshot is created based on the specified table. Set to NULL or NOW() to use\n"
  "                    the current content of performance_schema.events_statements_summary_by_digest.\n"
  "    * overall       The table with the content to create the overall analyzis for. The following values\n"
  "                    can be used:\n"
  "                      - A table name - use the content of that table.\n"
  "                      - NOW()        - create a fresh snapshot and overwrite the existing snapshot.\n"
  "                      - NULL         - use the last stored snapshot.\n"
  "    * delta         The table name is mandatory and specified the reference view to compare the currently\n"
  "                    stored snapshot against. If no snapshot exists, a new will be created.\n"
  "    * create_table  The name of the regular table to create.\n"
  "    * create_tmp    The name of the temporary table to create.\n"
  "    * save          The name of the table to save the currently stored snapshot into.\n"
  "\n"
  "in_views (SET (''with_runtimes_in_95th_percentile'', ''analysis'', ''with_errors_or_warnings'',\n"
  "               ''with_full_table_scans'', ''with_sorting'', ''with_temp_tables'', ''custom''))\n"
  "  Which views to include:\n"
  "\n"
  "    * with_runtimes_in_95th_percentile  Based on the sys.statements_with_runtimes_in_95th_percentile view\n"
  "    * analysis                          Based on the sys.statement_analysis view\n"
  "    * with_errors_or_warnings           Based on the sys.statements_with_errors_or_warnings view\n"
  "    * with_full_table_scans             Based on the sys.statements_with_full_table_scans view\n"
  "    * with_sorting                      Based on the sys.statements_with_sorting view\n"
  "    * with_temp_tables                  Based on the sys.statements_with_temp_tables view\n"
  "    * custom                            Use a custom view. This view must be specified in @sys.statement_performance_"
  "analyzer.view to an existing view or a query\n"
  "\n"
  "Default is to include all except ''custom''.\n"
  "\n"
  "\n"
  "Configuration Options\n"
  "----------------------\n"
  "\n"
  "sys.statement_performance_analyzer.limit\n"
  "  The maximum number of rows to include for the views that does not have a built-in limit (e.g. the 95th percentile v"
  "iew).\n"
  "  If not set the limit is 100.\n"
  "\n"
  "sys.statement_performance_analyzer.view\n"
  "  Used together with the ''custom'' view. If the value contains a space, it is considered a query, otherwise it must "
  "be\n"
  "  an existing view querying the performance_schema.events_statements_summary_by_digest table. There cannot be any lim"
  "it\n"
  "  clause including in the query or view definition if @sys.statement_performance_analyzer.limit > 0.\n"
  "  If specifying a view, use the same format as for in_table.\n"
  "\n"
  "sys.debug\n"
  "  Whether to provide debugging output.\n"
  "  Default is ''OFF''. Set to ''ON'' to include.\n"
  "\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "To create a report with the queries in the 95th percentile since last truncate of performance_schema.events_statement"
  "s_summary_by_digest\n"
  "and the delta for a 1 minute period:\n"
  "\n"
  "   1. Create a temporary table to store the initial snapshot.\n"
  "   2. Create the initial snapshot.\n"
  "   3. Save the initial snapshot in the temporary table.\n"
  "   4. Wait one minute.\n"
  "   5. Create a new snapshot.\n"
  "   6. Perform analyzis based on the new snapshot.\n"
  "   7. Perform analyzis based on the delta between the initial and new snapshots.\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''create_tmp'', ''mydb.tmp_digests_ini'', NULL);\n"
  "Query OK, 0 rows affected (0.08 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "Query OK, 0 rows affected (0.02 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''save'', ''mydb.tmp_digests_ini'', NULL);\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "mysql> DO SLEEP(60);\n"
  "Query OK, 0 rows affected (1 min 0.00 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "Query OK, 0 rows affected (0.02 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''overall'', NULL, ''with_runtimes_in_95th_percentile'');\n"
  "+-----------------------------------------+\n"
  "| Next Output                             |\n"
  "+-----------------------------------------+\n"
  "| Queries with Runtime in 95th Percentile |\n"
  "+-----------------------------------------+\n"
  "1 row in set (0.05 sec)\n"
  "\n"
  "...\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''delta'', ''mydb.tmp_digests_ini'', ''with_runtimes_in_95th_percentil"
  "e'');\n"
  "+-----------------------------------------+\n"
  "| Next Output                             |\n"
  "+-----------------------------------------+\n"
  "| Queries with Runtime in 95th Percentile |\n"
  "+-----------------------------------------+\n"
  "1 row in set (0.03 sec)\n"
  "\n"
  "...\n"
  "\n"
  "\n"
  "To create an overall report of the 95th percentile queries and the top 10 queries with full table scans:\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "Query OK, 0 rows affected (0.01 sec)\n"
  "\n"
  "mysql> SET @sys.statement_performance_analyzer.limit = 10;\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''overall'', NULL, ''with_runtimes_in_95th_percentile,with_full_table_"
  "scans'');\n"
  "+-----------------------------------------+\n"
  "| Next Output                             |\n"
  "+-----------------------------------------+\n"
  "| Queries with Runtime in 95th Percentile |\n"
  "+-----------------------------------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "...\n"
  "\n"
  "+-------------------------------------+\n"
  "| Next Output                         |\n"
  "+-------------------------------------+\n"
  "| Top 10 Queries with Full Table Scan |\n"
  "+-------------------------------------+\n"
  "1 row in set (0.09 sec)\n"
  "\n"
  "...\n"
  "\n"
  "\n"
  "Use a custom view showing the top 10 query sorted by total execution time refreshing the view every minute using\n"
  "the watch command in Linux.\n"
  "\n"
  "mysql> CREATE OR REPLACE VIEW mydb.my_statements AS\n"
  "    -> SELECT sys.format_statement(DIGEST_TEXT) AS query,\n"
  "    ->        SCHEMA_NAME AS db,\n"
  "    ->        COUNT_STAR AS exec_count,\n"
  "    ->        format_pico_time(SUM_TIMER_WAIT) AS total_latency,\n"
  "    ->        format_pico_time(AVG_TIMER_WAIT) AS avg_latency,\n"
  "    ->        ROUND(IFNULL(SUM_ROWS_SENT / NULLIF(COUNT_STAR, 0), 0)) AS rows_sent_avg,\n"
  "    ->        ROUND(IFNULL(SUM_ROWS_EXAMINED / NULLIF(COUNT_STAR, 0), 0)) AS rows_examined_avg,\n"
  "    ->        ROUND(IFNULL(SUM_ROWS_AFFECTED / NULLIF(COUNT_STAR, 0), 0)) AS rows_affected_avg,\n"
  "    ->        DIGEST AS digest\n"
  "    ->   FROM performance_schema.events_statements_summary_by_digest\n"
  "    -> ORDER BY SUM_TIMER_WAIT DESC;\n"
  "Query OK, 0 rows affected (0.01 sec)\n"
  "\n"
  "mysql> CALL sys.statement_performance_analyzer(''create_table'', ''mydb.digests_prev'', NULL);\n"
  "Query OK, 0 rows affected (0.10 sec)\n"
  "\n"
  "shell$ watch -n 60 \"mysql sys --table -e \\\"\n"
  "> SET @sys.statement_performance_analyzer.view = ''mydb.my_statements'';\n"
  "> SET @sys.statement_performance_analyzer.limit = 10;\n"
  "> CALL statement_performance_analyzer(''snapshot'', NULL, NULL);\n"
  "> CALL statement_performance_analyzer(''delta'', ''mydb.digests_prev'', ''custom'');\n"
  "> CALL statement_performance_analyzer(''save'', ''mydb.digests_prev'', NULL);\n"
  "> \\\"\"\n"
  "\n"
  "Every 60.0s: mysql sys --table -e \"                                                                                 "
  "                  ...  Mon Dec 22 10:58:51 2014\n"
  "\n"
  "+----------------------------------+\n"
  "| Next Output                      |\n"
  "+----------------------------------+\n"
  "| Top 10 Queries Using Custom View |\n"
  "+----------------------------------+\n"
  "+-------------------+-------+------------+---------------+-------------+---------------+-------------------+---------"
  "----------+----------------------------------+\n"
  "| query             | db    | exec_count | total_latency | avg_latency | rows_sent_avg | rows_examined_avg | rows_aff"
  "ected_avg | digest                           |\n"
  "+-------------------+-------+------------+---------------+-------------+---------------+-------------------+---------"
  "----------+----------------------------------+\n"
  "...\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    DECLARE v_table_exists, v_tmp_digests_table_exists, v_custom_view_exists ENUM('', 'BASE TABLE', 'VIEW', 'TEMPORAR"
  "Y') DEFAULT '';\n"
  "    DECLARE v_this_thread_enabled ENUM('YES', 'NO');\n"
  "    DECLARE v_force_new_snapshot BOOLEAN DEFAULT FALSE;\n"
  "    DECLARE v_digests_table VARCHAR(133);\n"
  "    DECLARE v_quoted_table, v_quoted_custom_view VARCHAR(133) DEFAULT '';\n"
  "    DECLARE v_table_db, v_table_name, v_custom_db, v_custom_name VARCHAR(64);\n"
  "    DECLARE v_digest_table_template, v_checksum_ref, v_checksum_table text;\n"
  "    DECLARE v_sql longtext;\n"
  "    -- Maximum supported length for MESSAGE_TEXT with the SIGNAL command is 128 chars.\n"
  "    DECLARE v_error_msg VARCHAR(128);\n"
  "    DECLARE v_old_group_concat_max_len INT UNSIGNED DEFAULT 0;\n"
  "    -- Don't instrument this thread\n"
  "    SELECT INSTRUMENTED INTO v_this_thread_enabled FROM performance_schema.threads WHERE PROCESSLIST_ID = CONNECTION_"
  "ID();\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_disable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    -- Temporary table are used - disable sql_log_bin if necessary to prevent them replicating\n"
  "    SET @log_bin := @@sql_log_bin;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = 0;\n"
  "    END IF;\n"
  "    -- Set configuration options\n"
  "    IF (@sys.statement_performance_analyzer.limit IS NULL) THEN\n"
  "        SET @sys.statement_performance_analyzer.limit = sys.sys_get_config('statement_performance_analyzer.limit', '1"
  "00');\n"
  "    END IF;\n"
  "    IF (@sys.debug IS NULL) THEN\n"
  "        SET @sys.debug                                = sys.sys_get_config('debug'                               , 'O"
  "FF');\n"
  "    END IF;\n"
  "    -- If in_table is set, break in_table into a db and table component and check whether it exists\n"
  "    -- in_table = NOW() is considered like it's not set.\n"
  "    IF (in_table = 'NOW()') THEN\n"
  "        SET v_force_new_snapshot = TRUE,\n"
  "            in_table             = NULL;\n"
  "    ELSEIF (in_table IS NOT NULL) THEN\n"
  "        IF (NOT INSTR(in_table, '.')) THEN\n"
  "            -- No . in the table name - use current database\n"
  "            -- DATABASE() will be the database of the procedure\n"
  "            SET v_table_db   = DATABASE(),\n"
  "                v_table_name = in_table;\n"
  "        ELSE\n"
  "            SET v_table_db   = SUBSTRING_INDEX(in_table, '.', 1);\n"
  "            SET v_table_name = SUBSTRING(in_table, CHAR_LENGTH(v_table_db)+2);\n"
  "        END IF;\n"
  "        SET v_quoted_table = CONCAT('`', v_table_db, '`.`', v_table_name, '`');\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('in_table is: db = ''', v_table_db, ''', table = ''', v_table_name, '''') AS 'Debug';\n"
  "        END IF;\n"
  "        IF (v_table_db = DATABASE() AND (v_table_name = 'tmp_digests' OR v_table_name = 'tmp_digests_delta')) THEN\n"
  "            SET v_error_msg = CONCAT('Invalid value for in_table: ', v_quoted_table, ' is reserved table name.');\n"
  "            SIGNAL SQLSTATE '45000'\n"
  "               SET MESSAGE_TEXT = v_error_msg;\n"
  "        END IF;\n"
  "        CALL sys.table_exists(v_table_db, v_table_name, v_table_exists);\n"
  "        IF (@sys.debug = 'ON') THEN\n"
  "            SELECT CONCAT('v_table_exists = ', v_table_exists) AS 'Debug';\n"
  "        END IF;\n"
  "        IF (v_table_exists = 'BASE TABLE') THEN\n"
  "            SET v_old_group_concat_max_len = @@session.group_concat_max_len;\n"
  "            SET @@session.group_concat_max_len = 2048;\n"
  "            -- Verify that the table has the correct table definition\n"
  "            -- This can only be done for base tables as temporary aren't in information_schema.COLUMNS.\n"
  "            -- This also minimises the risk of using a production table.\n"
  "            SET v_checksum_ref = (\n"
  "                 SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum\n"
  "                   FROM information_schema.COLUMNS\n"
  "                  WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'events_statements_summary_by_digest'\n"
  "                ),\n"
  "                v_checksum_table = (\n"
  "                 SELECT GROUP_CONCAT(CONCAT(COLUMN_NAME, COLUMN_TYPE) ORDER BY ORDINAL_POSITION) AS Checksum\n"
  "                   FROM information_schema.COLUMNS\n"
  "                  WHERE TABLE_SCHEMA = v_table_db AND TABLE_NAME = v_table_name\n"
  "                );\n"
  "            SET @@session.group_concat_max_len = v_old_group_concat_max_len;\n"
  "            IF (v_checksum_ref <> v_checksum_table) THEN\n"
  "                -- The table does not have the correct definition, so abandon\n"
  "                SET v_error_msg = CONCAT('The table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 93, CONCAT('...', SUBSTRING(v_quoted_table,"
  " -90)), v_quoted_table),\n"
  "                                         ' has the wrong definition.');\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        END IF;\n"
  "    END IF;\n"
  "    IF (in_views IS NULL OR in_views = '') THEN\n"
  "        -- Set to default\n"
  "        SET in_views = 'with_runtimes_in_95th_percentile,analysis,with_errors_or_warnings,with_full_table_scans,with_"
  "sorting,with_temp_tables';\n"
  "    END IF;\n"
  "    -- Validate settings\n"
  "    CALL sys.table_exists(DATABASE(), 'tmp_digests', v_tmp_digests_table_exists);\n"
  "    IF (@sys.debug = 'ON') THEN\n"
  "        SELECT CONCAT('v_tmp_digests_table_exists = ', v_tmp_digests_table_exists) AS 'Debug';\n"
  "    END IF;\n"
  "    CASE\n"
  "        WHEN in_action IN ('snapshot', 'overall') THEN\n"
  "            -- in_table must be NULL, NOW(), or an existing table\n"
  "            IF (in_table IS NOT NULL) THEN\n"
  "                IF (NOT v_table_exists IN ('TEMPORARY', 'BASE TABLE')) THEN\n"
  "                    SET v_error_msg = CONCAT('The ', in_action, ' action requires in_table to be NULL, NOW() or speci"
  "fy an existing table.',\n"
  "                                             ' The table ',\n"
  "                                             IF(CHAR_LENGTH(v_quoted_table) > 16, CONCAT('...', SUBSTRING(v_quoted_ta"
  "ble, -13)), v_quoted_table),\n"
  "                                             ' does not exist.');\n"
  "                    SIGNAL SQLSTATE '45000'\n"
  "                       SET MESSAGE_TEXT = v_error_msg;\n"
  "                END IF;\n"
  "            END IF;\n"
  "        WHEN in_action IN ('delta', 'save') THEN\n"
  "            -- in_table must be an existing table\n"
  "            IF (v_table_exists NOT IN ('TEMPORARY', 'BASE TABLE')) THEN\n"
  "                SET v_error_msg = CONCAT('The ', in_action, ' action requires in_table to be an existing table.',\n"
  "                                         IF(in_table IS NOT NULL, CONCAT(' The table ',\n"
  "                                             IF(CHAR_LENGTH(v_quoted_table) > 39, CONCAT('...', SUBSTRING(v_quoted_ta"
  "ble, -36)), v_quoted_table),\n"
  "                                             ' does not exist.'), ''));\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "            IF (in_action = 'delta' AND v_tmp_digests_table_exists <> 'TEMPORARY') THEN\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = 'An existing snapshot generated with the statement_performance_analyzer() must "
  "exist.';\n"
  "            END IF;\n"
  "        WHEN in_action = 'create_tmp' THEN\n"
  "            -- in_table must not exists as a temporary table\n"
  "            IF (v_table_exists = 'TEMPORARY') THEN\n"
  "                SET v_error_msg = CONCAT('Cannot create the table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 72, CONCAT('...', SUBSTRING(v_quoted_table,"
  " -69)), v_quoted_table),\n"
  "                                         ' as it already exists.');\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        WHEN in_action = 'create_table' THEN\n"
  "            -- in_table must not exists at all\n"
  "            IF (v_table_exists <> '') THEN\n"
  "                SET v_error_msg = CONCAT('Cannot create the table ',\n"
  "                                         IF(CHAR_LENGTH(v_quoted_table) > 52, CONCAT('...', SUBSTRING(v_quoted_table,"
  " -49)), v_quoted_table),\n"
  "                                         ' as it already exists',\n"
  "                                         IF(v_table_exists = 'TEMPORARY', ' as a temporary table.', '.'));\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = v_error_msg;\n"
  "            END IF;\n"
  "        WHEN in_action = 'cleanup' THEN\n"
  "            -- doesn't use any of the arguments\n"
  "            DO (SELECT 1);\n"
  "        ELSE\n"
  "            SIGNAL SQLSTATE '45000'\n"
  "               SET MESSAGE_TEXT = 'Unknown action. Supported actions are: cleanup, create_table, create_tmp, delta, o"
  "verall, save, snapshot';\n"
  "    END CASE;\n"
  "    SET v_digest_table_template = 'CREATE %{TEMPORARY}TABLE %{TABLE_NAME} (\n"
  "  `SCHEMA_NAME` varchar(64) DEFAULT NULL,\n"
  "  `DIGEST` varchar(64) DEFAULT NULL,\n"
  "  `DIGEST_TEXT` longtext,\n"
  "  `COUNT_STAR` bigint unsigned NOT NULL,\n"
  "  `SUM_TIMER_WAIT` bigint unsigned NOT NULL,\n"
  "  `MIN_TIMER_WAIT` bigint unsigned NOT NULL,\n"
  "  `AVG_TIMER_WAIT` bigint unsigned NOT NULL,\n"
  "  `MAX_TIMER_WAIT` bigint unsigned NOT NULL,\n"
  "  `SUM_LOCK_TIME` bigint unsigned NOT NULL,\n"
  "  `SUM_ERRORS` bigint unsigned NOT NULL,\n"
  "  `SUM_WARNINGS` bigint unsigned NOT NULL,\n"
  "  `SUM_ROWS_AFFECTED` bigint unsigned NOT NULL,\n"
  "  `SUM_ROWS_SENT` bigint unsigned NOT NULL,\n"
  "  `SUM_ROWS_EXAMINED` bigint unsigned NOT NULL,\n"
  "  `SUM_CREATED_TMP_DISK_TABLES` bigint unsigned NOT NULL,\n"
  "  `SUM_CREATED_TMP_TABLES` bigint unsigned NOT NULL,\n"
  "  `SUM_SELECT_FULL_JOIN` bigint unsigned NOT NULL,\n"
  "  `SUM_SELECT_FULL_RANGE_JOIN` bigint unsigned NOT NULL,\n"
  "  `SUM_SELECT_RANGE` bigint unsigned NOT NULL,\n"
  "  `SUM_SELECT_RANGE_CHECK` bigint unsigned NOT NULL,\n"
  "  `SUM_SELECT_SCAN` bigint unsigned NOT NULL,\n"
  "  `SUM_SORT_MERGE_PASSES` bigint unsigned NOT NULL,\n"
  "  `SUM_SORT_RANGE` bigint unsigned NOT NULL,\n"
  "  `SUM_SORT_ROWS` bigint unsigned NOT NULL,\n"
  "  `SUM_SORT_SCAN` bigint unsigned NOT NULL,\n"
  "  `SUM_NO_INDEX_USED` bigint unsigned NOT NULL,\n"
  "  `SUM_NO_GOOD_INDEX_USED` bigint unsigned NOT NULL,\n"
  "  `FIRST_SEEN` timestamp(6) NULL DEFAULT NULL,\n"
  "  `LAST_SEEN` timestamp(6) NULL DEFAULT NULL,\n"
  "  `QUANTILE_95` bigint unsigned NOT NULL,\n"
  "  `QUANTILE_99` bigint unsigned NOT NULL,\n"
  "  `QUANTILE_999` bigint unsigned NOT NULL,\n"
  "  `QUERY_SAMPLE_TEXT` longtext,\n"
  "  `QUERY_SAMPLE_SEEN` timestamp(6) NULL DEFAULT NULL,\n"
  "  `QUERY_SAMPLE_TIMER_WAIT` bigint unsigned NOT NULL,\n"
  "  INDEX (SCHEMA_NAME, DIGEST)\n"
  ") DEFAULT CHARSET=utf8mb4';\n"
  "    -- Do the action\n"
  "    -- The actions snapshot, ... requires a fresh snapshot - create it now\n"
  "    IF (v_force_new_snapshot\n"
  "           OR in_action = 'snapshot'\n"
  "           OR (in_action = 'overall' AND in_table IS NULL)\n"
  "           OR (in_action = 'save' AND v_tmp_digests_table_exists <> 'TEMPORARY')\n"
  "       ) THEN\n"
  "        IF (v_tmp_digests_table_exists = 'TEMPORARY') THEN\n"
  "            IF (@sys.debug = 'ON') THEN\n"
  "                SELECT 'DROP TEMPORARY TABLE IF EXISTS tmp_digests' AS 'Debug';\n"
  "            END IF;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digests;\n"
  "        END IF;\n"
  "        CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', 'TEMPORARY '), '%{TAB"
  "LE_NAME}', 'tmp_digests'));\n"
  "        SET v_sql = CONCAT('INSERT INTO tmp_digests SELECT * FROM ',\n"
  "                           IF(in_table IS NULL OR in_action = 'save', 'performance_schema.events_statements_summary_b"
  "y_digest', v_quoted_table));\n"
  "        CALL sys.execute_prepared_stmt(v_sql);\n"
  "    END IF;\n"
  "    -- Go through the remaining actions\n"
  "    IF (in_action IN ('create_table', 'create_tmp')) THEN\n"
  "        IF (in_action = 'create_table') THEN\n"
  "            CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', ''), '%{TABLE_NAM"
  "E}', v_quoted_table));\n"
  "        ELSE\n"
  "            CALL sys.execute_prepared_stmt(REPLACE(REPLACE(v_digest_table_template, '%{TEMPORARY}', 'TEMPORARY '), '%"
  "{TABLE_NAME}', v_quoted_table));\n"
  "        END IF;\n"
  "    ELSEIF (in_action = 'save') THEN\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('DELETE FROM ', v_quoted_table));\n"
  "        CALL sys.execute_prepared_stmt(CONCAT('INSERT INTO ', v_quoted_table, ' SELECT * FROM tmp_digests'));\n"
  "    ELSEIF (in_action = 'cleanup') THEN\n"
  "        DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests;\n"
  "        DROP TEMPORARY TABLE IF EXISTS sys.tmp_digests_delta;\n"
  "    ELSEIF (in_action IN ('overall', 'delta')) THEN\n"
  "        -- These are almost the same - for delta calculate the delta in tmp_digests_delta and use that instead of tmp"
  "_digests.\n"
  "        -- And overall allows overriding the table to use.\n"
  "        IF (in_action = 'overall') THEN\n"
  "            IF (in_table IS NULL) THEN\n"
  "                SET v_digests_table = 'tmp_digests';\n"
  "            ELSE\n"
  "                SET v_digests_table = v_quoted_table;\n"
  "            END IF;\n"
  "        ELSE\n"
  "            SET v_digests_table = 'tmp_digests_delta';\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digests_delta;\n"
  "            CREATE TEMPORARY TABLE tmp_digests_delta LIKE tmp_digests;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digests_delta\n"
  "SELECT `d_end`.`SCHEMA_NAME`,\n"
  "       `d_end`.`DIGEST`,\n"
  "       `d_end`.`DIGEST_TEXT`,\n"
  "       `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) AS ''COUNT_STAR'',\n"
  "       `d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0) AS ''SUM_TIMER_WAIT'',\n"
  "       `d_end`.`MIN_TIMER_WAIT` AS ''MIN_TIMER_WAIT'',\n"
  "       IFNULL((`d_end`.`SUM_TIMER_WAIT`-IFNULL(`d_start`.`SUM_TIMER_WAIT`, 0))/NULLIF(`d_end`.`COUNT_STAR`-IFNULL(`d_"
  "start`.`COUNT_STAR`, 0), 0), 0) AS ''AVG_TIMER_WAIT'',\n"
  "       `d_end`.`MAX_TIMER_WAIT` AS ''MAX_TIMER_WAIT'',\n"
  "       `d_end`.`SUM_LOCK_TIME`-IFNULL(`d_start`.`SUM_LOCK_TIME`, 0) AS ''SUM_LOCK_TIME'',\n"
  "       `d_end`.`SUM_ERRORS`-IFNULL(`d_start`.`SUM_ERRORS`, 0) AS ''SUM_ERRORS'',\n"
  "       `d_end`.`SUM_WARNINGS`-IFNULL(`d_start`.`SUM_WARNINGS`, 0) AS ''SUM_WARNINGS'',\n"
  "       `d_end`.`SUM_ROWS_AFFECTED`-IFNULL(`d_start`.`SUM_ROWS_AFFECTED`, 0) AS ''SUM_ROWS_AFFECTED'',\n"
  "       `d_end`.`SUM_ROWS_SENT`-IFNULL(`d_start`.`SUM_ROWS_SENT`, 0) AS ''SUM_ROWS_SENT'',\n"
  "       `d_end`.`SUM_ROWS_EXAMINED`-IFNULL(`d_start`.`SUM_ROWS_EXAMINED`, 0) AS ''SUM_ROWS_EXAMINED'',\n"
  "       `d_end`.`SUM_CREATED_TMP_DISK_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_DISK_TABLES`, 0) AS ''SUM_CREATED_TMP_"
  "DISK_TABLES'',\n"
  "       `d_end`.`SUM_CREATED_TMP_TABLES`-IFNULL(`d_start`.`SUM_CREATED_TMP_TABLES`, 0) AS ''SUM_CREATED_TMP_TABLES'',\n"
  "       `d_end`.`SUM_SELECT_FULL_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_JOIN`, 0) AS ''SUM_SELECT_FULL_JOIN'',\n"
  "       `d_end`.`SUM_SELECT_FULL_RANGE_JOIN`-IFNULL(`d_start`.`SUM_SELECT_FULL_RANGE_JOIN`, 0) AS ''SUM_SELECT_FULL_RA"
  "NGE_JOIN'',\n"
  "       `d_end`.`SUM_SELECT_RANGE`-IFNULL(`d_start`.`SUM_SELECT_RANGE`, 0) AS ''SUM_SELECT_RANGE'',\n"
  "       `d_end`.`SUM_SELECT_RANGE_CHECK`-IFNULL(`d_start`.`SUM_SELECT_RANGE_CHECK`, 0) AS ''SUM_SELECT_RANGE_CHECK'',\n"
  "       `d_end`.`SUM_SELECT_SCAN`-IFNULL(`d_start`.`SUM_SELECT_SCAN`, 0) AS ''SUM_SELECT_SCAN'',\n"
  "       `d_end`.`SUM_SORT_MERGE_PASSES`-IFNULL(`d_start`.`SUM_SORT_MERGE_PASSES`, 0) AS ''SUM_SORT_MERGE_PASSES'',\n"
  "       `d_end`.`SUM_SORT_RANGE`-IFNULL(`d_start`.`SUM_SORT_RANGE`, 0) AS ''SUM_SORT_RANGE'',\n"
  "       `d_end`.`SUM_SORT_ROWS`-IFNULL(`d_start`.`SUM_SORT_ROWS`, 0) AS ''SUM_SORT_ROWS'',\n"
  "       `d_end`.`SUM_SORT_SCAN`-IFNULL(`d_start`.`SUM_SORT_SCAN`, 0) AS ''SUM_SORT_SCAN'',\n"
  "       `d_end`.`SUM_NO_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_INDEX_USED`, 0) AS ''SUM_NO_INDEX_USED'',\n"
  "       `d_end`.`SUM_NO_GOOD_INDEX_USED`-IFNULL(`d_start`.`SUM_NO_GOOD_INDEX_USED`, 0) AS ''SUM_NO_GOOD_INDEX_USED'',\n"
  "       `d_end`.`FIRST_SEEN`,\n"
  "       `d_end`.`LAST_SEEN`,\n"
  "       `d_end`.`QUANTILE_95`,\n"
  "       `d_end`.`QUANTILE_99`,\n"
  "       `d_end`.`QUANTILE_999`,\n"
  "       `d_end`.`QUERY_SAMPLE_TEXT`,\n"
  "       `d_end`.`QUERY_SAMPLE_SEEN`,\n"
  "       `d_end`.`QUERY_SAMPLE_TIMER_WAIT`\n"
  "  FROM tmp_digests d_end\n"
  "       LEFT OUTER JOIN ', v_quoted_table, ' d_start ON `d_start`.`DIGEST` = `d_end`.`DIGEST`\n"
  "                                                    AND (`d_start`.`SCHEMA_NAME` = `d_end`.`SCHEMA_NAME`\n"
  "                                                          OR (`d_start`.`SCHEMA_NAME` IS NULL AND `d_end`.`SCHEMA_NAM"
  "E` IS NULL)\n"
  "                                                        )\n"
  " WHERE `d_end`.`COUNT_STAR`-IFNULL(`d_start`.`COUNT_STAR`, 0) > 0');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_runtimes_in_95th_percentile', in_views)) THEN\n"
  "            SELECT 'Queries with Runtime in 95th Percentile' AS 'Next Output';\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution1;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_avg_latency_distribution2;\n"
  "            DROP TEMPORARY TABLE IF EXISTS tmp_digest_95th_percentile_by_avg_us;\n"
  "            CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution1 (\n"
  "              cnt bigint unsigned NOT NULL,\n"
  "              avg_us decimal(21,0) NOT NULL,\n"
  "              PRIMARY KEY (avg_us)\n"
  "            ) ENGINE=InnoDB;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digest_avg_latency_distribution1\n"
  "SELECT COUNT(*) cnt,\n"
  "       ROUND(avg_timer_wait/1000000) AS avg_us\n"
  "  FROM ', v_digests_table, '\n"
  " GROUP BY avg_us');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            CREATE TEMPORARY TABLE tmp_digest_avg_latency_distribution2 LIKE tmp_digest_avg_latency_distribution1;\n"
  "            INSERT INTO tmp_digest_avg_latency_distribution2 SELECT * FROM tmp_digest_avg_latency_distribution1;\n"
  "            CREATE TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us (\n"
  "              avg_us decimal(21,0) NOT NULL,\n"
  "              percentile decimal(46,4) NOT NULL,\n"
  "              PRIMARY KEY (avg_us)\n"
  "            ) ENGINE=InnoDB;\n"
  "            SET v_sql = CONCAT('INSERT INTO tmp_digest_95th_percentile_by_avg_us\n"
  "SELECT s2.avg_us avg_us,\n"
  "       IFNULL(SUM(s1.cnt)/NULLIF((SELECT COUNT(*) FROM ', v_digests_table, '), 0), 0) percentile\n"
  "  FROM tmp_digest_avg_latency_distribution1 AS s1\n"
  "       JOIN tmp_digest_avg_latency_distribution2 AS s2 ON s1.avg_us <= s2.avg_us\n"
  " GROUP BY s2.avg_us\n"
  "HAVING percentile > 0.95\n"
  " ORDER BY percentile\n"
  " LIMIT 1');\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    REPLACE(\n"
  "                        (SELECT VIEW_DEFINITION\n"
  "                           FROM information_schema.VIEWS\n"
  "                          WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_runtimes_in_95th_percenti"
  "le'\n"
  "                        ),\n"
  "                        '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                        v_digests_table\n"
  "                    ),\n"
  "                    'sys.x$ps_digest_95th_percentile_by_avg_us',\n"
  "                    '`sys`.`x$ps_digest_95th_percentile_by_avg_us`'\n"
  "              );\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "            DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution1;\n"
  "            DROP TEMPORARY TABLE tmp_digest_avg_latency_distribution2;\n"
  "            DROP TEMPORARY TABLE tmp_digest_95th_percentile_by_avg_us;\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('analysis', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries Ordered by Total Latency') AS "
  "'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statement_analysis'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_errors_or_warnings', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Errors') AS 'Next Output'"
  ";\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_errors_or_warnings'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_full_table_scans', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Full Table Scan') AS 'Nex"
  "t Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_full_table_scans'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_sorting', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Sorting') AS 'Next Output"
  "';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_sorting'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('with_temp_tables', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries with Internal Temporary Tables"
  "') AS 'Next Output';\n"
  "            SET v_sql =\n"
  "                REPLACE(\n"
  "                    (SELECT VIEW_DEFINITION\n"
  "                       FROM information_schema.VIEWS\n"
  "                      WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'statements_with_temp_tables'\n"
  "                    ),\n"
  "                    '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                    v_digests_table\n"
  "                );\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "        IF (FIND_IN_SET('custom', in_views)) THEN\n"
  "            SELECT CONCAT('Top ', @sys.statement_performance_analyzer.limit, ' Queries Using Custom View') AS 'Next O"
  "utput';\n"
  "            IF (@sys.statement_performance_analyzer.view IS NULL) THEN\n"
  "                SET @sys.statement_performance_analyzer.view = sys.sys_get_config('statement_performance_analyzer.vie"
  "w', NULL);\n"
  "            END IF;\n"
  "            IF (@sys.statement_performance_analyzer.view IS NULL) THEN\n"
  "                SIGNAL SQLSTATE '45000'\n"
  "                   SET MESSAGE_TEXT = 'The @sys.statement_performance_analyzer.view user variable must be set with th"
  "e view or query to use.';\n"
  "            END IF;\n"
  "            IF (NOT INSTR(@sys.statement_performance_analyzer.view, ' ')) THEN\n"
  "                -- No spaces, so can't be a query\n"
  "                IF (NOT INSTR(@sys.statement_performance_analyzer.view, '.')) THEN\n"
  "                    -- No . in the table name - use current database\n"
  "                    -- DATABASE() will be the database of the procedure\n"
  "                    SET v_custom_db   = DATABASE(),\n"
  "                        v_custom_name = @sys.statement_performance_analyzer.view;\n"
  "                ELSE\n"
  "                    SET v_custom_db   = SUBSTRING_INDEX(@sys.statement_performance_analyzer.view, '.', 1);\n"
  "                    SET v_custom_name = SUBSTRING(@sys.statement_performance_analyzer.view, CHAR_LENGTH(v_custom_db)+"
  "2);\n"
  "                END IF;\n"
  "                CALL sys.table_exists(v_custom_db, v_custom_name, v_custom_view_exists);\n"
  "                IF (v_custom_view_exists <> 'VIEW') THEN\n"
  "                    SIGNAL SQLSTATE '45000'\n"
  "                       SET MESSAGE_TEXT = 'The @sys.statement_performance_analyzer.view user variable is set but spec"
  "ified neither an existing view nor a query.';\n"
  "                END IF;\n"
  "                SET v_sql =\n"
  "                    REPLACE(\n"
  "                        (SELECT VIEW_DEFINITION\n"
  "                           FROM information_schema.VIEWS\n"
  "                          WHERE TABLE_SCHEMA = v_custom_db AND TABLE_NAME = v_custom_name\n"
  "                        ),\n"
  "                        '`performance_schema`.`events_statements_summary_by_digest`',\n"
  "                        v_digests_table\n"
  "                    );\n"
  "            ELSE\n"
  "                SET v_sql = REPLACE(@sys.statement_performance_analyzer.view, '`performance_schema`.`events_statement"
  "s_summary_by_digest`', v_digests_table);\n"
  "            END IF;\n"
  "            IF (@sys.statement_performance_analyzer.limit > 0) THEN\n"
  "                SET v_sql = CONCAT(v_sql, ' LIMIT ', @sys.statement_performance_analyzer.limit);\n"
  "            END IF;\n"
  "            CALL sys.execute_prepared_stmt(v_sql);\n"
  "        END IF;\n"
  "    END IF;\n"
  "    -- Restore INSTRUMENTED for this thread\n"
  "    IF (v_this_thread_enabled = 'YES') THEN\n"
  "        CALL sys.ps_setup_enable_thread(CONNECTION_ID());\n"
  "    END IF;\n"
  "    IF (@log_bin = 1) THEN\n"
  "        SET sql_log_bin = @log_bin;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2015, 2021, Oracle and/or its affiliates.\n"
  "-- \n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "-- \n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "-- \n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA\n"
  "DROP PROCEDURE IF EXISTS table_exists;\n",
"CREATE DEFINER='mysql.sys'@'localhost' PROCEDURE table_exists (\n"
  "        IN in_db VARCHAR(64), IN in_table VARCHAR(64),\n"
  "        OUT out_exists ENUM('', 'BASE TABLE', 'VIEW', 'TEMPORARY')\n"
  "    )\n"
  "    COMMENT '\n"
  "Description\n"
  "-----------\n"
  "\n"
  "Tests whether the table specified in in_db and in_table exists either as a regular\n"
  "table, or as a temporary table. The returned value corresponds to the table that\n"
  "will be used, so if there''s both a temporary and a permanent table with the given\n"
  "name, then ''TEMPORARY'' will be returned.\n"
  "\n"
  "Parameters\n"
  "-----------\n"
  "\n"
  "in_db (VARCHAR(64)):\n"
  "  The database name to check for the existance of the table in.\n"
  "\n"
  "in_table (VARCHAR(64)):\n"
  "  The name of the table to check the existance of.\n"
  "\n"
  "out_exists ENUM('''', ''BASE TABLE'', ''VIEW'', ''TEMPORARY''):\n"
  "  The return value: whether the table exists. The value is one of:\n"
  "    * ''''           - the table does not exist neither as a base table, view, nor temporary table.\n"
  "    * ''BASE TABLE'' - the table name exists as a permanent base table table.\n"
  "    * ''VIEW''       - the table name exists as a view.\n"
  "    * ''TEMPORARY''  - the table name exists as a temporary table.\n"
  "\n"
  "Example\n"
  "--------\n"
  "\n"
  "mysql> CREATE DATABASE db1;\n"
  "Query OK, 1 row affected (0.07 sec)\n"
  "\n"
  "mysql> use db1;\n"
  "Database changed\n"
  "mysql> CREATE TABLE t1 (id INT PRIMARY KEY);\n"
  "Query OK, 0 rows affected (0.08 sec)\n"
  "\n"
  "mysql> CREATE TABLE t2 (id INT PRIMARY KEY);\n"
  "Query OK, 0 rows affected (0.08 sec)\n"
  "\n"
  "mysql> CREATE view v_t1 AS SELECT * FROM t1;\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "mysql> CREATE TEMPORARY TABLE t1 (id INT PRIMARY KEY);\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "mysql> CALL sys.table_exists(''db1'', ''t1'', @exists); SELECT @exists;\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "+------------+\n"
  "| @exists    |\n"
  "+------------+\n"
  "| TEMPORARY  |\n"
  "+------------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> CALL sys.table_exists(''db1'', ''t2'', @exists); SELECT @exists;\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "+------------+\n"
  "| @exists    |\n"
  "+------------+\n"
  "| BASE TABLE |\n"
  "+------------+\n"
  "1 row in set (0.01 sec)\n"
  "\n"
  "mysql> CALL sys.table_exists(''db1'', ''v_t1'', @exists); SELECT @exists;\n"
  "Query OK, 0 rows affected (0.00 sec)\n"
  "\n"
  "+---------+\n"
  "| @exists |\n"
  "+---------+\n"
  "| VIEW    |\n"
  "+---------+\n"
  "1 row in set (0.00 sec)\n"
  "\n"
  "mysql> CALL sys.table_exists(''db1'', ''t3'', @exists); SELECT @exists;\n"
  "Query OK, 0 rows affected (0.01 sec)\n"
  "\n"
  "+---------+\n"
  "| @exists |\n"
  "+---------+\n"
  "|         |\n"
  "+---------+\n"
  "1 row in set (0.00 sec)\n"
  "'\n"
  "    SQL SECURITY INVOKER\n"
  "    NOT DETERMINISTIC\n"
  "    CONTAINS SQL\n"
  "BEGIN\n"
  "    DECLARE v_error BOOLEAN DEFAULT FALSE;\n"
  "    DECLARE CONTINUE HANDLER FOR 1050 SET v_error = TRUE;\n"
  "    DECLARE CONTINUE HANDLER FOR 1146 SET v_error = TRUE;\n"
  "    SET out_exists = '';\n"
  "    -- Verify whether the table name exists as a normal table\n"
  "    IF (EXISTS(SELECT 1 FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_NAME = in_table)) THEN\n"
  "        -- Unfortunately the only way to determine whether there is also a temporary table is to try to create\n"
  "        -- a temporary table with the same name. If it succeeds the table didn't exist as a temporary table.\n"
  "        SET @sys.tmp.table_exists.SQL = CONCAT('CREATE TEMPORARY TABLE `', in_db, '`.`', in_table, '` (id INT PRIMARY"
  " KEY)');\n"
  "        PREPARE stmt_create_table FROM @sys.tmp.table_exists.SQL;\n"
  "        EXECUTE stmt_create_table;\n"
  "        DEALLOCATE PREPARE stmt_create_table;\n"
  "        IF (v_error) THEN\n"
  "            SET out_exists = 'TEMPORARY';\n"
  "        ELSE\n"
  "            -- The temporary table was created, i.e. it didn't exist. Remove it again so we don't leave garbage aroun"
  "d.\n"
  "            SET @sys.tmp.table_exists.SQL = CONCAT('DROP TEMPORARY TABLE `', in_db, '`.`', in_table, '`');\n"
  "            PREPARE stmt_drop_table FROM @sys.tmp.table_exists.SQL;\n"
  "            EXECUTE stmt_drop_table;\n"
  "            DEALLOCATE PREPARE stmt_drop_table;\n"
  "            SET out_exists = (SELECT TABLE_TYPE FROM information_schema.TABLES WHERE TABLE_SCHEMA = in_db AND TABLE_N"
  "AME = in_table);\n"
  "        END IF;\n"
  "    ELSE\n"
  "        -- Check whether a temporary table exists with the same name.\n"
  "        -- If it does it's possible to SELECT from the table without causing an error.\n"
  "        -- If it does not exist even a PREPARE using the table will fail.\n"
  "        SET @sys.tmp.table_exists.SQL = CONCAT('SELECT COUNT(*) FROM `', in_db, '`.`', in_table, '`');\n"
  "        PREPARE stmt_select FROM @sys.tmp.table_exists.SQL;\n"
  "        IF (NOT v_error) THEN\n"
  "            DEALLOCATE PREPARE stmt_select;\n"
  "            SET out_exists = 'TEMPORARY';\n"
  "        END IF;\n"
  "    END IF;\n"
  "END\n",
"-- Copyright (c) 2014, 2021, Oracle and/or its affiliates.\n"
  "--\n"
  "-- This program is free software; you can redistribute it and/or modify\n"
  "-- it under the terms of the GNU General Public License as published by\n"
  "-- the Free Software Foundation; version 2 of the License.\n"
  "--\n"
  "-- This program is distributed in the hope that it will be useful,\n"
  "-- but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
  "-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
  "-- GNU General Public License for more details.\n"
  "--\n"
  "-- You should have received a copy of the GNU General Public License\n"
  "-- along with this program; if not, write to the Free Software\n"
  "-- Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA\n"
  "SET @@sql_log_bin = @sql_log_bin;\n",
NULL
};
