/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.clusterj.tie.VariableByteBufferPoolImpl;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import java.nio.ByteBuffer;

class BlobImpl
implements Blob {
    static final I18NHelper local = I18NHelper.getInstance(BlobImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(BlobImpl.class);
    protected NdbBlob ndbBlob;
    protected byte[] data;
    protected NdbRecordOperationImpl operation;
    protected VariableByteBufferPoolImpl byteBufferPool;
    protected ByteBuffer byteBufferForSetValue = null;
    protected int byteBufferForSetValueSize = 0;

    public BlobImpl(VariableByteBufferPoolImpl variableByteBufferPoolImpl) {
        this.byteBufferPool = variableByteBufferPoolImpl;
    }

    public BlobImpl(NdbBlob ndbBlob, VariableByteBufferPoolImpl variableByteBufferPoolImpl) {
        this.ndbBlob = ndbBlob;
        this.byteBufferPool = variableByteBufferPoolImpl;
    }

    public void release() {
        if (logger.isDetailEnabled()) {
            logger.detail("BlobImpl.release");
        }
        this.data = null;
        this.operation = null;
        if (this.byteBufferForSetValue != null) {
            this.byteBufferPool.returnBuffer(this.byteBufferForSetValueSize, this.byteBufferForSetValue);
        }
    }

    @Override
    public Long getLength() {
        long[] lArray = new long[1];
        int n = this.ndbBlob.getLength(lArray);
        BlobImpl.handleError(n, this.ndbBlob);
        return lArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readData(byte[] byArray, int n) {
        if (n == 0) {
            return;
        }
        int[] nArray = new int[]{n + 1};
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = this.byteBufferPool.borrowBuffer(n);
            int n2 = this.ndbBlob.readData(byteBuffer, nArray);
            BlobImpl.handleError(n2, this.ndbBlob);
            if (nArray[0] != n) {
                throw new ClusterJFatalInternalException(local.message("ERR_Blob_Read_Data", (Object)n, (Object)nArray[0]));
            }
            byteBuffer.get(byArray);
        }
        finally {
            if (byteBuffer != null) {
                this.byteBufferPool.returnBuffer(n, byteBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(byte[] byArray) {
        if (byArray == null) {
            this.setNull();
            return;
        }
        if (byArray.length == 0) {
            return;
        }
        ByteBuffer byteBuffer = null;
        int n = byArray.length;
        try {
            if (n > 0) {
                byteBuffer = this.byteBufferPool.borrowBuffer(n);
                byteBuffer.put(byArray);
                byteBuffer.flip();
            }
            int n2 = this.ndbBlob.writeData(byteBuffer, n);
            BlobImpl.handleError(n2, this.ndbBlob);
        }
        finally {
            if (byteBuffer != null) {
                this.byteBufferPool.returnBuffer(n, byteBuffer);
            }
        }
    }

    @Override
    public void setValue(byte[] byArray) {
        if (byArray == null) {
            this.setNull();
            return;
        }
        if (byArray.length == 0) {
            return;
        }
        ByteBuffer byteBuffer = null;
        byteBuffer = this.byteBufferPool.borrowBuffer(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        if (this.byteBufferForSetValue != null) {
            this.byteBufferPool.returnBuffer(this.byteBufferForSetValueSize, this.byteBufferForSetValue);
        }
        this.byteBufferForSetValueSize = byArray.length;
        this.byteBufferForSetValue = byteBuffer;
        int n = this.ndbBlob.setValue(byteBuffer, byArray.length);
        BlobImpl.handleError(n, this.ndbBlob);
    }

    @Override
    public void setNull() {
        int n = this.ndbBlob.setNull();
        BlobImpl.handleError(n, this.ndbBlob);
    }

    @Override
    public void close() {
        int n = this.ndbBlob.close(true);
        BlobImpl.handleError(n, this.ndbBlob);
    }

    protected static void handleError(int n, NdbBlob ndbBlob) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, ndbBlob.getNdbError());
    }
}

