/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionServiceImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.FixedByteBufferPoolImpl;
import com.mysql.ndbjtie.mysql.CharsetMap;
import com.mysql.ndbjtie.mysql.Utils;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbRecAttr;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Utility {
    static final I18NHelper local;
    static final Logger logger;
    static Charset charset;
    static final long ooooooooooooooff = 255L;
    static final long ooooooooooooffoo = 65280L;
    static final long ooooooooooffoooo = 0xFF0000L;
    static final long ooooooooffoooooo = 0xFF000000L;
    static final long ooooooffoooooooo = 0xFF00000000L;
    static final long ooooffoooooooooo = 0xFF0000000000L;
    static final long ooffoooooooooooo = 0xFF000000000000L;
    static final long ffoooooooooooooo = -72057594037927936L;
    static final long ooooooooffffffff = 0xFFFFFFFFL;
    static final int ooooooff = 255;
    static final int ooooffff = 65535;
    static final int ooooffoo = 65280;
    static final int ooffoooo = 0xFF0000;
    static final int ooffffff = 0xFFFFFF;
    static final int ffoooooo = -16777216;
    static final char[] SPACE_PAD;
    static final byte[] ZERO_PAD;
    static final byte[] BLANK_PAD;
    static final byte[] EMPTY_BYTE_ARRAY;
    static int MAX_MEDIUMINT_VALUE;
    static int MAX_MEDIUMUNSIGNED_VALUE;
    static int MIN_MEDIUMINT_VALUE;
    static final FixedByteBufferPoolImpl decimalByteBufferPool;
    private static Set<Integer> NonSevereErrorCodes;
    public static final int SET_NOT_NULL_TO_NULL = 4203;
    public static final int INDEX_NOT_FOUND = 4243;
    public static final int ROW_NOT_FOUND = 626;
    public static final int DUPLICATE_PRIMARY_KEY = 630;
    public static final int DUPLICATE_UNIQUE_KEY = 893;
    public static final int FOREIGN_KEY_NO_PARENT = 255;
    public static final int FOREIGN_KEY_REFERENCED_ROW_EXISTS = 256;
    static Class<?> charsetMapClass;
    static CharsetMap charsetMap;
    static int MAXIMUM_MYSQL_COLLATION_NUMBER;
    static int collationLatin1;
    protected static final int collationUTF16;
    private static Map<String, int[]> collationPeersMap;
    private static CharsetConverter charsetConverterMultibyte;
    private static CharsetConverter[] charsetConverters;
    private static final EndianManager endianManager;
    static int[] howManyBytesNeeded;

    static Class<?> loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClusterJUserException(local.message("ERR_Loading_Native_Class", (Object)string), classNotFoundException);
        }
    }

    static CharsetMap createCharsetMap() {
        StringBuilder stringBuilder = new StringBuilder();
        CharsetMap charsetMap = null;
        try {
            return CharsetMap.create();
        }
        catch (Throwable throwable) {
            stringBuilder.append("CharsetMap.create() threw " + throwable.getClass().getName() + ":" + throwable.getMessage());
            try {
                Method method = charsetMapClass.getMethod("create", null);
                charsetMap = (CharsetMap)method.invoke(null, (Object[])null);
                stringBuilder.append("charsetMapCreateMethod.invoke() succeeded:" + charsetMap);
            }
            catch (Throwable throwable2) {
                stringBuilder.append("charsetMapCreateMethod.invoke() threw " + throwable2.getClass().getName() + ":" + throwable2.getMessage());
            }
            throw new ClusterJUserException(stringBuilder.toString());
        }
    }

    public static CharsetMap getCharsetMap() {
        return charsetMap;
    }

    public static boolean isRetriable(ClusterJDatastoreException clusterJDatastoreException) {
        return 1 == clusterJDatastoreException.getStatus();
    }

    protected static String hex(int n) {
        return String.format("0x%08X", n);
    }

    protected static String hex(long l) {
        return String.format("0x%016X", l);
    }

    protected static short swap(short s) {
        return (short)(0xFF & s >>> 8 | 0xFF00 & s << 8);
    }

    protected static int swap(int n) {
        return 0xFF & n >>> 24 | 0xFF00 & n >>> 8 | 0xFF0000 & n << 8 | 0xFF000000 & n << 24;
    }

    protected static long swap(long l) {
        return 0xFFL & l >>> 56 | 0xFF00L & l >>> 40 | 0xFF0000L & l >>> 24 | 0xFF000000L & l >>> 8 | 0xFF00000000L & l << 8 | 0xFF0000000000L & l << 24 | 0xFF000000000000L & l << 40 | 0xFF00000000000000L & l << 56;
    }

    protected static void throwError(Object object, NdbErrorConst ndbErrorConst) {
        Utility.throwError(object, ndbErrorConst, "");
    }

    protected static void throwError(Object object, NdbErrorConst ndbErrorConst, String string) {
        String string2 = ndbErrorConst.message();
        int n = ndbErrorConst.code();
        int n2 = ndbErrorConst.mysql_code();
        int n3 = ndbErrorConst.status();
        int n4 = ndbErrorConst.classification();
        String string3 = local.message("ERR_NdbJTie", object, n, n2, n3, n4, string2, string);
        if (!NonSevereErrorCodes.contains(n)) {
            logger.error(string3);
        }
        throw new ClusterJDatastoreException(string3, n, n2, n3, n4);
    }

    public static ByteBuffer convertValue(Column column, byte[] byArray) {
        int n = column.getColumnSpace();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        Utility.convertValue(byteBuffer, column, byArray);
        return byteBuffer;
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, byte[] byArray) {
        int n = byArray.length;
        int n2 = column.getLength();
        if (n > n2) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), n2, n));
        }
        int n3 = column.getPrefixLength();
        switch (n3) {
            case 0: {
                byteBuffer.put(byArray);
                if (n >= n2) break;
                byteBuffer.put(ZERO_PAD, 0, n2 - n);
                break;
            }
            case 1: {
                byteBuffer.put((byte)n);
                byteBuffer.put(byArray);
                break;
            }
            case 2: {
                byteBuffer.put((byte)(n % 256));
                byteBuffer.put((byte)(n / 256));
                byteBuffer.put(byArray);
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Unknown_Prefix_Length", (Object)n3, (Object)column.getName()));
            }
        }
        byteBuffer.flip();
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, BigDecimal bigDecimal) {
        int n = column.getPrecision();
        int n2 = column.getScale();
        int n3 = Utility.getDecimalColumnSpace(n, n2);
        BigDecimal bigDecimal2 = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        String string = bigDecimal2.toPlainString();
        int n4 = string.length();
        ByteBuffer byteBuffer2 = decimalByteBufferPool.borrowBuffer();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        charset.newEncoder().encode(charBuffer, byteBuffer2, true);
        byteBuffer2.flip();
        int n5 = Utils.decimal_str2bin(byteBuffer2, n4, n, n2, byteBuffer, n3);
        decimalByteBufferPool.returnBuffer(byteBuffer2);
        if (n5 != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", n5, bigDecimal2, column.getName(), n, n2));
        }
    }

    public static ByteBuffer convertValue(Column column, BigDecimal bigDecimal) {
        int n = column.getPrecision();
        int n2 = column.getScale();
        int n3 = Utility.getDecimalColumnSpace(n, n2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        BigDecimal bigDecimal2 = bigDecimal.setScale(n2, RoundingMode.HALF_UP);
        String string = bigDecimal2.toPlainString();
        int n4 = string.length();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        CharBuffer charBuffer = CharBuffer.wrap(string);
        charset.newEncoder().encode(charBuffer, byteBuffer2, true);
        byteBuffer2.flip();
        int n5 = Utils.decimal_str2bin(byteBuffer2, n4, n, n2, byteBuffer, n3);
        byteBuffer2.flip();
        if (n5 != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", n5, bigDecimal2, column.getName(), n, n2));
        }
        return byteBuffer;
    }

    public static ByteBuffer convertValue(ByteBuffer byteBuffer, Column column, BigInteger bigInteger) {
        int n = column.getPrecision();
        int n2 = column.getScale();
        int n3 = Utility.getDecimalColumnSpace(n, n2);
        String string = bigInteger.toString();
        int n4 = string.length();
        ByteBuffer byteBuffer2 = decimalByteBufferPool.borrowBuffer();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        charset.newEncoder().encode(charBuffer, byteBuffer2, true);
        byteBuffer2.flip();
        int n5 = Utils.decimal_str2bin(byteBuffer2, n4, n, n2, byteBuffer, n3);
        decimalByteBufferPool.returnBuffer(byteBuffer2);
        byteBuffer2.flip();
        if (n5 != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", n5, string, column.getName(), n, n2));
        }
        return byteBuffer;
    }

    public static ByteBuffer convertValue(Column column, BigInteger bigInteger) {
        int n = column.getPrecision();
        int n2 = column.getScale();
        int n3 = Utility.getDecimalColumnSpace(n, n2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        String string = bigInteger.toString();
        int n4 = string.length();
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        CharBuffer charBuffer = CharBuffer.wrap(string);
        charset.newEncoder().encode(charBuffer, byteBuffer2, true);
        byteBuffer2.flip();
        int n5 = Utils.decimal_str2bin(byteBuffer2, n4, n, n2, byteBuffer, n3);
        byteBuffer2.flip();
        if (n5 != 0) {
            throw new ClusterJUserException(local.message("ERR_String_To_Binary_Decimal", n5, string, column.getName(), n, n2));
        }
        return byteBuffer;
    }

    public static ByteBuffer convertValue(Column column, double d) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putDouble(d);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, double d) {
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putDouble(d);
        byteBuffer.flip();
    }

    public static ByteBuffer convertValue(Column column, float f) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putFloat(f);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, float f) {
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putFloat(f);
        byteBuffer.flip();
    }

    public static ByteBuffer convertValue(Column column, byte by) {
        return endianManager.convertValue(column, by);
    }

    public static ByteBuffer convertValue(Column column, short s) {
        return endianManager.convertValue(column, s);
    }

    public static ByteBuffer convertValue(Column column, int n) {
        return endianManager.convertValue(column, n);
    }

    public static ByteBuffer convertValue(Column column, long l) {
        return endianManager.convertValue(column, l);
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, byte by) {
        endianManager.convertValue(byteBuffer, column, by);
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, short s) {
        endianManager.convertValue(byteBuffer, column, s);
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, int n) {
        endianManager.convertValue(byteBuffer, column, n);
    }

    public static void convertValue(ByteBuffer byteBuffer, Column column, long l) {
        endianManager.convertValue(byteBuffer, column, l);
    }

    protected static ByteBuffer convertValue(Column column, String string) {
        if (string == null) {
            string = "";
        }
        CharSequence charSequence = string;
        int n = column.getPrefixLength();
        if (n == 0) {
            charSequence = Utility.padString(string, column);
        }
        ByteBuffer byteBuffer = Utility.encodeToByteBuffer(charSequence, column.getCharsetNumber(), n);
        Utility.fixBufferPrefixLength(column.getName(), byteBuffer, n);
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    protected static ByteBuffer convertValueForLikeFilter(Column column, String string) {
        if (string == null) {
            string = "";
        }
        String string2 = string;
        ByteBuffer byteBuffer = Utility.encodeToByteBuffer(string2, column.getCharsetNumber(), 0);
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    protected static ByteBuffer convertValueForLikeFilter(Column column, byte[] byArray) {
        if (byArray == null) {
            byArray = EMPTY_BYTE_ARRAY;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        if (logger.isDetailEnabled()) {
            Utility.dumpBytesToLog(byteBuffer, byteBuffer.limit());
        }
        return byteBuffer;
    }

    protected static void convertValueForLikeFilter(ByteBuffer byteBuffer, Column column, byte[] byArray) {
        if (byArray == null) {
            byArray = EMPTY_BYTE_ARRAY;
        }
        byteBuffer.put(byArray);
        byteBuffer.flip();
    }

    private static CharSequence padString(CharSequence charSequence, Column column) {
        int n;
        CharSequence charSequence2 = charSequence;
        int n2 = charSequence.length();
        if (n2 > (n = column.getColumnSpace())) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), n, n2));
        }
        if (n2 < n) {
            StringBuilder stringBuilder = new StringBuilder(n);
            stringBuilder.append(charSequence);
            stringBuilder.append(SPACE_PAD, 0, n - n2);
            charSequence2 = stringBuilder;
        }
        return charSequence2;
    }

    private static ByteBuffer padString(ByteBuffer byteBuffer, Column column) {
        int n;
        int n2 = byteBuffer.limit();
        if (n2 > (n = column.getColumnSpace())) {
            throw new ClusterJUserException(local.message("ERR_Data_Too_Long", column.getName(), n, n2));
        }
        if (n2 < n) {
            byteBuffer.limit(n);
            byteBuffer.position(n2);
            byteBuffer.put(BLANK_PAD, 0, n - n2);
            byteBuffer.position(0);
        }
        return byteBuffer;
    }

    public static void fixBufferPrefixLength(String string, ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit();
        int n3 = n2 - n;
        byteBuffer.position(0);
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                byteBuffer.put((byte)(n3 % 256));
                break;
            }
            case 2: {
                byteBuffer.put((byte)(n3 % 256));
                byteBuffer.put((byte)(n3 / 256));
            }
        }
        byteBuffer.position(0);
        byteBuffer.limit(n2);
    }

    private static int packDate(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = n * 512 + (n2 + 1) * 32 + n3;
        return n4;
    }

    private static int packTime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(l);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(10);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        if (n2 != 0) {
            throw new ClusterJUserException(local.message("ERR_Write_Time_Domain", new Time(l), l, n, n2, n3, n4, n5, n6));
        }
        int n7 = (n3 - 1) * 240000 + n4 * 10000 + n5 * 100 + n6;
        return n7;
    }

    protected static long packDatetime(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(l);
        long l2 = calendar.get(1);
        long l3 = calendar.get(2) + 1;
        long l4 = calendar.get(5);
        long l5 = calendar.get(10);
        long l6 = calendar.get(12);
        long l7 = calendar.get(13);
        long l8 = l2 * 10000000000L + l3 * 100000000L + l4 * 1000000L + l5 * 10000L + l6 * 100L + l7;
        return l8;
    }

    protected static long packDatetime2(int n, long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(l);
        long l2 = calendar.get(1);
        long l3 = calendar.get(2);
        long l4 = calendar.get(5);
        long l5 = calendar.get(10);
        long l6 = calendar.get(12);
        long l7 = calendar.get(13);
        long l8 = calendar.get(14);
        long l9 = Utility.packFractionalSeconds(n, l8);
        long l10 = Long.MIN_VALUE + l2 * 0x3400000000000L + (l3 + 1L) * 0x400000000000L + l4 * 0x20000000000L + l5 * 0x1000000000L + l6 * 0x40000000L + l7 * 0x1000000L + l9;
        return l10;
    }

    protected static long unpackDatetime2(int n, long l) {
        int n2 = (int)((l & 0x7FFFC00000000000L) >>> 46);
        int n3 = n2 / 13;
        int n4 = n2 % 13 - 1;
        int n5 = (int)((l & 0x3E0000000000L) >>> 41);
        int n6 = (int)((l & 0x1F000000000L) >>> 36);
        int n7 = (int)((l & 0xFC0000000L) >>> 30);
        int n8 = (int)((l & 0x3F000000L) >>> 24);
        int n9 = Utility.unpackFractionalSeconds(n, (int)(l & 0xFFFFFFL));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n3);
        calendar.set(2, n4);
        calendar.set(5, n5);
        calendar.set(10, n6);
        calendar.set(12, n7);
        calendar.set(13, n8);
        calendar.set(14, n9);
        return calendar.getTimeInMillis();
    }

    protected static long packFractionalSeconds(int n, long l) {
        switch (n) {
            case 0: {
                if (l > 0L) {
                    Utility.throwOnTruncation();
                }
                return 0L;
            }
            case 1: {
                if (l % 100L != 0L) {
                    Utility.throwOnTruncation();
                }
                return l / 100L * 655360L;
            }
            case 2: {
                if (l % 10L != 0L) {
                    Utility.throwOnTruncation();
                }
                return l / 10L * 65536L;
            }
            case 3: 
            case 4: {
                return l * 2560L;
            }
            case 5: 
            case 6: {
                return l * 1000L;
            }
        }
        return 0L;
    }

    protected static int unpackFractionalSeconds(int n, int n2) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return ((n2 & 0xFF0000) >>> 16) * 10;
            }
            case 2: {
                return ((n2 & 0xFF0000) >>> 16) * 10;
            }
            case 3: 
            case 4: {
                return ((n2 & 0xFFFF00) >>> 8) / 10;
            }
            case 5: 
            case 6: {
                return (n2 & 0xFFFFFF) / 1000;
            }
        }
        return 0;
    }

    protected static void throwOnTruncation() {
    }

    protected static long packTime2(int n, long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeInMillis(l);
        long l2 = calendar.get(10);
        long l3 = calendar.get(12);
        long l4 = calendar.get(13);
        long l5 = calendar.get(14);
        long l6 = Utility.packFractionalSeconds(n, l5);
        long l7 = Long.MIN_VALUE | l2 * 0x10000000000000L | l3 * 0x400000000000L | l4 * 0x10000000000L | l6 << 16;
        return l7;
    }

    protected static long unpackTime2(int n, long l) {
        int n2 = (int)((l & 0x3FF0000000000000L) >>> 52);
        int n3 = (int)((l & 0xFC00000000000L) >>> 46);
        int n4 = (int)((l & 0x3F0000000000L) >>> 40);
        int n5 = (int)((l & 0xFFFFFF0000L) >>> 16);
        int n6 = Utility.unpackFractionalSeconds(n, n5);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(10, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
        calendar.set(14, n6);
        return calendar.getTimeInMillis();
    }

    protected static long packTimestamp2(int n, long l) {
        long l2 = l % 1000L;
        long l3 = l / 1000L;
        long l4 = Utility.packFractionalSeconds(n, l2);
        long l5 = (l3 << 32) + (l4 << 8);
        if (logger.isDetailEnabled()) {
            logger.detail("packTimestamp2 precision: " + n + " millis: " + l + " result: " + Utility.hex(l5));
        }
        return l5;
    }

    protected static long unpackTimestamp2(int n, long l) {
        int n2 = (int)((l & 0xFFFFFFFFFFFFFF00L) >>> 8);
        long l2 = (l >>> 32) * 1000L + (long)Utility.unpackFractionalSeconds(n, n2);
        if (logger.isDetailEnabled()) {
            logger.detail("unpackTimestamp2 precision: " + n + " value: " + Utility.hex(l) + " fraction: " + Utility.hex(n2) + " result: " + l2);
        }
        return l2;
    }

    public static String dumpBytes(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("byte[");
        stringBuffer.append(byArray.length);
        stringBuffer.append("]: [");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String dumpBytes(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int n = byteBuffer.limit() - byteBuffer.position();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        byteBuffer.reset();
        return Utility.dumpBytes(byArray);
    }

    private static void dumpBytesToLog(ByteBuffer byteBuffer, int n) {
        StringBuffer stringBuffer = new StringBuffer("String position is: ");
        stringBuffer.append(byteBuffer.position());
        stringBuffer.append(" limit: ");
        stringBuffer.append(byteBuffer.limit());
        stringBuffer.append(" data [");
        while (byteBuffer.hasRemaining()) {
            stringBuffer.append(byteBuffer.get());
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        logger.detail(stringBuffer.toString());
        byteBuffer.position(0);
        byteBuffer.limit(n);
    }

    public static BigDecimal getDecimal(ByteBuffer byteBuffer, int n, int n2, int n3) {
        String string = null;
        try {
            string = Utility.getDecimalString(byteBuffer, n, n2, n3);
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ClusterJUserException(local.message("ERR_Number_Format", (Object)string, (Object)Utility.dump(string)));
        }
    }

    public static BigInteger getBigInteger(ByteBuffer byteBuffer, int n, int n2, int n3) {
        String string = null;
        try {
            string = Utility.getDecimalString(byteBuffer, n, n2, n3);
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ClusterJUserException(local.message("ERR_Number_Format", (Object)string, (Object)Utility.dump(string)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDecimalString(ByteBuffer byteBuffer, int n, int n2, int n3) {
        int n4 = n2 + 3;
        ByteBuffer byteBuffer2 = decimalByteBufferPool.borrowBuffer();
        int n5 = Utils.decimal_bin2str(byteBuffer, n, n2, n3, byteBuffer2, n4);
        if (n5 != 0) {
            decimalByteBufferPool.returnBuffer(byteBuffer2);
            throw new ClusterJUserException(local.message("ERR_Binary_Decimal_To_String", n5, n2, n3, Utility.dumpBytes(byteBuffer)));
        }
        String string = null;
        for (int i = 0; i < byteBuffer2.limit(); ++i) {
            if (byteBuffer2.get(i) != 0) continue;
            byteBuffer2.limit(i);
            break;
        }
        try {
            CharBuffer charBuffer = charset.decode(byteBuffer2);
            String string2 = string = charBuffer.toString();
            return string2;
        }
        finally {
            decimalByteBufferPool.returnBuffer(byteBuffer2);
        }
    }

    public static long unpackDate(int n) {
        int n2 = n & 0x1F;
        int n3 = ((n >>>= 5) & 0xF) - 1;
        int n4 = n >>> 4 & Short.MAX_VALUE;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(n4, n3, n2);
        return calendar.getTimeInMillis();
    }

    public static long unpackTime(int n) {
        int n2 = n % 100;
        int n3 = (n /= 100) % 100;
        int n4 = (n /= 100) % 24;
        int n5 = n / 24 + 1;
        if (n5 > 31) {
            throw new ClusterJUserException(local.message("ERR_Read_Time_Domain", n, n5, n4, n3, n2));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(5, n5);
        calendar.set(10, n4);
        calendar.set(12, n3);
        calendar.set(13, n2);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    protected static long unpackDatetime(long l) {
        int n = (int)(l % 100L);
        int n2 = (int)((l /= 100L) % 100L);
        int n3 = (int)((l /= 100L) % 100L);
        int n4 = (int)((l /= 100L) % 100L);
        int n5 = (int)((l /= 100L) % 100L) - 1;
        int n6 = (int)(l / 100L);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, n6);
        calendar.set(2, n5);
        calendar.set(5, n4);
        calendar.set(10, n3);
        calendar.set(12, n2);
        calendar.set(13, n);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static String decode(byte[] byArray, int n) {
        if (byArray == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.flip();
        int n2 = byArray.length;
        int n3 = n2 * 4;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3);
        int[] nArray = new int[]{n2, n3};
        int n4 = charsetMap.recode(nArray, n, collationUTF16, byteBuffer, byteBuffer2);
        switch (n4) {
            case 0: {
                byteBuffer2.limit(nArray[1]);
                CharBuffer charBuffer = byteBuffer2.asCharBuffer();
                return charBuffer.toString();
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", n));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)n, (Object)nArray[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Buffer_Too_Small", n, n2, n3, nArray[0], nArray[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", n4));
    }

    protected static String decode(ByteBuffer byteBuffer, int n) {
        int n2 = byteBuffer.limit() - byteBuffer.position();
        int n3 = n2 * 2;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n3);
        int[] nArray = new int[]{n2, n3};
        int n4 = charsetMap.recode(nArray, n, collationUTF16, byteBuffer, byteBuffer2);
        switch (n4) {
            case 0: {
                byteBuffer2.limit(nArray[1]);
                CharBuffer charBuffer = byteBuffer2.asCharBuffer();
                return charBuffer.toString();
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", n));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)n, (Object)nArray[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Buffer_Too_Small", n, n2, n3, nArray[0], nArray[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", n4));
    }

    public static byte[] encode(String string, int n) {
        ByteBuffer byteBuffer = Utility.encodeToByteBuffer(string, n, 0);
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    private static ByteBuffer encodeToByteBuffer(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return null;
        }
        int n3 = charSequence.length() * 2;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n3);
        CharBuffer charBuffer = byteBuffer.asCharBuffer();
        charBuffer.append(charSequence);
        int n4 = 2 * n3 + n2;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n4);
        byteBuffer2.position(n2);
        int[] nArray = new int[]{n3, n4 - n2};
        int n5 = charsetMap.recode(nArray, collationUTF16, n, byteBuffer, byteBuffer2);
        switch (n5) {
            case 0: {
                byteBuffer2.limit(n2 + nArray[1]);
                return byteBuffer2;
            }
            case 1: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Charset", n));
            }
            case 2: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Source", (Object)n, (Object)nArray[0]));
            }
            case 3: {
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Buffer_Too_Small", n, n3, n4, nArray[0], nArray[1]));
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Return_Code", n5));
    }

    public static ByteBuffer encode(String string, Column column, DbImpl.BufferManager bufferManager) {
        int n = column.getCharsetNumber();
        if (logger.isDetailEnabled()) {
            logger.detail("Utility.encode storeColumn: " + column.getName() + " charsetName " + column.getCharsetName() + " charsetNumber " + n + " input '" + string + "'");
        }
        CharsetConverter charsetConverter = Utility.getCharsetConverter(n);
        String string2 = string;
        int n2 = column.getPrefixLength();
        ByteBuffer byteBuffer = charsetConverter.encode(column.getName(), string2, n, n2, bufferManager);
        if (n2 == 0) {
            Utility.padString(byteBuffer, column);
        }
        return byteBuffer;
    }

    public static String decode(ByteBuffer byteBuffer, int n, DbImpl.BufferManager bufferManager) {
        CharsetConverter charsetConverter = Utility.getCharsetConverter(n);
        return charsetConverter.decode(byteBuffer, n, bufferManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CharsetConverter getCharsetConverter(int n) {
        CharsetConverter[] charsetConverterArray = charsetConverters;
        synchronized (charsetConverters) {
            if (n + 1 > charsetConverters.length) {
                String string = charsetMap.getName(n);
                logger.warn(local.message("ERR_Charset_Number_Too_Big", n, string, MAXIMUM_MYSQL_COLLATION_NUMBER));
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return charsetConverterMultibyte;
            }
            CharsetConverter charsetConverter = charsetConverters[n];
            if (charsetConverter == null) {
                charsetConverter = Utility.addCollation(n);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return charsetConverter;
        }
    }

    private static CharsetConverter addCollation(int n) {
        if (Utility.isMultibyteCollation(n).booleanValue()) {
            Utility.charsetConverters[n] = charsetConverterMultibyte;
            return Utility.charsetConverters[n];
        }
        String string = charsetMap.getMysqlName(n);
        SingleByteCharsetConverter singleByteCharsetConverter = new SingleByteCharsetConverter(n);
        int[] nArray = collationPeersMap.get(string);
        if (nArray == null) {
            nArray = new int[]{n};
            collationPeersMap.put(string, nArray);
            logger.warn(local.message("WARN_Unknown_Collation", (Object)n, (Object)string));
            return singleByteCharsetConverter;
        }
        for (int n2 : nArray) {
            logger.info("Adding charset converter " + string + " for collation " + n2);
            Utility.charsetConverters[n2] = singleByteCharsetConverter;
        }
        return singleByteCharsetConverter;
    }

    private static Boolean isMultibyteCollation(int n) {
        boolean[] blArray = charsetMap.isMultibyte(n);
        return blArray == null ? null : Boolean.valueOf(blArray[0]);
    }

    private static String dump(String string) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuffer.append((int)c);
            stringBuffer.append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static int getDecimalColumnSpace(int n, int n2) {
        int n3 = howManyBytesNeeded[n - n2];
        int n4 = howManyBytesNeeded[n2];
        int n5 = n3 + n4;
        return n5;
    }

    public static boolean getBoolean(Column column, NdbRecAttr ndbRecAttr) {
        return endianManager.getBoolean(column, ndbRecAttr);
    }

    public static boolean getBoolean(Column column, int n) {
        return endianManager.getBoolean(column, n);
    }

    public static byte getByte(Column column, NdbRecAttr ndbRecAttr) {
        return endianManager.getByte(column, ndbRecAttr);
    }

    public static short getShort(Column column, NdbRecAttr ndbRecAttr) {
        return endianManager.getShort(column, ndbRecAttr);
    }

    public static int getInt(Column column, NdbRecAttr ndbRecAttr) {
        return endianManager.getInt(column, ndbRecAttr);
    }

    public static int getInt(Column column, int n) {
        return endianManager.getInt(column, n);
    }

    public static long getLong(Column column, long l) {
        return endianManager.getLong(column, l);
    }

    public static long convertLongValueForStorage(Column column, long l) {
        return endianManager.convertLongValueForStorage(column, l);
    }

    public static int convertByteValueForStorage(Column column, byte by) {
        return endianManager.convertByteValueForStorage(column, by);
    }

    public static int convertShortValueForStorage(Column column, short s) {
        return endianManager.convertShortValueForStorage(column, s);
    }

    public static int convertIntValueForStorage(Column column, int n) {
        return endianManager.convertIntValueForStorage(column, n);
    }

    static {
        List<Integer> list;
        int n;
        local = I18NHelper.getInstance(Utility.class);
        logger = LoggerFactoryService.getFactory().getInstance(Utility.class);
        charset = Charset.forName("windows-1252");
        SPACE_PAD = new char[255];
        for (n = 0; n < 255; ++n) {
            Utility.SPACE_PAD[n] = 32;
        }
        ZERO_PAD = new byte[255];
        for (n = 0; n < 255; ++n) {
            Utility.ZERO_PAD[n] = 0;
        }
        BLANK_PAD = new byte[255];
        for (n = 0; n < 255; ++n) {
            Utility.BLANK_PAD[n] = 32;
        }
        EMPTY_BYTE_ARRAY = new byte[0];
        MAX_MEDIUMINT_VALUE = (int)(Math.pow(2.0, 23.0) - 1.0);
        MAX_MEDIUMUNSIGNED_VALUE = (int)(Math.pow(2.0, 24.0) - 1.0);
        MIN_MEDIUMINT_VALUE = (int)(-Math.pow(2.0, 23.0));
        decimalByteBufferPool = new FixedByteBufferPoolImpl(68, "Decimal Pool");
        NonSevereErrorCodes = new HashSet<Integer>();
        NonSevereErrorCodes.add(4203);
        NonSevereErrorCodes.add(4243);
        NonSevereErrorCodes.add(626);
        NonSevereErrorCodes.add(630);
        NonSevereErrorCodes.add(893);
        NonSevereErrorCodes.add(255);
        NonSevereErrorCodes.add(256);
        ClusterConnectionServiceImpl.loadSystemLibrary("ndbclient");
        charsetMapClass = Utility.loadClass("com.mysql.ndbjtie.mysql.CharsetMap");
        charsetMap = Utility.createCharsetMap();
        MAXIMUM_MYSQL_COLLATION_NUMBER = 256;
        collationLatin1 = charsetMap.getCharsetNumber("latin1");
        collationUTF16 = charsetMap.getUTF16CharsetNumber();
        collationPeersMap = new TreeMap<String, int[]>();
        charsetConverterMultibyte = new MultiByteCharsetConverter();
        charsetConverters = new CharsetConverter[MAXIMUM_MYSQL_COLLATION_NUMBER + 1];
        TreeMap<String, ArrayList<Integer>> treeMap = new TreeMap<String, ArrayList<Integer>>();
        for (int i = 1; i <= MAXIMUM_MYSQL_COLLATION_NUMBER; ++i) {
            String object = charsetMap.getMysqlName(i);
            if (object == null) continue;
            if (Utility.isMultibyteCollation(i).booleanValue()) {
                Utility.charsetConverters[i] = charsetConverterMultibyte;
                continue;
            }
            list = (List)treeMap.get(object);
            if (list == null) {
                list = new ArrayList<Integer>(8);
                list.add(i);
                treeMap.put(object, (ArrayList<Integer>)list);
                continue;
            }
            list.add(i);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            list = (String)entry.getKey();
            List list2 = (List)entry.getValue();
            int[] nArray = new int[list2.size()];
            int n2 = 0;
            for (Integer n3 : list2) {
                nArray[n2++] = n3;
            }
            collationPeersMap.put((String)((Object)list), nArray);
        }
        if (logger.isDetailEnabled()) {
            for (Map.Entry<Object, Object> entry : collationPeersMap.entrySet()) {
                logger.detail("Utility collationMap " + (String)entry.getKey() + " collations : " + Arrays.toString((int[])entry.getValue()));
            }
        }
        Utility.addCollation(collationLatin1);
        endianManager = ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()) ? new EndianManager(){

            @Override
            public boolean getBoolean(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: {
                        return ndbRecAttr.int32_value() == 1;
                    }
                    case Tinyint: {
                        return ndbRecAttr.int8_value() == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"boolean"));
            }

            @Override
            public boolean getBoolean(Column column, int n) {
                switch (column.getType()) {
                    case Bit: {
                        return n == 1;
                    }
                    case Tinyint: {
                        return n >>> 24 == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"boolean"));
            }

            @Override
            public byte getByte(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: {
                        return (byte)ndbRecAttr.int32_value();
                    }
                    case Tinyint: 
                    case Year: {
                        return ndbRecAttr.int8_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public short getShort(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: {
                        return (short)ndbRecAttr.int32_value();
                    }
                    case Smallint: {
                        return ndbRecAttr.short_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public int getInt(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return ndbRecAttr.int32_value();
                    }
                    case Date: 
                    case Mediumunsigned: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Time: 
                    case Mediumint: {
                        return ndbRecAttr.medium_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public int getInt(Column column, int n) {
                int n2 = 0;
                switch (column.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return n;
                    }
                    case Date: {
                        return n >>> 8;
                    }
                    case Time: {
                        return n >> 8;
                    }
                    case Mediumint: {
                        n2 |= (n & 0xFF000000) >>> 24;
                        n2 |= (n & 0xFF0000) >>> 8;
                        return n2 |= (n & 0xFF00) << 16 >> 8;
                    }
                    case Mediumunsigned: {
                        n2 |= (n & 0xFF000000) >>> 24;
                        n2 |= (n & 0xFF0000) >>> 8;
                        return n2 |= (n & 0xFF00) << 8;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public long getLong(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: {
                        long l = ndbRecAttr.int64_value();
                        return l >>> 32 | l << 32;
                    }
                    case Mediumint: {
                        return ndbRecAttr.medium_value();
                    }
                    case Mediumunsigned: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return ndbRecAttr.int64_value();
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(ndbRecAttr.int64_value());
                    }
                    case Timestamp: {
                        return ((long)ndbRecAttr.int32_value() & 0xFFFFFFFFL) * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate(ndbRecAttr.u_medium_value());
                    }
                    case Time: {
                        return Utility.unpackTime(ndbRecAttr.medium_value());
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            public long get3ByteLong(long l) {
                long l2 = 0L;
                l2 |= (l & 0xFF00000000000000L) >>> 56;
                l2 |= (l & 0xFF000000000000L) >>> 40;
                return l2 |= (l & 0xFF0000000000L) << 16 >> 40;
            }

            @Override
            public long getLong(Column column, long l) {
                switch (column.getType()) {
                    case Bit: {
                        return l >>> 32 | l << 32;
                    }
                    case Mediumint: {
                        return this.get3ByteLong(l);
                    }
                    case Mediumunsigned: {
                        long l2 = 0L;
                        l2 |= (l & 0xFF00000000000000L) >>> 56;
                        l2 |= (l & 0xFF000000000000L) >>> 40;
                        return l2 |= (l & 0xFF0000000000L) >>> 24;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return l;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(l);
                    }
                    case Timestamp: {
                        return (l >> 32) * 1000L;
                    }
                    case Date: {
                        long l3 = this.get3ByteLong(l);
                        return Utility.unpackDate((int)l3);
                    }
                    case Time: {
                        long l4 = this.get3ByteLong(l);
                        return Utility.unpackTime((int)l4);
                    }
                    case Datetime2: {
                        return Utility.unpackDatetime2(column.getPrecision(), l);
                    }
                    case Timestamp2: {
                        return Utility.unpackTimestamp2(column.getPrecision(), l);
                    }
                    case Time2: {
                        return Utility.unpackTime2(column.getPrecision(), l);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public void put3byteInt(ByteBuffer byteBuffer, int n) {
                byteBuffer.put((byte)n);
                byteBuffer.put((byte)(n >> 8));
                byteBuffer.put((byte)(n >> 16));
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, byte by) {
                switch (column.getType()) {
                    case Bit: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt(by & 0xFF);
                        byteBuffer.flip();
                        return;
                    }
                    case Tinyint: 
                    case Year: {
                        byteBuffer.put(by);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public ByteBuffer convertValue(Column column, byte by) {
                switch (column.getType()) {
                    case Bit: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt(by & 0xFF);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Tinyint: 
                    case Year: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
                        byteBuffer.put(by);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, short s) {
                switch (column.getType()) {
                    case Bit: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt(s & 0xFFFF);
                        byteBuffer.flip();
                        return;
                    }
                    case Smallint: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putShort(s);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column column, short s) {
                switch (column.getType()) {
                    case Bit: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt(s & 0xFFFF);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Smallint: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2);
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putShort(s);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column column, int n) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                this.convertValue(byteBuffer, column, n);
                return byteBuffer;
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, int n) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt(n);
                        byteBuffer.flip();
                        return;
                    }
                    case Mediumint: {
                        if (n > MAX_MEDIUMINT_VALUE || n < MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, n);
                        byteBuffer.flip();
                        return;
                    }
                    case Mediumunsigned: {
                        if (n > MAX_MEDIUMUNSIGNED_VALUE || n < 0) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, n);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public int convertIntValueForStorage(Column column, int n) {
                int n2 = 0;
                switch (column.getType()) {
                    case Bit: 
                    case Int: {
                        return n;
                    }
                    case Mediumint: {
                        if (n > MAX_MEDIUMINT_VALUE || n < MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        n2 |= (n & 0xFF) << 24;
                        n2 |= (n & 0xFF00) << 8;
                        return n2 |= (n & 0xFF0000) >> 8;
                    }
                    case Mediumunsigned: {
                        if (n > MAX_MEDIUMUNSIGNED_VALUE || n < 0) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        n2 |= (n & 0xFF) << 24;
                        n2 |= (n & 0xFF00) << 8;
                        return n2 |= (n & 0xFF0000) >> 8;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public ByteBuffer convertValue(Column column, long l) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
                return this.convertValue(column, l, byteBuffer);
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, long l) {
                this.convertValue(column, l, byteBuffer);
            }

            public ByteBuffer convertValue(Column column, long l, ByteBuffer byteBuffer) {
                switch (column.getType()) {
                    case Bit: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt((int)l);
                        byteBuffer.putInt((int)(l >>> 32));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Mediumint: {
                        if (l > (long)MAX_MEDIUMINT_VALUE || l < (long)MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, (int)l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Mediumunsigned: {
                        if (l > (long)MAX_MEDIUMUNSIGNED_VALUE || l < 0L) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, (int)l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Date: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, Utility.packDate(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Datetime: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packDatetime(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Time: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, Utility.packTime(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Timestamp: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putInt((int)(l / 1000L));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Datetime2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packDatetime2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Time2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packTime2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Timestamp2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packTimestamp2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            public long put3byteLong(long l) {
                long l2 = 0L;
                l2 |= (l & 0xFFL) << 56;
                l2 |= (l & 0xFF00L) << 40;
                return l2 |= (l & 0xFF0000L) << 24;
            }

            @Override
            public long convertLongValueForStorage(Column column, long l) {
                long l2 = 0L;
                switch (column.getType()) {
                    case Bit: {
                        l2 |= l >>> 32;
                        return l2 |= l << 32;
                    }
                    case Bigint: 
                    case Bigunsigned: {
                        return l;
                    }
                    case Mediumint: {
                        if (l > (long)MAX_MEDIUMINT_VALUE || l < (long)MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        return this.put3byteLong(l);
                    }
                    case Mediumunsigned: {
                        if (l > (long)MAX_MEDIUMUNSIGNED_VALUE || l < 0L) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        return this.put3byteLong(l);
                    }
                    case Date: {
                        long l3 = Utility.packDate(l);
                        return this.put3byteLong(l3);
                    }
                    case Datetime: {
                        return Utility.packDatetime(l);
                    }
                    case Time: {
                        long l4 = Utility.packTime(l);
                        return this.put3byteLong(l4);
                    }
                    case Timestamp: {
                        return l / 1000L << 32;
                    }
                    case Datetime2: {
                        return Utility.packDatetime2(column.getPrecision(), l);
                    }
                    case Time2: {
                        return Utility.packTime2(column.getPrecision(), l);
                    }
                    case Timestamp2: {
                        return Utility.packTimestamp2(column.getPrecision(), l);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public int convertByteValueForStorage(Column column, byte by) {
                switch (column.getType()) {
                    case Bit: {
                        return by & 0xFF;
                    }
                    case Tinyint: 
                    case Year: {
                        return by << 24;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public int convertShortValueForStorage(Column column, short s) {
                switch (column.getType()) {
                    case Bit: {
                        return s & 0xFFFF;
                    }
                    case Smallint: {
                        return s << 16;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public long convertLongValueFromStorage(Column column, long l) {
                return 0L;
            }
        } : new EndianManager(){

            @Override
            public boolean getBoolean(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: {
                        return ndbRecAttr.int32_value() == 1;
                    }
                    case Tinyint: {
                        return ndbRecAttr.int8_value() == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"boolean"));
            }

            @Override
            public boolean getBoolean(Column column, int n) {
                switch (column.getType()) {
                    case Bit: 
                    case Tinyint: {
                        return n == 1;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"boolean"));
            }

            @Override
            public byte getByte(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: 
                    case Tinyint: 
                    case Year: {
                        return ndbRecAttr.int8_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public short getShort(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: 
                    case Smallint: {
                        return ndbRecAttr.short_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public int getInt(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return ndbRecAttr.int32_value();
                    }
                    case Date: 
                    case Mediumunsigned: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Time: 
                    case Mediumint: {
                        return ndbRecAttr.medium_value();
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public int getInt(Column column, int n) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: 
                    case Timestamp: {
                        return n;
                    }
                    case Date: 
                    case Mediumunsigned: {
                        return n & 0xFFFFFF;
                    }
                    case Time: 
                    case Mediumint: {
                        return n << 8 >> 8;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public long getLong(Column column, NdbRecAttr ndbRecAttr) {
                switch (column.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return ndbRecAttr.int64_value();
                    }
                    case Mediumint: {
                        return ndbRecAttr.medium_value();
                    }
                    case Mediumunsigned: {
                        return ndbRecAttr.u_medium_value();
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(ndbRecAttr.int64_value());
                    }
                    case Timestamp: {
                        return (long)ndbRecAttr.int32_value() * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate(ndbRecAttr.int32_value());
                    }
                    case Time: {
                        return Utility.unpackTime(ndbRecAttr.int32_value());
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public long getLong(Column column, long l) {
                switch (column.getType()) {
                    case Bit: 
                    case Mediumunsigned: 
                    case Mediumint: 
                    case Bigint: 
                    case Bigunsigned: {
                        return l;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(l);
                    }
                    case Timestamp: {
                        return l * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate((int)l);
                    }
                    case Time: {
                        return Utility.unpackTime((int)l);
                    }
                    case Datetime2: {
                        return Utility.unpackDatetime2(column.getPrecision(), Utility.swap(l));
                    }
                    case Timestamp2: {
                        return Utility.unpackTimestamp2(column.getPrecision(), Utility.swap(l));
                    }
                    case Time2: {
                        return Utility.unpackTime2(column.getPrecision(), Utility.swap(l));
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public void put3byteInt(ByteBuffer byteBuffer, int n) {
                byteBuffer.putInt(n);
                byteBuffer.limit(3);
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, byte by) {
                switch (column.getType()) {
                    case Bit: {
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.putInt(by & 0xFF);
                        byteBuffer.flip();
                        return;
                    }
                    case Tinyint: 
                    case Year: {
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.put(by);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column column, byte by) {
                switch (column.getType()) {
                    case Bit: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.putInt(by & 0xFF);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Tinyint: 
                    case Year: {
                        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.put(by);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column column, short s) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(2);
                this.convertValue(byteBuffer, column, s);
                return byteBuffer;
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, short s) {
                switch (column.getType()) {
                    case Bit: 
                    case Smallint: {
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.putShort(s);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public ByteBuffer convertValue(Column column, int n) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
                this.convertValue(byteBuffer, column, n);
                return byteBuffer;
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, int n) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: {
                        byteBuffer.order(ByteOrder.nativeOrder());
                        byteBuffer.putInt(n);
                        byteBuffer.flip();
                        return;
                    }
                    case Mediumint: {
                        if (n > MAX_MEDIUMINT_VALUE || n < MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, n);
                        byteBuffer.flip();
                        return;
                    }
                    case Mediumunsigned: {
                        if (n > MAX_MEDIUMUNSIGNED_VALUE || n < 0) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, n);
                        byteBuffer.flip();
                        return;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public int convertIntValueForStorage(Column column, int n) {
                switch (column.getType()) {
                    case Bit: 
                    case Int: {
                        return n;
                    }
                    case Mediumint: {
                        if (n > MAX_MEDIUMINT_VALUE || n < MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        return n;
                    }
                    case Mediumunsigned: {
                        if (n > MAX_MEDIUMUNSIGNED_VALUE || n < 0) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{n, column.getName(), column.getType()}));
                        }
                        return n;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"int"));
            }

            @Override
            public void convertValue(ByteBuffer byteBuffer, Column column, long l) {
                this.convertValue(column, l, byteBuffer);
            }

            @Override
            public ByteBuffer convertValue(Column column, long l) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
                return this.convertValue(column, l, byteBuffer);
            }

            public ByteBuffer convertValue(Column column, long l, ByteBuffer byteBuffer) {
                switch (column.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        byteBuffer.putLong(l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Mediumint: {
                        if (l > (long)MAX_MEDIUMINT_VALUE || l < (long)MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, (int)l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Mediumunsigned: {
                        if (l > (long)MAX_MEDIUMUNSIGNED_VALUE || l < 0L) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, (int)l);
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Datetime: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        byteBuffer.putLong(Utility.packDatetime(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Timestamp: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        byteBuffer.putInt((int)(l / 1000L));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Date: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, Utility.packDate(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Time: {
                        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        this.put3byteInt(byteBuffer, Utility.packTime(l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Datetime2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packDatetime2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Time2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packTime2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                    case Timestamp2: {
                        byteBuffer.order(ByteOrder.BIG_ENDIAN);
                        byteBuffer.putLong(Utility.packTimestamp2(column.getPrecision(), l));
                        byteBuffer.flip();
                        return byteBuffer;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public long convertLongValueForStorage(Column column, long l) {
                switch (column.getType()) {
                    case Bit: 
                    case Bigint: 
                    case Bigunsigned: {
                        return l;
                    }
                    case Mediumint: {
                        if (l > (long)MAX_MEDIUMINT_VALUE || l < (long)MIN_MEDIUMINT_VALUE) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        return l;
                    }
                    case Mediumunsigned: {
                        if (l > (long)MAX_MEDIUMUNSIGNED_VALUE || l < 0L) {
                            throw new ClusterJUserException(local.message("ERR_Bounds", new Object[]{l, column.getName(), column.getType()}));
                        }
                        return l;
                    }
                    case Datetime: {
                        return Utility.packDatetime(l);
                    }
                    case Timestamp: {
                        return l / 1000L;
                    }
                    case Date: {
                        return Utility.packDate(l);
                    }
                    case Time: {
                        return Utility.packTime(l);
                    }
                    case Datetime2: {
                        return Utility.swap(Utility.packDatetime2(column.getPrecision(), l));
                    }
                    case Time2: {
                        return Utility.swap(Utility.packTime2(column.getPrecision(), l));
                    }
                    case Timestamp2: {
                        return Utility.swap(Utility.packTimestamp2(column.getPrecision(), l));
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }

            @Override
            public int convertByteValueForStorage(Column column, byte by) {
                switch (column.getType()) {
                    case Bit: 
                    case Tinyint: 
                    case Year: {
                        return by & 0xFF;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"byte"));
            }

            @Override
            public int convertShortValueForStorage(Column column, short s) {
                switch (column.getType()) {
                    case Bit: 
                    case Smallint: {
                        return s & 0xFFFF;
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"short"));
            }

            @Override
            public long convertLongValueFromStorage(Column column, long l) {
                switch (column.getType()) {
                    case Bit: 
                    case Mediumunsigned: 
                    case Mediumint: 
                    case Bigint: 
                    case Bigunsigned: {
                        return l;
                    }
                    case Datetime: {
                        return Utility.unpackDatetime(l);
                    }
                    case Timestamp: {
                        return l * 1000L;
                    }
                    case Date: {
                        return Utility.unpackDate((int)l);
                    }
                    case Time: {
                        return Utility.unpackTime((int)l);
                    }
                }
                throw new ClusterJUserException(local.message("ERR_Unsupported_Mapping", (Object)column.getType(), (Object)"long"));
            }
        };
        howManyBytesNeeded = new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 28, 29, 29};
    }

    protected static class SingleByteCharsetConverter
    implements CharsetConverter {
        private static final int BYTE_RANGE = 256;
        private static byte[] allBytes;
        private static byte[] unknownCharsMap;
        private char[] byteToChars = new char[256];
        private byte[] charToBytes = new byte[65536];

        public SingleByteCharsetConverter(int n) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(256);
            byteBuffer.put(allBytes);
            byteBuffer.flip();
            String string = Utility.decode(byteBuffer, n);
            if (string.length() != 256) {
                String string2 = charsetMap.getName(n);
                throw new ClusterJFatalInternalException(local.message("ERR_Bad_Charset_Decode_All_Chars", n, string2, string.length()));
            }
            int n2 = string.length();
            System.arraycopy(unknownCharsMap, 0, this.charToBytes, 0, this.charToBytes.length);
            for (int i = 0; i < 256 && i < n2; ++i) {
                char c;
                this.byteToChars[i] = c = string.charAt(i);
                this.charToBytes[c] = allBytes[i];
            }
        }

        @Override
        public ByteBuffer encode(String string, CharSequence charSequence, int n, int n2, DbImpl.BufferManager bufferManager) {
            int n3 = charSequence.length();
            byte[] byArray = new byte[n3];
            for (int i = 0; i < n3; ++i) {
                byArray[i] = this.charToBytes[charSequence.charAt(i)];
            }
            ByteBuffer byteBuffer = bufferManager.getStringStorageBuffer(n3 + n2);
            byteBuffer.position(n2);
            byteBuffer.put(byArray);
            byteBuffer.flip();
            Utility.fixBufferPrefixLength(string, byteBuffer, n2);
            return byteBuffer;
        }

        @Override
        public String decode(ByteBuffer byteBuffer, int n, DbImpl.BufferManager bufferManager) {
            int n2 = byteBuffer.limit();
            int n3 = byteBuffer.position();
            int n4 = n2 - n3;
            byte[] byArray = new byte[n4];
            byteBuffer.get(byArray);
            char[] cArray = new char[n4];
            for (int i = 0; i < n4; ++i) {
                cArray[i] = this.byteToChars[byArray[i] - -128];
            }
            String string = new String(cArray);
            return string;
        }

        static {
            int n;
            allBytes = new byte[256];
            unknownCharsMap = new byte[65536];
            for (n = -128; n <= 127; ++n) {
                SingleByteCharsetConverter.allBytes[n - -128] = (byte)n;
            }
            for (n = 0; n < unknownCharsMap.length; ++n) {
                SingleByteCharsetConverter.unknownCharsMap[n] = 63;
            }
        }
    }

    protected static class MultiByteCharsetConverter
    implements CharsetConverter {
        protected MultiByteCharsetConverter() {
        }

        @Override
        public ByteBuffer encode(String string, CharSequence charSequence, int n, int n2, DbImpl.BufferManager bufferManager) {
            int n3 = charSequence.length() * 2;
            ByteBuffer byteBuffer = bufferManager.copyStringToByteBuffer(charSequence);
            boolean bl = false;
            int n4 = n3;
            block6: while (!bl) {
                ByteBuffer byteBuffer2 = bufferManager.getStringStorageBuffer(n4);
                int n5 = byteBuffer2.limit();
                byteBuffer2.position(n2);
                int[] nArray = new int[]{n3, n5 - n2};
                int n6 = charsetMap.recode(nArray, collationUTF16, n, byteBuffer, byteBuffer2);
                switch (n6) {
                    case 0: {
                        byteBuffer2.limit(n2 + nArray[1]);
                        byteBuffer2.position(0);
                        Utility.fixBufferPrefixLength(string, byteBuffer2, n2);
                        return byteBuffer2;
                    }
                    case 1: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Charset", n));
                    }
                    case 2: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Source", (Object)n, (Object)nArray[0]));
                    }
                    case 3: {
                        n4 = n4 * 3 / 2;
                        continue block6;
                    }
                }
                throw new ClusterJFatalInternalException(local.message("ERR_Encode_Bad_Return_Code", n6));
            }
            return null;
        }

        @Override
        public String decode(ByteBuffer byteBuffer, int n, DbImpl.BufferManager bufferManager) {
            int n2 = byteBuffer.limit() - byteBuffer.position();
            int n3 = n2 * 4;
            boolean bl = false;
            block6: while (!bl) {
                ByteBuffer byteBuffer2 = bufferManager.getStringByteBuffer(n3);
                CharBuffer charBuffer = bufferManager.getStringCharBuffer();
                int n4 = byteBuffer2.limit();
                byteBuffer2.position(0);
                byteBuffer2.limit(n4);
                int[] nArray = new int[]{n2, n4};
                int n5 = charsetMap.recode(nArray, n, collationUTF16, byteBuffer, byteBuffer2);
                switch (n5) {
                    case 0: {
                        charBuffer.position(0);
                        charBuffer.limit(nArray[1] / 2);
                        return charBuffer.toString();
                    }
                    case 1: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Charset", n));
                    }
                    case 2: {
                        throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Source", (Object)n, (Object)nArray[0]));
                    }
                    case 3: {
                        n3 = n3 * 3 / 2;
                        continue block6;
                    }
                }
                throw new ClusterJFatalInternalException(local.message("ERR_Decode_Bad_Return_Code", n5));
            }
            return null;
        }
    }

    protected static interface CharsetConverter {
        public ByteBuffer encode(String var1, CharSequence var2, int var3, int var4, DbImpl.BufferManager var5);

        public String decode(ByteBuffer var1, int var2, DbImpl.BufferManager var3);
    }

    protected static interface EndianManager {
        public void put3byteInt(ByteBuffer var1, int var2);

        public int getInt(Column var1, int var2);

        public int getInt(Column var1, NdbRecAttr var2);

        public short getShort(Column var1, NdbRecAttr var2);

        public long getLong(Column var1, NdbRecAttr var2);

        public long getLong(Column var1, long var2);

        public byte getByte(Column var1, NdbRecAttr var2);

        public ByteBuffer convertValue(Column var1, byte var2);

        public ByteBuffer convertValue(Column var1, short var2);

        public ByteBuffer convertValue(Column var1, int var2);

        public ByteBuffer convertValue(Column var1, long var2);

        public void convertValue(ByteBuffer var1, Column var2, byte var3);

        public void convertValue(ByteBuffer var1, Column var2, short var3);

        public void convertValue(ByteBuffer var1, Column var2, int var3);

        public void convertValue(ByteBuffer var1, Column var2, long var3);

        public boolean getBoolean(Column var1, NdbRecAttr var2);

        public boolean getBoolean(Column var1, int var2);

        public int convertIntValueForStorage(Column var1, int var2);

        public long convertLongValueForStorage(Column var1, long var2);

        public long convertLongValueFromStorage(Column var1, long var2);

        public int convertByteValueForStorage(Column var1, byte var2);

        public int convertShortValueForStorage(Column var1, short var2);
    }
}

