/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Ignore;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Customer;
import testsuite.clusterj.model.IdBase;
import testsuite.clusterj.model.Order;
import testsuite.clusterj.model.OrderLine;

@Ignore(value="Bug#28550140 : disable test until diagnosis of failure")
public class ReconnectTest
extends AbstractClusterJModelTest {
    private int numberOfThreads = 30;
    private int numberOfNewCustomersPerThread = 5;
    private int numberOfNewOrdersPerNewCustomer = 5;
    private int numberOfUpdatesPerThread = 2;
    private int maximumOrderLinesPerOrder = 5;
    private int maximumQuantityPerOrderLine = 100;
    private int maximumUnitPrice = 100;
    private int numberOfInitialCustomers;
    private int nextCustomerId = this.numberOfInitialCustomers = 10;
    private int nextOrderId = 0;
    private int nextOrderLineId = 0;
    private int numberOfUpdatedOrderLines = 0;
    private int numberOfDeletedOrders = 0;
    private int numberOfDeletedOrderLines = 0;
    private ThreadGroup threadGroup;
    private int numberOfThreadsReady = 0;
    private final Object numberOfThreadsReadySync = new Object();
    List<Customer> customers = new ArrayList<Customer>();
    List<Order> orders = new ArrayList<Order>();
    Set<OrderLine> orderlines = new TreeSet<OrderLine>(new Comparator<OrderLine>(){

        @Override
        public int compare(OrderLine orderLine, OrderLine orderLine2) {
            return orderLine.getId() - orderLine2.getId();
        }
    });
    private int retryCount = 0;

    @Override
    protected boolean getDebug() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementNumberOfThreadsReady() {
        Object object = this.numberOfThreadsReadySync;
        synchronized (object) {
            ++this.numberOfThreadsReady;
            this.numberOfThreadsReadySync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilAtleastNumberOfThreadsReady(int n) {
        Object object = this.numberOfThreadsReadySync;
        synchronized (object) {
            while (this.numberOfThreadsReady < n) {
                logger.warn("Waiting on " + n);
                try {
                    this.numberOfThreadsReadySync.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Customer.class);
        this.session.deletePersistentAll(Order.class);
        this.session.deletePersistentAll(OrderLine.class);
        this.tx.commit();
        this.createCustomerInstances(this.nextCustomerId);
        this.tx.begin();
        this.session.makePersistentAll(this.customers);
        this.tx.commit();
        this.addTearDownClasses(Customer.class);
        this.addTearDownClasses(Order.class);
        this.addTearDownClasses(OrderLine.class);
        this.session.close();
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private void createCustomerInstances(int n) {
        for (int i = 0; i < n; ++i) {
            Customer customer = (Customer)this.session.newInstance(Customer.class);
            customer.setId(i);
            customer.setName("Customer number " + i + " (initial)");
            customer.setMagic(i * 100);
            this.customers.add(customer);
        }
    }

    public void test() {
        Object object;
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        this.threadGroup = new ThreadGroup("Stuff");
        AbstractClusterJTest.MyUncaughtExceptionHandler myUncaughtExceptionHandler = new AbstractClusterJTest.MyUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(myUncaughtExceptionHandler);
        Thread thread = new Thread(this.threadGroup, new Misbehaving());
        thread.start();
        this.waitUntilAtleastNumberOfThreadsReady(1);
        for (int i = 0; i < this.numberOfThreads; ++i) {
            Thread object22 = new Thread(this.threadGroup, new StuffToDo());
            arrayList.add(object22);
        }
        for (Thread thread2 : arrayList) {
            thread2.start();
        }
        this.waitUntilAtleastNumberOfThreadsReady(2);
        this.sessionFactory.reconnect(5);
        arrayList.add(thread);
        for (Thread thread3 : arrayList) {
            try {
                thread3.join();
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while joining threads.");
            }
        }
        for (Throwable throwable : myUncaughtExceptionHandler.getUncaughtExceptions()) {
            this.error("Caught exception: " + throwable.getClass().getName() + ": " + throwable.getMessage());
            object = throwable.getStackTrace();
            for (StackTraceElement stackTraceElement : object) {
                this.error("        at " + stackTraceElement.toString());
            }
        }
        if (this.retryCount < 5) {
            this.error("Retry count too low: " + this.retryCount);
        }
        if (this.getDebug()) {
            System.out.println("Retry count: " + this.retryCount);
            System.out.println("Number of threads: " + this.numberOfThreads + "; number of new customers per thread: " + this.numberOfNewCustomersPerThread + "; number of orders per new customer: " + this.numberOfNewOrdersPerNewCustomer);
            System.out.println("Created " + this.nextCustomerId + " customers; " + this.nextOrderId + " orders; and " + this.nextOrderLineId + " order lines.");
            System.out.println("Deleted " + this.numberOfDeletedOrders + " orders; and " + this.numberOfDeletedOrderLines + " order lines.");
            System.out.println("Updated " + this.numberOfUpdatedOrderLines + " order lines.");
        }
        this.errorIfNotEqual("Failed to create customers.", this.numberOfThreads * this.numberOfNewCustomersPerThread + this.numberOfInitialCustomers, this.nextCustomerId);
        this.errorIfNotEqual("Failed to create orders. ", this.numberOfThreads * this.numberOfNewCustomersPerThread * this.numberOfNewOrdersPerNewCustomer, this.nextOrderId);
        boolean bl = false;
        while (!bl) {
            if (this.getDebug()) {
                System.out.println("verifying...");
            }
            try {
                Session session = this.sessionFactory.getSession();
                object = null;
                try {
                    QueryDomainType queryDomainType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
                    queryDomainType.where(queryDomainType.get("orderId").equal(queryDomainType.param("orderId")));
                    if (this.getDebug()) {
                        System.out.println("checking orders: " + this.orders.size());
                    }
                    for (Order order : this.orders) {
                        int n = order.getId();
                        if (this.getDebug()) {
                            System.out.println("Read order " + n + " total " + order.getValue());
                        }
                        order = (Order)session.find(Order.class, (Object)n);
                        double d = order.getValue();
                        double d2 = 0.0;
                        StringBuffer stringBuffer = new StringBuffer();
                        ArrayList<OrderLine> arrayList2 = new ArrayList<OrderLine>();
                        for (OrderLine orderLine : this.getOrderLines(session, (QueryDomainType<OrderLine>)queryDomainType, n)) {
                            arrayList2.add(orderLine);
                            String string = "order " + orderLine.getOrderId() + " orderline " + orderLine.getId() + " value " + orderLine.getTotalValue();
                            if (this.getDebug()) {
                                System.out.println(string);
                            }
                            stringBuffer.append(string);
                            stringBuffer.append('\n');
                            d2 += orderLine.getTotalValue();
                        }
                        this.errorIfNotEqual("For order " + n + ", order value does not equal sum of order line values. orderLines: \n" + stringBuffer.toString(), d, d2);
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (session == null) continue;
                    if (object != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    session.close();
                }
            }
            catch (Throwable throwable) {
                if (this.getDebug()) {
                    System.out.println("summarize for the record caught " + throwable.getMessage());
                }
                this.sleep(1000L);
            }
        }
        this.failOnError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementRetryCount() {
        ReconnectTest reconnectTest = this;
        synchronized (reconnectTest) {
            ++this.retryCount;
        }
    }

    private Customer createCustomer(Session session, String string) {
        Customer customer = (Customer)session.newInstance(Customer.class);
        int n = this.getNextCustomerId();
        customer.setId(n);
        customer.setName("Customer number " + n + " thread " + string);
        customer.setMagic(n * 10000);
        session.makePersistent((Object)customer);
        return customer;
    }

    public Order createOrder(Session session, int n, Random random) {
        int n2 = this.getNextOrderId();
        Order order = (Order)session.newInstance(Order.class);
        order.setId(n2);
        order.setCustomerId(n);
        order.setDescription("Order " + n2 + " for Customer " + n);
        Double d = 0.0;
        int n3 = random.nextInt(this.maximumOrderLinesPerOrder) + 1;
        if (this.getDebug()) {
            System.out.println("Create Order " + n2 + " with numberOfOrderLines: " + n3);
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getNextOrderLineId();
            OrderLine orderLine = (OrderLine)session.newInstance(OrderLine.class);
            orderLine.setId(n4);
            orderLine.setOrderId(n2);
            long l = random.nextInt(this.maximumQuantityPerOrderLine) + 1;
            orderLine.setQuantity(l);
            float f = (1.0f + (float)random.nextInt(this.maximumUnitPrice)) / 4.0f;
            orderLine.setUnitPrice(f);
            double d2 = f * (float)l;
            d = d + d2;
            if (this.getDebug()) {
                System.out.println("Create orderline " + n4 + " for Order " + n2 + " quantity " + l + " price " + f + " order line value " + d2 + " order value " + d);
            }
            orderLine.setTotalValue(d2);
            this.addOrderLine(orderLine);
            session.persist((Object)orderLine);
        }
        order.setValue(d);
        session.persist((Object)order);
        return order;
    }

    public Order updateOrder(Session session, Random random, QueryDomainType<OrderLine> queryDomainType) {
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return null;
        }
        int n = order.getId();
        if ((order = (Order)session.find(Order.class, (Object)n)) == null) {
            return null;
        }
        List<OrderLine> list = this.getOrderLines(session, queryDomainType, n);
        int n2 = list.size();
        OrderLine orderLine = null;
        double d = order.getValue();
        if (this.getDebug()) {
            System.out.println("updateOrder previous orderValue: " + d);
        }
        if (n2 > 0) {
            int n3 = random.nextInt(n2);
            orderLine = list.get(n3);
            d -= orderLine.getTotalValue();
            this.updateOrderLine(orderLine, random);
            d += orderLine.getTotalValue();
        }
        if (this.getDebug()) {
            System.out.println("updateOrder updated orderValue: " + d);
        }
        order.setValue(d);
        session.updatePersistent((Object)orderLine);
        session.updatePersistent((Object)order);
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderLine(OrderLine orderLine, Random random) {
        int n = orderLine.getOrderId();
        int n2 = orderLine.getId();
        double d = orderLine.getTotalValue();
        long l = random.nextInt(this.maximumQuantityPerOrderLine);
        orderLine.setQuantity(l);
        float f = (float)random.nextInt(this.maximumUnitPrice) / 4.0f;
        orderLine.setUnitPrice(f);
        double d2 = f * (float)l;
        orderLine.setTotalValue(d2);
        if (this.getDebug()) {
            System.out.println("For order " + n + " orderline " + n2 + " previous order line value " + d + " new order line value " + d2);
        }
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            ++this.numberOfUpdatedOrderLines;
        }
    }

    public void deleteOrder(Session session, Random random, QueryDomainType<OrderLine> queryDomainType) {
        Order order = null;
        order = this.removeOrderFromOrdersCollection(random);
        if (order == null) {
            return;
        }
        int n = order.getId();
        if ((order = (Order)session.find(Order.class, (Object)n)) == null) {
            return;
        }
        List<OrderLine> list = this.getOrderLines(session, queryDomainType, n);
        this.removeOrderLinesFromOrderLinesCollection(list);
        session.deletePersistentAll(list);
        session.deletePersistent((Object)order);
    }

    private List<OrderLine> getOrderLines(Session session, QueryDomainType<OrderLine> queryDomainType, int n) {
        Query query = session.createQuery(queryDomainType);
        query.setParameter("orderId", (Object)n);
        return query.getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Order removeOrderFromOrdersCollection(Random random) {
        List<Order> list = this.orders;
        synchronized (list) {
            int n = this.orders.size();
            if (n < 10) {
                return null;
            }
            int n2 = random.nextInt(n);
            ++this.numberOfDeletedOrders;
            return this.orders.remove(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOrderLinesFromOrderLinesCollection(Collection<OrderLine> collection) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.removeAll(collection);
            this.numberOfDeletedOrderLines += collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomer(Customer customer) {
        List<Customer> list = this.customers;
        synchronized (list) {
            this.customers.add(customer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextCustomerId() {
        List<Customer> list = this.customers;
        synchronized (list) {
            int n = this.nextCustomerId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderId() {
        List<Order> list = this.orders;
        synchronized (list) {
            int n = this.nextOrderId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextOrderLineId() {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            int n = this.nextOrderLineId++;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrder(Order order) {
        List<Order> list = this.orders;
        synchronized (list) {
            this.orders.add(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrders(Collection<Order> collection) {
        List<Order> list = this.orders;
        synchronized (list) {
            this.orders.addAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrderLine(OrderLine orderLine) {
        Set<OrderLine> set = this.orderlines;
        synchronized (set) {
            this.orderlines.add(orderLine);
        }
    }

    class StuffToDo
    implements Runnable {
        private Random myRandom = new Random();

        StuffToDo() {
        }

        @Override
        public void run() {
            IdBase idBase;
            Throwable throwable;
            Throwable throwable2;
            QueryDomainType queryDomainType = null;
            boolean bl = false;
            while (!bl) {
                try {
                    Session session = ReconnectTest.this.sessionFactory.getSession();
                    throwable2 = null;
                    try {
                        queryDomainType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
                        queryDomainType.where(queryDomainType.get("orderId").equal(queryDomainType.param("orderId")));
                        session.close();
                        bl = true;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (session == null) continue;
                        if (throwable2 != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        session.close();
                    }
                }
                catch (ClusterJUserException clusterJUserException) {
                    if (ReconnectTest.this.getDebug()) {
                        System.out.println("StuffToDo: query orderId caught " + clusterJUserException.getMessage());
                    }
                    if (!clusterJUserException.getMessage().contains("SessionFactory is not open")) continue;
                    ReconnectTest.this.sleep(300L);
                }
            }
            ReconnectTest.this.incrementNumberOfThreadsReady();
            int n = 0;
            while (n < ReconnectTest.this.numberOfNewCustomersPerThread) {
                try {
                    throwable2 = ReconnectTest.this.sessionFactory.getSession();
                    throwable = null;
                    try {
                        idBase = null;
                        ArrayList<Order> arrayList = new ArrayList<Order>(ReconnectTest.this.numberOfNewOrdersPerNewCustomer);
                        throwable2.currentTransaction().begin();
                        idBase = ReconnectTest.this.createCustomer((Session)throwable2, String.valueOf(Thread.currentThread().getId()));
                        int n2 = idBase.getId();
                        for (int i = 0; i < ReconnectTest.this.numberOfNewOrdersPerNewCustomer; ++i) {
                            arrayList.add(ReconnectTest.this.createOrder((Session)throwable2, n2, this.myRandom));
                        }
                        ++n;
                        throwable2.currentTransaction().commit();
                        ReconnectTest.this.addCustomer((Customer)idBase);
                        ReconnectTest.this.addOrders(arrayList);
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (throwable2 == null) continue;
                        if (throwable != null) {
                            try {
                                throwable2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        throwable2.close();
                    }
                }
                catch (ClusterJUserException clusterJUserException) {
                    if (ReconnectTest.this.getDebug()) {
                        System.out.println("StuffToDo: create customer caught " + clusterJUserException.getMessage());
                    }
                    if (!clusterJUserException.getMessage().contains("SessionFactory is not open")) continue;
                    ReconnectTest.this.incrementRetryCount();
                    ReconnectTest.this.sleep(300L);
                }
            }
            n = 0;
            while (n < ReconnectTest.this.numberOfUpdatesPerThread) {
                try {
                    throwable2 = ReconnectTest.this.sessionFactory.getSession();
                    throwable = null;
                    try {
                        throwable2.currentTransaction().begin();
                        idBase = ReconnectTest.this.updateOrder((Session)throwable2, this.myRandom, (QueryDomainType<OrderLine>)queryDomainType);
                        throwable2.currentTransaction().commit();
                        ReconnectTest.this.addOrder((Order)idBase);
                        ++n;
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (throwable2 == null) continue;
                        if (throwable != null) {
                            try {
                                throwable2.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        throwable2.close();
                    }
                }
                catch (ClusterJUserException clusterJUserException) {
                    if (ReconnectTest.this.getDebug()) {
                        System.out.println("StuffToDo: update orders caught " + clusterJUserException.getMessage());
                    }
                    if (!clusterJUserException.getMessage().contains("SessionFactory is not open")) continue;
                    ReconnectTest.this.incrementRetryCount();
                    ReconnectTest.this.sleep(300L);
                }
            }
            bl = false;
            while (!bl) {
                try {
                    throwable2 = ReconnectTest.this.sessionFactory.getSession();
                    throwable = null;
                    try {
                        throwable2.currentTransaction().begin();
                        ReconnectTest.this.deleteOrder((Session)throwable2, this.myRandom, (QueryDomainType<OrderLine>)queryDomainType);
                        throwable2.currentTransaction().commit();
                        bl = true;
                    }
                    catch (Throwable throwable9) {
                        throwable = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (throwable2 == null) continue;
                        if (throwable != null) {
                            try {
                                throwable2.close();
                            }
                            catch (Throwable throwable10) {
                                throwable.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        throwable2.close();
                    }
                }
                catch (ClusterJUserException clusterJUserException) {
                    if (ReconnectTest.this.getDebug()) {
                        System.out.println("StuffToDo: delete order caught " + clusterJUserException.getMessage());
                    }
                    if (!clusterJUserException.getMessage().contains("SessionFactory is not open")) continue;
                    ReconnectTest.this.incrementRetryCount();
                    ReconnectTest.this.sleep(300L);
                }
            }
        }
    }

    class Misbehaving
    implements Runnable {
        Misbehaving() {
        }

        @Override
        public void run() {
            Session session = ReconnectTest.this.sessionFactory.getSession();
            session.currentTransaction().begin();
            boolean bl = false;
            ReconnectTest.this.incrementNumberOfThreadsReady();
            while (!bl) {
                try {
                    QueryDomainType queryDomainType = session.getQueryBuilder().createQueryDefinition(OrderLine.class);
                    queryDomainType.where(queryDomainType.get("orderId").greaterThan(queryDomainType.param("orderId")));
                    Query query = session.createQuery((QueryDefinition)queryDomainType);
                    query.setParameter("orderId", (Object)0);
                    query.getResultList();
                    ReconnectTest.this.sleep(100L);
                }
                catch (ClusterJException clusterJException) {
                    bl = true;
                }
            }
        }
    }
}

