/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.PredicateOperand;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class ReleaseTest
extends AbstractClusterJModelTest {
    Employee emp0;
    Employee emp1;
    Employee emp2;
    Employee emp3;
    Employee emp4;
    Employee emp5;
    Employee emp6;
    Employee emp7;

    public void test() {
        this.testReleaseNull();
        this.testReleaseStatic();
        this.testReleaseDynamic();
        this.testReleaseArray();
        this.testReleaseIterable();
        this.testReleaseFoundStatic();
        this.testReleaseFoundDynamic();
        this.testReleaseQueryStatic();
        this.testReleaseQueryDynamic();
        this.testReleaseNonPersistent();
        this.failOnError();
    }

    Employee setEmployeeFields(Employee employee) {
        int n = employee.getId();
        employee.setName("Employee " + n);
        employee.setMagic(n);
        employee.setAge(n);
        return employee;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.deletePersistentAll(Employee.class);
        this.emp0 = this.setEmployeeFields((Employee)this.session.newInstance(Employee.class, (Object)0));
        this.emp1 = this.setEmployeeFields((Employee)this.session.newInstance(DynamicEmployee.class, (Object)1));
        this.emp2 = this.setEmployeeFields((Employee)this.session.newInstance(Employee.class, (Object)2));
        this.emp3 = this.setEmployeeFields((Employee)this.session.newInstance(DynamicEmployee.class, (Object)3));
        this.emp4 = this.setEmployeeFields((Employee)this.session.newInstance(Employee.class, (Object)4));
        this.emp5 = this.setEmployeeFields((Employee)this.session.newInstance(DynamicEmployee.class, (Object)5));
        this.emp6 = this.setEmployeeFields((Employee)this.session.newInstance(Employee.class, (Object)6));
        this.emp7 = this.setEmployeeFields((Employee)this.session.newInstance(DynamicEmployee.class, (Object)7));
        this.session.makePersistent((Object)new Employee[]{this.emp0, this.emp1, this.emp2, this.emp5, this.emp6, this.emp7});
        this.emp6 = null;
        this.emp7 = null;
        this.addTearDownClasses(Employee.class, DynamicEmployee.class);
    }

    void testGetId(Employee employee, String string) {
        try {
            employee.getId();
            this.error("getId for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message for " + string + ":" + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.error("getId for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testSetId(Employee employee, String string) {
        try {
            employee.setId(0);
            this.error("setId for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message for " + string + ":" + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.error("setId for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testMakePersistent(Employee employee, String string) {
        try {
            this.session.makePersistent((Object)employee);
            this.error("makePersistent for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message for " + string + ":" + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.error("makePersistent for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testSavePersistent(Employee employee, String string) {
        try {
            this.session.savePersistent((Object)employee);
            this.error("savePersistent for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message: " + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.error("savePersistent for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testUpdatePersistent(Employee employee, String string) {
        try {
            this.session.updatePersistent((Object)employee);
            this.error("getId for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message: " + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.error("updatePersistent for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testDeletePersistent(Employee employee, String string) {
        try {
            this.session.deletePersistent((Object)employee);
            this.error("deletePersistent for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message: " + string2, true, string2.contains("elease"));
            try {
                this.session.release((Object)employee);
            }
            catch (Throwable throwable) {
                this.error("release for " + string + " incorrectly threw exception " + throwable.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.error("deletePersistent for " + string + " threw wrong exception " + throwable.getMessage());
        }
    }

    void testNonPersistentRelease(Object object, String string) {
        try {
            this.session.release(object);
            this.error("release for " + string + " failed to throw ClusterJUserException");
        }
        catch (ClusterJUserException clusterJUserException) {
            String string2 = clusterJUserException.getMessage();
            this.errorIfNotEqual("wrong error message: " + string2, true, string2.contains("elease"));
        }
        catch (Throwable throwable) {
            this.error("release for Integer threw the wrong exception: " + throwable.getMessage());
        }
    }

    protected void testReleaseNull() {
        try {
            this.session.release(null);
            this.error("release null failed to throw ClusterJUserException.");
        }
        catch (Throwable throwable) {
            String string = throwable.getMessage();
            this.errorIfNotEqual("wrong error message: " + string, true, string.contains("elease"));
        }
    }

    protected void testReleaseStatic() {
        Employee employee = (Employee)this.session.release((Object)this.emp0);
        if (employee != this.emp0) {
            this.error("for static object, result of release does not equal parameter.");
        }
        this.testGetId(this.emp0, "static object");
        this.testSetId(this.emp0, "static object");
        this.testMakePersistent(this.emp0, "static object");
        this.testSavePersistent(this.emp0, "static object");
        this.testUpdatePersistent(this.emp0, "static object");
        this.testDeletePersistent(this.emp0, "static object");
    }

    protected void testReleaseDynamic() {
        Employee employee = (Employee)this.session.release((Object)this.emp1);
        if (employee != this.emp1) {
            this.error("for dynamic object, result of release does not equal parameter.");
        }
        this.testGetId(this.emp1, "dynamic object");
        this.testSetId(this.emp1, "dynamic object");
        this.testMakePersistent(this.emp1, "dynamic object");
        this.testSavePersistent(this.emp1, "dynamic object");
        this.testUpdatePersistent(this.emp1, "dynamic object");
        this.testDeletePersistent(this.emp1, "dynamic object");
    }

    protected void testReleaseIterable() {
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        arrayList.add(this.emp2);
        arrayList.add(this.emp3);
        List list = null;
        try {
            list = (List)this.session.release(arrayList);
        }
        catch (Throwable throwable) {
            System.out.println("ReleaseTest.testReleaseIterable threw this exception:");
            throwable.printStackTrace();
        }
        if (arrayList != list) {
            this.error("session.release list did not return argument");
        }
        this.testGetId(this.emp2, "static object in list");
        this.testSetId(this.emp2, "static object in list");
        this.testMakePersistent(this.emp2, "static object in list");
        this.testSavePersistent(this.emp2, "static object in list");
        this.testUpdatePersistent(this.emp2, "static object in list");
        this.testDeletePersistent(this.emp2, "static object in list");
        this.testGetId(this.emp3, "dynamic object in list");
        this.testSetId(this.emp3, "dynamic object in list");
        this.testMakePersistent(this.emp3, "dynamic object in list");
        this.testSavePersistent(this.emp3, "dynamic object in list");
        this.testUpdatePersistent(this.emp3, "dynamic object in list");
        this.testDeletePersistent(this.emp3, "dynamic object in list");
    }

    protected void testReleaseArray() {
        Employee[] employeeArray = new Employee[]{this.emp4, this.emp5};
        Employee[] employeeArray2 = null;
        try {
            employeeArray2 = (Employee[])this.session.release((Object)employeeArray);
        }
        catch (Throwable throwable) {
            System.out.println("ReleaseTest.testReleaseArray threw this exception:");
            throwable.printStackTrace();
        }
        if (employeeArray != employeeArray2) {
            this.error("session.release array did not return argument");
        }
        this.testGetId(this.emp4, "static object in array");
        this.testSetId(this.emp4, "static object in array");
        this.testMakePersistent(this.emp4, "static object in array");
        this.testSavePersistent(this.emp4, "static object in array");
        this.testUpdatePersistent(this.emp4, "static object in array");
        this.testDeletePersistent(this.emp4, "static object in array");
        this.testGetId(this.emp5, "dynamic object in array");
        this.testSetId(this.emp5, "dynamic object in array");
        this.testMakePersistent(this.emp5, "dynamic object in array");
        this.testSavePersistent(this.emp5, "dynamic object in array");
        this.testUpdatePersistent(this.emp5, "dynamic object in array");
        this.testDeletePersistent(this.emp5, "dynamic object in array");
    }

    protected void testReleaseNonPersistent() {
        this.testNonPersistentRelease(1, "Integer.valueOf(1)");
        this.testNonPersistentRelease(new Integer[]{1, 2}, "new Integer[] {1, 2}");
    }

    protected void testReleaseFoundStatic() {
        this.emp6 = (Employee)this.session.find(Employee.class, (Object)6);
        this.session.release((Object)this.emp6);
        this.testGetId(this.emp6, "static found object");
        this.testSetId(this.emp6, "static found object");
        this.testMakePersistent(this.emp6, "static found object");
        this.testSavePersistent(this.emp6, "static found object");
        this.testUpdatePersistent(this.emp6, "static found object");
        this.testDeletePersistent(this.emp6, "static found object");
    }

    protected void testReleaseFoundDynamic() {
        this.emp7 = (Employee)this.session.find(DynamicEmployee.class, (Object)7);
        this.session.release((Object)this.emp7);
        this.testGetId(this.emp7, "dynamic found object");
        this.testSetId(this.emp7, "dynamic found object");
        this.testMakePersistent(this.emp7, "dynamic found object");
        this.testSavePersistent(this.emp7, "dynamic found object");
        this.testUpdatePersistent(this.emp7, "dynamic found object");
        this.testDeletePersistent(this.emp7, "dynamic found object");
    }

    protected void testReleaseQueryStatic() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id_low");
        PredicateOperand predicateOperand2 = queryDomainType.param("id_high");
        PredicateOperand predicateOperand3 = queryDomainType.get("id");
        Predicate predicate = predicateOperand3.between(predicateOperand, predicateOperand2);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id_low", (Object)0);
        query.setParameter("id_high", (Object)2);
        List list = query.getResultList();
        this.errorIfNotEqual("Static query wrong result size", 3, list.size());
        this.session.release((Object)list);
        for (Employee employee : list) {
            this.testGetId(employee, "static query object");
            this.testSetId(employee, "static query object");
            this.testMakePersistent(employee, "static query object");
            this.testSavePersistent(employee, "static query object");
            this.testUpdatePersistent(employee, "static query object");
            this.testDeletePersistent(employee, "static query object");
        }
    }

    protected void testReleaseQueryDynamic() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(DynamicEmployee.class);
        PredicateOperand predicateOperand = queryDomainType.param("id_low");
        PredicateOperand predicateOperand2 = queryDomainType.param("id_high");
        PredicateOperand predicateOperand3 = queryDomainType.get("id");
        Predicate predicate = predicateOperand3.between(predicateOperand, predicateOperand2);
        queryDomainType.where(predicate);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("id_low", (Object)0);
        query.setParameter("id_high", (Object)2);
        List list = query.getResultList();
        this.errorIfNotEqual("Dynamic query wrong result size", 3, list.size());
        this.session.release((Object)list);
        for (Employee employee : list) {
            this.testGetId(employee, "dynamic query object");
            this.testSetId(employee, "dynamic query object");
            this.testMakePersistent(employee, "dynamic query object");
            this.testSavePersistent(employee, "dynamic query object");
            this.testUpdatePersistent(employee, "dynamic query object");
            this.testDeletePersistent(employee, "dynamic query object");
        }
    }

    public static class DynamicEmployee
    extends DynamicObject
    implements Employee {
        public String table() {
            return "t_basic";
        }

        @Override
        public int getId() {
            return (Integer)this.get(0);
        }

        @Override
        public void setId(int n) {
            this.set(0, n);
        }

        @Override
        public String getName() {
            return (String)this.get(1);
        }

        @Override
        public void setName(String string) {
            this.set(1, string);
        }

        @Override
        public int getMagic() {
            return (Integer)this.get(2);
        }

        @Override
        public void setMagic(int n) {
            this.set(2, n);
        }

        @Override
        public Integer getAge() {
            return (Integer)this.get(3);
        }

        @Override
        public void setAge(Integer n) {
            this.set(3, n);
        }
    }
}

