/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core.util;

import com.mysql.clusterj.core.util.JDK14LoggerImpl;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;

public class JDK14LoggerFactoryImpl
implements LoggerFactory {
    public static final String CLUSTERJ_LOGGER = "com.mysql.clusterj.core";
    public static final String CLUSTERJ_METADATA_LOGGER = "com.mysql.clusterj.core.metadata";
    public static final String CLUSTERJ_UTIL_LOGGER = "com.mysql.clusterj.core.util";
    public static final String CLUSTERJ_QUERY_LOGGER = "com.mysql.clusterj.core.query";
    static final LogManager logManager = LogManager.getLogManager();
    static final Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    public JDK14LoggerFactoryImpl() {
        this.registerLogger(CLUSTERJ_LOGGER);
        this.registerLogger(CLUSTERJ_METADATA_LOGGER);
        this.registerLogger(CLUSTERJ_QUERY_LOGGER);
        this.registerLogger(CLUSTERJ_UTIL_LOGGER);
    }

    @Override
    public Logger registerLogger(String string) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(string);
        JDK14LoggerImpl jDK14LoggerImpl = new JDK14LoggerImpl(logger);
        loggerMap.put(string, jDK14LoggerImpl);
        return jDK14LoggerImpl;
    }

    public Logger getInstance(Class clazz) {
        String string = JDK14LoggerFactoryImpl.getPackageName(clazz);
        return this.getInstance(string);
    }

    @Override
    public synchronized Logger getInstance(String string) {
        Logger logger = loggerMap.get(string);
        if (logger == null) {
            logger = this.registerLogger(string);
        }
        return logger;
    }

    private static final String getPackageName(Class<?> clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }
}

