/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.mysql.CharsetMap;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;

class ColumnImpl
implements Column {
    static final I18NHelper local = I18NHelper.getInstance(ColumnImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ColumnImpl.class);
    static final CharsetMap charsetMap = Utility.getCharsetMap();
    private String nativeCharsetName;
    private String charsetName;
    private int charsetNumber = 0;
    private ColumnType columnType;
    private int prefixLength = -1;
    private int columnSpace = 0;
    private String columnName;
    private String tableName;
    private int columnId;
    private boolean primaryKey;
    private boolean partitionKey;
    private int length;
    private int inlineSize;
    private int precision;
    private int scale;
    private int size;
    private boolean nullable;
    private boolean lob = false;

    public ColumnImpl(String string, NdbDictionary.ColumnConst columnConst) {
        this.columnName = columnConst.getName();
        this.columnId = columnConst.getColumnNo();
        this.tableName = string;
        int n = columnConst.getType();
        this.columnType = this.convertType(n);
        this.primaryKey = columnConst.getPrimaryKey();
        this.partitionKey = columnConst.getPartitionKey();
        this.nullable = columnConst.getNullable();
        this.length = columnConst.getLength();
        this.inlineSize = columnConst.getInlineSize();
        this.precision = columnConst.getPrecision();
        this.scale = columnConst.getScale();
        this.size = columnConst.getSize();
        if (logger.isDetailEnabled()) {
            logger.detail("ColumnImpl column type: " + (Object)((Object)this.columnType));
        }
        switch (columnConst.getType()) {
            case 1: 
            case 2: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 3: 
            case 4: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 5: 
            case 6: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 7: 
            case 8: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 9: 
            case 10: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 11: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 12: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 13: 
            case 28: 
            case 29: 
            case 30: {
                this.prefixLength = 0;
                this.columnSpace = this.alignTo4(Utility.getDecimalColumnSpace(this.precision, this.scale));
                break;
            }
            case 14: {
                this.prefixLength = 0;
                this.columnSpace = this.length;
                this.charsetNumber = columnConst.getCharsetNumber();
                this.mapCharsetName();
                break;
            }
            case 15: {
                this.prefixLength = 1;
                this.columnSpace = this.alignTo4(this.length + this.prefixLength);
                this.charsetNumber = columnConst.getCharsetNumber();
                this.mapCharsetName();
                break;
            }
            case 16: {
                this.prefixLength = 0;
                this.columnSpace = this.length;
                break;
            }
            case 17: {
                this.prefixLength = 1;
                this.columnSpace = this.alignTo4(this.length + this.prefixLength);
                break;
            }
            case 18: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 19: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 20: {
                this.prefixLength = 0;
                this.columnSpace = 8;
                this.lob = true;
                break;
            }
            case 21: {
                this.prefixLength = 0;
                this.columnSpace = 8;
                this.charsetNumber = columnConst.getCharsetNumber();
                this.lob = true;
                this.mapCharsetName();
                break;
            }
            case 22: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 23: {
                this.prefixLength = 2;
                this.columnSpace = this.alignTo4(this.length + this.prefixLength);
                this.charsetNumber = columnConst.getCharsetNumber();
                this.mapCharsetName();
                break;
            }
            case 24: {
                this.prefixLength = 2;
                this.columnSpace = this.alignTo4(this.length + this.prefixLength);
                break;
            }
            case 25: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 26: {
                this.prefixLength = 0;
                this.columnSpace = 4;
                break;
            }
            case 27: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 31: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 32: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            case 33: {
                this.prefixLength = 0;
                this.columnSpace = 0;
                break;
            }
            default: {
                String string2 = local.message("ERR_Unknown_Column_Type", string, columnConst.getName(), n);
                logger.warn(string2);
                throw new ClusterJFatalInternalException(string2);
            }
        }
        if (logger.isDetailEnabled()) {
            logger.detail("Column " + this.columnName + " columnSpace: " + this.columnSpace + " prefixLength: " + this.prefixLength + " inlineSize: " + this.inlineSize + " length: " + this.length + " size: " + this.size + " charsetNumber: " + this.charsetNumber + " charsetName: " + this.charsetName + " nativeCharsetNumber: " + this.nativeCharsetName);
        }
    }

    private int alignTo4(int n) {
        int n2 = 4 - n % 4 % 4;
        int n3 = n + n2;
        return n3;
    }

    private void mapCharsetName() {
        this.nativeCharsetName = charsetMap.getName(this.charsetNumber);
        this.charsetName = charsetMap.getMysqlName(this.charsetNumber);
        if (this.charsetName == null) {
            throw new ClusterJDatastoreException(local.message("ERR_Unknown_Charset_Name", this.tableName, this.columnName, this.nativeCharsetName));
        }
    }

    @Override
    public ColumnType getType() {
        return this.columnType;
    }

    private ColumnType convertType(int n) {
        switch (n) {
            case 9: {
                return ColumnType.Bigint;
            }
            case 10: {
                return ColumnType.Bigunsigned;
            }
            case 16: {
                return ColumnType.Binary;
            }
            case 22: {
                return ColumnType.Bit;
            }
            case 20: {
                return ColumnType.Blob;
            }
            case 14: {
                return ColumnType.Char;
            }
            case 19: {
                return ColumnType.Date;
            }
            case 18: {
                return ColumnType.Datetime;
            }
            case 29: {
                return ColumnType.Decimal;
            }
            case 30: {
                return ColumnType.Decimalunsigned;
            }
            case 12: {
                return ColumnType.Double;
            }
            case 11: {
                return ColumnType.Float;
            }
            case 7: {
                return ColumnType.Int;
            }
            case 24: {
                return ColumnType.Longvarbinary;
            }
            case 23: {
                return ColumnType.Longvarchar;
            }
            case 5: {
                return ColumnType.Mediumint;
            }
            case 6: {
                return ColumnType.Mediumunsigned;
            }
            case 13: {
                return ColumnType.Olddecimal;
            }
            case 28: {
                return ColumnType.Olddecimalunsigned;
            }
            case 3: {
                return ColumnType.Smallint;
            }
            case 4: {
                return ColumnType.Smallunsigned;
            }
            case 21: {
                return ColumnType.Text;
            }
            case 25: {
                return ColumnType.Time;
            }
            case 27: {
                return ColumnType.Timestamp;
            }
            case 1: {
                return ColumnType.Tinyint;
            }
            case 2: {
                return ColumnType.Tinyunsigned;
            }
            case 0: {
                return ColumnType.Undefined;
            }
            case 8: {
                return ColumnType.Unsigned;
            }
            case 17: {
                return ColumnType.Varbinary;
            }
            case 15: {
                return ColumnType.Varchar;
            }
            case 26: {
                return ColumnType.Year;
            }
            case 31: {
                return ColumnType.Time2;
            }
            case 32: {
                return ColumnType.Datetime2;
            }
            case 33: {
                return ColumnType.Timestamp2;
            }
        }
        String string = local.message("ERR_Unknown_Column_Type", this.tableName, this.columnName, n);
        logger.warn(string);
        throw new ClusterJFatalInternalException(string);
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public String getName() {
        return this.columnName;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrefixLength() {
        if (this.prefixLength != -1) {
            return this.prefixLength;
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Prefix_Length_Not_Defined", (Object)this.tableName, (Object)this.columnName));
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getColumnId() {
        return this.columnId;
    }

    @Override
    public int getColumnSpace() {
        return this.columnSpace;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public int getCharsetNumber() {
        return this.charsetNumber;
    }

    @Override
    public String decode(byte[] byArray) {
        return Utility.decode(byArray, this.charsetNumber);
    }

    @Override
    public byte[] encode(String string) {
        return Utility.encode(string, this.charsetNumber);
    }

    public String toString() {
        return this.columnName;
    }

    @Override
    public boolean getNullable() {
        return this.nullable;
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }
}

