/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.math.BigInteger;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.BigIntegerTypes;
import testsuite.clusterj.model.IdBase;

public class QueryBigIntegerTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return BigIntegerTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllBigIntegerTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanDecimal();
        this.hashIndexScanDecimal();
        this.bothIndexScanDecimal();
        this.noneIndexScanDecimal();
        this.failOnError();
    }

    public void btreeIndexScanDecimal() {
        this.equalQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_btree", "idx_decimal_null_btree", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void hashIndexScanDecimal() {
        this.equalQuery("decimal_null_hash", "idx_decimal_null_hash", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_hash", "none", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_hash", "none", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_hash", "none", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void bothIndexScanDecimal() {
        this.equalQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_both", "idx_decimal_null_both", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    public void noneIndexScanDecimal() {
        this.equalQuery("decimal_null_none", "none", this.getBigInteger(8), 8);
        this.greaterEqualQuery("decimal_null_none", "none", this.getBigInteger(7), 7, 8, 9);
        this.greaterThanQuery("decimal_null_none", "none", this.getBigInteger(6), 7, 8, 9);
        this.lessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("decimal_null_none", "none", this.getBigInteger(4), 3, 2, 1, 0);
        this.betweenQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 5, 6);
        this.greaterEqualAndLessThanQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 4, 5);
        this.greaterThanAndLessThanQuery("decimal_null_none", "none", this.getBigInteger(4), this.getBigInteger(6), 5);
    }

    private void createAllBigIntegerTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            BigIntegerTypes bigIntegerTypes = (BigIntegerTypes)this.session.newInstance(BigIntegerTypes.class);
            bigIntegerTypes.setId(i);
            bigIntegerTypes.setDecimal_null_hash(this.getBigInteger(i));
            bigIntegerTypes.setDecimal_null_btree(this.getBigInteger(i));
            bigIntegerTypes.setDecimal_null_both(this.getBigInteger(i));
            bigIntegerTypes.setDecimal_null_none(this.getBigInteger(i));
            this.instances.add(bigIntegerTypes);
        }
    }

    protected BigInteger getBigInteger(int n) {
        return BigInteger.valueOf(n * 10000);
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof BigIntegerTypes) {
            BigIntegerTypes bigIntegerTypes = (BigIntegerTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        BigIntegerTypes bigIntegerTypes = (BigIntegerTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("BigIntegerTypes id: ");
        stringBuffer.append(bigIntegerTypes.getId());
        stringBuffer.append("; decimal_null_both: ");
        stringBuffer.append(bigIntegerTypes.getDecimal_null_both().toString());
        stringBuffer.append("; decimal_null_btree: ");
        stringBuffer.append(bigIntegerTypes.getDecimal_null_btree().toString());
        stringBuffer.append("; decimal_null_hash: ");
        stringBuffer.append(bigIntegerTypes.getDecimal_null_hash().toString());
        stringBuffer.append("; decimal_null_none: ");
        stringBuffer.append(bigIntegerTypes.getDecimal_null_none().toString());
        return stringBuffer.toString();
    }
}

