/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.ByteArrayTypes;
import testsuite.clusterj.model.IdBase;

public class QueryByteArrayTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return ByteArrayTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllByteArrayTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanByteArray();
        this.hashIndexScanByteArray();
        this.bothIndexScanByteArray();
        this.noneIndexScanByteArray();
        this.failOnError();
    }

    public void btreeIndexScanByteArray() {
        this.equalQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_btree", "idx_bytes_null_btree", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void hashIndexScanByteArray() {
        this.equalQuery("bytes_null_hash", "idx_bytes_null_hash", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_hash", "none", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_hash", "none", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_hash", "none", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_hash", "none", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void bothIndexScanByteArray() {
        this.equalQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_both", "idx_bytes_null_both", this.getByteArray(4), this.getByteArray(6), 5);
    }

    public void noneIndexScanByteArray() {
        this.equalQuery("bytes_null_none", "none", this.getByteArray(8), 8);
        this.greaterEqualQuery("bytes_null_none", "none", this.getByteArray(7), 7, 8, 9);
        this.greaterThanQuery("bytes_null_none", "none", this.getByteArray(6), 7, 8, 9);
        this.lessEqualQuery("bytes_null_none", "none", this.getByteArray(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("bytes_null_none", "none", this.getByteArray(4), 3, 2, 1, 0);
        this.betweenQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 5, 6);
        this.greaterEqualAndLessThanQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 4, 5);
        this.greaterThanAndLessThanQuery("bytes_null_none", "none", this.getByteArray(4), this.getByteArray(6), 5);
    }

    private void createAllByteArrayTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            ByteArrayTypes byteArrayTypes = (ByteArrayTypes)this.session.newInstance(ByteArrayTypes.class);
            byteArrayTypes.setId(i);
            byteArrayTypes.setBytes_null_hash(this.getByteArray(i));
            byteArrayTypes.setBytes_null_btree(this.getByteArray(i));
            byteArrayTypes.setBytes_null_both(this.getByteArray(i));
            byteArrayTypes.setBytes_null_none(this.getByteArray(i));
            this.instances.add(byteArrayTypes);
        }
    }

    protected byte[] getByteArray(int n) {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, (byte)n};
    }

    public static String toString(IdBase idBase) {
        ByteArrayTypes byteArrayTypes = (ByteArrayTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("ByteArrayTypes id: ");
        stringBuffer.append(byteArrayTypes.getId());
        stringBuffer.append("; bytes_null_both: ");
        stringBuffer.append(byteArrayTypes.getBytes_null_both().toString());
        stringBuffer.append("; bytes_null_btree: ");
        stringBuffer.append(byteArrayTypes.getBytes_null_btree().toString());
        stringBuffer.append("; bytes_null_hash: ");
        stringBuffer.append(byteArrayTypes.getBytes_null_hash().toString());
        stringBuffer.append("; bytes_null_none: ");
        stringBuffer.append(byteArrayTypes.getBytes_null_none().toString());
        return stringBuffer.toString();
    }
}

