/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.Timestamp;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DatetimeAsSqlTimestampTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDatetimeAsSqlTimestampTypesTest
extends AbstractQueryTest {
    public Class<DatetimeAsSqlTimestampTypes> getInstanceType() {
        return DatetimeAsSqlTimestampTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllDateTimeTypesInstances(n);
    }

    @Override
    protected void consistencyCheck(IdBase idBase) {
        DatetimeAsSqlTimestampTypes datetimeAsSqlTimestampTypes = (DatetimeAsSqlTimestampTypes)idBase;
        Timestamp timestamp = this.getDateTimeFor(datetimeAsSqlTimestampTypes.getId());
        String string = "Wrong values retrieved from ";
        this.errorIfNotEqual(string + "datetime_not_null_both", timestamp, datetimeAsSqlTimestampTypes.getDatetime_not_null_both());
        this.errorIfNotEqual(string + "datetime_not_null_btree", timestamp, datetimeAsSqlTimestampTypes.getDatetime_not_null_btree());
        this.errorIfNotEqual(string + "datetime_not_null_hash", timestamp, datetimeAsSqlTimestampTypes.getDatetime_not_null_hash());
        this.errorIfNotEqual(string + "datetime_not_null_none", timestamp, datetimeAsSqlTimestampTypes.getDatetime_not_null_none());
    }

    public void test() {
        this.btreeIndexScanDateTime();
        this.hashIndexScanDateTime();
        this.bothIndexScanDateTime();
        this.noneIndexScanDateTime();
        this.failOnError();
    }

    public void btreeIndexScanDateTime() {
        this.equalQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(8), 8);
        this.greaterEqualQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), this.getDateTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("datetime_not_null_btree", "idx_datetime_not_null_btree", this.getDateTimeFor(4), this.getDateTimeFor(6), 5);
    }

    public void hashIndexScanDateTime() {
        this.equalQuery("datetime_not_null_hash", "idx_datetime_not_null_hash", this.getDateTimeFor(8), 8);
        this.greaterEqualQuery("datetime_not_null_hash", "none", this.getDateTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("datetime_not_null_hash", "none", this.getDateTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("datetime_not_null_hash", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 5);
    }

    public void bothIndexScanDateTime() {
        this.equalQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(8), 8);
        this.greaterEqualQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), this.getDateTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("datetime_not_null_both", "idx_datetime_not_null_both", this.getDateTimeFor(4), this.getDateTimeFor(6), 5);
    }

    public void noneIndexScanDateTime() {
        this.equalQuery("datetime_not_null_none", "none", this.getDateTimeFor(8), 8);
        this.greaterEqualQuery("datetime_not_null_none", "none", this.getDateTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("datetime_not_null_none", "none", this.getDateTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("datetime_not_null_none", "none", this.getDateTimeFor(4), this.getDateTimeFor(6), 5);
    }

    private void createAllDateTimeTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            DatetimeAsSqlTimestampTypes datetimeAsSqlTimestampTypes = (DatetimeAsSqlTimestampTypes)this.session.newInstance(DatetimeAsSqlTimestampTypes.class);
            datetimeAsSqlTimestampTypes.setId(i);
            datetimeAsSqlTimestampTypes.setDatetime_not_null_hash(this.getDateTimeFor(i));
            datetimeAsSqlTimestampTypes.setDatetime_not_null_btree(this.getDateTimeFor(i));
            datetimeAsSqlTimestampTypes.setDatetime_not_null_both(this.getDateTimeFor(i));
            datetimeAsSqlTimestampTypes.setDatetime_not_null_none(this.getDateTimeFor(i));
            this.instances.add(datetimeAsSqlTimestampTypes);
        }
    }

    protected Timestamp getDateTimeFor(int n) {
        return new Timestamp(QueryDatetimeAsSqlTimestampTypesTest.getMillisFor(1980, 0, 1, 0, 0, n));
    }

    public static String toString(IdBase idBase) {
        DatetimeAsSqlTimestampTypes datetimeAsSqlTimestampTypes = (DatetimeAsSqlTimestampTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("DateTimeTypes id: ");
        stringBuffer.append(datetimeAsSqlTimestampTypes.getId());
        stringBuffer.append("; datetime_not_null_both: ");
        stringBuffer.append(datetimeAsSqlTimestampTypes.getDatetime_not_null_both().toString());
        stringBuffer.append("; datetime_not_null_btree: ");
        stringBuffer.append(datetimeAsSqlTimestampTypes.getDatetime_not_null_btree().toString());
        stringBuffer.append("; datetime_not_null_hash: ");
        stringBuffer.append(datetimeAsSqlTimestampTypes.getDatetime_not_null_hash().toString());
        stringBuffer.append("; datetime_not_null_none: ");
        stringBuffer.append(datetimeAsSqlTimestampTypes.getDatetime_not_null_none().toString());
        return stringBuffer.toString();
    }
}

