/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.FloatTypes;
import testsuite.clusterj.model.IdBase;

public class QueryFloatTypesTest
extends AbstractQueryTest {
    public Class getInstanceType() {
        return FloatTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllFloatTypesInstances(n);
    }

    public void test() {
        this.btreeIndexScanFloat();
        this.hashIndexScanFloat();
        this.bothIndexScanFloat();
        this.noneIndexScanFloat();
        this.failOnError();
    }

    public void btreeIndexScanFloat() {
        this.equalQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(8), 8);
        this.greaterEqualQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_not_null_btree", "idx_float_not_null_btree", this.getFloat(4), this.getFloat(6), 5);
        this.equalQuery("float_null_btree", "idx_float_null_btree", this.getFloat(8), 8);
        this.greaterEqualQuery("float_null_btree", "idx_float_null_btree", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_null_btree", "idx_float_null_btree", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_null_btree", "idx_float_null_btree", this.getFloat(4), this.getFloat(6), 5);
    }

    public void hashIndexScanFloat() {
        this.equalQuery("float_not_null_hash", "idx_float_not_null_hash", this.getFloat(8), 8);
        this.greaterEqualQuery("float_not_null_hash", "none", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_not_null_hash", "none", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_not_null_hash", "none", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_not_null_hash", "none", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_not_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_not_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_not_null_hash", "none", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_not_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_not_null_hash", "none", this.getFloat(4), this.getFloat(6), 5);
        this.equalQuery("float_null_hash", "idx_float_null_hash", this.getFloat(8), 8);
        this.greaterEqualQuery("float_null_hash", "none", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_null_hash", "none", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_null_hash", "none", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_null_hash", "none", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_null_hash", "none", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_null_hash", "none", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_null_hash", "none", this.getFloat(4), this.getFloat(6), 5);
    }

    public void bothIndexScanFloat() {
        this.equalQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(8), 8);
        this.greaterEqualQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_not_null_both", "idx_float_not_null_both", this.getFloat(4), this.getFloat(6), 5);
        this.equalQuery("float_null_both", "idx_float_null_both", this.getFloat(8), 8);
        this.greaterEqualQuery("float_null_both", "idx_float_null_both", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_null_both", "idx_float_null_both", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_null_both", "idx_float_null_both", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_null_both", "idx_float_null_both", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_null_both", "idx_float_null_both", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_null_both", "idx_float_null_both", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_null_both", "idx_float_null_both", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_null_both", "idx_float_null_both", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_null_both", "idx_float_null_both", this.getFloat(4), this.getFloat(6), 5);
    }

    public void noneIndexScanFloat() {
        this.equalQuery("float_not_null_none", "none", this.getFloat(8), 8);
        this.greaterEqualQuery("float_not_null_none", "none", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_not_null_none", "none", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_not_null_none", "none", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_not_null_none", "none", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_not_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_not_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_not_null_none", "none", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_not_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_not_null_none", "none", this.getFloat(4), this.getFloat(6), 5);
        this.equalQuery("float_null_none", "none", this.getFloat(8), 8);
        this.greaterEqualQuery("float_null_none", "none", this.getFloat(7), 7, 8, 9);
        this.greaterThanQuery("float_null_none", "none", this.getFloat(6), 7, 8, 9);
        this.lessEqualQuery("float_null_none", "none", this.getFloat(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("float_null_none", "none", this.getFloat(4), 3, 2, 1, 0);
        this.betweenQuery("float_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("float_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("float_null_none", "none", this.getFloat(4), this.getFloat(6), 5, 6);
        this.greaterEqualAndLessThanQuery("float_null_none", "none", this.getFloat(4), this.getFloat(6), 4, 5);
        this.greaterThanAndLessThanQuery("float_null_none", "none", this.getFloat(4), this.getFloat(6), 5);
    }

    private void createAllFloatTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            FloatTypes floatTypes = (FloatTypes)this.session.newInstance(FloatTypes.class);
            floatTypes.setId(i);
            floatTypes.setFloat_not_null_hash(this.getFloat(i).floatValue());
            floatTypes.setFloat_not_null_btree(this.getFloat(i).floatValue());
            floatTypes.setFloat_not_null_both(this.getFloat(i).floatValue());
            floatTypes.setFloat_not_null_none(this.getFloat(i).floatValue());
            floatTypes.setFloat_null_hash(this.getFloat(i));
            floatTypes.setFloat_null_btree(this.getFloat(i));
            floatTypes.setFloat_null_both(this.getFloat(i));
            floatTypes.setFloat_null_none(this.getFloat(i));
            this.instances.add(floatTypes);
        }
    }

    protected Float getFloat(int n) {
        return Float.valueOf(1.0E-5f * (float)n);
    }

    @Override
    protected void printResultInstance(IdBase idBase) {
        if (idBase instanceof FloatTypes) {
            FloatTypes floatTypes = (FloatTypes)idBase;
        }
    }

    public static String toString(IdBase idBase) {
        FloatTypes floatTypes = (FloatTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("FloatTypes id: ");
        stringBuffer.append(floatTypes.getId());
        stringBuffer.append("; float_not_null_both: ");
        stringBuffer.append(floatTypes.getFloat_not_null_both());
        stringBuffer.append("; float_not_null_btree: ");
        stringBuffer.append(floatTypes.getFloat_not_null_btree());
        stringBuffer.append("; float_not_null_hash: ");
        stringBuffer.append(floatTypes.getFloat_not_null_hash());
        stringBuffer.append("; float_not_null_none: ");
        stringBuffer.append(floatTypes.getFloat_not_null_none());
        stringBuffer.append("; float_null_both: ");
        stringBuffer.append(floatTypes.getFloat_null_both().toString());
        stringBuffer.append("; float_null_btree: ");
        stringBuffer.append(floatTypes.getFloat_null_btree().toString());
        stringBuffer.append("; float_null_hash: ");
        stringBuffer.append(floatTypes.getFloat_null_hash().toString());
        stringBuffer.append("; float_null_none: ");
        stringBuffer.append(floatTypes.getFloat_null_none().toString());
        return stringBuffer.toString();
    }
}

