# $OpenBSD: fortran.port.mk,v 1.15 2019/01/14 21:27:37 pascal Exp $

MODFORTRAN_COMPILER ?= g77

.if empty(MODFORTRAN_COMPILER)
ERRORS += "Fatal: need to specify MODFORTRAN_COMPILER"
.endif

.if ${MODFORTRAN_COMPILER:L} == "g77"
MODFORTRAN_BUILD_DEPENDS += lang/g77 devel/libf2c
MODFORTRAN_LIB_DEPENDS += devel/libf2c
MODFORTRAN_WANTLIB += g2c
.elif ${MODFORTRAN_COMPILER:L} == "gfortran"
MODULES += gcc4
MODGCC4_ARCHS ?= *
MODGCC4_LANGS += fortran
MODFORTRAN_BUILD_DEPENDS += ${MODGCC4_FORTRANDEP}
MODFORTRAN_LIB_DEPENDS += ${MODGCC4_FORTRANLIBDEP}
MODFORTRAN_WANTLIB += ${MODGCC4_FORTRANWANTLIB}
.else
ERRORS += "Fatal: MODFORTRAN_COMPILER must be one of: g77 gfortran"
.endif
