/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class MaterializedResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow materializedRowBuffer;
    protected long materializedCID;
    public boolean materializedCreated;
    private boolean fromSource = true;
    protected ConglomerateController materializedCC;
    protected ScanController materializedScan;
    private TransactionController tc;
    private boolean sourceDrained;
    public long createTCTime;
    public long fetchTCTime;

    public MaterializedResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.tc = activation.getTransactionController();
        this.recordConstructorTime();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        boolean bl = true;
        this.beginTime = this.getCurrentTimeMillis();
        while (!this.sourceDrained) {
            this.getNextRowFromSource();
        }
        this.fromSource = false;
        if (this.materializedScan != null) {
            this.materializedScan.close();
        }
        if (this.materializedCID != 0L) {
            this.materializedScan = this.tc.openScan(this.materializedCID, false, 0, 7, 5, null, null, 0, null, null, 0);
            this.isOpen = true;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow execRow = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        execRow = this.fromSource ? this.getNextRowFromSource() : this.getNextRowFromTempTable();
        if (execRow != null) {
            ++this.rowsSeen;
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        if (this.sourceDrained) {
            return null;
        }
        ExecRow execRow = null;
        Object var2_2 = null;
        execRow = this.source.getNextRowCore();
        if (execRow != null) {
            long l = this.getCurrentTimeMillis();
            if (this.materializedRowBuffer == null) {
                this.materializedRowBuffer = execRow.getClone();
                this.tc = this.activation.getTransactionController();
                this.materializedCID = this.tc.createConglomerate("heap", this.materializedRowBuffer.getRowArray(), null, null, null, 3);
                this.materializedCreated = true;
                this.materializedCC = this.tc.openConglomerate(this.materializedCID, false, 4, 7, 5);
            }
            this.materializedCC.insert(execRow.getRowArray());
            this.createTCTime += this.getElapsedMillis(l);
        } else {
            this.sourceDrained = true;
        }
        return execRow;
    }

    private ExecRow getNextRowFromTempTable() throws StandardException {
        long l = this.getCurrentTimeMillis();
        if (this.materializedScan != null && this.materializedScan.fetchNext(this.materializedRowBuffer.getRowArray())) {
            this.fetchTCTime += this.getElapsedMillis(l);
            return this.materializedRowBuffer;
        }
        return null;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            if (this.materializedScan != null) {
                this.materializedScan.close();
            }
            this.materializedScan = null;
            if (this.materializedCC != null) {
                this.materializedCC.close();
            }
            this.materializedCC = null;
            if (this.materializedCreated) {
                this.tc.dropConglomerate(this.materializedCID);
            }
            this.materializedCreated = false;
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }
}

