<?php
// This file was auto-generated from sdk-root/src/data/cloudformation/2010-05-15/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2010-05-15', 'endpointPrefix' => 'cloudformation', 'protocol' => 'query', 'serviceFullName' => 'AWS CloudFormation', 'serviceId' => 'CloudFormation', 'signatureVersion' => 'v4', 'uid' => 'cloudformation-2010-05-15', 'xmlNamespace' => 'http://cloudformation.amazonaws.com/doc/2010-05-15/', ], 'operations' => [ 'CancelUpdateStack' => [ 'name' => 'CancelUpdateStack', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelUpdateStackInput', ], 'errors' => [ [ 'shape' => 'TokenAlreadyExistsException', ], ], ], 'ContinueUpdateRollback' => [ 'name' => 'ContinueUpdateRollback', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ContinueUpdateRollbackInput', ], 'output' => [ 'shape' => 'ContinueUpdateRollbackOutput', 'resultWrapper' => 'ContinueUpdateRollbackResult', ], 'errors' => [ [ 'shape' => 'TokenAlreadyExistsException', ], ], ], 'CreateChangeSet' => [ 'name' => 'CreateChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateChangeSetInput', ], 'output' => [ 'shape' => 'CreateChangeSetOutput', 'resultWrapper' => 'CreateChangeSetResult', ], 'errors' => [ [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'InsufficientCapabilitiesException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'CreateStack' => [ 'name' => 'CreateStack', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateStackInput', ], 'output' => [ 'shape' => 'CreateStackOutput', 'resultWrapper' => 'CreateStackResult', ], 'errors' => [ [ 'shape' => 'LimitExceededException', ], [ 'shape' => 'AlreadyExistsException', ], [ 'shape' => 'TokenAlreadyExistsException', ], [ 'shape' => 'InsufficientCapabilitiesException', ], ], ], 'CreateStackInstances' => [ 'name' => 'CreateStackInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateStackInstancesInput', ], 'output' => [ 'shape' => 'CreateStackInstancesOutput', 'resultWrapper' => 'CreateStackInstancesResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationInProgressException', ], [ 'shape' => 'OperationIdAlreadyExistsException', ], [ 'shape' => 'StaleRequestException', ], [ 'shape' => 'InvalidOperationException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'CreateStackSet' => [ 'name' => 'CreateStackSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateStackSetInput', ], 'output' => [ 'shape' => 'CreateStackSetOutput', 'resultWrapper' => 'CreateStackSetResult', ], 'errors' => [ [ 'shape' => 'NameAlreadyExistsException', ], [ 'shape' => 'CreatedButModifiedException', ], [ 'shape' => 'LimitExceededException', ], ], ], 'DeleteChangeSet' => [ 'name' => 'DeleteChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteChangeSetInput', ], 'output' => [ 'shape' => 'DeleteChangeSetOutput', 'resultWrapper' => 'DeleteChangeSetResult', ], 'errors' => [ [ 'shape' => 'InvalidChangeSetStatusException', ], ], ], 'DeleteStack' => [ 'name' => 'DeleteStack', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteStackInput', ], 'errors' => [ [ 'shape' => 'TokenAlreadyExistsException', ], ], ], 'DeleteStackInstances' => [ 'name' => 'DeleteStackInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteStackInstancesInput', ], 'output' => [ 'shape' => 'DeleteStackInstancesOutput', 'resultWrapper' => 'DeleteStackInstancesResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationInProgressException', ], [ 'shape' => 'OperationIdAlreadyExistsException', ], [ 'shape' => 'StaleRequestException', ], [ 'shape' => 'InvalidOperationException', ], ], ], 'DeleteStackSet' => [ 'name' => 'DeleteStackSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteStackSetInput', ], 'output' => [ 'shape' => 'DeleteStackSetOutput', 'resultWrapper' => 'DeleteStackSetResult', ], 'errors' => [ [ 'shape' => 'StackSetNotEmptyException', ], [ 'shape' => 'OperationInProgressException', ], ], ], 'DeregisterType' => [ 'name' => 'DeregisterType', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeregisterTypeInput', ], 'output' => [ 'shape' => 'DeregisterTypeOutput', 'resultWrapper' => 'DeregisterTypeResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], [ 'shape' => 'TypeNotFoundException', ], ], 'idempotent' => true, ], 'DescribeAccountLimits' => [ 'name' => 'DescribeAccountLimits', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeAccountLimitsInput', ], 'output' => [ 'shape' => 'DescribeAccountLimitsOutput', 'resultWrapper' => 'DescribeAccountLimitsResult', ], ], 'DescribeChangeSet' => [ 'name' => 'DescribeChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeChangeSetInput', ], 'output' => [ 'shape' => 'DescribeChangeSetOutput', 'resultWrapper' => 'DescribeChangeSetResult', ], 'errors' => [ [ 'shape' => 'ChangeSetNotFoundException', ], ], ], 'DescribeStackDriftDetectionStatus' => [ 'name' => 'DescribeStackDriftDetectionStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackDriftDetectionStatusInput', ], 'output' => [ 'shape' => 'DescribeStackDriftDetectionStatusOutput', 'resultWrapper' => 'DescribeStackDriftDetectionStatusResult', ], ], 'DescribeStackEvents' => [ 'name' => 'DescribeStackEvents', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackEventsInput', ], 'output' => [ 'shape' => 'DescribeStackEventsOutput', 'resultWrapper' => 'DescribeStackEventsResult', ], ], 'DescribeStackInstance' => [ 'name' => 'DescribeStackInstance', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackInstanceInput', ], 'output' => [ 'shape' => 'DescribeStackInstanceOutput', 'resultWrapper' => 'DescribeStackInstanceResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'StackInstanceNotFoundException', ], ], ], 'DescribeStackResource' => [ 'name' => 'DescribeStackResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackResourceInput', ], 'output' => [ 'shape' => 'DescribeStackResourceOutput', 'resultWrapper' => 'DescribeStackResourceResult', ], ], 'DescribeStackResourceDrifts' => [ 'name' => 'DescribeStackResourceDrifts', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackResourceDriftsInput', ], 'output' => [ 'shape' => 'DescribeStackResourceDriftsOutput', 'resultWrapper' => 'DescribeStackResourceDriftsResult', ], ], 'DescribeStackResources' => [ 'name' => 'DescribeStackResources', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackResourcesInput', ], 'output' => [ 'shape' => 'DescribeStackResourcesOutput', 'resultWrapper' => 'DescribeStackResourcesResult', ], ], 'DescribeStackSet' => [ 'name' => 'DescribeStackSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackSetInput', ], 'output' => [ 'shape' => 'DescribeStackSetOutput', 'resultWrapper' => 'DescribeStackSetResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], ], ], 'DescribeStackSetOperation' => [ 'name' => 'DescribeStackSetOperation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStackSetOperationInput', ], 'output' => [ 'shape' => 'DescribeStackSetOperationOutput', 'resultWrapper' => 'DescribeStackSetOperationResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationNotFoundException', ], ], ], 'DescribeStacks' => [ 'name' => 'DescribeStacks', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeStacksInput', ], 'output' => [ 'shape' => 'DescribeStacksOutput', 'resultWrapper' => 'DescribeStacksResult', ], ], 'DescribeType' => [ 'name' => 'DescribeType', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeTypeInput', ], 'output' => [ 'shape' => 'DescribeTypeOutput', 'resultWrapper' => 'DescribeTypeResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], [ 'shape' => 'TypeNotFoundException', ], ], 'idempotent' => true, ], 'DescribeTypeRegistration' => [ 'name' => 'DescribeTypeRegistration', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeTypeRegistrationInput', ], 'output' => [ 'shape' => 'DescribeTypeRegistrationOutput', 'resultWrapper' => 'DescribeTypeRegistrationResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], ], 'idempotent' => true, ], 'DetectStackDrift' => [ 'name' => 'DetectStackDrift', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DetectStackDriftInput', ], 'output' => [ 'shape' => 'DetectStackDriftOutput', 'resultWrapper' => 'DetectStackDriftResult', ], ], 'DetectStackResourceDrift' => [ 'name' => 'DetectStackResourceDrift', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DetectStackResourceDriftInput', ], 'output' => [ 'shape' => 'DetectStackResourceDriftOutput', 'resultWrapper' => 'DetectStackResourceDriftResult', ], ], 'DetectStackSetDrift' => [ 'name' => 'DetectStackSetDrift', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DetectStackSetDriftInput', ], 'output' => [ 'shape' => 'DetectStackSetDriftOutput', 'resultWrapper' => 'DetectStackSetDriftResult', ], 'errors' => [ [ 'shape' => 'InvalidOperationException', ], [ 'shape' => 'OperationInProgressException', ], [ 'shape' => 'StackSetNotFoundException', ], ], ], 'EstimateTemplateCost' => [ 'name' => 'EstimateTemplateCost', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'EstimateTemplateCostInput', ], 'output' => [ 'shape' => 'EstimateTemplateCostOutput', 'resultWrapper' => 'EstimateTemplateCostResult', ], ], 'ExecuteChangeSet' => [ 'name' => 'ExecuteChangeSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ExecuteChangeSetInput', ], 'output' => [ 'shape' => 'ExecuteChangeSetOutput', 'resultWrapper' => 'ExecuteChangeSetResult', ], 'errors' => [ [ 'shape' => 'InvalidChangeSetStatusException', ], [ 'shape' => 'ChangeSetNotFoundException', ], [ 'shape' => 'InsufficientCapabilitiesException', ], [ 'shape' => 'TokenAlreadyExistsException', ], ], ], 'GetStackPolicy' => [ 'name' => 'GetStackPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetStackPolicyInput', ], 'output' => [ 'shape' => 'GetStackPolicyOutput', 'resultWrapper' => 'GetStackPolicyResult', ], ], 'GetTemplate' => [ 'name' => 'GetTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetTemplateInput', ], 'output' => [ 'shape' => 'GetTemplateOutput', 'resultWrapper' => 'GetTemplateResult', ], 'errors' => [ [ 'shape' => 'ChangeSetNotFoundException', ], ], ], 'GetTemplateSummary' => [ 'name' => 'GetTemplateSummary', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetTemplateSummaryInput', ], 'output' => [ 'shape' => 'GetTemplateSummaryOutput', 'resultWrapper' => 'GetTemplateSummaryResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], ], ], 'ListChangeSets' => [ 'name' => 'ListChangeSets', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListChangeSetsInput', ], 'output' => [ 'shape' => 'ListChangeSetsOutput', 'resultWrapper' => 'ListChangeSetsResult', ], ], 'ListExports' => [ 'name' => 'ListExports', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListExportsInput', ], 'output' => [ 'shape' => 'ListExportsOutput', 'resultWrapper' => 'ListExportsResult', ], ], 'ListImports' => [ 'name' => 'ListImports', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListImportsInput', ], 'output' => [ 'shape' => 'ListImportsOutput', 'resultWrapper' => 'ListImportsResult', ], ], 'ListStackInstances' => [ 'name' => 'ListStackInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStackInstancesInput', ], 'output' => [ 'shape' => 'ListStackInstancesOutput', 'resultWrapper' => 'ListStackInstancesResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], ], ], 'ListStackResources' => [ 'name' => 'ListStackResources', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStackResourcesInput', ], 'output' => [ 'shape' => 'ListStackResourcesOutput', 'resultWrapper' => 'ListStackResourcesResult', ], ], 'ListStackSetOperationResults' => [ 'name' => 'ListStackSetOperationResults', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStackSetOperationResultsInput', ], 'output' => [ 'shape' => 'ListStackSetOperationResultsOutput', 'resultWrapper' => 'ListStackSetOperationResultsResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationNotFoundException', ], ], ], 'ListStackSetOperations' => [ 'name' => 'ListStackSetOperations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStackSetOperationsInput', ], 'output' => [ 'shape' => 'ListStackSetOperationsOutput', 'resultWrapper' => 'ListStackSetOperationsResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], ], ], 'ListStackSets' => [ 'name' => 'ListStackSets', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStackSetsInput', ], 'output' => [ 'shape' => 'ListStackSetsOutput', 'resultWrapper' => 'ListStackSetsResult', ], ], 'ListStacks' => [ 'name' => 'ListStacks', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListStacksInput', ], 'output' => [ 'shape' => 'ListStacksOutput', 'resultWrapper' => 'ListStacksResult', ], ], 'ListTypeRegistrations' => [ 'name' => 'ListTypeRegistrations', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTypeRegistrationsInput', ], 'output' => [ 'shape' => 'ListTypeRegistrationsOutput', 'resultWrapper' => 'ListTypeRegistrationsResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], ], 'idempotent' => true, ], 'ListTypeVersions' => [ 'name' => 'ListTypeVersions', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTypeVersionsInput', ], 'output' => [ 'shape' => 'ListTypeVersionsOutput', 'resultWrapper' => 'ListTypeVersionsResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], ], 'idempotent' => true, ], 'ListTypes' => [ 'name' => 'ListTypes', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTypesInput', ], 'output' => [ 'shape' => 'ListTypesOutput', 'resultWrapper' => 'ListTypesResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], ], 'idempotent' => true, ], 'RecordHandlerProgress' => [ 'name' => 'RecordHandlerProgress', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RecordHandlerProgressInput', ], 'output' => [ 'shape' => 'RecordHandlerProgressOutput', 'resultWrapper' => 'RecordHandlerProgressResult', ], 'errors' => [ [ 'shape' => 'InvalidStateTransitionException', ], [ 'shape' => 'OperationStatusCheckFailedException', ], ], 'idempotent' => true, ], 'RegisterType' => [ 'name' => 'RegisterType', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RegisterTypeInput', ], 'output' => [ 'shape' => 'RegisterTypeOutput', 'resultWrapper' => 'RegisterTypeResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], ], 'idempotent' => true, ], 'SetStackPolicy' => [ 'name' => 'SetStackPolicy', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SetStackPolicyInput', ], ], 'SetTypeDefaultVersion' => [ 'name' => 'SetTypeDefaultVersion', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SetTypeDefaultVersionInput', ], 'output' => [ 'shape' => 'SetTypeDefaultVersionOutput', 'resultWrapper' => 'SetTypeDefaultVersionResult', ], 'errors' => [ [ 'shape' => 'CFNRegistryException', ], [ 'shape' => 'TypeNotFoundException', ], ], 'idempotent' => true, ], 'SignalResource' => [ 'name' => 'SignalResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'SignalResourceInput', ], ], 'StopStackSetOperation' => [ 'name' => 'StopStackSetOperation', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopStackSetOperationInput', ], 'output' => [ 'shape' => 'StopStackSetOperationOutput', 'resultWrapper' => 'StopStackSetOperationResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationNotFoundException', ], [ 'shape' => 'InvalidOperationException', ], ], ], 'UpdateStack' => [ 'name' => 'UpdateStack', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateStackInput', ], 'output' => [ 'shape' => 'UpdateStackOutput', 'resultWrapper' => 'UpdateStackResult', ], 'errors' => [ [ 'shape' => 'InsufficientCapabilitiesException', ], [ 'shape' => 'TokenAlreadyExistsException', ], ], ], 'UpdateStackInstances' => [ 'name' => 'UpdateStackInstances', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateStackInstancesInput', ], 'output' => [ 'shape' => 'UpdateStackInstancesOutput', 'resultWrapper' => 'UpdateStackInstancesResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'StackInstanceNotFoundException', ], [ 'shape' => 'OperationInProgressException', ], [ 'shape' => 'OperationIdAlreadyExistsException', ], [ 'shape' => 'StaleRequestException', ], [ 'shape' => 'InvalidOperationException', ], ], ], 'UpdateStackSet' => [ 'name' => 'UpdateStackSet', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateStackSetInput', ], 'output' => [ 'shape' => 'UpdateStackSetOutput', 'resultWrapper' => 'UpdateStackSetResult', ], 'errors' => [ [ 'shape' => 'StackSetNotFoundException', ], [ 'shape' => 'OperationInProgressException', ], [ 'shape' => 'OperationIdAlreadyExistsException', ], [ 'shape' => 'StaleRequestException', ], [ 'shape' => 'InvalidOperationException', ], [ 'shape' => 'StackInstanceNotFoundException', ], ], ], 'UpdateTerminationProtection' => [ 'name' => 'UpdateTerminationProtection', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateTerminationProtectionInput', ], 'output' => [ 'shape' => 'UpdateTerminationProtectionOutput', 'resultWrapper' => 'UpdateTerminationProtectionResult', ], ], 'ValidateTemplate' => [ 'name' => 'ValidateTemplate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ValidateTemplateInput', ], 'output' => [ 'shape' => 'ValidateTemplateOutput', 'resultWrapper' => 'ValidateTemplateResult', ], ], ], 'shapes' => [ 'Account' => [ 'type' => 'string', 'pattern' => '^[0-9]{12}$', ], 'AccountGateResult' => [ 'type' => 'structure', 'members' => [ 'Status' => [ 'shape' => 'AccountGateStatus', ], 'StatusReason' => [ 'shape' => 'AccountGateStatusReason', ], ], ], 'AccountGateStatus' => [ 'type' => 'string', 'enum' => [ 'SUCCEEDED', 'FAILED', 'SKIPPED', ], ], 'AccountGateStatusReason' => [ 'type' => 'string', ], 'AccountLimit' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'LimitName', ], 'Value' => [ 'shape' => 'LimitValue', ], ], ], 'AccountLimitList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AccountLimit', ], ], 'AccountList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Account', ], ], 'AllowedValue' => [ 'type' => 'string', ], 'AllowedValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'AllowedValue', ], ], 'AlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'AlreadyExistsException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Arn' => [ 'type' => 'string', ], 'AutoDeployment' => [ 'type' => 'structure', 'members' => [ 'Enabled' => [ 'shape' => 'AutoDeploymentNullable', ], 'RetainStacksOnAccountRemoval' => [ 'shape' => 'RetainStacksOnAccountRemovalNullable', ], ], ], 'AutoDeploymentNullable' => [ 'type' => 'boolean', ], 'BoxedInteger' => [ 'type' => 'integer', 'box' => true, ], 'BoxedMaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'CFNRegistryException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'code' => 'CFNRegistryException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'CancelUpdateStackInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'Capabilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'Capability', ], ], 'CapabilitiesReason' => [ 'type' => 'string', ], 'Capability' => [ 'type' => 'string', 'enum' => [ 'CAPABILITY_IAM', 'CAPABILITY_NAMED_IAM', 'CAPABILITY_AUTO_EXPAND', ], ], 'CausingEntity' => [ 'type' => 'string', ], 'Change' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'ChangeType', ], 'ResourceChange' => [ 'shape' => 'ResourceChange', ], ], ], 'ChangeAction' => [ 'type' => 'string', 'enum' => [ 'Add', 'Modify', 'Remove', 'Import', ], ], 'ChangeSetId' => [ 'type' => 'string', 'min' => 1, 'pattern' => 'arn:[-a-zA-Z0-9:/]*', ], 'ChangeSetName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z][-a-zA-Z0-9]*', ], 'ChangeSetNameOrId' => [ 'type' => 'string', 'max' => 1600, 'min' => 1, 'pattern' => '[a-zA-Z][-a-zA-Z0-9]*|arn:[-a-zA-Z0-9:/]*', ], 'ChangeSetNotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'ChangeSetNotFound', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'ChangeSetStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_PENDING', 'CREATE_IN_PROGRESS', 'CREATE_COMPLETE', 'DELETE_COMPLETE', 'FAILED', ], ], 'ChangeSetStatusReason' => [ 'type' => 'string', ], 'ChangeSetSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ChangeSetSummary', ], ], 'ChangeSetSummary' => [ 'type' => 'structure', 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'StackName' => [ 'shape' => 'StackName', ], 'ChangeSetId' => [ 'shape' => 'ChangeSetId', ], 'ChangeSetName' => [ 'shape' => 'ChangeSetName', ], 'ExecutionStatus' => [ 'shape' => 'ExecutionStatus', ], 'Status' => [ 'shape' => 'ChangeSetStatus', ], 'StatusReason' => [ 'shape' => 'ChangeSetStatusReason', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'Description' => [ 'shape' => 'Description', ], ], ], 'ChangeSetType' => [ 'type' => 'string', 'enum' => [ 'CREATE', 'UPDATE', 'IMPORT', ], ], 'ChangeSource' => [ 'type' => 'string', 'enum' => [ 'ResourceReference', 'ParameterReference', 'ResourceAttribute', 'DirectModification', 'Automatic', ], ], 'ChangeType' => [ 'type' => 'string', 'enum' => [ 'Resource', ], ], 'Changes' => [ 'type' => 'list', 'member' => [ 'shape' => 'Change', ], ], 'ClientRequestToken' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9][-a-zA-Z0-9]*', ], 'ClientToken' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'ContinueUpdateRollbackInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'ResourcesToSkip' => [ 'shape' => 'ResourcesToSkip', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'ContinueUpdateRollbackOutput' => [ 'type' => 'structure', 'members' => [], ], 'CreateChangeSetInput' => [ 'type' => 'structure', 'required' => [ 'StackName', 'ChangeSetName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'UsePreviousTemplate' => [ 'shape' => 'UsePreviousTemplate', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'ResourceTypes' => [ 'shape' => 'ResourceTypes', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'RollbackConfiguration' => [ 'shape' => 'RollbackConfiguration', ], 'NotificationARNs' => [ 'shape' => 'NotificationARNs', ], 'Tags' => [ 'shape' => 'Tags', ], 'ChangeSetName' => [ 'shape' => 'ChangeSetName', ], 'ClientToken' => [ 'shape' => 'ClientToken', ], 'Description' => [ 'shape' => 'Description', ], 'ChangeSetType' => [ 'shape' => 'ChangeSetType', ], 'ResourcesToImport' => [ 'shape' => 'ResourcesToImport', ], ], ], 'CreateChangeSetOutput' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ChangeSetId', ], 'StackId' => [ 'shape' => 'StackId', ], ], ], 'CreateStackInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'DisableRollback' => [ 'shape' => 'DisableRollback', ], 'RollbackConfiguration' => [ 'shape' => 'RollbackConfiguration', ], 'TimeoutInMinutes' => [ 'shape' => 'TimeoutMinutes', ], 'NotificationARNs' => [ 'shape' => 'NotificationARNs', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'ResourceTypes' => [ 'shape' => 'ResourceTypes', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'OnFailure' => [ 'shape' => 'OnFailure', ], 'StackPolicyBody' => [ 'shape' => 'StackPolicyBody', ], 'StackPolicyURL' => [ 'shape' => 'StackPolicyURL', ], 'Tags' => [ 'shape' => 'Tags', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], 'EnableTerminationProtection' => [ 'shape' => 'EnableTerminationProtection', ], ], ], 'CreateStackInstancesInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'Regions', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'Accounts' => [ 'shape' => 'AccountList', ], 'DeploymentTargets' => [ 'shape' => 'DeploymentTargets', ], 'Regions' => [ 'shape' => 'RegionList', ], 'ParameterOverrides' => [ 'shape' => 'Parameters', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateStackInstancesOutput' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'CreateStackOutput' => [ 'type' => 'structure', 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], ], ], 'CreateStackSetInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'Description' => [ 'shape' => 'Description', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Tags' => [ 'shape' => 'Tags', ], 'AdministrationRoleARN' => [ 'shape' => 'RoleARN', ], 'ExecutionRoleName' => [ 'shape' => 'ExecutionRoleName', ], 'PermissionModel' => [ 'shape' => 'PermissionModels', ], 'AutoDeployment' => [ 'shape' => 'AutoDeployment', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'CreateStackSetOutput' => [ 'type' => 'structure', 'members' => [ 'StackSetId' => [ 'shape' => 'StackSetId', ], ], ], 'CreatedButModifiedException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'CreatedButModifiedException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'CreationTime' => [ 'type' => 'timestamp', ], 'DeleteChangeSetInput' => [ 'type' => 'structure', 'required' => [ 'ChangeSetName', ], 'members' => [ 'ChangeSetName' => [ 'shape' => 'ChangeSetNameOrId', ], 'StackName' => [ 'shape' => 'StackNameOrId', ], ], ], 'DeleteChangeSetOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteStackInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'RetainResources' => [ 'shape' => 'RetainResources', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'DeleteStackInstancesInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'Regions', 'RetainStacks', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'Accounts' => [ 'shape' => 'AccountList', ], 'DeploymentTargets' => [ 'shape' => 'DeploymentTargets', ], 'Regions' => [ 'shape' => 'RegionList', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'RetainStacks' => [ 'shape' => 'RetainStacks', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'DeleteStackInstancesOutput' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'DeleteStackSetInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], ], ], 'DeleteStackSetOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeletionTime' => [ 'type' => 'timestamp', ], 'DeploymentTargets' => [ 'type' => 'structure', 'members' => [ 'Accounts' => [ 'shape' => 'AccountList', ], 'OrganizationalUnitIds' => [ 'shape' => 'OrganizationalUnitIdList', ], ], ], 'DeprecatedStatus' => [ 'type' => 'string', 'enum' => [ 'LIVE', 'DEPRECATED', ], ], 'DeregisterTypeInput' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'PrivateTypeArn', ], 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'VersionId' => [ 'shape' => 'TypeVersionId', ], ], ], 'DeregisterTypeOutput' => [ 'type' => 'structure', 'members' => [], ], 'DescribeAccountLimitsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeAccountLimitsOutput' => [ 'type' => 'structure', 'members' => [ 'AccountLimits' => [ 'shape' => 'AccountLimitList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeChangeSetInput' => [ 'type' => 'structure', 'required' => [ 'ChangeSetName', ], 'members' => [ 'ChangeSetName' => [ 'shape' => 'ChangeSetNameOrId', ], 'StackName' => [ 'shape' => 'StackNameOrId', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeChangeSetOutput' => [ 'type' => 'structure', 'members' => [ 'ChangeSetName' => [ 'shape' => 'ChangeSetName', ], 'ChangeSetId' => [ 'shape' => 'ChangeSetId', ], 'StackId' => [ 'shape' => 'StackId', ], 'StackName' => [ 'shape' => 'StackName', ], 'Description' => [ 'shape' => 'Description', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'ExecutionStatus' => [ 'shape' => 'ExecutionStatus', ], 'Status' => [ 'shape' => 'ChangeSetStatus', ], 'StatusReason' => [ 'shape' => 'ChangeSetStatusReason', ], 'NotificationARNs' => [ 'shape' => 'NotificationARNs', ], 'RollbackConfiguration' => [ 'shape' => 'RollbackConfiguration', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Tags' => [ 'shape' => 'Tags', ], 'Changes' => [ 'shape' => 'Changes', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeStackDriftDetectionStatusInput' => [ 'type' => 'structure', 'required' => [ 'StackDriftDetectionId', ], 'members' => [ 'StackDriftDetectionId' => [ 'shape' => 'StackDriftDetectionId', ], ], ], 'DescribeStackDriftDetectionStatusOutput' => [ 'type' => 'structure', 'required' => [ 'StackId', 'StackDriftDetectionId', 'DetectionStatus', 'Timestamp', ], 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'StackDriftDetectionId' => [ 'shape' => 'StackDriftDetectionId', ], 'StackDriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'DetectionStatus' => [ 'shape' => 'StackDriftDetectionStatus', ], 'DetectionStatusReason' => [ 'shape' => 'StackDriftDetectionStatusReason', ], 'DriftedStackResourceCount' => [ 'shape' => 'BoxedInteger', ], 'Timestamp' => [ 'shape' => 'Timestamp', ], ], ], 'DescribeStackEventsInput' => [ 'type' => 'structure', 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeStackEventsOutput' => [ 'type' => 'structure', 'members' => [ 'StackEvents' => [ 'shape' => 'StackEvents', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeStackInstanceInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'StackInstanceAccount', 'StackInstanceRegion', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'StackInstanceAccount' => [ 'shape' => 'Account', ], 'StackInstanceRegion' => [ 'shape' => 'Region', ], ], ], 'DescribeStackInstanceOutput' => [ 'type' => 'structure', 'members' => [ 'StackInstance' => [ 'shape' => 'StackInstance', ], ], ], 'DescribeStackResourceDriftsInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'StackResourceDriftStatusFilters' => [ 'shape' => 'StackResourceDriftStatusFilters', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'BoxedMaxResults', ], ], ], 'DescribeStackResourceDriftsOutput' => [ 'type' => 'structure', 'required' => [ 'StackResourceDrifts', ], 'members' => [ 'StackResourceDrifts' => [ 'shape' => 'StackResourceDrifts', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeStackResourceInput' => [ 'type' => 'structure', 'required' => [ 'StackName', 'LogicalResourceId', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], ], ], 'DescribeStackResourceOutput' => [ 'type' => 'structure', 'members' => [ 'StackResourceDetail' => [ 'shape' => 'StackResourceDetail', ], ], ], 'DescribeStackResourcesInput' => [ 'type' => 'structure', 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], ], ], 'DescribeStackResourcesOutput' => [ 'type' => 'structure', 'members' => [ 'StackResources' => [ 'shape' => 'StackResources', ], ], ], 'DescribeStackSetInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], ], ], 'DescribeStackSetOperationInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'OperationId', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'DescribeStackSetOperationOutput' => [ 'type' => 'structure', 'members' => [ 'StackSetOperation' => [ 'shape' => 'StackSetOperation', ], ], ], 'DescribeStackSetOutput' => [ 'type' => 'structure', 'members' => [ 'StackSet' => [ 'shape' => 'StackSet', ], ], ], 'DescribeStacksInput' => [ 'type' => 'structure', 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeStacksOutput' => [ 'type' => 'structure', 'members' => [ 'Stacks' => [ 'shape' => 'Stacks', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'DescribeTypeInput' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'Arn' => [ 'shape' => 'TypeArn', ], 'VersionId' => [ 'shape' => 'TypeVersionId', ], ], ], 'DescribeTypeOutput' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'TypeArn', ], 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'DefaultVersionId' => [ 'shape' => 'TypeVersionId', ], 'Description' => [ 'shape' => 'Description', ], 'Schema' => [ 'shape' => 'TypeSchema', ], 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], 'DeprecatedStatus' => [ 'shape' => 'DeprecatedStatus', ], 'LoggingConfig' => [ 'shape' => 'LoggingConfig', ], 'ExecutionRoleArn' => [ 'shape' => 'RoleArn', ], 'Visibility' => [ 'shape' => 'Visibility', ], 'SourceUrl' => [ 'shape' => 'OptionalSecureUrl', ], 'DocumentationUrl' => [ 'shape' => 'OptionalSecureUrl', ], 'LastUpdated' => [ 'shape' => 'Timestamp', ], 'TimeCreated' => [ 'shape' => 'Timestamp', ], ], ], 'DescribeTypeRegistrationInput' => [ 'type' => 'structure', 'required' => [ 'RegistrationToken', ], 'members' => [ 'RegistrationToken' => [ 'shape' => 'RegistrationToken', ], ], ], 'DescribeTypeRegistrationOutput' => [ 'type' => 'structure', 'members' => [ 'ProgressStatus' => [ 'shape' => 'RegistrationStatus', ], 'Description' => [ 'shape' => 'Description', ], 'TypeArn' => [ 'shape' => 'TypeArn', ], 'TypeVersionArn' => [ 'shape' => 'TypeArn', ], ], ], 'Description' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'DetectStackDriftInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'LogicalResourceIds' => [ 'shape' => 'LogicalResourceIds', ], ], ], 'DetectStackDriftOutput' => [ 'type' => 'structure', 'required' => [ 'StackDriftDetectionId', ], 'members' => [ 'StackDriftDetectionId' => [ 'shape' => 'StackDriftDetectionId', ], ], ], 'DetectStackResourceDriftInput' => [ 'type' => 'structure', 'required' => [ 'StackName', 'LogicalResourceId', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], ], ], 'DetectStackResourceDriftOutput' => [ 'type' => 'structure', 'required' => [ 'StackResourceDrift', ], 'members' => [ 'StackResourceDrift' => [ 'shape' => 'StackResourceDrift', ], ], ], 'DetectStackSetDriftInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetNameOrId', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'DetectStackSetDriftOutput' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'DifferenceType' => [ 'type' => 'string', 'enum' => [ 'ADD', 'REMOVE', 'NOT_EQUAL', ], ], 'DisableRollback' => [ 'type' => 'boolean', ], 'DriftedStackInstancesCount' => [ 'type' => 'integer', 'min' => 0, ], 'EnableTerminationProtection' => [ 'type' => 'boolean', ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 255, 'min' => 1, ], 'EstimateTemplateCostInput' => [ 'type' => 'structure', 'members' => [ 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'Parameters' => [ 'shape' => 'Parameters', ], ], ], 'EstimateTemplateCostOutput' => [ 'type' => 'structure', 'members' => [ 'Url' => [ 'shape' => 'Url', ], ], ], 'EvaluationType' => [ 'type' => 'string', 'enum' => [ 'Static', 'Dynamic', ], ], 'EventId' => [ 'type' => 'string', ], 'ExecuteChangeSetInput' => [ 'type' => 'structure', 'required' => [ 'ChangeSetName', ], 'members' => [ 'ChangeSetName' => [ 'shape' => 'ChangeSetNameOrId', ], 'StackName' => [ 'shape' => 'StackNameOrId', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'ExecuteChangeSetOutput' => [ 'type' => 'structure', 'members' => [], ], 'ExecutionRoleName' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z_0-9+=,.@-]+', ], 'ExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'UNAVAILABLE', 'AVAILABLE', 'EXECUTE_IN_PROGRESS', 'EXECUTE_COMPLETE', 'EXECUTE_FAILED', 'OBSOLETE', ], ], 'Export' => [ 'type' => 'structure', 'members' => [ 'ExportingStackId' => [ 'shape' => 'StackId', ], 'Name' => [ 'shape' => 'ExportName', ], 'Value' => [ 'shape' => 'ExportValue', ], ], ], 'ExportName' => [ 'type' => 'string', ], 'ExportValue' => [ 'type' => 'string', ], 'Exports' => [ 'type' => 'list', 'member' => [ 'shape' => 'Export', ], ], 'FailedStackInstancesCount' => [ 'type' => 'integer', 'min' => 0, ], 'FailureToleranceCount' => [ 'type' => 'integer', 'min' => 0, ], 'FailureTolerancePercentage' => [ 'type' => 'integer', 'max' => 100, 'min' => 0, ], 'GetStackPolicyInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], ], ], 'GetStackPolicyOutput' => [ 'type' => 'structure', 'members' => [ 'StackPolicyBody' => [ 'shape' => 'StackPolicyBody', ], ], ], 'GetTemplateInput' => [ 'type' => 'structure', 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'ChangeSetName' => [ 'shape' => 'ChangeSetNameOrId', ], 'TemplateStage' => [ 'shape' => 'TemplateStage', ], ], ], 'GetTemplateOutput' => [ 'type' => 'structure', 'members' => [ 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'StagesAvailable' => [ 'shape' => 'StageList', ], ], ], 'GetTemplateSummaryInput' => [ 'type' => 'structure', 'members' => [ 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'StackName' => [ 'shape' => 'StackNameOrId', ], 'StackSetName' => [ 'shape' => 'StackSetNameOrId', ], ], ], 'GetTemplateSummaryOutput' => [ 'type' => 'structure', 'members' => [ 'Parameters' => [ 'shape' => 'ParameterDeclarations', ], 'Description' => [ 'shape' => 'Description', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'CapabilitiesReason' => [ 'shape' => 'CapabilitiesReason', ], 'ResourceTypes' => [ 'shape' => 'ResourceTypes', ], 'Version' => [ 'shape' => 'Version', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'DeclaredTransforms' => [ 'shape' => 'TransformsList', ], 'ResourceIdentifierSummaries' => [ 'shape' => 'ResourceIdentifierSummaries', ], ], ], 'HandlerErrorCode' => [ 'type' => 'string', 'enum' => [ 'NotUpdatable', 'InvalidRequest', 'AccessDenied', 'InvalidCredentials', 'AlreadyExists', 'NotFound', 'ResourceConflict', 'Throttling', 'ServiceLimitExceeded', 'NotStabilized', 'GeneralServiceException', 'ServiceInternalError', 'NetworkFailure', 'InternalFailure', ], ], 'Imports' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackName', ], ], 'InProgressStackInstancesCount' => [ 'type' => 'integer', 'min' => 0, ], 'InSyncStackInstancesCount' => [ 'type' => 'integer', 'min' => 0, ], 'InsufficientCapabilitiesException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InsufficientCapabilitiesException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidChangeSetStatusException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidChangeSetStatus', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidOperationException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidOperationException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'InvalidStateTransitionException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'InvalidStateTransition', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'Key' => [ 'type' => 'string', ], 'LastUpdatedTime' => [ 'type' => 'timestamp', ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'LimitExceededException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'LimitName' => [ 'type' => 'string', ], 'LimitValue' => [ 'type' => 'integer', ], 'ListChangeSetsInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListChangeSetsOutput' => [ 'type' => 'structure', 'members' => [ 'Summaries' => [ 'shape' => 'ChangeSetSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListExportsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListExportsOutput' => [ 'type' => 'structure', 'members' => [ 'Exports' => [ 'shape' => 'Exports', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListImportsInput' => [ 'type' => 'structure', 'required' => [ 'ExportName', ], 'members' => [ 'ExportName' => [ 'shape' => 'ExportName', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListImportsOutput' => [ 'type' => 'structure', 'members' => [ 'Imports' => [ 'shape' => 'Imports', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackInstancesInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'StackInstanceAccount' => [ 'shape' => 'Account', ], 'StackInstanceRegion' => [ 'shape' => 'Region', ], ], ], 'ListStackInstancesOutput' => [ 'type' => 'structure', 'members' => [ 'Summaries' => [ 'shape' => 'StackInstanceSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackResourcesInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackResourcesOutput' => [ 'type' => 'structure', 'members' => [ 'StackResourceSummaries' => [ 'shape' => 'StackResourceSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackSetOperationResultsInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'OperationId', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListStackSetOperationResultsOutput' => [ 'type' => 'structure', 'members' => [ 'Summaries' => [ 'shape' => 'StackSetOperationResultSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackSetOperationsInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], ], ], 'ListStackSetOperationsOutput' => [ 'type' => 'structure', 'members' => [ 'Summaries' => [ 'shape' => 'StackSetOperationSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStackSetsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'Status' => [ 'shape' => 'StackSetStatus', ], ], ], 'ListStackSetsOutput' => [ 'type' => 'structure', 'members' => [ 'Summaries' => [ 'shape' => 'StackSetSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListStacksInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'StackStatusFilter' => [ 'shape' => 'StackStatusFilter', ], ], ], 'ListStacksOutput' => [ 'type' => 'structure', 'members' => [ 'StackSummaries' => [ 'shape' => 'StackSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTypeRegistrationsInput' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'TypeArn' => [ 'shape' => 'TypeArn', ], 'RegistrationStatusFilter' => [ 'shape' => 'RegistrationStatus', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTypeRegistrationsOutput' => [ 'type' => 'structure', 'members' => [ 'RegistrationTokenList' => [ 'shape' => 'RegistrationTokenList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTypeVersionsInput' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'Arn' => [ 'shape' => 'PrivateTypeArn', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'DeprecatedStatus' => [ 'shape' => 'DeprecatedStatus', ], ], ], 'ListTypeVersionsOutput' => [ 'type' => 'structure', 'members' => [ 'TypeVersionSummaries' => [ 'shape' => 'TypeVersionSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTypesInput' => [ 'type' => 'structure', 'members' => [ 'Visibility' => [ 'shape' => 'Visibility', ], 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], 'DeprecatedStatus' => [ 'shape' => 'DeprecatedStatus', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListTypesOutput' => [ 'type' => 'structure', 'members' => [ 'TypeSummaries' => [ 'shape' => 'TypeSummaries', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'LogGroupName' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '[\\.\\-_/#A-Za-z0-9]+', ], 'LoggingConfig' => [ 'type' => 'structure', 'required' => [ 'LogRoleArn', 'LogGroupName', ], 'members' => [ 'LogRoleArn' => [ 'shape' => 'RoleArn', ], 'LogGroupName' => [ 'shape' => 'LogGroupName', ], ], ], 'LogicalResourceId' => [ 'type' => 'string', ], 'LogicalResourceIds' => [ 'type' => 'list', 'member' => [ 'shape' => 'LogicalResourceId', ], 'max' => 200, 'min' => 1, ], 'MaxConcurrentCount' => [ 'type' => 'integer', 'min' => 1, ], 'MaxConcurrentPercentage' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'MaxResults' => [ 'type' => 'integer', 'max' => 100, 'min' => 1, ], 'Metadata' => [ 'type' => 'string', ], 'MonitoringTimeInMinutes' => [ 'type' => 'integer', 'max' => 180, 'min' => 0, ], 'NameAlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'NameAlreadyExistsException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'NextToken' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'NoEcho' => [ 'type' => 'boolean', ], 'NotificationARN' => [ 'type' => 'string', ], 'NotificationARNs' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotificationARN', ], 'max' => 5, ], 'OnFailure' => [ 'type' => 'string', 'enum' => [ 'DO_NOTHING', 'ROLLBACK', 'DELETE', ], ], 'OperationIdAlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'OperationIdAlreadyExistsException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'OperationInProgressException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'OperationInProgressException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'OperationNotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'OperationNotFoundException', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'OperationStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'IN_PROGRESS', 'SUCCESS', 'FAILED', ], ], 'OperationStatusCheckFailedException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'ConditionalCheckFailed', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'OptionalSecureUrl' => [ 'type' => 'string', 'max' => 4096, ], 'OrganizationalUnitId' => [ 'type' => 'string', 'pattern' => '^(ou-[a-z0-9]{4,32}-[a-z0-9]{8,32}|r-[a-z0-9]{4,32})$', ], 'OrganizationalUnitIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'OrganizationalUnitId', ], ], 'Output' => [ 'type' => 'structure', 'members' => [ 'OutputKey' => [ 'shape' => 'OutputKey', ], 'OutputValue' => [ 'shape' => 'OutputValue', ], 'Description' => [ 'shape' => 'Description', ], 'ExportName' => [ 'shape' => 'ExportName', ], ], ], 'OutputKey' => [ 'type' => 'string', ], 'OutputValue' => [ 'type' => 'string', ], 'Outputs' => [ 'type' => 'list', 'member' => [ 'shape' => 'Output', ], ], 'Parameter' => [ 'type' => 'structure', 'members' => [ 'ParameterKey' => [ 'shape' => 'ParameterKey', ], 'ParameterValue' => [ 'shape' => 'ParameterValue', ], 'UsePreviousValue' => [ 'shape' => 'UsePreviousValue', ], 'ResolvedValue' => [ 'shape' => 'ParameterValue', ], ], ], 'ParameterConstraints' => [ 'type' => 'structure', 'members' => [ 'AllowedValues' => [ 'shape' => 'AllowedValues', ], ], ], 'ParameterDeclaration' => [ 'type' => 'structure', 'members' => [ 'ParameterKey' => [ 'shape' => 'ParameterKey', ], 'DefaultValue' => [ 'shape' => 'ParameterValue', ], 'ParameterType' => [ 'shape' => 'ParameterType', ], 'NoEcho' => [ 'shape' => 'NoEcho', ], 'Description' => [ 'shape' => 'Description', ], 'ParameterConstraints' => [ 'shape' => 'ParameterConstraints', ], ], ], 'ParameterDeclarations' => [ 'type' => 'list', 'member' => [ 'shape' => 'ParameterDeclaration', ], ], 'ParameterKey' => [ 'type' => 'string', ], 'ParameterType' => [ 'type' => 'string', ], 'ParameterValue' => [ 'type' => 'string', ], 'Parameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'Parameter', ], ], 'PermissionModels' => [ 'type' => 'string', 'enum' => [ 'SERVICE_MANAGED', 'SELF_MANAGED', ], ], 'PhysicalResourceId' => [ 'type' => 'string', ], 'PhysicalResourceIdContext' => [ 'type' => 'list', 'member' => [ 'shape' => 'PhysicalResourceIdContextKeyValuePair', ], 'max' => 5, ], 'PhysicalResourceIdContextKeyValuePair' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'Key', ], 'Value' => [ 'shape' => 'Value', ], ], ], 'PrivateTypeArn' => [ 'type' => 'string', 'max' => 1024, 'pattern' => 'arn:aws[A-Za-z0-9-]{0,64}:cloudformation:[A-Za-z0-9-]{1,64}:[0-9]{12}:type/.+', ], 'Properties' => [ 'type' => 'string', ], 'PropertyDifference' => [ 'type' => 'structure', 'required' => [ 'PropertyPath', 'ExpectedValue', 'ActualValue', 'DifferenceType', ], 'members' => [ 'PropertyPath' => [ 'shape' => 'PropertyPath', ], 'ExpectedValue' => [ 'shape' => 'PropertyValue', ], 'ActualValue' => [ 'shape' => 'PropertyValue', ], 'DifferenceType' => [ 'shape' => 'DifferenceType', ], ], ], 'PropertyDifferences' => [ 'type' => 'list', 'member' => [ 'shape' => 'PropertyDifference', ], ], 'PropertyName' => [ 'type' => 'string', ], 'PropertyPath' => [ 'type' => 'string', ], 'PropertyValue' => [ 'type' => 'string', ], 'ProvisioningType' => [ 'type' => 'string', 'enum' => [ 'NON_PROVISIONABLE', 'IMMUTABLE', 'FULLY_MUTABLE', ], ], 'Reason' => [ 'type' => 'string', ], 'RecordHandlerProgressInput' => [ 'type' => 'structure', 'required' => [ 'BearerToken', 'OperationStatus', ], 'members' => [ 'BearerToken' => [ 'shape' => 'ClientToken', ], 'OperationStatus' => [ 'shape' => 'OperationStatus', ], 'CurrentOperationStatus' => [ 'shape' => 'OperationStatus', ], 'StatusMessage' => [ 'shape' => 'StatusMessage', ], 'ErrorCode' => [ 'shape' => 'HandlerErrorCode', ], 'ResourceModel' => [ 'shape' => 'ResourceModel', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'RecordHandlerProgressOutput' => [ 'type' => 'structure', 'members' => [], ], 'Region' => [ 'type' => 'string', 'pattern' => '^[a-zA-Z0-9-]{1,128}$', ], 'RegionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Region', ], ], 'RegisterTypeInput' => [ 'type' => 'structure', 'required' => [ 'TypeName', 'SchemaHandlerPackage', ], 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'SchemaHandlerPackage' => [ 'shape' => 'S3Url', ], 'LoggingConfig' => [ 'shape' => 'LoggingConfig', ], 'ExecutionRoleArn' => [ 'shape' => 'RoleArn', ], 'ClientRequestToken' => [ 'shape' => 'RequestToken', ], ], ], 'RegisterTypeOutput' => [ 'type' => 'structure', 'members' => [ 'RegistrationToken' => [ 'shape' => 'RegistrationToken', ], ], ], 'RegistrationStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETE', 'IN_PROGRESS', 'FAILED', ], ], 'RegistrationToken' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9][-a-zA-Z0-9]*', ], 'RegistrationTokenList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RegistrationToken', ], ], 'RegistryType' => [ 'type' => 'string', 'enum' => [ 'RESOURCE', ], ], 'Replacement' => [ 'type' => 'string', 'enum' => [ 'True', 'False', 'Conditional', ], ], 'RequestToken' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9][-a-zA-Z0-9]*', ], 'RequiresRecreation' => [ 'type' => 'string', 'enum' => [ 'Never', 'Conditionally', 'Always', ], ], 'ResourceAttribute' => [ 'type' => 'string', 'enum' => [ 'Properties', 'Metadata', 'CreationPolicy', 'UpdatePolicy', 'DeletionPolicy', 'Tags', ], ], 'ResourceChange' => [ 'type' => 'structure', 'members' => [ 'Action' => [ 'shape' => 'ChangeAction', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'Replacement' => [ 'shape' => 'Replacement', ], 'Scope' => [ 'shape' => 'Scope', ], 'Details' => [ 'shape' => 'ResourceChangeDetails', ], ], ], 'ResourceChangeDetail' => [ 'type' => 'structure', 'members' => [ 'Target' => [ 'shape' => 'ResourceTargetDefinition', ], 'Evaluation' => [ 'shape' => 'EvaluationType', ], 'ChangeSource' => [ 'shape' => 'ChangeSource', ], 'CausingEntity' => [ 'shape' => 'CausingEntity', ], ], ], 'ResourceChangeDetails' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceChangeDetail', ], ], 'ResourceIdentifierProperties' => [ 'type' => 'map', 'key' => [ 'shape' => 'ResourceIdentifierPropertyKey', ], 'value' => [ 'shape' => 'ResourceIdentifierPropertyValue', ], 'max' => 256, 'min' => 1, ], 'ResourceIdentifierPropertyKey' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ResourceIdentifierPropertyValue' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, ], 'ResourceIdentifierSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceIdentifierSummary', ], ], 'ResourceIdentifierSummary' => [ 'type' => 'structure', 'members' => [ 'ResourceType' => [ 'shape' => 'ResourceType', ], 'LogicalResourceIds' => [ 'shape' => 'LogicalResourceIds', ], 'ResourceIdentifiers' => [ 'shape' => 'ResourceIdentifiers', ], ], ], 'ResourceIdentifiers' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceIdentifierPropertyKey', ], ], 'ResourceModel' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, ], 'ResourceProperties' => [ 'type' => 'string', ], 'ResourceSignalStatus' => [ 'type' => 'string', 'enum' => [ 'SUCCESS', 'FAILURE', ], ], 'ResourceSignalUniqueId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, ], 'ResourceStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'CREATE_FAILED', 'CREATE_COMPLETE', 'DELETE_IN_PROGRESS', 'DELETE_FAILED', 'DELETE_COMPLETE', 'DELETE_SKIPPED', 'UPDATE_IN_PROGRESS', 'UPDATE_FAILED', 'UPDATE_COMPLETE', 'IMPORT_FAILED', 'IMPORT_COMPLETE', 'IMPORT_IN_PROGRESS', 'IMPORT_ROLLBACK_IN_PROGRESS', 'IMPORT_ROLLBACK_FAILED', 'IMPORT_ROLLBACK_COMPLETE', ], ], 'ResourceStatusReason' => [ 'type' => 'string', ], 'ResourceTargetDefinition' => [ 'type' => 'structure', 'members' => [ 'Attribute' => [ 'shape' => 'ResourceAttribute', ], 'Name' => [ 'shape' => 'PropertyName', ], 'RequiresRecreation' => [ 'shape' => 'RequiresRecreation', ], ], ], 'ResourceToImport' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'LogicalResourceId', 'ResourceIdentifier', ], 'members' => [ 'ResourceType' => [ 'shape' => 'ResourceType', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'ResourceIdentifier' => [ 'shape' => 'ResourceIdentifierProperties', ], ], ], 'ResourceToSkip' => [ 'type' => 'string', 'pattern' => '[a-zA-Z0-9]+|[a-zA-Z][-a-zA-Z0-9]*\\.[a-zA-Z0-9]+', ], 'ResourceType' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'ResourceTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceType', ], ], 'ResourcesToImport' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceToImport', ], 'max' => 200, ], 'ResourcesToSkip' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceToSkip', ], ], 'RetainResources' => [ 'type' => 'list', 'member' => [ 'shape' => 'LogicalResourceId', ], ], 'RetainStacks' => [ 'type' => 'boolean', ], 'RetainStacksNullable' => [ 'type' => 'boolean', ], 'RetainStacksOnAccountRemovalNullable' => [ 'type' => 'boolean', ], 'RoleARN' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, ], 'RoleArn' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => 'arn:.+:iam::[0-9]{12}:role/.+', ], 'RollbackConfiguration' => [ 'type' => 'structure', 'members' => [ 'RollbackTriggers' => [ 'shape' => 'RollbackTriggers', ], 'MonitoringTimeInMinutes' => [ 'shape' => 'MonitoringTimeInMinutes', ], ], ], 'RollbackTrigger' => [ 'type' => 'structure', 'required' => [ 'Arn', 'Type', ], 'members' => [ 'Arn' => [ 'shape' => 'Arn', ], 'Type' => [ 'shape' => 'Type', ], ], ], 'RollbackTriggers' => [ 'type' => 'list', 'member' => [ 'shape' => 'RollbackTrigger', ], 'max' => 5, ], 'S3Url' => [ 'type' => 'string', 'max' => 4096, 'min' => 1, ], 'Scope' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceAttribute', ], ], 'SetStackPolicyInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'StackPolicyBody' => [ 'shape' => 'StackPolicyBody', ], 'StackPolicyURL' => [ 'shape' => 'StackPolicyURL', ], ], ], 'SetTypeDefaultVersionInput' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'PrivateTypeArn', ], 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'VersionId' => [ 'shape' => 'TypeVersionId', ], ], ], 'SetTypeDefaultVersionOutput' => [ 'type' => 'structure', 'members' => [], ], 'SignalResourceInput' => [ 'type' => 'structure', 'required' => [ 'StackName', 'LogicalResourceId', 'UniqueId', 'Status', ], 'members' => [ 'StackName' => [ 'shape' => 'StackNameOrId', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'UniqueId' => [ 'shape' => 'ResourceSignalUniqueId', ], 'Status' => [ 'shape' => 'ResourceSignalStatus', ], ], ], 'Stack' => [ 'type' => 'structure', 'required' => [ 'StackName', 'CreationTime', 'StackStatus', ], 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'StackName' => [ 'shape' => 'StackName', ], 'ChangeSetId' => [ 'shape' => 'ChangeSetId', ], 'Description' => [ 'shape' => 'Description', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'DeletionTime' => [ 'shape' => 'DeletionTime', ], 'LastUpdatedTime' => [ 'shape' => 'LastUpdatedTime', ], 'RollbackConfiguration' => [ 'shape' => 'RollbackConfiguration', ], 'StackStatus' => [ 'shape' => 'StackStatus', ], 'StackStatusReason' => [ 'shape' => 'StackStatusReason', ], 'DisableRollback' => [ 'shape' => 'DisableRollback', ], 'NotificationARNs' => [ 'shape' => 'NotificationARNs', ], 'TimeoutInMinutes' => [ 'shape' => 'TimeoutMinutes', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Outputs' => [ 'shape' => 'Outputs', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'Tags' => [ 'shape' => 'Tags', ], 'EnableTerminationProtection' => [ 'shape' => 'EnableTerminationProtection', ], 'ParentId' => [ 'shape' => 'StackId', ], 'RootId' => [ 'shape' => 'StackId', ], 'DriftInformation' => [ 'shape' => 'StackDriftInformation', ], ], ], 'StackDriftDetectionId' => [ 'type' => 'string', 'max' => 36, 'min' => 1, ], 'StackDriftDetectionStatus' => [ 'type' => 'string', 'enum' => [ 'DETECTION_IN_PROGRESS', 'DETECTION_FAILED', 'DETECTION_COMPLETE', ], ], 'StackDriftDetectionStatusReason' => [ 'type' => 'string', ], 'StackDriftInformation' => [ 'type' => 'structure', 'required' => [ 'StackDriftStatus', ], 'members' => [ 'StackDriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'LastCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackDriftInformationSummary' => [ 'type' => 'structure', 'required' => [ 'StackDriftStatus', ], 'members' => [ 'StackDriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'LastCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackDriftStatus' => [ 'type' => 'string', 'enum' => [ 'DRIFTED', 'IN_SYNC', 'UNKNOWN', 'NOT_CHECKED', ], ], 'StackEvent' => [ 'type' => 'structure', 'required' => [ 'StackId', 'EventId', 'StackName', 'Timestamp', ], 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'EventId' => [ 'shape' => 'EventId', ], 'StackName' => [ 'shape' => 'StackName', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'Timestamp' => [ 'shape' => 'Timestamp', ], 'ResourceStatus' => [ 'shape' => 'ResourceStatus', ], 'ResourceStatusReason' => [ 'shape' => 'ResourceStatusReason', ], 'ResourceProperties' => [ 'shape' => 'ResourceProperties', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'StackEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackEvent', ], ], 'StackId' => [ 'type' => 'string', ], 'StackInstance' => [ 'type' => 'structure', 'members' => [ 'StackSetId' => [ 'shape' => 'StackSetId', ], 'Region' => [ 'shape' => 'Region', ], 'Account' => [ 'shape' => 'Account', ], 'StackId' => [ 'shape' => 'StackId', ], 'ParameterOverrides' => [ 'shape' => 'Parameters', ], 'Status' => [ 'shape' => 'StackInstanceStatus', ], 'StatusReason' => [ 'shape' => 'Reason', ], 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], 'DriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'LastDriftCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackInstanceNotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'StackInstanceNotFoundException', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'StackInstanceStatus' => [ 'type' => 'string', 'enum' => [ 'CURRENT', 'OUTDATED', 'INOPERABLE', ], ], 'StackInstanceSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackInstanceSummary', ], ], 'StackInstanceSummary' => [ 'type' => 'structure', 'members' => [ 'StackSetId' => [ 'shape' => 'StackSetId', ], 'Region' => [ 'shape' => 'Region', ], 'Account' => [ 'shape' => 'Account', ], 'StackId' => [ 'shape' => 'StackId', ], 'Status' => [ 'shape' => 'StackInstanceStatus', ], 'StatusReason' => [ 'shape' => 'Reason', ], 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], 'DriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'LastDriftCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackName' => [ 'type' => 'string', ], 'StackNameOrId' => [ 'type' => 'string', 'min' => 1, 'pattern' => '([a-zA-Z][-a-zA-Z0-9]*)|(arn:\\b(aws|aws-us-gov|aws-cn)\\b:[-a-zA-Z0-9:/._+]*)', ], 'StackPolicyBody' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, ], 'StackPolicyDuringUpdateBody' => [ 'type' => 'string', 'max' => 16384, 'min' => 1, ], 'StackPolicyDuringUpdateURL' => [ 'type' => 'string', 'max' => 1350, 'min' => 1, ], 'StackPolicyURL' => [ 'type' => 'string', 'max' => 1350, 'min' => 1, ], 'StackResource' => [ 'type' => 'structure', 'required' => [ 'LogicalResourceId', 'ResourceType', 'Timestamp', 'ResourceStatus', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'StackId' => [ 'shape' => 'StackId', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'Timestamp' => [ 'shape' => 'Timestamp', ], 'ResourceStatus' => [ 'shape' => 'ResourceStatus', ], 'ResourceStatusReason' => [ 'shape' => 'ResourceStatusReason', ], 'Description' => [ 'shape' => 'Description', ], 'DriftInformation' => [ 'shape' => 'StackResourceDriftInformation', ], ], ], 'StackResourceDetail' => [ 'type' => 'structure', 'required' => [ 'LogicalResourceId', 'ResourceType', 'LastUpdatedTimestamp', 'ResourceStatus', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'StackId' => [ 'shape' => 'StackId', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], 'ResourceStatus' => [ 'shape' => 'ResourceStatus', ], 'ResourceStatusReason' => [ 'shape' => 'ResourceStatusReason', ], 'Description' => [ 'shape' => 'Description', ], 'Metadata' => [ 'shape' => 'Metadata', ], 'DriftInformation' => [ 'shape' => 'StackResourceDriftInformation', ], ], ], 'StackResourceDrift' => [ 'type' => 'structure', 'required' => [ 'StackId', 'LogicalResourceId', 'ResourceType', 'StackResourceDriftStatus', 'Timestamp', ], 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'PhysicalResourceIdContext' => [ 'shape' => 'PhysicalResourceIdContext', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'ExpectedProperties' => [ 'shape' => 'Properties', ], 'ActualProperties' => [ 'shape' => 'Properties', ], 'PropertyDifferences' => [ 'shape' => 'PropertyDifferences', ], 'StackResourceDriftStatus' => [ 'shape' => 'StackResourceDriftStatus', ], 'Timestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackResourceDriftInformation' => [ 'type' => 'structure', 'required' => [ 'StackResourceDriftStatus', ], 'members' => [ 'StackResourceDriftStatus' => [ 'shape' => 'StackResourceDriftStatus', ], 'LastCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackResourceDriftInformationSummary' => [ 'type' => 'structure', 'required' => [ 'StackResourceDriftStatus', ], 'members' => [ 'StackResourceDriftStatus' => [ 'shape' => 'StackResourceDriftStatus', ], 'LastCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackResourceDriftStatus' => [ 'type' => 'string', 'enum' => [ 'IN_SYNC', 'MODIFIED', 'DELETED', 'NOT_CHECKED', ], ], 'StackResourceDriftStatusFilters' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackResourceDriftStatus', ], 'max' => 4, 'min' => 1, ], 'StackResourceDrifts' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackResourceDrift', ], ], 'StackResourceSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackResourceSummary', ], ], 'StackResourceSummary' => [ 'type' => 'structure', 'required' => [ 'LogicalResourceId', 'ResourceType', 'LastUpdatedTimestamp', 'ResourceStatus', ], 'members' => [ 'LogicalResourceId' => [ 'shape' => 'LogicalResourceId', ], 'PhysicalResourceId' => [ 'shape' => 'PhysicalResourceId', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], 'LastUpdatedTimestamp' => [ 'shape' => 'Timestamp', ], 'ResourceStatus' => [ 'shape' => 'ResourceStatus', ], 'ResourceStatusReason' => [ 'shape' => 'ResourceStatusReason', ], 'DriftInformation' => [ 'shape' => 'StackResourceDriftInformationSummary', ], ], ], 'StackResources' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackResource', ], ], 'StackSet' => [ 'type' => 'structure', 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'StackSetId' => [ 'shape' => 'StackSetId', ], 'Description' => [ 'shape' => 'Description', ], 'Status' => [ 'shape' => 'StackSetStatus', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Tags' => [ 'shape' => 'Tags', ], 'StackSetARN' => [ 'shape' => 'StackSetARN', ], 'AdministrationRoleARN' => [ 'shape' => 'RoleARN', ], 'ExecutionRoleName' => [ 'shape' => 'ExecutionRoleName', ], 'StackSetDriftDetectionDetails' => [ 'shape' => 'StackSetDriftDetectionDetails', ], 'AutoDeployment' => [ 'shape' => 'AutoDeployment', ], 'PermissionModel' => [ 'shape' => 'PermissionModels', ], 'OrganizationalUnitIds' => [ 'shape' => 'OrganizationalUnitIdList', ], ], ], 'StackSetARN' => [ 'type' => 'string', ], 'StackSetDriftDetectionDetails' => [ 'type' => 'structure', 'members' => [ 'DriftStatus' => [ 'shape' => 'StackSetDriftStatus', ], 'DriftDetectionStatus' => [ 'shape' => 'StackSetDriftDetectionStatus', ], 'LastDriftCheckTimestamp' => [ 'shape' => 'Timestamp', ], 'TotalStackInstancesCount' => [ 'shape' => 'TotalStackInstancesCount', ], 'DriftedStackInstancesCount' => [ 'shape' => 'DriftedStackInstancesCount', ], 'InSyncStackInstancesCount' => [ 'shape' => 'InSyncStackInstancesCount', ], 'InProgressStackInstancesCount' => [ 'shape' => 'InProgressStackInstancesCount', ], 'FailedStackInstancesCount' => [ 'shape' => 'FailedStackInstancesCount', ], ], ], 'StackSetDriftDetectionStatus' => [ 'type' => 'string', 'enum' => [ 'COMPLETED', 'FAILED', 'PARTIAL_SUCCESS', 'IN_PROGRESS', 'STOPPED', ], ], 'StackSetDriftStatus' => [ 'type' => 'string', 'enum' => [ 'DRIFTED', 'IN_SYNC', 'NOT_CHECKED', ], ], 'StackSetId' => [ 'type' => 'string', ], 'StackSetName' => [ 'type' => 'string', ], 'StackSetNameOrId' => [ 'type' => 'string', 'pattern' => '[a-zA-Z][-a-zA-Z0-9]*(?::[a-zA-Z0-9]{8}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{4}-[a-zA-Z0-9]{12})?', ], 'StackSetNotEmptyException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'StackSetNotEmptyException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'StackSetNotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'StackSetNotFoundException', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'StackSetOperation' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], 'StackSetId' => [ 'shape' => 'StackSetId', ], 'Action' => [ 'shape' => 'StackSetOperationAction', ], 'Status' => [ 'shape' => 'StackSetOperationStatus', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'RetainStacks' => [ 'shape' => 'RetainStacksNullable', ], 'AdministrationRoleARN' => [ 'shape' => 'RoleARN', ], 'ExecutionRoleName' => [ 'shape' => 'ExecutionRoleName', ], 'CreationTimestamp' => [ 'shape' => 'Timestamp', ], 'EndTimestamp' => [ 'shape' => 'Timestamp', ], 'DeploymentTargets' => [ 'shape' => 'DeploymentTargets', ], 'StackSetDriftDetectionDetails' => [ 'shape' => 'StackSetDriftDetectionDetails', ], ], ], 'StackSetOperationAction' => [ 'type' => 'string', 'enum' => [ 'CREATE', 'UPDATE', 'DELETE', 'DETECT_DRIFT', ], ], 'StackSetOperationPreferences' => [ 'type' => 'structure', 'members' => [ 'RegionOrder' => [ 'shape' => 'RegionList', ], 'FailureToleranceCount' => [ 'shape' => 'FailureToleranceCount', ], 'FailureTolerancePercentage' => [ 'shape' => 'FailureTolerancePercentage', ], 'MaxConcurrentCount' => [ 'shape' => 'MaxConcurrentCount', ], 'MaxConcurrentPercentage' => [ 'shape' => 'MaxConcurrentPercentage', ], ], ], 'StackSetOperationResultStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING', 'RUNNING', 'SUCCEEDED', 'FAILED', 'CANCELLED', ], ], 'StackSetOperationResultSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackSetOperationResultSummary', ], ], 'StackSetOperationResultSummary' => [ 'type' => 'structure', 'members' => [ 'Account' => [ 'shape' => 'Account', ], 'Region' => [ 'shape' => 'Region', ], 'Status' => [ 'shape' => 'StackSetOperationResultStatus', ], 'StatusReason' => [ 'shape' => 'Reason', ], 'AccountGateResult' => [ 'shape' => 'AccountGateResult', ], 'OrganizationalUnitId' => [ 'shape' => 'OrganizationalUnitId', ], ], ], 'StackSetOperationStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'SUCCEEDED', 'FAILED', 'STOPPING', 'STOPPED', 'QUEUED', ], ], 'StackSetOperationSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackSetOperationSummary', ], ], 'StackSetOperationSummary' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], 'Action' => [ 'shape' => 'StackSetOperationAction', ], 'Status' => [ 'shape' => 'StackSetOperationStatus', ], 'CreationTimestamp' => [ 'shape' => 'Timestamp', ], 'EndTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackSetStatus' => [ 'type' => 'string', 'enum' => [ 'ACTIVE', 'DELETED', ], ], 'StackSetSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackSetSummary', ], ], 'StackSetSummary' => [ 'type' => 'structure', 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'StackSetId' => [ 'shape' => 'StackSetId', ], 'Description' => [ 'shape' => 'Description', ], 'Status' => [ 'shape' => 'StackSetStatus', ], 'AutoDeployment' => [ 'shape' => 'AutoDeployment', ], 'PermissionModel' => [ 'shape' => 'PermissionModels', ], 'DriftStatus' => [ 'shape' => 'StackDriftStatus', ], 'LastDriftCheckTimestamp' => [ 'shape' => 'Timestamp', ], ], ], 'StackStatus' => [ 'type' => 'string', 'enum' => [ 'CREATE_IN_PROGRESS', 'CREATE_FAILED', 'CREATE_COMPLETE', 'ROLLBACK_IN_PROGRESS', 'ROLLBACK_FAILED', 'ROLLBACK_COMPLETE', 'DELETE_IN_PROGRESS', 'DELETE_FAILED', 'DELETE_COMPLETE', 'UPDATE_IN_PROGRESS', 'UPDATE_COMPLETE_CLEANUP_IN_PROGRESS', 'UPDATE_COMPLETE', 'UPDATE_ROLLBACK_IN_PROGRESS', 'UPDATE_ROLLBACK_FAILED', 'UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS', 'UPDATE_ROLLBACK_COMPLETE', 'REVIEW_IN_PROGRESS', 'IMPORT_IN_PROGRESS', 'IMPORT_COMPLETE', 'IMPORT_ROLLBACK_IN_PROGRESS', 'IMPORT_ROLLBACK_FAILED', 'IMPORT_ROLLBACK_COMPLETE', ], ], 'StackStatusFilter' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackStatus', ], ], 'StackStatusReason' => [ 'type' => 'string', ], 'StackSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'StackSummary', ], ], 'StackSummary' => [ 'type' => 'structure', 'required' => [ 'StackName', 'CreationTime', 'StackStatus', ], 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], 'StackName' => [ 'shape' => 'StackName', ], 'TemplateDescription' => [ 'shape' => 'TemplateDescription', ], 'CreationTime' => [ 'shape' => 'CreationTime', ], 'LastUpdatedTime' => [ 'shape' => 'LastUpdatedTime', ], 'DeletionTime' => [ 'shape' => 'DeletionTime', ], 'StackStatus' => [ 'shape' => 'StackStatus', ], 'StackStatusReason' => [ 'shape' => 'StackStatusReason', ], 'ParentId' => [ 'shape' => 'StackId', ], 'RootId' => [ 'shape' => 'StackId', ], 'DriftInformation' => [ 'shape' => 'StackDriftInformationSummary', ], ], ], 'Stacks' => [ 'type' => 'list', 'member' => [ 'shape' => 'Stack', ], ], 'StageList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateStage', ], ], 'StaleRequestException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'StaleRequestException', 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'StatusMessage' => [ 'type' => 'string', 'max' => 1024, ], 'StopStackSetOperationInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'OperationId', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'StopStackSetOperationOutput' => [ 'type' => 'structure', 'members' => [], ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', 'Value', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'Tags' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 50, ], 'TemplateBody' => [ 'type' => 'string', 'min' => 1, ], 'TemplateDescription' => [ 'type' => 'string', ], 'TemplateParameter' => [ 'type' => 'structure', 'members' => [ 'ParameterKey' => [ 'shape' => 'ParameterKey', ], 'DefaultValue' => [ 'shape' => 'ParameterValue', ], 'NoEcho' => [ 'shape' => 'NoEcho', ], 'Description' => [ 'shape' => 'Description', ], ], ], 'TemplateParameters' => [ 'type' => 'list', 'member' => [ 'shape' => 'TemplateParameter', ], ], 'TemplateStage' => [ 'type' => 'string', 'enum' => [ 'Original', 'Processed', ], ], 'TemplateURL' => [ 'type' => 'string', 'max' => 1024, 'min' => 1, ], 'TimeoutMinutes' => [ 'type' => 'integer', 'min' => 1, ], 'Timestamp' => [ 'type' => 'timestamp', ], 'TokenAlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'TokenAlreadyExistsException', 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'TotalStackInstancesCount' => [ 'type' => 'integer', 'min' => 0, ], 'TransformName' => [ 'type' => 'string', ], 'TransformsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TransformName', ], ], 'Type' => [ 'type' => 'string', ], 'TypeArn' => [ 'type' => 'string', 'max' => 1024, 'pattern' => 'arn:aws[A-Za-z0-9-]{0,64}:cloudformation:[A-Za-z0-9-]{1,64}:([0-9]{12})?:type/.+', ], 'TypeName' => [ 'type' => 'string', 'max' => 196, 'min' => 10, 'pattern' => '[A-Za-z0-9]{2,64}::[A-Za-z0-9]{2,64}::[A-Za-z0-9]{2,64}', ], 'TypeNotFoundException' => [ 'type' => 'structure', 'members' => [], 'error' => [ 'code' => 'TypeNotFoundException', 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'TypeSchema' => [ 'type' => 'string', 'max' => 16777216, 'min' => 1, ], 'TypeSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TypeSummary', ], ], 'TypeSummary' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'DefaultVersionId' => [ 'shape' => 'TypeVersionId', ], 'TypeArn' => [ 'shape' => 'TypeArn', ], 'LastUpdated' => [ 'shape' => 'Timestamp', ], 'Description' => [ 'shape' => 'Description', ], ], ], 'TypeVersionId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-]+', ], 'TypeVersionSummaries' => [ 'type' => 'list', 'member' => [ 'shape' => 'TypeVersionSummary', ], ], 'TypeVersionSummary' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'RegistryType', ], 'TypeName' => [ 'shape' => 'TypeName', ], 'VersionId' => [ 'shape' => 'TypeVersionId', ], 'Arn' => [ 'shape' => 'TypeArn', ], 'TimeCreated' => [ 'shape' => 'Timestamp', ], 'Description' => [ 'shape' => 'Description', ], ], ], 'UpdateStackInput' => [ 'type' => 'structure', 'required' => [ 'StackName', ], 'members' => [ 'StackName' => [ 'shape' => 'StackName', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'UsePreviousTemplate' => [ 'shape' => 'UsePreviousTemplate', ], 'StackPolicyDuringUpdateBody' => [ 'shape' => 'StackPolicyDuringUpdateBody', ], 'StackPolicyDuringUpdateURL' => [ 'shape' => 'StackPolicyDuringUpdateURL', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'ResourceTypes' => [ 'shape' => 'ResourceTypes', ], 'RoleARN' => [ 'shape' => 'RoleARN', ], 'RollbackConfiguration' => [ 'shape' => 'RollbackConfiguration', ], 'StackPolicyBody' => [ 'shape' => 'StackPolicyBody', ], 'StackPolicyURL' => [ 'shape' => 'StackPolicyURL', ], 'NotificationARNs' => [ 'shape' => 'NotificationARNs', ], 'Tags' => [ 'shape' => 'Tags', ], 'ClientRequestToken' => [ 'shape' => 'ClientRequestToken', ], ], ], 'UpdateStackInstancesInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', 'Regions', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetNameOrId', ], 'Accounts' => [ 'shape' => 'AccountList', ], 'DeploymentTargets' => [ 'shape' => 'DeploymentTargets', ], 'Regions' => [ 'shape' => 'RegionList', ], 'ParameterOverrides' => [ 'shape' => 'Parameters', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], ], ], 'UpdateStackInstancesOutput' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'UpdateStackOutput' => [ 'type' => 'structure', 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], ], ], 'UpdateStackSetInput' => [ 'type' => 'structure', 'required' => [ 'StackSetName', ], 'members' => [ 'StackSetName' => [ 'shape' => 'StackSetName', ], 'Description' => [ 'shape' => 'Description', ], 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], 'UsePreviousTemplate' => [ 'shape' => 'UsePreviousTemplate', ], 'Parameters' => [ 'shape' => 'Parameters', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Tags' => [ 'shape' => 'Tags', ], 'OperationPreferences' => [ 'shape' => 'StackSetOperationPreferences', ], 'AdministrationRoleARN' => [ 'shape' => 'RoleARN', ], 'ExecutionRoleName' => [ 'shape' => 'ExecutionRoleName', ], 'DeploymentTargets' => [ 'shape' => 'DeploymentTargets', ], 'PermissionModel' => [ 'shape' => 'PermissionModels', ], 'AutoDeployment' => [ 'shape' => 'AutoDeployment', ], 'OperationId' => [ 'shape' => 'ClientRequestToken', 'idempotencyToken' => true, ], 'Accounts' => [ 'shape' => 'AccountList', ], 'Regions' => [ 'shape' => 'RegionList', ], ], ], 'UpdateStackSetOutput' => [ 'type' => 'structure', 'members' => [ 'OperationId' => [ 'shape' => 'ClientRequestToken', ], ], ], 'UpdateTerminationProtectionInput' => [ 'type' => 'structure', 'required' => [ 'EnableTerminationProtection', 'StackName', ], 'members' => [ 'EnableTerminationProtection' => [ 'shape' => 'EnableTerminationProtection', ], 'StackName' => [ 'shape' => 'StackNameOrId', ], ], ], 'UpdateTerminationProtectionOutput' => [ 'type' => 'structure', 'members' => [ 'StackId' => [ 'shape' => 'StackId', ], ], ], 'Url' => [ 'type' => 'string', ], 'UsePreviousTemplate' => [ 'type' => 'boolean', ], 'UsePreviousValue' => [ 'type' => 'boolean', ], 'ValidateTemplateInput' => [ 'type' => 'structure', 'members' => [ 'TemplateBody' => [ 'shape' => 'TemplateBody', ], 'TemplateURL' => [ 'shape' => 'TemplateURL', ], ], ], 'ValidateTemplateOutput' => [ 'type' => 'structure', 'members' => [ 'Parameters' => [ 'shape' => 'TemplateParameters', ], 'Description' => [ 'shape' => 'Description', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'CapabilitiesReason' => [ 'shape' => 'CapabilitiesReason', ], 'DeclaredTransforms' => [ 'shape' => 'TransformsList', ], ], ], 'Value' => [ 'type' => 'string', ], 'Version' => [ 'type' => 'string', ], 'Visibility' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'PRIVATE', ], ], ],];
