/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Predicate;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables$4;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterables$5;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Iterators;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Lists;
import java.util.Collection;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Iterables {
    public static String toString(Iterable iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static Object getOnlyElement(Iterable iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    static Object[] toArray(Iterable iterable, Object[] objectArray) {
        Collection collection = Iterables.castOrCopyToCollection(iterable);
        return collection.toArray(objectArray);
    }

    static Object[] toArray(Iterable iterable) {
        return Iterables.castOrCopyToCollection(iterable).toArray();
    }

    private static Collection castOrCopyToCollection(Iterable iterable) {
        return iterable instanceof Collection ? (Collection)iterable : Lists.newArrayList(iterable.iterator());
    }

    public static Iterable filter(Iterable iterable, Predicate predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        return new Iterables$4(iterable, predicate);
    }

    public static Iterable transform(Iterable iterable, Function function) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(function);
        return new Iterables$5(iterable, function);
    }

    @NullableDecl
    public static Object getFirst(Iterable iterable, @NullableDecl Object object) {
        return Iterators.getNext(iterable.iterator(), object);
    }
}

