/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.expr;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.NeedsBackfillException;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.expr.SolverHint;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedConstructor;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExpressionSolver<T extends PatternExpression> {
    private Class<T> tcls;
    protected RecursiveDescentSolver solver;
    protected final DbgTimer dbg = DbgTimer.INACTIVE;

    public AbstractExpressionSolver(Class<T> tcls) {
        this.tcls = tcls;
    }

    public abstract AssemblyResolution solve(T var1, MaskedLong var2, Map<String, Long> var3, Map<Integer, Object> var4, AssemblyResolvedConstructor var5, Set<SolverHint> var6, String var7) throws NeedsBackfillException;

    public abstract MaskedLong getValue(T var1, Map<String, Long> var2, Map<Integer, Object> var3, AssemblyResolvedConstructor var4) throws NeedsBackfillException;

    public abstract int getInstructionLength(T var1, Map<Integer, Object> var2);

    public abstract MaskedLong valueForResolution(T var1, AssemblyResolvedConstructor var2);

    protected void register(RecursiveDescentSolver general) {
        this.solver = general;
        general.register(this.tcls, this);
    }
}

