/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.OldGenericNamespaceAddress;
import ghidra.program.model.lang.Register;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class RegisterManager {
    Register[] registers;
    Register contextBaseRegister;
    Map<String, Register> registerNameMap = new HashMap<String, Register>();
    Map<RegisterSizeKey, Register> sizeMap = new HashMap<RegisterSizeKey, Register>();
    Map<Address, List<Register>> registerAddressMap = new HashMap<Address, List<Register>>();
    private TreeSet<Register> sortedVectorRegisters;
    private static Comparator<Register> registerSizeComparator = new Comparator<Register>(){

        @Override
        public int compare(Register r1, Register r2) {
            return r2.getBitLength() - r1.getBitLength();
        }
    };

    RegisterManager(Register[] cookedRegisters) {
        this.registers = cookedRegisters;
        this.initialize();
    }

    private void initialize() {
        ArrayList<Register> registerList = new ArrayList<Register>(Arrays.asList(this.registers));
        Collections.sort(registerList, registerSizeComparator);
        for (Register reg : registerList) {
            Address addr;
            List<Register> list;
            this.registerNameMap.put(reg.getName(), reg);
            for (String alias : reg.getAliases()) {
                this.registerNameMap.put(alias, reg);
            }
            if (reg.isProcessorContext() && reg.isBaseRegister()) {
                this.contextBaseRegister = reg;
            }
            if ((list = this.registerAddressMap.get(addr = reg.getAddress())) == null) {
                list = new ArrayList<Register>();
                this.registerAddressMap.put(addr, list);
            }
            list.add(reg);
            if (reg.isProcessorContext()) continue;
            if (reg.isBigEndian()) {
                this.populateSizeMapBigEndian(reg);
                continue;
            }
            this.populateSizeMapLittleEndian(reg);
        }
        Collections.reverse(registerList);
        for (Register register : registerList) {
            this.sizeMap.put(new RegisterSizeKey(register.getAddress(), 0), register);
        }
    }

    private void populateSizeMapBigEndian(Register reg) {
        int regSize = reg.getMinimumByteSize();
        for (int i = 1; i <= regSize; ++i) {
            Address address = reg.getAddress().add(regSize - i);
            this.sizeMap.put(new RegisterSizeKey(address, i), reg);
        }
    }

    private void populateSizeMapLittleEndian(Register reg) {
        int regSize = reg.getMinimumByteSize();
        for (int i = 1; i <= regSize; ++i) {
            this.sizeMap.put(new RegisterSizeKey(reg.getAddress(), i), reg);
        }
    }

    public Register getContextBaseRegister() {
        return this.contextBaseRegister;
    }

    public Register getRegister(Address addr) {
        if (!addr.isRegisterAddress() && !addr.getAddressSpace().hasMappedRegisters()) {
            return null;
        }
        return this.sizeMap.get(new RegisterSizeKey(addr, 0));
    }

    public Register[] getRegisters(Address addr) {
        List<Register> list;
        if ((addr.isRegisterAddress() || addr.getAddressSpace().hasMappedRegisters()) && (list = this.registerAddressMap.get(this.getGlobalAddress(addr))) != null) {
            Register[] regs = new Register[list.size()];
            list.toArray(regs);
            return regs;
        }
        return new Register[0];
    }

    private Address getGlobalAddress(Address addr) {
        if (addr instanceof OldGenericNamespaceAddress) {
            return ((OldGenericNamespaceAddress)addr).getGlobalAddress();
        }
        return addr;
    }

    public Register getRegister(Address addr, int size) {
        if (!addr.isRegisterAddress() && !addr.getAddressSpace().hasMappedRegisters()) {
            return null;
        }
        return this.sizeMap.get(new RegisterSizeKey(addr, size));
    }

    public Register getRegister(String name) {
        return this.registerNameMap.get(name);
    }

    public Register[] getRegisters() {
        return this.registers;
    }

    public Register[] getSortedVectorRegisters() {
        if (this.sortedVectorRegisters == null) {
            this.sortedVectorRegisters = new TreeSet(RegisterManager::compareVectorRegisters);
            for (Register reg : this.getRegisters()) {
                if (!reg.isVectorRegister()) continue;
                this.sortedVectorRegisters.add(reg);
            }
        }
        return this.sortedVectorRegisters.toArray(new Register[0]);
    }

    private static int compareVectorRegisters(Register reg1, Register reg2) {
        if (!reg1.isVectorRegister() || !reg2.isVectorRegister()) {
            throw new IllegalArgumentException("compareVectorRegisters can only be applied to vector registers!");
        }
        int sizeComp = Integer.compare(reg2.getBitLength(), reg1.getBitLength());
        if (sizeComp != 0) {
            return sizeComp;
        }
        return Integer.compare(reg1.getOffset(), reg2.getOffset());
    }

    class RegisterSizeKey {
        Address address;
        int size;

        public RegisterSizeKey(Address addr, int size) {
            this.address = RegisterManager.this.getGlobalAddress(addr);
            this.size = size < 0 ? 0 : size;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            RegisterSizeKey other = (RegisterSizeKey)obj;
            return other.address.equals(this.address) && other.size == this.size;
        }

        public int hashCode() {
            return this.address.hashCode() << 8 + this.size;
        }

        public String toString() {
            return "{" + this.address.toString() + ", size = " + this.size + "}";
        }
    }
}

