/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.service.FidMatch;
import ghidra.feature.fid.service.NameVersions;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MatchNameAnalysis {
    private Set<String> finalNameList = null;
    private TreeSet<String> rawNames = null;
    private TreeSet<String> similarBaseNames = null;
    private TreeSet<String> exactDemangledBaseNames = null;
    private TreeSet<String> libraries = null;
    private int mostOptimisticCount;
    private float overallScore = 0.0f;

    public int numNames() {
        return this.finalNameList.size();
    }

    public Iterator<String> getRawNameIterator() {
        return this.rawNames.iterator();
    }

    public Iterator<String> getNameIterator() {
        return this.finalNameList.iterator();
    }

    public int numSimilarNames() {
        return this.similarBaseNames.size();
    }

    public int numLibraries() {
        return this.libraries.size();
    }

    public Iterator<String> getLibraryIterator() {
        return this.libraries.iterator();
    }

    public int getMostOptimisticCount() {
        return this.mostOptimisticCount;
    }

    public float getOverallScore() {
        return this.overallScore;
    }

    public void analyzeNames(List<FidMatch> matches, Program program, TaskMonitor monitor) throws CancelledException {
        this.rawNames = new TreeSet();
        this.similarBaseNames = new TreeSet();
        this.exactDemangledBaseNames = new TreeSet();
        int cannotDemangle = 0;
        for (FidMatch match : matches) {
            monitor.checkCanceled();
            FunctionRecord function = match.getFunctionRecord();
            NameVersions nameVersions = NameVersions.generate(function.getName(), program);
            if (nameVersions.rawName == null) continue;
            this.rawNames.add(nameVersions.rawName);
            this.similarBaseNames.add(nameVersions.similarName);
            if (nameVersions.demangledBaseName != null) {
                this.exactDemangledBaseNames.add(nameVersions.demangledBaseName);
                continue;
            }
            ++cannotDemangle;
        }
        String singleName = null;
        this.mostOptimisticCount = this.rawNames.size();
        this.finalNameList = this.rawNames;
        if (this.rawNames.size() == 1) {
            singleName = this.rawNames.first();
        } else {
            singleName = this.findCommonBaseName();
            this.mostOptimisticCount = this.similarBaseNames.size();
            if (singleName == null) {
                singleName = this.findCommonDemangledBaseName(cannotDemangle);
                if (this.exactDemangledBaseNames.size() > 0 && this.exactDemangledBaseNames.size() < this.mostOptimisticCount) {
                    this.mostOptimisticCount = this.exactDemangledBaseNames.size();
                }
            }
        }
        if (singleName != null) {
            this.mostOptimisticCount = 1;
            this.finalNameList = Collections.singleton(singleName);
        }
        if (matches.size() > 0) {
            this.overallScore = matches.get(0).getOverallScore();
        }
    }

    public void analyzeLibraries(Collection<FidMatch> matches, int libraryLimit, TaskMonitor monitor) throws CancelledException {
        Object familyVersion;
        LibraryRecord libraryRecord;
        this.libraries = new TreeSet();
        for (FidMatch match : matches) {
            String library = match.getLibraryRecord().toString();
            if (library != null) {
                this.libraries.add(library);
            }
            if (this.libraries.size() < libraryLimit) continue;
            break;
        }
        if (this.libraries.size() >= libraryLimit) {
            this.libraries.clear();
            for (FidMatch match : matches) {
                monitor.checkCanceled();
                libraryRecord = match.getLibraryRecord();
                familyVersion = libraryRecord.getLibraryFamilyName() + " " + libraryRecord.getLibraryVersion();
                this.libraries.add((String)familyVersion);
                if (this.libraries.size() < libraryLimit) continue;
                break;
            }
        }
        if (this.libraries.size() >= libraryLimit) {
            this.libraries.clear();
            for (FidMatch match : matches) {
                monitor.checkCanceled();
                libraryRecord = match.getLibraryRecord();
                familyVersion = libraryRecord.getLibraryFamilyName();
                this.libraries.add((String)familyVersion);
            }
        }
    }

    private String findCommonBaseName() {
        if (this.similarBaseNames.size() == 1) {
            return this.rawNames.iterator().next();
        }
        return null;
    }

    public static String removeTemplateParams(String name) {
        int pos2;
        int pos1 = name.indexOf(60);
        if (pos1 < 0) {
            return null;
        }
        int nesting = 1;
        for (pos2 = pos1 + 1; pos2 < name.length(); ++pos2) {
            char c = name.charAt(pos2);
            if (c == '<') {
                ++nesting;
                continue;
            }
            if (c == '>' && --nesting == 0) break;
        }
        if (nesting != 0) {
            return null;
        }
        return name.substring(0, pos1 + 1) + name.substring(pos2);
    }

    private String findCommonDemangledBaseName(int cannotDemangle) {
        if (cannotDemangle > 0) {
            return null;
        }
        if (this.exactDemangledBaseNames.size() == 1) {
            return this.exactDemangledBaseNames.iterator().next();
        }
        String finalName = null;
        for (String name : this.exactDemangledBaseNames) {
            String templateFree = MatchNameAnalysis.removeTemplateParams(name);
            if (templateFree == null) {
                return null;
            }
            if (finalName == null) {
                finalName = templateFree;
                continue;
            }
            if (finalName.equals(templateFree)) continue;
            return null;
        }
        return finalName;
    }

    public Set<String> getAppriateNamesSet() {
        if (this.exactDemangledBaseNames.size() > 1 && this.rawNames.size() > 1) {
            return this.exactDemangledBaseNames;
        }
        if (this.rawNames.size() == this.similarBaseNames.size() * 2) {
            return this.similarBaseNames;
        }
        return this.rawNames;
    }
}

