/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction31t
extends OffsetInstruction
implements SingleRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private int targetAddressOffset;

    public Instruction31t(Opcode opcode, short regA, int offB) {
        super(opcode);
        if (regA >= 256) {
            throw new RuntimeException("The register number must be less than v256");
        }
        this.regA = (byte)regA;
        this.targetAddressOffset = offB;
    }

    private Instruction31t(Opcode opcode, byte[] buffer, int bufferIndex) {
        super(opcode);
        this.regA = buffer[bufferIndex + 1];
        this.targetAddressOffset = NumberUtils.decodeInt(buffer, bufferIndex + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput out, int currentCodeAddress) {
        out.writeByte(this.opcode.value);
        out.writeByte(this.regA);
        out.writeInt(this.targetAddressOffset + (currentCodeAddress + this.targetAddressOffset) % 2);
    }

    @Override
    public void updateTargetAddressOffset(int targetAddressOffset) {
        this.targetAddressOffset = targetAddressOffset;
    }

    @Override
    public Format getFormat() {
        return Format.Format31t;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] buffer, int bufferIndex) {
            return new Instruction31t(opcode, buffer, bufferIndex);
        }
    }
}

