/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.options.editor.OptionsEditorPanel;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.feature.vt.api.main.VTProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.framework.options.EditorStateFactory;
import ghidra.framework.options.Options;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.layout.MiddleLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import util.CollectionUtils;

public class OptionsPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private static final Dimension DEFAULT_PREFERRED_SIZE = new Dimension(650, 350);
    private List<OptionsEditorPanel> optionsEditorPanelList;
    private List<VTOptions> optionsList = null;
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            OptionsPanel.this.notifyListenersOfValidityChanged();
        }
    };

    OptionsPanel() {
        super((LayoutManager)new BorderLayout());
    }

    public HelpLocation getHelpLocation() {
        if (this.optionsList != null) {
            for (VTOptions options : this.optionsList) {
                HelpLocation helpLocation;
                if (options == null || (helpLocation = options.getOptionsHelpLocation()) == null) continue;
                return helpLocation;
            }
        }
        return new HelpLocation("VersionTrackingPlugin", "Options_Panel");
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (preferredSize.width < OptionsPanel.DEFAULT_PREFERRED_SIZE.width) {
            return DEFAULT_PREFERRED_SIZE;
        }
        return preferredSize;
    }

    public void dispose() {
        if (this.optionsEditorPanelList != null) {
            this.removeAll();
            this.optionsEditorPanelList = null;
            this.optionsList = null;
        }
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        this.dispose();
        List<VTProgramCorrelatorFactory> correlatorFactoryList = this.getCorrelators(state);
        this.optionsList = this.getCorrelatorOptions(state);
        if (this.optionsList == null) {
            this.optionsList = this.generateDefaultOptions(state);
        }
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(30));
        this.optionsEditorPanelList = new ArrayList<OptionsEditorPanel>();
        for (int i = 0; i < correlatorFactoryList.size(); ++i) {
            String correlatorName = correlatorFactoryList.get(i).getName();
            String title = correlatorName + " Options";
            if (this.optionsList.get(i) == null) continue;
            EditorStateFactory editorStateFactory = new EditorStateFactory();
            Options options = (Options)this.optionsList.get(i);
            List optionNames = options.getLeafOptionNames();
            if (optionNames.isEmpty()) continue;
            OptionsEditorPanel optionsPanel = new OptionsEditorPanel(title, options, optionNames, editorStateFactory);
            optionsPanel.setOptionsPropertyChangeListener(this.propertyChangeListener);
            this.optionsEditorPanelList.add(optionsPanel);
            panel.add((Component)optionsPanel);
        }
        JPanel outerPanel = new JPanel((LayoutManager)new MiddleLayout());
        outerPanel.add(panel);
        JScrollPane scrollPane = new JScrollPane(outerPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.add(scrollPane);
    }

    private List<VTOptions> generateDefaultOptions(WizardState<VTWizardStateKey> state) {
        ArrayList<VTOptions> list = new ArrayList<VTOptions>();
        List<VTProgramCorrelatorFactory> correlatorFactoryList = this.getCorrelators(state);
        for (VTProgramCorrelatorFactory vtProgramCorrelatorFactory : correlatorFactoryList) {
            list.add(vtProgramCorrelatorFactory.createDefaultOptions());
        }
        return list;
    }

    private List<VTOptions> getCorrelatorOptions(WizardState<VTWizardStateKey> state) {
        List list = (List)state.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_OPTIONS_LIST);
        if (list == null) {
            return null;
        }
        return CollectionUtils.asList((List)list, VTOptions.class);
    }

    private List<VTProgramCorrelatorFactory> getCorrelators(WizardState<VTWizardStateKey> state) {
        List list = (List)state.get((Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST);
        if (list == null) {
            return null;
        }
        return CollectionUtils.asList((List)list, VTProgramCorrelatorFactory.class);
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        List<VTOptions> tmpOptions = this.getCorrelatorOptions(state);
        if (tmpOptions == null) {
            tmpOptions = this.generateDefaultOptions(state);
        }
        for (VTOptions vtOptions : tmpOptions) {
            List names;
            if (vtOptions == null || (names = vtOptions.getOptionNames()).isEmpty()) continue;
            return WizardPanelDisplayability.MUST_BE_DISPLAYED;
        }
        return WizardPanelDisplayability.DO_NOT_DISPLAY;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        if (this.optionsList != null) {
            this.applyOptions();
        }
        List<VTOptions> newOptions = this.optionsList != null ? this.optionsList : this.generateDefaultOptions(state);
        state.put((Object)VTWizardStateKey.PROGRAM_CORRELATOR_OPTIONS_LIST, newOptions);
    }

    public String getTitle() {
        return "Correlator Options";
    }

    public void initialize() {
    }

    public boolean isValidInformation() {
        this.applyOptions();
        for (VTOptions options : this.optionsList) {
            if (options == null || options.validate()) continue;
            return false;
        }
        return true;
    }

    private void applyOptions() {
        try {
            for (OptionsEditorPanel panel : this.optionsEditorPanelList) {
                panel.apply();
            }
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)((Object)this), (String)"Error", (Object)"could not apply options settings", (Throwable)e);
        }
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
        state.addDependency((Object)VTWizardStateKey.PROGRAM_CORRELATOR_OPTIONS_LIST, (Object)VTWizardStateKey.PROGRAM_CORRELATOR_FACTORY_LIST);
    }
}

