/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentTransferableData;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class ComponentTransferable
implements Transferable,
ClipboardOwner {
    private static final Logger LOGGER = LogManager.getLogger(ComponentTransferable.class);
    public static DataFlavor localComponentProviderFlavor = ComponentTransferable.createLocalComponentProviderFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localComponentProviderFlavor};
    private ComponentTransferableData provider;

    private static DataFlavor createLocalComponentProviderFlavor() {
        try {
            return new DataFlavor(ComponentTransferableData.class, "Component Provider");
        }
        catch (Exception e) {
            Msg.error((Object)LOGGER, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    ComponentTransferable(ComponentTransferableData provider) {
        this.provider = provider;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return f == localComponentProviderFlavor;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localComponentProviderFlavor)) {
            return this.provider;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "ComponentProviderTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    void clearTransferData() {
        this.provider = null;
    }
}

