/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.CountLeadingZerosOpBehavior;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.memstate.MemoryState;
import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public class PPCEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    public PPCEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.registerPcodeOpBehavior("countLeadingZeros", (OpBehaviorOther)new CountLeadingZerosOpBehavior());
        this.registerPcodeOpBehavior("vectorPermute", new vectorPermuteOpBehavior());
    }

    private static byte[] getUnsignedValueArray(byte[] srcBytes, int byteLength) {
        if (srcBytes.length == byteLength) {
            return srcBytes;
        }
        byte[] result = new byte[byteLength];
        int srcStartIndex = Math.max(0, srcBytes.length - byteLength);
        int copyCount = Math.min(byteLength, srcBytes.length);
        int destStartIndex = byteLength - copyCount;
        System.arraycopy(srcBytes, srcStartIndex, result, destStartIndex, copyCount);
        return result;
    }

    private class vectorPermuteOpBehavior
    implements OpBehaviorOther {
        private vectorPermuteOpBehavior() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            if (out == null) {
                throw new LowlevelError("CALLOTHER: Vector permute op missing required output");
            }
            if (inputs.length != 4) {
                throw new LowlevelError("CALLOTHER: Vector permute op requires three non-constant varnode input");
            }
            for (int i = 1; i < 4; ++i) {
                if (inputs[i].getSize() != 0 && !inputs[i].isConstant()) continue;
                throw new LowlevelError("CALLOTHER: Vector permute op requires three non-constant varnode input");
            }
            Varnode in1 = inputs[1];
            Varnode in2 = inputs[2];
            Varnode in3 = inputs[3];
            if (in1.getSize() != 16 || in2.getSize() != 16 || in3.getSize() != 16 || out.getSize() != 16) {
                throw new LowlevelError("CALLOTHER: Vector permute op inputs/output must be 16bytes long");
            }
            MemoryState memoryState = emu.getMemoryState();
            BigInteger src = memoryState.getBigInteger(in1, false);
            src = src.shiftLeft(128);
            src = src.or(memoryState.getBigInteger(in2, false));
            byte[] srcin = PPCEmulateInstructionStateModifier.getUnsignedValueArray(src.toByteArray(), 32);
            byte[] pin = memoryState.getBigInteger(in3, false).toByteArray();
            byte[] permute = PPCEmulateInstructionStateModifier.getUnsignedValueArray(pin, 16);
            byte[] outarray = new byte[16];
            for (int i = 0; i < 16; ++i) {
                outarray[i] = srcin[permute[i] & 0x1F];
            }
            memoryState.setValue(out, new BigInteger(outarray));
        }
    }
}

