/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bean;

import docking.widgets.label.GLabel;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.TableSortingContext;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.VersionedLanguageService;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SelectLanguagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GhidraTable table;
    private LanguageModel model;
    private JTextField filterField;

    public static void main(String[] args) {
        SelectLanguagePanel slp = new SelectLanguagePanel(null);
        JDialog dialog = new JDialog((Frame)new JFrame(), "Select Language Panel");
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)slp, "Center");
        dialog.pack();
        dialog.setVisible(true);
    }

    public SelectLanguagePanel(LanguageService service) {
        this.model = new LanguageModel(service);
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setAutoLookupColumn(0);
        this.table.setName("LanguageTable");
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(2);
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }
        });
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(0).setPreferredWidth(250);
        tcm.getColumn(1).setPreferredWidth(75);
        tcm.getColumn(2).setPreferredWidth(75);
        this.filterField = new JTextField();
        this.filterField.setName("SET_LANG_FILTER");
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectLanguagePanel.this.filter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectLanguagePanel.this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectLanguagePanel.this.filter();
            }
        });
        this.filterField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SelectLanguagePanel.this.filterField.selectAll();
            }
        });
        JPanel filterPanel = new JPanel(new BorderLayout());
        filterPanel.add((Component)new GLabel("Filter:"), "West");
        filterPanel.add((Component)this.filterField, "Center");
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)new JScrollPane((Component)((Object)this.table)), "Center");
        this.add((Component)filterPanel, "South");
        this.model.update();
    }

    public void setShowVersion(boolean enable) {
        this.model.setShowVersion(enable);
        this.model.fireTableDataChanged();
    }

    public void setSelectedLanguage(LanguageID languageID) {
        if (this.model.service == null) {
            return;
        }
        Language lang = null;
        try {
            lang = this.model.service.getLanguage(languageID);
        }
        catch (LanguageNotFoundException languageNotFoundException) {
            // empty catch block
        }
        this.setSelectedLanguage(lang);
    }

    public void setSelectedLanguage(Language lang) {
        if (this.model.contains(lang)) {
            int row = this.model.getRow(lang);
            this.table.setRowSelectionInterval(row, row);
            Rectangle rect = this.table.getCellRect(row, 0, true);
            this.table.scrollRectToVisible(rect);
        } else {
            this.table.clearSelection();
        }
    }

    public void setLanguageService(LanguageService service) {
        this.model.service = service;
        this.update();
    }

    public void dispose() {
        this.model.dispose();
    }

    public void update() {
        this.model.update();
    }

    public Language getSelectedLanguage() {
        int row = this.table.getSelectedRow();
        return this.model.getLanguage(row);
    }

    public int setFilter(String filter) {
        this.filterField.setText(filter);
        return this.model.getRowCount();
    }

    public void selectHighestPriorityLanguage() {
        Language lang = this.model.getHighestPriority();
        this.setSelectedLanguage(lang);
    }

    private void filter() {
        String filter = this.filterField.getText();
        this.model.filter(filter);
    }

    private class LanguageModel
    extends AbstractSortedTableModel<LanguageDescription> {
        private static final int NAME_COL = 0;
        private static final int PROCESSOR_COL = 1;
        private static final int MANUFACTURER_COL = 2;
        private static final int NO_FILTER = 0;
        private static final int STARTS_WITH_FILTER = 1;
        private static final int ENDS_WITH_FILTER = 2;
        private static final int EQUALS_FILTER = 3;
        private static final int CONTAINS_FILTER = 4;
        private LanguageService service;
        private LanguageDescription[] masterList;
        private List<LanguageDescription> displayList;
        private String filter;
        private int filterType;
        private boolean showVersion;

        private LanguageModel(LanguageService service) {
            super(0);
            this.masterList = new LanguageDescription[0];
            this.displayList = new ArrayList<LanguageDescription>();
            this.filterType = 0;
            this.showVersion = false;
            this.service = service;
        }

        void setShowVersion(boolean enable) {
            this.showVersion = enable;
        }

        public boolean isSortable(int columnIndex) {
            return true;
        }

        protected void sort(List<LanguageDescription> data, TableSortingContext<LanguageDescription> sortingContext) {
            Language selectedLang = SelectLanguagePanel.this.getSelectedLanguage();
            super.sort(data, sortingContext);
            SelectLanguagePanel.this.setSelectedLanguage(selectedLang);
        }

        private Language getHighestPriority() {
            if (this.displayList.isEmpty()) {
                return null;
            }
            LanguageDescription supremeLang = null;
            for (LanguageDescription ld : this.displayList) {
                if (supremeLang != null) continue;
                supremeLang = ld;
            }
            if (supremeLang == null) {
                return null;
            }
            try {
                return this.service.getLanguage(supremeLang.getLanguageID());
            }
            catch (LanguageNotFoundException e) {
                return null;
            }
        }

        private boolean contains(Language lang) {
            if (lang == null) {
                return false;
            }
            return this.getRow(lang) >= 0;
        }

        private int getRow(Language lang) {
            if (lang == null) {
                return -1;
            }
            int index = 0;
            for (LanguageDescription ld : this.displayList) {
                if (ld.getLanguageID().equals((Object)lang.getLanguageID())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        private Language getLanguage(int row) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            if (this.service == null) {
                return null;
            }
            LanguageDescription languageDescription = this.displayList.get(row);
            LanguageID id = languageDescription.getLanguageID();
            try {
                if (this.service instanceof VersionedLanguageService) {
                    return ((VersionedLanguageService)this.service).getLanguage(id, languageDescription.getVersion());
                }
                return this.service.getLanguage(id);
            }
            catch (LanguageNotFoundException languageNotFoundException) {
                return null;
            }
        }

        public void dispose() {
            this.service = null;
            this.update();
        }

        private void filter(String f) {
            if (f == null) {
                this.filterType = 0;
            } else {
                if (f.length() > 1 && f.startsWith("\"") && f.endsWith("\"")) {
                    this.filterType = 3;
                    this.filter = f.substring(1, f.length() - 1);
                } else if (f.startsWith("\"")) {
                    this.filterType = 1;
                    this.filter = f.substring(1, f.length());
                } else if (f.endsWith("\"")) {
                    this.filterType = 2;
                    this.filter = f.substring(0, f.length() - 1);
                } else {
                    this.filterType = 4;
                    this.filter = f;
                }
                this.filter = this.filter.toLowerCase();
            }
            this.filter();
        }

        private boolean matchesFilter(String str) {
            switch (this.filterType) {
                case 1: {
                    return str.toLowerCase().startsWith(this.filter);
                }
                case 2: {
                    return str.toLowerCase().endsWith(this.filter);
                }
                case 3: {
                    return str.equalsIgnoreCase(this.filter);
                }
                case 4: {
                    return str.toLowerCase().indexOf(this.filter) >= 0;
                }
            }
            return true;
        }

        private void filter() {
            Language selectedLang = SelectLanguagePanel.this.getSelectedLanguage();
            this.displayList.clear();
            if (this.filter == null) {
                this.displayList.addAll(Arrays.asList(this.masterList));
            } else {
                for (LanguageDescription element : this.masterList) {
                    if (!this.matchesFilter(element.getLanguageID().getIdAsString()) && !this.matchesFilter(element.getProcessor().toString())) continue;
                    this.displayList.add(element);
                }
            }
            this.fireTableDataChanged();
            SelectLanguagePanel.this.setSelectedLanguage(selectedLang);
        }

        protected Comparator<LanguageDescription> createSortComparator(int columnIndex) {
            return new LanguageDescriptionComparator(columnIndex);
        }

        private void update() {
            this.masterList = this.service == null ? new LanguageDescription[0] : this.service.getLanguageDescriptions(false).toArray(new LanguageDescription[0]);
            this.filter();
        }

        public Class<String> getColumnClass(int aColumn) {
            return String.class;
        }

        public int getRowCount() {
            return this.displayList.size();
        }

        private String getLanguageDisplayName(LanguageDescription ld) {
            LanguageID id = ld.getLanguageID();
            Object langDisplayName = id.toString();
            if (this.showVersion) {
                langDisplayName = id.toString() + " (" + ld.getVersion() + "." + ld.getMinorVersion() + ")";
            }
            return langDisplayName;
        }

        public String getName() {
            return "Select Language";
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int aColumn) {
            switch (aColumn) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Processor";
                }
                case 2: {
                    return "Manufacturer";
                }
            }
            return "Unknown";
        }

        public Object getColumnValueForRow(LanguageDescription ld, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getLanguageDisplayName(ld);
                }
                case 1: {
                    return ld.getProcessor().toString();
                }
            }
            return "Unknown";
        }

        public List<LanguageDescription> getModelData() {
            return this.displayList;
        }

        class LanguageDescriptionComparator
        implements Comparator<LanguageDescription> {
            private final int sortColumn;

            public LanguageDescriptionComparator(int sortColumn) {
                this.sortColumn = sortColumn;
            }

            @Override
            public int compare(LanguageDescription ld1, LanguageDescription ld2) {
                int value = 0;
                switch (this.sortColumn) {
                    case 0: {
                        value = LanguageModel.this.getLanguageDisplayName(ld1).compareTo(LanguageModel.this.getLanguageDisplayName(ld2));
                        break;
                    }
                    case 1: {
                        value = ld1.getProcessor().toString().compareTo(ld2.getProcessor().toString());
                    }
                }
                return value;
            }
        }
    }
}

