/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next;

import ghidra.app.util.bin.format.dwarf4.DIEAggregate;

public class DWARFSourceInfo {
    private final String filename;
    private final int lineNum;

    public static DWARFSourceInfo create(DIEAggregate diea) {
        int fileNum = (int)diea.getUnsignedLong(58, -1L);
        int lineNum = (int)diea.getUnsignedLong(59, -1L);
        return fileNum != -1 && lineNum != -1 ? new DWARFSourceInfo(diea.getCompilationUnit().getCompileUnit().getFileByIndex(fileNum), lineNum) : null;
    }

    public static DWARFSourceInfo getSourceInfoWithFallbackToParent(DIEAggregate diea) {
        DIEAggregate declParent;
        DWARFSourceInfo dsi = DWARFSourceInfo.create(diea);
        if (dsi == null && (declParent = diea.getDeclParent()) != null) {
            dsi = DWARFSourceInfo.create(declParent);
        }
        return dsi;
    }

    public static String getDescriptionStr(DIEAggregate diea) {
        DWARFSourceInfo sourceInfo = DWARFSourceInfo.create(diea);
        return sourceInfo != null ? sourceInfo.getDescriptionStr() : null;
    }

    private DWARFSourceInfo(String filename, int lineNum) {
        this.filename = filename;
        this.lineNum = lineNum;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getDescriptionStr() {
        return this.filename + ":" + this.lineNum;
    }

    public String getDescriptionStr2() {
        return String.format("File: %s Line: %d", this.filename, this.lineNum);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + this.lineNum;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DWARFSourceInfo)) {
            return false;
        }
        DWARFSourceInfo other = (DWARFSourceInfo)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return this.lineNum == other.lineNum;
    }

    public String toString() {
        return "DWARFSourceInfo [filename=" + this.filename + ", lineNum=" + this.lineNum + "]";
    }
}

