/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.ContinuesFactory;
import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.SeparateDebugHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.importer.MessageLogContinuesFactory;
import ghidra.app.util.opinion.AbstractPeDebugLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Conv;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class DbgLoader
extends AbstractPeDebugLoader {
    public static final String DBG_NAME = "Debug Symbols (DBG)";
    private static final long MIN_BYTE_LENGTH = 46L;

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.length() < 46L) {
            return loadSpecs;
        }
        SeparateDebugHeader debug = new SeparateDebugHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
        if (debug.getSignature() == 18756) {
            long imageBase = Conv.intToLong((int)debug.getImageBase());
            String machineName = debug.getMachineName();
            for (QueryResult result : QueryOpinionService.query(this.getName(), machineName, null)) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, imageBase, true));
            }
        }
        return loadSpecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException {
        ContinuesFactory factory = MessageLogContinuesFactory.create((MessageLog)log);
        if (!prog.getExecutableFormat().equals("Portable Executable (PE)")) {
            throw new IOException("Loading of DBG file may only be 'added' to existing Portable Executable (PE) Program");
        }
        SeparateDebugHeader debug = new SeparateDebugHeader((GenericFactory)factory, provider);
        String parentPath = prog.getExecutablePath();
        File parentFile = new File(parentPath);
        try (RandomAccessByteProvider provider2 = null;){
            SectionHeader[] sectionHeaders;
            provider2 = new RandomAccessByteProvider(parentFile);
            PortableExecutable parentPE = PortableExecutable.createPortableExecutable((GenericFactory)factory, provider2, PortableExecutable.SectionLayout.FILE);
            Address imageBase = prog.getImageBase();
            HashMap<SectionHeader, Address> sectionToAddress = new HashMap<SectionHeader, Address>();
            FileHeader fileHeader = parentPE.getNTHeader().getFileHeader();
            for (SectionHeader sectionHeader : sectionHeaders = fileHeader.getSectionHeaders()) {
                sectionToAddress.put(sectionHeader, imageBase.add((long)sectionHeader.getVirtualAddress()));
            }
            this.processDebug(debug.getParser(), fileHeader, sectionToAddress, prog, monitor);
        }
    }

    @Override
    public String getName() {
        return DBG_NAME;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }
}

