/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.menu.MultiActionDockingAction;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigationActionContext;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.base.actions.HorizontalRuleAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Navigation", shortDescription="Navigates to previous locations", description="Provides actions for returning to previously visited program locations.", servicesRequired={NavigationHistoryService.class})
public class NextPrevAddressPlugin
extends Plugin {
    private static final String NAV_GROUP = "GoTo";
    private static ImageIcon previousIcon = ResourceManager.loadImage((String)"images/left.png");
    private static ImageIcon nextIcon = ResourceManager.loadImage((String)"images/right.png");
    private static final String PREVIOUS_ACTION_NAME = "Previous in History Buffer";
    private static final String NEXT_ACTION_NAME = "Next in History Buffer";
    private static final String[] CLEAR_MENUPATH = new String[]{"Navigation", "Clear History"};
    private NavigationHistoryService historyService;
    private MultiActionDockingAction nextAction;
    private MultiActionDockingAction previousAction;
    private DockingAction clearAction;
    private BrowserCodeUnitFormat codeUnitFormatter;
    private static int idCount = 0;

    public NextPrevAddressPlugin(PluginTool plugintool) {
        super(plugintool);
        this.createActions();
    }

    protected void init() {
        this.historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        this.codeUnitFormatter = new BrowserCodeUnitFormat((ServiceProvider)this.tool);
    }

    private List<DockingActionIf> getPreviousActions(Navigatable navigatable) {
        Program lastProgram = null;
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        List<LocationMemento> nextLocations = this.historyService.getPreviousLocations(navigatable);
        for (LocationMemento locationMomento : nextLocations) {
            Program program = locationMomento.getProgram();
            if (program != lastProgram && actionList.size() != 0) {
                actionList.add(this.createHorizontalRule(lastProgram, program));
            }
            lastProgram = program;
            actionList.add((DockingActionIf)new NavigationAction(navigatable, locationMomento, false, this.historyService, this.codeUnitFormatter));
        }
        return actionList;
    }

    private List<DockingActionIf> getNextActions(Navigatable navigatable) {
        Program lastProgram = null;
        ArrayList<DockingActionIf> actionList = new ArrayList<DockingActionIf>();
        List<LocationMemento> nextLocations = this.historyService.getNextLocations(navigatable);
        for (LocationMemento locationMomento : nextLocations) {
            Program program = locationMomento.getProgram();
            if (program != lastProgram && !actionList.isEmpty()) {
                actionList.add(this.createHorizontalRule(lastProgram, program));
            }
            lastProgram = program;
            actionList.add((DockingActionIf)new NavigationAction(navigatable, locationMomento, true, this.historyService, this.codeUnitFormatter));
        }
        return actionList;
    }

    private DockingActionIf createHorizontalRule(Program previousProgram, Program nextProgram) {
        DomainFile previousDomainFile = previousProgram.getDomainFile();
        String topName = previousDomainFile.getName();
        DomainFile nextDomainFile = nextProgram.getDomainFile();
        String bottomName = nextDomainFile.getName();
        return new HorizontalRuleAction(this.getName(), topName, bottomName);
    }

    private void createActions() {
        this.nextAction = new NextPreviousAction(NEXT_ACTION_NAME, this.getName(), true);
        this.previousAction = new NextPreviousAction(PREVIOUS_ACTION_NAME, this.getName(), false);
        this.clearAction = new DockingAction("Clear History Buffer", this.getName()){

            public void actionPerformed(ActionContext context) {
                NextPrevAddressPlugin.this.historyService.clear(NextPrevAddressPlugin.this.getNavigatable(context));
            }

            public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
                for (Class<?> class1 : contextTypes) {
                    if (!NavigationActionContext.class.isAssignableFrom(class1)) continue;
                    return true;
                }
                return false;
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (!(context instanceof ProgramActionContext)) {
                    return false;
                }
                Navigatable navigatable = NextPrevAddressPlugin.this.getNavigatable(context);
                boolean hasNext = NextPrevAddressPlugin.this.historyService.hasNext(navigatable);
                boolean hasPrevious = NextPrevAddressPlugin.this.historyService.hasPrevious(navigatable);
                return hasNext || hasPrevious;
            }
        };
        this.clearAction.setHelpLocation(new HelpLocation("Navigation", this.clearAction.getName()));
        MenuData menuData = new MenuData(CLEAR_MENUPATH, NAV_GROUP);
        menuData.setMenuSubGroup("1");
        this.clearAction.setMenuBarData(menuData);
        this.tool.addAction((DockingActionIf)this.previousAction);
        this.tool.addAction((DockingActionIf)this.nextAction);
        this.tool.addAction((DockingActionIf)this.clearAction);
    }

    private static String truncateAsNecessary(String value) {
        int maxNameLength = 25;
        if (((String)value).length() > maxNameLength) {
            value = ((String)value).substring(0, maxNameLength - 2) + "...";
        }
        return value;
    }

    private static String buildActionName(LocationMemento location, CodeUnitFormat formatter) {
        Program program = location.getProgram();
        Address address = location.getProgramLocation().getAddress();
        StringBuffer buffy = new StringBuffer();
        buffy.append(address.toString()).append('\t');
        FunctionManager functionManager = program.getFunctionManager();
        Function function = functionManager.getFunctionContaining(address);
        if (function != null) {
            Address entryPointAddress = function.getEntryPoint();
            String offset = null;
            if (!entryPointAddress.equals((Object)address)) {
                offset = Long.toHexString(address.subtract(entryPointAddress));
            }
            buffy.append('(').append(NextPrevAddressPlugin.truncateAsNecessary(function.getName()));
            if (offset != null) {
                buffy.append("+0x").append(offset);
            }
            buffy.append(')');
        }
        buffy.append('\t');
        String representation = NextPrevAddressPlugin.getAddressRepresentation(program, address, formatter);
        if (representation != null) {
            buffy.append(representation);
        }
        return buffy.toString();
    }

    private static String getAddressRepresentation(Program program, Address address, CodeUnitFormat formatter) {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(address);
        if (symbol != null) {
            return NextPrevAddressPlugin.truncateAsNecessary(symbol.getName());
        }
        Listing listing = program.getListing();
        CodeUnit codeUnit = listing.getCodeUnitAt(address);
        if (codeUnit == null) {
            return null;
        }
        String displayString = formatter.getRepresentationString(codeUnit);
        if (displayString != null) {
            return NextPrevAddressPlugin.truncateAsNecessary(displayString);
        }
        return null;
    }

    private Navigatable getNavigatable(ActionContext context) {
        Navigatable navigatable;
        if (context instanceof NavigatableActionContext && !(navigatable = ((NavigatableActionContext)context).getNavigatable()).isConnected()) {
            return navigatable;
        }
        GoToService service = (GoToService)this.tool.getService(GoToService.class);
        if (service != null) {
            return service.getDefaultNavigatable();
        }
        return null;
    }

    private class NavigationAction
    extends DockingAction {
        private final LocationMemento location;
        private final Navigatable navigatable;
        private final NavigationHistoryService service;
        private final boolean isNext;

        private NavigationAction(Navigatable navigatable, LocationMemento location, boolean isNext, NavigationHistoryService service, CodeUnitFormat formatter) {
            super("NavigationAction: " + ++idCount, NextPrevAddressPlugin.this.getName());
            this.location = location;
            this.isNext = isNext;
            this.service = service;
            this.navigatable = navigatable;
            Icon navIcon = navigatable.getNavigatableIcon();
            this.setMenuBarData(new MenuData(new String[]{NextPrevAddressPlugin.buildActionName(location, formatter)}, navIcon));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionContext context) {
            if (this.isNext) {
                this.service.next(this.navigatable, this.location);
            } else {
                this.service.previous(this.navigatable, this.location);
            }
        }
    }

    private class NextPreviousAction
    extends MultiActionDockingAction {
        private final boolean isNext;

        NextPreviousAction(String name, String owner, boolean isNext) {
            super(name, owner);
            this.isNext = isNext;
            this.setToolBarData(new ToolBarData((Icon)(isNext ? nextIcon : previousIcon), NextPrevAddressPlugin.NAV_GROUP));
            this.setHelpLocation(new HelpLocation("Navigation", name));
            int keycode = isNext ? 39 : 37;
            this.setKeyBindingData(new KeyBindingData(keycode, 512));
            this.setDescription(isNext ? "Go to next location" : "Go to previous location");
        }

        public boolean isValidContext(ActionContext context) {
            return false;
        }

        public boolean isValidGlobalContext(ActionContext globalContext) {
            return globalContext instanceof NavigatableActionContext;
        }

        public boolean isEnabledForContext(ActionContext context) {
            Navigatable navigatable = NextPrevAddressPlugin.this.getNavigatable(context);
            if (navigatable == null) {
                return false;
            }
            if (this.isNext) {
                return NextPrevAddressPlugin.this.historyService.hasNext(navigatable);
            }
            return NextPrevAddressPlugin.this.historyService.hasPrevious(navigatable);
        }

        public void actionPerformed(ActionContext context) {
            Navigatable navigatable = NextPrevAddressPlugin.this.getNavigatable(context);
            if (this.isNext) {
                NextPrevAddressPlugin.this.historyService.next(navigatable);
            } else {
                NextPrevAddressPlugin.this.historyService.previous(navigatable);
            }
        }

        public boolean shouldAddToWindow(boolean isMainWindow, Set<Class<?>> contextTypes) {
            for (Class<?> class1 : contextTypes) {
                if (!NavigationActionContext.class.isAssignableFrom(class1)) continue;
                return true;
            }
            return false;
        }

        public List<DockingActionIf> getActionList(ActionContext context) {
            Navigatable navigatable = NextPrevAddressPlugin.this.getNavigatable(context);
            if (this.isNext) {
                return NextPrevAddressPlugin.this.getNextActions(navigatable);
            }
            return NextPrevAddressPlugin.this.getPreviousActions(navigatable);
        }
    }
}

