/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.util.GroupPath;
import ghidra.util.SystemUtilities;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ProgramNode
extends DefaultMutableTreeNode {
    private boolean visited;
    private transient Group group;
    private transient ProgramModule module;
    private transient ProgramFragment fragment;
    private transient ProgramModule parentModule;
    private transient Program program;
    private transient Listing listing;
    private TreePath path;
    private String name;
    private boolean deleted;
    private GroupPath groupPath;
    private boolean isInView;
    private transient ProgramDnDTree tree;

    ProgramNode(Program program, Group g) {
        this(program, g, g.getName());
    }

    ProgramNode(Program program, String name) {
        this(program, null, name);
    }

    ProgramNode(Program program, Group g, String name) {
        super(name);
        this.program = program;
        this.group = g;
        this.name = name;
        if (program != null) {
            this.listing = program.getListing();
        }
        if (this.listing != null) {
            if (this.group instanceof ProgramModule) {
                this.module = (ProgramModule)this.group;
            } else {
                this.fragment = (ProgramFragment)this.group;
                this.setAllowsChildren(false);
            }
        }
    }

    @Override
    public boolean isLeaf() {
        if (this.module == null) {
            return true;
        }
        return this.module.getNumChildren() == 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return this.module != null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgramNode other = (ProgramNode)obj;
        if (!SystemUtilities.isEqual((Object)this.parentModule, (Object)other.parentModule)) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.group, (Object)other.group);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.parentModule == null ? 0 : this.parentModule.hashCode());
        return result;
    }

    public JTree getTree() {
        if (this.isRoot()) {
            return this.tree;
        }
        ProgramNode root = (ProgramNode)this.getRoot();
        return root.getTree();
    }

    public String getName() {
        return this.name;
    }

    public Group getGroup() {
        return this.group;
    }

    public boolean isFragment() {
        return this.fragment != null;
    }

    public boolean isModule() {
        return this.module != null;
    }

    public ProgramModule getModule() {
        return this.module;
    }

    public ProgramFragment getFragment() {
        return this.fragment;
    }

    public Program getProgram() {
        return this.program;
    }

    public boolean isInView() {
        return this.isInView;
    }

    public GroupPath getGroupPath() {
        return this.groupPath;
    }

    void visit() {
        if (this.visited || this.module == null) {
            return;
        }
        this.visited = true;
    }

    boolean wasVisited() {
        return this.visited;
    }

    void setGroup(Group g) {
        this.group = g;
    }

    TreePath getTreePath() {
        return this.path;
    }

    void setTreePath(TreePath path) {
        this.path = path;
    }

    ProgramModule getParentModule() {
        return this.parentModule;
    }

    void setParentModule(ProgramModule parent) {
        this.parentModule = parent;
    }

    void setName(String name) {
        this.name = name;
        super.setUserObject(name);
    }

    void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    boolean isDeleted() {
        return this.deleted;
    }

    void setGroupPath(GroupPath groupPath) {
        this.groupPath = groupPath;
    }

    void setInView(boolean isInView) {
        this.isInView = isInView;
    }

    boolean hasDescendantsInView() {
        if (this.isInView) {
            return true;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            ProgramNode child = (ProgramNode)this.getChildAt(i);
            if (child.isInView()) {
                return true;
            }
            if (!child.getAllowsChildren() || !child.hasDescendantsInView()) continue;
            return true;
        }
        return false;
    }

    void setTree(ProgramDnDTree tree) {
        this.tree = tree;
    }

    void dispose() {
        this.program = null;
        this.listing = null;
        this.module = null;
        this.fragment = null;
        this.group = null;
        this.parentModule = null;
        this.path = null;
        this.groupPath = null;
    }

    boolean isValid(Object versionTag) {
        if (this.group == null) {
            return true;
        }
        if (this.module != null) {
            return versionTag == this.module.getVersionTag();
        }
        return true;
    }

    ProgramNode getChild(String childName) {
        if (this.getAllowsChildren()) {
            int nchild = this.getChildCount();
            for (int i = 0; i < nchild; ++i) {
                ProgramNode c = (ProgramNode)this.getChildAt(i);
                if (!c.getName().equals(childName)) continue;
                return c;
            }
        }
        return null;
    }
}

