/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.flow;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.jung.JungToGDirectedGraphAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.graph.CodeBlockEdge;
import ghidra.program.model.block.graph.CodeBlockVertex;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Select flows only reachable from current location", description="Allows the user to select code blocks by following flows only reachable from the current location within a function")
public class SelectByScopedFlowPlugin
extends ProgramPlugin {
    public SelectByScopedFlowPlugin(PluginTool tool) {
        super(tool, true, true);
        this.createActions();
    }

    private void createActions() {
        NavigatableContextAction action = new NavigatableContextAction("Select Forward Scoped Flow", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                FunctionManager functionManager = SelectByScopedFlowPlugin.this.currentProgram.getFunctionManager();
                Function function = functionManager.getFunctionContaining(SelectByScopedFlowPlugin.this.currentLocation.getAddress());
                if (!SelectByScopedFlowPlugin.this.isValidFunction(function)) {
                    Msg.showWarn((Object)((Object)this), null, (String)"Cursor Must Be In a Function", (Object)"Selecting scoped flow requires the cursor to be inside of a function");
                    return;
                }
                try {
                    ProgramSelection selection = SelectByScopedFlowPlugin.this.makeForwardScopedSelection(function, SelectByScopedFlowPlugin.this.currentProgram, SelectByScopedFlowPlugin.this.currentLocation, (TaskMonitor)new TaskMonitorAdapter(true));
                    SelectByScopedFlowPlugin.this.updateStatusText(selection);
                    SelectByScopedFlowPlugin.this.setSelection(selection);
                }
                catch (CancelledException e) {
                    Msg.debug((Object)((Object)this), (Object)"Calculating Forward Scoped Flow cancelled", (Throwable)e);
                }
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"Se&lect", "Scoped Flow", "Forward Scoped Flow"}, null, "Select"));
        action.setDescription("Allows user to select scoped flow from current location.");
        action.setHelpLocation(new HelpLocation("FlowSelection", "Scoped_Flow"));
        this.tool.addAction((DockingActionIf)action);
        action = new NavigatableContextAction("Select Reverse Scoped Flow", this.getName()){

            @Override
            public void actionPerformed(NavigatableActionContext context) {
                FunctionManager functionManager = SelectByScopedFlowPlugin.this.currentProgram.getFunctionManager();
                Function function = functionManager.getFunctionContaining(SelectByScopedFlowPlugin.this.currentLocation.getAddress());
                if (!SelectByScopedFlowPlugin.this.isValidFunction(function)) {
                    Msg.showWarn((Object)((Object)this), null, (String)"Cursor Must Be In a Function", (Object)"Selecting scoped flow requires the cursor to be inside of a function");
                    return;
                }
                try {
                    ProgramSelection selection = SelectByScopedFlowPlugin.this.makeReverseScopedSelection(function, SelectByScopedFlowPlugin.this.currentProgram, SelectByScopedFlowPlugin.this.currentLocation, (TaskMonitor)new TaskMonitorAdapter(true));
                    SelectByScopedFlowPlugin.this.updateStatusText(selection);
                    SelectByScopedFlowPlugin.this.setSelection(selection);
                }
                catch (CancelledException e) {
                    Msg.debug((Object)((Object)this), (Object)"Calculating Reverse Scoped Flow cancelled", (Throwable)e);
                }
            }
        };
        action.setMenuBarData(new MenuData(new String[]{"Se&lect", "Scoped Flow", "Reverse Scoped Flow"}, null, "Select"));
        action.setDescription("Allows user to select scoped flow to the current location.");
        action.setHelpLocation(new HelpLocation("FlowSelection", "Scoped_Flow"));
        this.tool.addAction((DockingActionIf)action);
    }

    private void updateStatusText(ProgramSelection selection) {
        if (selection.isEmpty()) {
            this.tool.setStatusInfo("Scope Flow Selection: No addresses found in flow");
            return;
        }
        long count = selection.getNumAddresses();
        if (count == 1L) {
            this.tool.setStatusInfo("Scope Flow Selection: Selecting 1 address");
        } else {
            this.tool.setStatusInfo("Scope Flow Selection: Selecting " + count + " addresses");
        }
    }

    private boolean isValidFunction(Function function) {
        Address currentAddress;
        if (function == null) {
            return false;
        }
        Listing listing = this.currentProgram.getListing();
        Instruction instruction = listing.getInstructionAt(currentAddress = this.currentLocation.getAddress());
        return instruction != null;
    }

    private ProgramSelection makeForwardScopedSelection(Function function, Program program, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        return this.makeSelectionFromVertex(true, function, program, location, monitor);
    }

    private ProgramSelection makeReverseScopedSelection(Function function, Program program, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        return this.makeSelectionFromVertex(false, function, program, location, monitor);
    }

    private ProgramSelection makeSelectionFromVertex(boolean forwardFlow, Function function, Program program, ProgramLocation location, TaskMonitor monitor) throws CancelledException {
        Graph<CodeBlockVertex, CodeBlockEdge> graph = this.createGraph(function, program, monitor);
        CodeBlockVertex from = this.getVertex(location, graph);
        GDirectedGraph<CodeBlockVertex, CodeBlockEdge> dg = this.asDirectedGraph(graph);
        Set dominated = forwardFlow ? GraphAlgorithms.findDominance(dg, (Object)from, (TaskMonitor)monitor) : GraphAlgorithms.findPostDominance(dg, (Object)from, (TaskMonitor)monitor);
        Collection<CodeBlock> blocks = this.generateCodeBlocksFromVertices(dominated);
        ProgramSelection selection = this.makeSelectionFromCodeBlocks(blocks, program);
        return selection;
    }

    private CodeBlockVertex getVertex(ProgramLocation location, Graph<CodeBlockVertex, CodeBlockEdge> graph) {
        CodeBlockVertex from = null;
        Collection vertices = graph.getVertices();
        for (CodeBlockVertex vertex : vertices) {
            Address address;
            CodeBlock codeBlock = vertex.getCodeBlock();
            if (!codeBlock.contains(address = location.getAddress())) continue;
            from = vertex;
            break;
        }
        if (from == null) {
            throw new AssertException("supplied location is not within supplied function");
        }
        return from;
    }

    private GDirectedGraph<CodeBlockVertex, CodeBlockEdge> asDirectedGraph(Graph<CodeBlockVertex, CodeBlockEdge> g) {
        return new JungToGDirectedGraphAdapter(g);
    }

    private Collection<CodeBlock> generateCodeBlocksFromVertices(Collection<CodeBlockVertex> vertices) {
        ArrayList<CodeBlock> result = new ArrayList<CodeBlock>();
        for (CodeBlockVertex vertex : vertices) {
            result.add(vertex.getCodeBlock());
        }
        return result;
    }

    private ProgramSelection makeSelectionFromCodeBlocks(Collection<CodeBlock> blocks, Program program) {
        AddressSet set = this.getAddressForCodeBlocks(blocks, program);
        AddressFactory addressFactory = program.getAddressFactory();
        ProgramSelection selection = new ProgramSelection(addressFactory, (AddressSetView)set);
        return selection;
    }

    private AddressSet getAddressForCodeBlocks(Collection<CodeBlock> blocks, Program program) {
        AddressSet set = new AddressSet();
        for (CodeBlock codeBlock : blocks) {
            set.add((AddressSetView)codeBlock);
        }
        return set;
    }

    private Graph<CodeBlockVertex, CodeBlockEdge> createGraph(Function function, Program program, TaskMonitor monitor) throws CancelledException {
        DirectedSparseGraph directedGraph = new DirectedSparseGraph();
        List<CodeBlockVertex> vertices = this.createVertices(function, program, monitor);
        this.addVerticesToGraph((DirectedSparseGraph<CodeBlockVertex, CodeBlockEdge>)directedGraph, vertices);
        this.addEdgesToGraph((Graph<CodeBlockVertex, CodeBlockEdge>)directedGraph, vertices, monitor);
        return directedGraph;
    }

    private List<CodeBlockVertex> createVertices(Function function, Program program, TaskMonitor monitor) throws CancelledException {
        ArrayList<CodeBlockVertex> vertices = new ArrayList<CodeBlockVertex>();
        BasicBlockModel blockModel = new BasicBlockModel(program);
        AddressSetView addresses = function.getBody();
        CodeBlockIterator iterator = blockModel.getCodeBlocksContaining(addresses, monitor);
        monitor.initialize(addresses.getNumAddresses());
        while (iterator.hasNext()) {
            monitor.checkCanceled();
            CodeBlock codeBlock = iterator.next();
            CodeBlockVertex vertex = new CodeBlockVertex(codeBlock);
            vertices.add(vertex);
            long blockAddressCount = codeBlock.getNumAddresses();
            long currentProgress = monitor.getProgress();
            monitor.setProgress(currentProgress + blockAddressCount);
        }
        return vertices;
    }

    private void addVerticesToGraph(DirectedSparseGraph<CodeBlockVertex, CodeBlockEdge> directedGraph, List<CodeBlockVertex> vertices) {
        for (CodeBlockVertex vertex : vertices) {
            directedGraph.addVertex((Object)vertex);
        }
    }

    private void addEdgesToGraph(Graph<CodeBlockVertex, CodeBlockEdge> graph, List<CodeBlockVertex> vertices, TaskMonitor monitor) throws CancelledException {
        Map<CodeBlock, CodeBlockVertex> blockToVertexMap = this.mapBlocksToVertices(vertices);
        for (CodeBlockVertex startVertex : vertices) {
            monitor.checkCanceled();
            this.addEdgesForStartVertex(graph, blockToVertexMap, startVertex, monitor);
        }
    }

    private void addEdgesForStartVertex(Graph<CodeBlockVertex, CodeBlockEdge> graph, Map<CodeBlock, CodeBlockVertex> blockToVertexMap, CodeBlockVertex start, TaskMonitor monitor) throws CancelledException {
        CodeBlock codeBlock = start.getCodeBlock();
        CodeBlockReferenceIterator destinations = codeBlock.getDestinations(monitor);
        while (destinations.hasNext()) {
            monitor.checkCanceled();
            CodeBlockReference reference = destinations.next();
            CodeBlock destinationBlock = reference.getDestinationBlock();
            CodeBlockVertex end = blockToVertexMap.get(destinationBlock);
            if (end == null) continue;
            graph.addEdge((Object)new CodeBlockEdge(start, end), (Object)start, (Object)end);
        }
    }

    private Map<CodeBlock, CodeBlockVertex> mapBlocksToVertices(List<CodeBlockVertex> vertices) {
        HashMap<CodeBlock, CodeBlockVertex> blockToVertexMap = new HashMap<CodeBlock, CodeBlockVertex>();
        for (CodeBlockVertex vertex : vertices) {
            blockToVertexMap.put(vertex.getCodeBlock(), vertex);
        }
        return blockToVertexMap;
    }
}

