/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import ghidra.app.services.ProgramManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.SelectFromListDialog;
import ghidra.framework.model.Tool;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class FSBUtils {
    public static FSRL getFileFSRLFromContext(ActionContext context) {
        return FSBUtils.getFSRLFromContext(context, false);
    }

    public static FSRL getFSRLFromContext(ActionContext context, boolean dirsOk) {
        boolean isDir;
        if (context == null || !(context.getContextObject() instanceof FSBNode)) {
            return null;
        }
        FSBNode node = (FSBNode)context.getContextObject();
        FSRL fsrl = node.getFSRL();
        if (!dirsOk && node instanceof FSBRootNode && FSBUtils.fsrlHasContainer(fsrl.getFS())) {
            return fsrl.getFS().getContainer();
        }
        boolean bl = isDir = node instanceof FSBDirNode || node instanceof FSBRootNode;
        if (isDir && !dirsOk) {
            return null;
        }
        return fsrl;
    }

    public static boolean fsrlHasContainer(FSRLRoot fsFSRL) {
        return fsFSRL.hasContainer() && !fsFSRL.getProtocol().equals("file");
    }

    public static FSBRootNode getNodesRoot(FSBNode node) {
        FSBNode tmp;
        for (tmp = node; tmp != null && !(tmp instanceof FSBRootNode); tmp = tmp.getParent()) {
        }
        return tmp instanceof FSBRootNode ? (FSBRootNode)tmp : null;
    }

    public static ProgramManager getProgramManager(PluginTool tool, boolean allowUserPrompt) {
        List<PluginTool> runningPMTools;
        PluginTool pmTool = null;
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        pmTool = pm != null ? tool : ((runningPMTools = FSBUtils.getRunningProgramManagerTools(tool)).size() == 1 ? runningPMTools.get(0) : (allowUserPrompt ? FSBUtils.selectPMTool(tool) : null));
        return pmTool != null ? (ProgramManager)pmTool.getService(ProgramManager.class) : null;
    }

    public static List<PluginTool> getRunningProgramManagerTools(PluginTool tool) {
        ArrayList<PluginTool> pluginTools = new ArrayList<PluginTool>();
        for (Tool runningTool : tool.getToolServices().getRunningTools()) {
            PluginTool pt;
            ProgramManager pmService;
            if (!(runningTool instanceof PluginTool) || (pmService = (ProgramManager)(pt = (PluginTool)runningTool).getService(ProgramManager.class)) == null) continue;
            pluginTools.add(pt);
        }
        return pluginTools;
    }

    private static PluginTool selectPMTool(PluginTool tool) {
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        if (pm != null) {
            return tool;
        }
        List<PluginTool> pluginTools = FSBUtils.getRunningProgramManagerTools(tool);
        if (pluginTools.size() == 1) {
            return pluginTools.get(0);
        }
        if (pluginTools.isEmpty()) {
            Msg.showWarn((Object)tool, (Component)tool.getActiveWindow(), (String)"No open tools", (Object)"There are no open tools to use to open a program with");
            return null;
        }
        PluginTool pt = SelectFromListDialog.selectFromList(pluginTools, "Select tool", "Select a tool to use to open programs", pluginTool -> pluginTool.getName());
        return pt;
    }
}

