/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.rmi.value.BinaryValue;
import org.apache.jackrabbit.rmi.value.BooleanValue;
import org.apache.jackrabbit.rmi.value.DateValue;
import org.apache.jackrabbit.rmi.value.DoubleValue;
import org.apache.jackrabbit.rmi.value.LongValue;
import org.apache.jackrabbit.rmi.value.NameValue;
import org.apache.jackrabbit.rmi.value.PathValue;
import org.apache.jackrabbit.rmi.value.ReferenceValue;
import org.apache.jackrabbit.rmi.value.SerialValue;
import org.apache.jackrabbit.rmi.value.StatefulValue;
import org.apache.jackrabbit.rmi.value.StatefulValueAdapter;
import org.apache.jackrabbit.rmi.value.StringValue;

public class SerialValueFactory
implements ValueFactory {
    private static final SerialValueFactory INSTANCE = new SerialValueFactory();

    public static final SerialValueFactory getInstance() {
        return INSTANCE;
    }

    public static Value[] makeSerialValueArray(Value[] values) {
        if (values != null) {
            Value[] serials = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                serials[i] = SerialValueFactory.makeSerialValue(values[i]);
            }
            return serials;
        }
        return new Value[0];
    }

    public static Value makeSerialValue(Value value) {
        if (value == null || value instanceof SerialValue) {
            return value;
        }
        return new SerialValue(new StatefulValueAdapter(value));
    }

    protected SerialValueFactory() {
    }

    public final Value createValue(String value) {
        return new SerialValue(this.createStringValue(value));
    }

    public final Value createValue(String value, int type) throws ValueFormatException {
        StatefulValue intValue;
        switch (type) {
            case 2: {
                intValue = this.createBinaryValue(value);
                break;
            }
            case 6: {
                intValue = this.createBooleanValue(value);
                break;
            }
            case 5: {
                intValue = this.createDateValue(value);
                break;
            }
            case 4: {
                intValue = this.createDoubleValue(value);
                break;
            }
            case 3: {
                intValue = this.createLongValue(value);
                break;
            }
            case 7: {
                intValue = this.createNameValue(value);
                break;
            }
            case 8: {
                intValue = this.createPathValue(value);
                break;
            }
            case 9: {
                intValue = this.createReferenceValue(value);
                break;
            }
            case 1: {
                intValue = this.createStringValue(value);
                break;
            }
            default: {
                throw new ValueFormatException("Unknown type " + type);
            }
        }
        return new SerialValue(intValue);
    }

    public final Value createValue(long value) {
        return new SerialValue(this.createLongValue(value));
    }

    public final Value createValue(double value) {
        return new SerialValue(this.createDoubleValue(value));
    }

    public final Value createValue(boolean value) {
        return new SerialValue(this.createBooleanValue(value));
    }

    public final Value createValue(Calendar value) {
        return new SerialValue(this.createDateValue(value));
    }

    public final Value createValue(InputStream value) {
        return new SerialValue(this.createBinaryValue(value));
    }

    public final Value createValue(Node value) throws RepositoryException {
        return this.createValue(value.getUUID(), 9);
    }

    protected StringValue createStringValue(String value) {
        return new StringValue(value);
    }

    protected NameValue createNameValue(String value) throws ValueFormatException {
        return new NameValue(value);
    }

    protected PathValue createPathValue(String value) throws ValueFormatException {
        return new PathValue(value);
    }

    protected ReferenceValue createReferenceValue(String value) throws ValueFormatException {
        return new ReferenceValue(value);
    }

    protected LongValue createLongValue(long value) {
        return new LongValue(value);
    }

    protected LongValue createLongValue(String value) throws ValueFormatException {
        return new LongValue(value);
    }

    protected DoubleValue createDoubleValue(double value) {
        return new DoubleValue(value);
    }

    protected DoubleValue createDoubleValue(String value) throws ValueFormatException {
        return new DoubleValue(value);
    }

    protected DateValue createDateValue(Calendar value) {
        return new DateValue(value);
    }

    protected DateValue createDateValue(String value) throws ValueFormatException {
        return new DateValue(value);
    }

    protected BooleanValue createBooleanValue(boolean value) {
        return new BooleanValue(value);
    }

    protected BooleanValue createBooleanValue(String value) {
        return new BooleanValue(value);
    }

    protected BinaryValue createBinaryValue(InputStream value) {
        return new BinaryValue(value);
    }

    protected BinaryValue createBinaryValue(String value) throws ValueFormatException {
        return new BinaryValue(value);
    }
}

