/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.DialogComponentProvider;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableSortState;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.PluginDetailsPanel;
import ghidra.framework.plugintool.dialog.PluginInstallerTableModel;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PluginInstallerDialog
extends DialogComponentProvider {
    private PluginTool tool;
    private PluginConfigurationModel model;
    private List<PluginDescription> pluginDescriptions;
    private GTableFilterPanel<PluginDescription> tableFilterPanel;
    private PluginDetailsPanel detailsPanel;
    private GTable table;

    public PluginInstallerDialog(String title, PluginTool tool, List<PluginDescription> pluginDescriptions) {
        super(title, true, false, true, false);
        this.tool = tool;
        if (this.model == null) {
            this.model = new PluginConfigurationModel(tool);
        }
        this.pluginDescriptions = pluginDescriptions;
        this.addWorkPanel(this.getWorkPanel());
        this.addOKButton();
    }

    protected void dialogShown() {
        this.tableFilterPanel.requestFocus();
    }

    protected void okCallback() {
        this.close();
    }

    public void close() {
        super.close();
        this.tableFilterPanel.dispose();
        this.table.dispose();
    }

    PluginDetailsPanel getDetailsPanel() {
        return this.detailsPanel;
    }

    GTableFilterPanel<PluginDescription> getFilterPanel() {
        return this.tableFilterPanel;
    }

    PluginConfigurationModel getModel() {
        return this.model;
    }

    private JComponent getWorkPanel() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.detailsPanel = new PluginDetailsPanel(this.model);
        JPanel pluginTablePanel = this.createPluginTablePanel(this.detailsPanel);
        JSplitPane splitPane = new JSplitPane(0, pluginTablePanel, this.detailsPanel);
        splitPane.setResizeWeight(0.75);
        mainPanel.add((Component)splitPane, "Center");
        return mainPanel;
    }

    private JPanel createPluginTablePanel(PluginDetailsPanel pluginDetailsPanel) {
        JPanel pluginTablePanel = new JPanel();
        pluginTablePanel.setLayout(new BorderLayout());
        PluginInstallerTableModel tableModel = new PluginInstallerTableModel(this.tool, this.getComponent(), this.pluginDescriptions, this.model);
        this.table = new GTable((TableModel)((Object)tableModel));
        this.table.setSelectionMode(0);
        this.tableFilterPanel = new GTableFilterPanel((JTable)this.table, (RowObjectTableModel)tableModel);
        JScrollPane sp = new JScrollPane((Component)this.table);
        sp.getViewport().setBackground(this.table.getBackground());
        pluginTablePanel.add((Component)sp, "Center");
        pluginTablePanel.add((Component)this.tableFilterPanel, "South");
        TableColumn inst_col = this.table.getColumnModel().getColumn(0);
        inst_col.setMaxWidth(30);
        TableColumn status_col = this.table.getColumnModel().getColumn(1);
        status_col.setMaxWidth(24);
        tableModel.setTableSortState(TableSortState.createDefaultSortState((int)2));
        tableModel.refresh();
        this.table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new NameCellRenderer()));
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new StatusCellRenderer()));
        HelpService help = Help.getHelpService();
        help.registerHelp((Object)this.table, new HelpLocation("Tool", "PluginDialog"));
        this.table.getSelectionModel().addListSelectionListener(e -> {
            int row = this.table.getSelectedRow();
            if (row < 0 || row > this.pluginDescriptions.size()) {
                pluginDetailsPanel.setPluginDescription(null);
                return;
            }
            PluginDescription desc = (PluginDescription)this.tableFilterPanel.getRowObject(row);
            pluginDetailsPanel.setPluginDescription(desc);
        });
        return pluginTablePanel;
    }

    private class NameCellRenderer
    extends GTableCellRenderer {
        NameCellRenderer() {
            this.defaultFont = this.getFont();
            this.boldFont = new Font(this.defaultFont.getName(), this.defaultFont.getStyle() | 1, this.defaultFont.getSize());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            JTable jtable = data.getTable();
            int row = data.getRowViewIndex();
            boolean isSelected = data.isSelected();
            renderer.setText((String)value);
            PluginDescription desc = (PluginDescription)PluginInstallerDialog.this.tableFilterPanel.getRowObject(row);
            boolean hasDependents = PluginInstallerDialog.this.model.hasDependencies(desc);
            if (isSelected) {
                if (hasDependents) {
                    renderer.setForeground(Color.pink);
                    renderer.setFont(this.boldFont);
                } else {
                    renderer.setForeground(jtable.getSelectionForeground());
                    renderer.setFont(this.defaultFont);
                }
            } else if (hasDependents) {
                renderer.setForeground(Color.red);
                renderer.setFont(this.boldFont);
            } else {
                renderer.setForeground(jtable.getForeground());
                renderer.setFont(this.defaultFont);
            }
            return renderer;
        }
    }

    private class StatusCellRenderer
    extends GTableCellRenderer {
        public StatusCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            renderer.setIcon(value instanceof Icon ? (Icon)value : null);
            String toolTipText = "";
            if (value == PluginInstallerTableModel.EXPERIMENTAL_ICON) {
                toolTipText = "This plugin is usable, but not fully tested or documented";
            } else if (value == PluginInstallerTableModel.DEV_ICON) {
                toolTipText = "This plugin is under development and not intended for general use.\nIt could cause Ghidra to become unstable!";
            }
            renderer.setToolTipText(toolTipText);
            return renderer;
        }
    }
}

