/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.ModifiedUTF8;
import ghidra.file.formats.android.dex.format.StringIDItem;
import ghidra.file.formats.android.dex.util.Leb128;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class StringDataItem
implements StructConverter {
    private int stringLength;
    private int lebLength;
    private int actualLength;
    private String string;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringDataItem(StringIDItem stringItem, BinaryReader reader) throws IOException {
        long oldIndex = reader.getPointerIndex();
        try {
            reader.setPointerIndex(stringItem.getStringDataOffset());
            this.stringLength = Leb128.readUnsignedLeb128(reader.readByteArray((long)stringItem.getStringDataOffset(), 5));
            this.lebLength = Leb128.unsignedLeb128Size(this.stringLength);
            reader.readNextByteArray(this.lebLength);
            this.actualLength = this.computeActualLength(reader);
            byte[] stringBytes = reader.readNextByteArray(this.actualLength);
            ByteArrayInputStream in = new ByteArrayInputStream(stringBytes);
            char[] out = new char[this.stringLength];
            this.string = ModifiedUTF8.decode(in, out);
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    public String getString() {
        return this.string;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("string_data_item_" + this.actualLength, 0);
        structure.add((DataType)new ArrayDataType(BYTE, this.lebLength, BYTE.getLength()), "utf16_size", null);
        structure.add(UTF8, this.actualLength, "data", null);
        structure.setCategoryPath(new CategoryPath("/dex/string_data_item"));
        return structure;
    }

    private int computeActualLength(BinaryReader reader) throws IOException {
        int count;
        for (count = 0; count < 0x200000 && reader.readByte(reader.getPointerIndex() + (long)count) != 0; ++count) {
        }
        return count + 1;
    }
}

