/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.iso9660;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.iso9660.ISO9660BaseVolume;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ISO9660SetTerminator
extends ISO9660BaseVolume {
    private long endVolumeIndex;

    public ISO9660SetTerminator(BinaryReader reader) throws IOException {
        super(reader);
        this.endVolumeIndex = reader.getPointerIndex();
    }

    public long getEndVolumeIndex() {
        return this.endVolumeIndex;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struc = new StructureDataType("ISO9600SetTerminator", 0);
        struc.add(BYTE, "Type", "Volume Descriptor Type");
        struc.add((DataType)new ArrayDataType(BYTE, super.getIdentifier().length, 1), "Identifier", "Identifier");
        struc.add(BYTE, "Version", "Volume Descriptor Version");
        return struc;
    }
}

