/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import docking.widgets.table.threaded.ThreadedTableModelStub;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.gui.PatternInfoRowObject;
import ghidra.bitpatterns.info.PatternType;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class PatternInfoTableModel
extends ThreadedTableModelStub<PatternInfoRowObject> {
    private static final String MODEL_NAME = "Pattern Clipboard";
    private FunctionBitPatternsExplorerPlugin plugin;
    private static final int NOTE_COLUMN = 2;
    private static final int ALIGNMENT_COLUMN = 5;
    private static final int MONOSPACE_FONT_SIZE = 14;
    protected GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        protected void configureFont(JTable table, TableModel model, int column) {
            Font f = new Font("monospaced", this.getFixedWidthFont().getStyle(), 14);
            this.setFont(f);
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public PatternInfoTableModel(FunctionBitPatternsExplorerPlugin plugin) {
        super(MODEL_NAME, (ServiceProvider)plugin.getTool());
        this.plugin = plugin;
    }

    protected void doLoad(Accumulator<PatternInfoRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        accumulator.addAll(this.plugin.getPatterns());
    }

    public boolean isCellEditable(int row, int columnIndex) {
        if (columnIndex == 2) {
            return true;
        }
        if (columnIndex == 5) {
            PatternInfoRowObject rowObject = (PatternInfoRowObject)this.filteredData.get(row);
            return rowObject.getPatternType().equals((Object)PatternType.FIRST);
        }
        return false;
    }

    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (row < 0 || row >= this.filteredData.size()) {
            return;
        }
        PatternInfoRowObject rowObject = (PatternInfoRowObject)this.filteredData.get(row);
        if (columnIndex == 2) {
            rowObject.setNote((String)aValue);
        }
        if (columnIndex == 5) {
            Integer newValue = (Integer)aValue;
            if (newValue <= 0) {
                rowObject.setAlignment(null);
                return;
            }
            if ((newValue & newValue - 1) == 0) {
                rowObject.setAlignment((Integer)aValue);
            } else {
                rowObject.setAlignment(null);
            }
        }
    }

    protected TableColumnDescriptor<PatternInfoRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new PatternTypeTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new DittedBitSequenceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new NoteTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new BitsOfCheckTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ContextRegisterFilterTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new AlignmentTableColumn());
        return descriptor;
    }

    class AlignmentTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, Integer, Object> {
        AlignmentTableColumn() {
        }

        public String getColumnName() {
            return "Alignment";
        }

        public Integer getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getAlignment();
        }
    }

    class ContextRegisterFilterTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, String, Object> {
        ContextRegisterFilterTableColumn() {
        }

        public String getColumnName() {
            return "Context Register Filter";
        }

        public String getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider services) throws IllegalArgumentException {
            if (rowObject.getContextRegisterFilter() == null) {
                return null;
            }
            return rowObject.getContextRegisterFilter().getCompactString();
        }
    }

    class BitsOfCheckTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, Integer, Object> {
        BitsOfCheckTableColumn() {
        }

        public String getColumnName() {
            return "Bits of Check";
        }

        public Integer getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getDittedBitSequence().getNumFixedBits();
        }
    }

    class DittedBitSequenceTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, String, Object> {
        DittedBitSequenceTableColumn() {
        }

        public String getColumnName() {
            return "Bit Sequence";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return PatternInfoTableModel.this.monospacedRenderer;
        }

        public String getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getDittedBitSequence().getHexString();
        }
    }

    class NoteTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, String, Object> {
        NoteTableColumn() {
        }

        public String getColumnName() {
            return "Note";
        }

        public String getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getNote();
        }
    }

    class PatternTypeTableColumn
    extends AbstractDynamicTableColumn<PatternInfoRowObject, String, Object> {
        PatternTypeTableColumn() {
        }

        public String getColumnName() {
            return "Pattern Type";
        }

        public String getValue(PatternInfoRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            if (rowObject.getPatternType().equals((Object)PatternType.FIRST)) {
                return "POST";
            }
            return "PRE";
        }
    }
}

