/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.util.GraphicsUtils;
import docking.widgets.OptionDialog;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import utilities.util.reflection.ReflectionUtilities;

public class MultiLineLabel
extends JPanel {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int num_lines;
    protected int margin_width;
    protected int margin_height;
    protected int line_height;
    protected int line_ascent;
    protected int[] line_widths;
    protected int max_width;
    protected int alignment = 1;

    public MultiLineLabel() {
    }

    public MultiLineLabel(String label, int margin_width, int margin_height, int alignment) {
        this.setDoubleBuffered(false);
        this.newLabel(label);
        this.margin_width = margin_width;
        this.margin_height = margin_height;
        this.alignment = alignment;
    }

    public MultiLineLabel(String label) {
        this(label, 10, 10, 0);
    }

    protected void newLabel(String label) {
        if (label == null) {
            label = "No label given for this dialog.\nThis was likely due to an exception with no message from the line of code below:\n\n" + this.getCallerString();
            Msg.debug((Object)label, (Object)label, (Throwable)new Throwable());
        }
        StringTokenizer t = new StringTokenizer((String)label, "\n");
        this.num_lines = t.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        for (int i = 0; i < this.num_lines; ++i) {
            this.lines[i] = t.nextToken();
        }
    }

    private String getCallerString() {
        String name = ReflectionUtilities.getClassNameOlderThan((Class[])new Class[]{OptionDialog.class});
        return name;
    }

    protected void measure() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return;
        }
        this.line_height = fm.getHeight();
        this.line_ascent = fm.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fm.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
    }

    public void setLabel(String label) {
        this.newLabel(label);
        this.measure();
        this.repaint();
    }

    public void setLabel(String[] text) {
        this.line_widths = new int[text.length];
        this.lines = text;
        this.num_lines = text.length;
        this.measure();
        this.repaint();
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.lines.length; ++i) {
            sb.append(this.lines[i]);
            if (i >= this.lines.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.measure();
        this.repaint();
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        this.repaint();
    }

    public void setAlignment(int a) {
        this.alignment = a;
        this.repaint();
    }

    public void setMarginWidth(int mw) {
        this.margin_width = mw;
        this.repaint();
    }

    public void setMarginHeight(int mh) {
        this.margin_height = mh;
        this.repaint();
    }

    public final int getAlignment() {
        return this.alignment;
    }

    public final int getMarginWidth() {
        return this.margin_width;
    }

    public final int getMarginHeight() {
        return this.margin_height;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.max_width, this.num_lines * this.line_height);
    }

    @Override
    public void paint(Graphics g) {
        Dimension d = this.getSize();
        int y = this.line_ascent + (d.height - this.num_lines * this.line_height) / 2;
        int i = 0;
        while (i < this.num_lines) {
            int x;
            switch (this.alignment) {
                case 0: {
                    x = this.margin_width;
                    break;
                }
                default: {
                    x = (d.width - this.line_widths[i]) / 2;
                    break;
                }
                case 2: {
                    x = d.width - this.margin_width - this.line_widths[i];
                }
            }
            GraphicsUtils.drawString((JComponent)this, g, this.lines[i], x, y);
            ++i;
            y += this.line_height;
        }
    }

    public static void main(String[] args) {
        MultiLineLabel mlab = new MultiLineLabel("This is a test\nof a multi-line label\nLine One\nLine Two\nLine Three.", 20, 20, 1);
        JFrame f = new JFrame("Test MultiLineLabel");
        f.getContentPane().add(mlab);
        f.pack();
        f.setVisible(true);
    }
}

