/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.DataBuffer;

class BufferNode {
    BufferNode nextCached;
    BufferNode prevCached;
    BufferNode nextVersion;
    BufferNode prevVersion;
    BufferNode nextInCheckpoint;
    BufferNode prevInCheckpoint;
    final int id;
    int checkpoint;
    DataBuffer buffer = null;
    int diskCacheIndex = -1;
    boolean locked = false;
    boolean empty = false;
    boolean modified = false;
    boolean isDirty = false;
    boolean[] snapshotTaken = new boolean[]{false, false};

    BufferNode(int id, int checkpoint) {
        this.id = id;
        this.checkpoint = checkpoint;
    }

    void clearSnapshotTaken() {
        this.snapshotTaken[0] = false;
        this.snapshotTaken[1] = false;
    }

    void removeFromCache() {
        this.prevCached.nextCached = this.nextCached;
        this.nextCached.prevCached = this.prevCached;
        this.nextCached = null;
        this.prevCached = null;
    }

    void addToCache(BufferNode cacheHead) {
        this.prevCached = cacheHead;
        this.nextCached = cacheHead.nextCached;
        cacheHead.nextCached.prevCached = this;
        cacheHead.nextCached = this;
    }

    void removeFromCheckpoint() {
        this.prevInCheckpoint.nextInCheckpoint = this.nextInCheckpoint;
        this.nextInCheckpoint.prevInCheckpoint = this.prevInCheckpoint;
        this.nextInCheckpoint = null;
        this.prevInCheckpoint = null;
    }

    void addToCheckpoint(BufferNode checkpointHead) {
        this.prevInCheckpoint = checkpointHead;
        this.nextInCheckpoint = checkpointHead.nextInCheckpoint;
        checkpointHead.nextInCheckpoint.prevInCheckpoint = this;
        checkpointHead.nextInCheckpoint = this;
    }

    void removeFromVersion() {
        this.prevVersion.nextVersion = this.nextVersion;
        this.nextVersion.prevVersion = this.prevVersion;
        this.nextVersion = null;
        this.prevVersion = null;
    }

    void addToVersion(BufferNode versionHead) {
        this.prevVersion = versionHead;
        this.nextVersion = versionHead.nextVersion;
        versionHead.nextVersion.prevVersion = this;
        versionHead.nextVersion = this;
    }
}

