/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.Record;
import ghidra.feature.vt.api.db.AssociationDatabaseManager;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.db.VTMatchTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.Address;
import ghidra.util.Lock;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.io.IOException;

public class VTMatchDB
extends DatabaseObject
implements VTMatch {
    private Record record;
    private final VTMatchSetDB matchSet;
    private VTSessionDB session;
    private VTAssociation association;
    protected Lock lock;
    private boolean doCalculateHash = true;
    private int hash;

    public VTMatchDB(DBObjectCache<VTMatchDB> cache, Record record, VTMatchSetDB matchSet) {
        super(cache, record.getKey());
        this.record = record;
        this.matchSet = matchSet;
        this.session = (VTSessionDB)matchSet.getSession();
        this.lock = this.session.getLock();
    }

    protected boolean refresh() {
        return this.refresh(null);
    }

    protected boolean refresh(Record matchRecord) {
        this.association = null;
        if (matchRecord == null) {
            matchRecord = this.matchSet.getMatchRecord(this.key);
        }
        if (matchRecord == null) {
            return false;
        }
        this.record = matchRecord;
        return true;
    }

    @Override
    public VTMatchSet getMatchSet() {
        return this.matchSet;
    }

    @Override
    public int getDestinationLength() {
        return this.record.getIntValue(VTMatchTableDBAdapter.ColumnDescription.DESTINATION_LENGTH_COL.column());
    }

    @Override
    public VTScore getSimilarityScore() {
        return new VTScore(this.record.getString(VTMatchTableDBAdapter.ColumnDescription.SIMILARITY_SCORE_COL.column()));
    }

    @Override
    public VTScore getConfidenceScore() {
        return new VTScore(this.record.getString(VTMatchTableDBAdapter.ColumnDescription.CONFIDENCE_SCORE_COL.column()));
    }

    public String getLengthType() {
        return this.record.getString(VTMatchTableDBAdapter.ColumnDescription.LENGTH_TYPE.column());
    }

    @Override
    public int getSourceLength() {
        return this.record.getIntValue(VTMatchTableDBAdapter.ColumnDescription.SOURCE_LENGTH_COL.column());
    }

    @Override
    public VTMatchTag getTag() {
        long tagKey = this.record.getLongValue(VTMatchTableDBAdapter.ColumnDescription.TAG_KEY_COL.column());
        return this.session.getMatchTag(tagKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTag(VTMatchTag tag) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            if (this.record == null) {
                return;
            }
            VTMatchTag oldTag = this.getTag();
            if (SystemUtilities.isEqual((Object)tag, (Object)oldTag)) {
                return;
            }
            long tagKey = -1L;
            VTMatchTagDB newTagDB = this.session.getOrCreateMatchTagDB(tag);
            if (newTagDB != null) {
                tagKey = newTagDB.getKey();
            }
            this.record.setLongValue(VTMatchTableDBAdapter.ColumnDescription.TAG_KEY_COL.column(), tagKey);
            this.updateRecord();
            this.session.setObjectChanged(1024, this, oldTag, newTagDB);
        }
        finally {
            this.lock.release();
        }
    }

    private VTAssociation loadAssociation() {
        long associationKey = this.record.getLongValue(VTMatchTableDBAdapter.ColumnDescription.ASSOCIATION_COL.column());
        AssociationDatabaseManager associationManager = this.matchSet.getAssociationManager();
        VTAssociationDB existingAssociation = associationManager.getAssociation(associationKey);
        if (existingAssociation == null) {
            throw new AssertException("This match has no VTAssociation!");
        }
        return existingAssociation;
    }

    @Override
    public VTAssociation getAssociation() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.association == null) {
                this.association = this.loadAssociation();
            }
        }
        finally {
            this.lock.release();
        }
        return this.association;
    }

    private void updateRecord() {
        VTMatchTableDBAdapter matchTableAdapter = this.matchSet.getMatchTableAdapter();
        try {
            matchTableAdapter.updateRecord(this.record);
        }
        catch (IOException e) {
            this.matchSet.dbError(e);
        }
    }

    public int hashCode() {
        if (this.doCalculateHash) {
            VTProgramCorrelatorInfo info;
            String programCorrelatorName;
            Address destinationAddress;
            this.hash = 17;
            Address sourceAddress = this.getAssociation().getSourceAddress();
            if (sourceAddress != null) {
                this.hash = 37 * this.hash + (int)sourceAddress.getOffset();
            }
            if ((destinationAddress = this.getAssociation().getDestinationAddress()) != null) {
                this.hash = 37 * this.hash + (int)destinationAddress.getOffset();
            }
            if ((programCorrelatorName = (info = this.getMatchSet().getProgramCorrelatorInfo()).getName()) != null) {
                this.hash = 37 * this.hash + programCorrelatorName.hashCode();
            }
            this.doCalculateHash = false;
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTMatch)) {
            return false;
        }
        VTMatchDB other = (VTMatchDB)obj;
        if (this.matchSet.getID() != other.matchSet.getID()) {
            return false;
        }
        if (this.getSourceLength() != other.getSourceLength()) {
            return false;
        }
        if (this.getDestinationLength() != other.getDestinationLength()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.getSimilarityScore(), (Object)other.getSimilarityScore())) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.getConfidenceScore(), (Object)other.getConfidenceScore())) {
            return false;
        }
        if (this.getTag() != other.getTag()) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.getAssociation(), (Object)other.getAssociation());
    }

    @Override
    public Address getSourceAddress() {
        return this.getAssociation().getSourceAddress();
    }

    @Override
    public Address getDestinationAddress() {
        return this.getAssociation().getDestinationAddress();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Address destinationAddress = this.getDestinationAddress();
        Address sourceAddress = this.getSourceAddress();
        double similarityScore = this.getSimilarityScore().getScore();
        double confidenceScore = this.getConfidenceScore().getScore();
        buffer.append("\nMatch:");
        buffer.append("\n  Type               = ").append((Object)this.getAssociation().getType());
        buffer.append("\n  Similarity Score   = ").append(similarityScore);
        buffer.append("\n  Confidence Score   = ").append(confidenceScore);
        buffer.append("\n  SourceAddress      = ").append(sourceAddress);
        buffer.append("\n  DestinationAddress = ").append(destinationAddress);
        buffer.append("\n  LengthType         = ").append(this.getLengthType());
        buffer.append("\n  SourceLength       = ").append(this.getSourceLength());
        buffer.append("\n  DestinationLength  = ").append(this.getDestinationLength());
        buffer.append("\n  Tagged             = ").append(this.getTag());
        buffer.append("\n  Session ID:        = ").append(this.matchSet.getID());
        return buffer.toString();
    }
}

