/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import opennlp.tools.doccat.BagOfWordsFeatureGenerator;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizer;
import opennlp.tools.doccat.DocumentCategorizerContextGenerator;
import opennlp.tools.doccat.DocumentCategorizerEventStream;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.doccat.FeatureGenerator;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public class DocumentCategorizerME
implements DocumentCategorizer {
    private static FeatureGenerator defaultFeatureGenerator = new BagOfWordsFeatureGenerator();
    private DoccatModel model;
    private DocumentCategorizerContextGenerator mContextGenerator;

    public DocumentCategorizerME(DoccatModel model) {
        this.model = model;
        this.mContextGenerator = new DocumentCategorizerContextGenerator(this.model.getFactory().getFeatureGenerators());
    }

    @Override
    public double[] categorize(String[] text, Map<String, Object> extraInformation) {
        return this.model.getMaxentModel().eval(this.mContextGenerator.getContext(text, extraInformation));
    }

    @Override
    public double[] categorize(String[] text) {
        return this.categorize(text, Collections.emptyMap());
    }

    @Override
    public Map<String, Double> scoreMap(String[] text) {
        HashMap<String, Double> probDist = new HashMap<String, Double>();
        double[] categorize = this.categorize(text);
        int catSize = this.getNumberOfCategories();
        for (int i = 0; i < catSize; ++i) {
            String category = this.getCategory(i);
            probDist.put(category, categorize[this.getIndex(category)]);
        }
        return probDist;
    }

    @Override
    public SortedMap<Double, Set<String>> sortedScoreMap(String[] text) {
        TreeMap<Double, Set<String>> descendingMap = new TreeMap<Double, Set<String>>();
        double[] categorize = this.categorize(text);
        int catSize = this.getNumberOfCategories();
        for (int i = 0; i < catSize; ++i) {
            String category = this.getCategory(i);
            double score = categorize[this.getIndex(category)];
            if (descendingMap.containsKey(score)) {
                ((Set)descendingMap.get(score)).add(category);
                continue;
            }
            HashSet<String> newset = new HashSet<String>();
            newset.add(category);
            descendingMap.put(score, newset);
        }
        return descendingMap;
    }

    @Override
    public String getBestCategory(double[] outcome) {
        return this.model.getMaxentModel().getBestOutcome(outcome);
    }

    @Override
    public int getIndex(String category) {
        return this.model.getMaxentModel().getIndex(category);
    }

    @Override
    public String getCategory(int index) {
        return this.model.getMaxentModel().getOutcome(index);
    }

    @Override
    public int getNumberOfCategories() {
        return this.model.getMaxentModel().getNumOutcomes();
    }

    @Override
    public String getAllResults(double[] results) {
        return this.model.getMaxentModel().getAllOutcomes(results);
    }

    public static DoccatModel train(String languageCode, ObjectStream<DocumentSample> samples, TrainingParameters mlParams, DoccatFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams, manifestInfoEntries);
        MaxentModel model = trainer.train(new DocumentCategorizerEventStream(samples, factory.getFeatureGenerators()));
        return new DoccatModel(languageCode, model, manifestInfoEntries, factory);
    }
}

