/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import org.apache.lucene.codecs.memory.LegacyNumericDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.util.Bits;

@Deprecated
final class LegacyNumericDocValuesWrapper
extends NumericDocValues {
    private final Bits docsWithField;
    private final LegacyNumericDocValues values;
    private final int maxDoc;
    private int docID = -1;
    private long value;

    public LegacyNumericDocValuesWrapper(Bits docsWithField, LegacyNumericDocValues values) {
        this.docsWithField = docsWithField;
        this.values = values;
        this.maxDoc = docsWithField.length();
    }

    public int docID() {
        return this.docID;
    }

    public int nextDoc() {
        ++this.docID;
        while (this.docID < this.maxDoc) {
            this.value = this.values.get(this.docID);
            if (this.value != 0L || this.docsWithField.get(this.docID)) {
                return this.docID;
            }
            ++this.docID;
        }
        this.docID = Integer.MAX_VALUE;
        return Integer.MAX_VALUE;
    }

    public int advance(int target) {
        assert (target >= this.docID) : "target=" + target + " docID=" + this.docID;
        if (target == Integer.MAX_VALUE) {
            this.docID = Integer.MAX_VALUE;
        } else {
            this.docID = target - 1;
            this.nextDoc();
        }
        return this.docID;
    }

    public boolean advanceExact(int target) throws IOException {
        this.docID = target;
        this.value = this.values.get(this.docID);
        return this.value != 0L || this.docsWithField.get(this.docID);
    }

    public long cost() {
        return 0L;
    }

    public long longValue() {
        return this.value;
    }

    public String toString() {
        return "LegacyNumericDocValuesWrapper(" + this.values + ")";
    }
}

