.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH R128 __drivermansuffix__ __vendorversion__
.SH NAME
r128 \- ATI Rage 128 video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qr128\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B r128
is an __xservername__ driver for ATI Rage 128 based video cards.  It contains
full support for 8, 15, 16 and 24 bit pixel depths, hardware
acceleration of drawing primitives, hardware cursor, video modes up to
1800x1440 @ 70Hz, doublescan modes (e.g., 320x200 and 320x240), gamma
correction at all pixel depths, a fully programming dot clock and robust
text mode restoration for VT switching.  Dualhead is supported on M3/M4
mobile chips.
.SH SUPPORTED HARDWARE
The
.B r128
driver supports all ATI Rage 128 based video cards including the Rage
Fury AGP 32MB, the XPERT 128 AGP 16MB and the XPERT 99 AGP 8MB.
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The driver auto-detects all device information necessary to initialize
the card.  However, if you have problems with auto-detection, you can
specify:
.PP
.RS 4
VideoRam - in kilobytes
.br
MemBase  - physical address of the linear framebuffer
.br
IOBase   - physical address of the MMIO registers
.br
ChipID   - PCI DEVICE ID
.RE
.PP
In addition, the following driver
.B Options
are supported:
.TP
.BI "Option \*qSWcursor\*q \*q" boolean \*q
Selects software cursor.  The default is
.B off.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Enables or disables all hardware acceleration.  The default is to
.B enable
hardware acceleration.
.TP
.BI "Option \*qEnablePageFlip\*q \*q" boolean \*q
Enable page flipping for 3D acceleration. This will increase performance
but not work correctly in some rare cases, hence the default is
.B off.
.TP
.BI "Option \*qRenderAccel\*q \*q" boolean \*q
Enables or disables hardware Render acceleration.  It is only supported when
using EXA acceleration and DRI.  The default is to
.B enable
Render acceleration.
.TP
.BI "Option \*qAccelMethod\*q \*q" "string" \*q
Chooses between available acceleration architectures.  Valid options are
.B XAA
and
.B EXA.
XAA is the traditional acceleration architecture and support for it is very
stable.  EXA is a newer acceleration architecture with better performance for
the Render and Composite extensions.  The default is
.B XAA.
.TP
.BI "Option \*qVideoKey\*q \*q" integer \*q
This overrides the default pixel value for the YUV video overlay key.
The default value is
.B undefined.

.PP
The following
.B Options
are mostly important for non-x86 architectures:
.TP
.BI "Option \*qProgramFPRegs\*q \*q" boolean \*q
Enable or disable programming of the flat panel registers.
Beware that this may damage your panel, so use this
.B at your own risk.
The default depends on the device.
.TP
.BI "Option \*qPanelWidth\*q \*q" integer \*q
.TP
.BI "Option \*qPanelHeight\*q \*q" integer \*q
Override the flat panel dimensions in pixels. They are used to program the flat panel
registers and normally determined using the video card BIOS. If the wrong dimensions
are used, the system may hang.
.TP
.BI "Option \*qUseFBDev\*q \*q" boolean \*q
Enable or disable use of an OS-specific framebuffer device interface
(which is not supported on all OSs).  See fbdevhw(__drivermansuffix__)
for further information.
Default: 
.BI on 
for PowerPC, 
.BI off 
for other architectures.
.TP
.BI "Option \*qDMAForXv\*q \*q" boolean \*q
Try or don't try to use DMA for Xv image transfers. This will reduce CPU
usage when playing big videos like DVDs, but may cause instabilities.
Default: off.

.PP
The following additional
.B Options
are supported:
.TP
.BI "Option \*qShowCache\*q \*q" boolean \*q
Enable or disable viewing offscreen cache memory.  A
development debug option.  Default: off.
.TP
.BI "Option \*qVGAAccess\*q \*q" boolean \*q
Tell the driver if it can do legacy VGA IOs to the card. This is
necessary for properly resuming consoles when in VGA text mode, but
shouldn't be if the console is using radeonfb or some other graphic
mode driver. Some platforms like PowerPC have issues with those, and they aren't
necessary unless you have a real text mode in console. The default is
.B off
on PowerPC and SPARC and
.B on
on other architectures.

.PP
.B Dualhead Note: 
The video BIOS on some laptops interacts strangely with dualhead.
This can result in flickering and problems changing modes on crtc2.
If you experience these problems try toggling your laptop's video
output switch (e.g., fn-f7, etc.) prior to starting X or switch to
another VT and back.

.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
.nf
Rickard E. (Rik) Faith   \fIfaith@precisioninsight.com\fP
Kevin E. Martin          \fIkevin@precisioninsight.com\fP
