/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.ServerTestHelper;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.NativeAIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.util.test.FreeColTestCase;

public class StandardAIPlayerTest
extends FreeColTestCase {
    private static final GoodsType horsesType = StandardAIPlayerTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType musketsType = StandardAIPlayerTest.spec().getGoodsType("model.goods.muskets");
    private static final Role nativeDragoonRole = StandardAIPlayerTest.spec().getRole("model.role.nativeDragoon");
    private int horsesReqPerUnit = 0;
    private int musketsReqPerUnit = 0;
    private LogBuilder lb = new LogBuilder(0);

    @Override
    public void tearDown() throws Exception {
        ServerTestHelper.stopServerGame();
        super.tearDown();
    }

    private void setupNativeDragoons() {
        for (AbstractGoods ag : nativeDragoonRole.getRequiredGoodsList()) {
            if (ag.getType() == horsesType) {
                this.horsesReqPerUnit = ag.getAmount();
                continue;
            }
            if (ag.getType() != musketsType) continue;
            this.musketsReqPerUnit = ag.getAmount();
        }
        StandardAIPlayerTest.assertFalse((this.horsesReqPerUnit == 0 ? 1 : 0) != 0);
        StandardAIPlayerTest.assertFalse((this.musketsReqPerUnit == 0 ? 1 : 0) != 0);
    }

    public void testEquipBraves() {
        ServerGame game = ServerTestHelper.startServerGame(StandardAIPlayerTest.getTestMap());
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.initialBravesInCamp(3).build();
        NativeAIPlayer player = (NativeAIPlayer)aiMain.getAIPlayer(camp.getOwner());
        game.setCurrentPlayer(camp.getOwner());
        this.setupNativeDragoons();
        int bravesToEquip = camp.getUnitCount();
        int totalHorsesReq = bravesToEquip * this.horsesReqPerUnit;
        int totalMusketsReq = bravesToEquip * this.musketsReqPerUnit;
        int totalHorsesAvail = totalHorsesReq * 2;
        int totalMusketsAvail = totalMusketsReq * 2;
        StandardAIPlayerTest.assertEquals((String)"No horses should exist in camp", (int)0, (int)camp.getGoodsCount(horsesType));
        StandardAIPlayerTest.assertEquals((String)"No muskets should exist in camp", (int)0, (int)camp.getGoodsCount(musketsType));
        for (Unit unit : camp.getUnitList()) {
            StandardAIPlayerTest.assertFalse((String)"Indian should not have mounted braves", (boolean)unit.isMounted());
            StandardAIPlayerTest.assertFalse((String)"Indian should not have armed braves", (boolean)unit.isArmed());
        }
        camp.addGoods(horsesType, totalHorsesAvail);
        camp.addGoods(musketsType, totalMusketsAvail);
        StandardAIPlayerTest.assertEquals((String)"Wrong initial number of horses in Indian camp", (int)totalHorsesAvail, (int)camp.getGoodsCount(horsesType));
        StandardAIPlayerTest.assertEquals((String)"Wrong initial number of muskets in Indian camp", (int)totalMusketsAvail, (int)camp.getGoodsCount(musketsType));
        player.equipBraves(camp, this.lb);
        int mounted = 0;
        int armed = 0;
        for (Unit unit : camp.getUnitList()) {
            if (unit.isMounted()) {
                ++mounted;
            }
            if (!unit.isArmed()) continue;
            ++armed;
        }
        StandardAIPlayerTest.assertEquals((String)"Wrong number of units armed", (int)bravesToEquip, (int)armed);
        StandardAIPlayerTest.assertEquals((String)"Wrong number of units mounted", (int)bravesToEquip, (int)mounted);
        StandardAIPlayerTest.assertEquals((String)"Wrong final number of muskets in Indian camp", (int)totalMusketsReq, (int)camp.getGoodsCount(musketsType));
        StandardAIPlayerTest.assertEquals((String)"Wrong final number of horses in Indian camp", (int)totalHorsesReq, (int)camp.getGoodsCount(horsesType));
    }

    public void testEquipBravesNotEnoughReqGoods() {
        ServerGame game = ServerTestHelper.startServerGame(StandardAIPlayerTest.getTestMap());
        AIMain aiMain = ServerTestHelper.getServer().getAIMain();
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement camp = builder.initialBravesInCamp(3).build();
        NativeAIPlayer player = (NativeAIPlayer)aiMain.getAIPlayer(camp.getOwner());
        game.setCurrentPlayer(camp.getOwner());
        this.setupNativeDragoons();
        int bravesToEquip = camp.getUnitCount() - 1;
        int totalHorsesAvail = bravesToEquip * this.horsesReqPerUnit + horsesType.getBreedingNumber();
        int totalMusketsAvail = bravesToEquip * this.musketsReqPerUnit;
        StandardAIPlayerTest.assertEquals((String)"No horses should exist in camp", (int)0, (int)camp.getGoodsCount(horsesType));
        StandardAIPlayerTest.assertEquals((String)"No muskets should exist in camp", (int)0, (int)camp.getGoodsCount(musketsType));
        for (Unit unit : camp.getUnitList()) {
            if (unit.isMounted()) {
                StandardAIPlayerTest.fail((String)"Indian should not have mounted braves");
            }
            if (!unit.isArmed()) continue;
            StandardAIPlayerTest.fail((String)"Indian should not have armed braves");
        }
        camp.addGoods(horsesType, totalHorsesAvail);
        camp.addGoods(musketsType, totalMusketsAvail);
        StandardAIPlayerTest.assertEquals((String)"Wrong initial number of horses in Indian camp", (int)totalHorsesAvail, (int)camp.getGoodsCount(horsesType));
        StandardAIPlayerTest.assertEquals((String)"Wrong initial number of muskets in Indian camp", (int)totalMusketsAvail, (int)camp.getGoodsCount(musketsType));
        player.equipBraves(camp, this.lb);
        int mounted = 0;
        int armed = 0;
        for (Unit unit : camp.getUnitList()) {
            if (unit.isMounted()) {
                ++mounted;
            }
            if (!unit.isArmed()) continue;
            ++armed;
        }
        StandardAIPlayerTest.assertEquals((String)"Wrong number of units armed", (int)bravesToEquip, (int)armed);
        StandardAIPlayerTest.assertEquals((String)"Wrong number of units mounted", (int)bravesToEquip, (int)mounted);
        StandardAIPlayerTest.assertEquals((String)"Wrong final number of muskets in Indian camp", (int)0, (int)camp.getGoodsCount(musketsType));
        StandardAIPlayerTest.assertEquals((String)"Wrong final number of horses in Indian camp", (int)horsesType.getBreedingNumber(), (int)camp.getGoodsCount(horsesType));
    }
}

