/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.packet;

public enum PubSubNamespace {
    basic(null),
    error("errors"),
    event("event"),
    owner("owner");

    private final String fragment;
    private final String fullNamespace;

    private PubSubNamespace(String fragment) {
        this.fragment = fragment;
        this.fullNamespace = fragment != null ? "http://jabber.org/protocol/pubsub#" + fragment : "http://jabber.org/protocol/pubsub";
    }

    public String getXmlns() {
        return this.fullNamespace;
    }

    public String getFragment() {
        return this.fragment;
    }

    public static PubSubNamespace valueOfFromXmlns(String ns) {
        int index = ns.lastIndexOf(35);
        if (index != -1) {
            if (index > ns.length()) {
                throw new IllegalArgumentException(ns + " is not a valid PubSub namespace");
            }
            String suffix = ns.substring(index + 1);
            return PubSubNamespace.valueOf(suffix);
        }
        if (!"http://jabber.org/protocol/pubsub".equals(ns)) {
            throw new IllegalArgumentException(ns + " is not a valid PubSub namespace");
        }
        return basic;
    }
}

