/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.smallrye.config.ConfigSourceInterceptorContext;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logmanager.LogContext;
import org.keycloak.config.LoggingOptions;
import org.keycloak.config.Option;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.PropertyException;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.TracingPropertyMappers;
import org.keycloak.quarkus.runtime.configuration.mappers.WildcardPropertyMapper;

public final class LoggingPropertyMappers {
    private static final String CONSOLE_ENABLED_MSG = "Console log handler is activated";
    private static final String FILE_ENABLED_MSG = "File log handler is activated";
    private static final String SYSLOG_ENABLED_MSG = "Syslog is activated";
    private static final String DEFAULT_ROOT_LOG_LEVEL = LoggingPropertyMappers.toLevel((String)((List)LoggingOptions.LOG_LEVEL.getDefaultValue().orElseThrow()).get(0)).getName();
    private static final Map<String, Map<String, String>> rootLogLevels = new HashMap<String, Map<String, String>>();

    private LoggingPropertyMappers() {
    }

    public static PropertyMapper<?>[] getMappers() {
        rootLogLevels.clear();
        PropertyMapper[] defaultMappers = new PropertyMapper[]{PropertyMapper.fromOption(LoggingOptions.LOG).paramLabel("<handler>").build(), PropertyMapper.fromOption(LoggingOptions.LOG_ASYNC).build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_OUTPUT).isEnabled(LoggingPropertyMappers::isConsoleEnabled, CONSOLE_ENABLED_MSG).to("quarkus.log.console.json.enabled").paramLabel("output").transformer(LoggingPropertyMappers::resolveLogOutput).build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_LEVEL).isEnabled(LoggingPropertyMappers::isConsoleEnabled, CONSOLE_ENABLED_MSG).to("quarkus.log.console.level").paramLabel("level").transformer(LoggingPropertyMappers::upperCase).build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_FORMAT).isEnabled(LoggingPropertyMappers::isConsoleEnabled, CONSOLE_ENABLED_MSG).to("quarkus.log.console.format").paramLabel("format").transformer((value, ctx) -> LoggingPropertyMappers.addTracingInfo(value, (Option<Boolean>)LoggingOptions.LOG_CONSOLE_INCLUDE_TRACE)).build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_JSON_FORMAT).isEnabled(LoggingPropertyMappers::isConsoleJsonEnabled, "%s and output is set to 'json'".formatted(CONSOLE_ENABLED_MSG)).to("quarkus.log.console.json.log-format").paramLabel("format").build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_INCLUDE_TRACE).isEnabled(() -> LoggingPropertyMappers.isConsoleEnabled() && TracingPropertyMappers.isTracingEnabled(), "Console log handler and Tracing is activated").build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_COLOR).isEnabled(LoggingPropertyMappers::isConsoleEnabled, CONSOLE_ENABLED_MSG).to("quarkus.log.console.color").build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_ENABLED).mapFrom(LoggingOptions.LOG, LoggingPropertyMappers.resolveLogHandler(LoggingOptions.DEFAULT_LOG_HANDLER.name())).to("quarkus.log.console.enable").build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_ASYNC).mapFrom(LoggingOptions.LOG_ASYNC).isEnabled(LoggingPropertyMappers::isConsoleEnabled, CONSOLE_ENABLED_MSG).to("quarkus.log.console.async").build(), PropertyMapper.fromOption(LoggingOptions.LOG_CONSOLE_ASYNC_QUEUE_LENGTH).isEnabled(LoggingPropertyMappers::isConsoleAsyncEnabled, "%s and asynchronous logging is enabled".formatted(CONSOLE_ENABLED_MSG)).to("quarkus.log.console.async.queue-length").paramLabel("queue-length").build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_ENABLED).mapFrom(LoggingOptions.LOG, LoggingPropertyMappers.resolveLogHandler("file")).to("quarkus.log.file.enable").build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE).isEnabled(LoggingPropertyMappers::isFileEnabled, FILE_ENABLED_MSG).to("quarkus.log.file.path").paramLabel("file").transformer(LoggingPropertyMappers::resolveFileLogLocation).build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_LEVEL).isEnabled(LoggingPropertyMappers::isFileEnabled, FILE_ENABLED_MSG).to("quarkus.log.file.level").paramLabel("level").transformer(LoggingPropertyMappers::upperCase).build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_FORMAT).isEnabled(LoggingPropertyMappers::isFileEnabled, FILE_ENABLED_MSG).to("quarkus.log.file.format").paramLabel("format").transformer((value, ctx) -> LoggingPropertyMappers.addTracingInfo(value, (Option<Boolean>)LoggingOptions.LOG_FILE_INCLUDE_TRACE)).build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_JSON_FORMAT).isEnabled(LoggingPropertyMappers::isFileJsonEnabled, "File log handler is activated and output is set to 'json'").to("quarkus.log.file.json.log-format").paramLabel("format").build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_INCLUDE_TRACE).isEnabled(() -> LoggingPropertyMappers.isFileEnabled() && TracingPropertyMappers.isTracingEnabled(), "File log handler and Tracing is activated").build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_OUTPUT).isEnabled(LoggingPropertyMappers::isFileEnabled, FILE_ENABLED_MSG).to("quarkus.log.file.json.enabled").paramLabel("output").transformer(LoggingPropertyMappers::resolveLogOutput).build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_ASYNC).mapFrom(LoggingOptions.LOG_ASYNC).isEnabled(LoggingPropertyMappers::isFileEnabled, FILE_ENABLED_MSG).to("quarkus.log.file.async").build(), PropertyMapper.fromOption(LoggingOptions.LOG_FILE_ASYNC_QUEUE_LENGTH).isEnabled(LoggingPropertyMappers::isFileAsyncEnabled, "%s and asynchronous logging is enabled".formatted(FILE_ENABLED_MSG)).to("quarkus.log.file.async.queue-length").paramLabel("queue-length").build(), PropertyMapper.fromOption(LoggingOptions.LOG_LEVEL).to("quarkus.log.level").transformer(LoggingPropertyMappers::resolveRootLogLevel).validator(LoggingPropertyMappers::validateLogLevel).paramLabel("category:level").build(), PropertyMapper.fromOption(LoggingOptions.LOG_LEVEL_CATEGORY).to("quarkus.log.category.\"<categories>\".level").validator(LoggingPropertyMappers::validateCategoryLogLevel).wildcardKeysTransformer(LoggingPropertyMappers::getConfiguredLogCategories).transformer((v, c) -> v == null ? null : LoggingPropertyMappers.toLevel(v).getName()).wildcardMapFrom(LoggingOptions.LOG_LEVEL, LoggingPropertyMappers::resolveCategoryLogLevelFromParentLogLevelOption).paramLabel("level").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_ENABLED).mapFrom(LoggingOptions.LOG, LoggingPropertyMappers.resolveLogHandler("syslog")).to("quarkus.log.syslog.enable").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_ENDPOINT).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.endpoint").paramLabel("host:port").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_LEVEL).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.level").paramLabel("level").transformer(LoggingPropertyMappers::upperCase).build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_APP_NAME).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.app-name").paramLabel("name").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_TYPE).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.syslog-type").paramLabel("type").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_MAX_LENGTH).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.max-length").validator(LoggingPropertyMappers::validateSyslogMaxLength).paramLabel("max-length").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_PROTOCOL).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.protocol").paramLabel("protocol").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_FORMAT).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.format").paramLabel("format").transformer((value, ctx) -> LoggingPropertyMappers.addTracingInfo(value, (Option<Boolean>)LoggingOptions.LOG_SYSLOG_INCLUDE_TRACE)).build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_JSON_FORMAT).isEnabled(LoggingPropertyMappers::isSyslogJsonEnabled, "Syslog is activated and output is set to 'json'").to("quarkus.log.syslog.json.log-format").paramLabel("format").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_INCLUDE_TRACE).isEnabled(() -> LoggingPropertyMappers.isSyslogEnabled() && TracingPropertyMappers.isTracingEnabled(), "Syslog handler and Tracing is activated").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_OUTPUT).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.json.enabled").paramLabel("output").transformer(LoggingPropertyMappers::resolveLogOutput).build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_COUNTING_FRAMING).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).transformer(LoggingPropertyMappers::resolveSyslogCountingFraming).to("quarkus.log.syslog.use-counting-framing").paramLabel("strategy").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_ASYNC).mapFrom(LoggingOptions.LOG_ASYNC).isEnabled(LoggingPropertyMappers::isSyslogEnabled, SYSLOG_ENABLED_MSG).to("quarkus.log.syslog.async").build(), PropertyMapper.fromOption(LoggingOptions.LOG_SYSLOG_ASYNC_QUEUE_LENGTH).isEnabled(LoggingPropertyMappers::isSyslogAsyncEnabled, "%s and asynchronous logging is enabled".formatted(SYSLOG_ENABLED_MSG)).to("quarkus.log.syslog.async.queue-length").paramLabel("queue-length").build()};
        return defaultMappers;
    }

    public static boolean isConsoleEnabled() {
        return LoggingPropertyMappers.isHandlerEnabled(LoggingOptions.Handler.console);
    }

    public static boolean isConsoleAsyncEnabled() {
        return LoggingPropertyMappers.isHandlerAsyncEnabled(LoggingOptions.Handler.console);
    }

    public static boolean isConsoleJsonEnabled() {
        return LoggingPropertyMappers.isConsoleEnabled() && Configuration.isTrue("quarkus.log.console.json.enabled");
    }

    public static boolean isFileEnabled() {
        return LoggingPropertyMappers.isHandlerEnabled(LoggingOptions.Handler.file);
    }

    public static boolean isFileAsyncEnabled() {
        return LoggingPropertyMappers.isHandlerAsyncEnabled(LoggingOptions.Handler.file);
    }

    public static boolean isFileJsonEnabled() {
        return LoggingPropertyMappers.isFileEnabled() && Configuration.isTrue("quarkus.log.file.json.enabled");
    }

    public static boolean isSyslogEnabled() {
        return LoggingPropertyMappers.isHandlerEnabled(LoggingOptions.Handler.syslog);
    }

    public static boolean isSyslogAsyncEnabled() {
        return LoggingPropertyMappers.isHandlerAsyncEnabled(LoggingOptions.Handler.syslog);
    }

    public static boolean isSyslogJsonEnabled() {
        return LoggingPropertyMappers.isSyslogEnabled() && Configuration.isTrue("quarkus.log.syslog.json.enabled");
    }

    private static boolean isHandlerEnabled(LoggingOptions.Handler handler) {
        return switch (handler) {
            default -> throw new IncompatibleClassChangeError();
            case LoggingOptions.Handler.console -> Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_CONSOLE_ENABLED);
            case LoggingOptions.Handler.file -> Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_FILE_ENABLED);
            case LoggingOptions.Handler.syslog -> Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_SYSLOG_ENABLED);
        };
    }

    private static boolean isHandlerAsyncEnabled(LoggingOptions.Handler handler) {
        if (!LoggingPropertyMappers.isHandlerEnabled(handler)) {
            return false;
        }
        Option property = switch (handler) {
            default -> throw new IncompatibleClassChangeError();
            case LoggingOptions.Handler.console -> LoggingOptions.LOG_CONSOLE_ASYNC;
            case LoggingOptions.Handler.file -> LoggingOptions.LOG_FILE_ASYNC;
            case LoggingOptions.Handler.syslog -> LoggingOptions.LOG_SYSLOG_ASYNC;
        };
        return Configuration.isSet(property) ? Configuration.isTrue((Option<Boolean>)property) : Configuration.isTrue((Option<Boolean>)LoggingOptions.LOG_ASYNC);
    }

    private static BiFunction<String, ConfigSourceInterceptorContext, String> resolveLogHandler(String handler) {
        return (handlers, context) -> {
            String[] logHandlerValues = handlers.split(",");
            return String.valueOf(Stream.of(logHandlerValues).anyMatch(handler::equals));
        };
    }

    private static String resolveFileLogLocation(String value, ConfigSourceInterceptorContext configSourceInterceptorContext) {
        return value.endsWith(File.separator) ? value + "keycloak.log" : value;
    }

    private static Level toLevel(String categoryLevel) throws IllegalArgumentException {
        return LogContext.getLogContext().getLevelForName(categoryLevel.toUpperCase(Locale.ROOT));
    }

    private static CategoryLevel validateLogLevel(String level) {
        String categoryLevel;
        String[] parts = level.split(":");
        String category = null;
        if (parts.length == 1) {
            categoryLevel = parts[0];
        } else if (parts.length == 2) {
            category = parts[0];
            if (!WildcardPropertyMapper.isValidWildcardValue(category)) {
                throw new PropertyException("logging category '%s' is not valid".formatted(category));
            }
            categoryLevel = parts[1];
        } else {
            throw new PropertyException(Messages.invalidLogCategoryFormat(level));
        }
        try {
            Level levelType = LoggingPropertyMappers.toLevel(categoryLevel);
            return new CategoryLevel(category, levelType.getName());
        }
        catch (IllegalArgumentException iae) {
            throw new PropertyException(Messages.invalidLogCategoryFormat(level));
        }
    }

    private static String resolveRootLogLevel(String value, ConfigSourceInterceptorContext configSourceInterceptorContext) {
        return LoggingPropertyMappers.parseRootLogLevel(value).getOrDefault(null, DEFAULT_ROOT_LOG_LEVEL);
    }

    private static Set<String> getConfiguredLogCategories(String value, Set<String> categories) {
        return LoggingPropertyMappers.parseRootLogLevel(value).keySet().stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void validateCategoryLogLevel(String logLevel) {
        try {
            LoggingPropertyMappers.toLevel(logLevel);
        }
        catch (IllegalArgumentException iae) {
            throw new PropertyException(Messages.invalidLogLevel(logLevel));
        }
    }

    private static String resolveCategoryLogLevelFromParentLogLevelOption(String category, String parentLogLevelValue, ConfigSourceInterceptorContext context) {
        return LoggingPropertyMappers.parseRootLogLevel(parentLogLevelValue).get(category);
    }

    private static Map<String, String> parseRootLogLevel(String values) {
        if (values == null) {
            return Map.of();
        }
        return rootLogLevels.computeIfAbsent(values, key -> Stream.of(values.split(",")).map(LoggingPropertyMappers::validateLogLevel).collect(Collectors.toMap(CategoryLevel::category, CategoryLevel::levelName, (s1, s2) -> s1, LinkedHashMap::new)));
    }

    private static String resolveLogOutput(String value, ConfigSourceInterceptorContext context) {
        boolean isDefault = LoggingOptions.DEFAULT_CONSOLE_OUTPUT.name().toLowerCase(Locale.ROOT).equals(value);
        return Boolean.valueOf(!isDefault).toString();
    }

    private static String addTracingInfo(String value, Option<Boolean> includeTraceOption) {
        boolean isChangedLogFormat;
        boolean isTracingEnabled = TracingPropertyMappers.isTracingEnabled();
        boolean includeTrace = Configuration.isTrue(includeTraceOption);
        boolean bl = isChangedLogFormat = !LoggingOptions.DEFAULT_LOG_FORMAT.equals(value);
        if (!isTracingEnabled || !includeTrace || isChangedLogFormat) {
            return value;
        }
        return LoggingOptions.DEFAULT_LOG_TRACING_FORMAT;
    }

    private static String upperCase(String value, ConfigSourceInterceptorContext context) {
        return value.toUpperCase(Locale.ROOT);
    }

    private static void validateSyslogMaxLength(String value) {
        MemorySizeConverter converter = new MemorySizeConverter();
        try {
            converter.convert(value);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyException(String.format("Invalid value for option '--log-syslog-max-length': %s", e.getMessage()));
        }
    }

    private static String resolveSyslogCountingFraming(String value, ConfigSourceInterceptorContext context) {
        if ("protocol-dependent".equals(value)) {
            return Configuration.getOptionalKcValue(LoggingOptions.LOG_SYSLOG_PROTOCOL).map(protocol -> switch (protocol) {
                case "tcp", "ssl-tcp" -> Boolean.TRUE.toString();
                case "udp" -> Boolean.FALSE.toString();
                default -> throw new PropertyException("Invalid Syslog protocol: " + protocol);
            }).orElse(Boolean.FALSE.toString());
        }
        return value;
    }

    record CategoryLevel(String category, String levelName) {
    }
}

