/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Location;
import org.locationtech.jts.operation.relateng.IMPredicate;
import org.locationtech.jts.operation.relateng.TopologyPredicate;

public class TopologyPredicateTracer {
    public static TopologyPredicate trace(TopologyPredicate pred) {
        return new PredicateTracer(pred);
    }

    private TopologyPredicateTracer() {
    }

    private static class PredicateTracer
    implements TopologyPredicate {
        private TopologyPredicate pred;

        private PredicateTracer(TopologyPredicate pred) {
            this.pred = pred;
        }

        @Override
        public String name() {
            return this.pred.name();
        }

        @Override
        public boolean requireSelfNoding() {
            return this.pred.requireSelfNoding();
        }

        @Override
        public boolean requireInteraction() {
            return this.pred.requireInteraction();
        }

        @Override
        public boolean requireCovers(boolean isSourceA) {
            return this.pred.requireCovers(isSourceA);
        }

        @Override
        public boolean requireExteriorCheck(boolean isSourceA) {
            return this.pred.requireExteriorCheck(isSourceA);
        }

        @Override
        public void init(int dimA, int dimB) {
            this.pred.init(dimA, dimB);
            this.checkValue("dimensions");
        }

        @Override
        public void init(Envelope envA, Envelope envB) {
            this.pred.init(envA, envB);
            this.checkValue("envelopes");
        }

        @Override
        public void updateDimension(int locA, int locB, int dimension) {
            String desc = "A:" + Location.toLocationSymbol(locA) + "/B:" + Location.toLocationSymbol(locB) + " -> " + dimension;
            String ind = "";
            boolean isChanged = this.isDimChanged(locA, locB, dimension);
            if (isChanged) {
                ind = " <<< ";
            }
            System.out.println(desc + ind);
            this.pred.updateDimension(locA, locB, dimension);
            if (isChanged) {
                this.checkValue("IM entry");
            }
        }

        private boolean isDimChanged(int locA, int locB, int dimension) {
            if (this.pred instanceof IMPredicate) {
                return ((IMPredicate)this.pred).isDimChanged(locA, locB, dimension);
            }
            return false;
        }

        private void checkValue(String source) {
            if (this.pred.isKnown()) {
                System.out.println(this.name() + " = " + this.pred.value() + " based on " + source);
            }
        }

        @Override
        public void finish() {
            this.pred.finish();
        }

        @Override
        public boolean isKnown() {
            return this.pred.isKnown();
        }

        @Override
        public boolean value() {
            return this.pred.value();
        }

        public String toString() {
            return this.pred.toString();
        }
    }
}

