/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.compression.Brotli;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.SnappyFrameDecoder;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.compression.ZlibWrapper;
import io.netty.handler.codec.compression.Zstd;
import io.netty.handler.codec.compression.ZstdDecoder;
import io.netty.handler.codec.http.HttpContentDecoder;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.internal.ObjectUtil;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;
    private final int maxAllocation;

    @Deprecated
    public HttpContentDecompressor() {
        this(false, 0);
    }

    public HttpContentDecompressor(int maxAllocation) {
        this(false, maxAllocation);
    }

    @Deprecated
    public HttpContentDecompressor(boolean strict) {
        this(strict, 0);
    }

    public HttpContentDecompressor(boolean strict, int maxAllocation) {
        this.strict = strict;
        this.maxAllocation = ObjectUtil.checkPositiveOrZero((int)maxAllocation, (String)"maxAllocation");
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        Channel channel = this.ctx.channel();
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)ZlibWrapper.GZIP, (int)this.maxAllocation)).build();
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)ZlibCodecFactory.newZlibDecoder((ZlibWrapper)wrapper, (int)this.maxAllocation)).build();
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new BrotliDecoder()).build();
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new SnappyFrameDecoder()).build();
        }
        if (Zstd.isAvailable() && HttpHeaderValues.ZSTD.contentEqualsIgnoreCase((CharSequence)contentEncoding)) {
            return EmbeddedChannel.builder().channelId(channel.id()).hasDisconnect(channel.metadata().hasDisconnect()).config(channel.config()).handlers((ChannelHandler)new ZstdDecoder()).build();
        }
        return null;
    }
}

