/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectListener;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HitpointsCombatModel;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SimpleCombatModel;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Introspector;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerColonyTile;
import net.sf.freecol.server.model.ServerEurope;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerIndianSettlement;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerRegion;
import net.sf.freecol.server.model.ServerUnit;

public class Game
extends FreeColGameObject {
    private static final Logger logger = Logger.getLogger(Game.class.getName());
    public static final String TAG = "game";
    private static final java.util.Map<Class<? extends FreeColObject>, Class<? extends FreeColObject>> serverClasses = new HashMap<Class<? extends FreeColObject>, Class<? extends FreeColObject>>();
    private static final java.util.Map<String, Class<? extends FreeColGameObject>> locationClasses;
    private Specification specification = null;
    protected int nextId = 1;
    private UUID uuid = UUID.randomUUID();
    private String clientUserName;
    protected final List<Player> players = new ArrayList<Player>();
    private Player unknownEnemy = null;
    protected Map map = null;
    private NationOptions nationOptions = null;
    protected Player currentPlayer = null;
    private Turn turn = new Turn(1);
    private boolean spanishSuccession = false;
    private String initialActiveUnitId = null;
    protected final HashMap<String, WeakReference<FreeColGameObject>> freeColGameObjects = new HashMap(10000);
    private static final int REMOVE_GC_THRESHOLD = 64;
    private int removeCount = 0;
    protected FreeColGameObjectListener freeColGameObjectListener = null;
    private static final String CIBOLA_TAG = "cibola";
    private static final String CLIENT_USER_NAME_TAG = "clientUserName";
    private static final String CURRENT_PLAYER_TAG = "currentPlayer";
    private static final String INITIAL_ACTIVE_UNIT_ID = "initialActiveUnitId";
    private static final String NEXT_ID_TAG = "nextId";
    private static final String SPANISH_SUCCESSION_TAG = "spanishSuccession";
    private static final String TURN_TAG = "turn";
    private static final String UUID_TAG = "UUID";

    public Game() {
        this.internId("0");
        this.clientUserName = null;
        this.players.clear();
        this.unknownEnemy = null;
        this.map = null;
        this.nationOptions = null;
        this.currentPlayer = null;
        this.spanishSuccession = false;
        this.initialActiveUnitId = null;
        this.specification = null;
        this.removeCount = 0;
        this.initialized = true;
    }

    protected Game(Specification specification) {
        this();
        this.setSpecification(specification);
    }

    public Game(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this();
        this.readFromXML(xr);
    }

    public synchronized boolean preGameUpdate(Game game) {
        return this.copyIn(game);
    }

    public static <T extends FreeColObject> T newInstance(Game game, Class<T> returnClass, boolean server) {
        Class<? extends FreeColObject> sc22;
        if (server && (sc22 = serverClasses.get(returnClass)) != null) {
            returnClass = sc22;
        }
        try {
            return (T)((FreeColObject)Introspector.instantiate(returnClass, new Class[]{Game.class, String.class}, new Object[]{game, null}));
        }
        catch (Introspector.IntrospectorException sc22) {
            if (game != null && FreeColSpecObject.class.isAssignableFrom(returnClass)) {
                try {
                    return (T)((FreeColObject)Introspector.instantiate(returnClass, new Class[]{Specification.class}, new Object[]{game.getSpecification()}));
                }
                catch (Introspector.IntrospectorException ex) {
                    logger.log(Level.WARNING, "newInstance(spec) fail for: " + returnClass.getName(), ex);
                }
            } else {
                try {
                    return (T)((FreeColObject)Introspector.instantiate(returnClass, new Class[0], new Object[0]));
                }
                catch (Introspector.IntrospectorException ex) {
                    logger.log(Level.WARNING, "newInstance(trivial) fail for: " + returnClass.getName(), ex);
                }
            }
            return null;
        }
    }

    public final OptionGroup getDifficultyOptionGroup() {
        return this.specification.getDifficultyOptionGroup();
    }

    public OptionGroup getGameOptions() {
        return this.specification.getGameOptions();
    }

    public void setGameOptions(OptionGroup go) {
        this.specification.setGameOptions(go);
    }

    public OptionGroup getMapGeneratorOptions() {
        return this.specification.getMapGeneratorOptions();
    }

    public void setMapGeneratorOptions(OptionGroup mgo) {
        this.specification.setMapGeneratorOptions(mgo);
    }

    public int getNextId() {
        throw new RuntimeException("game.getNextId not implemented: " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FreeColGameObject getFreeColGameObject(String id) {
        WeakReference<FreeColGameObject> ro;
        if (id == null || id.isEmpty()) {
            return null;
        }
        HashMap<String, WeakReference<FreeColGameObject>> hashMap = this.freeColGameObjects;
        synchronized (hashMap) {
            ro = this.freeColGameObjects.get(id);
        }
        if (ro == null) {
            return null;
        }
        FreeColGameObject o = (FreeColGameObject)ro.get();
        if (o == null) {
            this.removeFreeColGameObject(id, "missed");
            return null;
        }
        return o;
    }

    public <T extends FreeColGameObject> T getFreeColGameObject(String id, Class<T> returnClass) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        try {
            return (T)((FreeColGameObject)returnClass.cast(fcgo));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("Null/empty identifier: " + this);
        }
        if (fcgo == null) {
            throw new RuntimeException("Null FreeColGameObject: " + id);
        }
        WeakReference<FreeColGameObject> wr = new WeakReference<FreeColGameObject>(fcgo);
        HashMap<String, WeakReference<FreeColGameObject>> hashMap = this.freeColGameObjects;
        synchronized (hashMap) {
            this.freeColGameObjects.put(id, wr);
        }
    }

    public void addFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("Null/empty identifier: " + this);
        }
        if (fcgo == null) {
            throw new RuntimeException("Null FreeColGameObject: " + id);
        }
        FreeColGameObject old = this.getFreeColGameObject(id);
        if (old != null) {
            throw new RuntimeException("Tried to replace FCGO " + id + " : " + old.getClass() + " with " + fcgo.getId() + " : " + fcgo.getClass());
        }
        this.setFreeColGameObject(id, fcgo);
        this.notifySetFreeColGameObject(id, fcgo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFreeColGameObject(String id, String reason) {
        if (id == null || id.isEmpty()) {
            throw new RuntimeException("Null/empty identifier: " + this);
        }
        logger.finest("removeFCGO/" + reason + ": " + id);
        this.notifyRemoveFreeColGameObject(id);
        HashMap<String, WeakReference<FreeColGameObject>> hashMap = this.freeColGameObjects;
        synchronized (hashMap) {
            this.freeColGameObjects.remove(id);
        }
        if (++this.removeCount > 64) {
            hashMap = this.freeColGameObjects;
            synchronized (hashMap) {
                Iterator<FreeColGameObject> iter = this.getFreeColGameObjectIterator();
                while (iter.hasNext()) {
                    iter.next();
                }
            }
            this.removeCount = 0;
        }
    }

    public <T extends FreeColGameObject> T update(T other, boolean create) {
        return other == null ? null : (T)this.update(other, other.getFreeColObjectClass(), create);
    }

    private <T extends FreeColGameObject> T update(T other, Class<T> returnClass, boolean create) {
        FreeColGameObject t;
        if (other == null) {
            return null;
        }
        String id = other.getId();
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        if (fcgo == null) {
            if (create) {
                fcgo = (FreeColGameObject)Game.newInstance(this, returnClass, false);
                fcgo.setId(id);
            } else {
                logger.warning("Update of missing object: " + id + "\n" + FreeColDebugger.stackTraceToString());
                return null;
            }
        }
        try {
            t = (FreeColGameObject)returnClass.cast(fcgo);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Update class clash: " + fcgo.getClass() + " / " + returnClass, cce);
        }
        if (!t.copyIn(other)) {
            throw new RuntimeException("Update copy failed: " + id + " onto " + t);
        }
        if (create) {
            t.internId(id);
        }
        return (T)t;
    }

    public <T extends FreeColGameObject> List<T> update(Collection<T> other, boolean create) {
        if (other == null) {
            return null;
        }
        ArrayList<FreeColGameObject> ret = new ArrayList<FreeColGameObject>();
        for (FreeColGameObject t : other) {
            FreeColGameObject nt = this.update(t, create);
            if (nt == null) continue;
            ret.add(nt);
        }
        return ret;
    }

    public <T extends FreeColGameObject> T updateRef(T other) {
        return other == null ? null : (T)this.updateRef(other, other.getFreeColObjectClass());
    }

    private <T extends FreeColGameObject> T updateRef(T other, Class<T> returnClass) {
        if (other == null) {
            return null;
        }
        String id = other.getId();
        return this.getFreeColGameObject(id, returnClass);
    }

    public <T extends FreeColGameObject> List<T> updateRef(Collection<T> other) {
        if (other == null) {
            return null;
        }
        ArrayList<FreeColGameObject> ret = new ArrayList<FreeColGameObject>();
        for (FreeColGameObject t : other) {
            FreeColGameObject nt = this.updateRef(t);
            if (nt == null) continue;
            ret.add(nt);
        }
        return ret;
    }

    public Location updateLocationRef(Location loc) {
        return loc == null ? null : this.findFreeColLocation(loc.getId());
    }

    public Location findFreeColLocation(String id) {
        FreeColGameObject fcgo = this.getFreeColGameObject(id);
        return fcgo instanceof Location ? (Location)((Object)fcgo) : null;
    }

    private Iterator<FreeColGameObject> getFreeColGameObjectIterator() {
        return new Iterator<FreeColGameObject>(){
            private final Iterator<Map.Entry<String, WeakReference<FreeColGameObject>>> it;
            private Map.Entry<String, WeakReference<FreeColGameObject>> readAhead;
            private FcgoState fcgoState;
            {
                this.it = Game.this.freeColGameObjects.entrySet().iterator();
                this.readAhead = null;
                this.fcgoState = FcgoState.INVALID;
            }

            @Override
            public boolean hasNext() {
                if (this.fcgoState == FcgoState.VALID) {
                    return true;
                }
                while (this.it.hasNext()) {
                    this.readAhead = this.it.next();
                    if (this.readAhead.getValue().get() != null) {
                        this.fcgoState = FcgoState.VALID;
                        return true;
                    }
                    this.fcgoState = FcgoState.CONSUMED;
                    this.remove();
                }
                return false;
            }

            @Override
            public FreeColGameObject next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                FreeColGameObject fcgo = (FreeColGameObject)this.readAhead.getValue().get();
                this.fcgoState = FcgoState.CONSUMED;
                return fcgo;
            }

            @Override
            public void remove() {
                if (this.fcgoState == FcgoState.INVALID) {
                    throw new RuntimeException("No current entry: " + this.fcgoState);
                }
                String key = this.readAhead.getKey();
                this.fcgoState = FcgoState.INVALID;
                this.it.remove();
                logger.finest("removeFCGO/expire: " + key);
                Game.this.notifyRemoveFreeColGameObject(key);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FreeColGameObject> getFreeColGameObjectList() {
        ArrayList<FreeColGameObject> ret = new ArrayList<FreeColGameObject>();
        HashMap<String, WeakReference<FreeColGameObject>> hashMap = this.freeColGameObjects;
        synchronized (hashMap) {
            Iterator<FreeColGameObject> iter = this.getFreeColGameObjectIterator();
            while (iter.hasNext()) {
                ret.add(iter.next());
            }
        }
        return ret;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Player> getPlayerList(Predicate<? super Player> predicate) {
        List<Player> list = this.players;
        synchronized (list) {
            return CollectionUtils.transform(this.players, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Player> getPlayers(Predicate<? super Player> predicate) {
        List<Player> list = this.players;
        synchronized (list) {
            return this.getPlayerList(predicate).stream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getPlayer(Predicate<? super Player> predicate) {
        List<Player> list = this.players;
        synchronized (list) {
            return CollectionUtils.find(this.players, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPlayers(List<Player> players) {
        List<Player> list = this.players;
        synchronized (list) {
            this.players.clear();
            if (players != null) {
                this.players.addAll(players);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Player getPlayerAfter(Player beforePlayer) {
        List<Player> list = this.players;
        synchronized (list) {
            int start;
            if (this.players.isEmpty()) {
                return null;
            }
            int index = start = this.players.indexOf(beforePlayer);
            do {
                Player player;
                if (++index >= this.players.size()) {
                    index = 0;
                }
                if ((player = this.players.get(index)).isUnknownEnemy() || player.isDead()) continue;
                return player;
            } while (index != start);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(Player player) {
        List<Player> list = this.players;
        synchronized (list) {
            if (!this.players.contains(player)) {
                this.players.add(player);
            }
        }
        Nation nation = this.getSpecification().getNation(player.getNationId());
        this.nationOptions.getNations().put(nation, NationOptions.NationState.NOT_AVAILABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePlayer(Player player) {
        Player newCurrent = this.currentPlayer != player ? null : this.getPlayerAfter(this.currentPlayer);
        List<Player> list = this.players;
        synchronized (list) {
            if (!this.players.remove(player)) {
                return false;
            }
        }
        Nation nation = this.getSpecification().getNation(player.getNationId());
        this.nationOptions.getNations().put(nation, NationOptions.NationState.AVAILABLE);
        player.dispose();
        if (newCurrent != null) {
            this.currentPlayer = newCurrent;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Player getFirstPlayer() {
        List<Player> list = this.players;
        synchronized (list) {
            return CollectionUtils.first(this.players);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortPlayers(Comparator<Player> comparator) {
        List<Player> list = this.players;
        synchronized (list) {
            this.players.sort(comparator);
        }
    }

    public Player getPlayerByName(String name) {
        return this.getPlayer(CollectionUtils.matchKeyEquals(name, Player::getName));
    }

    public Player getPlayerByNation(Nation nation) {
        return this.getPlayerByNationId(nation.getId());
    }

    public Player getPlayerByNationId(String nationId) {
        return this.getPlayer(CollectionUtils.matchKeyEquals(nationId, Player::getNationId));
    }

    public List<Player> getLivePlayerList(Player ... exclude) {
        Predicate<Player> livePred = p -> !p.isUnknownEnemy() && !p.isDead() && !CollectionUtils.any(exclude, CollectionUtils.matchKey(p));
        return this.getPlayerList(livePred);
    }

    public Stream<Player> getLivePlayers(Player ... exclude) {
        return this.getLivePlayerList(exclude).stream();
    }

    public List<Player> getLiveEuropeanPlayerList(Player ... exclude) {
        Predicate<Player> europeanPred = p -> !p.isUnknownEnemy() && !p.isDead() && p.isEuropean() && !CollectionUtils.any(exclude, CollectionUtils.matchKey(p));
        return this.getPlayerList(europeanPred);
    }

    public Stream<Player> getLiveEuropeanPlayers(Player ... exclude) {
        return this.getLiveEuropeanPlayerList(exclude).stream();
    }

    public List<Player> getLiveNativePlayerList(Player ... exclude) {
        Predicate<Player> nativePred = p -> !p.isUnknownEnemy() && !p.isDead() && p.isIndian() && !CollectionUtils.any(exclude, CollectionUtils.matchKey(p));
        return this.getPlayerList(nativePred);
    }

    public Stream<Player> getLiveNativePlayers(Player ... exclude) {
        return this.getLiveNativePlayerList(exclude).stream();
    }

    public Player getNextPlayer() {
        return this.getPlayerAfter(this.currentPlayer);
    }

    public void addPlayers(List<Player> players) {
        ArrayList valid = new ArrayList();
        for (Player p : players) {
            FreeColGameObject fcgo = this.getFreeColGameObject(p.getId());
            if (fcgo == null) {
                fcgo = this.update(p, Player.class, true);
                if (fcgo != null) {
                    this.addPlayer((Player)fcgo);
                    logger.finest("addPlayers added new: " + fcgo);
                    continue;
                }
                logger.warning("addPlayers create new fail: " + p);
                continue;
            }
            if (fcgo instanceof Player) {
                if (fcgo.copyIn(p)) {
                    logger.finest("addPlayers copied in: " + fcgo);
                    continue;
                }
                logger.warning("addPlayers copyIn existing fail: " + p);
                continue;
            }
            logger.warning("addPlayers onto non-player: " + fcgo);
        }
    }

    public Player getUnknownEnemy() {
        return this.unknownEnemy;
    }

    public void setUnknownEnemy(Player player) {
        this.unknownEnemy = player;
    }

    public String getClientUserName() {
        return this.clientUserName;
    }

    public boolean isInClient() {
        return this.clientUserName != null;
    }

    public boolean isInServer() {
        return this.clientUserName == null;
    }

    public Player getClientPlayer() {
        return this.clientUserName == null ? null : this.getPlayerByName(this.clientUserName);
    }

    public boolean isInRevengeMode() {
        return this.getPlayer(Player::isUndead) != null;
    }

    public Player getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(Player newCurrentPlayer) {
        this.currentPlayer = newCurrentPlayer;
    }

    public synchronized Map getMap() {
        return this.map;
    }

    public synchronized Map setMap(Map newMap) {
        Map oldMap = this.map;
        this.map = newMap;
        return oldMap;
    }

    public void changeMap(Map newMap) {
        Map oldMap = this.setMap(newMap);
        if (newMap != oldMap) {
            for (HighSeas hs : CollectionUtils.transform(this.getLivePlayers(new Player[0]), CollectionUtils.alwaysTrue(), Player::getHighSeas, CollectionUtils.toListNoNulls())) {
                hs.removeDestination(oldMap);
                hs.addDestination(newMap);
            }
        }
    }

    public final synchronized NationOptions getNationOptions() {
        return this.nationOptions;
    }

    public final synchronized void setNationOptions(NationOptions newNationOptions) {
        this.nationOptions = newNationOptions;
    }

    public Nation getVacantNation() {
        Map.Entry entry = CollectionUtils.find(this.nationOptions.getNations().entrySet(), CollectionUtils.matchKey(NationOptions.NationState.AVAILABLE, Map.Entry::getValue));
        return entry == null ? null : (Nation)entry.getKey();
    }

    public final List<Nation> getVacantNations() {
        return CollectionUtils.transform(this.nationOptions.getNations().entrySet(), CollectionUtils.matchKey(NationOptions.NationState.AVAILABLE, Map.Entry::getValue), Map.Entry::getKey);
    }

    public boolean canAddNewPlayer() {
        return this.getVacantNation() != null;
    }

    public Turn getTurn() {
        return this.turn;
    }

    public void setTurn(Turn newTurn) {
        this.turn = newTurn;
    }

    public int getAge() {
        return this.getSpecification().getAge(this.turn);
    }

    public final CombatModel getCombatModel() {
        if (this.specification.hasAbility("model.ability.hitpointsCombatModel")) {
            return new HitpointsCombatModel();
        }
        return new SimpleCombatModel();
    }

    public final boolean getSpanishSuccession() {
        return this.spanishSuccession;
    }

    public final void setSpanishSuccession(boolean spanishSuccession) {
        this.spanishSuccession = spanishSuccession;
    }

    public String getInitialActiveUnitId() {
        return this.initialActiveUnitId;
    }

    public Unit getInitialActiveUnit() {
        return this.initialActiveUnitId == null ? null : this.getFreeColGameObject(this.initialActiveUnitId, Unit.class);
    }

    public void setInitialActiveUnitId(String initialActiveUnitId) {
        this.initialActiveUnitId = initialActiveUnitId;
    }

    public void setFreeColGameObjectListener(FreeColGameObjectListener fcgol) {
        this.freeColGameObjectListener = fcgol;
    }

    public void notifySetFreeColGameObject(String id, FreeColGameObject fcgo) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.setFreeColGameObject(id, fcgo);
        }
    }

    public void notifyRemoveFreeColGameObject(String id) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.removeFreeColGameObject(id);
        }
    }

    public void notifyOwnerChanged(FreeColGameObject source, Player oldOwner, Player newOwner) {
        if (this.freeColGameObjectListener != null) {
            this.freeColGameObjectListener.ownerChanged(source, oldOwner, newOwner);
        }
    }

    public void checkOwners(Ownable o, Player oldOwner) {
        Player newOwner = o.getOwner();
        if (oldOwner == newOwner) {
            return;
        }
        if (oldOwner != null && oldOwner.removeOwnable(o)) {
            oldOwner.invalidateCanSeeTiles();
        }
        if (newOwner != null && newOwner.addOwnable(o)) {
            newOwner.invalidateCanSeeTiles();
        }
    }

    public boolean allPlayersReadyToLaunch() {
        return CollectionUtils.all(this.getLiveEuropeanPlayerList(new Player[0]), Player::isReady);
    }

    public Stream<Colony> getAllColonies(Player player) {
        return CollectionUtils.flatten(this.getLiveEuropeanPlayerList(player), Player::getColonies);
    }

    public List<Colony> getAllColoniesList(Player player) {
        return CollectionUtils.toList(this.getAllColonies(player));
    }

    public Settlement getSettlementByName(String name) {
        return CollectionUtils.find(CollectionUtils.flatten(this.getLivePlayers(new Player[0]), Player::getSettlements), CollectionUtils.matchKeyEquals(name, Settlement::getName));
    }

    public FreeColGameObject getMessageSource(ModelMessage message) {
        return this.getFreeColGameObject(message.getSourceId());
    }

    public FreeColObject getMessageDisplay(ModelMessage message) {
        FreeColObject o;
        String id = message.getDisplayId();
        if (id == null) {
            id = message.getSourceId();
        }
        if ((o = this.getFreeColGameObject(id)) == null) {
            try {
                o = this.getSpecification().getType(id);
            }
            catch (Exception e) {
                o = null;
            }
        }
        return o;
    }

    public java.util.Map<String, String> getStatistics() {
        HashMap<String, String> stats = new HashMap<String, String>();
        Utils.garbageCollect();
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        stats.put("freeMemory", Long.toString(free));
        stats.put("totalMemory", Long.toString(total));
        stats.put("maxMemory", Long.toString(max));
        HashMap<String, Long> objStats = new HashMap<String, Long>();
        long disposed = 0L;
        for (FreeColGameObject fcgo : this.getFreeColGameObjectList()) {
            String className = fcgo.getClass().getSimpleName();
            Long count = (Long)objStats.get(className);
            if (count != null) {
                Long l = count;
                Long l2 = count = Long.valueOf(count + 1L);
                objStats.put(className, count);
            } else {
                objStats.put(className, 1L);
            }
            if (!fcgo.isDisposed()) continue;
            ++disposed;
        }
        stats.put("disposed", Long.toString(disposed));
        CollectionUtils.forEachMapEntry(objStats, e -> stats.put((String)e.getKey(), Long.toString((Long)e.getValue())));
        return stats;
    }

    public static Class<? extends FreeColGameObject> getLocationClass(String id) {
        return locationClasses.get(StringUtils.capitalize(FreeColObject.getIdTypeByName(id)));
    }

    public <T extends FreeColObject> T unserialize(String xml, Class<T> returnClass) throws XMLStreamException {
        try {
            FreeColXMLReader xr = new FreeColXMLReader(new StringReader(xml));
            xr.nextTag();
            T ret = Game.newInstance(this, returnClass, false);
            ((FreeColObject)ret).readFromXML(xr);
            return ret;
        }
        catch (Exception ex) {
            throw new XMLStreamException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Map map;
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        lb.mark();
        HashMap<String, WeakReference<FreeColGameObject>> hashMap = this.freeColGameObjects;
        synchronized (hashMap) {
            Iterator<FreeColGameObject> iterator = this.getFreeColGameObjectIterator();
            while (iterator.hasNext()) {
                FreeColGameObject fcgo = iterator.next();
                if (fcgo == null) {
                    lb.add(" null-fcgo");
                } else {
                    if (fcgo.isInitialized()) continue;
                    lb.add(" ", fcgo.getId(), "(", StringUtils.lastPart(fcgo.getClass().getName(), "."), ")");
                }
                if (fix) {
                    iterator.remove();
                    result = result.fix();
                    continue;
                }
                result = result.fail();
            }
        }
        if (lb.grew("\n  Uninitialized game ids: ") && fix) {
            lb.add(" (dropped)");
        }
        if ((map = this.getMap()) != null) {
            result = result.combine(map.checkIntegrity(fix, lb));
        }
        List<Player> list = this.players;
        synchronized (list) {
            for (Player p : this.players) {
                result = result.combine(p.checkIntegrity(fix, lb));
            }
        }
        return result;
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public final void setSpecification(Specification specification) {
        this.specification = specification;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Game o = this.copyInCast(other, Game.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.specification = o.getSpecification();
        this.uuid = o.getUUID();
        this.clientUserName = o.getClientUserName();
        this.addPlayers(o.players);
        this.changeMap(this.update(o.getMap(), Map.class, true));
        this.setNationOptions(o.getNationOptions());
        this.unknownEnemy = this.update(o.getUnknownEnemy(), false);
        this.currentPlayer = this.updateRef(o.getCurrentPlayer(), Player.class);
        this.turn = o.getTurn();
        this.spanishSuccession = o.getSpanishSuccession();
        this.initialActiveUnitId = o.getInitialActiveUnitId();
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (xw.validForSave()) {
            xw.writeAttribute(NEXT_ID_TAG, this.nextId);
        } else {
            Player client = xw.getClientPlayer();
            if (client != null) {
                xw.writeAttribute(CLIENT_USER_NAME_TAG, client.getName());
            }
        }
        xw.writeAttribute(UUID_TAG, this.getUUID());
        xw.writeAttribute(TURN_TAG, this.getTurn().getNumber());
        xw.writeAttribute(SPANISH_SUCCESSION_TAG, this.spanishSuccession);
        if (this.initialActiveUnitId != null) {
            xw.writeAttribute(INITIAL_ACTIVE_UNIT_ID, this.initialActiveUnitId);
        }
        if (this.currentPlayer != null) {
            xw.writeAttribute(CURRENT_PLAYER_TAG, this.currentPlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        Map map;
        List<Player> list;
        super.writeChildren(xw);
        if (this.specification != null) {
            list = this.specification;
            synchronized (list) {
                this.specification.toXML(xw);
            }
        }
        for (String string : NameCache.getCitiesOfCibola()) {
            xw.writeStartElement(CIBOLA_TAG);
            xw.writeAttribute("id", string);
            xw.writeEndElement();
        }
        list = this.nationOptions;
        synchronized (list) {
            this.nationOptions.toXML(xw);
        }
        list = this.players;
        synchronized (list) {
            for (Player p : this.players) {
                p.toXML(xw);
            }
        }
        Player unknown = this.getUnknownEnemy();
        if (unknown != null) {
            unknown.toXML(xw);
        }
        if ((map = this.getMap()) != null) {
            map.toXML(xw);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.nextId = xr.getAttribute(NEXT_ID_TAG, -1);
        this.clientUserName = xr.getAttribute(CLIENT_USER_NAME_TAG, null);
        String str = xr.getAttribute(UUID_TAG, null);
        if (str == null) {
            this.uuid = UUID.randomUUID();
        } else {
            try {
                UUID u;
                this.uuid = u = UUID.fromString(str);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.turn = new Turn(xr.getAttribute(TURN_TAG, 1));
        this.spanishSuccession = xr.getAttribute(SPANISH_SUCCESSION_TAG, false);
        this.initialActiveUnitId = xr.getAttribute(INITIAL_ACTIVE_UNIT_ID, null);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        NameCache.clearCitiesOfCibola();
        this.players.clear();
        this.unknownEnemy = null;
        String current = xr.getAttribute(CURRENT_PLAYER_TAG, null);
        super.readChildren(xr);
        this.currentPlayer = xr.lookup(this, current, Player.class);
        for (Colony c : this.getAllColoniesList(null)) {
            c.updateProductionTypes();
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (CIBOLA_TAG.equals(tag)) {
            Object cibola = xr.readId();
            String oldPrefix = "lostCityRumour.cityName";
            if (((String)cibola).startsWith("lostCityRumour.cityName")) {
                cibola = "nameCache." + (String)cibola;
            }
            NameCache.addCityOfCibola((String)cibola);
            xr.closeTag(CIBOLA_TAG);
        } else if ("map".equals(tag)) {
            if (this.specification == null) {
                throw new XMLStreamException("Tried to read " + tag + " with null specification");
            }
            this.changeMap(xr.readFreeColObject(game, Map.class));
        } else if ("nationOptions".equals(tag)) {
            if (this.specification == null) {
                throw new XMLStreamException("Tried to read " + tag + " with null specification");
            }
            this.setNationOptions(new NationOptions(xr, this.specification));
        } else if ("player".equals(tag)) {
            if (this.specification == null) {
                throw new XMLStreamException("Tried to read " + tag + " with null specification");
            }
            Player player = xr.readFreeColObject(game, Player.class);
            if (player.isUnknownEnemy()) {
                this.setUnknownEnemy(player);
            } else {
                this.players.add(player);
            }
        } else if ("freecol-specification".equals(tag)) {
            this.setSpecification(new Specification(xr));
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getId());
    }

    static {
        serverClasses.put(Building.class, ServerBuilding.class);
        serverClasses.put(Colony.class, ServerColony.class);
        serverClasses.put(ColonyTile.class, ServerColonyTile.class);
        serverClasses.put(Europe.class, ServerEurope.class);
        serverClasses.put(Game.class, ServerGame.class);
        serverClasses.put(IndianSettlement.class, ServerIndianSettlement.class);
        serverClasses.put(Region.class, ServerRegion.class);
        serverClasses.put(Player.class, ServerPlayer.class);
        serverClasses.put(Unit.class, ServerUnit.class);
        locationClasses = new HashMap<String, Class<? extends FreeColGameObject>>();
        locationClasses.put("Building", Building.class);
        locationClasses.put("Colony", Colony.class);
        locationClasses.put("ColonyTile", ColonyTile.class);
        locationClasses.put("Europe", Europe.class);
        locationClasses.put("HighSeas", HighSeas.class);
        locationClasses.put("IndianSettlement", IndianSettlement.class);
        locationClasses.put("Map", Map.class);
        locationClasses.put("Tile", Tile.class);
        locationClasses.put("Unit", Unit.class);
    }

    private static enum FcgoState {
        INVALID,
        VALID,
        CONSUMED;

    }

    public static enum LogoutReason {
        DEFEATED,
        LOGIN,
        LOGOUT,
        MAIN_TITLE,
        NEW_GAME,
        QUIT,
        RECONNECT;

    }
}

