/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.ClientObserveRelation;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;

public class CoapObserveRelation
extends ClientObserveRelation {
    private volatile CoapResponse current = null;
    private volatile NotificationListener notificationListener;

    protected CoapObserveRelation(Request request, Endpoint endpoint, ScheduledThreadPoolExecutor executor) {
        super(request, endpoint, executor);
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    @Override
    protected void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled && this.notificationListener != null) {
            this.endpoint.removeNotificationListener(this.notificationListener);
        }
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener = listener;
    }

    protected boolean onResponse(CoapResponse response) {
        boolean isNew = false;
        if (null != response && (isNew = super.onResponse(response.advanced()))) {
            this.current = response;
        }
        return isNew;
    }

    @Override
    public boolean onResponse(Response response) {
        if (super.onResponse(response)) {
            this.current = new CoapResponse(response);
            return true;
        }
        return false;
    }
}

