/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.enterprise.DomainCategory;
import ca.sqlpower.architect.swingui.ArchitectSwingProject;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class SQLTypeTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Logger logger = Logger.getLogger(SQLTypeTreeCellRenderer.class);
    public static final ImageIcon CATEGORY_ICON = new ImageIcon(SQLTypeTreeCellRenderer.class.getResource("icons/category.png"));
    public static final ImageIcon DOMAIN_ICON = new ImageIcon(SQLTypeTreeCellRenderer.class.getResource("icons/domain.png"));
    public static final ImageIcon TYPE_ICON = new ImageIcon(SQLTypeTreeCellRenderer.class.getResource("icons/type.png"));

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof ArchitectSwingProject) {
            this.setIcon(null);
            if (((ArchitectSwingProject)((Object)value)).getSession().isEnterpriseSession()) {
                this.setText("Domains & Data Types");
            } else {
                this.setText("Data Types");
            }
        } else if (value instanceof UserDefinedSQLType) {
            UserDefinedSQLType type = (UserDefinedSQLType)value;
            if (type.getParent() instanceof DomainCategory) {
                this.setIcon(DOMAIN_ICON);
            } else {
                this.setIcon(TYPE_ICON);
            }
            this.setText(type.getName());
        } else if (value instanceof DomainCategory) {
            this.setIcon(CATEGORY_ICON);
            this.setText(((DomainCategory)((Object)value)).getName());
        }
        this.setToolTipText(this.getText());
        return this;
    }
}

