/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerAttacher;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.linux.HasInvalidVariables;
import com.intellij.profiler.linux.KernelVariablesChangeRequiredException;
import com.intellij.profiler.linux.KernelVariablesValidatorKt;
import com.intellij.profiler.linux.ValidationResult;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationType;
import com.intellij.profiler.ultimate.JavaTargetProcess;
import com.intellij.profiler.ultimate.JvmProfilerStarter;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBase;
import com.intellij.profiler.ultimate.async.AsyncProfilerConfigurationExtensionBaseKt;
import com.intellij.profiler.ultimate.async.AsyncProfilerProcess;
import com.intellij.profiler.ultimate.async.UtilsKt;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurable;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerConfigurationStateBase;
import com.intellij.profiler.ultimate.async.configurations.AsyncProfilerStarter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationTypeBase;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationType;", "Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationStateBase;", "<init>", "()V", "isAvailable", "", "isAvailableForTarget", "createConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "state", "createAttacher", "Lcom/intellij/profiler/api/configurations/ProfilerAttacher;", "createStarter", "Lcom/intellij/profiler/ultimate/JvmProfilerStarter;", "Companion", "intellij.profiler.ultimate"})
public abstract class AsyncProfilerConfigurationTypeBase
extends JavaProfilerConfigurationType<AsyncProfilerConfigurationStateBase> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DEFAULT_OPTIONS = "interval=10ms";

    public boolean isAvailable() {
        return SystemInfo.isMac || SystemInfo.isLinux;
    }

    public boolean isAvailableForTarget() {
        return true;
    }

    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull AsyncProfilerConfigurationStateBase state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return (UnnamedConfigurable)new AsyncProfilerConfigurable(state);
    }

    @NotNull
    public ProfilerAttacher createAttacher(@NotNull AsyncProfilerConfigurationStateBase state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new ProfilerAttacher(state){
            final /* synthetic */ AsyncProfilerConfigurationStateBase $state;
            {
                this.$state = $state;
            }

            public Promise<? extends ProfilerProcess<? extends AttachableTargetProcess>> attachTo(AttachableTargetProcess targetProcess, Project project) {
                String string;
                Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                try {
                    string = UtilsKt.getNativeAgentPath$default(this.$state, null, 2, null);
                }
                catch (ExecutionException e) {
                    String string2 = e.getMessage();
                    if (string2 == null) {
                        string2 = UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.unknown.reason", new Object[0]);
                    }
                    String errorDescription = string2;
                    Object[] objectArray = new Object[]{targetProcess.getShortName(), errorDescription};
                    String errorMessage = UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.error", objectArray);
                    Object[] $this$attachTo_u24lambda_u240 = objectArray = new AsyncPromise();
                    boolean bl = false;
                    $this$attachTo_u24lambda_u240.setError(errorMessage);
                    return (Promise)objectArray;
                }
                String agentPath = string;
                string = AsyncProfilerConfigurationExtensionBaseKt.validateAgentPath(agentPath, project, (ProfilerConfigurationState)this.$state);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    return Promises.rejectedPromise((Throwable)((Throwable)((Object)it)));
                }
                ValidationResult kernelVariablesValidationResult = KernelVariablesValidatorKt.checkKernelVariablesOnLinuxOnly(AsyncProfilerConfigurationExtensionBase.Companion.getRequiredKernelVariables());
                if (kernelVariablesValidationResult instanceof HasInvalidVariables) {
                    return Promises.rejectedPromise((Throwable)((Throwable)new KernelVariablesChangeRequiredException((HasInvalidVariables)kernelVariablesValidationResult, project)));
                }
                if (targetProcess instanceof JavaTargetProcess) {
                    String string3 = ((JavaTargetProcess)targetProcess).getJvmArgs();
                    boolean bl = string3 != null ? UtilsKt.containsScheduledDebuggerAgent(string3) : false;
                    if (bl) {
                        Object[] e = new Object[]{((JavaTargetProcess)targetProcess).getPid(), UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.scheduled.debugger", new Object[0])};
                        return Promises.rejectedPromise((Throwable)new ExecutionException(UltimateProfilerBundleKt.profilerMessage("profiler.cant.attach.error", e)));
                    }
                }
                AgentConfiguration configuration = new AgentConfiguration(UtilsKt.tryToHandleSpacesInAgentPath(agentPath), AsyncProfilerConfigurationStateBase.agentOptions$default(this.$state, null, 1, null), targetProcess.getShortName(), project);
                return AsyncProfilerProcess.Companion.attach(targetProcess, (ProfilerConfigurationState)this.$state, configuration, 120000, project);
            }
        };
    }

    @NotNull
    public JvmProfilerStarter createStarter(@NotNull AsyncProfilerConfigurationStateBase state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return AsyncProfilerStarter.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ultimate/async/configurations/AsyncProfilerConfigurationTypeBase$Companion;", "", "<init>", "()V", "DEFAULT_OPTIONS", "", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

